/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.kernel.InputDeviceAdapter;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.coll.ObservableSet;
import cib.util.view.ViewUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class FillPaintComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private Kernel m_krnl;
    private boolean m_valid = true;
    private boolean m_selectSetChanged = false;
    private InputDeviceAdapter m_inputDevice;

    public FillPaintComboBox(Kernel krnl, InputDeviceAdapter inputDevice) {
        this.m_krnl = krnl;
        this.m_inputDevice = inputDevice;
        this.setFocusable(false);
        this.setPreferredSize(new Dimension(this._getDefaultWidth(), this.getPreferredSize().height + 2));
        this.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.setRenderer(new ViewUtilities._LabelComboBoxRenderer(false));
        this.setMaximumRowCount(8);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox c = (JComboBox)e.getSource();
                JLabel item = (JLabel)c.getSelectedItem();
                if (item == null) {
                    return;
                }
                if (FillPaintComboBox.this.m_inputDevice.isEnabled() && SwingUtilities.isEventDispatchThread()) {
                    ObservableSet<Component> selSet = FillPaintComboBox.this.m_krnl.getDatabase().getSelectSet();
                    if (selSet.isEmpty()) {
                        FillPaintComboBox.this.m_inputDevice.fireInterruptingInput("moddeffillpaint \"" + item.getText() + "\"");
                    } else {
                        FillPaintComboBox.this.m_inputDevice.fireInterruptingInput("modfillpaint \"" + item.getText() + "\"");
                    }
                } else if (FillPaintComboBox.this.m_valid) {
                    FillPaintComboBox.this._setDefaultFillPaint();
                } else {
                    FillPaintComboBox.this.m_valid = true;
                }
            }
        };
        this.addActionListener(al);
        final AttributeManager.Listener aml = new AttributeManager.Listener(){
            private static final long serialVersionUID = 1L;

            @Override
            public void defaultAttributesChanged() {
                FillPaintComboBox.this._setDefaultFillPaint();
            }

            @Override
            public void fillPaintAdded(String name) {
                AttributeManager am = AttributeManager.getAttributeManager();
                String locName = am.getLocalizedFillPaintName(name);
                JLabel l = new JLabel(locName);
                l.setText(locName);
                l.setToolTipText(locName);
                l.setIcon(ViewUtilities.createImageIconByFillPaint(am.getFillPaint(name)));
                Collator collator = Collator.getInstance();
                int n = FillPaintComboBox.this.getItemCount();
                int i = 1;
                while (i < n) {
                    JLabel item = (JLabel)FillPaintComboBox.this.getItemAt(i);
                    String itemText = item.getText();
                    if (collator.compare(itemText, locName) > 0) {
                        FillPaintComboBox.this.insertItemAt(l, i);
                        return;
                    }
                    ++i;
                }
                FillPaintComboBox.this.insertItemAt(l, n);
            }

            @Override
            public void fillPaintChanged(String name) {
                AttributeManager am = AttributeManager.getAttributeManager();
                String locName = am.getLocalizedFillPaintName(name);
                int i = 0;
                while (i < FillPaintComboBox.this.getItemCount()) {
                    JLabel l = (JLabel)FillPaintComboBox.this.getItemAt(i);
                    if (l.getText().equals(locName)) {
                        l.setIcon(ViewUtilities.createImageIconByFillPaint(am.getFillPaint(name)));
                        break;
                    }
                    ++i;
                }
            }

            @Override
            public void fillPaintRemoved(String name) {
                AttributeManager am = AttributeManager.getAttributeManager();
                String locName = am.getLocalizedFillPaintName(name);
                int i = 0;
                while (i < FillPaintComboBox.this.getItemCount()) {
                    JLabel l = (JLabel)FillPaintComboBox.this.getItemAt(i);
                    if (l.getText().equals(locName)) {
                        FillPaintComboBox.this.removeItemAt(i);
                        break;
                    }
                    ++i;
                }
            }
        };
        AttributeManager.getAttributeManager().addListener(aml);
        final ObservableSet.Listener<Component> ssl = new ObservableSet.Listener<Component>(){
            private static final long serialVersionUID = 0L;

            @Override
            public void wasAdded(Component o) {
                FillPaintComboBox.this.m_selectSetChanged = true;
            }

            @Override
            public void wasRemoved(Component o) {
                FillPaintComboBox.this.m_selectSetChanged = true;
            }

            @Override
            public void wasChanged(Component o) {
                FillPaintComboBox.this.m_selectSetChanged = true;
            }
        };
        this.m_krnl.getDatabase().getSelectSet().addListener(ssl);
        this.m_krnl.addListener(new Kernel.Listener(){

            @Override
            public void loadStarts() {
                FillPaintComboBox.this.m_krnl.getDatabase().getSelectSet().removeListener(ssl);
                AttributeManager.getAttributeManager().removeListener(aml);
                FillPaintComboBox.this.removeAllItems();
            }

            @Override
            public void loadEnds() {
                FillPaintComboBox.this._init();
                AttributeManager.getAttributeManager().addListener(aml);
                FillPaintComboBox.this.m_krnl.getDatabase().getSelectSet().addListener(ssl);
            }

            @Override
            public void storeStarts() {
                FillPaintComboBox.this.m_krnl.getDatabase().getSelectSet().removeListener(ssl);
                AttributeManager.getAttributeManager().removeListener(aml);
            }

            @Override
            public void storeEnds() {
                FillPaintComboBox.this.m_krnl.getDatabase().getSelectSet().addListener(ssl);
                AttributeManager.getAttributeManager().addListener(aml);
            }

            @Override
            public void cmdEnds(String name) {
                if (FillPaintComboBox.this.m_selectSetChanged) {
                    boolean status = FillPaintComboBox.this.m_inputDevice.isEnabled();
                    FillPaintComboBox.this.m_inputDevice.setEnabled(false);
                    FillPaintComboBox.this._update();
                    FillPaintComboBox.this.m_inputDevice.setEnabled(status);
                    FillPaintComboBox.this.m_selectSetChanged = false;
                }
            }
        });
        this._init();
    }

    private void _update() {
        ObservableSet<Component> selSet = this.m_krnl.getDatabase().getSelectSet();
        Iterator iter = selSet.iterator();
        String name = null;
        if (!iter.hasNext()) {
            this._setDefaultFillPaint();
        } else {
            Component comp = (Component)iter.next();
            Attributes attr = comp.getAttributes();
            if (attr != null) {
                name = attr.getFillPaint();
            }
            while (name != null && iter.hasNext()) {
                comp = (Component)iter.next();
                attr = comp.getAttributes();
                if (attr != null && name.equals(attr.getFillPaint())) continue;
                name = null;
            }
            this.m_valid = false;
            if (name == null) {
                this.m_inputDevice.setEnabled(false);
                this.setSelectedItem(null);
                this.m_inputDevice.setEnabled(true);
                this.repaint();
            } else {
                AttributeManager atm = AttributeManager.getAttributeManager();
                String locName = atm.getLocalizedFillPaintName(name);
                int i = 0;
                while (i < this.getItemCount()) {
                    JLabel l = (JLabel)this.getItemAt(i);
                    if (l.getText().equals(locName)) {
                        this.m_inputDevice.setEnabled(false);
                        this.setSelectedIndex(i);
                        this.m_inputDevice.setEnabled(true);
                        this.repaint();
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private void _init() {
        AttributeManager am = AttributeManager.getAttributeManager();
        this.removeAllItems();
        HashMap<String, String> localNamesMap = new HashMap<String, String>();
        HashSet<String> names = new HashSet<String>(am.getFillPaints());
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            localNamesMap.put(am.getLocalizedFillPaintName(name), name);
        }
        ArrayList locNames = new ArrayList(localNamesMap.keySet());
        Collections.sort(locNames, Collator.getInstance());
        String locDefault = Messages.getString("db.att.Attribute.FillPaint.Name.DEFAULT");
        locNames.add(0, locDefault);
        localNamesMap.put(locDefault, "DEFAULT");
        for (String locName : locNames) {
            String name = (String)localNamesMap.get(locName);
            JLabel label = new JLabel();
            label.setText(locName);
            label.setToolTipText(locName);
            label.setIcon(ViewUtilities.createImageIconByFillPaint(am.getFillPaint(name)));
            this.addItem(label);
        }
        ObservableSet<Component> selSet = this.m_krnl.getDatabase().getSelectSet();
        if (selSet.isEmpty()) {
            this._setDefaultFillPaint();
        } else {
            Iterator iter = selSet.iterator();
            String att = null;
            Component comp = (Component)iter.next();
            Attributes attr = comp.getAttributes();
            if (attr != null) {
                att = attr.getFillPaint();
            }
            while (att != null && iter.hasNext()) {
                comp = (Component)iter.next();
                attr = comp.getAttributes();
                if (attr != null && att.equals(attr.getFillPaint())) continue;
                att = null;
            }
            if (att == null) {
                this.m_inputDevice.setEnabled(false);
                this.setSelectedItem(null);
                this.m_inputDevice.setEnabled(true);
                this.repaint();
            } else {
                int i = 0;
                while (i < this.getItemCount()) {
                    JLabel l = (JLabel)this.getItemAt(i);
                    if (l.getText().equals(att)) {
                        this.m_inputDevice.setEnabled(false);
                        this.setSelectedIndex(i);
                        this.m_inputDevice.setEnabled(true);
                        this.repaint();
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private void _setDefaultFillPaint() {
        AttributeManager atm = AttributeManager.getAttributeManager();
        String name = atm.getDefaultAttributes().getFillPaint();
        String locName = atm.getLocalizedFillPaintName(name);
        int i = 0;
        while (i < this.getItemCount()) {
            JLabel l = (JLabel)this.getItemAt(i);
            if (l.getText().equals(locName)) {
                this.m_inputDevice.setEnabled(false);
                this.setSelectedIndex(i);
                this.m_inputDevice.setEnabled(true);
                this.repaint();
                break;
            }
            ++i;
        }
    }

    private int _getDefaultWidth() {
        JComboBox<JLabel> box = new JComboBox<JLabel>();
        JLabel label = new JLabel();
        label.setIcon(ViewUtilities.createImageIconByFillPaint(Color.BLACK));
        label.setText("DEFAULT_");
        box.addItem(label);
        box.setRenderer(new ViewUtilities._LabelComboBoxRenderer(false));
        box.revalidate();
        return box.getPreferredSize().width;
    }
}

