/*
 * Decompiled with CFR 0.152.
 */
package cib.util.coll;

import cib.util.NameSpace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class _NamedElementsSet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 0L;
    private Set<E> m_set;
    private NameSpace m_nameSpace;
    private transient Map<E, String> t_generatedNames;

    protected _NamedElementsSet() {
    }

    protected _NamedElementsSet(Set<E> set, NameSpace nameSpace) {
        this.t_generatedNames = new HashMap<E, String>();
        if (set == null || nameSpace == null) {
            throw new IllegalArgumentException();
        }
        this.m_set = set;
        this.m_nameSpace = nameSpace;
        for (E e : set) {
            this.assignName(e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.t_generatedNames = new HashMap<E, String>();
        in.defaultReadObject();
    }

    @Override
    public boolean add(E e) {
        if (!this.m_set.add(e)) {
            return false;
        }
        this.assignName(e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (!this.m_set.addAll(c)) {
            return false;
        }
        for (E e : c) {
            this.assignName(e);
        }
        return true;
    }

    @Override
    public void clear() {
        for (E e : this.m_set) {
            this.m_nameSpace.remove(e);
        }
        this.m_set.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.m_set.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.m_set.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.m_set.equals(o);
    }

    @Override
    public int hashCode() {
        return this.m_set.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.m_set.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.m_set.iterator();
    }

    @Override
    public boolean remove(Object o) {
        if (!this.m_set.remove(o)) {
            return false;
        }
        this.m_nameSpace.remove(o);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (!this.m_set.removeAll(c)) {
            return false;
        }
        for (Object object : c) {
            this.m_nameSpace.remove(object);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        HashSet<E> old = new HashSet<E>(this.m_set);
        old.removeAll(c);
        for (Object e : old) {
            this.m_nameSpace.remove(e);
        }
        return this.m_set.retainAll(c);
    }

    @Override
    public int size() {
        return this.m_set.size();
    }

    @Override
    public Object[] toArray() {
        return this.m_set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.m_set.toArray(a);
    }

    private void assignName(E e) {
        String name;
        if (this.m_nameSpace.containsObject(e)) {
            return;
        }
        if (this.t_generatedNames.containsKey(e) && !this.m_nameSpace.containsName(name = this.t_generatedNames.get(e))) {
            this.m_nameSpace.put(e, name);
            return;
        }
        name = this.m_nameSpace.generateName();
        this.m_nameSpace.put(e, name);
        this.t_generatedNames.put(e, name);
    }

    public String toString() {
        return this.m_set.toString();
    }
}

