/*
 * Decompiled with CFR 0.152.
 */
package cib.util.dxf;

import cib.util.dxf.Attributes;
import cib.util.dxf.ContentHandler;
import cib.util.dxf.DXFReader;
import cib.util.dxf.interpreter.ParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class DXFPrinter {
    private static String s_indent = "";

    private static void incIndent() {
        s_indent = String.valueOf(s_indent) + "    ";
    }

    private static void decIndent() {
        s_indent = s_indent.substring(4);
    }

    private static String getIndent() {
        return s_indent;
    }

    public static void main(String[] args) throws ParseException {
        if (args.length != 1) {
            System.out.println("Usage: DXFPrinter filename");
            System.exit(0);
        }
        DXFReader myDXFReader = new DXFReader();
        myDXFReader.addContentHandler(new ContentHandler(){

            @Override
            public void startSection(String section) {
                System.out.println("SECTION: " + section);
                DXFPrinter.incIndent();
            }

            @Override
            public void endSection(String section) {
                DXFPrinter.decIndent();
            }

            @Override
            public void startTable(String name, Attributes atts) {
                System.out.println(String.valueOf(DXFPrinter.getIndent()) + name + ": lines " + atts.firstParsedLine() + "-" + atts.lastParsedLine());
                DXFPrinter.incIndent();
                int n = atts.size();
                int i = 0;
                while (i < n) {
                    System.out.println(String.valueOf(DXFPrinter.getIndent()) + (Object)((Object)atts.getGroupCodeAt(i)) + ": " + atts.getValueAt(i));
                    ++i;
                }
            }

            @Override
            public void endTable(String name) {
                DXFPrinter.decIndent();
            }

            @Override
            public void startBlock(String name, Attributes atts) {
                System.out.println(String.valueOf(DXFPrinter.getIndent()) + name + ": lines " + atts.firstParsedLine() + "-" + atts.lastParsedLine());
                DXFPrinter.incIndent();
                int n = atts.size();
                int i = 0;
                while (i < n) {
                    System.out.println(String.valueOf(DXFPrinter.getIndent()) + (Object)((Object)atts.getGroupCodeAt(i)) + ": " + atts.getValueAt(i));
                    ++i;
                }
            }

            @Override
            public void endBlock(String name, Attributes atts) {
                DXFPrinter.decIndent();
            }

            @Override
            public void startElement(String name, Attributes atts) {
                System.out.println(String.valueOf(DXFPrinter.getIndent()) + name + ": lines " + atts.firstParsedLine() + "-" + atts.lastParsedLine());
                DXFPrinter.incIndent();
                int n = atts.size();
                int i = 0;
                while (i < n) {
                    System.out.println(String.valueOf(DXFPrinter.getIndent()) + (Object)((Object)atts.getGroupCodeAt(i)) + ": " + atts.getValueAt(i));
                    ++i;
                }
            }

            @Override
            public void endElement(String name) {
                DXFPrinter.decIndent();
            }
        });
        FileInputStream myStream = null;
        InputStreamReader myReader = null;
        try {
            System.out.println("DXFPrinter: parsing file " + args[0]);
            myStream = new FileInputStream(new File(args[0]));
            myReader = new InputStreamReader((InputStream)myStream, "ISO-8859-1");
        }
        catch (IOException e) {
            System.out.println(e);
            System.exit(1);
        }
        myDXFReader.parse(myReader);
    }
}

