/*
 * Decompiled with CFR 0.152.
 */
package cib.util.geo;

import cib.util.CoordSpace;
import cib.util.geo.NoIntersectionException;
import cib.util.geo.NullVectorException;
import cib.util.geo.RewindablePathIterator;
import cib.util.geo.Vector2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;

public class Geo2D {
    private static double m_eps = 1.0E-6;
    private static double m_epsSqr = m_eps * m_eps;
    public static final int OUTSIDE = 0;
    public static final int INSIDE = -1;
    public static final int CLIPPED = 1;

    public static double getEps() {
        return m_eps;
    }

    public static double getEpsSqr() {
        return m_epsSqr;
    }

    public static void setEps(double eps) {
        m_eps = eps;
        m_epsSqr = eps * eps;
    }

    @Deprecated
    protected static double _round(double x) {
        double ulp = Math.ulp(x);
        double exp = Math.log10(ulp);
        double expRounded = Math.ceil(exp) + 1.0;
        double divisor = Math.pow(10.0, expRounded);
        System.out.println("x=" + x + " ulp=" + ulp + " exp=" + exp + " expRounded=" + expRounded + " divisor=" + divisor + " result=" + (x - Math.IEEEremainder(x, divisor)));
        return x - Math.IEEEremainder(x, divisor);
    }

    @Deprecated
    public static String roundToString(double x) {
        return Geo2D.formatCoordinate(x);
    }

    @Deprecated
    public static String round(double x) {
        return Geo2D.formatCoordinate(x);
    }

    public static String formatCoordinate(double x) {
        if (Double.isNaN(x)) {
            return "NaN";
        }
        CoordSpace cs = CoordSpace.getCoordSpace();
        return cs.formatCoordinate(x);
    }

    public static String formatDegrees(double degrees) {
        if (Double.isNaN(degrees)) {
            return "NaN";
        }
        DecimalFormat nf = new DecimalFormat();
        nf.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        nf.applyLocalizedPattern("0.0##########");
        return nf.format(degrees);
    }

    public static String formatDouble(double value) {
        return Double.toString(value);
    }

    public static double length(Vector2D vec) {
        return Math.sqrt(vec.getX() * vec.getX() + vec.getY() * vec.getY());
    }

    public static double length(Line2D seg) {
        double dx = seg.getX2() - seg.getX1();
        double dy = seg.getY2() - seg.getY1();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double length(Ellipse2D ell) {
        return Geo2D.length(ell.getPathIterator(null, m_eps));
    }

    public static double length(Arc2D arc) {
        return Geo2D.length(arc.getPathIterator(null, m_eps));
    }

    public static double length(QuadCurve2D qad) {
        return Geo2D.length(qad.getPathIterator(null, m_eps));
    }

    public static double length(CubicCurve2D cub) {
        return Geo2D.length(cub.getPathIterator(null, m_eps));
    }

    private static double length(PathIterator pit) {
        double lenSq = 0.0;
        Line2D.Double lineSeg = new Line2D.Double();
        double[] mvto = new double[2];
        double[] last = new double[2];
        double[] crds = new double[2];
        while (!pit.isDone()) {
            int typ = pit.currentSegment(crds);
            switch (typ) {
                case 0: {
                    mvto[0] = crds[0];
                    mvto[1] = crds[1];
                    last[0] = crds[0];
                    last[1] = crds[1];
                    break;
                }
                case 1: {
                    ((Line2D)lineSeg).setLine(last[0], last[1], crds[0], crds[1]);
                    last[0] = crds[0];
                    last[1] = crds[1];
                    double dx = ((Line2D)lineSeg).getX2() - ((Line2D)lineSeg).getX1();
                    double dy = ((Line2D)lineSeg).getY2() - ((Line2D)lineSeg).getY1();
                    lenSq += dx * dx + dy * dy;
                    break;
                }
                case 4: {
                    ((Line2D)lineSeg).setLine(last[0], last[1], mvto[0], mvto[1]);
                    double dx = ((Line2D)lineSeg).getX2() - ((Line2D)lineSeg).getX1();
                    double dy = ((Line2D)lineSeg).getY2() - ((Line2D)lineSeg).getY1();
                    lenSq += dx * dx + dy * dy;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a flattening path iterator");
                }
            }
            pit.next();
        }
        return Math.sqrt(lenSq);
    }

    public static double area(Line2D seg) {
        double dx = seg.getX2() - seg.getX1();
        double dy = 0.5 * (seg.getY1() + seg.getY2());
        return dx * dy;
    }

    public static double area(Ellipse2D ell) {
        return Geo2D.area(ell.getPathIterator(null, m_eps));
    }

    public static double area(Arc2D arc) {
        return Geo2D.area(arc.getPathIterator(null, m_eps));
    }

    public static double area(QuadCurve2D qad) {
        return Geo2D.area(qad.getPathIterator(null, m_eps));
    }

    public static double area(CubicCurve2D cub) {
        return Geo2D.area(cub.getPathIterator(null, m_eps));
    }

    public static double area(PathIterator pit) throws IllegalArgumentException {
        double area = 0.0;
        Line2D.Double lineSeg = new Line2D.Double();
        double[] mvto = new double[2];
        double[] last = new double[2];
        double[] crds = new double[2];
        while (!pit.isDone()) {
            int typ = pit.currentSegment(crds);
            switch (typ) {
                case 0: {
                    mvto[0] = crds[0];
                    mvto[1] = crds[1];
                    last[0] = crds[0];
                    last[1] = crds[1];
                    break;
                }
                case 1: {
                    ((Line2D)lineSeg).setLine(last[0], last[1], crds[0], crds[1]);
                    last[0] = crds[0];
                    last[1] = crds[1];
                    double dx = ((Line2D)lineSeg).getX2() - ((Line2D)lineSeg).getX1();
                    double dy = 0.5 * (((Line2D)lineSeg).getY1() + ((Line2D)lineSeg).getY2());
                    area += dx * dy;
                    break;
                }
                case 4: {
                    ((Line2D)lineSeg).setLine(last[0], last[1], mvto[0], mvto[1]);
                    double dx = ((Line2D)lineSeg).getX2() - ((Line2D)lineSeg).getX1();
                    double dy = 0.5 * (((Line2D)lineSeg).getY1() + ((Line2D)lineSeg).getY2());
                    area += dx * dy;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a flattening path iterator");
                }
            }
            pit.next();
        }
        return area;
    }

    public static double distance(Point2D pnt1, Point2D pnt2) {
        return pnt1.distance(pnt2);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double distance(Point2D pnt, Line2D seg) {
        return Math.sqrt(Math.abs(seg.ptSegDistSq(pnt)));
    }

    public static double distance(Point2D pnt, Line2D any, boolean unbounded) {
        return unbounded ? Math.sqrt(Math.abs(any.ptLineDistSq(pnt))) : Math.sqrt(Math.abs(any.ptSegDistSq(pnt)));
    }

    public static double distance(Point2D pnt, Ellipse2D ell) {
        if (Math.abs(ell.getWidth() - ell.getHeight()) < m_eps) {
            double r = 0.5 * ell.getWidth();
            return Math.abs(Geo2D.distance(pnt.getX(), pnt.getY(), ell.getCenterX(), ell.getCenterY()) - r);
        }
        return Geo2D._distance(pnt, ell.getPathIterator(null, m_eps));
    }

    public static double distance(Point2D pnt, Arc2D arc) {
        if (Math.abs(arc.getWidth() - arc.getHeight()) < m_eps) {
            double r = 0.5 * arc.getWidth();
            double distCircle = Math.abs(Geo2D.distance(pnt.getX(), pnt.getY(), arc.getCenterX(), arc.getCenterY()) - r);
            Vector2D cpPnt = new Vector2D(arc.getCenterX(), arc.getCenterY(), pnt.getX(), pnt.getY());
            if (Geo2D.isNull(cpPnt)) {
                return distCircle;
            }
            double angle = -Math.toDegrees(Math.atan2(cpPnt.y, cpPnt.x));
            if (arc.containsAngle(angle)) {
                return distCircle;
            }
            return Math.min(Geo2D.distance(arc.getStartPoint(), pnt), Geo2D.distance(arc.getEndPoint(), pnt));
        }
        return Geo2D._distance(pnt, arc.getPathIterator(null, m_eps));
    }

    public static double distance(Point2D pnt, QuadCurve2D qad) {
        return Geo2D._distance(pnt, qad.getPathIterator(null, m_eps));
    }

    public static double distance(Point2D pnt, CubicCurve2D cub) {
        return Geo2D._distance(pnt, cub.getPathIterator(null, m_eps));
    }

    private static double _distance(Point2D pnt, PathIterator pit) {
        if (pit.isDone()) {
            return Double.NaN;
        }
        double distSq = Double.MAX_VALUE;
        Line2D.Double lineSeg = new Line2D.Double();
        double[] mvto = new double[2];
        double[] last = new double[2];
        double[] crds = new double[2];
        while (!pit.isDone()) {
            int typ = pit.currentSegment(crds);
            switch (typ) {
                case 0: {
                    mvto[0] = crds[0];
                    mvto[1] = crds[1];
                    last[0] = crds[0];
                    last[1] = crds[1];
                    break;
                }
                case 1: {
                    ((Line2D)lineSeg).setLine(last[0], last[1], crds[0], crds[1]);
                    last[0] = crds[0];
                    last[1] = crds[1];
                    double _distSq = lineSeg.ptSegDistSq(pnt);
                    if (!(_distSq < distSq)) break;
                    distSq = _distSq;
                    break;
                }
                case 4: {
                    ((Line2D)lineSeg).setLine(last[0], last[1], mvto[0], mvto[1]);
                    double _distSq = lineSeg.ptSegDistSq(pnt);
                    if (!(_distSq < distSq)) break;
                    distSq = _distSq;
                    break;
                }
                default: {
                    throw new Error("Not a flattening path iterator");
                }
            }
            pit.next();
        }
        return Math.sqrt(distSq);
    }

    public static Point2D projection(Point2D pnt, Line2D lin, Point2D pntDst) {
        if (pntDst == null) {
            pntDst = new Point2D.Double();
        }
        Vector2D linVec = new Vector2D();
        linVec.setLocation(lin.getX2() - lin.getX1(), lin.getY2() - lin.getY1());
        try {
            linVec.normalize();
        }
        catch (NullVectorException e) {
            pntDst.setLocation(lin.getP1());
            return pntDst;
        }
        Vector2D pntVec = new Vector2D();
        pntVec.setLocation(lin.getP1(), pnt);
        double scale = linVec.getScalarProduct(pntVec);
        linVec.scaleBy(scale).add(lin.getP1());
        pntDst.setLocation(linVec);
        return pntDst;
    }

    public static Line2D projection(Line2D seg, Line2D lin, Line2D linDst) {
        if (linDst == null) {
            linDst = new Line2D.Double();
        }
        Point2D.Double pnt1 = new Point2D.Double();
        Geo2D.projection(seg.getP1(), lin, pnt1);
        Point2D.Double pnt2 = new Point2D.Double();
        Geo2D.projection(seg.getP2(), lin, pnt2);
        linDst.setLine(pnt1, pnt2);
        return linDst;
    }

    public static Point2D intersection(Line2D seg, Line2D seg2, Point2D pntDst) throws NoIntersectionException {
        return Geo2D.intersection(seg, false, seg2, false, pntDst);
    }

    public static Point2D intersection(Line2D seg, Line2D any, boolean unbounded, Point2D pntDst) throws NoIntersectionException {
        return Geo2D.intersection(seg, false, any, unbounded, pntDst);
    }

    public static Iterator<Point2D> intersection(Line2D seg, Ellipse2D ell) throws NoIntersectionException {
        return Geo2D.intersection(seg, false, ell);
    }

    public static Iterator<Point2D> intersection(Line2D seg, Arc2D arc) throws NoIntersectionException {
        return Geo2D.intersection(seg, false, arc);
    }

    public static Iterator<Point2D> intersection(Line2D seg, QuadCurve2D qad) throws NoIntersectionException {
        return Geo2D.intersection(seg, Geo2D._toCubicCurve(qad, new CubicCurve2D.Double()));
    }

    public static Iterator<Point2D> intersection(Line2D seg, CubicCurve2D cub) throws NoIntersectionException {
        return Geo2D.intersection(Geo2D._toCubicCurve(seg, new CubicCurve2D.Double()), cub);
    }

    public static Point2D intersection(Line2D any, boolean unbounded, Line2D any2, boolean unbounded2, Point2D pntDst) throws NoIntersectionException {
        Vector2D v2;
        Vector2D v1;
        double angle;
        double vy2;
        double vy1;
        if (pntDst == null) {
            pntDst = new Point2D.Double();
        }
        if (!unbounded && !unbounded2) {
            Geo2D._boundsCheck(any, any2);
        }
        boolean isNull = Geo2D.isNull(any);
        boolean isNull2 = Geo2D.isNull(any2);
        if (isNull && isNull2) {
            Point2D.Double p2;
            Point2D.Double p = new Point2D.Double(0.5 * (any.getX1() + any.getX2()), 0.5 * (any.getY1() + any.getY2()));
            if (Geo2D.equality(p, p2 = new Point2D.Double(0.5 * (any2.getX1() + any2.getX2()), 0.5 * (any2.getY1() + any2.getY2())))) {
                pntDst.setLocation(0.5 * (((Point2D)p).getX() + ((Point2D)p2).getX()), 0.5 * (((Point2D)p).getY() + ((Point2D)p2).getY()));
                return pntDst;
            }
        } else {
            if (isNull) {
                Point2D.Double p = new Point2D.Double(0.5 * (any.getX1() + any.getX2()), 0.5 * (any.getY1() + any.getY2()));
                if (Geo2D.containment(any2, unbounded2, p)) {
                    pntDst.setLocation(p);
                    return pntDst;
                }
                throw new NoIntersectionException();
            }
            if (isNull2) {
                Point2D.Double p2 = new Point2D.Double(0.5 * (any2.getX1() + any2.getX2()), 0.5 * (any2.getY1() + any2.getY2()));
                if (Geo2D.containment(any, unbounded, p2)) {
                    pntDst.setLocation(p2);
                    return pntDst;
                }
                throw new NoIntersectionException();
            }
        }
        double vx1 = any.getX2() - any.getX1();
        double a1 = vy1 = any.getY2() - any.getY1();
        double b1 = -vx1;
        double c1 = vx1 * any.getY1() - vy1 * any.getX1();
        double vx2 = any2.getX2() - any2.getX1();
        double a2 = vy2 = any2.getY2() - any2.getY1();
        double b2 = -vx2;
        double c2 = vx2 * any2.getY1() - vy2 * any2.getX1();
        double d = a1 * b2 - a2 * b1;
        if (Math.abs(d) <= m_eps && ((angle = (v1 = new Vector2D(any.getX1(), any.getY1(), any.getX2(), any.getY2())).getAngleSmallest(v2 = new Vector2D(any2.getX1(), any2.getY1(), any2.getX2(), any2.getY2()))) < Math.toRadians(0.001) || angle > Math.toRadians(179.999))) {
            throw new NoIntersectionException("Lines are parallel");
        }
        double dx = b1 * c2 - b2 * c1;
        double dy = c1 * a2 - c2 * a1;
        pntDst.setLocation(dx / d, dy / d);
        if (!unbounded && !Geo2D.containment(any, pntDst)) {
            throw new NoIntersectionException("1st line segment doesn't contain intersection point");
        }
        if (!unbounded2 && !Geo2D.containment(any2, pntDst)) {
            throw new NoIntersectionException("2nd line segment doesn't contain intersection point");
        }
        return pntDst;
    }

    public static Iterator<Point2D> intersection(Line2D any, boolean unbounded, Ellipse2D ell) throws NoIntersectionException {
        double df = Math.abs(ell.getWidth() - ell.getHeight());
        if (df > Geo2D.getEps()) {
            return Geo2D.intersection(ell.getPathIterator(null), any, unbounded);
        }
        try {
            int nPnts;
            double cx = ell.getCenterX();
            double cy = ell.getCenterY();
            double r = 0.5 * ell.getWidth();
            double l1x = any.getX1() - cx;
            double l1y = any.getY1() - cy;
            double l2x = any.getX2() - cx;
            double l2y = any.getY2() - cy;
            Vector2D u = new Vector2D(l2x - l1x, l2y - l1y);
            u.normalize();
            double r1u = l1x * u.x + l1y * u.y;
            double uu = u.x * u.x + u.y * u.y;
            double r1r1 = l1x * l1x + l1y * l1y;
            double radicand = r1u * r1u - r1r1 * uu + r * r * uu;
            if (radicand < -Geo2D.getEps()) {
                throw new NoIntersectionException();
            }
            double sqrt = radicand <= Geo2D.getEps() ? 0.0 : Math.sqrt(radicand);
            double t1 = -r1u / uu;
            double t2 = sqrt / uu;
            double lambda1 = t1 + t2;
            double lambda2 = t1 - t2;
            Point2D[] pnts = new Point2D[]{new Point2D.Double(l1x + lambda1 * u.x + cx, l1y + lambda1 * u.y + cy), new Point2D.Double(l1x + lambda2 * u.x + cx, l1y + lambda2 * u.y + cy)};
            int n = nPnts = Geo2D.equality(pnts[0], pnts[1]) ? 1 : 2;
            if (!unbounded) {
                int i = 0;
                while (i < nPnts) {
                    if (!Geo2D.containment(any, pnts[i])) {
                        pnts[i] = null;
                    }
                    ++i;
                }
            }
            return new _PointIterator(pnts, nPnts);
        }
        catch (NullVectorException e) {
            throw new NoIntersectionException();
        }
    }

    public static Iterator<Point2D> intersection(Line2D any, boolean unbounded, Arc2D arc) throws NoIntersectionException {
        double df = Math.abs(arc.getWidth() - arc.getHeight());
        if (df > Geo2D.getEps()) {
            return Geo2D.intersection(arc.getPathIterator(null), any, unbounded);
        }
        Ellipse2D.Double cir = new Ellipse2D.Double();
        double cx = arc.getCenterX();
        double cy = arc.getCenterY();
        double r = 0.5 * arc.getWidth();
        cir.setFrameFromCenter(cx, cy, cx + r, cy + r);
        Iterator<Point2D> it = Geo2D.intersection(any, unbounded, cir);
        Point2D[] pnts = new Point2D[2];
        int nPnts = 0;
        while (it.hasNext()) {
            Point2D p = it.next();
            if (!Geo2D.containment(arc, p)) continue;
            pnts[nPnts++] = p;
        }
        if (nPnts == 0) {
            throw new NoIntersectionException();
        }
        return new _PointIterator(pnts, nPnts);
    }

    public static Iterator<Point2D> intersection(Line2D any, boolean unbounded, QuadCurve2D qad) throws NoIntersectionException {
        return Geo2D.intersection(any, unbounded, Geo2D._toCubicCurve(qad, new CubicCurve2D.Double()));
    }

    public static Iterator<Point2D> intersection(Line2D any, boolean unbounded, CubicCurve2D cub) throws NoIntersectionException {
        if (!unbounded) {
            return Geo2D.intersection(Geo2D._toCubicCurve(any, new CubicCurve2D.Double()), Geo2D._toCubicCurve(cub, new CubicCurve2D.Double()));
        }
        Point2D[] pnts = new Point2D.Double[3];
        int nPnts = Geo2D._intersection(any, cub, pnts);
        if (nPnts == 0) {
            throw new NoIntersectionException();
        }
        return new _PointIterator(pnts, nPnts);
    }

    private static int _intersection(Line2D lin, CubicCurve2D cub, Point2D[] pnts) {
        return Geo2D.__intersection(lin, cub, pnts, 0);
    }

    private static int __intersection(Line2D lin, CubicCurve2D cub, Point2D[] pnts, int nPnts) {
        if (nPnts >= 3) {
            return nPnts;
        }
        if (Geo2D._relativePosition(lin, cub) != 0) {
            return nPnts;
        }
        if (cub.getFlatnessSq() < m_epsSqr) {
            Line2D.Double lseg = new Line2D.Double(cub.getP1(), cub.getP2());
            Point2D.Double p = new Point2D.Double();
            try {
                Geo2D.intersection(lseg, lin, true, p);
                int i = 0;
                while (i < nPnts) {
                    if (Geo2D.equality(pnts[i], p)) {
                        return nPnts;
                    }
                    ++i;
                }
                pnts[nPnts++] = p;
            }
            catch (NoIntersectionException noIntersectionException) {}
        } else {
            CubicCurve2D.Double left = new CubicCurve2D.Double();
            CubicCurve2D.Double right = new CubicCurve2D.Double();
            cub.subdivide(left, right);
            nPnts = Geo2D.__intersection(lin, (CubicCurve2D)left, pnts, nPnts);
            nPnts = Geo2D.__intersection(lin, (CubicCurve2D)right, pnts, nPnts);
        }
        return nPnts;
    }

    private static int _relativePosition(Line2D lin, CubicCurve2D cub) {
        if (Geo2D.isNull(lin)) {
            double y;
            double x;
            Rectangle2D rct = cub.getBounds2D();
            return rct.intersects(x = lin.getX1() - 0.5 * m_eps, y = lin.getY1() - 0.5 * m_eps, m_eps, m_eps) ? 0 : -1;
        }
        Vector2D vec1Left = new Vector2D(lin.getP1(), lin.getP2());
        vec1Left.left();
        vec1Left.normalize();
        Vector2D vec = new Vector2D();
        vec.setLocation(lin.getP1(), cub.getP1());
        int ii = Geo2D._relativePosition(vec1Left, vec);
        if (ii == 0) {
            return 0;
        }
        vec.setLocation(lin.getP1(), cub.getP2());
        int i = Geo2D._relativePosition(vec1Left, vec);
        if (i == 0 || i + ii == 0) {
            return 0;
        }
        vec.setLocation(lin.getP1(), cub.getCtrlP1());
        i = Geo2D._relativePosition(vec1Left, vec);
        if (i == 0 || i + ii == 0) {
            return 0;
        }
        vec.setLocation(lin.getP1(), cub.getCtrlP2());
        i = Geo2D._relativePosition(vec1Left, vec);
        if (i == 0 || i + ii == 0) {
            return 0;
        }
        return ii;
    }

    private static int _relativePosition(Vector2D vec1Left, Vector2D vec1Pnt) {
        double signedDist = vec1Left.getScalarProduct(vec1Pnt);
        if (signedDist < -m_eps) {
            return -1;
        }
        if (signedDist > m_eps) {
            return 1;
        }
        return 0;
    }

    public static Iterator<Point2D> intersection(Ellipse2D ell, Ellipse2D ell2) throws NoIntersectionException {
        if (Math.abs(ell.getWidth() - ell.getHeight()) < m_eps && Math.abs(ell2.getWidth() - ell2.getHeight()) < m_eps) {
            double c1x = ell.getCenterX();
            double c1y = ell.getCenterY();
            double c2x = ell2.getCenterX();
            double c2y = ell2.getCenterY();
            double m = Point2D.distance(c1x, c1y, c2x, c2y);
            double r1 = 0.5 * ell.getWidth();
            double r2 = 0.5 * ell2.getWidth();
            if (Geo2D.isNull(m) || Geo2D.isNull(r1) || Geo2D.isNull(r2)) {
                throw new NoIntersectionException();
            }
            double u = 0.5 * m + (r1 * r1 - r2 * r2) / (m + m);
            double radicand = r1 * r1 - u * u;
            if (radicand < -Geo2D.getEps()) {
                throw new NoIntersectionException();
            }
            double v = radicand > Geo2D.getEps() ? Math.sqrt(radicand) : 0.0;
            Vector2D vc1c2 = new Vector2D(c1x, c1y, c2x, c2y);
            vc1c2.normalize();
            Vector2D vPerp = new Vector2D(vc1c2).left();
            vPerp.scaleBy(v);
            vc1c2.scaleBy(u);
            return v < m_eps ? new _PointIterator(new Point2D[]{new Point2D.Double(c1x + vc1c2.x, c1y + vc1c2.y)}, 1) : new _PointIterator(new Point2D[]{new Point2D.Double(c1x + vc1c2.x + vPerp.x, c1y + vc1c2.y + vPerp.y), new Point2D.Double(c1x + vc1c2.x - vPerp.x, c1y + vc1c2.y - vPerp.y)}, 2);
        }
        return Geo2D.intersection(ell.getPathIterator(null), ell2.getPathIterator(null));
    }

    public static Iterator<Point2D> intersection(Ellipse2D ell, Arc2D arc) throws NoIntersectionException {
        if (Math.abs(ell.getWidth() - ell.getHeight()) < m_eps && Math.abs(arc.getWidth() - arc.getHeight()) < m_eps) {
            Ellipse2D.Double cir = new Ellipse2D.Double(arc.getMinX(), arc.getMinY(), arc.getWidth(), arc.getHeight());
            Point2D[] pnts = new Point2D[2];
            int nPnts = 0;
            Iterator<Point2D> it = Geo2D.intersection(ell, (Ellipse2D)cir);
            while (it.hasNext()) {
                Point2D p = it.next();
                if (!Geo2D.containment(arc, p)) continue;
                pnts[nPnts++] = p;
            }
            return new _PointIterator(pnts, nPnts);
        }
        return Geo2D.intersection(ell.getPathIterator(null), arc.getPathIterator(null));
    }

    public static Iterator<Point2D> intersection(Ellipse2D ell, QuadCurve2D qad) throws NoIntersectionException {
        return Geo2D.intersection(ell.getPathIterator(null), qad.getPathIterator(null));
    }

    public static Iterator<Point2D> intersection(Ellipse2D ell, CubicCurve2D cub) throws NoIntersectionException {
        return Geo2D.intersection(ell.getPathIterator(null), cub.getPathIterator(null));
    }

    public static Iterator<Point2D> intersection(Arc2D arc, Arc2D arc2) throws NoIntersectionException {
        if (Math.abs(arc.getWidth() - arc.getHeight()) < m_eps && Math.abs(arc2.getWidth() - arc2.getHeight()) < m_eps) {
            Ellipse2D.Double cir = new Ellipse2D.Double(arc.getMinX(), arc.getMinY(), arc.getWidth(), arc.getHeight());
            Ellipse2D.Double cir2 = new Ellipse2D.Double(arc2.getMinX(), arc2.getMinY(), arc2.getWidth(), arc2.getHeight());
            Point2D[] pnts = new Point2D[2];
            int nPnts = 0;
            Iterator<Point2D> it = Geo2D.intersection((Ellipse2D)cir, (Ellipse2D)cir2);
            while (it.hasNext()) {
                Point2D p = it.next();
                if (!Geo2D.containment(arc, p) || !Geo2D.containment(arc2, p)) continue;
                pnts[nPnts++] = p;
            }
            return new _PointIterator(pnts, nPnts);
        }
        return Geo2D.intersection(arc.getPathIterator(null), arc2.getPathIterator(null));
    }

    public static Iterator<Point2D> intersection(Arc2D arc, QuadCurve2D qad) throws NoIntersectionException {
        return Geo2D.intersection(arc.getPathIterator(null), qad.getPathIterator(null));
    }

    public static Iterator<Point2D> intersection(Arc2D arc, CubicCurve2D cub) throws NoIntersectionException {
        return Geo2D.intersection(arc.getPathIterator(null), cub.getPathIterator(null));
    }

    public static Iterator<Point2D> intersection(QuadCurve2D qad, QuadCurve2D qad2) throws NoIntersectionException {
        return Geo2D.intersection(Geo2D._toCubicCurve(qad, new CubicCurve2D.Double()), Geo2D._toCubicCurve(qad2, new CubicCurve2D.Double()));
    }

    public static Iterator<Point2D> intersection(QuadCurve2D qad, CubicCurve2D cub) throws NoIntersectionException {
        return Geo2D.intersection(Geo2D._toCubicCurve(qad, new CubicCurve2D.Double()), cub);
    }

    public static Iterator<Point2D> intersection(CubicCurve2D cub1, CubicCurve2D cub2) throws NoIntersectionException {
        Point2D[] pnts = new Point2D.Double[9];
        int nPnts = Geo2D._intersection(cub1, cub2, pnts);
        if (nPnts == 0) {
            throw new NoIntersectionException();
        }
        return new _PointIterator(pnts, nPnts);
    }

    private static int _intersection(CubicCurve2D cub1, CubicCurve2D cub2, Point2D[] pnts) {
        return Geo2D.__intersection(cub1, cub2, pnts, 0);
    }

    private static int __intersection(CubicCurve2D cub1, CubicCurve2D cub2, Point2D[] pnts, int nPnts) {
        boolean isFlat2;
        if (nPnts >= 9) {
            return nPnts;
        }
        if (!Geo2D._collision(cub1, cub2)) {
            return nPnts;
        }
        boolean isFlat1 = cub1.getFlatnessSq() < m_epsSqr;
        boolean bl = isFlat2 = cub2.getFlatnessSq() < m_epsSqr;
        if (isFlat1 && isFlat2) {
            Line2D.Double l1 = new Line2D.Double(cub1.getP1(), cub1.getP2());
            Line2D.Double l2 = new Line2D.Double(cub2.getP1(), cub2.getP2());
            Point2D.Double p = new Point2D.Double();
            try {
                Geo2D.intersection((Line2D)l1, (Line2D)l2, p);
                int i = 0;
                while (i < nPnts) {
                    if (Geo2D.equality(pnts[i], p)) {
                        return nPnts;
                    }
                    ++i;
                }
                pnts[nPnts++] = p;
            }
            catch (NoIntersectionException i) {}
        } else if (isFlat1) {
            Line2D.Double l1 = new Line2D.Double(cub1.getP1(), cub1.getP2());
            if (Geo2D._relativePosition(l1, cub2) != 0) {
                return nPnts;
            }
            CubicCurve2D.Double left2 = new CubicCurve2D.Double();
            CubicCurve2D.Double right2 = new CubicCurve2D.Double();
            cub2.subdivide(left2, right2);
            nPnts = Geo2D.__intersection(cub1, (CubicCurve2D)left2, pnts, nPnts);
            nPnts = Geo2D.__intersection(cub1, (CubicCurve2D)right2, pnts, nPnts);
        } else if (isFlat2) {
            Line2D.Double l2 = new Line2D.Double(cub2.getP1(), cub2.getP2());
            if (Geo2D._relativePosition(l2, cub1) != 0) {
                return nPnts;
            }
            CubicCurve2D.Double left1 = new CubicCurve2D.Double();
            CubicCurve2D.Double right1 = new CubicCurve2D.Double();
            cub1.subdivide(left1, right1);
            nPnts = Geo2D.__intersection(left1, cub2, pnts, nPnts);
            nPnts = Geo2D.__intersection(right1, cub2, pnts, nPnts);
        } else {
            CubicCurve2D.Double left1 = new CubicCurve2D.Double();
            CubicCurve2D.Double right1 = new CubicCurve2D.Double();
            cub1.subdivide(left1, right1);
            CubicCurve2D.Double left2 = new CubicCurve2D.Double();
            CubicCurve2D.Double right2 = new CubicCurve2D.Double();
            cub2.subdivide(left2, right2);
            nPnts = Geo2D.__intersection(left1, (CubicCurve2D)left2, pnts, nPnts);
            nPnts = Geo2D.__intersection(left1, (CubicCurve2D)right2, pnts, nPnts);
            nPnts = Geo2D.__intersection(right1, (CubicCurve2D)left2, pnts, nPnts);
            nPnts = Geo2D.__intersection(right1, (CubicCurve2D)right2, pnts, nPnts);
        }
        return nPnts;
    }

    public static Iterator<Point2D> intersection(PathIterator pit, Line2D seg) throws NoIntersectionException {
        return Geo2D.intersection(pit, seg.getPathIterator(null));
    }

    public static Iterator<Point2D> intersection(PathIterator pit, Line2D any, boolean unbounded) throws NoIntersectionException {
        if (!unbounded) {
            PathIterator pitl = any.getPathIterator(null);
            return Geo2D.intersection(pit, pitl);
        }
        CubicCurve2D.Double cub1 = new CubicCurve2D.Double();
        HashSet<Point2D> pntSet = new HashSet<Point2D>();
        pntSet.clear();
        Shape seg1 = null;
        double[] mvto1 = new double[2];
        double[] last1 = new double[2];
        double[] crds1 = new double[6];
        while (!pit.isDone()) {
            int typ1 = pit.currentSegment(crds1);
            switch (typ1) {
                case 0: {
                    mvto1[0] = crds1[0];
                    mvto1[1] = crds1[1];
                    seg1 = null;
                    last1[0] = crds1[0];
                    last1[1] = crds1[1];
                    break;
                }
                case 1: {
                    seg1 = new Line2D.Double(last1[0], last1[1], crds1[0], crds1[1]);
                    last1[0] = crds1[0];
                    last1[1] = crds1[1];
                    break;
                }
                case 2: {
                    seg1 = new QuadCurve2D.Double(last1[0], last1[1], crds1[0], crds1[1], crds1[2], crds1[3]);
                    last1[0] = crds1[2];
                    last1[1] = crds1[3];
                    break;
                }
                case 3: {
                    seg1 = new CubicCurve2D.Double(last1[0], last1[1], crds1[0], crds1[1], crds1[2], crds1[3], crds1[4], crds1[5]);
                    last1[0] = crds1[4];
                    last1[1] = crds1[5];
                    break;
                }
                case 4: {
                    seg1 = new Line2D.Double(last1[0], last1[1], mvto1[0], mvto1[1]);
                    break;
                }
                default: {
                    throw new Error("Unexpected segment type");
                }
            }
            if (seg1 != null) {
                try {
                    if (seg1 instanceof Line2D) {
                        Point2D.Double p = new Point2D.Double();
                        Geo2D.intersection(seg1, false, any, true, p);
                        Geo2D._addPoint(pntSet, p);
                    } else {
                        Iterator<Point2D> it = Geo2D.intersection(any, true, Geo2D._toCubicCurve(seg1, cub1));
                        while (it.hasNext()) {
                            Point2D p = it.next();
                            Geo2D._addPoint(pntSet, p);
                        }
                    }
                }
                catch (NoIntersectionException noIntersectionException) {
                    // empty catch block
                }
            }
            pit.next();
        }
        if (pntSet.isEmpty()) {
            throw new NoIntersectionException();
        }
        return pntSet.iterator();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Iterator<Point2D> intersection(PathIterator pit, Ellipse2D ell) throws NoIntersectionException {
        double df = Math.abs(ell.getWidth() - ell.getHeight());
        if (df > Geo2D.getEps()) {
            return Geo2D.intersection(pit, ell.getPathIterator(null));
        }
        HashSet<Point2D> pntSet = new HashSet<Point2D>();
        pntSet.clear();
        Object var5_4 = null;
        double[] mvto1 = new double[2];
        double[] last1 = new double[2];
        double[] crds1 = new double[6];
        while (!pit.isDone()) {
            void var5_11;
            int typ1 = pit.currentSegment(crds1);
            switch (typ1) {
                case 0: {
                    mvto1[0] = crds1[0];
                    mvto1[1] = crds1[1];
                    Object var5_6 = null;
                    last1[0] = crds1[0];
                    last1[1] = crds1[1];
                    break;
                }
                case 1: {
                    Line2D.Double double_ = new Line2D.Double(last1[0], last1[1], crds1[0], crds1[1]);
                    last1[0] = crds1[0];
                    last1[1] = crds1[1];
                    break;
                }
                case 2: {
                    QuadCurve2D.Double double_ = new QuadCurve2D.Double(last1[0], last1[1], crds1[0], crds1[1], crds1[2], crds1[3]);
                    last1[0] = crds1[2];
                    last1[1] = crds1[3];
                    break;
                }
                case 3: {
                    CubicCurve2D.Double double_ = new CubicCurve2D.Double(last1[0], last1[1], crds1[0], crds1[1], crds1[2], crds1[3], crds1[4], crds1[5]);
                    last1[0] = crds1[4];
                    last1[1] = crds1[5];
                    break;
                }
                case 4: {
                    Line2D.Double double_ = new Line2D.Double(last1[0], last1[1], mvto1[0], mvto1[1]);
                    break;
                }
                default: {
                    throw new Error("Unexpected segment type");
                }
            }
            if (var5_11 != null) {
                try {
                    Iterator<Point2D> it = null;
                    if (var5_11 instanceof Line2D) {
                        it = Geo2D.intersection((Line2D)var5_11, false, ell);
                    } else if (var5_11 instanceof QuadCurve2D) {
                        it = Geo2D.intersection(ell, (QuadCurve2D)var5_11);
                    } else {
                        if (!(var5_11 instanceof CubicCurve2D)) {
                            throw new InternalError("Unexpected segment type");
                        }
                        it = Geo2D.intersection(ell, (CubicCurve2D)var5_11);
                    }
                    while (it.hasNext()) {
                        Point2D p = it.next();
                        Geo2D._addPoint(pntSet, p);
                    }
                }
                catch (NoIntersectionException noIntersectionException) {
                    // empty catch block
                }
            }
            pit.next();
        }
        if (pntSet.isEmpty()) {
            throw new NoIntersectionException();
        }
        return pntSet.iterator();
    }

    public static Iterator<Point2D> intersection(PathIterator pit, Arc2D arc) throws NoIntersectionException {
        return Geo2D.intersection(pit, arc.getPathIterator(null));
    }

    public static Iterator<Point2D> intersection(PathIterator pit, QuadCurve2D qad) throws NoIntersectionException {
        return Geo2D.intersection(pit, qad.getPathIterator(null));
    }

    public static Iterator<Point2D> intersection(PathIterator pit, CubicCurve2D cub) throws NoIntersectionException {
        return Geo2D.intersection(pit, cub.getPathIterator(null));
    }

    public static Iterator<Point2D> intersection(PathIterator pit1, PathIterator pit2) throws NoIntersectionException {
        RewindablePathIterator rwpit2 = new RewindablePathIterator(pit2);
        CubicCurve2D.Double cub1 = new CubicCurve2D.Double();
        CubicCurve2D.Double cub2 = new CubicCurve2D.Double();
        HashSet<Point2D> pntSet = new HashSet<Point2D>();
        pntSet.clear();
        Shape seg1 = null;
        double[] mvto1 = new double[2];
        double[] last1 = new double[2];
        double[] crds1 = new double[6];
        while (!pit1.isDone()) {
            int typ1 = pit1.currentSegment(crds1);
            switch (typ1) {
                case 0: {
                    mvto1[0] = crds1[0];
                    mvto1[1] = crds1[1];
                    seg1 = null;
                    last1[0] = crds1[0];
                    last1[1] = crds1[1];
                    break;
                }
                case 1: {
                    seg1 = new Line2D.Double(last1[0], last1[1], crds1[0], crds1[1]);
                    last1[0] = crds1[0];
                    last1[1] = crds1[1];
                    break;
                }
                case 2: {
                    seg1 = new QuadCurve2D.Double(last1[0], last1[1], crds1[0], crds1[1], crds1[2], crds1[3]);
                    last1[0] = crds1[2];
                    last1[1] = crds1[3];
                    break;
                }
                case 3: {
                    seg1 = new CubicCurve2D.Double(last1[0], last1[1], crds1[0], crds1[1], crds1[2], crds1[3], crds1[4], crds1[5]);
                    last1[0] = crds1[4];
                    last1[1] = crds1[5];
                    break;
                }
                case 4: {
                    seg1 = new Line2D.Double(last1[0], last1[1], mvto1[0], mvto1[1]);
                    break;
                }
                default: {
                    throw new Error("Unexpected segment type");
                }
            }
            if (seg1 != null) {
                Shape seg2 = null;
                double[] mvto2 = new double[2];
                double[] last2 = new double[2];
                double[] crds2 = new double[6];
                rwpit2.rewind();
                while (!rwpit2.isDone()) {
                    int typ2 = rwpit2.currentSegment(crds2);
                    switch (typ2) {
                        case 0: {
                            mvto2[0] = crds2[0];
                            mvto2[1] = crds2[1];
                            seg2 = null;
                            last2[0] = crds2[0];
                            last2[1] = crds2[1];
                            break;
                        }
                        case 1: {
                            seg2 = new Line2D.Double(last2[0], last2[1], crds2[0], crds2[1]);
                            last2[0] = crds2[0];
                            last2[1] = crds2[1];
                            break;
                        }
                        case 2: {
                            seg2 = new QuadCurve2D.Double(last2[0], last2[1], crds2[0], crds2[1], crds2[2], crds2[3]);
                            last2[0] = crds2[2];
                            last2[1] = crds2[3];
                            break;
                        }
                        case 3: {
                            seg2 = new CubicCurve2D.Double(last2[0], last2[1], crds2[0], crds2[1], crds2[2], crds2[3], crds2[4], crds2[5]);
                            last2[0] = crds2[4];
                            last2[1] = crds2[5];
                            break;
                        }
                        case 4: {
                            seg2 = new Line2D.Double(last2[0], last2[1], mvto2[0], mvto2[1]);
                            break;
                        }
                        default: {
                            throw new Error("Unexpected segment type");
                        }
                    }
                    if (seg2 != null) {
                        try {
                            if (seg1 instanceof Line2D && seg2 instanceof Line2D) {
                                Point2D.Double p = new Point2D.Double();
                                Geo2D.intersection((Line2D)seg1, (Line2D)seg2, p);
                                Geo2D._addPoint(pntSet, p);
                            } else {
                                Iterator<Point2D> it = Geo2D.intersection(Geo2D._toCubicCurve(seg1, cub1), Geo2D._toCubicCurve(seg2, cub2));
                                while (it.hasNext()) {
                                    Point2D p = it.next();
                                    Geo2D._addPoint(pntSet, p);
                                }
                            }
                        }
                        catch (NoIntersectionException noIntersectionException) {
                            // empty catch block
                        }
                    }
                    rwpit2.next();
                }
            }
            pit1.next();
        }
        if (pntSet.isEmpty()) {
            throw new NoIntersectionException();
        }
        return pntSet.iterator();
    }

    private static void _boundsCheck(Shape shp1, Shape shp2) throws NoIntersectionException {
        if (!Geo2D._collision(shp1, shp2)) {
            throw new NoIntersectionException("Bounds check: Shapes don't intersect");
        }
    }

    private static boolean _collision(Shape shp1, Shape shp2) {
        Rectangle2D bounds1 = shp1.getBounds2D();
        Rectangle2D bounds2 = shp2.getBounds2D();
        bounds1.setFrame(bounds1.getX() - m_eps, bounds1.getY() - m_eps, bounds1.getWidth() + m_eps + m_eps, bounds1.getHeight() + m_eps + m_eps);
        bounds2.setFrame(bounds2.getX() - m_eps, bounds2.getY() - m_eps, bounds2.getWidth() + m_eps + m_eps, bounds2.getHeight() + m_eps + m_eps);
        return bounds1.intersects(bounds2);
    }

    private static CubicCurve2D _toCubicCurve(Shape seg, CubicCurve2D cub) {
        if (cub == null) {
            cub = new CubicCurve2D.Double();
        }
        if (seg instanceof Line2D) {
            Line2D src = (Line2D)seg;
            cub.setCurve(src.getX1(), src.getY1(), src.getX1(), src.getY1(), src.getX2(), src.getY2(), src.getX2(), src.getY2());
        } else {
            if (seg instanceof Ellipse2D) {
                throw new InternalError("Can't convert Ellipse2D to CubicCurve2D");
            }
            if (seg instanceof Arc2D) {
                throw new InternalError("Can't convert Arc2D to CubicCurve2D");
            }
            if (seg instanceof QuadCurve2D) {
                QuadCurve2D src = (QuadCurve2D)seg;
                cub.setCurve(src.getX1(), src.getY1(), src.getCtrlX(), src.getCtrlY(), src.getCtrlX(), src.getCtrlY(), src.getX2(), src.getY2());
            } else {
                CubicCurve2D src = (CubicCurve2D)seg;
                cub.setCurve(src.getX1(), src.getY1(), src.getCtrlX1(), src.getCtrlY1(), src.getCtrlX2(), src.getCtrlY2(), src.getX2(), src.getY2());
            }
        }
        return cub;
    }

    private static boolean _addPoint(Set<Point2D> set, Point2D pnt) {
        for (Point2D _pnt : set) {
            if (!Geo2D.equality(pnt, _pnt)) continue;
            return false;
        }
        set.add(pnt);
        return true;
    }

    public static boolean equality(double d1, double d2) {
        return m_eps > Math.abs(d2 - d1);
    }

    public static boolean equality(Point2D pnt1, Point2D pnt2) {
        return Geo2D.equality(pnt1.getX(), pnt1.getY(), pnt2.getX(), pnt2.getY());
    }

    public static boolean equality(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return m_epsSqr > dx * dx + dy * dy;
    }

    public static boolean equality(Vector2D vec1, Vector2D vec2) {
        double dy;
        double dx = vec2.getX() - vec1.getX();
        return m_epsSqr > dx * dx + (dy = vec2.getY() - vec1.getY()) * dy;
    }

    public static boolean equality(Line2D seg1, Line2D seg2) {
        return Geo2D.equality(seg1.getP1(), seg2.getP1()) && Geo2D.equality(seg1.getP2(), seg2.getP2());
    }

    public static boolean equality(Line2D any1, Line2D any2, boolean unbounded) {
        if (unbounded) {
            boolean isNull1 = Geo2D.isNull(any1);
            boolean isNull2 = Geo2D.isNull(any2);
            if (isNull1 && isNull2) {
                return Geo2D.equality(any1.getP1(), any2.getP1());
            }
            if (!isNull1 && !isNull2) {
                Line2D longLine = any1;
                Line2D shortLine = any2;
                if (Geo2D.length(any2) > Geo2D.length(any1)) {
                    longLine = any2;
                    shortLine = any1;
                }
                if (Geo2D.containment(longLine, unbounded, shortLine.getP1()) && Geo2D.containment(longLine, unbounded, shortLine.getP2())) {
                    return true;
                }
            }
            return false;
        }
        return Geo2D.equality(any1, any2);
    }

    public static boolean equality(Ellipse2D ell1, Ellipse2D ell2) {
        Point2D.Double pnt1 = new Point2D.Double();
        Point2D.Double pnt2 = new Point2D.Double();
        ((Point2D)pnt1).setLocation(ell1.getX(), ell1.getY());
        ((Point2D)pnt2).setLocation(ell2.getX(), ell2.getY());
        return Geo2D.equality(pnt1, pnt2) && Geo2D.equality(ell1.getWidth(), ell2.getWidth()) && Geo2D.equality(ell1.getHeight(), ell2.getHeight());
    }

    public static boolean equality(Arc2D arc1, Arc2D arc2) {
        Point2D.Double pnt1 = new Point2D.Double();
        Point2D.Double pnt2 = new Point2D.Double();
        ((Point2D)pnt1).setLocation(arc1.getX(), arc1.getY());
        ((Point2D)pnt2).setLocation(arc2.getX(), arc2.getY());
        return Geo2D.equality(pnt1, pnt2) && Geo2D.equality(arc1.getWidth(), arc2.getWidth()) && Geo2D.equality(arc1.getHeight(), arc2.getHeight()) && Geo2D.equality(arc1.getAngleStart(), arc2.getAngleStart()) && Geo2D.equality(arc1.getAngleExtent(), arc2.getAngleExtent());
    }

    public static boolean equality(QuadCurve2D qad1, QuadCurve2D qad2) {
        return Geo2D.equality(qad1.getP1(), qad2.getP1()) && Geo2D.equality(qad1.getP2(), qad2.getP2()) && Geo2D.equality(qad1.getCtrlPt(), qad2.getCtrlPt());
    }

    public static boolean equality(CubicCurve2D cub1, CubicCurve2D cub2) {
        return Geo2D.equality(cub1.getP1(), cub2.getP1()) && Geo2D.equality(cub1.getP2(), cub2.getP2()) && Geo2D.equality(cub1.getCtrlP1(), cub2.getCtrlP1()) && Geo2D.equality(cub1.getCtrlP2(), cub2.getCtrlP2());
    }

    public static boolean parallelism(Line2D any1, Line2D any2) {
        Line2D.Double _any2 = new Line2D.Double(any1.getX1(), any1.getY1(), any1.getX1() + any2.getX2() - any2.getX1(), any1.getY1() + any2.getY2() - any2.getY1());
        return Geo2D.equality(any1, _any2, true);
    }

    public static boolean perpendicularity(Vector2D vec1, Vector2D vec2) {
        return Math.abs(vec1.getAngleSmallest(vec2) - Math.PI) < m_eps;
    }

    public static boolean perpendicularity(Line2D any1, Line2D any2) {
        Vector2D vec1 = new Vector2D(any1.getX2() - any1.getX1(), any1.getY2() - any1.getY1());
        Vector2D vec2 = new Vector2D(any2.getX2() - any2.getX1(), any2.getY2() - any2.getY1());
        return Geo2D.perpendicularity(vec1, vec2);
    }

    public static boolean containment(Line2D seg, Point2D pnt) {
        return seg.ptSegDistSq(pnt) <= m_epsSqr;
    }

    public static boolean containment(Line2D any, boolean unbounded, Point2D pnt) {
        return unbounded ? any.ptLineDistSq(pnt) <= m_epsSqr : any.ptSegDistSq(pnt) <= m_epsSqr;
    }

    public static boolean containment(Ellipse2D ell, Point2D pnt) {
        return Geo2D.distance(pnt, ell) <= m_eps;
    }

    public static boolean containment(Arc2D arc, Point2D pnt) {
        return Geo2D.distance(pnt, arc) <= m_eps;
    }

    public static boolean containment(QuadCurve2D qad, Point2D pnt) {
        return Geo2D.distance(pnt, qad) <= m_eps;
    }

    public static boolean containment(CubicCurve2D cub, Point2D pnt) {
        return Geo2D.distance(pnt, cub) <= m_eps;
    }

    public static boolean isNull(double dist) {
        return dist * dist <= m_epsSqr;
    }

    public static boolean isNull(Vector2D vec) {
        return m_epsSqr > vec.getX() * vec.getX() + vec.getY() * vec.getY();
    }

    public static void setNull(Vector2D vec) {
        vec.x = 0.0;
        vec.y = 0.0;
    }

    public static boolean isNull(Line2D seg) {
        double dy;
        double dx = seg.getX2() - seg.getX1();
        return m_epsSqr > dx * dx + (dy = seg.getY2() - seg.getY1()) * dy;
    }

    public static void setNull(Line2D seg) {
        double x = seg.getX1();
        double y = seg.getY1();
        seg.setLine(x, y, x, y);
    }

    public static boolean isNull(Ellipse2D ell) {
        return m_eps > ell.getWidth() || m_eps > ell.getHeight();
    }

    public static void setNull(Ellipse2D ell) {
        double x = ell.getCenterX();
        double y = ell.getCenterY();
        ell.setFrameFromCenter(x, y, x, y);
    }

    public static boolean isNull(Arc2D arc) {
        return m_eps > arc.getWidth() || m_eps > arc.getHeight();
    }

    public static void setNull(Arc2D arc) {
        double x = arc.getCenterX();
        double y = arc.getCenterY();
        arc.setFrameFromCenter(x, y, x, y);
    }

    public static boolean isNull(QuadCurve2D qad) {
        return Geo2D.equality(qad.getP1(), qad.getP2());
    }

    public static void setNull(QuadCurve2D qad) {
        double x = qad.getX1();
        double y = qad.getX1();
        qad.setCurve(x, y, x, y, x, y);
    }

    public static boolean isNull(CubicCurve2D cub) {
        return Geo2D.equality(cub.getP1(), cub.getP2());
    }

    public static void setNull(CubicCurve2D cub) {
        double x = cub.getX1();
        double y = cub.getX1();
        cub.setCurve(x, y, x, y, x, y, x, y);
    }

    public static int calculateTangentLines(Point2D pnt, Ellipse2D ell, Point2D[] tangentPoints) {
        double rad;
        if (Math.abs(ell.getWidth() - ell.getHeight()) > m_eps) {
            throw new IllegalArgumentException("Not a circle");
        }
        double dst = Point2D.distance(ell.getCenterX(), ell.getCenterY(), pnt.getX(), pnt.getY());
        if (dst - (rad = 0.5 * ell.getWidth()) < -m_eps) {
            return 0;
        }
        if (Math.abs(dst - rad) < m_eps) {
            if (tangentPoints[0] == null) {
                tangentPoints[0] = new Point2D.Double();
            }
            tangentPoints[0].setLocation(pnt);
            return 1;
        }
        double cx = 0.5 * (pnt.getX() + ell.getCenterX());
        double cy = 0.5 * (pnt.getY() + ell.getCenterY());
        double r = 0.5 * Point2D.distance(pnt.getX(), pnt.getY(), ell.getCenterX(), ell.getCenterY());
        Ellipse2D.Double thales = new Ellipse2D.Double();
        thales.setFrameFromCenter(cx, cy, cx + r, cy + r);
        try {
            Iterator<Point2D> it = Geo2D.intersection(ell, (Ellipse2D)thales);
            if (tangentPoints[0] == null) {
                tangentPoints[0] = new Point2D.Double();
            }
            tangentPoints[0].setLocation(it.next());
            if (tangentPoints[1] == null) {
                tangentPoints[1] = new Point2D.Double();
            }
            tangentPoints[1].setLocation(it.next());
            return 2;
        }
        catch (NoIntersectionException e) {
            return 0;
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public static int calculateTangentLines(Ellipse2D ell1, Ellipse2D ell2, Line2D[] tangents) {
        if (Math.abs(ell1.getWidth() - ell1.getHeight()) > m_eps || Math.abs(ell2.getWidth() - ell2.getHeight()) > m_eps) {
            throw new IllegalArgumentException("Not a circle");
        }
        double r1 = 0.5 * ell1.getWidth();
        double c1x = ell1.getCenterX();
        double c1y = ell1.getCenterY();
        double r2 = 0.5 * ell2.getWidth();
        double c2x = ell2.getCenterX();
        double c2y = ell2.getCenterY();
        if (r2 > r1) {
            r2 = 0.5 * ell1.getWidth();
            c2x = ell1.getCenterX();
            c2y = ell1.getCenterY();
            r1 = 0.5 * ell2.getWidth();
            c1x = ell2.getCenterX();
            c1y = ell2.getCenterY();
        }
        Point2D.Double c1 = new Point2D.Double(c1x, c1y);
        Point2D.Double c2 = new Point2D.Double(c2x, c2y);
        double r = r1 - r2;
        Ellipse2D.Double ell = new Ellipse2D.Double();
        ell.setFrameFromCenter(c1x, c1y, c1x + r, c1y + r);
        Point2D[] tangentPoints = new Point2D[2];
        int n = Geo2D.calculateTangentLines(c2, (Ellipse2D)ell, tangentPoints);
        Vector2D v = new Vector2D();
        if (n > 0) {
            v.setLocation(c1, tangentPoints[0]);
            v.normalize();
            v.scaleBy(r2);
            if (tangents[0] == null) {
                tangents[0] = new Line2D.Double();
            }
            tangents[0].setLine(tangentPoints[0].getX() + v.x, tangentPoints[0].getY() + v.y, c2x + v.x, c2y + v.y);
        }
        if (n > 1) {
            v.setLocation(c1, tangentPoints[1]);
            v.normalize();
            v.scaleBy(r2);
            if (tangents[1] == null) {
                tangents[1] = new Line2D.Double();
            }
            tangents[1].setLine(tangentPoints[1].getX() + v.x, tangentPoints[1].getY() + v.y, c2x + v.x, c2y + v.y);
        }
        r = r1 + r2;
        ell.setFrameFromCenter(c1x, c1y, c1x + r, c1y + r);
        int m = Geo2D.calculateTangentLines(c2, (Ellipse2D)ell, tangentPoints);
        if (m > 0) {
            v.setLocation(c1, tangentPoints[0]);
            v.normalize();
            v.scaleBy(r2);
            if (tangents[n] == null) {
                tangents[n] = new Line2D.Double();
            }
            tangents[n].setLine(tangentPoints[0].getX() - v.x, tangentPoints[0].getY() - v.y, c2x - v.x, c2y - v.y);
        }
        if (m > 1) {
            v.setLocation(c1, tangentPoints[1]);
            v.normalize();
            v.scaleBy(r2);
            if (tangents[n + 1] == null) {
                tangents[n + 1] = new Line2D.Double();
            }
            tangents[n + 1].setLine(tangentPoints[1].getX() - v.x, tangentPoints[1].getY() - v.y, c2x - v.x, c2y - v.y);
        }
        return n + m;
    }

    public static int calculateTangentCircles(Line2D line1, Line2D line2, double radius, Point2D[] tangentCircleCenters) {
        if (radius < Geo2D.getEps()) {
            throw new IllegalArgumentException();
        }
        try {
            Point2D p = Geo2D.intersection(line1, true, line2, true, new Point2D.Double());
            Vector2D u = new Vector2D(line1.getP1(), line1.getP2()).normalize();
            Vector2D v = new Vector2D(line2.getP1(), line2.getP2()).normalize();
            Vector2D u_ = new Vector2D(-u.x, -u.y);
            Vector2D v_ = new Vector2D(-v.x, -v.y);
            if (tangentCircleCenters[0] == null) {
                tangentCircleCenters[0] = new Point2D.Double();
            }
            Geo2D._calculateCenter(p, u, v, radius, tangentCircleCenters[0]);
            if (tangentCircleCenters[1] == null) {
                tangentCircleCenters[1] = new Point2D.Double();
            }
            Geo2D._calculateCenter(p, u, v_, radius, tangentCircleCenters[1]);
            if (tangentCircleCenters[2] == null) {
                tangentCircleCenters[2] = new Point2D.Double();
            }
            Geo2D._calculateCenter(p, u_, v, radius, tangentCircleCenters[2]);
            if (tangentCircleCenters[3] == null) {
                tangentCircleCenters[3] = new Point2D.Double();
            }
            Geo2D._calculateCenter(p, u_, v_, radius, tangentCircleCenters[3]);
            return 4;
        }
        catch (NoIntersectionException e) {
            return 0;
        }
        catch (NullVectorException e) {
            return 0;
        }
    }

    private static Point2D _calculateCenter(Point2D p, Vector2D u, Vector2D v, double radius, Point2D ctr) {
        Vector2D c = new Vector2D(u.x + v.x, u.y + v.y).normalize();
        double angle = u.getAngleSmallest(v);
        double t = radius / Math.sin(0.5 * angle);
        c.scaleBy(t);
        if (ctr == null) {
            ctr = new Point2D.Double();
        }
        ctr.setLocation(p.getX() + c.x, p.getY() + c.y);
        return ctr;
    }

    public static int calculateTangentCircles(Line2D line, Ellipse2D cir, double r, Point2D[] tangentCircleCenters) {
        if (Geo2D.isNull(r)) {
            throw new IllegalArgumentException();
        }
        if (Geo2D.isNull(line) || Geo2D.isNull(cir)) {
            return 0;
        }
        Vector2D nrm = new Vector2D(line.getP1(), line.getP2());
        nrm.left();
        nrm.normalize();
        nrm.scaleBy(r);
        double r1 = 0.5 * cir.getWidth();
        double x1 = cir.getCenterX();
        double y1 = cir.getCenterY();
        int nCircles = 0;
        Line2D.Double l = new Line2D.Double();
        Ellipse2D.Double c = new Ellipse2D.Double();
        int i = 0;
        while (i < 2) {
            Iterator<Point2D> it2;
            ((Line2D)l).setLine(line.getX1() + nrm.x, line.getY1() + nrm.y, line.getX2() + nrm.x, line.getY2() + nrm.y);
            try {
                c.setFrameFromCenter(x1, y1, x1 + r1 + r, y1 + r1 + r);
                it2 = Geo2D.intersection((Line2D)l, true, c);
                while (it2.hasNext()) {
                    tangentCircleCenters[nCircles++] = it2.next();
                }
            }
            catch (NoIntersectionException it2) {
                // empty catch block
            }
            try {
                c.setFrameFromCenter(x1, y1, x1 + r1 - r, y1 + r1 - r);
                it2 = Geo2D.intersection((Line2D)l, true, c);
                while (it2.hasNext()) {
                    tangentCircleCenters[nCircles++] = it2.next();
                }
            }
            catch (NoIntersectionException noIntersectionException) {
                // empty catch block
            }
            nrm.scaleBy(-1.0);
            ++i;
        }
        return nCircles;
    }

    public static int calculateTangentCircles(Ellipse2D cir1, Ellipse2D cir2, double r, Point2D[] tangentCircleCenters) {
        if (r < Geo2D.getEps()) {
            throw new IllegalArgumentException();
        }
        int nCircles = 0;
        double r1 = 0.5 * cir1.getWidth();
        double x1 = cir1.getCenterX();
        double y1 = cir1.getCenterY();
        double r2 = 0.5 * cir2.getWidth();
        double x2 = cir2.getCenterX();
        double y2 = cir2.getCenterY();
        boolean swapped = false;
        if (Math.abs(x2 - x1) < Geo2D.getEps()) {
            swapped = true;
            double t = x1;
            x1 = y1;
            y1 = t;
            t = x2;
            x2 = y2;
            y2 = t;
        }
        if (Math.abs(x2 - x1) < Geo2D.getEps()) {
            return 0;
        }
        double _a = (y2 - y1) / (x2 - x1);
        double[] _b = new double[]{0.5 * ((r1 + r) * (r1 + r) - (r2 + r) * (r2 + r) - x1 * x1 + x2 * x2 - y1 * y1 + y2 * y2) / (x2 - x1), 0.5 * ((r1 + r) * (r1 + r) - (r2 - r) * (r2 - r) - x1 * x1 + x2 * x2 - y1 * y1 + y2 * y2) / (x2 - x1), 0.5 * ((r1 - r) * (r1 - r) - (r2 + r) * (r2 + r) - x1 * x1 + x2 * x2 - y1 * y1 + y2 * y2) / (x2 - x1), 0.5 * ((r1 - r) * (r1 - r) - (r2 - r) * (r2 - r) - x1 * x1 + x2 * x2 - y1 * y1 + y2 * y2) / (x2 - x1)};
        double a = 1.0 + _a * _a;
        double[] b = new double[4];
        int i = 0;
        while (i < 4) {
            b[i] = 2.0 * (_a * x1 - _a * _b[i] - y1);
            ++i;
        }
        double[] c = new double[]{_b[0] * _b[0] - 2.0 * _b[0] * x1 + x1 * x1 + y1 * y1 - (r1 + r) * (r1 + r), _b[1] * _b[1] - 2.0 * _b[1] * x1 + x1 * x1 + y1 * y1 - (r1 + r) * (r1 + r), _b[2] * _b[2] - 2.0 * _b[2] * x1 + x1 * x1 + y1 * y1 - (r1 - r) * (r1 - r), _b[3] * _b[3] - 2.0 * _b[3] * x1 + x1 * x1 + y1 * y1 - (r1 - r) * (r1 - r)};
        int i2 = 0;
        while (i2 < 4) {
            double discriminant = 0.25 * b[i2] * b[i2] - a * c[i2];
            if (discriminant > -Geo2D.getEps()) {
                double sqrt;
                double d = sqrt = discriminant < Geo2D.getEps() ? 0.0 : Math.sqrt(discriminant);
                if (!Double.isNaN(sqrt)) {
                    double y = (-0.5 * b[i2] + sqrt) / a;
                    double x = _b[i2] - _a * y;
                    Point2D point2D = tangentCircleCenters[nCircles++] = swapped ? new Point2D.Double(y, x) : new Point2D.Double(x, y);
                    if (discriminant > Geo2D.getEps()) {
                        y = (-0.5 * b[i2] - sqrt) / a;
                        x = _b[i2] - _a * y;
                        tangentCircleCenters[nCircles++] = swapped ? new Point2D.Double(y, x) : new Point2D.Double(x, y);
                    }
                }
            }
            ++i2;
        }
        return nCircles;
    }

    public static int clip(Rectangle2D rect, Line2D l) {
        int outcode2;
        int outcode1 = rect.outcode(l.getP1());
        if ((outcode1 & (outcode2 = rect.outcode(l.getP2()))) != 0) {
            return 0;
        }
        if (outcode1 == 0 && outcode2 == 0) {
            return -1;
        }
        double x1 = l.getX1();
        double y1 = l.getY1();
        double x2 = l.getX2();
        double y2 = l.getY2();
        if ((outcode1 & 1) != 0) {
            y1 += (y2 - y1) * (rect.getMinX() - x1) / (x2 - x1);
            x1 = rect.getMinX();
            outcode1 = rect.outcode(x1, y1);
        }
        if ((outcode1 & 4) != 0) {
            y1 += (y2 - y1) * (rect.getMaxX() - x1) / (x2 - x1);
            x1 = rect.getMaxX();
            outcode1 = rect.outcode(x1, y1);
        }
        if ((outcode1 & 2) != 0) {
            x1 += (x2 - x1) * (rect.getMinY() - y1) / (y2 - y1);
            y1 = rect.getMinY();
            outcode1 = rect.outcode(x1, y1);
        }
        if ((outcode1 & 8) != 0) {
            x1 += (x2 - x1) * (rect.getMaxY() - y1) / (y2 - y1);
            y1 = rect.getMaxY();
            outcode1 = rect.outcode(x1, y1);
        }
        if ((outcode2 & 1) != 0) {
            y2 = y1 + (y2 - y1) * (rect.getMinX() - x1) / (x2 - x1);
            x2 = rect.getMinX();
            outcode2 = rect.outcode(x2, y2);
        }
        if ((outcode2 & 4) != 0) {
            y2 = y1 + (y2 - y1) * (rect.getMaxX() - x1) / (x2 - x1);
            x2 = rect.getMaxX();
            outcode2 = rect.outcode(x2, y2);
        }
        if ((outcode2 & 2) != 0) {
            x2 = x1 + (x2 - x1) * (rect.getMinY() - y1) / (y2 - y1);
            y2 = rect.getMinY();
            outcode2 = rect.outcode(x2, y2);
        }
        if ((outcode2 & 8) != 0) {
            x2 = x1 + (x2 - x1) * (rect.getMaxY() - y1) / (y2 - y1);
            y2 = rect.getMaxY();
            outcode2 = rect.outcode(x2, y2);
        }
        l.setLine(x1, y1, x2, y2);
        return 1;
    }

    public static boolean _clip(Rectangle2D rect, Line2D l) {
        int outcode2;
        int outcode1 = rect.outcode(l.getP1());
        if ((outcode1 & (outcode2 = rect.outcode(l.getP2()))) != 0) {
            return false;
        }
        if (outcode1 == 0 && outcode2 == 0) {
            return true;
        }
        double x1 = l.getX1();
        double y1 = l.getY1();
        double x2 = l.getX2();
        double y2 = l.getY2();
        if ((outcode1 & 1) != 0) {
            y1 += (y2 - y1) * (rect.getMinX() - x1) / (x2 - x1);
            x1 = rect.getMinX();
            outcode1 = rect.outcode(x1, y1);
        }
        if ((outcode1 & 4) != 0) {
            y1 += (y2 - y1) * (rect.getMaxX() - x1) / (x2 - x1);
            x1 = rect.getMaxX();
            outcode1 = rect.outcode(x1, y1);
        }
        if ((outcode1 & 2) != 0) {
            x1 += (x2 - x1) * (rect.getMinY() - y1) / (y2 - y1);
            y1 = rect.getMinY();
            outcode1 = rect.outcode(x1, y1);
        }
        if ((outcode1 & 8) != 0) {
            x1 += (x2 - x1) * (rect.getMaxY() - y1) / (y2 - y1);
            y1 = rect.getMaxY();
            outcode1 = rect.outcode(x1, y1);
        }
        if ((outcode2 & 1) != 0) {
            y2 = y1 + (y2 - y1) * (rect.getMinX() - x1) / (x2 - x1);
            x2 = rect.getMinX();
            outcode2 = rect.outcode(x2, y2);
        }
        if ((outcode2 & 4) != 0) {
            y2 = y1 + (y2 - y1) * (rect.getMaxX() - x1) / (x2 - x1);
            x2 = rect.getMaxX();
            outcode2 = rect.outcode(x2, y2);
        }
        if ((outcode2 & 2) != 0) {
            x2 = x1 + (x2 - x1) * (rect.getMinY() - y1) / (y2 - y1);
            y2 = rect.getMinY();
            outcode2 = rect.outcode(x2, y2);
        }
        if ((outcode2 & 8) != 0) {
            x2 = x1 + (x2 - x1) * (rect.getMaxY() - y1) / (y2 - y1);
            y2 = rect.getMaxY();
            outcode2 = rect.outcode(x2, y2);
        }
        l.setLine(x1, y1, x2, y2);
        return true;
    }

    public static boolean getCircularArc(CubicCurve2D cub, Arc2D arc) {
        Point2D p2;
        Point2D p1 = cub.getP1();
        if (Geo2D.equality(p1, p2 = cub.getP2())) {
            return false;
        }
        CubicCurve2D.Double left = new CubicCurve2D.Double();
        CubicCurve2D.Double right = new CubicCurve2D.Double();
        cub.subdivide(left, right);
        Point2D pc = ((CubicCurve2D)left).getP2();
        arc = Geo2D.calculateArc2D(p1, pc, p2, arc);
        if (arc == null) {
            return false;
        }
        double radius = 0.5 * arc.getWidth();
        double eps = 3.0E-4 * radius;
        left.subdivide(left, null);
        double dist = Geo2D.distance(((CubicCurve2D)left).getX2(), ((CubicCurve2D)left).getY2(), arc.getCenterX(), arc.getCenterY());
        double delta = Math.abs(radius - dist);
        if (delta > eps) {
            return false;
        }
        right.subdivide(null, right);
        dist = Geo2D.distance(((CubicCurve2D)right).getX1(), ((CubicCurve2D)right).getY1(), arc.getCenterX(), arc.getCenterY());
        delta = Math.abs(radius - dist);
        return !(delta > eps);
    }

    public static Point2D getCenterPoint(Point2D p1, Point2D p2, double bulge, Point2D cp) throws IllegalArgumentException {
        if (Math.abs(bulge) < Geo2D.getEps()) {
            return null;
        }
        if (bulge < -1.0 - Geo2D.getEps() || bulge > 1.0 + Geo2D.getEps()) {
            throw new IllegalArgumentException("Illegal bulge value");
        }
        double l = Geo2D.distance(p1, p2);
        if (l < Geo2D.getEps()) {
            return null;
        }
        double h = 0.5 * bulge * l;
        double r = 0.5 * l / Math.sin(0.5 * Geo2D.angleFromBulge(bulge));
        Vector2D vec12 = new Vector2D(p2).subtract(p1);
        Vector2D vecPerp = new Vector2D(vec12);
        vecPerp.left();
        vecPerp.normalize();
        vecPerp.scaleBy(r - h);
        Vector2D veccp = new Vector2D(p1);
        vec12.scaleBy(0.5);
        veccp.add(vec12);
        veccp.add(vecPerp);
        if (cp == null) {
            cp = new Point2D.Double();
        }
        cp.setLocation(veccp);
        return cp;
    }

    public static double angleFromBulge(double bulge) {
        return 4.0 * Math.atan(bulge);
    }

    public static double bulgeFromAngle(double angle) {
        return Math.tan(0.25 * angle);
    }

    public static Ellipse2D calculateEllipse2D(Point2D _p1, Point2D _p2, Point2D _p3, Ellipse2D dst) {
        double xoff = (_p1.getX() + _p2.getX() + _p3.getX()) / 3.0;
        double yoff = (_p1.getY() + _p2.getY() + _p3.getY()) / 3.0;
        Point2D.Double p1 = new Point2D.Double(_p1.getX() - xoff, _p1.getY() - yoff);
        Point2D.Double p2 = new Point2D.Double(_p2.getX() - xoff, _p2.getY() - yoff);
        Point2D.Double p3 = new Point2D.Double(_p3.getX() - xoff, _p3.getY() - yoff);
        boolean equalityP1P2 = Geo2D.equality(p1, p2);
        boolean equalityP2P3 = Geo2D.equality(p2, p3);
        boolean equalityP1P3 = Geo2D.equality(p1, p3);
        if (equalityP1P2 && equalityP2P3 && equalityP1P3) {
            dst.setFrameFromCenter(((Point2D)p1).getX() + xoff, ((Point2D)p1).getY() + yoff, ((Point2D)p1).getX() + xoff, ((Point2D)p1).getY() + yoff);
            return dst;
        }
        Point2D.Double p = null;
        Point2D.Double q = null;
        if (equalityP1P2) {
            p = p1;
            q = p3;
        } else if (equalityP1P3) {
            p = p1;
            q = p2;
        } else if (equalityP2P3) {
            p = p2;
            q = p1;
        }
        if (p != null) {
            double radius = 0.5 * Geo2D.distance((Point2D)p, q);
            double centerX = 0.5 * (((Point2D)p).getX() + ((Point2D)q).getX());
            double centerY = 0.5 * (((Point2D)p).getY() + ((Point2D)q).getY());
            double cornerX = centerX + radius;
            double cornerY = centerY + radius;
            dst.setFrameFromCenter(centerX + xoff, centerY + yoff, cornerX + xoff, cornerY + yoff);
            return dst;
        }
        Line2D.Double l = new Line2D.Double(p1, p3);
        if (Geo2D.containment(l, true, p2)) {
            return null;
        }
        l.setLine(p1, p2);
        if (Geo2D.containment(l, true, p3)) {
            return null;
        }
        l.setLine(p2, p3);
        if (Geo2D.containment(l, true, p1)) {
            return null;
        }
        double a1 = 1.0;
        double b1 = -((Point2D)p1).getX();
        double c1 = -((Point2D)p1).getY();
        double d1 = -((Point2D)p1).getX() * ((Point2D)p1).getX() - ((Point2D)p1).getY() * ((Point2D)p1).getY();
        double a2 = 1.0;
        double b2 = -((Point2D)p2).getX();
        double c2 = -((Point2D)p2).getY();
        double d2 = -((Point2D)p2).getX() * ((Point2D)p2).getX() - ((Point2D)p2).getY() * ((Point2D)p2).getY();
        double a3 = 1.0;
        double b3 = -((Point2D)p3).getX();
        double c3 = -((Point2D)p3).getY();
        double d3 = -((Point2D)p3).getX() * ((Point2D)p3).getX() - ((Point2D)p3).getY() * ((Point2D)p3).getY();
        double detD = a1 * (b2 * c3 - b3 * c2) - b1 * (a2 * c3 - a3 * c2) + c1 * (a2 * b3 - a3 * b2);
        double detA = d1 * (b2 * c3 - b3 * c2) - b1 * (d2 * c3 - d3 * c2) + c1 * (d2 * b3 - d3 * b2);
        double detB = a1 * (d2 * c3 - d3 * c2) - d1 * (a2 * c3 - a3 * c2) + c1 * (a2 * d3 - a3 * d2);
        double detC = a1 * (b2 * d3 - b3 * d2) - b1 * (a2 * d3 - a3 * d2) + d1 * (a2 * b3 - a3 * b2);
        double a = detA / detD;
        double b = detB / detD;
        double c = detC / detD;
        if (Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(c)) {
            return null;
        }
        double xm = 0.5 * b;
        double ym = 0.5 * c;
        double r = Math.sqrt(xm * xm + ym * ym - a);
        dst.setFrameFromDiagonal(xm - r + xoff, ym - r + yoff, xm + r + xoff, ym + r + yoff);
        return dst;
    }

    public static Arc2D calculateArc2D(Point2D _sp, Point2D _p, Point2D _ep, Arc2D dst) {
        Point2D.Double ep;
        Point2D.Double p;
        double xoff = (_sp.getX() + _p.getX() + _ep.getX()) / 3.0;
        double yoff = (_sp.getY() + _p.getY() + _ep.getY()) / 3.0;
        Point2D.Double sp = new Point2D.Double(_sp.getX() - xoff, _sp.getY() - yoff);
        Ellipse2D ell = Geo2D.calculateEllipse2D(sp, p = new Point2D.Double(_p.getX() - xoff, _p.getY() - yoff), ep = new Point2D.Double(_ep.getX() - xoff, _ep.getY() - yoff), new Ellipse2D.Double());
        if (ell == null) {
            return null;
        }
        double xm = ell.getCenterX();
        double ym = ell.getCenterY();
        double r = 0.5 * ell.getHeight();
        if (r < Geo2D.getEps()) {
            dst.setArcByCenter(xm + xoff, ym + yoff, r, 0.0, 0.0, 0);
            return dst;
        }
        Vector2D vsp = new Vector2D(xm, ym, ((Point2D)sp).getX(), ((Point2D)sp).getY());
        Vector2D vp = new Vector2D(xm, ym, ((Point2D)p).getX(), ((Point2D)p).getY());
        Vector2D vep = new Vector2D(xm, ym, ((Point2D)ep).getX(), ((Point2D)ep).getY());
        try {
            double startAngle = Vector2D.X_UNIT.getAngleCCW(vsp);
            double sweepAngle = vsp.getAngleCCW(vep);
            double angleVspVp = vsp.getAngleCCW(vp);
            if (angleVspVp > sweepAngle) {
                sweepAngle = -(Math.PI * 2 - sweepAngle);
            }
            dst.setArcByCenter(xm + xoff, ym + yoff, r, -Math.toDegrees(startAngle), -Math.toDegrees(sweepAngle), 0);
            Rectangle2D rct = dst.getBounds2D();
            if (Double.isNaN(rct.getWidth())) {
                return null;
            }
        }
        catch (NullVectorException e) {
            dst.setArcByCenter(xm, ym, r, 0.0, 0.0, 0);
        }
        return dst;
    }

    public static boolean collision(Shape shp, Rectangle2D rct, double flatness) {
        if (!shp.intersects(rct)) {
            return false;
        }
        if (shp.contains(rct)) {
            return false;
        }
        double[] crds = new double[6];
        double[] moveToCrds = new double[2];
        double[] lastCrds = new double[2];
        PathIterator pit = shp.getPathIterator(null, flatness);
        while (!pit.isDone()) {
            int seg = pit.currentSegment(crds);
            switch (seg) {
                case 0: {
                    moveToCrds[0] = crds[0];
                    moveToCrds[1] = crds[1];
                    lastCrds[0] = crds[0];
                    lastCrds[1] = crds[1];
                    break;
                }
                case 1: {
                    if (rct.intersectsLine(lastCrds[0], lastCrds[1], crds[0], crds[1])) {
                        return true;
                    }
                    lastCrds[0] = crds[0];
                    lastCrds[1] = crds[1];
                    break;
                }
                case 4: {
                    if (!rct.intersectsLine(lastCrds[0], lastCrds[1], moveToCrds[0], moveToCrds[1])) break;
                    return true;
                }
                default: {
                    throw new InternalError();
                }
            }
            pit.next();
        }
        return false;
    }

    private static class _PointIterator
    implements Iterator<Point2D> {
        private Point2D[] m_pnts;
        private int m_index = 0;

        private _PointIterator(Point2D[] pnts, int _nPnts) {
            int nPnts = 0;
            int i = 0;
            while (i < _nPnts) {
                if (pnts[i] != null) {
                    ++nPnts;
                }
                ++i;
            }
            this.m_pnts = new Point2D.Double[nPnts];
            int j = 0;
            int i2 = 0;
            while (i2 < _nPnts) {
                if (pnts[i2] != null) {
                    this.m_pnts[j++] = pnts[i2];
                }
                ++i2;
            }
            this.m_index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.m_index < this.m_pnts.length;
        }

        @Override
        public Point2D next() {
            if (this.m_index >= this.m_pnts.length) {
                throw new NoSuchElementException();
            }
            return this.m_pnts[this.m_index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

