/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute.mindmapmode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.core.ui.components.JComboBoxWithBorder;
import org.freeplane.core.ui.components.TypedListCellRenderer;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.SortedComboBoxModel;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.AttributeRegistryElement;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.attribute.mindmapmode.AssignAttributeDialog;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

@EnabledAction(checkOnNodeChange=true)
public class AddAttributeAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private JComboBox attributeNames = null;
    private JComboBox attributeValues = null;
    private final AttributeController attrContr = AttributeController.getController();

    public AddAttributeAction() {
        super("attributes_AddAttributeAction");
    }

    public void actionPerformed(ActionEvent arg0) {
        Collection nodes = Controller.getCurrentModeController().getMapController().getSelectedNodes();
        int selection = UITools.showConfirmDialog((NodeModel)Controller.getCurrentController().getSelection().getSelected(), (Object)this.getPanel(), (String)TextUtils.getText((String)"attributes_AddAttributeAction.text"), (int)2, (int)-1);
        if (selection == 0) {
            if (this.attributeNames.getSelectedItem() == null) {
                UITools.showAttributeEmptyStringErrorMessage();
                return;
            }
            String name = this.attributeNames.getSelectedItem().toString();
            if (name.equals("")) {
                UITools.showAttributeEmptyStringErrorMessage();
                return;
            }
            Object valueSelectedItem = this.attributeValues.getSelectedItem();
            String value = valueSelectedItem != null ? valueSelectedItem.toString() : "";
            for (NodeModel node : nodes) {
                NodeAttributeTableModel attributes = this.attrContr.createAttributeTableModel(node);
                this.attrContr.performInsertRow(attributes, attributes.getRowCount(), name, (Object)value);
            }
        }
    }

    private JPanel getPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(new EtchedBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(20, 10, 2, 10);
        String pattern = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        JLabel patternLabel = new JLabel("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        Dimension comboBoxMaximumSize = patternLabel.getPreferredSize();
        comboBoxMaximumSize.width += 4;
        comboBoxMaximumSize.height += 10;
        JLabel nameLabel = new JLabel(TextUtils.getText((String)"attribute_name"));
        panel.add((Component)nameLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        JLabel valueLabel = new JLabel(TextUtils.getText((String)"attribute_value"));
        panel.add((Component)valueLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(2, 10, 20, 10);
        this.attributeNames = new JComboBoxWithBorder();
        MapModel map = Controller.getCurrentController().getMap();
        AttributeRegistry attributes = AttributeRegistry.getRegistry((MapModel)map);
        ComboBoxModel names = attributes.getComboBoxModel();
        this.attributeNames.setModel(new AssignAttributeDialog.ClonedComboBoxModel(names));
        this.attributeNames.setEditable(true);
        this.attributeNames.setMaximumSize(comboBoxMaximumSize);
        this.attributeNames.setPreferredSize(comboBoxMaximumSize);
        this.attributeNames.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AddAttributeAction.this.selectedAttributeChanged(e.getItem(), AddAttributeAction.this.attributeValues);
            }
        });
        panel.add((Component)this.attributeNames, gridBagConstraints);
        this.attributeValues = new JComboBoxWithBorder();
        this.attributeValues.setRenderer(new TypedListCellRenderer());
        this.attributeValues.setMaximumSize(comboBoxMaximumSize);
        this.attributeValues.setPreferredSize(comboBoxMaximumSize);
        ++gridBagConstraints.gridx;
        panel.add((Component)this.attributeValues, gridBagConstraints);
        panel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Component component = e.getComponent();
                if (component.isShowing()) {
                    AddAttributeAction.this.attributeNames.requestFocus();
                    component.removeHierarchyListener(this);
                }
            }
        });
        return panel;
    }

    protected void selectedAttributeChanged(Object selectedAttributeName, JComboBox values) {
        MapModel map = Controller.getCurrentController().getMap();
        AttributeRegistry attributes = AttributeRegistry.getRegistry((MapModel)map);
        try {
            AttributeRegistryElement element = attributes.getElement((Comparable)((Object)selectedAttributeName.toString()));
            SortedComboBoxModel selectedValues = element.getValues();
            values.setModel(new AssignAttributeDialog.ClonedComboBoxModel((ComboBoxModel)selectedValues));
            try {
                Object firstValue = selectedValues.getElementAt(0);
                values.setSelectedItem(firstValue);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            values.setEditable(!element.isRestricted());
        }
        catch (NoSuchElementException ex) {
            values.setEditable(!selectedAttributeName.toString().equals(""));
        }
    }
}

