/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ExampleFileFilter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.export.mindmapmode.ImageCreator;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;

public class ExportToImage
implements IExportEngine {
    private final String imageDescripton;
    private final String imageType;

    ExportToImage(String imageType, String imageDescripton) {
        this.imageType = imageType;
        this.imageDescripton = imageDescripton;
    }

    @Override
    public void export(MapModel map, File toFile) {
        try {
            RenderedImage image = new ImageCreator(this.getImageResolutionDPI()).createBufferedImage(map);
            if (image != null) {
                this.exportToImage(image, toFile);
            }
        }
        catch (OutOfMemoryError ex) {
            UITools.errorMessage((Object)TextUtils.getText((String)"out_of_memory"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportToImage(RenderedImage image, File chosenFile) {
        try {
            ImageWriteParam writeParam;
            ImageTypeSpecifier typeSpecifier;
            ImageWriter writer;
            IIOMetadata metadata;
            Controller.getCurrentController().getViewController().setWaitingCursor(true);
            Iterator<ImageWriter> imageWritersByFormatName = ImageIO.getImageWritersByFormatName(this.imageType);
            do {
                writer = imageWritersByFormatName.next();
                writeParam = writer.getDefaultWriteParam();
            } while (((metadata = writer.getDefaultImageMetadata(typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1), writeParam)).isReadOnly() || !metadata.isStandardMetadataFormatSupported()) && imageWritersByFormatName.hasNext());
            this.addDpiToMetadata(metadata);
            FileOutputStream outFile = new FileOutputStream(chosenFile);
            ImageOutputStream stream = ImageIO.createImageOutputStream(outFile);
            try {
                writer.setOutput(ImageIO.createImageOutputStream(outFile));
                writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
            }
            finally {
                stream.close();
                outFile.close();
            }
        }
        catch (IOException e1) {
            LogUtils.warn((Throwable)e1);
            UITools.errorMessage((Object)TextUtils.getText((String)"export_failed"));
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
        return true;
    }

    private void addDpiToMetadata(IIOMetadata metadata) throws IIOInvalidTreeException {
        int dpi = this.getImageResolutionDPI();
        double dotsPerMilli = 1.0 * (double)dpi / 10.0 / 2.54;
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
        horiz.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
        vert.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        dim.appendChild(horiz);
        dim.appendChild(vert);
        root.appendChild(dim);
        metadata.mergeTree("javax_imageio_1.0", root);
    }

    public FileFilter getFileFilter() {
        return new ExampleFileFilter(this.imageType, this.imageDescripton);
    }

    private int getImageResolutionDPI() {
        return ResourceController.getResourceController().getIntProperty("exported_image_resolution_dpi", 300);
    }
}

