/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.features.mode.Controller;

public class Browser {
    public void openDocument(URI uri) {
        String osName;
        String uriString = uri.toString();
        String UNC_PREFIX = "file:////";
        if (uriString.startsWith("file:////")) {
            uriString = "file://" + uriString.substring("file:////".length());
        }
        if ((osName = System.getProperty("os.name")).substring(0, 3).equals("Win")) {
            String propertyString = "default_browser_command_windows";
            propertyString = osName.indexOf("9") != -1 || osName.indexOf("Me") != -1 ? propertyString + "_9x" : propertyString + "_nt";
            String[] command = null;
            try {
                Object[] messageArguments = new Object[]{uriString};
                MessageFormat formatter = new MessageFormat(ResourceController.getResourceController().getProperty(propertyString));
                String browserCommand = formatter.format(messageArguments);
                String scheme = uri.getScheme();
                if (scheme.equals("file") || scheme.equals("smb")) {
                    if (scheme.equals("smb")) {
                        uriString = Compat.smbUri2unc((URI)uri);
                    }
                    command = System.getProperty("os.name").startsWith("Windows 2000") ? new String[]{"rundll32", "shell32.dll,ShellExec_RunDLL", uriString} : new String[]{"rundll32", "url.dll,FileProtocolHandler", uriString};
                } else if (uriString.startsWith("mailto:")) {
                    command = new String[]{"rundll32", "url.dll,FileProtocolHandler", uriString};
                } else {
                    Controller.exec((String)browserCommand);
                    return;
                }
                Controller.exec((String[])command);
            }
            catch (IOException x) {
                UITools.errorMessage((Object)("Could not invoke browser.\n\nFreeplane excecuted the following statement on a command line:\n\"" + command + "\".\n\nYou may look at the user or default property called '" + propertyString + "'."));
                System.err.println("Caught: " + x);
            }
        } else if (osName.startsWith("Mac OS")) {
            String browserCommand = null;
            try {
                Object[] messageArguments = new Object[]{uriString, uriString};
                MessageFormat formatter = new MessageFormat(ResourceController.getResourceController().getProperty("default_browser_command_mac"));
                browserCommand = formatter.format(messageArguments);
                Controller.exec((String)browserCommand);
            }
            catch (IOException ex2) {
                UITools.errorMessage((Object)("Could not invoke browser.\n\nFreeplane excecuted the following statement on a command line:\n\"" + browserCommand + "\".\n\nYou may look at the user or default property called 'default_browser_command_mac'."));
                System.err.println("Caught: " + ex2);
            }
        } else {
            String browserCommand = null;
            try {
                Object[] messageArguments = new Object[]{uriString, uriString};
                MessageFormat formatter = new MessageFormat(ResourceController.getResourceController().getProperty("default_browser_command_other_os"));
                browserCommand = formatter.format(messageArguments);
                Controller.exec((String)browserCommand);
            }
            catch (IOException ex2) {
                UITools.errorMessage((Object)("Could not invoke browser.\n\nFreeplane excecuted the following statement on a command line:\n\"" + browserCommand + "\".\n\nYou may look at the user or default property called 'default_browser_command_other_os'."));
                System.err.println("Caught: " + ex2);
            }
        }
    }
}

