/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.features.mode.Controller;
import org.freeplane.main.application.ApplicationResourceController;

public class FreeplaneSplashModern
extends JWindow {
    private static final long serialVersionUID = 1L;
    private Font versionTextFont = null;
    private final ImageIcon splashImage;
    private final URL splashResource = ResourceController.getResourceController().getResource("/images/Freeplane_splash.png");

    public FreeplaneSplashModern(JFrame frame) {
        super(frame);
        this.splashImage = new ImageIcon(this.splashResource);
        this.setBackground(new Color(87, 191, 94));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = new Dimension(this.splashImage.getIconWidth(), this.splashImage.getIconHeight());
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        this.setSize(labelSize);
        RootPane rootPane = new RootPane();
        rootPane.setSize(labelSize);
        this.setRootPane(rootPane);
    }

    private void createVersionTextFont() {
        if (this.versionTextFont != null) {
            return;
        }
        InputStream fontInputStream = null;
        try {
            fontInputStream = ResourceController.getResourceController().getResource("/fonts/intuitive-subset.ttf").openStream();
            this.versionTextFont = Font.createFont(0, fontInputStream);
        }
        catch (Exception e) {
            try {
                this.versionTextFont = new Font("Arial", 0, 12);
            }
            catch (Throwable throwable) {
                FileUtils.silentlyClose((Closeable[])new Closeable[]{fontInputStream});
                throw throwable;
            }
            FileUtils.silentlyClose((Closeable[])new Closeable[]{fontInputStream});
        }
        FileUtils.silentlyClose((Closeable[])new Closeable[]{fontInputStream});
    }

    private String getVersionText(FreeplaneVersion version) {
        String freeplaneNumber = version.numberToString();
        String status = version.getType().toLowerCase();
        if ("".equals(status)) {
            return freeplaneNumber;
        }
        String versionString = freeplaneNumber + " " + status;
        return versionString;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.paintImmediately();
        }
    }

    public void paintImmediately() {
        this.getRootPane().paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    public static void main(String[] args) {
        ApplicationResourceController applicationResourceController = new ApplicationResourceController();
        Controller controller = new Controller((ResourceController)applicationResourceController);
        Controller.setCurrentController((Controller)controller);
        FreeplaneSplashModern freeplaneSplashModern = new FreeplaneSplashModern(null);
        freeplaneSplashModern.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.out.println("x = " + e.getX() + " y = " + e.getY());
                if (e.getClickCount() == 2) {
                    System.exit(0);
                }
            }
        });
        freeplaneSplashModern.setVisible(true);
    }

    private class RootPane
    extends JRootPane {
        public RootPane() {
            this.setDoubleBuffered(false);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            FreeplaneSplashModern.this.splashImage.paintIcon(this, g2, 0, 0);
            if (FreeplaneSplashModern.this.splashResource.getProtocol().equals("file")) {
                return;
            }
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            FreeplaneVersion version = FreeplaneVersion.getVersion();
            String versionString = FreeplaneSplashModern.this.getVersionText(version);
            g2.setColor(Color.WHITE);
            FreeplaneSplashModern.this.createVersionTextFont();
            float versionFontSize = 20.0f;
            g2.setFont(FreeplaneSplashModern.this.versionTextFont.deriveFont(20.0f));
            int versionStringWidth = g2.getFontMetrics().stringWidth(versionString);
            int xCoordinate = FreeplaneSplashModern.this.splashImage.getIconWidth() - versionStringWidth - 20;
            int yCoordinate = 20;
            g2.drawString(versionString, xCoordinate, 20);
        }

        @Override
        public void paintChildren(Graphics g) {
        }
    }
}

