/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import net.infonode.docking.AbstractTabWindow;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowAdapter;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.RootWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.ViewSerializer;
import net.infonode.docking.properties.DockingWindowProperties;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.theme.BlueHighlightDockingTheme;
import net.infonode.docking.util.DockingUtil;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.tabbedpanel.TabAreaProperties;
import net.infonode.tabbedpanel.TabAreaVisiblePolicy;
import net.infonode.tabbedpanel.TabDropDownListVisiblePolicy;
import net.infonode.tabbedpanel.TabLayoutPolicy;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.util.Direction;
import org.apache.commons.codec.binary.Base64;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.FileOpener;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.url.mindmapmode.DroppedMindMapOpener;
import org.freeplane.main.application.IconColorReplacer;
import org.freeplane.main.application.MapViewSerializer;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.DefaultMapMouseListener;

class MapViewDockingWindows
implements IMapViewChangeListener {
    private static final String OPENED_NOW = "openedNow_1.3.04";
    private RootWindow rootWindow = null;
    private final Vector<Component> mapViews;
    private boolean mPaneSelectionUpdate = true;
    private boolean loadingLayoutFromObjectInpusStream;
    private byte[] emptyConfigurations;
    private final MapViewSerializer viewSerializer = new MapViewSerializer();

    public MapViewDockingWindows() {
        this.rootWindow = new RootWindow((ViewSerializer)this.viewSerializer);
        this.configureDefaultDockingWindowProperties();
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream wrapper = new ObjectOutputStream(byteStream);
            this.rootWindow.write(wrapper);
            wrapper.close();
            this.emptyConfigurations = byteStream.toByteArray();
        }
        catch (IOException byteStream) {
            // empty catch block
        }
        this.removeDesktopPaneAccelerators();
        this.mapViews = new Vector();
        FileOpener fileOpener = new FileOpener("mm", (FileOpener.Listener)new DroppedMindMapOpener());
        new DropTarget((Component)this.rootWindow, (DropTargetListener)fileOpener);
        this.rootWindow.addMouseListener((MouseListener)new DefaultMapMouseListener());
        Controller controller = Controller.getCurrentController();
        controller.getMapViewManager().addMapViewChangeListener((IMapViewChangeListener)this);
        this.rootWindow.addListener((DockingWindowListener)new DockingWindowAdapter(){
            private IconColorReplacer iconColorReplacer;

            public void viewFocusChanged(View previouslyFocusedView, View focusedView) {
                Component mapViewComponent;
                Component containedMapView;
                if (focusedView != null && (containedMapView = MapViewDockingWindows.getContainedMapView(focusedView)) != (mapViewComponent = Controller.getCurrentController().getMapViewManager().getMapViewComponent())) {
                    MapViewDockingWindows.this.viewSelectionChanged(containedMapView);
                }
            }

            public void windowClosing(DockingWindow window) throws OperationAbortedException {
                for (Component mapViewComponent : MapViewDockingWindows.this.mapViews.toArray(new Component[0])) {
                    if (!SwingUtilities.isDescendingFrom(mapViewComponent, (Component)window) || Controller.getCurrentController().getMapViewManager().close(mapViewComponent)) continue;
                    throw new OperationAbortedException("can not close view");
                }
            }

            public void windowAdded(DockingWindow addedToWindow, DockingWindow addedWindow) {
                Container topLevelAncestor;
                if (addedWindow instanceof TabWindow) {
                    DockingWindowProperties windowProperties = addedWindow.getWindowProperties();
                    windowProperties.setDockEnabled(false);
                    windowProperties.setUndockEnabled(false);
                    if (UITools.getCurrentFrame().isResizable()) {
                        MapViewDockingWindows.this.setTabAreaVisiblePolicy((TabWindow)addedWindow);
                    } else {
                        MapViewDockingWindows.this.setTabAreaPolicy((TabWindow)addedWindow, TabAreaVisiblePolicy.NEVER);
                    }
                } else if (addedWindow instanceof FloatingWindow && (topLevelAncestor = addedWindow.getTopLevelAncestor()) instanceof Window) {
                    if (this.iconColorReplacer == null) {
                        this.iconColorReplacer = new IconColorReplacer(((Window)UITools.getMenuComponent()).getIconImages());
                    }
                    List<Image> iconImages = this.iconColorReplacer.getNextIconImages();
                    ((Window)topLevelAncestor).setIconImages(iconImages);
                }
                this.setTabPolicies(addedWindow);
            }

            private void setTabPolicies(DockingWindow window) {
                if (window instanceof TabWindow) {
                    TabbedPanelProperties tabbedPanelProperties = ((TabWindow)window).getTabWindowProperties().getTabbedPanelProperties();
                    if (!tabbedPanelProperties.getTabLayoutPolicy().equals(TabLayoutPolicy.COMPRESSION)) {
                        tabbedPanelProperties.setTabLayoutPolicy(TabLayoutPolicy.COMPRESSION);
                    }
                    if (!tabbedPanelProperties.getTabDropDownListVisiblePolicy().equals(TabDropDownListVisiblePolicy.MORE_THAN_ONE_TAB)) {
                        tabbedPanelProperties.setTabDropDownListVisiblePolicy(TabDropDownListVisiblePolicy.MORE_THAN_ONE_TAB);
                    }
                }
                for (int i = 0; i < window.getChildWindowCount(); ++i) {
                    this.setTabPolicies(window.getChildWindow(i));
                }
            }

            public void windowRemoved(DockingWindow removedFromWindow, DockingWindow removedWindow) {
                if (removedWindow instanceof TabWindow && removedFromWindow == MapViewDockingWindows.this.rootWindow) {
                    TabAreaProperties tabAreaProperties = ((TabWindow)removedWindow).getTabWindowProperties().getTabbedPanelProperties().getTabAreaProperties();
                    tabAreaProperties.setTabAreaVisiblePolicy(TabAreaVisiblePolicy.ALWAYS);
                }
            }
        });
        new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
            }
        };
    }

    private void configureDefaultDockingWindowProperties() {
        RootWindowProperties rootWindowProperties = this.rootWindow.getRootWindowProperties();
        rootWindowProperties.addSuperObject(new BlueHighlightDockingTheme().getRootWindowProperties());
        RootWindowProperties overwrittenProperties = new RootWindowProperties();
        overwrittenProperties.getFloatingWindowProperties().setUseFrame(true);
        ComponentProperties windowAreaProperties = overwrittenProperties.getWindowAreaProperties();
        windowAreaProperties.setBackgroundColor(UIManager.getColor("Panel.background"));
        windowAreaProperties.setInsets(null);
        windowAreaProperties.setBorder(null);
        TabbedPanelProperties tabbedPanelProperties = overwrittenProperties.getTabWindowProperties().getTabbedPanelProperties();
        tabbedPanelProperties.setTabLayoutPolicy(TabLayoutPolicy.COMPRESSION);
        tabbedPanelProperties.setTabDropDownListVisiblePolicy(TabDropDownListVisiblePolicy.MORE_THAN_ONE_TAB);
        tabbedPanelProperties.setShadowEnabled(false);
        ComponentProperties contentPaneComponentProperties = tabbedPanelProperties.getContentPanelProperties().getComponentProperties();
        contentPaneComponentProperties.setInsets(null);
        contentPaneComponentProperties.setBorder(null);
        Font tabFont = new Font("Dialog", 0, 10);
        tabFont = UITools.scaleFontInt((Font)tabFont, (double)0.8);
        TitledTabProperties titledTabProperties = overwrittenProperties.getTabWindowProperties().getTabProperties().getTitledTabProperties();
        titledTabProperties.getHighlightedProperties().getComponentProperties().setFont(tabFont);
        titledTabProperties.getNormalProperties().getComponentProperties().setFont(tabFont);
        rootWindowProperties.addSuperObject(overwrittenProperties);
    }

    private void removeDesktopPaneAccelerators() {
        InputMap map = new InputMap();
        this.rootWindow.setInputMap(1, map);
    }

    private DockingWindow getLastFocusedChildWindow(DockingWindow parentWindow) {
        DockingWindow lastFocusedChildWindow = parentWindow.getLastFocusedChildWindow();
        if (lastFocusedChildWindow == null) {
            return parentWindow;
        }
        return this.getLastFocusedChildWindow(lastFocusedChildWindow);
    }

    public void afterViewChange(Component pOldMap, Component pNewMap) {
        if (pNewMap == null) {
            return;
        }
        if (!this.loadingLayoutFromObjectInpusStream) {
            for (int i = 0; i < this.mapViews.size(); ++i) {
                if (this.mapViews.get(i) != pNewMap) continue;
                View dockedView = MapViewDockingWindows.getContainingDockedWindow(pNewMap);
                if (dockedView.isMinimized()) {
                    dockedView.restore();
                } else {
                    dockedView.restoreFocus();
                }
                this.focusMapViewLater((MapView)pNewMap);
                return;
            }
            this.addDockedWindow(pOldMap, pNewMap);
        } else if (this.mapViews.contains(pNewMap)) {
            return;
        }
        this.mapViews.add(pNewMap);
    }

    private static View getContainingDockedWindow(Component pNewMap) {
        return (View)SwingUtilities.getAncestorOfClass(View.class, pNewMap);
    }

    private void addDockedView(View oldSelected, View newView) {
        View lastFocusedChildWindow;
        Object object = lastFocusedChildWindow = oldSelected != null ? oldSelected : this.getLastFocusedChildWindow((DockingWindow)this.rootWindow);
        if (lastFocusedChildWindow == null) {
            DockingUtil.addWindow((DockingWindow)newView, (RootWindow)this.rootWindow);
        } else {
            Container parent = SwingUtilities.getAncestorOfClass(DockingWindow.class, (Component)lastFocusedChildWindow);
            if (parent instanceof TabWindow) {
                TabWindow tabWindow = (TabWindow)parent;
                tabWindow.addTab((DockingWindow)newView, tabWindow.getChildWindowIndex((DockingWindow)lastFocusedChildWindow) + 1);
            } else {
                DockingUtil.addWindow((DockingWindow)newView, (RootWindow)lastFocusedChildWindow.getRootWindow());
            }
        }
    }

    static Component getContainedMapView(View dockedWindow) {
        JScrollPane scrollPane = (JScrollPane)dockedWindow.getComponent();
        Component view = scrollPane.getViewport().getView();
        return view;
    }

    private void addDockedWindow(Component pOldMap, Component pNewMap) {
        View viewFrame = this.viewSerializer.newDockedView(pNewMap, this.createTitle(pNewMap));
        this.addDockedView(pOldMap != null ? MapViewDockingWindows.getContainingDockedWindow(pOldMap) : null, viewFrame);
    }

    public void afterViewClose(Component pOldMapView) {
        for (int i = 0; i < this.mapViews.size(); ++i) {
            if (this.mapViews.get(i) != pOldMapView) continue;
            this.mPaneSelectionUpdate = false;
            MapViewDockingWindows.getContainingDockedWindow(pOldMapView).close();
            this.mapViews.remove(i);
            this.mPaneSelectionUpdate = true;
            this.rootWindow.repaint();
            return;
        }
    }

    public void afterViewCreated(Component mapView) {
    }

    public void beforeViewChange(Component pOldMapView, Component pNewMapView) {
    }

    private void viewSelectionChanged(Component mapView) {
        if (!this.mPaneSelectionUpdate) {
            return;
        }
        Controller controller = Controller.getCurrentController();
        if (mapView != controller.getMapViewManager().getMapViewComponent()) {
            controller.getMapViewManager().changeToMapView(mapView.getName());
        }
    }

    public JComponent getMapPane() {
        return this.rootWindow;
    }

    public void saveLayout() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            this.rootWindow.write(objectStream);
            objectStream.close();
            String encodedBytes = Base64.encodeBase64String((byte[])byteStream.toByteArray());
            ResourceController.getResourceController().setProperty(OPENED_NOW, encodedBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLayout() {
        String encodedBytes = ResourceController.getResourceController().getProperty(OPENED_NOW, null);
        if (encodedBytes != null) {
            byte[] bytes = Base64.decodeBase64((String)encodedBytes);
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            try {
                this.loadingLayoutFromObjectInpusStream = true;
                this.rootWindow.read(new ObjectInputStream(byteStream));
            }
            catch (Exception e) {
                LogUtils.severe((Throwable)e);
                try {
                    this.rootWindow.read(new ObjectInputStream(new ByteArrayInputStream(this.emptyConfigurations)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                this.viewSerializer.removeDummyViews();
                this.loadingLayoutFromObjectInpusStream = false;
            }
            this.rootWindow.getWindowBar(Direction.DOWN).setEnabled(false);
        }
    }

    public void focusMapViewLater(final MapView mapView) {
        Timer timer = new Timer(40, new ActionListener(){
            int retryCount = 5;

            @Override
            public void actionPerformed(ActionEvent event) {
                Timer eventTimer = (Timer)event.getSource();
                this.focusMapLater(mapView, eventTimer);
            }

            private void focusMapLater(MapView mapView2, final Timer eventTimer) {
                NodeView selected;
                if (mapView2.isShowing() && Controller.getCurrentController().getMapViewManager().getMapViewComponent() == mapView2 && (selected = mapView2.getSelected()) != null) {
                    final Frame frame = JOptionPane.getFrameForComponent((Component)mapView2);
                    if (frame.isFocused()) {
                        selected.requestFocusInWindow();
                    } else {
                        frame.addWindowFocusListener(new WindowAdapter(){

                            @Override
                            public void windowGainedFocus(WindowEvent e) {
                                frame.removeWindowFocusListener(this);
                                selected.requestFocusInWindow();
                                retryCount = 2;
                                eventTimer.start();
                            }
                        });
                    }
                }
                if (this.retryCount > 1) {
                    --this.retryCount;
                    eventTimer.start();
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public void setTitle() {
        if (this.loadingLayoutFromObjectInpusStream) {
            return;
        }
        for (Component mapViewComponent : this.mapViews) {
            if (!(mapViewComponent instanceof MapView)) continue;
            String title = this.createTitle(mapViewComponent);
            View containingDockedWindow = MapViewDockingWindows.getContainingDockedWindow(mapViewComponent);
            containingDockedWindow.getViewProperties().setTitle(title);
        }
    }

    private String createTitle(Component mapViewComponent) {
        MapView mapView = (MapView)mapViewComponent;
        String name = mapView.getName();
        String title = mapView.getModel().isSaved() || mapView.getModel().isReadOnly() ? name : name + " *";
        return title;
    }

    public void selectNextMapView() {
        this.selectMap(1);
    }

    public void selectPreviousMapView() {
        this.selectMap(-1);
    }

    private void selectMap(int tabIndexChange) {
        AbstractTabWindow tabWindow;
        Controller controller = Controller.getCurrentController();
        MapView mapView = (MapView)controller.getMapViewManager().getMapViewComponent();
        if (mapView != null && (tabWindow = (AbstractTabWindow)SwingUtilities.getAncestorOfClass(AbstractTabWindow.class, (Component)mapView)) != null) {
            DockingWindow selectedWindow = tabWindow.getSelectedWindow();
            int childWindowIndex = tabWindow.getChildWindowIndex(selectedWindow);
            int childWindowCount = tabWindow.getChildWindowCount();
            int nextWindowIndex = (childWindowIndex + childWindowCount + tabIndexChange) % childWindowCount;
            View nextWindow = (View)tabWindow.getChildWindow(nextWindowIndex);
            Component nextMapView = MapViewDockingWindows.getContainedMapView(nextWindow);
            Controller.getCurrentController().getMapViewManager().changeToMapView(nextMapView);
        }
    }

    private void setTabAreaVisiblePolicy(TabWindow window) {
        this.setTabAreaPolicy(window, window.getWindowParent() == this.rootWindow ? TabAreaVisiblePolicy.MORE_THAN_ONE_TAB : TabAreaVisiblePolicy.ALWAYS);
    }

    private void setTabAreaPolicy(TabWindow window, TabAreaVisiblePolicy tabAreaVisiblePolicy) {
        TabAreaProperties tabAreaProperties = window.getTabWindowProperties().getTabbedPanelProperties().getTabAreaProperties();
        tabAreaProperties.setTabAreaVisiblePolicy(tabAreaVisiblePolicy);
    }

    public void setTabAreaVisiblePolicy(JFrame frame) {
        DockingWindow window = (DockingWindow)(JOptionPane.getFrameForComponent((Component)this.rootWindow) == frame ? this.rootWindow : frame.getContentPane().getComponent(0));
        this.setTabAreaVisiblePolicies(window);
    }

    private void setTabAreaVisiblePolicies(DockingWindow parentWindow) {
        for (int i = 0; i < parentWindow.getChildWindowCount(); ++i) {
            DockingWindow window = parentWindow.getChildWindow(i);
            if (window instanceof TabWindow) {
                this.setTabAreaVisiblePolicy((TabWindow)window);
            }
            if (window instanceof FloatingWindow) continue;
            this.setTabAreaVisiblePolicies(window);
        }
    }

    public void setTabAreaInvisiblePolicy(JFrame frame) {
        DockingWindow window = (DockingWindow)(JOptionPane.getFrameForComponent((Component)this.rootWindow) == frame ? this.rootWindow : frame.getContentPane().getComponent(0));
        this.setTabAreaInvisiblePolicies(window);
    }

    private void setTabAreaInvisiblePolicies(DockingWindow parentWindow) {
        for (int i = 0; i < parentWindow.getChildWindowCount(); ++i) {
            DockingWindow window = parentWindow.getChildWindow(i);
            if (window instanceof TabWindow) {
                this.setTabAreaPolicy((TabWindow)window, TabAreaVisiblePolicy.NEVER);
            }
            if (window instanceof FloatingWindow) continue;
            this.setTabAreaInvisiblePolicies(window);
        }
    }

    public List<? extends Component> getMapViewVector() {
        ArrayList<Component> orderedMapViews = new ArrayList<Component>(this.mapViews.size());
        this.addMapViews(orderedMapViews, (DockingWindow)this.rootWindow);
        return orderedMapViews;
    }

    private void addMapViews(ArrayList<Component> orderedMapViews, DockingWindow window) {
        if (window instanceof View) {
            orderedMapViews.add(MapViewDockingWindows.getContainedMapView((View)window));
        } else {
            for (int windowIndex = 0; windowIndex < window.getChildWindowCount(); ++windowIndex) {
                this.addMapViews(orderedMapViews, window.getChildWindow(windowIndex));
            }
        }
    }
}

