/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode;

import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.ui.components.JComboBoxWithBorder;
import org.freeplane.view.swing.features.time.mindmapmode.PeriodUnit;

class PeriodPanel
extends JPanel {
    private JSpinner periodComponent;
    private JComboBox periodUnitBox;

    PeriodPanel() {
        SpinnerNumberModel periodModel = new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1);
        this.periodComponent = new JSpinner(periodModel);
        this.periodUnitBox = new JComboBoxWithBorder((Object[])TranslatedObject.fromEnum(PeriodUnit.class));
        this.periodUnitBox.setEditable(false);
        this.periodUnitBox.setSelectedIndex(PeriodUnit.DAY.ordinal());
        this.add(this.periodComponent);
        this.add(this.periodUnitBox);
    }

    PeriodUnit getPeriodUnit() {
        TranslatedObject selectedItem = (TranslatedObject)this.periodUnitBox.getSelectedItem();
        PeriodUnit period = (PeriodUnit)((Object)selectedItem.getObject());
        return period;
    }

    void setPeriodUnit(PeriodUnit unit) {
        this.periodUnitBox.setSelectedIndex(unit.ordinal());
    }

    int getPeriod() {
        return ((Number)this.periodComponent.getValue()).intValue();
    }

    void setPeriod(int period) {
        this.periodComponent.setValue(period);
    }

    Date calculateNextTime(Date time) {
        PeriodUnit periodUnit = this.getPeriodUnit();
        int period = this.getPeriod();
        long timeInMillis = time.getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMillis);
        if (periodUnit.equals((Object)PeriodUnit.WEEK)) {
            period *= 7;
        }
        calendar.add(periodUnit.calendarField, period);
        return calendar.getTime();
    }
}

