/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode.nodelist;

import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TextAccessor;

public class TextHolder
implements Comparable<TextHolder> {
    private final TextAccessor textAccessor;
    private String originalNotesText = null;
    private String untaggedNotesText = null;

    public TextHolder(TextAccessor textAccessor) {
        this.textAccessor = textAccessor;
    }

    @Override
    public int compareTo(TextHolder compareToObject) {
        return this.toString().compareTo(compareToObject.toString());
    }

    public String getUntaggedNotesText() {
        String notesText = this.textAccessor.getText();
        if (notesText == null) {
            return "";
        }
        if (this.untaggedNotesText == null || this.originalNotesText != null && !this.originalNotesText.equals(notesText)) {
            this.originalNotesText = notesText;
            this.untaggedNotesText = HtmlUtils.htmlToPlain((String)notesText).replaceAll("\\s+", " ");
        }
        return this.untaggedNotesText;
    }

    public String toString() {
        return this.getUntaggedNotesText();
    }

    public void setText(String newText) {
        this.textAccessor.setText(newText);
    }

    public NodeModel getNode() {
        return this.textAccessor.getNode();
    }

    public String getText() {
        return this.textAccessor.getText();
    }
}

