/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.clipboard.MindMapNodesSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

public class MNodeDragListener
implements DragGestureListener {
    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        String dragActionName;
        NodeModel node;
        Rectangle bounds;
        MainView mainView = (MainView)e.getComponent();
        NodeView nodeView = mainView.getNodeView();
        MapView mapView = nodeView.getMap();
        mapView.select();
        if (!nodeView.isSelected()) {
            nodeView.getMap().getModeController().getController().getSelection().selectAsTheOnlyOneSelected(nodeView.getModel());
        }
        if (!(bounds = new Rectangle(0, 0, mainView.getWidth(), mainView.getHeight())).contains(e.getDragOrigin())) {
            return;
        }
        int dragActionType = e.getDragAction();
        if (dragActionType == 2 && (node = nodeView.getModel()).isRoot() && !this.isLinkDragEvent(e)) {
            return;
        }
        Cursor cursor = this.getCursorByAction(dragActionType);
        if (this.isLinkDragEvent(e)) {
            cursor = DragSource.DefaultLinkDrop;
            dragActionName = "LINK";
        } else if ((e.getTriggerEvent().getModifiersEx() & 0x800) != 0) {
            cursor = DragSource.DefaultCopyDrop;
            dragActionName = "COPY";
        } else {
            dragActionName = "MOVE";
        }
        Transferable t = ClipboardController.getController().copy(Controller.getCurrentController().getSelection());
        ((MindMapNodesSelection)t).setDropAction(dragActionName);
        try {
            e.startDrag(cursor, t, new DragSourceListener(){

                @Override
                public void dragDropEnd(DragSourceDropEvent dsde) {
                }

                @Override
                public void dragEnter(DragSourceDragEvent e) {
                }

                @Override
                public void dragExit(DragSourceEvent dse) {
                }

                @Override
                public void dragOver(DragSourceDragEvent dsde) {
                }

                @Override
                public void dropActionChanged(DragSourceDragEvent dsde) {
                    dsde.getDragSourceContext().setCursor(MNodeDragListener.this.getCursorByAction(dsde.getUserAction()));
                }
            });
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            // empty catch block
        }
    }

    private boolean isLinkDragEvent(DragGestureEvent e) {
        return (e.getTriggerEvent().getModifiersEx() & 0x1000) != 0;
    }

    public Cursor getCursorByAction(int dragAction) {
        switch (dragAction) {
            case 1: {
                return DragSource.DefaultCopyDrop;
            }
            case 0x40000000: {
                return DragSource.DefaultLinkDrop;
            }
        }
        return DragSource.DefaultMoveDrop;
    }
}

