/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.plugin.GroovyRunner;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.freeplane.plugin.script.MyGroovyClassLoader;

class GroovyShell
extends GroovyObjectSupport {
    private static final String DEFAULT_CODE_BASE = "/groovy/shell";
    private Binding context;
    private int counter;
    private CompilerConfiguration config;
    private GroovyClassLoader loader;

    GroovyShell(ClassLoader parent, Binding binding, final CompilerConfiguration config) {
        if (binding == null) {
            throw new IllegalArgumentException("Binding must not be null.");
        }
        if (config == null) {
            throw new IllegalArgumentException("Compiler configuration must not be null.");
        }
        final ClassLoader parentLoader = parent != null ? parent : GroovyShell.class.getClassLoader();
        this.loader = AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader>(){

            @Override
            public GroovyClassLoader run() {
                return new MyGroovyClassLoader(parentLoader, config);
            }
        });
        this.context = binding;
        this.config = config;
    }

    public Object getProperty(String property) {
        Object answer = this.getVariable(property);
        if (answer == null) {
            answer = super.getProperty(property);
        }
        return answer;
    }

    public void setProperty(String property, Object newValue) {
        this.setVariable(property, newValue);
        try {
            super.setProperty(property, newValue);
        }
        catch (GroovyRuntimeException groovyRuntimeException) {
            // empty catch block
        }
    }

    private Object runScriptOrMainOrTestOrRunnable(Class scriptClass, String[] args) {
        if (scriptClass == null) {
            return null;
        }
        if (Script.class.isAssignableFrom(scriptClass)) {
            Script script = null;
            try {
                script = (Script)scriptClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (script != null) {
                script.setBinding(this.context);
                script.setProperty("args", (Object)args);
                return script.run();
            }
        }
        try {
            scriptClass.getMethod("main", String[].class);
            return InvokerHelper.invokeMethod((Object)scriptClass, (String)"main", (Object)new Object[]{args});
        }
        catch (NoSuchMethodException e) {
            if (Runnable.class.isAssignableFrom(scriptClass)) {
                return this.runRunnable(scriptClass, args);
            }
            for (Map.Entry entry : GroovySystem.RUNNER_REGISTRY.entrySet()) {
                GroovyRunner runner = (GroovyRunner)entry.getValue();
                if (runner == null || !runner.canRun(scriptClass, this.loader)) continue;
                return runner.run(scriptClass, this.loader);
            }
            String message = "This script or class could not be run.\nIt should either:\n- have a main method,\n- be a JUnit test or extend GroovyTestCase,\n- implement the Runnable interface,\n- or be compatible with a registered script runner. Known runners:\n";
            if (GroovySystem.RUNNER_REGISTRY.isEmpty()) {
                message = message + "  * <none>";
            }
            for (Map.Entry entry : GroovySystem.RUNNER_REGISTRY.entrySet()) {
                message = message + "  * " + (String)entry.getKey() + "\n";
            }
            throw new GroovyRuntimeException(message);
        }
    }

    private Object runRunnable(Class scriptClass, String[] args) {
        Constructor constructor = null;
        Runnable runnable = null;
        Throwable reason = null;
        try {
            constructor = scriptClass.getConstructor(new String[0].getClass());
            try {
                runnable = (Runnable)constructor.newInstance(new Object[]{args});
            }
            catch (Throwable t) {
                reason = t;
            }
        }
        catch (NoSuchMethodException e1) {
            try {
                constructor = scriptClass.getConstructor(new Class[0]);
                try {
                    runnable = (Runnable)constructor.newInstance(new Object[0]);
                }
                catch (InvocationTargetException ite) {
                    throw new InvokerInvocationException(ite.getTargetException());
                }
                catch (Throwable t) {
                    reason = t;
                }
            }
            catch (NoSuchMethodException nsme) {
                reason = nsme;
            }
        }
        if (constructor == null || runnable == null) {
            throw new GroovyRuntimeException("This script or class was runnable but could not be run. ", reason);
        }
        runnable.run();
        return null;
    }

    private Object getVariable(String name) {
        return this.context.getVariables().get(name);
    }

    private void setVariable(String name, Object value) {
        this.context.setVariable(name, value);
    }

    private Class parseClass(GroovyCodeSource codeSource) throws CompilationFailedException {
        return this.loader.parseClass(codeSource, false);
    }

    private Script parse(GroovyCodeSource codeSource) throws CompilationFailedException {
        return InvokerHelper.createScript((Class)this.parseClass(codeSource), (Binding)this.context);
    }

    Script parse(File file) throws CompilationFailedException, IOException {
        return this.parse(new GroovyCodeSource(file, this.config.getSourceEncoding()));
    }

    Script parse(String scriptText) throws CompilationFailedException {
        return this.parse(scriptText, this.generateScriptName());
    }

    private Script parse(final String scriptText, final String fileName) throws CompilationFailedException {
        GroovyCodeSource gcs = AccessController.doPrivileged(new PrivilegedAction<GroovyCodeSource>(){

            @Override
            public GroovyCodeSource run() {
                return new GroovyCodeSource(scriptText, fileName, GroovyShell.DEFAULT_CODE_BASE);
            }
        });
        return this.parse(gcs);
    }

    protected synchronized String generateScriptName() {
        return "Script" + ++this.counter + ".groovy";
    }
}

