/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import jsyntaxpane.CompoundUndoMan;
import jsyntaxpane.Lexer;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxDocument
extends PlainDocument {
    Lexer lexer;
    List<Token> tokens;
    CompoundUndoMan undo;
    private static final Logger log = Logger.getLogger(SyntaxDocument.class.getName());

    public SyntaxDocument(Lexer lexer) {
        this.putProperty("tabSize", 4);
        this.lexer = lexer;
        this.undo = new CompoundUndoMan(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        ArrayList<Token> arrayList;
        block6: {
            if (this.lexer == null) {
                this.tokens = null;
                return;
            }
            arrayList = new ArrayList<Token>(this.getLength() / 10);
            long l = System.nanoTime();
            int n = this.getLength();
            try {
                Segment segment = new Segment();
                this.getText(0, this.getLength(), segment);
                this.lexer.parse(segment, 0, arrayList);
                if (!log.isLoggable(Level.FINEST)) break block6;
            }
            catch (BadLocationException badLocationException) {
                block7: {
                    try {
                        log.log(Level.SEVERE, null, badLocationException);
                        if (!log.isLoggable(Level.FINEST)) break block7;
                    }
                    catch (Throwable throwable) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest(String.format("Parsed %d in %d ms, giving %d tokens\n", n, (System.nanoTime() - l) / 1000000L, arrayList.size()));
                        }
                        this.tokens = arrayList;
                        throw throwable;
                    }
                    log.finest(String.format("Parsed %d in %d ms, giving %d tokens\n", n, (System.nanoTime() - l) / 1000000L, arrayList.size()));
                }
                this.tokens = arrayList;
            }
            log.finest(String.format("Parsed %d in %d ms, giving %d tokens\n", n, (System.nanoTime() - l) / 1000000L, arrayList.size()));
        }
        this.tokens = arrayList;
    }

    @Override
    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        this.parse();
        super.fireChangedUpdate(documentEvent);
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        this.parse();
        super.fireInsertUpdate(documentEvent);
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        this.parse();
        super.fireRemoveUpdate(documentEvent);
    }

    public void replaceToken(Token token, String string) {
        try {
            this.replace(token.start, token.length, string, null);
        }
        catch (BadLocationException badLocationException) {
            log.log(Level.WARNING, "unable to replace token: " + token, badLocationException);
        }
    }

    public Iterator<Token> getTokens(int n, int n2) {
        return new TokenIterator(n, n2);
    }

    public Token getTokenAt(int n) {
        if (this.tokens == null || this.tokens.isEmpty() || n > this.getLength()) {
            return null;
        }
        Token token = null;
        Token token2 = new Token(TokenType.DEFAULT, n, 1);
        int n2 = Collections.binarySearch(this.tokens, token2);
        if (n2 < 0) {
            n2 = -n2 - 1 - 1 < 0 ? 0 : -n2 - 1 - 1;
            Token token3 = this.tokens.get(n2);
            if (token3.start <= n && n <= token3.end()) {
                token = token3;
            }
        } else {
            token = this.tokens.get(n2);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getWordAt(int n, Pattern pattern) {
        Token token = null;
        try {
            Element element = this.getParagraphElement(n);
            if (element == null) {
                Token token2 = token;
                return token2;
            }
            int n2 = element.getStartOffset();
            int n3 = Math.min(element.getEndOffset(), this.getLength());
            Segment segment = new Segment();
            this.getText(n2, n3 - n2, segment);
            if (segment.count > 0) {
                Matcher matcher = pattern.matcher(segment);
                int n4 = n - n2;
                while (matcher.find()) {
                    if (matcher.start() > n4 || n4 > matcher.end()) continue;
                    token = new Token(TokenType.DEFAULT, matcher.start() + n2, matcher.end() - matcher.start());
                    return token;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(SyntaxDocument.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
        finally {
            return token;
        }
    }

    public Token getNextToken(Token token) {
        int n = this.tokens.indexOf(token);
        if (n >= 0 && n < this.tokens.size() - 1) {
            return this.tokens.get(n + 1);
        }
        return null;
    }

    public Token getPrevToken(Token token) {
        int n = this.tokens.indexOf(token);
        if (n > 0 && !this.tokens.isEmpty()) {
            return this.tokens.get(n - 1);
        }
        return null;
    }

    public Token getPairFor(Token token) {
        if (token == null || token.pairValue == 0) {
            return null;
        }
        Token token2 = null;
        int n = this.tokens.indexOf(token);
        int n2 = token.pairValue;
        int n3 = token.pairValue > 0 ? 1 : -1;
        boolean bl = false;
        int n4 = Math.abs(token.pairValue);
        while (!bl && (n += n3) >= 0 && n < this.tokens.size()) {
            Token token3 = this.tokens.get(n);
            if (Math.abs(token3.pairValue) != n4 || (n2 += token3.pairValue) != 0) continue;
            token2 = token3;
            bl = true;
        }
        return token2;
    }

    public void doUndo() {
        if (this.undo.canUndo()) {
            this.undo.undo();
            this.parse();
        }
    }

    public void doRedo() {
        if (this.undo.canRedo()) {
            this.undo.redo();
            this.parse();
        }
    }

    public Matcher getMatcher(Pattern pattern) {
        return this.getMatcher(pattern, 0, this.getLength());
    }

    public Matcher getMatcher(Pattern pattern, int n) {
        return this.getMatcher(pattern, n, this.getLength() - n);
    }

    public Matcher getMatcher(Pattern pattern, int n, int n2) {
        Matcher matcher = null;
        if (this.getLength() == 0) {
            return null;
        }
        if (n >= this.getLength()) {
            return null;
        }
        try {
            if (n < 0) {
                n = 0;
            }
            if (n + n2 > this.getLength()) {
                n2 = this.getLength() - n;
            }
            Segment segment = new Segment();
            this.getText(n, n2, segment);
            matcher = pattern.matcher(segment);
        }
        catch (BadLocationException badLocationException) {
            log.log(Level.SEVERE, "Requested offset: " + badLocationException.offsetRequested(), badLocationException);
        }
        return matcher;
    }

    public void clearUndos() {
        this.undo.discardAllEdits();
    }

    public String getLineAt(int n) throws BadLocationException {
        Element element = this.getParagraphElement(n);
        Segment segment = new Segment();
        this.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset(), segment);
        char c = segment.last();
        if (c == '\n' || c == '\r') {
            --segment.count;
        }
        return segment.toString();
    }

    public void removeLineAt(int n) throws BadLocationException {
        Element element = this.getParagraphElement(n);
        this.remove(element.getStartOffset(), this.getElementLength(element));
    }

    public void replaceLineAt(int n, String string) throws BadLocationException {
        Element element = this.getParagraphElement(n);
        this.replace(element.getStartOffset(), this.getElementLength(element), string, null);
    }

    private int getElementLength(Element element) {
        int n = element.getEndOffset();
        if (n >= this.getLength() - 1) {
            --n;
        }
        return n - element.getStartOffset();
    }

    public synchronized String getUncommentedText(int n, int n2) {
        this.readLock();
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Token> iterator = this.getTokens(n, n2);
        while (iterator.hasNext()) {
            Token token = iterator.next();
            if (TokenType.isComment(token)) continue;
            stringBuilder.append(token.getText(this));
        }
        this.readUnlock();
        return stringBuilder.toString();
    }

    public int getLineStartOffset(int n) {
        return this.getParagraphElement(n).getStartOffset();
    }

    public int getLineEndOffset(int n) {
        int n2 = 0;
        n2 = this.getParagraphElement(n).getEndOffset();
        if (n2 >= this.getLength()) {
            n2 = this.getLength();
        }
        return n2;
    }

    public int getLineCount() {
        Element element = this.getDefaultRootElement();
        int n = element.getElementCount();
        return n;
    }

    public int getLineNumberAt(int n) {
        int n2 = this.getDefaultRootElement().getElementIndex(n);
        return n2;
    }

    public String toString() {
        return "SyntaxDocument(" + this.lexer + ", " + (this.tokens == null ? 0 : this.tokens.size()) + " tokens)@" + this.hashCode();
    }

    @Override
    public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        this.remove(n, n2);
        this.undo.startCombine();
        this.insertString(n, string, attributeSet);
    }

    public SyntaxDocument append(String string) {
        try {
            this.insertString(this.getLength(), string, null);
        }
        catch (BadLocationException badLocationException) {
            log.log(Level.WARNING, "Error appending str", badLocationException);
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TokenIterator
    implements ListIterator<Token> {
        int start;
        int end;
        int ndx = 0;

        private TokenIterator(int n, int n2) {
            this.start = n;
            this.end = n2;
            if (SyntaxDocument.this.tokens != null && !SyntaxDocument.this.tokens.isEmpty()) {
                Token token = new Token(TokenType.COMMENT, n, n2 - n);
                this.ndx = Collections.binarySearch(SyntaxDocument.this.tokens, token);
                if (this.ndx < 0) {
                    this.ndx = -this.ndx - 1 - 1 < 0 ? 0 : -this.ndx - 1 - 1;
                    Token token2 = SyntaxDocument.this.tokens.get(this.ndx);
                    if (token2.end() <= n) {
                        ++this.ndx;
                    }
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (SyntaxDocument.this.tokens == null) {
                return false;
            }
            if (this.ndx >= SyntaxDocument.this.tokens.size()) {
                return false;
            }
            Token token = SyntaxDocument.this.tokens.get(this.ndx);
            return token.start < this.end;
        }

        @Override
        public Token next() {
            return SyntaxDocument.this.tokens.get(this.ndx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            if (SyntaxDocument.this.tokens == null) {
                return false;
            }
            if (this.ndx <= 0) {
                return false;
            }
            Token token = SyntaxDocument.this.tokens.get(this.ndx);
            return token.end() > this.start;
        }

        @Override
        public Token previous() {
            return SyntaxDocument.this.tokens.get(this.ndx--);
        }

        @Override
        public int nextIndex() {
            return this.ndx + 1;
        }

        @Override
        public int previousIndex() {
            return this.ndx - 1;
        }

        @Override
        public void set(Token token) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Token token) {
            throw new UnsupportedOperationException();
        }
    }
}

