/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.SyntaxAction;
import jsyntaxpane.util.Configuration;
import jsyntaxpane.util.ReflectUtils;

public abstract class DefaultSyntaxAction
extends TextAction
implements SyntaxAction {
    public static final String ACTION_PREFIX = "Action.";
    public static final String SMALL_ICONS_LOC_PREFIX = "/META-INF/images/small-icons/";
    public static final String LARGE_ICONS_LOC_PREFIX = "/META-INF/images/large-icons/";

    public DefaultSyntaxAction(String string) {
        super(string);
        this.putValue("Name", string);
    }

    public void config(Configuration configuration, String string) {
        String string2 = string.substring(ACTION_PREFIX.length());
        for (Configuration.StringKeyMatcher stringKeyMatcher : configuration.getKeys(Pattern.compile(Pattern.quote(string) + "\\.((\\w|-)+)"))) {
            if (ReflectUtils.callSetter(this, stringKeyMatcher.group1, stringKeyMatcher.value)) continue;
            this.putValue(stringKeyMatcher.group1, stringKeyMatcher.value);
        }
        if (this.getValue("Name") == null) {
            this.putValue("Name", string2);
        }
        if (this.getValue("SmallIcon") == null) {
            this.setSmallIcon(string2 + ".png");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTextComponent jTextComponent = this.getTextComponent(actionEvent);
        SyntaxDocument syntaxDocument = ActionUtils.getSyntaxDocument(jTextComponent);
        if (jTextComponent != null) {
            this.actionPerformed(jTextComponent, syntaxDocument, jTextComponent.getCaretPosition(), actionEvent);
        }
    }

    public void actionPerformed(JTextComponent jTextComponent, SyntaxDocument syntaxDocument, int n, ActionEvent actionEvent) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String toString() {
        return "Action " + this.getValue("Name") + "of type " + this.getClass().getSimpleName();
    }

    public final void setMenuText(String string) {
        this.putValue("Name", string);
        if (this.getValue("ShortDescription") == null) {
            this.putValue("ShortDescription", string);
        }
    }

    public final void setToolTip(String string) {
        this.putValue("ShortDescription", string);
    }

    public final void setLargeIcon(String string) {
        URL uRL = this.getClass().getResource(LARGE_ICONS_LOC_PREFIX + string);
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            this.putValue("SwingLargeIconKey", imageIcon);
        }
    }

    public final void setSmallIcon(String string) {
        URL uRL = this.getClass().getResource(SMALL_ICONS_LOC_PREFIX + string);
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            this.putValue("SmallIcon", imageIcon);
        }
    }
}

