/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.components;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;

public class Markers {
    private static final Logger LOG = Logger.getLogger(Markers.class.getName());

    public static void removeMarkers(JTextComponent jTextComponent, SimpleMarker simpleMarker) {
        Highlighter highlighter = jTextComponent.getHighlighter();
        Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
        for (int i = 0; i < highlightArray.length; ++i) {
            if (!(highlightArray[i].getPainter() instanceof SimpleMarker)) continue;
            SimpleMarker simpleMarker2 = (SimpleMarker)highlightArray[i].getPainter();
            if (simpleMarker != null && !simpleMarker2.equals(simpleMarker)) continue;
            highlighter.removeHighlight(highlightArray[i]);
        }
    }

    public static void removeMarkers(JTextComponent jTextComponent) {
        Markers.removeMarkers(jTextComponent, null);
    }

    public static void markToken(JTextComponent jTextComponent, Token token, SimpleMarker simpleMarker) {
        Markers.markText(jTextComponent, token.start, token.end(), simpleMarker);
    }

    public static void markText(JTextComponent jTextComponent, int n, int n2, SimpleMarker simpleMarker) {
        try {
            Highlighter highlighter = jTextComponent.getHighlighter();
            int n3 = jTextComponent.getSelectionStart();
            int n4 = jTextComponent.getSelectionEnd();
            if (n3 == n4 || n2 < n3 || n > n3) {
                highlighter.addHighlight(n, n2, simpleMarker);
                return;
            }
            if (n3 > n && n3 < n2) {
                highlighter.addHighlight(n, n3, simpleMarker);
            }
            if (n4 > n && n4 < n2) {
                highlighter.addHighlight(n4, n2, simpleMarker);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.SEVERE, null, badLocationException);
        }
    }

    public static void markAll(JTextComponent jTextComponent, Pattern pattern, SimpleMarker simpleMarker) {
        SyntaxDocument syntaxDocument = ActionUtils.getSyntaxDocument(jTextComponent);
        if (syntaxDocument == null || pattern == null) {
            return;
        }
        Matcher matcher = syntaxDocument.getMatcher(pattern);
        if (matcher == null) {
            return;
        }
        while (matcher.find()) {
            Markers.markText(jTextComponent, matcher.start(), matcher.end(), simpleMarker);
        }
    }

    public static class SimpleMarker
    extends DefaultHighlighter.DefaultHighlightPainter {
        public SimpleMarker(Color color) {
            super(color);
        }
    }
}

