/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.svg;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.export.mindmapmode.ExportController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.svg.ExportVectorGraphic;
import org.freeplane.view.swing.map.MapView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ExportPdf
extends ExportVectorGraphic {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(MapModel map, File chosenFile) {
        if (!ExportController.getContoller().checkCurrentMap(map)) {
            return;
        }
        try {
            MapView view = (MapView)Controller.getCurrentController().getMapViewManager().getMapViewComponent();
            if (view == null) {
                return;
            }
            Controller.getCurrentController().getViewController().setWaitingCursor(true);
            SVGGraphics2D g2d = this.fillSVGGraphics2D(view);
            PDFTranscoder pdfTranscoder = new PDFTranscoder();
            pdfTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_HEIGHT, (Object)new Float(19200.0f));
            pdfTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_WIDTH, (Object)new Float(19200.0f));
            pdfTranscoder.addTranscodingHint(ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)Float.valueOf(0.35277778f / UITools.FONT_SCALE_FACTOR));
            Document doc = g2d.getDOMFactory();
            Element rootE = doc.getDocumentElement();
            g2d.getRoot(rootE);
            TranscoderInput input = new TranscoderInput(doc);
            FileOutputStream ostream = new FileOutputStream(chosenFile);
            BufferedOutputStream bufStream = new BufferedOutputStream(ostream);
            TranscoderOutput output = new TranscoderOutput((OutputStream)bufStream);
            pdfTranscoder.transcode(input, output);
            ostream.flush();
            ostream.close();
        }
        catch (Exception ex) {
            LogUtils.warn((Throwable)ex);
            UITools.errorMessage((Object)ex.getLocalizedMessage());
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }
}

