/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.io;

import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.util.Quantity;
import org.freeplane.features.map.MapWriter;

public class BackwardCompatibleQuantityWriter {
    private final ITreeWriter writer;
    private final boolean makeCompatible;

    public static BackwardCompatibleQuantityWriter forWriter(ITreeWriter writer) {
        Object hint = writer.getHint(BackwardCompatibleQuantityWriter.class);
        if (Boolean.FALSE.equals(hint)) {
            boolean makeCompatible = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
            BackwardCompatibleQuantityWriter quantityWriter = new BackwardCompatibleQuantityWriter(writer, makeCompatible);
            writer.setHint(BackwardCompatibleQuantityWriter.class, quantityWriter);
            return quantityWriter;
        }
        return (BackwardCompatibleQuantityWriter)hint;
    }

    public BackwardCompatibleQuantityWriter(ITreeWriter writer, boolean makeCompatible) {
        this.writer = writer;
        this.makeCompatible = makeCompatible;
    }

    public void writeQuantity(String name, Quantity<LengthUnits> value) {
        if (this.makeCompatible) {
            this.writer.addAttribute(name, value.toBaseUnitsRounded());
            this.writer.addAttribute(name + "_QUANTITY", value.toString());
        } else {
            this.writer.addAttribute(name, value.toString());
        }
    }
}

