/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.freeplane.core.resources.components.IKeystrokeValidator;
import org.freeplane.core.resources.components.KeyEventTranslator;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;

public class GrabKeyDialog
extends JDialog {
    public static final String MODIFIER_SEPARATOR = " ";
    private static final long serialVersionUID = 1L;
    private JLabel assignedTo;
    private JButton cancel;
    private JButton clear;
    private boolean isOK;
    private int modifierMask;
    private JButton ok;
    private InputPane shortcut;
    private IKeystrokeValidator validator;

    private static String getText(String resourceString) {
        return TextUtils.getText("GrabKeyDialog." + resourceString);
    }

    public static String toString(KeyEvent evt) {
        String id;
        switch (evt.getID()) {
            case 401: {
                id = "KEY_PRESSED";
                break;
            }
            case 402: {
                id = "KEY_RELEASED";
                break;
            }
            case 400: {
                id = "KEY_TYPED";
                break;
            }
            default: {
                id = "unknown type";
            }
        }
        return id + ",keyCode=0x" + Integer.toString(evt.getKeyCode(), 16) + ",keyChar=0x" + Integer.toString(evt.getKeyChar(), 16) + ",modifiers=0x" + Integer.toString(evt.getModifiers(), 16);
    }

    public Character getKeyChar() {
        return this.shortcut.getKeyChar();
    }

    public GrabKeyDialog(String input, int modifierMask) {
        super((Window)UITools.getMenuComponent(), Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(GrabKeyDialog.getText("grab-key.title"));
        this.init(input, modifierMask);
    }

    public GrabKeyDialog(String input) {
        this(input, 0);
    }

    public boolean canClose(KeyStroke ks) {
        return this.validator == null || this.validator.isValid(ks, this.getKeyChar());
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public String getShortcut() {
        if (this.isOK) {
            return this.shortcut.getText();
        }
        return null;
    }

    private String getSymbolicName(int keyCode) {
        if (keyCode == 0) {
            return null;
        }
        if (keyCode >= 65 && keyCode <= 90) {
            return String.valueOf(Character.toLowerCase((char)keyCode));
        }
        try {
            Field[] fields = KeyEvent.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                String name = field.getName();
                if (!name.startsWith("VK_") || field.getInt(null) != keyCode) continue;
                return name.substring(3);
            }
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
        return null;
    }

    public IKeystrokeValidator getValidator() {
        return this.validator;
    }

    private void init(String inputText, int modifierMask) {
        this.modifierMask = modifierMask;
        this.enableEvents(8L);
        JPanel content = new JPanel(new GridLayout(0, 1, 0, 6)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean getFocusTraversalKeysEnabled() {
                return false;
            }

            @Override
            public boolean isManagingFocus() {
                return false;
            }
        };
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        Box input = Box.createHorizontalBox();
        this.shortcut = new InputPane();
        if (inputText != null) {
            this.shortcut.setText(inputText);
        }
        input.add(this.shortcut);
        input.add(Box.createHorizontalStrut(12));
        this.clear = new JButton(GrabKeyDialog.getText("grab-key.clear"));
        this.clear.addActionListener(new ActionHandler());
        input.add(this.clear);
        this.shortcut.setPreferredSize(new Dimension(200, this.clear.getPreferredSize().height));
        this.assignedTo = new JLabel();
        this.updateAssignedTo(null);
        Box buttons = Box.createHorizontalBox();
        buttons.add(Box.createGlue());
        this.ok = new JButton(GrabKeyDialog.getText("common.ok"));
        this.ok.addActionListener(new ActionHandler());
        buttons.add(this.ok);
        buttons.add(Box.createHorizontalStrut(12));
        this.cancel = new JButton(GrabKeyDialog.getText("common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        buttons.add(this.cancel);
        buttons.add(Box.createGlue());
        content.add(input);
        content.add(buttons);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean isOK() {
        return this.isOK;
    }

    @Override
    protected void processKeyEvent(KeyEvent evt) {
        this.shortcut.processKeyEvent(evt);
    }

    public void setValidator(IKeystrokeValidator validator) {
        this.validator = validator;
    }

    private void updateAssignedTo(String shortcut) {
        String text = GrabKeyDialog.getText("grab-key.assigned-to.none");
        if (this.ok != null) {
            this.ok.setEnabled(true);
        }
        this.assignedTo.setText(GrabKeyDialog.getText("grab-key.assigned-to") + MODIFIER_SEPARATOR + text);
    }

    class InputPane
    extends JTextField {
        private static final long serialVersionUID = 1L;
        private Character keyChar = null;

        InputPane() {
        }

        @Override
        public boolean getFocusTraversalKeysEnabled() {
            return false;
        }

        private int getModifierMask() {
            return GrabKeyDialog.this.modifierMask;
        }

        @Override
        protected void processKeyEvent(KeyEvent evt) {
            if (401 != evt.getID()) {
                return;
            }
            if ((this.getModifierMask() & evt.getModifiers()) != 0) {
                KeyEvent evt2 = new KeyEvent(evt.getComponent(), evt.getID(), evt.getWhen(), ~this.getModifierMask() & evt.getModifiers(), evt.getKeyCode(), evt.getKeyChar(), evt.getKeyLocation());
                this.processKeyEvent(evt2);
                if (evt2.isConsumed()) {
                    evt.consume();
                }
                return;
            }
            int keyCode = evt.getKeyCode();
            switch (keyCode) {
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: {
                    return;
                }
                case 0: {
                    if (evt.getKeyChar() != '\uffff' && evt.getKeyChar() != '\u0000') break;
                    return;
                }
                case 524: {
                    if (!Compat.isWindowsOS()) break;
                    return;
                }
                case 18: {
                    KeyEventTranslator.modifiers |= 8;
                    return;
                }
                case 65406: {
                    KeyEventTranslator.modifiers |= 0x20;
                    return;
                }
                case 17: {
                    KeyEventTranslator.modifiers |= 2;
                    return;
                }
                case 16: {
                    KeyEventTranslator.modifiers |= 1;
                    return;
                }
                case 157: {
                    KeyEventTranslator.modifiers |= 4;
                    return;
                }
            }
            evt.consume();
            KeyEventTranslator.Key key = KeyEventTranslator.translateKeyEvent(evt);
            if (key == null) {
                return;
            }
            this.keyChar = Character.valueOf(key.input);
            StringBuilder keyString = new StringBuilder();
            if (key.modifiers != null) {
                keyString.append(key.modifiers).append(' ');
            }
            if (key.input == ' ') {
                keyString.append("SPACE");
            } else if (key.key == 0) {
                keyString.append(key.input);
            } else {
                String symbolicName = GrabKeyDialog.this.getSymbolicName(key.key);
                if (symbolicName == null) {
                    return;
                }
                keyString.append(symbolicName);
            }
            this.setText(keyString.toString());
            GrabKeyDialog.this.updateAssignedTo(keyString.toString());
        }

        public Character getKeyChar() {
            return this.keyChar;
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == GrabKeyDialog.this.ok) {
                if (GrabKeyDialog.this.shortcut.keyChar == null) {
                    GrabKeyDialog.this.isOK = false;
                    GrabKeyDialog.this.dispose();
                } else if (GrabKeyDialog.this.canClose(UITools.getKeyStroke(GrabKeyDialog.this.shortcut.getText()))) {
                    GrabKeyDialog.this.isOK = true;
                    GrabKeyDialog.this.dispose();
                }
            } else if (evt.getSource() == GrabKeyDialog.this.cancel) {
                GrabKeyDialog.this.dispose();
            } else if (evt.getSource() == GrabKeyDialog.this.clear) {
                GrabKeyDialog.this.shortcut.keyChar = Character.valueOf('\uffff');
                GrabKeyDialog.this.shortcut.setText(null);
                GrabKeyDialog.this.shortcut.requestFocus();
            }
        }
    }
}

