/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.dpolivaev.mnemonicsetter.MnemonicSetter;
import org.freeplane.core.ui.MenuSplitterConfiguration;
import org.freeplane.core.util.Compat;

public class MenuSplitter {
    private static final String EXTRA_SUBMENU = MenuSplitter.class.getName() + ".extra_submenu";
    static final int MAX_HEIGHT = !GraphicsEnvironment.isHeadless() ? Toolkit.getDefaultToolkit().getScreenSize().height - 100 : 0;
    public static int count = 0;
    private final int maxMenuItemCount;

    public MenuSplitter(int maxMenuItemCount) {
        this.maxMenuItemCount = maxMenuItemCount;
    }

    public MenuSplitter() {
        this(MenuSplitterConfiguration.MAX_MENU_ITEM_COUNT);
    }

    public void addComponent(Container container, Component component) {
        if (container instanceof JMenu) {
            this.addMenuComponent((JMenu)container, component);
        } else {
            container.add(component);
        }
    }

    public void addMenuComponent(JMenu menu, Component component, int index) {
        JPopupMenu popupMenu = menu.getPopupMenu();
        int itemCount = popupMenu.getComponentCount();
        if (index == 0 || index < itemCount) {
            popupMenu.insert(component, index);
        } else {
            Component lastMenuItem = popupMenu.getComponent(itemCount - 1);
            boolean extraSubMenu = this.isExtraSubMenu(lastMenuItem);
            if (extraSubMenu || !this.fitsOnScreen(popupMenu, component)) {
                JMenu submenu;
                if (extraSubMenu) {
                    submenu = (JMenu)lastMenuItem;
                } else {
                    if (component instanceof JPopupMenu.Separator) {
                        return;
                    }
                    submenu = new JMenu("-");
                    submenu.putClientProperty(EXTRA_SUBMENU, Boolean.TRUE);
                    popupMenu.add(submenu);
                    if (!Compat.isMacOsX()) {
                        submenu.getPopupMenu().addPopupMenuListener(MnemonicSetter.INSTANCE);
                    }
                }
                this.addMenuComponent(submenu, component, submenu.getPopupMenu().getComponentCount());
            } else {
                popupMenu.insert(component, index);
            }
        }
    }

    public void removeMenuComponent(Component component) {
        Container parent = component.getParent();
        if (parent != null) {
            Component invoker;
            parent.remove(component);
            if (parent instanceof JPopupMenu && this.isExtraSubMenu(invoker = ((JPopupMenu)parent).getInvoker()) && parent.getComponentCount() == 0) {
                this.removeMenuComponent(invoker);
            }
        }
    }

    private boolean fitsOnScreen(JPopupMenu popupMenu, Component component) {
        int itemCount = popupMenu.getComponentCount();
        return itemCount < this.getMaxMenuItemCount() && popupMenu.getPreferredSize().height + component.getPreferredSize().height < MAX_HEIGHT;
    }

    protected int getMaxMenuItemCount() {
        return this.maxMenuItemCount;
    }

    public boolean hasExtraSubMenu(JMenu menu) {
        Component lastComponent = menu.getComponent(menu.getComponentCount() - 1);
        return this.isExtraSubMenu(lastComponent);
    }

    public boolean isExtraSubMenu(Component c) {
        return c instanceof JMenu && Boolean.TRUE.equals(((JMenu)c).getClientProperty(EXTRA_SUBMENU));
    }

    public JMenu getExtraSubMenu(JMenu parentComponent) {
        Component lastComponent = parentComponent.getComponent(parentComponent.getComponentCount() - 1);
        if (this.isExtraSubMenu(lastComponent)) {
            return (JMenu)lastComponent;
        }
        return null;
    }

    public void addMenuComponent(JMenu menu, Component component) {
        this.addMenuComponent(menu, component, menu.getPopupMenu().getComponentCount());
    }
}

