/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.net.URI;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.freeplane.core.ui.components.ObjectAndIcon;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.ui.FrameController;

public class TypedListCellRenderer
extends DefaultListCellRenderer {
    private static final TypedListCellRenderer instance = new TypedListCellRenderer();
    private static final long serialVersionUID = 1L;

    static TypedListCellRenderer getInstance() {
        return instance;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof String) {
            this.setIcon(FrameController.textIcon);
        } else if (value instanceof FormattedDate) {
            FormattedDate fd = (FormattedDate)value;
            if (fd.containsTime()) {
                this.setIcon(FrameController.dateTimeIcon);
            } else {
                this.setIcon(FrameController.dateIcon);
            }
        } else if (value instanceof URI) {
            this.setIcon(FrameController.linkIcon);
        } else if (value instanceof Number) {
            this.setIcon(FrameController.numberIcon);
        } else if (value instanceof ObjectAndIcon) {
            this.setIcon(((ObjectAndIcon)value).getIcon());
        }
        return this;
    }
}

