/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import org.freeplane.core.util.TypeReference;
import org.freeplane.core.util.collection.SortedComboBoxModel;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.n3.nanoxml.XMLElement;

public class AttributeRegistryElement {
    private boolean isManual;
    private boolean isRestricted;
    private boolean isVisible;
    private String key;
    private final AttributeRegistry registry;
    private Boolean restrictionModel;
    private final RegisteredAttributeValues values;
    private Boolean visibilityModel;

    public AttributeRegistryElement(AttributeRegistry registry, String key) {
        this.key = key;
        this.registry = registry;
        this.values = new RegisteredAttributeValues();
        this.isVisible = false;
        this.visibilityModel = this.isVisible;
        this.isRestricted = false;
        this.isManual = false;
        this.restrictionModel = this.isRestricted;
    }

    public void addValue(Object s) {
        this.values._add(s);
        this.registry.fireAttributesChanged();
    }

    public Comparable<?> getKey() {
        return this.key;
    }

    Boolean getRestriction() {
        return this.restrictionModel;
    }

    public SortedComboBoxModel getValues() {
        return this.values;
    }

    Boolean getVisibilityModel() {
        return this.visibilityModel;
    }

    public boolean isManual() {
        return this.isManual;
    }

    public boolean isRestricted() {
        return this.isRestricted;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void removeAllValues() {
        this.values.clear();
        this.registry.fireAttributesChanged();
    }

    public void removeValue(Object s) {
        this.values._remove(s);
        this.registry.fireAttributesChanged();
    }

    public void replaceValue(String oldValue, String newValue) {
        this.values._replace(oldValue, newValue);
        this.registry.fireAttributesChanged();
    }

    public XMLElement save() {
        XMLElement element = new XMLElement();
        if (this.isVisible()) {
            element.setAttribute("VISIBLE", "true");
        }
        if (this.isManual()) {
            element.setAttribute("MANUAL", "true");
        }
        if (this.isRestricted()) {
            element.setAttribute("RESTRICTED", "true");
        }
        if (this.isManual() || this.isRestricted()) {
            for (int i = 0; i < this.values.getSize(); ++i) {
                XMLElement xmlValue = new XMLElement();
                xmlValue.setName("attribute_value");
                Object value = this.values.getElementAt(i);
                String string = value.toString();
                xmlValue.setAttribute("VALUE", string);
                if (!(value instanceof String)) {
                    String spec = TypeReference.toSpec(value);
                    xmlValue.setAttribute("OBJECT", spec);
                }
                element.addChild(xmlValue);
            }
        }
        element.setName("attribute_name");
        element.setAttribute("NAME", this.key.toString());
        return element;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setManual(boolean isManual) {
        this.isManual = isManual;
    }

    public void setRestriction(boolean isRestricted) {
        this.isRestricted = isRestricted;
        this.restrictionModel = isRestricted;
        this.registry.fireAttributesChanged();
    }

    void setRestrictionModel(Boolean restrictionModel) {
        this.restrictionModel = restrictionModel;
    }

    public void setVisibility(boolean isVisible) {
        if (this.isVisible != isVisible) {
            this.isVisible = isVisible;
            this.visibilityModel = isVisible;
            if (isVisible) {
                this.registry.incrementVisibleElementsNumber();
            } else {
                this.registry.decrementVisibleElementsNumber();
            }
            this.registry.fireAttributeLayoutChanged();
        }
    }

    void setVisibilityModel(Boolean visibilityModel) {
        this.visibilityModel = visibilityModel;
    }

    private class RegisteredAttributeValues
    extends SortedComboBoxModel {
        private static final long serialVersionUID = 1L;

        private RegisteredAttributeValues() {
        }

        public void _add(Object element) {
            super.add(element);
        }

        public void _remove(Object element) {
            super.remove(element);
        }

        public void _replace(Object oldO, Object newO) {
            super.replace(oldO, newO);
        }

        @Override
        public void add(Object element) {
            AttributeRegistryElement.this.registry.getAttributeController().performRegistryAttributeValue(this.getKey(), element.toString(), true);
        }

        public String getKey() {
            return AttributeRegistryElement.this.key;
        }

        @Override
        public void remove(Object element) {
            AttributeRegistryElement.this.registry.getAttributeController().performRemoveAttributeValue(this.getKey(), element.toString());
        }

        @Override
        public void replace(Object oldO, Object newO) {
            AttributeRegistryElement.this.registry.getAttributeController().performReplaceAttributeValue(this.getKey(), oldO.toString(), newO.toString());
        }
    }
}

