/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.util.LinkedList;
import java.util.ListIterator;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

class FoundNodes
implements IExtension {
    String rootID;
    final LinkedList<String> nodesUnfoldedByDisplay = new LinkedList();
    ASelectableCondition condition;

    FoundNodes() {
    }

    static FoundNodes get(MapModel map) {
        if (map == null) {
            return null;
        }
        FoundNodes nodes = map.getExtension(FoundNodes.class);
        if (nodes == null) {
            nodes = new FoundNodes();
            map.addExtension(nodes);
        }
        return nodes;
    }

    void displayFoundNode(NodeModel node) {
        String oldPathNodeID;
        NodeModel oldPathNode;
        MapModel map = node.getMap();
        LinkedList<String> nodesUnfoldedByDisplay = new LinkedList<String>();
        NodeModel nodeOnPath = null;
        for (nodeOnPath = node; nodeOnPath != null && !this.nodesUnfoldedByDisplay.contains(nodeOnPath.createID()); nodeOnPath = nodeOnPath.getParentNode()) {
            if (!Controller.getCurrentModeController().getMapController().isFolded(nodeOnPath)) continue;
            nodesUnfoldedByDisplay.add(nodeOnPath.createID());
        }
        ListIterator<String> oldPathIterator = this.nodesUnfoldedByDisplay.listIterator(this.nodesUnfoldedByDisplay.size());
        while (oldPathIterator.hasPrevious() && ((oldPathNode = map.getNodeForID(oldPathNodeID = oldPathIterator.previous())) == null || !oldPathNode.equals(nodeOnPath))) {
            oldPathIterator.remove();
            if (oldPathNode == null) continue;
            Controller.getCurrentModeController().getMapController().setFolded(oldPathNode, true);
        }
        this.nodesUnfoldedByDisplay.addAll(nodesUnfoldedByDisplay);
        Controller.getCurrentModeController().getMapController().select(node);
    }
}

