/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.format;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.FormatUtils;
import org.freeplane.features.format.Parser;
import org.freeplane.features.format.Scanner;
import org.freeplane.features.mode.Controller;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLParserFactory;
import org.freeplane.n3.nanoxml.XMLWriter;

public class ScannerController
implements IExtension,
IFreeplanePropertyListener {
    private static final String SCANNER_XML = "scanner.xml";
    private static final String ROOT_ELEMENT = "scanners";
    private String pathToFile;
    private Scanner selectedScanner;
    private static List<Scanner> scanners = new ArrayList<Scanner>();
    private static boolean scannersLoaded;

    public ScannerController() {
        String freeplaneUserDirectory = ResourceController.getResourceController().getFreeplaneUserDirectory();
        this.pathToFile = freeplaneUserDirectory == null ? null : freeplaneUserDirectory + File.separator + SCANNER_XML;
        this.initScanners();
        this.selectScanner(FormatUtils.getFormatLocaleFromResources());
        this.addParsersForStandardFormats();
        ResourceController resourceController = ResourceController.getResourceController();
        resourceController.addPropertyChangeListener(this);
    }

    public static ScannerController getController() {
        return ScannerController.getController(Controller.getCurrentController());
    }

    public static ScannerController getController(Controller controller) {
        return controller.getExtension(ScannerController.class);
    }

    public static void install(ScannerController scannerController) {
        Controller.getCurrentController().addExtension(ScannerController.class, scannerController);
    }

    public void selectScanner(Locale locale) {
        this.selectedScanner = this.findScanner(locale);
    }

    public Object parse(String string) {
        return this.selectedScanner.parse(string);
    }

    private Scanner findScanner(Locale locale) {
        String localeAsString = locale.toString();
        Scanner countryScanner = null;
        Scanner defaultScanner = null;
        for (Scanner scanner : scanners) {
            if (scanner.localeMatchesExactly(localeAsString)) {
                return scanner;
            }
            if (localeAsString.contains("_") && scanner.countryMatches(localeAsString)) {
                countryScanner = scanner;
                continue;
            }
            if (!scanner.isDefault()) continue;
            defaultScanner = scanner;
        }
        return countryScanner == null ? defaultScanner : countryScanner;
    }

    private Scanner findGoodMatch(Locale locale) {
        String localeAsString = locale.toString();
        Scanner countryScanner = null;
        for (Scanner scanner : scanners) {
            if (scanner.localeMatchesExactly(localeAsString)) {
                return scanner;
            }
            if (!localeAsString.contains("_") || !scanner.countryMatches(localeAsString)) continue;
            countryScanner = scanner;
        }
        return countryScanner;
    }

    private void initScanners() {
        if (scannersLoaded) {
            return;
        }
        scannersLoaded = true;
        try {
            if (this.pathToFile != null) {
                this.loadScanners();
            }
        }
        catch (Exception e) {
            LogUtils.warn(e);
            UITools.errorMessage(TextUtils.getText("scanners_not_loaded"));
        }
        this.addAndSaveStandardScanners();
    }

    public void addParsersForStandardFormats() {
        String standardDateTimeFormat;
        HashSet<String> patterns = new HashSet<String>();
        List<Parser> parsers = this.selectedScanner.getParsers();
        for (Parser parser : parsers) {
            patterns.add(parser.getFormat());
        }
        String standardDateFormat = FormatController.getController().getDefaultDateFormat().toPattern();
        if (!patterns.contains(standardDateFormat)) {
            this.selectedScanner.addParser(Parser.createParser("date", "datetime", standardDateFormat, Locale.getDefault(), "STANDARD FORMAT"));
            LogUtils.info("added parsing support for standard date format " + standardDateFormat);
        }
        if (!patterns.contains(standardDateTimeFormat = FormatController.getController().getDefaultDateTimeFormat().toPattern())) {
            this.selectedScanner.addParser(Parser.createParser("date", "datetime", standardDateTimeFormat, Locale.getDefault(), "STANDARD FORMAT"));
            LogUtils.info("added parsing support for standard date time format " + standardDateTimeFormat);
        }
    }

    private void addAndSaveStandardScanners() {
        int originalCount = scanners.size();
        if (this.findGoodMatch(new Locale("en")) == null) {
            scanners.add(this.createScanner_en());
        }
        if (this.findGoodMatch(new Locale("de")) == null) {
            scanners.add(this.createScanner_de());
        }
        if (this.findGoodMatch(new Locale("hr")) == null) {
            scanners.add(this.createScanner_hr());
        }
        if (this.findGoodMatch(Locale.getDefault()) == null) {
            String shortLocale = Locale.getDefault().toString().replaceAll("(.*_.*)_.*", "$1");
            scanners.add(this.createScanner(new Locale(shortLocale)));
        }
        if (scanners.size() != originalCount) {
            this.saveScannersNoThrow();
        }
    }

    private Scanner createScanner_en() {
        Scanner s = new Scanner(new String[]{"en"}, true);
        s.setFirstChars("+-0123456789.");
        String tNumber = "number";
        String tDate = "datetime";
        Locale loc = new Locale("en");
        s.addParser(Parser.createParser("decimal", "number", null, loc, "supports locale specific numbers"));
        s.addParser(Parser.createParser("isodate", "datetime", null, loc, "ISO reader for date and date/time"));
        s.addParser(Parser.createParser("date", "datetime", "M/d", loc, "completes date with current year"));
        s.addParser(Parser.createParser("date", "datetime", "M/d/y", loc, "parses 4/21/11 or 4/21/2011"));
        s.addParser(Parser.createParser("date", "datetime", "M/d/y H:m", loc, "parses datetime"));
        s.addParser(Parser.createParser("date", "datetime", "M/d/y H:m:s", loc, "parses datetime"));
        s.addParser(Parser.createParser("date", "datetime", "H:m", loc, "parses time, sets date to today"));
        return s;
    }

    private Scanner createScanner_de() {
        Scanner s = new Scanner(new String[]{"de"}, false);
        s.setFirstChars("+-0123456789,.");
        String tNumber = "number";
        String tDate = "datetime";
        Locale loc = new Locale("de");
        s.addParser(Parser.createParser("date", "datetime", "d.M", loc, "completes date with current year"));
        s.addParser(Parser.createParser("date", "datetime", "d.M.y", loc, "parses 21.4.11 or 21.4.2011"));
        s.addParser(Parser.createParser("date", "datetime", "d.M.y H:m", loc, "parses datetime"));
        s.addParser(Parser.createParser("date", "datetime", "d.M.y H:m:s", loc, "parses datetime"));
        s.addParser(Parser.createParser("date", "datetime", "H:m", loc, "parses time, sets date to today"));
        s.addParser(Parser.createParser("decimal", "number", null, loc, "uses comma as decimal separator: 1.234,12"));
        s.addParser(Parser.createParser("isodate", "datetime", null, loc, "ISO reader for date and date/time"));
        s.addParser(Parser.createParser("numberliteral", "number", null, loc, "support dot as decimal separator (if nothing else matches)"));
        return s;
    }

    private Scanner createScanner_hr() {
        Scanner s = new Scanner(new String[]{"hr"}, false);
        s.setFirstChars("+-0123456789,.");
        String tNumber = "number";
        String tDate = "datetime";
        Locale loc = new Locale("hr");
        s.addParser(Parser.createParser("date", "datetime", "d.M", loc, "completes date with current year"));
        s.addParser(Parser.createParser("date", "datetime", "d.M.y", loc, "parses 21.4.11 or 21.4.2011"));
        s.addParser(Parser.createParser("date", "datetime", "d.M.y.", loc, "parses 21.4.11. or 21.4.2011."));
        s.addParser(Parser.createParser("date", "datetime", "d.M.y. H:m.", loc, "parses datetime"));
        s.addParser(Parser.createParser("date", "datetime", "d.M.y. H:m:s", loc, "parses datetime"));
        s.addParser(Parser.createParser("date", "datetime", "H:m", loc, "parses time, sets date to today"));
        s.addParser(Parser.createParser("decimal", "number", null, loc, "uses comma as decimal separator: 1.234,12"));
        s.addParser(Parser.createParser("isodate", "datetime", null, loc, "ISO reader for date and date/time"));
        s.addParser(Parser.createParser("numberliteral", "number", null, loc, "support dot as decimal separator (if nothing else matches)"));
        return s;
    }

    private Scanner createScanner(Locale loc) {
        DateFormat shortDateFormat;
        Scanner s = new Scanner(new String[]{loc.toString()}, false);
        s.setFirstChars("+-0123456789,.");
        String tNumber = "number";
        String tDate = "datetime";
        DateFormat shortDateTimeFormat = SimpleDateFormat.getDateTimeInstance(3, 3, loc);
        if (shortDateTimeFormat instanceof SimpleDateFormat) {
            s.addParser(Parser.createParser("date", "datetime", ((SimpleDateFormat)shortDateTimeFormat).toPattern(), loc, "short datetime format"));
        }
        if ((shortDateFormat = SimpleDateFormat.getDateInstance(3, loc)) instanceof SimpleDateFormat) {
            s.addParser(Parser.createParser("date", "datetime", ((SimpleDateFormat)shortDateFormat).toPattern(), loc, "short date format"));
        }
        s.addParser(Parser.createParser("decimal", "number", null, loc, "number format"));
        s.addParser(Parser.createParser("isodate", "datetime", null, loc, "ISO reader for date and date/time"));
        s.addParser(Parser.createParser("numberliteral", "number", null, loc, "support dot as decimal separator (if nothing else matches)"));
        return s;
    }

    void loadScanners() throws Exception {
        File configXml = new File(this.pathToFile);
        if (!configXml.exists()) {
            LogUtils.info(this.pathToFile + " does not exist yet");
            return;
        }
        try {
            IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
            StdXMLReader reader = new StdXMLReader(new BufferedInputStream(new FileInputStream(configXml)));
            parser.setReader(reader);
            XMLElement loader = (XMLElement)parser.parse();
            Vector<XMLElement> scannerElements = loader.getChildren();
            for (XMLElement elem : scannerElements) {
                scanners.add(this.parseScanner(elem));
            }
            boolean haveDefault = false;
            for (Scanner scanner : scanners) {
                if (!scanner.isDefault()) continue;
                if (haveDefault) {
                    LogUtils.warn(configXml + ": multiple scanners are marked as default - fix that!");
                    continue;
                }
                haveDefault = true;
            }
            if (!haveDefault) {
                LogUtils.warn(configXml + ": no scanner is marked as default - fix that!");
            }
        }
        catch (IOException e) {
            LogUtils.warn("error parsing " + configXml, e);
        }
    }

    private Scanner parseScanner(XMLElement elem) {
        String locales = elem.getAttribute("locale", "");
        String isDefault = elem.getAttribute("default", "false");
        if (StringUtils.isEmpty((String)locales)) {
            throw new RuntimeException("wrong scanner in " + this.pathToFile + ": none of the following must be empty: locales=" + locales + ".");
        }
        Scanner scanner = new Scanner(locales.trim().split(","), Boolean.parseBoolean(isDefault));
        Locale locale = new Locale(scanner.getLocales().get(0));
        for (XMLElement child : elem.getChildren()) {
            if (child.getName().equals("checkfirstchar")) {
                String chars = elem.getAttribute("chars", "");
                boolean disabled = Boolean.parseBoolean(elem.getAttribute("disabled", "false"));
                if (disabled) continue;
                scanner.setFirstChars(chars);
                continue;
            }
            if (!child.getName().equals("parser")) continue;
            scanner.addParser(this.parseParser(child, locale));
        }
        return scanner;
    }

    private Parser parseParser(XMLElement elem, Locale locale) {
        String type = elem.getAttribute("type", null);
        String style = elem.getAttribute("style", null);
        String format = elem.getAttribute("format", null);
        String comment = elem.getAttribute("comment", null);
        return Parser.createParser(style, type, format, locale, comment);
    }

    private void saveScannersNoThrow() {
        try {
            this.saveScanners(scanners);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception e) {
            LogUtils.warn("cannot save create " + this.pathToFile, e);
        }
    }

    private void saveScanners(List<Scanner> scanners) throws IOException {
        XMLElement saver = new XMLElement();
        saver.setName(ROOT_ELEMENT);
        String sep = System.getProperty("line.separator");
        String description = this.commentLines("Description:", "", "<scanner> Scanners are locale dependent. If there is no scanner for", "the selected locale the scanner marked with default=\"true\" is choosen.", " 'locales': A comma-separated list of locale names.", "   The locale is selected via Preferences -> Environment -> Language", "   It's a pattern like 'en' (generic English) or 'en_US'", "   (English/USA). Use the more general two-letter form if appropriate.", " 'default': Set to \"true\" for only one locale. The standard is 'en'.", "", "<checkfirstchar> allows to enable a fast check for the first input", "character. If the first input character is not contained in the string", "given in attribute 'chars' no further attempts are made to parse the", "input as a number or date.", "Do not use this option if you have have scanner formats that can", "recognize arbitrary text at the beginning of the pattern. To disable", "this check omit <checkfirstchar> or add the attribute disabled=\"true\".", " 'chars': A string of characters that may start data.", "", "<type> selects the kind of data the scanner should recognize.", " 'style' selects the formatter implementation:", "  - \"isodate\": flexible ISO date reader for strings like 2011-04-29 22:31:21", "    Only creates datetimes if time part is given, so no differentiation", "    between date and date/time is necessary.", "  - \"date\": a special format for dates; needs attribute 'format'. See", "    http://download.oracle.com/javase/6/docs/api/java/text/SimpleDateFormat.html", "  - \"numberliteral\": parses Java float or integral number literals only, with", "    a dot as decimal separator and no thousands separator. See", "    http://en.wikibooks.org/wiki/Java_Programming/Literals/Numeric_Literals/Floating_Point_Literals", "  - \"decimal\": a special format for numbers; needs attribute 'format'. See", "    http://download.oracle.com/javase/6/docs/api/java/text/DecimalFormat.html", " 'format': The format code of a \"date\" or \"decimal\" scanner.", " 'comment': Inline comment, not used by the application.");
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + sep + description;
        for (Scanner scanner : scanners) {
            saver.addChild(scanner.toXml());
        }
        FileWriter writer = new FileWriter(this.pathToFile);
        XMLWriter xmlWriter = new XMLWriter(writer);
        xmlWriter.addRawContent(header);
        xmlWriter.write(saver, true);
        ((Writer)writer).close();
    }

    private String commentLines(String ... comments) {
        StringBuilder builder = new StringBuilder(comments.length * 100);
        for (String comment : comments) {
            builder.append(String.format("<!-- %-71s -->%n", comment));
        }
        return builder.toString();
    }

    @Override
    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if (FormatUtils.equalsFormatLocaleName(propertyName)) {
            this.selectScanner(FormatUtils.getFormatLocaleFromResources());
        }
    }
}

