/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.help;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.icon.factory.ImageIconFactory;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

class FilePropertiesAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    FilePropertiesAction() {
        super("FilePropertiesAction");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int nodeTotalFiltered;
        int fileChangesSinceSave;
        String fileSize;
        String fileSavedDateTime;
        String fileNamePath;
        MapModel map = Controller.getCurrentController().getMap();
        if (map.getFile() != null) {
            fileNamePath = map.getFile().toString();
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(map.getFile().lastModified());
            DateFormat df = DateFormat.getDateTimeInstance(0, 0);
            fileSavedDateTime = df.format(c.getTime());
            DecimalFormat def = new DecimalFormat();
            def.setGroupingUsed(true);
            fileSize = def.format(map.getFile().length()) + " " + TextUtils.getText("FileRevisionsDialog.file_size");
            fileChangesSinceSave = map.getNumberOfChangesSinceLastSave();
        } else {
            fileNamePath = TextUtils.getText("FileProperties_NeverSaved");
            fileSavedDateTime = TextUtils.getText("FileProperties_NeverSaved");
            fileSize = TextUtils.getText("FileProperties_NeverSaved");
            fileChangesSinceSave = 0;
        }
        NodeModel rootNode = map.getRootNode();
        int nodeMainBranches = rootNode.getChildCount();
        ICondition trueCondition = new ICondition(){

            @Override
            public boolean checkNode(NodeModel node) {
                return true;
            }
        };
        ICondition isLeafCondition = new ICondition(){

            @Override
            public boolean checkNode(NodeModel node) {
                return node.isLeaf();
            }
        };
        int nodeTotalNodeCount = this.getNodeCount(rootNode, trueCondition);
        int nodeTotalLeafCount = this.getNodeCount(rootNode, isLeafCondition);
        final Filter filter = map.getFilter();
        if (filter != null && filter.getCondition() != null) {
            ICondition matchesFilterCondition = new ICondition(){

                @Override
                public boolean checkNode(NodeModel node) {
                    return filter.matches(node);
                }
            };
            nodeTotalFiltered = this.getNodeCount(rootNode, matchesFilterCondition);
        } else {
            nodeTotalFiltered = -1;
        }
        Set<NodeModel> nodes = Controller.getCurrentController().getSelection().getSelection();
        boolean isDescendant = false;
        int nodeRelativeChildCount = 0;
        int nodeRelativeNodeCount = 0;
        int nodeRelativeLeafCount = 0;
        for (NodeModel n : nodes) {
            nodeRelativeChildCount += n.getChildCount();
            isDescendant = false;
            for (NodeModel node : nodes) {
                if (!n.isDescendantOf(node)) continue;
                isDescendant = true;
                break;
            }
            if (isDescendant) continue;
            nodeRelativeNodeCount += this.getNodeCount(n, trueCondition);
            nodeRelativeLeafCount += this.getNodeCount(n, isLeafCondition);
        }
        int nodeSelectedNodeCount = Controller.getCurrentController().getSelection().getSelection().size();
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.ipady = 5;
        c.ipadx = 0;
        c.insets = new Insets(0, 10, 0, 10);
        c.anchor = 23;
        URL imageURL = ResourceController.getResourceController().getResource("/images/filenew.png");
        JLabel fileIcon = new JLabel(ImageIconFactory.getInstance().getImageIcon(imageURL));
        gridbag.setConstraints(fileIcon, c);
        panel.add(fileIcon);
        c.gridx = 1;
        JLabel fileNamePathText = new JLabel(TextUtils.getText("FileProperties_FileName"));
        gridbag.setConstraints(fileNamePathText, c);
        panel.add(fileNamePathText);
        c.gridx = 2;
        JLabel fileNamePathLabel = new JLabel(fileNamePath);
        gridbag.setConstraints(fileNamePathLabel, c);
        panel.add(fileNamePathLabel);
        ++c.gridy;
        c.gridx = 1;
        JLabel fileSizeText = new JLabel(TextUtils.getText("FileProperties_FileSize"));
        gridbag.setConstraints(fileSizeText, c);
        panel.add(fileSizeText);
        c.gridx = 2;
        JLabel fileSizeLabel = new JLabel(fileSize);
        gridbag.setConstraints(fileSizeLabel, c);
        panel.add(fileSizeLabel);
        ++c.gridy;
        c.gridx = 1;
        JLabel fileSavedDateTimeText = new JLabel(TextUtils.getText("FileProperties_FileSaved"));
        gridbag.setConstraints(fileSavedDateTimeText, c);
        panel.add(fileSavedDateTimeText);
        c.gridx = 2;
        JLabel fileSavedDateTimeLabel = new JLabel(fileSavedDateTime);
        gridbag.setConstraints(fileSavedDateTimeLabel, c);
        panel.add(fileSavedDateTimeLabel);
        ++c.gridy;
        c.gridx = 1;
        JLabel fileChangesSinceSaveText = new JLabel(TextUtils.getText("FileProperties_ChangesSinceLastSave"));
        gridbag.setConstraints(fileChangesSinceSaveText, c);
        panel.add(fileChangesSinceSaveText);
        c.gridx = 2;
        JLabel fileChangesSinceSaveLabel = new JLabel(String.valueOf(fileChangesSinceSave));
        gridbag.setConstraints(fileChangesSinceSaveLabel, c);
        panel.add(fileChangesSinceSaveLabel);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(5, 10, 5, 10);
        c.ipady = 2;
        c.gridwidth = 3;
        JSeparator js = new JSeparator(0);
        js.setLayout(gridbag);
        js.setBorder(BorderFactory.createEtchedBorder());
        js.setPreferredSize(new Dimension(0, 0));
        c.fill = 2;
        gridbag.setConstraints(js, c);
        panel.add(js);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 10);
        c.ipady = 5;
        c.gridwidth = 1;
        c.gridx = 0;
        URL imageURL2 = ResourceController.getResourceController().getResource("/images/MapStats.png");
        JLabel MapStatsIcon = new JLabel(ImageIconFactory.getInstance().getImageIcon(imageURL2));
        gridbag.setConstraints(MapStatsIcon, c);
        panel.add(MapStatsIcon);
        c.gridx = 1;
        JLabel nodeTotalNodeCountText = new JLabel(TextUtils.getText("FileProperties_TotalNodeCount"));
        gridbag.setConstraints(nodeTotalNodeCountText, c);
        panel.add(nodeTotalNodeCountText);
        c.gridx = 2;
        JLabel nodeTotalNodeCountLabel = new JLabel(String.valueOf(nodeTotalNodeCount));
        gridbag.setConstraints(nodeTotalNodeCountLabel, c);
        panel.add(nodeTotalNodeCountLabel);
        if (nodeTotalFiltered != -1) {
            ++c.gridy;
            c.gridx = 1;
            JLabel nodeTotalFilteredLabelText = new JLabel(TextUtils.getText("FileProperties_TotalFilteredCount"));
            gridbag.setConstraints(nodeTotalFilteredLabelText, c);
            panel.add(nodeTotalFilteredLabelText);
            c.gridx = 2;
            JLabel nodeTotalFilteredLabel = new JLabel(String.valueOf(nodeTotalFiltered));
            gridbag.setConstraints(nodeTotalFilteredLabel, c);
            panel.add(nodeTotalFilteredLabel);
        }
        ++c.gridy;
        c.gridx = 1;
        JLabel nodeTotalLeafCountText = new JLabel(TextUtils.getText("FileProperties_TotalLeafCount"));
        gridbag.setConstraints(nodeTotalLeafCountText, c);
        panel.add(nodeTotalLeafCountText);
        c.gridx = 2;
        JLabel nodeTotalLeafCountLabel = new JLabel(String.valueOf(nodeTotalLeafCount));
        gridbag.setConstraints(nodeTotalLeafCountLabel, c);
        panel.add(nodeTotalLeafCountLabel);
        ++c.gridy;
        c.gridx = 1;
        JLabel nodeMainBranchesText = new JLabel(TextUtils.getText("FileProperties_MainBranchCount"));
        gridbag.setConstraints(nodeMainBranchesText, c);
        panel.add(nodeMainBranchesText);
        c.gridx = 2;
        JLabel nodeMainBranchesLabel = new JLabel(String.valueOf(nodeMainBranches));
        gridbag.setConstraints(nodeMainBranchesLabel, c);
        panel.add(nodeMainBranchesLabel);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(5, 10, 5, 10);
        c.ipady = 2;
        c.gridwidth = 3;
        JSeparator js2 = new JSeparator(0);
        js2.setLayout(gridbag);
        js2.setBorder(BorderFactory.createEtchedBorder());
        js2.setPreferredSize(new Dimension(0, 0));
        c.fill = 2;
        gridbag.setConstraints(js2, c);
        panel.add(js2);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 10);
        c.ipady = 5;
        c.gridwidth = 1;
        c.gridx = 0;
        URL imageURL3 = ResourceController.getResourceController().getResource("/images/BranchStats.png");
        JLabel BranchStatsIcon = new JLabel(ImageIconFactory.getInstance().getImageIcon(imageURL3));
        gridbag.setConstraints(BranchStatsIcon, c);
        panel.add(BranchStatsIcon);
        c.gridx = 1;
        JLabel nodeRelativeNodeCountText = new JLabel(TextUtils.getText("FileProperties_BranchNodeCount"));
        gridbag.setConstraints(nodeRelativeNodeCountText, c);
        panel.add(nodeRelativeNodeCountText);
        c.gridx = 2;
        JLabel nodeRelativeNodeCountLabel = new JLabel(String.valueOf(nodeRelativeNodeCount));
        gridbag.setConstraints(nodeRelativeNodeCountLabel, c);
        panel.add(nodeRelativeNodeCountLabel);
        ++c.gridy;
        c.gridx = 1;
        JLabel nodeRelativeLeafCountText = new JLabel(TextUtils.getText("FileProperties_BranchLeafCount"));
        gridbag.setConstraints(nodeRelativeLeafCountText, c);
        panel.add(nodeRelativeLeafCountText);
        c.gridx = 2;
        JLabel nodeRelativeLeafCountLabel = new JLabel(String.valueOf(nodeRelativeLeafCount));
        gridbag.setConstraints(nodeRelativeLeafCountLabel, c);
        panel.add(nodeRelativeLeafCountLabel);
        ++c.gridy;
        c.gridx = 1;
        JLabel nodeRelativeChildCountText = new JLabel(TextUtils.getText("FileProperties_NodeChildCount"));
        gridbag.setConstraints(nodeRelativeChildCountText, c);
        panel.add(nodeRelativeChildCountText);
        c.gridx = 2;
        JLabel nodeRelativeChildCountLabel = new JLabel(String.valueOf(nodeRelativeChildCount));
        gridbag.setConstraints(nodeRelativeChildCountLabel, c);
        panel.add(nodeRelativeChildCountLabel);
        ++c.gridy;
        c.gridx = 1;
        JLabel nodeSelectedNodeCountText = new JLabel(TextUtils.getText("FileProperties_NodeSelectionCount"));
        gridbag.setConstraints(nodeSelectedNodeCountText, c);
        panel.add(nodeSelectedNodeCountText);
        c.gridx = 2;
        JLabel nodeSelectedNodeCountLabel = new JLabel(String.valueOf(nodeSelectedNodeCount));
        gridbag.setConstraints(nodeSelectedNodeCountLabel, c);
        panel.add(nodeSelectedNodeCountLabel);
        JOptionPane.showMessageDialog(UITools.getCurrentRootComponent(), panel, TextUtils.getText("FilePropertiesAction.text"), -1);
    }

    private int getNodeCount(NodeModel node, ICondition condition) {
        int result = 0;
        Enumeration<NodeModel> children = node.children();
        if (condition.checkNode(node)) {
            ++result;
        }
        while (children.hasMoreElements()) {
            NodeModel child = children.nextElement();
            result += this.getNodeCount(child, condition);
        }
        return result;
    }
}

