/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.util.List;
import java.util.Map;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.IReadCompletionListener;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.UnknownElements;
import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.HistoryInformationModel;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapReader;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

public class NodeBuilder
implements IElementDOMHandler {
    public static final String FOLDING_LOADED = "folding_loaded";
    private static final String RESOURCES_ALWAYS_FOLD_ALL_AFTER_LOAD = "always_fold_all_after_load";
    private static final String RESOURCES_ALWAYS_UNFOLD_ALL_AFTER_LOAD = "always_unfold_all_after_load";
    private static final String RESOURCES_LOAD_FOLDING = "load_folding";
    private static final String RESOURCES_LOAD_FOLDING_FROM_MAP_DEFAULT_FOLD_ALL = "load_folding_from_map_default_fold_all";
    private static final String MAX_DISPLAYED_NODE_COUNT = "max_displayed_node_count";
    private static final String RESOURCES_ALWAYS_SHOW_LESS_THAN_N_NODES_AFTER_LOAD = "always_show_less_than_N_nodes_after_load";
    private static final String RESOURCES_SHOW_LESS_THAN_N_NODES_BY_DEFAULT_AFTER_LOAD = "show_less_than_N_nodes_by_default_after_load";
    public static final String RESOURCES_ALWAYS_SAVE_FOLDING = "always_save_folding";
    public static final String RESOURCES_NEVER_SAVE_FOLDING = "never_save_folding";
    public static final String RESOURCES_SAVE_FOLDING = "save_folding";
    public static final String RESOURCES_SAVE_FOLDING_IF_MAP_IS_CHANGED = "save_folding_if_map_is_changed";
    public static final String RESOURCES_SAVE_MODIFICATION_TIMES = "save_modification_times";
    public static final String XML_NODE = "node";
    public static final String XML_STYLENODE = "stylenode";
    public static final String XML_NODE_ADDITIONAL_INFO = "ADDITIONAL_INFO";
    public static final String XML_NODE_CLASS = "AA_NODE_CLASS";
    public static final String XML_NODE_ENCRYPTED_CONTENT = "ENCRYPTED_CONTENT";
    public static final String XML_NODE_HISTORY_CREATED_AT = "CREATED";
    public static final String XML_NODE_HISTORY_LAST_MODIFIED_AT = "MODIFIED";
    private final MapReader mapReader;

    NodeBuilder(MapReader mapReader) {
        this.mapReader = mapReader;
    }

    @Override
    public Object createElement(Object parent, String tag, XMLElement attributes) {
        NodeModel userObject = this.createNode();
        if (this.getMapChild() == null) {
            this.setMapChild(userObject);
        }
        return userObject;
    }

    public NodeModel createNode() {
        return new NodeModel(this.getMap());
    }

    @Override
    public void endElement(Object parentObject, String tag, Object userObject, XMLElement dom) {
        NodeModel node = (NodeModel)userObject;
        if (dom.getAttributeCount() != 0 || dom.hasChildren()) {
            node.addExtension(new UnknownElements(dom));
        }
        if (parentObject instanceof MapModel) {
            this.setMapChild(node);
            return;
        }
        if (parentObject instanceof NodeModel) {
            NodeModel parentNode = (NodeModel)parentObject;
            if (userObject instanceof NodeModel) {
                parentNode.insert(node, -1);
            }
            return;
        }
    }

    private MapModel getMap() {
        return this.mapReader.getCurrentNodeTreeCreator().getCreatedMap();
    }

    public NodeModel getMapChild() {
        return this.mapReader.getCurrentNodeTreeCreator().getMapChild();
    }

    private void registerAttributeHandlers(ReadManager reader) {
        reader.addAttributeHandler(XML_NODE, XML_NODE_ENCRYPTED_CONTENT, new IAttributeHandler(){

            private void createEncryptedNode(NodeModel node, String additionalInfo) {
                EncryptionModel encryptionModel = new EncryptionModel(node, additionalInfo);
                node.addExtension(encryptionModel);
            }

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                this.createEncryptedNode(node, value);
                node.setFolded(true);
            }
        });
        reader.addAttributeHandler(XML_NODE, XML_NODE_HISTORY_CREATED_AT, new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                if (node.getHistoryInformation() == null) {
                    node.setHistoryInformation(new HistoryInformationModel());
                }
                node.getHistoryInformation().setCreatedAt(TreeXmlReader.xmlToDate(value));
            }
        });
        reader.addAttributeHandler(XML_NODE, XML_NODE_HISTORY_LAST_MODIFIED_AT, new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                if (node.getHistoryInformation() == null) {
                    node.setHistoryInformation(new HistoryInformationModel());
                }
                node.getHistoryInformation().setLastModifiedAt(TreeXmlReader.xmlToDate(value));
            }
        });
        reader.addAttributeHandler(XML_STYLENODE, "FOLDED", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
            }
        });
        reader.addAttributeHandler(XML_NODE, "FOLDED", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                Object mode = NodeBuilder.this.mapReader.getCurrentNodeTreeCreator().getHint((Object)MapWriter.Hint.MODE);
                if (mode.equals((Object)MapWriter.Mode.FILE)) {
                    String loadFolding = ResourceController.getResourceController().getProperty(NodeBuilder.RESOURCES_LOAD_FOLDING);
                    if (loadFolding.equals(NodeBuilder.RESOURCES_ALWAYS_FOLD_ALL_AFTER_LOAD) || loadFolding.equals(NodeBuilder.RESOURCES_ALWAYS_UNFOLD_ALL_AFTER_LOAD) || loadFolding.equals(NodeBuilder.RESOURCES_ALWAYS_SHOW_LESS_THAN_N_NODES_AFTER_LOAD)) {
                        return;
                    }
                    NodeBuilder.this.mapReader.getCurrentNodeTreeCreator().setHint(NodeBuilder.FOLDING_LOADED, Boolean.TRUE);
                }
                if (value.equals("true")) {
                    node.setFolded(true);
                }
            }
        });
        reader.addReadCompletionListener(new IReadCompletionListener(){

            private int foldAll(NodeModel node, int nodeCount) {
                if (node.getChildCount() == 0) {
                    return nodeCount;
                }
                if (nodeCount <= 0) {
                    node.setFolded(true);
                } else {
                    nodeCount -= node.getChildCount();
                }
                for (NodeModel child : node.getChildren()) {
                    nodeCount = this.foldAll(child, nodeCount);
                }
                return nodeCount;
            }

            @Override
            public void readingCompleted(NodeModel topNode, Map<String, String> newIds) {
                if (!MapWriter.Mode.FILE.equals(NodeBuilder.this.mapReader.getCurrentNodeTreeCreator().getHint((Object)MapWriter.Hint.MODE))) {
                    return;
                }
                if (Boolean.TRUE.equals(NodeBuilder.this.mapReader.getCurrentNodeTreeCreator().getHint(NodeBuilder.FOLDING_LOADED))) {
                    return;
                }
                ResourceController resourceController = ResourceController.getResourceController();
                String loadFolding = resourceController.getProperty(NodeBuilder.RESOURCES_LOAD_FOLDING);
                if (loadFolding.equals(NodeBuilder.RESOURCES_ALWAYS_FOLD_ALL_AFTER_LOAD) || loadFolding.equals(NodeBuilder.RESOURCES_LOAD_FOLDING_FROM_MAP_DEFAULT_FOLD_ALL) || loadFolding.equals(NodeBuilder.RESOURCES_ALWAYS_SHOW_LESS_THAN_N_NODES_AFTER_LOAD) || loadFolding.equals(NodeBuilder.RESOURCES_SHOW_LESS_THAN_N_NODES_BY_DEFAULT_AFTER_LOAD)) {
                    int nodeCount = 1;
                    if (loadFolding.equals(NodeBuilder.RESOURCES_ALWAYS_SHOW_LESS_THAN_N_NODES_AFTER_LOAD) || loadFolding.equals(NodeBuilder.RESOURCES_SHOW_LESS_THAN_N_NODES_BY_DEFAULT_AFTER_LOAD)) {
                        nodeCount = resourceController.getIntProperty(NodeBuilder.MAX_DISPLAYED_NODE_COUNT, 20);
                    }
                    List<NodeModel> children = topNode.getChildren();
                    nodeCount = nodeCount - 1 - children.size();
                    for (NodeModel child : children) {
                        nodeCount = this.foldAll(child, nodeCount);
                    }
                }
            }
        });
        IAttributeHandler positionHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                node.setLeft(value.equals("left"));
            }
        };
        reader.addAttributeHandler(XML_NODE, "POSITION", positionHandler);
        reader.addAttributeHandler(XML_STYLENODE, "POSITION", positionHandler);
        reader.addAttributeHandler(XML_NODE, "ID", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                String realId = NodeBuilder.this.getMap().generateNodeID(value);
                node.setID(realId);
                if (!realId.equals(value)) {
                    NodeBuilder.this.mapReader.getCurrentNodeTreeCreator().substituteNodeID(value, realId);
                }
            }
        });
        CloneHandler subtreeReferenceHandler = new CloneHandler(NodeModel.CloneType.TREE);
        reader.addAttributeHandler(XML_NODE, "REFERENCE_ID", subtreeReferenceHandler);
        reader.addAttributeHandler(XML_NODE, "TREE_ID", subtreeReferenceHandler);
        CloneHandler contentReferenceHandler = new CloneHandler(NodeModel.CloneType.CONTENT);
        reader.addAttributeHandler(XML_NODE, "CONTENT_ID", contentReferenceHandler);
    }

    public void registerBy(ReadManager reader) {
        this.registerAttributeHandlers(reader);
        reader.addElementHandler(XML_NODE, this);
        reader.addElementHandler(XML_STYLENODE, this);
    }

    public void reset() {
        this.setMapChild(null);
    }

    public void setAttributes(String tag, Object node, XMLElement attributes) {
    }

    private void setMapChild(NodeModel mapChild) {
        this.mapReader.getCurrentNodeTreeCreator().setMapChild(mapChild);
    }

    static class IconProperties {
        String iconName;

        IconProperties() {
        }
    }

    private class CloneHandler
    implements IAttributeHandler {
        private final NodeModel.CloneType cloneType;

        public CloneHandler(NodeModel.CloneType cloneType) {
            this.cloneType = cloneType;
        }

        @Override
        public void setAttribute(Object userObject, String proposedReferenceId) {
            NodeModel node = (NodeModel)userObject;
            String realReference = NodeBuilder.this.mapReader.getCurrentNodeTreeCreator().substitutedID(proposedReferenceId);
            node.convertToClone(NodeBuilder.this.getMap().getNodeForID(realReference), this.cloneType);
        }
    }
}

