/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.StyleTranslatedObject;
import org.freeplane.n3.nanoxml.XMLElement;

public class ConditionalStyleModel
implements IExtension,
Iterable<Item> {
    private ArrayList<Item> styles;
    private boolean recursiveCall;
    private AbstractTableModel table;

    public ConditionalStyleModel() {
        this.styles = new ArrayList();
    }

    public ConditionalStyleModel(ConditionalStyleModel conditionalStyleModel) {
        ArrayList<Item> prototypeStyles = conditionalStyleModel.styles;
        this.styles = new ArrayList(prototypeStyles.size());
        for (Item style : prototypeStyles) {
            this.styles.add(new Item(style));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IStyle> getStyles(NodeModel node) {
        if (this.recursiveCall) {
            return Collections.emptyList();
        }
        try {
            this.recursiveCall = true;
            LinkedHashSet<IStyle> matchingStyles = new LinkedHashSet<IStyle>();
            for (Item item : this.styles) {
                ASelectableCondition condition = item.getCondition();
                if (!item.isActive() || condition != null && !condition.checkNode(node)) continue;
                matchingStyles.add(item.style);
                if (!item.isLast()) continue;
                break;
            }
            LinkedHashSet<IStyle> linkedHashSet = matchingStyles;
            return linkedHashSet;
        }
        finally {
            this.recursiveCall = false;
        }
    }

    void addCondition(boolean isActive, ASelectableCondition condition, IStyle style, boolean isLast) {
        this.styles.add(new Item(isActive, condition, style, isLast));
        if (this.table == null) {
            return;
        }
        int index = this.styles.size() - 1;
        this.table.fireTableRowsInserted(index, index);
    }

    void insertCondition(int index, boolean isActive, ASelectableCondition condition, IStyle style, boolean isLast) {
        this.styles.add(index, new Item(isActive, condition, style, isLast));
        if (this.table == null) {
            return;
        }
        this.table.fireTableRowsInserted(index, index);
    }

    Item removeCondition(int index) {
        Item item = this.styles.remove(index);
        if (this.table == null) {
            return item;
        }
        this.table.fireTableRowsDeleted(index, index);
        return item;
    }

    void swapConditions(int index1, int index2) {
        Item item1 = this.styles.get(index1);
        Item item2 = this.styles.get(index2);
        this.styles.set(index1, item2);
        this.styles.set(index2, item1);
        if (this.table == null) {
            return;
        }
        this.table.fireTableRowsUpdated(index1, index1);
        this.table.fireTableRowsUpdated(index2, index2);
    }

    void moveUp(int index) {
        if (index == 0) {
            return;
        }
        this.swapConditions(index, index - 1);
    }

    void moveDown(int index) {
        if (index == this.styles.size() - 1) {
            return;
        }
        this.swapConditions(index, index + 1);
    }

    void clear() {
        this.styles.clear();
    }

    @Override
    public Iterator<Item> iterator() {
        return this.styles.iterator();
    }

    public TableModel asTableModel() {
        if (this.table != null) {
            return this.table;
        }
        this.table = new AbstractTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Item item = (Item)ConditionalStyleModel.this.styles.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return item.isActive();
                    }
                    case 1: {
                        return item.getCondition();
                    }
                    case 2: {
                        return item.getStyle();
                    }
                    case 3: {
                        return item.isLast();
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }

            @Override
            public int getRowCount() {
                return ConditionalStyleModel.this.styles.size();
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: 
                    case 3: {
                        return Boolean.class;
                    }
                    case 1: {
                        return ASelectableCondition.class;
                    }
                }
                return super.getColumnClass(columnIndex);
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return TextUtils.getText("active");
                    }
                    case 1: {
                        return TextUtils.getText("condition");
                    }
                    case 2: {
                        return TextUtils.getText("style");
                    }
                    case 3: {
                        return TextUtils.getText("stop_processing");
                    }
                }
                return super.getColumnName(column);
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                Item item = (Item)ConditionalStyleModel.this.styles.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        item.setActive((Boolean)aValue);
                        break;
                    }
                    case 1: {
                        item.setCondition((ASelectableCondition)aValue);
                        break;
                    }
                    case 2: {
                        item.setStyle((IStyle)aValue);
                        break;
                    }
                    case 3: {
                        item.setLast((Boolean)aValue);
                        break;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        };
        return this.table;
    }

    public int getStyleCount() {
        return this.styles.size();
    }

    public ConditionalStyleModel clone() {
        ConditionalStyleModel conditionalStyleModel = new ConditionalStyleModel(this);
        return conditionalStyleModel;
    }

    public class Item {
        private ASelectableCondition condition;
        private IStyle style;
        private boolean isActive;
        private boolean isLast;

        private Item(boolean isActive, ASelectableCondition condition, IStyle style, boolean isLast) {
            this.isActive = isActive;
            this.condition = condition;
            this.style = style;
            this.setLast(isLast);
        }

        public Item(Item prototype) {
            this(prototype.isActive, prototype.condition, prototype.style, prototype.isLast);
        }

        public void setCondition(ASelectableCondition condition) {
            this.condition = condition;
        }

        public ASelectableCondition getCondition() {
            return this.condition;
        }

        public void setStyle(IStyle style) {
            this.style = style;
        }

        public IStyle getStyle() {
            return this.style;
        }

        public void setActive(boolean isActive) {
            this.isActive = isActive;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void setLast(boolean isLast) {
            this.isLast = isLast;
        }

        public boolean isLast() {
            return this.isLast;
        }

        public void toXml(XMLElement conditionalStylesRoot) {
            XMLElement itemElement = conditionalStylesRoot.createElement("conditional_style");
            conditionalStylesRoot.addChild(itemElement);
            itemElement.setAttribute("ACTIVE", Boolean.toString(this.isActive()));
            IStyle style = this.getStyle();
            if (style instanceof StyleTranslatedObject) {
                String referencedStyle = ((StyleTranslatedObject)style).getObject().toString();
                itemElement.setAttribute("LOCALIZED_STYLE_REF", referencedStyle);
            } else {
                String referencedStyle = style.toString();
                itemElement.setAttribute("STYLE_REF", referencedStyle);
            }
            itemElement.setAttribute("LAST", Boolean.toString(this.isLast()));
            if (this.condition != null) {
                this.condition.toXml(itemElement);
            }
        }
    }
}

