/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.XsltPipeReaderFactory;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.url.IMapConverter;
import org.freeplane.features.url.IMapInputStreamConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MapVersionInterpreter
implements IExtension {
    public static final IMapInputStreamConverter DEFAULT_INPUTSTREAM_CONVERTER = new IMapInputStreamConverter(){
        private static final String FREEPLANE_VERSION_UPDATER_XSLT = "/xslt/freeplane_version_updater.xslt";

        @Override
        public Reader getConvertedStream(File f) throws FileNotFoundException, IOException {
            return new XsltPipeReaderFactory(FREEPLANE_VERSION_UPDATER_XSLT).getReader(new FileInputStream(f));
        }
    };
    public static final MapVersionInterpreter DEFAULT = new MapVersionInterpreter("", 0, "", true, true, null, null);
    public final String mapBegin;
    public final String name;
    public final int version;
    public final boolean needsConversion;
    public final boolean anotherDialect;
    public final String appName;
    public final String url;
    public final IMapInputStreamConverter inputStreamConverter;
    public final IMapConverter mapConverter;
    private static MapVersionInterpreter[] values = null;

    MapVersionInterpreter(String name, int version, String versionBegin, boolean needsConversion, boolean anotherDialect, String appName, String url) {
        this(name, version, versionBegin, needsConversion, anotherDialect, appName, url, DEFAULT_INPUTSTREAM_CONVERTER, null);
    }

    public MapVersionInterpreter(String name, int version, String versionBegin, boolean needsConversion, boolean anotherDialect, String appName, String url, IMapInputStreamConverter inputStreamConverter, IMapConverter mapConverter) {
        this.inputStreamConverter = inputStreamConverter;
        this.mapConverter = mapConverter;
        this.name = name;
        this.version = version;
        this.mapBegin = "<map version=\"" + versionBegin;
        this.needsConversion = needsConversion;
        this.anotherDialect = anotherDialect;
        this.appName = appName;
        this.url = url;
    }

    public static MapVersionInterpreter getVersionInterpreter(String mapBegin) {
        for (MapVersionInterpreter interpreter : MapVersionInterpreter.values()) {
            if (!interpreter.knows(mapBegin)) continue;
            return interpreter;
        }
        return DEFAULT;
    }

    private static MapVersionInterpreter[] values() {
        if (values == null) {
            try {
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = domFactory.newDocumentBuilder();
                InputStream resource = ResourceController.getResourceController().getResource("/xml/mapVersions.xml").openStream();
                Document dom = documentBuilder.parse(resource);
                Element root = dom.getDocumentElement();
                NodeList dialectElements = root.getElementsByTagName("dialect");
                int dialectNumber = dialectElements.getLength();
                values = new MapVersionInterpreter[dialectNumber];
                for (int i = 0; i < dialectNumber; ++i) {
                    Element dialectElement = (Element)dialectElements.item(i);
                    String versionBegin = dialectElement.getAttribute("versionBegin");
                    boolean needsConversion = Boolean.parseBoolean(dialectElement.getAttribute("needsConversion"));
                    boolean anotherDialect = Boolean.parseBoolean(dialectElement.getAttribute("anotherDialect"));
                    String name = dialectElement.getAttribute("name");
                    String appName = dialectElement.getAttribute("appName");
                    String url = dialectElement.getAttribute("url");
                    int version = Integer.parseInt(dialectElement.getAttribute("version"));
                    MapVersionInterpreter.values[i] = new MapVersionInterpreter(name, version, versionBegin, needsConversion, anotherDialect, appName, url);
                }
                resource.close();
            }
            catch (Exception e) {
                LogUtils.severe(e);
                values = new MapVersionInterpreter[0];
            }
        }
        return values;
    }

    public static void addMapVersionInterpreter(MapVersionInterpreter interpreter) {
        ArrayList<MapVersionInterpreter> list = new ArrayList<MapVersionInterpreter>();
        list.add(interpreter);
        list.addAll(Arrays.asList(MapVersionInterpreter.values()));
        values = list.toArray(values);
    }

    private boolean knows(String mapBegin) {
        return mapBegin.startsWith(this.mapBegin);
    }

    public IMapConverter getMapConverter() {
        return this.mapConverter;
    }

    public IMapInputStreamConverter getMapInputStreamConverter() {
        return this.inputStreamConverter;
    }

    public String getDialectInfo(String path) {
        String appInfo = this.appName != null ? ("Freeplane".equals(this.appName) ? TextUtils.format("dialect_info.later_version", path) : TextUtils.format("dialect_info.app", path, this.appName)) : TextUtils.format("dialect_info.unknownApp", path);
        String warning = TextUtils.getText("dialect_info.warning");
        String urlInfo = this.url != null ? TextUtils.format("dialect_info.url", this.url) : TextUtils.getText("dialect_info.unknownURL");
        return appInfo + " " + warning + " " + urlInfo;
    }

    public static boolean isOlderThan(MapModel map, int version) {
        MapVersionInterpreter versionInterpreter = map.getExtension(MapVersionInterpreter.class);
        return versionInterpreter != null && versionInterpreter.version < version;
    }
}

