/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import com.thebuzzmedia.imgscalr.AsyncScalr;
import com.thebuzzmedia.imgscalr.Scalr;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.view.swing.features.filepreview.ImageLoadingListener;
import org.freeplane.view.swing.features.filepreview.ScalableComponent;

public class BitmapViewerComponent
extends JComponent
implements ScalableComponent {
    private static final long serialVersionUID = 1L;
    private File cacheFile;
    private int hint;
    private BufferedImage cachedImage;
    private WeakReference<BufferedImage> cachedImageWeakRef;
    private final URL url;
    private final Dimension originalSize;
    private int imageX;
    private int imageY;
    private boolean processing;
    private boolean scaleEnabled;
    private Dimension maximumSize = null;
    private boolean center;
    private static final Object LOCK = new Object();
    private ImageLoadingListener imageLoadinglistener;

    public BitmapViewerComponent(URI uri) throws MalformedURLException, IOException {
        this.url = uri.toURL();
        this.originalSize = this.readOriginalSize();
        this.hint = 4;
        this.processing = false;
        this.scaleEnabled = true;
        this.cachedImage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension readOriginalSize() throws IOException {
        InputStream inputStream = null;
        ImageInputStream in = null;
        try {
            inputStream = this.url.openStream();
            in = ImageIO.createImageInputStream(inputStream);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                try {
                    reader.setInput(in);
                    Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                    return dimension;
                }
                finally {
                    reader.dispose();
                }
            }
            throw new IOException("can not create image");
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public boolean isScaleEnabled() {
        return this.scaleEnabled;
    }

    public void setScaleEnabled(boolean scaleEnabled) {
        this.scaleEnabled = scaleEnabled;
    }

    protected int getHint() {
        return this.hint;
    }

    public void setHint(int hint) {
        this.hint = hint;
    }

    @Override
    public Dimension getOriginalSize() {
        return new Dimension(this.originalSize);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.processing || this.componentHasNoArea()) {
            return;
        }
        if (this.cachedImage == null && this.cachedImageWeakRef != null) {
            this.cachedImage = (BufferedImage)this.cachedImageWeakRef.get();
            this.cachedImageWeakRef = null;
        }
        if (this.cachedImage == null && this.cacheFile != null) {
            this.loadImageFromCacheFile();
            if (!this.isCachedImageValid()) {
                this.cacheFile.delete();
                this.cacheFile = null;
            }
        }
        if (this.isCachedImageValid()) {
            g.drawImage(this.cachedImage, this.imageX, this.imageY, null);
            this.flushImage();
        } else {
            final BufferedImage image = this.loadImageFromURL();
            if (image == null || this.hasNoArea(image)) {
                return;
            }
            this.processing = true;
            final Future<BufferedImage> result = AsyncScalr.resize(image, Scalr.Mode.BEST_FIT_BOTH, this.getWidth(), this.getHeight(), new BufferedImageOp[0]);
            AsyncScalr.getService().submit(new Runnable(){

                @Override
                public void run() {
                    BufferedImage scaledImage = null;
                    try {
                        scaledImage = (BufferedImage)result.get();
                    }
                    catch (Exception e) {
                        LogUtils.severe(e);
                        return;
                    }
                    finally {
                        image.flush();
                    }
                    int scaledImageHeight = scaledImage.getHeight();
                    int scaledImageWidth = scaledImage.getWidth();
                    this.centerImagePosition(scaledImageWidth, scaledImageHeight);
                    BitmapViewerComponent.this.cachedImage = scaledImage;
                    if (BitmapViewerComponent.this.getCacheType().equals((Object)CacheType.IC_FILE)) {
                        BitmapViewerComponent.this.writeCacheFile();
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BitmapViewerComponent.this.processing = false;
                            if (BitmapViewerComponent.this.imageLoadinglistener != null) {
                                BitmapViewerComponent.this.imageLoadinglistener.imageLoaded();
                            }
                            BitmapViewerComponent.this.repaint();
                        }
                    });
                }

                private void centerImagePosition(int scaledImageWidth, int scaledImageHeight) {
                    if (BitmapViewerComponent.this.center) {
                        BitmapViewerComponent.this.imageX = (BitmapViewerComponent.this.getWidth() - scaledImageWidth) / 2;
                        BitmapViewerComponent.this.imageY = (BitmapViewerComponent.this.getHeight() - scaledImageHeight) / 2;
                    } else if (scaledImageWidth > BitmapViewerComponent.this.getHeight()) {
                        BitmapViewerComponent.this.imageX = 0;
                        BitmapViewerComponent.this.imageY = (BitmapViewerComponent.this.getHeight() - scaledImageHeight) / 2;
                    } else {
                        BitmapViewerComponent.this.imageX = (BitmapViewerComponent.this.getWidth() - scaledImageWidth) / 2;
                        BitmapViewerComponent.this.imageY = 0;
                    }
                }
            });
        }
    }

    private boolean componentHasNoArea() {
        return this.getWidth() == 0 || this.getHeight() == 0;
    }

    private boolean hasNoArea(BufferedImage image) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        return imageWidth == 0 || imageHeight == 0;
    }

    private void loadImageFromCacheFile() {
        try {
            this.cachedImage = ImageIO.read(this.cacheFile);
        }
        catch (IOException e) {
            LogUtils.severe("ImageIO can not read cache file " + this.cacheFile, e);
        }
    }

    private boolean isCachedImageValid() {
        return this.cachedImage != null && (!this.scaleEnabled || this.componentHasSameWidthAsCachedImage() && this.cachedImageHeightFitsComponentHeight() || this.cachedImageWidthFitsComponentWidth() && this.componentHasSameHeightAsCachedImage());
    }

    private boolean componentHasSameHeightAsCachedImage() {
        return 1 >= Math.abs(this.getHeight() - this.cachedImage.getHeight());
    }

    private boolean cachedImageWidthFitsComponentWidth() {
        return this.getWidth() >= this.cachedImage.getWidth();
    }

    private boolean cachedImageHeightFitsComponentHeight() {
        return this.getHeight() >= this.cachedImage.getHeight();
    }

    private boolean componentHasSameWidthAsCachedImage() {
        return 1 >= Math.abs(this.getWidth() - this.cachedImage.getWidth());
    }

    private BufferedImage loadImageFromURL() {
        BufferedImage tempImage = null;
        try {
            tempImage = ImageIO.read(this.url);
        }
        catch (IOException e) {
            LogUtils.severe(e);
        }
        return tempImage;
    }

    private void flushImage() {
        CacheType cacheType = this.getCacheType();
        if (CacheType.IC_RAM.equals((Object)cacheType)) {
            this.cachedImage.flush();
        } else {
            this.cachedImageWeakRef = new WeakReference<BufferedImage>(this.cachedImage);
            this.cachedImage = null;
        }
    }

    private CacheType getCacheType() {
        return ResourceController.getResourceController().getEnumProperty("image_cache", CacheType.IC_DISABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCacheFile() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"), "freeplane");
        tempDir.mkdirs();
        try {
            Object object = LOCK;
            synchronized (object) {
                if (this.cacheFile == null) {
                    this.cacheFile = File.createTempFile("cachedImage", ".jpg", tempDir);
                } else {
                    this.cacheFile.delete();
                    this.cacheFile.createNewFile();
                }
            }
            ImageIO.write((RenderedImage)this.cachedImage, "jpg", this.cacheFile);
        }
        catch (IOException e) {
            this.cacheFile.delete();
            this.cacheFile = null;
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.cacheFile != null) {
            this.cacheFile.delete();
            this.cacheFile = null;
        }
    }

    @Override
    public void setFinalViewerSize(Dimension size) {
        Dimension sizeWithScaleCorrection = this.fitToMaximumSize(size);
        this.setPreferredSize(sizeWithScaleCorrection);
        this.setSize(sizeWithScaleCorrection);
        this.setScaleEnabled(true);
    }

    @Override
    public void setFinalViewerSize(float zoom) {
        int scaledWidth = (int)((float)this.originalSize.width * zoom);
        int scaledHeight = (int)((float)this.originalSize.height * zoom);
        this.setFinalViewerSize(new Dimension(scaledWidth, scaledHeight));
    }

    @Override
    public void setDraftViewerSize(Dimension size) {
        this.setPreferredSize(size);
        this.setSize(size);
        this.setScaleEnabled(false);
    }

    @Override
    public void setMaximumComponentSize(Dimension size) {
        this.maximumSize = size;
    }

    private Dimension fitToMaximumSize(Dimension size) {
        if (this.maximumSize == null || this.isUnderMaximumSize(size)) {
            return size;
        }
        return this.maximumSize;
    }

    private boolean isUnderMaximumSize(Dimension size) {
        return this.maximumSize.getWidth() >= (double)size.width || this.maximumSize.getHeight() >= (double)size.height;
    }

    @Override
    public void setCenter(boolean center) {
        this.center = center;
    }

    @Override
    public void setImageLoadingListener(ImageLoadingListener listener) {
        this.imageLoadinglistener = listener;
    }

    static enum CacheType {
        IC_DISABLE,
        IC_FILE,
        IC_RAM;

    }
}

