/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Stroke;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.nodestyle.ShapeConfigurationModel;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;

class ForkMainView
extends MainView {
    private static final long serialVersionUID = 1L;
    private static final int SINGLE_CHILD_SHIFT = -2;

    ForkMainView() {
    }

    @Override
    public Point getLeftPoint() {
        int edgeWidth = this.getEdgeWidth();
        Point in = new Point(0, this.getHeight() - edgeWidth / 2);
        return in;
    }

    public int getEdgeWidth() {
        NodeView nodeView = this.getNodeView();
        int edgeWidth = nodeView.getEdgeWidth();
        EdgeStyle style = nodeView.getEdgeStyle();
        int nodeLineWidth = style.getNodeLineWidth(edgeWidth);
        if (edgeWidth == 0) {
            return nodeLineWidth;
        }
        int zoomedLineWidth = nodeView.getMap().getZoomed(nodeLineWidth);
        return zoomedLineWidth;
    }

    @Override
    protected int getMainViewHeightWithFoldingMark() {
        int height = this.getHeight();
        NodeView nodeView = this.getNodeView();
        if (nodeView.isFolded()) {
            height += this.getZoomedFoldingSymbolHalfWidth();
        }
        return height;
    }

    @Override
    public Point getRightPoint() {
        int edgeWidth = this.getEdgeWidth();
        Point in = new Point(this.getWidth() - 1, this.getHeight() - edgeWidth / 2);
        return in;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        NodeView nodeView = this.getNodeView();
        if (nodeView.getModel() == null) {
            return;
        }
        this.paintBackgound(g);
        this.paintDragOver(g);
        super.paintComponent(g);
    }

    @Override
    protected void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight() - this.getEdgeWidth());
    }

    @Override
    void paintDecoration(NodeView nodeView, Graphics2D g) {
        Stroke oldStroke = g.getStroke();
        float edgeWidth = this.getEdgeWidth();
        g.setStroke(new BasicStroke(edgeWidth, 0, 0));
        Color oldColor = g.getColor();
        g.setColor(nodeView.getEdgeColor());
        Point leftLinePoint = this.getLeftPoint();
        g.drawLine(leftLinePoint.x, leftLinePoint.y, leftLinePoint.x + this.getWidth(), leftLinePoint.y);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
        super.paintDecoration(nodeView, g);
    }

    @Override
    public Insets getInsets() {
        return this.getInsets(null);
    }

    @Override
    public Insets getInsets(Insets insets) {
        NodeView nodeView = this.getNodeView();
        int edgeWidth = nodeView.getEdgeWidth();
        EdgeStyle style = nodeView.getEdgeStyle();
        edgeWidth = style.getNodeLineWidth(edgeWidth);
        if (insets == null) {
            insets = new Insets(0, 2, edgeWidth, 2);
        } else {
            insets.set(0, 2, edgeWidth, 2);
        }
        return insets;
    }

    @Override
    public int getSingleChildShift() {
        return -2;
    }

    @Override
    public ShapeConfigurationModel getShapeConfiguration() {
        return ShapeConfigurationModel.FORK;
    }
}

