/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JViewport;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.map.NodeModel;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.ScrollingDirective;

class MapScroller {
    private NodeView anchor;
    private Point anchorContentLocation;
    private float anchorHorizontalPoint;
    private float anchorVerticalPoint;
    private NodeView scrolledNode = null;
    private ScrollingDirective scrollingDirective = ScrollingDirective.DONE;
    private boolean slowScroll;
    private int extraWidth;
    private final MapView map;

    public MapScroller(MapView map) {
        this.map = map;
        this.anchorContentLocation = new Point();
    }

    void anchorToNode(NodeView view, float horizontalPoint, float verticalPoint) {
        if (view != null && view.getMainView() != null) {
            this.setAnchorView(view);
            this.anchorHorizontalPoint = horizontalPoint;
            this.anchorVerticalPoint = verticalPoint;
            this.anchorContentLocation = this.getAnchorCenterPoint();
            if (this.scrolledNode == null) {
                this.scrolledNode = this.anchor;
                this.scrollingDirective = ScrollingDirective.ANCHOR;
                this.extraWidth = 0;
            }
        }
    }

    public void scrollBy(int x, int y) {
        JViewport mapViewport = (JViewport)this.map.getParent();
        if (mapViewport != null) {
            Point currentPoint = mapViewport.getViewPosition();
            currentPoint.translate(x, y);
            if (currentPoint.getX() < 0.0) {
                currentPoint.setLocation(0.0, currentPoint.getY());
            }
            if (currentPoint.getY() < 0.0) {
                currentPoint.setLocation(currentPoint.getX(), 0.0);
            }
            double maxX = this.map.getSize().getWidth() - mapViewport.getExtentSize().getWidth();
            double maxY = this.map.getSize().getHeight() - mapViewport.getExtentSize().getHeight();
            if (currentPoint.getX() > maxX) {
                currentPoint.setLocation(maxX, currentPoint.getY());
            }
            if (currentPoint.getY() > maxY) {
                currentPoint.setLocation(currentPoint.getX(), maxY);
            }
            mapViewport.setViewPosition(currentPoint);
        }
    }

    public void scrollNode(NodeView node, ScrollingDirective scrollingDirective, boolean slowScroll) {
        if (node != null) {
            this.slowScroll = slowScroll;
            this.scrolledNode = node;
            this.scrollingDirective = scrollingDirective;
            if (this.map.isDisplayable() && this.map.frameLayoutCompleted() && this.map.isValid()) {
                this.scrollNodeNow(slowScroll);
            }
        }
    }

    private Rectangle calculateOptimalVisibleRectangle() {
        JViewport viewPort = (JViewport)this.map.getParent();
        Dimension extentSize = viewPort.getExtentSize();
        JComponent content = this.scrolledNode.getContent();
        Point contentLocation = new Point();
        UITools.convertPointToAncestor((Component)content, contentLocation, this.map);
        Rectangle rect = new Rectangle(contentLocation.x + content.getWidth() / 2 - extentSize.width / 2, contentLocation.y + content.getHeight() / 2 - extentSize.height / 2, extentSize.width, extentSize.height);
        if (this.scrollingDirective == ScrollingDirective.SCROLL_TO_BEST_ROOT_POSITION) {
            Rectangle innerBounds = this.map.getInnerBounds();
            if (innerBounds.width <= extentSize.width && this.map.getModeController().shouldCenterCompactMaps()) {
                rect.x = innerBounds.x - (extentSize.width - innerBounds.width) / 2;
            } else {
                NodeView root = this.map.getRoot();
                if (!this.map.isOutlineLayoutSet()) {
                    boolean scrollToTheLeft = false;
                    List<NodeModel> children = root.getModel().getChildren();
                    if (!children.isEmpty()) {
                        scrollToTheLeft = true;
                        boolean outlineLayoutSet = this.map.isOutlineLayoutSet();
                        for (NodeModel node : children) {
                            if (outlineLayoutSet || !node.isLeft()) continue;
                            scrollToTheLeft = false;
                            break;
                        }
                    }
                    if (scrollToTheLeft) {
                        rect.x += (extentSize.width - content.getWidth()) / 2 - 10;
                    }
                }
            }
        }
        return rect;
    }

    private void scrollNodeNow(boolean slowScroll) {
        JViewport viewPort = (JViewport)this.map.getParent();
        if (slowScroll) {
            viewPort.putClientProperty("slowScrolling", 20);
        }
        Rectangle rect = this.calculateOptimalVisibleRectangle();
        this.map.scrollRectToVisible(rect);
        this.scrolledNode = null;
        this.scrollingDirective = ScrollingDirective.DONE;
        this.slowScroll = false;
        if (!this.anchor.equals(this.map.getRoot())) {
            this.anchor = this.map.getRoot();
        }
        this.anchorContentLocation = this.getAnchorCenterPoint();
    }

    void setAnchorView(NodeView view) {
        this.anchor = view;
    }

    private Point getAnchorCenterPoint() {
        if (!this.map.isDisplayable()) {
            return new Point();
        }
        MainView mainView = this.anchor.getMainView();
        int mainViewWidth = mainView.getWidth();
        int mainViewHeight = mainView.getHeight();
        Point anchorCenterPoint = new Point((int)((float)mainViewWidth * this.anchorHorizontalPoint), (int)((float)mainViewHeight * this.anchorVerticalPoint));
        JViewport viewPort = (JViewport)this.map.getParent();
        UITools.convertPointToAncestor((Component)mainView, anchorCenterPoint, this.map);
        Dimension extentSize = viewPort.getExtentSize();
        anchorCenterPoint.x += (extentSize.width - viewPort.getWidth()) / 2;
        anchorCenterPoint.y += (extentSize.height - viewPort.getHeight()) / 2;
        return anchorCenterPoint;
    }

    public void scrollNodeToVisible(NodeView node) {
        this.scrollNodeToVisible(node, 0);
    }

    private void scrollNodeToVisible(NodeView node, int extraWidth) {
        if (node == null) {
            return;
        }
        if (this.scrollingDirective == ScrollingDirective.DONE || this.scrollingDirective == ScrollingDirective.ANCHOR) {
            this.scrollingDirective = ScrollingDirective.MAKE_NODE_VISIBLE;
        }
        if (this.scrolledNode != null && this.scrollingDirective != ScrollingDirective.MAKE_NODE_VISIBLE) {
            if (node != this.scrolledNode) {
                if (this.scrollingDirective == ScrollingDirective.SCROLL_TO_BEST_ROOT_POSITION && !node.isRoot()) {
                    this.scrollingDirective = ScrollingDirective.SCROLL_NODE_TO_CENTER;
                }
                this.scrollNode(node, this.scrollingDirective, false);
            }
            return;
        }
        if (!this.map.isValid()) {
            this.scrolledNode = node;
            this.scrollingDirective = ScrollingDirective.MAKE_NODE_VISIBLE;
            this.extraWidth = extraWidth;
            return;
        }
        int HORIZ_SPACE = 10;
        int HORIZ_SPACE2 = 20;
        int VERT_SPACE = 5;
        int VERT_SPACE2 = 10;
        JComponent nodeContent = node.getContent();
        int width = nodeContent.getWidth();
        if (extraWidth < 0) {
            nodeContent.scrollRectToVisible(new Rectangle(-10 + extraWidth, -5, (width -= extraWidth) + 20, nodeContent.getHeight() + 10));
        } else {
            nodeContent.scrollRectToVisible(new Rectangle(-10, -5, (width += extraWidth) + 20, nodeContent.getHeight() + 10));
        }
    }

    void scrollToRootNode() {
        this.scrollNode(this.map.getRoot(), ScrollingDirective.SCROLL_TO_BEST_ROOT_POSITION, false);
    }

    void scrollView() {
        if (this.scrolledNode != null && this.scrollingDirective != ScrollingDirective.MAKE_NODE_VISIBLE && this.scrollingDirective != ScrollingDirective.ANCHOR) {
            this.scrollNode(this.scrolledNode, this.scrollingDirective, this.slowScroll);
            return;
        }
        if (this.anchorContentLocation.getX() == 0.0 && this.anchorContentLocation.getY() == 0.0) {
            return;
        }
        JViewport vp = (JViewport)this.map.getParent();
        int scrollMode = vp.getScrollMode();
        vp.setScrollMode(0);
        Point viewPosition = vp.getViewPosition();
        Point oldAnchorContentLocation = this.anchorContentLocation;
        Point newAnchorContentLocation = this.getAnchorCenterPoint();
        int deltaX = newAnchorContentLocation.x - oldAnchorContentLocation.x;
        int deltaY = newAnchorContentLocation.y - oldAnchorContentLocation.y;
        if (deltaX != 0 || deltaY != 0) {
            viewPosition.x += deltaX;
            viewPosition.y += deltaY;
            vp.setViewPosition(viewPosition);
        } else {
            this.map.repaintVisible();
        }
        if (this.scrolledNode != null) {
            this.scrollNodeToVisible(this.scrolledNode, this.extraWidth);
        }
        vp.setScrollMode(scrollMode);
        this.scrolledNode = null;
        this.scrollingDirective = ScrollingDirective.DONE;
        this.setAnchorView(this.map.getRoot());
        this.anchorVerticalPoint = 0.0f;
        this.anchorHorizontalPoint = 0.0f;
        this.anchorContentLocation = this.getAnchorCenterPoint();
    }

    void setAnchorContentLocation() {
        this.anchorContentLocation = this.getAnchorCenterPoint();
    }

    public void scrollNodeTreeToVisible(NodeView node) {
        int lackingHeight;
        Rectangle visibleRect = this.map.getVisibleRect();
        Rectangle requiredRectangle = new Rectangle(node.getSize());
        int margin = 30;
        int spaceToCut = node.getSpaceAround() - margin;
        requiredRectangle.x += spaceToCut;
        requiredRectangle.y += spaceToCut;
        requiredRectangle.width -= 2 * spaceToCut;
        requiredRectangle.height -= 2 * spaceToCut;
        Rectangle contentBounds = node.getContent().getBounds();
        int lackingWidth = requiredRectangle.width - visibleRect.width;
        if (lackingWidth > 0) {
            int leftGap = contentBounds.x - requiredRectangle.x - margin;
            int rightGap = requiredRectangle.x + requiredRectangle.width - contentBounds.x - contentBounds.width - margin;
            requiredRectangle.width = visibleRect.width;
            requiredRectangle.x += lackingWidth * leftGap / (leftGap + rightGap);
        }
        if ((lackingHeight = requiredRectangle.height - visibleRect.height) > 0) {
            int topGap = contentBounds.y - requiredRectangle.y - margin;
            int bottomGap = requiredRectangle.y + requiredRectangle.height - contentBounds.y - contentBounds.height - margin;
            requiredRectangle.height = visibleRect.height;
            requiredRectangle.y += lackingHeight * topGap / (topGap + bottomGap);
        }
        if (!node.getVisibleRect().contains(requiredRectangle)) {
            node.scrollRectToVisible(requiredRectangle);
        }
    }

    void anchorToRoot() {
        NodeView root = this.map.getRoot();
        if (!root.equals(this.anchor)) {
            this.anchorToNode(root, 0.0f, 0.0f);
        }
    }
}

