/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URI;
import java.net.URL;
import java.security.AccessControlException;
import javax.swing.JEditorPane;
import javax.swing.JToolTip;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.JRestrictedSizeScrollPane;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.html.ScaledEditorKit;
import org.freeplane.core.ui.components.html.SynchronousScaledEditorKit;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.url.UrlManager;

public class NodeTooltip
extends JToolTip {
    private final JEditorPane tip = new JEditorPane();
    private int maximumWidth;

    public NodeTooltip(GraphicsConfiguration graphicsConfiguration) {
        this.tip.setContentType("text/html");
        this.tip.putClientProperty("JEditorPane.honorDisplayProperties", false);
        ScaledEditorKit kit = SynchronousScaledEditorKit.create();
        this.tip.setEditorKit(kit);
        this.tip.setEditable(false);
        this.tip.setMargin(new Insets(0, 0, 0, 0));
        LinkMouseListener linkMouseListener = new LinkMouseListener();
        this.tip.addMouseListener(linkMouseListener);
        this.tip.addMouseMotionListener(linkMouseListener);
        HTMLDocument document = (HTMLDocument)this.tip.getDocument();
        StyleSheet styleSheet = document.getStyleSheet();
        styleSheet.removeStyle("p");
        styleSheet.removeStyle("body");
        styleSheet.addRule("p {margin-top:0;}\n");
        JRestrictedSizeScrollPane scrollPane = new JRestrictedSizeScrollPane(this.tip);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(22);
        Rectangle screenBounds = graphicsConfiguration.getBounds();
        int screenHeigth = screenBounds.height - 80;
        int screenWidth = screenBounds.width - 80;
        int maximumHeight = Math.min(screenHeigth, this.getIntProperty("toolTipManager.max_tooltip_height"));
        int scrollBarWidth = scrollPane.getVerticalScrollBar().getPreferredSize().width;
        scrollPane.setMaximumSize(new Dimension(screenWidth, maximumHeight));
        this.maximumWidth = Math.min(screenWidth, this.getIntProperty("toolTipManager.max_tooltip_width")) - scrollBarWidth;
        UITools.setScrollbarIncrement(scrollPane);
        this.add(scrollPane);
        this.tip.setOpaque(true);
    }

    private int getIntProperty(String propertyName) {
        return ResourceController.getResourceController().getIntProperty(propertyName, Integer.MAX_VALUE);
    }

    @Override
    public void setTipText(String tipText) {
        try {
            this.setTipTextUnsafe(tipText);
        }
        catch (Exception e1) {
            if (e1 instanceof AccessControlException) {
                LogUtils.warn(e1.getMessage());
            } else {
                LogUtils.severe(e1);
            }
            String localizedMessage = e1.getLocalizedMessage();
            String htmlEscapedText = HtmlUtils.plainToHTML(localizedMessage + '\n' + tipText);
            try {
                this.setTipTextUnsafe(htmlEscapedText);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setTipTextUnsafe(String tipText) throws Exception {
        this.tip.setSize(0, 0);
        this.tip.setPreferredSize(null);
        this.tip.setText(tipText);
        Dimension preferredSize = this.tip.getPreferredSize();
        if (preferredSize.width > this.maximumWidth) {
            HTMLDocument document = (HTMLDocument)this.tip.getDocument();
            document.getStyleSheet().addRule("body { width: " + this.maximumWidth + "}");
            this.tip.setEditable(true);
            this.tip.setEditable(false);
            preferredSize = this.tip.getPreferredSize();
        }
        this.tip.setSize(preferredSize);
        preferredSize = this.tip.getPreferredSize();
        this.tip.setPreferredSize(preferredSize);
    }

    @Override
    public Dimension getPreferredSize() {
        Component scrollPane = this.getComponent(0);
        return scrollPane.getPreferredSize();
    }

    @Override
    public void layout() {
        Component scrollPane = this.getComponent(0);
        scrollPane.setSize(this.getPreferredSize());
        super.layout();
    }

    void scrollUp() {
        this.tip.scrollRectToVisible(new Rectangle(1, 1));
    }

    public void setBase(URL url) {
        ((HTMLDocument)this.tip.getDocument()).setBase(url);
    }

    class LinkMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        LinkMouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            int requiredCursor;
            String link = HtmlUtils.getURLOfExistingLink((HTMLDocument)NodeTooltip.this.tip.getDocument(), NodeTooltip.this.tip.viewToModel(ev.getPoint()));
            boolean followLink = link != null;
            Controller currentController = Controller.getCurrentController();
            if (followLink) {
                currentController.getViewController().out(link);
                requiredCursor = 12;
            } else {
                requiredCursor = 0;
            }
            if (NodeTooltip.this.tip.getCursor().getType() != requiredCursor) {
                NodeTooltip.this.tip.setCursor(requiredCursor != 0 ? new Cursor(requiredCursor) : null);
            }
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            String linkURL;
            if (Compat.isPlainEvent(ev) && (linkURL = HtmlUtils.getURLOfExistingLink((HTMLDocument)NodeTooltip.this.tip.getDocument(), NodeTooltip.this.tip.viewToModel(ev.getPoint()))) != null) {
                try {
                    UrlManager.getController().loadURL(new URI(linkURL));
                }
                catch (Exception e) {
                    LogUtils.warn(e);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }
}

