/*
 * Decompiled with CFR 0.152.
 */
import com.swabunga.spell.engine.Configuration;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.engine.Word;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;

public class JSpellChecker
extends Applet {
    private boolean initialized = false;
    protected SpellCheckEvent event;
    protected SpellChecker checker;
    private StringWordTokenizer tokens;
    private JSpellCheckListener listener;
    private static final int IGNORE_ALL_CAPS_WORD = 2;
    private static final int IGNORE_CAPPED_WORD = 4;
    private static final int IGNORE_MIXED_CASE = 8;
    private static final int IGNORE_MIXED_DIGITS = 16;
    private static final int REPORT_DOUBLED_WORD = 64;
    private static final int IGNORE_DOMAIN_NAMES = 65536;
    private static Hashtable configmap = new Hashtable();

    static {
        configmap.put(new Integer(16), "SPELL_IGNOREDIGITWORDS");
        configmap.put(new Integer(65536), "SPELL_IGNOREINTERNETADDRESS");
        configmap.put(new Integer(8), "SPELL_IGNOREMIXEDCASE");
        configmap.put(new Integer(64), "SPELL_IGNOREMULTIPLEWORDS");
        configmap.put(new Integer(4), "SPELL_IGNORESENTENCECAPTILIZATION");
        configmap.put(new Integer(2), "SPELL_IGNOREUPPERCASE");
    }

    @Override
    public void init() {
        JSpellChecker.log(String.valueOf(this.hashCode()) + ": JSpellChecker.init");
        String dictionary = this.getParameter("dictionary");
        this.checker = new SpellChecker();
        StringTokenizer strtok = new StringTokenizer(dictionary, " ;:");
        while (strtok.hasMoreElements()) {
            InputStream is = this.getClass().getResourceAsStream(strtok.nextToken());
            try {
                this.checker.addDictionary(new SpellDictionaryHashMap(new InputStreamReader(is)));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.initialized = true;
    }

    public void setText(String text) {
        JSpellChecker.log(String.valueOf(this.hashCode()) + ": JSpellChecker.setText(" + text + ")");
        if (!this.initialized) {
            throw new IllegalStateException("Spellchecker is loading.");
        }
        this.checker.removeSpellCheckListener(this.listener);
        this.tokens = new StringWordTokenizer(text);
        this.listener = new JSpellCheckListener(this.tokens);
        this.checker.addSpellCheckListener(this.listener);
        this.checker.reset();
    }

    public void setOptions(int options) {
        Configuration config = this.checker.getConfiguration();
        int i = 1;
        while (i <= 131072) {
            String key = (String)configmap.get(new Integer(i));
            if (key != null) {
                config.setBoolean(key, (options & i) > 0);
            }
            i <<= 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean check() {
        if (!this.listener.isAlive()) {
            this.listener.start();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.listener.done();
        }
        JSpellCheckListener jSpellCheckListener = this.listener;
        synchronized (jSpellCheckListener) {
            this.listener.notifyAll();
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.listener.done();
    }

    private String getSuggestionList(List suggestions) {
        String s = "";
        for (Word element : suggestions) {
            s = String.valueOf(s) + element.getWord() + "|";
        }
        return s;
    }

    public String getSuggestions() {
        return this.getSuggestionList(this.event.getSuggestions());
    }

    public String getSuggestions(String word) {
        return this.getSuggestionList(this.checker.getSuggestions(word, 0));
    }

    public String getMisspelledWord() {
        if (this.event != null) {
            return this.event.getInvalidWord();
        }
        return null;
    }

    public int getCursorPosition() {
        if (this.event != null) {
            return this.event.getWordContextPosition();
        }
        return 0;
    }

    public void changeWord(String word, boolean all) {
        if (this.event != null) {
            if (word == null) {
                word = "";
            }
            this.event.replaceWord(word, all);
        }
    }

    public void ignoreWord(boolean all) {
        if (this.event != null) {
            this.event.ignoreWord(all);
        }
    }

    protected static void log(String s) {
        System.out.println(s);
    }

    private class JSpellCheckListener
    extends Thread
    implements SpellCheckListener {
        private boolean done;
        private StringWordTokenizer tokens;

        private JSpellCheckListener(StringWordTokenizer tokens) {
            JSpellChecker.log(String.valueOf(this.hashCode()) + ": JSpellCheckListener.init");
            this.tokens = tokens;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void spellingError(SpellCheckEvent event) {
            JSpellChecker.log(String.valueOf(this.hashCode()) + ": JSpellCheckListener.spellingError");
            JSpellChecker.this.event = event;
            JSpellChecker jSpellChecker = JSpellChecker.this;
            synchronized (jSpellChecker) {
                JSpellChecker.this.notifyAll();
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public boolean done() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JSpellChecker.log(String.valueOf(this.hashCode()) + ": JSpellCheckListener.run");
            this.done = false;
            JSpellChecker.this.checker.checkSpelling(this.tokens);
            this.done = true;
            JSpellChecker jSpellChecker = JSpellChecker.this;
            synchronized (jSpellChecker) {
                JSpellChecker.this.notifyAll();
            }
        }
    }
}

