/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.ColumnIterator;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlLog;
import com.imaginary.sql.msql.ParsedRow;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;

public class RowTokenizer
implements ParsedRow {
    private boolean complete = false;
    private ArrayList columns = new ArrayList();
    private String encoding = "8859_1";
    private MsqlLog log = null;
    private MsqlException parseException = null;
    private byte[] rawData = null;
    private int size = -1;

    public RowTokenizer(byte[] byArray, String string, int n) {
        this.log = new MsqlLog(n, this);
        this.encoding = string;
        this.rawData = byArray;
        try {
            this.log.log("constructor", 16, "Parsing row " + new String(byArray, this.encoding));
        }
        catch (Exception exception) {
            this.log.log("constructor", 8, "Encoding " + string + " not supported: " + exception.getMessage());
        }
        Thread thread = new Thread(){

            public void run() {
                RowTokenizer.this.parse();
            }
        };
        thread.start();
    }

    public Iterator columns() throws MsqlException {
        return new ColumnIterator(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String get(int n) throws MsqlException {
        if (this.parseException != null) {
            throw this.parseException;
        }
        ArrayList arrayList = this.columns;
        synchronized (arrayList) {
            if (this.columns.size() >= n + 1) return (String)this.columns.get(n);
            if (this.complete) {
                throw new IndexOutOfBoundsException();
            }
            while (true) {
                if (this.complete) {
                    return (String)this.columns.get(n);
                }
                try {
                    this.columns.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasColumn(int n) throws MsqlException {
        if (this.parseException != null) {
            throw this.parseException;
        }
        ArrayList arrayList = this.columns;
        synchronized (arrayList) {
            if (n < this.size) {
                return true;
            }
            while (!this.complete) {
                if (n < this.columns.size()) {
                    return true;
                }
                try {
                    this.columns.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (n < this.columns.size()) return true;
        return false;
    }

    private void parse() {
        int n = 0;
        while ((n = this.readColumn(n)) != -1) {
        }
        ArrayList arrayList = this.columns;
        synchronized (arrayList) {
            this.complete = true;
            this.columns.notifyAll();
        }
    }

    /*
     * Unable to fully structure code
     */
    private int readColumn(int var1_1) {
        var2_2 = var1_1;
        if (this.rawData.length > var1_1) ** GOTO lbl5
        return -1;
lbl-1000:
        // 1 sources

        {
            ++var2_2;
lbl5:
            // 2 sources

            ** while (this.rawData[var2_2] != 58 && this.rawData[var2_2] != 13 && this.rawData[var2_2] != 10)
        }
lbl6:
        // 1 sources

        if (var2_2 == var1_1) {
            var6_3 = this.columns;
            synchronized (var6_3) {
                this.columns.add(null);
                this.columns.notifyAll();
                var5_4 = ++var2_2;
                var7_6 = null;
                return var5_4;
            }
        }
        var3_7 = new byte[var2_2 - var1_1];
        System.arraycopy(this.rawData, var1_1, var3_7, 0, var3_7.length);
        ++var2_2;
        try {
            var5_5 = new String(var3_7, "8859_1");
            var4_8 = Integer.parseInt((String)var5_5);
        }
        catch (UnsupportedEncodingException v1) {
            var5_5 = new String(var3_7);
            var4_8 = Integer.parseInt((String)var5_5);
        }
        if (var4_8 == -2) {
            var5_5 = this.columns;
            synchronized (var5_5) {
                this.columns.add(null);
                this.columns.notifyAll();
            }
        }
        if (var4_8 == 0) {
            var5_5 = this.columns;
            synchronized (var5_5) {
                this.columns.add(null);
                this.columns.notifyAll();
            }
        }
        var3_7 = new byte[var4_8];
        System.arraycopy(this.rawData, var2_2, var3_7, 0, var4_8);
        var2_2 += var4_8;
        try {
            var5_5 = this.columns;
            synchronized (var5_5) {
                this.columns.add(new String(var3_7, this.encoding));
                this.columns.notifyAll();
            }
        }
        catch (UnsupportedEncodingException v5) {
            var5_5 = this.columns;
            synchronized (var5_5) {
                this.columns.add(new String(var3_7));
                this.columns.notifyAll();
            }
        }
        return var2_2;
    }

    public void set(int n, String string) {
        this.columns.set(n, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int size() throws MsqlException {
        if (this.parseException != null) {
            throw this.parseException;
        }
        ArrayList arrayList = this.columns;
        synchronized (arrayList) {
            while (true) {
                if (this.size != -1) {
                    return this.size;
                }
                try {
                    this.columns.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public String toString() {
        try {
            return new String(this.rawData, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return super.toString();
        }
    }
}

