/*
 * Decompiled with CFR 0.152.
 */
package biege;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class TextBox {
    private boolean enabled;
    private String[] content;
    private Color backColour = Color.black;
    private Color foreColour = Color.white;
    private int longestLine = 0;
    private static int FONT_POINT_SIZE = 12;

    public TextBox(String[] dlg) {
        this.content = dlg;
        this.longestLine = 0;
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i].length() <= this.longestLine) continue;
            this.longestLine = this.content[i].length();
        }
    }

    public void draw(Graphics g, int w, int h) {
        g.setColor(this.backColour);
        g.setFont(new Font(null, 1, FONT_POINT_SIZE));
        g.fillRect(0, 0, w, h);
        int fontHeight = h / (this.content.length + 1);
        g.setColor(this.foreColour);
        for (int l = 0; l < this.content.length; ++l) {
            g.drawString(String.valueOf(" ").concat(String.valueOf(this.content[l])), 0, (l + 1) * fontHeight);
        }
    }

    public static TextBox testTextBox() {
        String[] temp = new String[]{"Hello how are you today?", "Fine!", "Super!", "WOW", "This is phun!"};
        return new TextBox(temp);
    }

    public static TextBox defaultTextBox() {
        String[] temp = new String[]{"There is nothing extiting", "to see here", "[Press ENTER]"};
        return new TextBox(temp);
    }
}

