package biege;
import java.awt.Graphics;
import java.awt.Font;
import java.awt.Color;


public class TextBox extends Object
{
  private boolean enabled;
  private String[] content;
  private Color backColour = Color.black;
  private Color foreColour = Color.white;
  private int longestLine = 0;
  private static int FONT_POINT_SIZE = 12;



  public TextBox(String[] dlg)
  {
    super();
    content = dlg;

    longestLine = 0;
    for (int i = 0; i < content.length; i++)
    {
      if (content[i].length() > longestLine)
        longestLine = content[i].length();
    }
  }

  public void draw(Graphics g, int w, int h)
  {
    g.setColor(backColour);
    g.setFont(new Font(null, Font.BOLD, FONT_POINT_SIZE));

    g.fillRect(0,0, w, h);

    int fontHeight = h / (content.length + 1);
 
    g.setColor(foreColour);
    for (int l = 0; l < content.length; l++)
      g.drawString(" " + content[l], 0,  (l+1)* fontHeight);

  }

  public static TextBox testTextBox()
  {
        String[] temp = {"Hello how are you today?",
                     "Fine!",
                     "Super!",
                     "WOW",
                     "This is phun!"};
                     
      return new TextBox(temp);
  }

  public static TextBox defaultTextBox()
  {
        String[] temp = {"There is nothing extiting",
                     "to see here",
                     "[Press ENTER]"};

      return new TextBox(temp);
  }

}
