(provide 'snd-peak-phases.scm)
(load "primes.scm")

;;; multiply these phases by pi before use as initial-phases (and use sin, not cos -- see tstall below)


;;; ---------------------------------------- all harmonics ----------------------------------------

(define noid-min-peak-phases (vector

#(1  1.0    #(0))
#(2  1.76   #(0 0))

;; the 1.76 can be calculated (given here that 0 is the min)
;;   take derivative of sin(x) + sin(2x) = cos(x) + 2cos(2x)
;;   use cos(2x) = 2cos^2(x) - 1 to turn this into a quadratic polynomial in cos(x)
;;       4cos^2(x) + cos(x) - 2
;;   let x be cos(x), quadratic formula gives (-1 + sqrt(33))/8, [poly-roots (vct -2 1 4) -> (0.59307033081725 -0.84307033081725)]
;;   take acos of that to get cos(x): 
;;      (acos (+ -1/8 (/ (sqrt (+ 1 32)) 8))) -> 0.93592945566133
;;   plug that into the original: 
;;      (+ (sin 0.93592945566133) (sin (* 2 0.93592945566133))) -> 1.7601725930461
;;   see smax in clm.c -- this works for small n
;;
;; for 1+3, diff is 12cos^3x-8cosx so (acos 0) = pi/2 is a red-herring, but 3cos^2x-2 -> x = (sqrt 2/3), (acos (sqrt 2/3)) -> 0.61547970867039
;;    and (+ (sin 0.61547970867039) (sin (* 3 0.61547970867039))) is 1.539600717839 and
;;    1.5396 + 0.4604 * sin(initial-phase) is very close.
;;
;; we can show that phase=0 is the global min by using simultaneous non-linear equations:
;;
;;   let peak-loc = (acos (/ (- (sqrt 33) 1) 8))
;;       peak (+ (sin peak-loc) (sin (* 2 peak-loc)))
;;       and assume we're focusing on the 1st min (not pi)
;;
;;   sin(peak-loc) + sin(2*peak-loc + phase) <= peak
;;   so sin(2*peak-loc (i.e. 1.8718) + phase) < (peak - sin(peak-loc)) = 0.9551, but that means phase >= 0 (sin is going down at this point)
;;   sin(-peak-loc) + sin(2*(-peak-loc) + phase) >= -peak
;;   so sin(2*(-peak-loc) + phase) >= -(peak - sin(peak-loc)) = -0.9551, so phase <= 0 (sin is going up)
;;   so phase must be 0 [this argument assumes the peak loc is not jumping around randomly]
;;
;;   I think we can play the same game in n=3 case, but now there are 6 (12?) peaks to fiddle with and 4 global mins
;;   so it's messier.


;; there's always an equivalent point found by flipping the even harmonics, and another pair at 2-val (symmetry around 0)
;; so there are 4 equivalent points.  A function that returns the other 3 given 1 is at the end of this file.


;;; 3 all --------------------------------------------------------------------------------
#(3  2.1949383250709 #(0 0 1)

     1.9798054823226 #(0.0 5.897251124274717204443163609539624303579E-1 3.166675693251937984129540382127743214369E-1) 
     1.9798054823222 #(0.0 4.102748875720859667026729766803327947855E-1 1.683332430673265878162681019603041931987E0)  
     1.9798054823226 #(0.0 1.58972511242745917492413809668505564332E0 3.166675693251493894919690319511573761702E-1)
     1.9798054823222 #(0.0 1.410274887572085966702672976680332794785E0 1.683332430673265878162681019603041931987E0)

     ;; :(tstall '#(0 62/39 19/60))
     ;; (1.979860844111887127172689015942912379187E0 5.5534000000004)
     ;; same for #(0 23/39 19/60), always the case (it's symmetric in the 2nd), sin(x) +/- sin(2x + a) + sin(3x + b)
     ;; :(tstall #(0.0 5.897251124274717204443163609539624303579E-1 3.166675693251937984129540382127743214369E-1) 0.0000001)
     ;; (1.979806197137575924716806491964687429097E0 0.1714663000039)

     1.9797181063317 #(0.0 0.41022177723939 1.6832780274654)
     1.979716725384 #(0.0 1.5897793760084 0.31672588155614)
     1.9797162690553 #(0.0 1.4102202429311 1.6832728267862)
     )


;;; 4 all --------------------------------------------------------------------------------
#(4  2.2962718935302 #(0 1 1 1)

     2.040  #(0 33/35 67/50 10/9)               ;#(0 1/9 17/24 71/36) -- 2.04242
     2.04012799263 #(0.000 0.072 0.674 1.912)
     2.04012799263 #(0.000 0.928 1.326 1.088)
     2.04012799263 #(0.000 1.072 0.674 0.912)
     2.04012799263 #(0.000 1.928 1.326 0.088)

     2.0392323180235 #(0.0 9.429973765023149656627765580196864902973E-1 1.340090256365081833322960846999194473028E0 1.112605206055434337031329050660133361816E0)

     2.038956 #(0.000000 0.944585 1.341508 1.115059)
     2.038954 #(0.000000 1.055406 0.658486 0.884929)
     2.038954 #(0.000000 0.055405 0.658485 1.884926)
     2.038954 #(0.000000 1.944593 1.341515 0.115071)
     )

;;; 5 all -------------------------------------------------------------------------------- ; 2.23
#(5  2.5405211753511 #(0 1 0 0 0)

     2.3434929847717 #(0.0 0.84531772136688 1.6645057201385 1.4203575849533 1.5933285951614)
     2.3434844481891 #(0.0 1.8453152570243 1.6649825491504 0.42142125263938 1.5942588576594)

     2.343549 #(0.000000 1.845237 1.664402 0.420189 1.593154)
     2.343533 #(0.000000 1.154716 0.335535 0.579695 0.406714)
     2.343497 #(0.000000 0.845320 1.664496 1.420334 1.593308)
     
     2.343527 #(0.000000 0.154667 0.335503 1.579672 0.406698)
     2.343513 #(0.000000 0.154687 0.335490 1.579647 0.406677)
     2.343508 #(0.000000 1.845332 1.664532 0.420369 1.593338)
     )

;;; 6 all -------------------------------------------------------------------------------- ; 2.4494
#(6  2.8200183503167 #(0 0 0 0 1 0) 

     2.5598928928375 #(0.0 0.91140931844711 0.34124284982681 1.3568490743637 1.4451304674149 1.2563138008118)
     2.5509102344513 #(0.0 0.88722838124921 0.26020415169852 1.2966409163042 1.3233535939997 1.15281977798)
     2.5493413065822 #(0.0 0.88655948906463 0.26426014425456 1.3003055923199 1.3306838066896 1.1573162129407)

     2.549466 #(0.000000 1.113453 1.735461 0.699472 0.668803 0.842320)
     2.549414 #(0.000000 0.886661 0.264519 1.300599 1.331194 1.157723)
     2.549386 #(0.000000 0.113427 1.735535 1.699526 0.668940 1.842412)
     2.549385 #(0.000000 1.886568 0.264458 0.300485 1.331039 0.157570)
     2.549360 #(0.000000 0.886491 0.264319 1.300337 1.330828 1.157371)
     )

;;; 7 all -------------------------------------------------------------------------------- ; 2.64575
#(7  3.072141248417 #(0 0 0 1 1 0 1)

     2.639426 #(0.000000 0.904980 0.986109 1.721148 1.291116 1.621443 0.966099)
     2.639402 #(0.000000 0.095202 1.014213 1.278914 0.709149 1.378847 1.034223)
     2.639371 #(0.000000 1.095652 1.014884 0.279318 0.709755 0.379605 1.035166)
     2.639364 #(0.000000 1.904695 0.985719 0.720925 1.290796 0.621014 0.965536)
     )

;;; 8 all -------------------------------------------------------------------------------- ; 2.8284
#(8  3.5725696916739 #(0 1 0 0 0 0 1 1)
     3.4905790371793 #(0 1 0 0 1 1 1 0)

     2.795099 #(0.000000 1.333103 1.192134 0.394213 1.162609 1.955320 1.855302 0.126169)
     2.794748 #(0.000000 0.333225 1.192073 1.394414 1.162519 0.954914 1.855082 1.126189)
     2.794737 #(0.000000 1.666686 0.807757 0.605305 0.837099 1.044558 0.144428 0.873255)
     2.794719 #(0.000000 0.666709 0.807769 1.605408 0.837217 0.044625 0.144433 1.873342)
     2.794585 #(0.000000 0.666699 0.807707 1.605285 0.837106 0.044540 0.144374 1.873180)
     )

;;; 9 all --------------------------------------------------------------------------------
#(9  3.7118878501776 #(0 0 0 0 1 0 0 0 1)
     3.5954569026984 #(0 1 1 0 1 0 1 1 1)

     2.962087 #(0.000000 0.872517 1.501013 0.464057 -0.056897 1.063020 1.251698 1.436014 1.254131)
     2.962094 #(0.000000 1.127564 0.498862 1.535743 0.056794 0.936657 0.748023 0.563510 0.745376)
     2.962065 #(0.000000 -0.127444 1.501316 1.464492 -0.056263 0.063823 1.252240 0.437075 1.255320)
     2.961916 #(0.000000 0.127632 0.498978 0.536080 0.057253 -0.062716 0.748729 1.564172 0.746161)
     2.961829 #(0.000000 1.872309 1.500693 1.463585 1.942384 0.062267 1.250564 0.435026 1.252813)
     2.961652 #(0.000000 1.872337 1.500914 1.463820 1.942618 0.062504 1.251193 0.435609 1.253539)
     )

;;; 10 all -------------------------------------------------------------------------------- ; 3.162
#(10 3.8132503352626 #(0 1 0 1 0 0 0 0 0 1)
     3.7726427002737 #(0 1 1 0 0 0 0 1 0 1)
     3.7587492407668 #(0 1 1 0 1 1 1 0 0 0)
     3.7587492407668 #(0 0 1 1 1 0 1 1 0 1)

     3.102964 #(0.000000 0.071632 0.396251 0.504925 0.052683 0.212597 1.057168 -0.172275 1.102043 0.501144)
     3.102823 #(0.000000 1.070629 0.394872 1.503703 0.050925 1.211208 1.054650 0.825637 1.099957 1.498128)
     3.102782 #(0.000000 0.927743 1.602314 0.494139 -0.054832 0.785103 0.940332 1.169212 0.894844 0.494709)
     3.102734 #(0.000000 1.928606 1.603786 1.495372 -0.052790 1.786999 0.942669 0.172108 0.897837 1.498611)
     3.102729 #(0.000000 -0.072172 1.602638 1.494434 -0.054524 1.785698 0.940876 0.169981 0.895530 1.495531)
     3.102679 #(0.000000 -0.071505 1.603768 1.495148 -0.052966 1.786780 0.942656 0.171631 0.897221 1.498092)
     3.102303 #(0.000000 -0.071891 1.603086 1.494633 -0.053985 1.786024 0.941426 0.170569 0.896122 1.496522)
     )

;;; 11 all -------------------------------------------------------------------------------- ; 3.31662
#(11 4.0969838225299 #(0 0 1 1 0 0 0 0 1 0 1)
     4.0506916989601 #(0 0 0 1 1 1 1 0 1 1 0)
     3.8018732822274 #(0 1 0 0 1 0 0 0 1 1 1)
     3.8018732822274 #(0 0 0 1 1 1 0 1 1 0 1)

     3.218745  #(0.000000 1.518100 1.908924 1.617043 1.540909 0.660141 -0.056826 0.670660 1.165195 1.212229 0.198401)
     3.218587 #(0.000000 0.518100 1.908924 0.617043 1.540909 1.660141 -0.056826 1.670660 1.165195 0.212229 0.198401)
     3.218514 #(0.000000 0.481786 0.091759 0.383540 0.459429 1.340439 0.058075 1.330988 0.836240 0.789345 -0.196819)
     3.218444 #(0.000000 0.482127 0.090769 0.383093 0.459045 1.339823 0.056682 1.328792 0.834826 0.787716 -0.199032)
     3.217965 #(0.000000 0.482287 0.091029 0.383292 0.459507 1.340271 0.057231 1.329368 0.835616 0.788459 -0.198129)
     )

;;; 12 all -------------------------------------------------------------------------------- ; 3.464
#(12 3.761           #(0 0 1 1 0 0 0 0 0 1 0 1)
     3.7616552322386 #(0 1 1 0 0 1 0 1 0 0 0 0)

     3.389586 #(0.000000 0.076743 0.348321 0.615321 0.763893 0.188090 0.117764 1.147735 1.461927 0.591300 1.497863 0.867456)
     3.389547 #(0.000000 -0.079085 1.648740 1.380212 1.228354 1.804105 1.875295 0.844196 0.527781 1.396624 0.490362 1.119947)
     3.389430 #(0.000000 1.081078 0.354514 1.624157 0.776410 1.200581 0.129241 0.162495 1.480822 1.614178 1.518801 1.892528)
     3.389128 #(0.000000 1.076659 0.348730 1.615059 0.764020 1.188577 0.117561 0.148053 1.462454 1.591386 1.497945 1.868055)
     3.388654 #(0.000000 1.076620 0.347797 1.614462 0.764164 1.188107 0.116910 0.147164 1.461571 1.590619 1.496557 1.866148)
     )

;;; 13 all -------------------------------------------------------------------------------- ; 3.6055
#(13 4.2969298731102 #(0 1 0 1 0 0 1 1 0 0 0 0 0)
     4.1211657406183 #(0 0 0 0 0 0 1 1 0 0 1 0 1) 

     3.525309 #(0.000000 1.051846 0.170520 1.635159 0.455907 1.511384 -0.147127 1.055447 1.000548 0.097871 0.005880 0.160672 0.616896)
     3.525164 #(0.000000 0.947554 1.827637 0.362791 1.540717 0.485315 0.143016 0.940517 0.994364 1.896615 -0.012058 1.833412 1.375539)
     3.525069 #(0.000000 0.947187 1.827546 0.362752 1.541123 0.485247 0.142279 0.941021 0.994821 1.896143 -0.012766 1.832600 1.375866)

     ;; tstall (flip odds):
     3.5254909 #(0.000000 0.051846 0.170520 0.635159 0.455907 0.511384 -0.147127 0.055447 1.000548 1.097871 0.005880 1.160672 0.616896)

     3.525038 #(0.000000 0.946517 1.827042 0.361916 1.539603 0.484426 0.141403 0.938505 0.992273 1.893878 -0.015423 1.830018 1.372777)
     3.524879 #(0.000000 0.948502 1.829668 0.364984 1.544240 0.488687 0.147763 0.945396 1.000061 1.903153 -0.004551 1.840699 1.384079)
     3.524127 #(0.000000 0.948325 1.829839 0.364837 1.544231 0.489035 0.147691 0.944940 1.000036 1.902764 -0.004752 1.840449 1.384160)
     )

;;; 14 all -------------------------------------------------------------------------------- ; 3.7416
#(14 4.3488449994701 #(0 0 1 1 0 1 0 1 1 0 0 0 0 0)
     4.1603193984251 #(0 1 0 1 1 0 1 0 0 0 1 0 0 0) 

     3.613280 #(0.000000 0.028982 0.530538 0.496734 -0.474935 -0.580078 0.104750 1.488617 -0.565757 -0.157842 -1.258035 -0.057079 0.253472 -0.294346)
     3.613121 #(0.000000 0.028974 0.530453 0.496128 -0.475742 -0.580534 0.104588 -0.512201 1.433649 1.841085 0.741103 -0.058374 0.252301 -0.295482)
     3.612244 #(0.000000 0.028654 0.530107 0.495786 -0.476137 -0.581023 0.103729 -0.513152 1.433095 1.840437 0.739729 -0.059420 0.251093 -0.296875)
     )

;;; 15 all -------------------------------------------------------------------------------- ; 3.8729
#(15 4.4060654286219 #(0 1 0 1 0 1 1 1 1 1 0 1 1 0 0) ; 3.87298 (3.8729833462074)

     3.768991 #(0.000000 0.863434 1.069349 1.651266 0.272078 0.287377 1.735528 1.050008 0.997192 -0.020076 1.092043 1.658049 1.188297 1.641481 1.391589)
     3.768033 #(0.000000 0.863152 1.069135 1.651353 0.271851 0.287255 1.735115 1.049678 0.996877 -0.020587 1.091869 1.657562 1.187769 1.641176 1.391193)
     )

;;; 16 all --------------------------------------------------------------------------------
#(16 4.6832396970099 #(0 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0)
     4.5445760745314 #(0 1 1 0 1 0 1 0 0 0 1 1 0 0 0 0)

     3.875080 #(0.000000 0.730612 0.678979 1.195144 1.632126 1.276744 -0.008560 1.467028 0.525375 0.204869 -0.166129 -0.115302 1.317856 1.622654 0.244306 1.412402)
     3.873760 #(0.000000 0.727564 0.672436 1.188603 1.622426 1.266314 -0.018679 1.451325 0.507181 0.185750 -0.189066 -0.140317 1.293402 1.595942 0.216437 1.382779)
     )

;;; 17 all -------------------------------------------------------------------------------- ; 4.1231
#(17 4.7478643837553 #(0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1)
     4.7478643837553 #(0 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1)
     4.7654988506492 #(0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 1 1)
     4.7654988506492 #(0 1 0 1 1 0 0 0 0 1 1 0 1 1 1 0 1)

     3.981459 #(0.000000 0.520484 1.429480 0.505816 -0.891395 0.114390 0.146335 0.416197 0.938893 0.898753 0.507264 0.650687 -0.081499 -0.607990 0.213218 -0.096782 -0.652476)
     3.980210 #(0.000000 0.519908 1.429364 0.506455 -0.889349 0.115888 0.147799 0.418944 0.941982 0.901488 0.510707 0.653289 -0.078010 -0.603698 0.217190 -0.091931 -0.646982)
     )

;;; 18 all -------------------------------------------------------------------------------- ; 4.24264
#(18 4.9109328272248 #(0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 0)
     4.8247395547715 #(0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 1 0)
     4.795  #(0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0) 

     4.145376 #(0.000000 0.815970 1.442468 0.022437 0.838057 0.561089 1.647234 0.678944 1.711039 1.021597 1.327383 0.016884 -0.030470 1.937927 0.480054 1.947188 1.779952 1.482341)
     4.143797 #(0.000000 0.818014 1.444164 0.024749 0.841333 0.563942 1.651378 0.683332 1.716474 1.028213 1.333307 0.023380 -0.024413 1.945329 0.488400 1.955424 1.789772 1.492736)
     )

;;; 19 all -------------------------------------------------------------------------------- ; 4.35889
#(19 5.0964118877766 #(0 0 0 0 1 1 0 1 0 0 1 0 0 0 1 0 0 0 1)
     5.0269187181249 #(0 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0)
     5.0140104455275 #(0 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 0)
     4.957  #(0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1) 

     4.220950 #(0.000000 0.963878 0.724427 1.142775 1.347933 0.681634 0.858134 1.165699 1.071759 -0.202310 0.544201 1.698473 0.575529 0.392352 1.327300 -0.513540 0.980505 1.004716 0.307249)
     )

;;; 20 all -------------------------------------------------------------------------------- ; 4.4721
#(20 5.2602326468873 #(0 1 1 0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1)
     5.2536671092168 #(0 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1) 
     5.2516581503036 #(0 1 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 0 1)
     5.2027356749364 #(0 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0) 
     5.202707605727 #(0 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0)

     4.288981 #(0.000000 1.288096 1.467454 -0.169090 1.858403 0.280935 0.217741 -0.031571 0.876318 1.220549 0.027164 0.381448 1.736192 1.508757 1.292734 0.007137 1.225400 0.645757 1.237414 0.420948)
     )

;;; 21 all -------------------------------------------------------------------------------- ; 4.5825
#(21 5.3651112556805 #(0 1 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 1)
     5.3503630356826 #(0 1 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1)
     5.3430035169068 #(0 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 0 1)
     5.3468859417495 #(0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1)
     5.3164971341632 #(0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 1 0 0 0) 
     5.3164971341632 #(0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0)

     4.482399 #(0.000000 1.397497 1.231727 1.288294 -0.006341 1.417563 -0.224775 1.544084 0.158820 1.058039 0.318600 1.788531 1.041209 0.988222 1.527762 0.536397 0.600751 0.298693 0.721205 1.590350 -0.083320)
     )

;;; 22 all -------------------------------------------------------------------------------- ; 4.6904
#(22 5.3384906472168 #(0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 0 1)
     5.3118962410791 #(0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0)
     5.29249935509144 #(0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1) 
     5.292244006282 #(0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0)

     4.586632 #(0.000000 -0.097347 1.080504 0.590888 -0.253961 1.023423 0.714156 1.899465 -0.021982 0.277218 1.158938 0.994197 1.053415 1.055197 1.429563 0.904330 0.879709 1.421582 0.356096 1.550705 0.340822 1.056446)
     )

;;; 23 all -------------------------------------------------------------------------------- ; 4.7958
#(23 5.5572876930237 #(0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 0)
     5.35928895203514 #(0 1 1 0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1) 
     5.3592889520338 #(0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1)

     4.605166 #(0.000000 0.690307 -0.223703 0.265767 1.214689 0.913389 0.192629 1.489393 1.370656 0.848931 0.362934 0.592228 0.586290 0.001276 1.085398 1.699229 1.577973 0.044583 0.292577 1.343812 0.079208 -0.074880 0.197817)
     )

;;; 24 all -------------------------------------------------------------------------------- ; 4.89897
#(24 5.7082858085632 #(0 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0)
     5.6697635650635 #(0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0)
     5.6446962356567 #(0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0)
     5.635  #(0 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1) 
     5.6358969066981 #(0 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 0 1 1 0)

     4.728042 #(0.000000 1.858980 1.366314 1.303093 0.303565 0.363906 -0.013052 0.288365 1.150614 1.733252 0.305478 1.054343 0.956930 0.688496 0.150610 0.766590 0.723928 0.358579 1.444965 0.475911 1.678841 0.331630 0.146133 0.753447)
     )

;;; 25 all -------------------------------------------------------------------------------- ; 5
#(25 5.7284736633301 #(0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0)
     5.7190117835999 #(0 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1)
     5.6488965032573 #(0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0) 
     5.6488965032573 #(0 1 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0)

     4.853136 #(0.000000 0.231156 1.726027 0.449218 0.014875 0.016936 0.462137 0.871821 0.609989 0.654860 0.063408 0.827651 0.577530 -0.078679 -0.110847 1.742364 0.577571 0.893703 1.390261 0.669384 1.847505 1.342504 1.778537 0.655762 1.007768)
     )

;;; 26 all -------------------------------------------------------------------------------- ; 5.0990
#(26 5.8922033309937 #(0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0)
     5.8206262588501 #(0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0)
     5.78661186695166 #(0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 1) 
     5.7865648269653 #(0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0)

     5.004963 #(0.000000 0.356503 0.613044 0.799459 0.607543 -0.552567 0.275717 0.954617 0.539225 0.390115 0.747516 -0.287816 0.661916 1.821078 -0.045167 -0.217306 1.531723 0.896950 0.283527 0.968137 0.942126 0.004913 -0.474898 0.935500 1.374671 0.106691)
     )

;;; 27 all -------------------------------------------------------------------------------- ; 5.1961
#(27 5.980658531189 #(0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1)
     5.8753982451551 #(0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0) 
     5.8753981590271 #(0 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0)

     5.063979 #(0.000000 1.181312 1.011523 -0.037795 0.952214 0.743188 0.046346 -0.011550 1.593930 1.829003 1.926981 0.836368 0.497093 0.820784 0.581154 1.308971 0.813642 0.203348 0.448693 0.869589 1.163120 0.319576 0.498929 -0.074366 0.820574 1.666665 0.421783)
     )

;;; 28 all -------------------------------------------------------------------------------- ; 5.2915
#(28 6.1332263946533 #(0 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0)
     6.107029914856 #(0 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1)
     6.0962085723877 #(0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0) 
     6.0962085723877 #(0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1)

     5.157284 #(0.000000 0.613262 -0.034248 0.167107 1.753362 0.009121 1.168065 1.319935 0.754215 1.452315 0.403030 1.384036 -0.445049 1.700477 0.448730 1.102474 0.302577 0.114957 0.813938 -1.221580 0.733588 -0.228287 1.379195 0.775101 0.357079 0.863661 0.744441 -0.542730)
     )

;;; 29 all -------------------------------------------------------------------------------- ; 5.38516
#(29 6.2162199020386 #(0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0)
     6.2025485038757 #(0 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1)
     6.1994609975558 #(0 0 1 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 0)
     6.168496131897 #(0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1) 
     6.168496131897 #(0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 0 1 0 1)

     5.241325 #(0.000000 1.424549 1.434579 0.952506 0.877300 1.948583 1.592791 0.964559 0.950012 1.429458 0.788068 0.556113 0.404906 0.813692 1.604109 0.138120 0.925420 1.345282 1.048370 1.281239 1.347177 1.752489 1.781053 0.782127 0.063659 1.163981 0.330203 1.128951 1.871926)
     )

;;; 30 all -------------------------------------------------------------------------------- ; 5.4772
#(30 6.3668465614319 #(0 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 1) 
     6.3080444335938 #(0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 1 0 1)
     6.2868418693542 #(0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 1)
     6.257221698761 #(0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 1 0 1)

     5.362330 #(0.000000 1.367601 0.676897 1.055989 -0.504631 0.355844 0.103164 0.545914 0.753793 0.321958 -0.469115 -0.198271 0.504377 0.195433 -0.043539 1.646405 0.868434 1.019067 1.250208 0.154175 0.521612 -0.269412 0.224800 -0.453065 0.517176 0.213875 0.989118 0.339398 0.791198 0.750265)
     )

;;; 31 all -------------------------------------------------------------------------------- ; 5.56776
#(31 6.4472563825087 #(0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1) 
     6.3776631355286 #(0 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1)
     6.3353910446167 #(0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 0 1)
     6.3243918418884 #(0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1)

     5.479964 #(0.000000 1.716184 0.735456 1.283862 0.002347 1.137343 1.649762 0.840216 0.865317 0.361979 -0.012305 1.509338 0.901430 1.005925 1.660821 0.521083 0.544433 0.645935 1.649120 0.937869 0.005989 1.743531 0.418063 1.629392 0.675104 0.804207 1.141603 1.156207 0.677172 1.099658 1.175569)
     )

;;; 32 all -------------------------------------------------------------------------------- ; 5.65685
#(32 6.5261273384094 #(0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0)
     6.4710988998413 #(0 0 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 0 0)
     6.4692246308309 #(0 0 1 1 0 1 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0 1 0 1 1 0 0)
     6.4519599479542 #(0 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1)
     6.4451498985291 #(0 0 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 1 0)  

     5.525903 #(0.000000 -0.354298 1.295736 -0.242973 0.377539 0.343431 0.387143 0.123759 0.157029 1.354752 0.238238 0.278815 0.141973 1.317329 1.717686 1.193878 1.733619 1.635283 0.446743 0.658737 0.934459 0.325544 1.909458 1.329732 0.500020 1.393895 1.748910 0.388564 0.707106 0.075513 0.833275 -0.013804)
     )

;;; 33 all -------------------------------------------------------------------------------- ; 5.74456
#(33 6.678719997406 #(0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 0) 
     6.6342549324036 #(0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1)
     6.6147227287292 #(0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0)
     6.5579299926758 #(0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 0)

     5.631973 #(0.000000 0.098072 0.532854 0.846014 0.664079 0.830642 1.909055 0.034669 0.156155 0.326304 1.406913 -0.021726 0.930021 1.245474 0.369819 0.650843 -0.063677 1.850934 0.443245 0.245700 0.778820 0.460792 -0.163758 0.929340 0.593887 1.314478 1.696216 1.195643 0.257411 1.265317 1.685847 1.107963 0.566881)
     )

;;; 34 all -------------------------------------------------------------------------------- ; 5.8309518
#(34 6.7310481071472 #(0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0)
     6.7281470298767 #(0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 0)
     6.7141165733337 #(0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0)
     6.6820402145386 #(0 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 0)
     6.6788883209229 #(0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 0)
     6.6782836914062 #(0 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 0)

     5.716745 #(0.000000 1.537504 0.239008 0.278920 1.094080 0.274645 0.872514 1.496751 1.521774 0.761180 1.654894 0.025765 1.234380 0.204375 1.322037 0.722918 0.795256 1.811198 1.110677 1.456684 1.070774 0.658521 1.725859 1.407197 -0.521781 1.351171 1.541096 1.489412 0.629042 0.675615 0.879357 -0.127404 -0.019945 0.556507)
     )

;;; 35 all -------------------------------------------------------------------------------- ; 5.9160
#(35 6.8652677536011 #(0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 0 0 1 0 0 0 0 0)
     6.8216953277588 #(0 0 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     6.7839112281799 #(0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0)
     6.7759642601013 #(0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0)
     6.7637429237366 #(0 1 1 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0)

     5.764823 #(0.000000 0.102596 1.399104 0.819850 1.460051 0.153394 1.619399 1.534181 1.543719 0.875767 1.319541 1.295004 1.412963 0.147635 1.056962 0.647124 1.391447 1.069261 0.136848 0.362097 1.849103 1.487034 0.789806 1.755813 0.989693 1.204982 0.199212 -0.166559 0.164670 -0.019626 0.358830 0.682492 1.632953 0.563668 0.903472)
     )

;;; 36 all -------------------------------------------------------------------------------- ; 6
#(36 6.9388113021851 #(0 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 0 1 0 0 0 0)
     6.934184551239 #(0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 0)
     6.9237461090088 #(0 0 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 0 0)
     6.9208335876465 #(0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1)
     6.8763957023621 #(0 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0)
     6.8008880615234 #(0 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1)

     5.926043 #(0.000000 1.020111 0.677817 0.140140 0.932921 0.775557 0.190635 1.853238 0.762697 0.237889 0.277245 0.161572 1.553054 0.008070 0.283378 1.674361 -0.347149 0.590912 0.944213 0.823255 0.043034 -0.091562 0.229555 1.352871 0.981843 0.171776 0.581947 0.691871 1.000348 0.829120 1.162722 1.690975 0.634924 1.730234 0.452876 1.429867)
     )

;;; 37 all -------------------------------------------------------------------------------- ; 6.0827
#(37 7.1209874153137 #(0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0)
     7.1156206130981 #(0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0)
     7.1152505874634 #(0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0)
     7.1046371459961 #(0 1 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 0 0 0)
     7.0939922332764 #(0 0 1 1 1 0 1 0 0 0 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0)
     7.0588836669922 #(0 1 0 1 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0)
     7.0475845336914 #(0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 0 0)
     7.0251078605652 #(0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 0 0)

     5.929140 #(0.000000 1.358762 1.822305 0.294959 1.751486 1.846255 1.054705 1.356070 0.295356 0.389947 1.778796 1.535165 0.425814 0.315763 -0.095179 0.216827 1.001516 1.634643 1.367262 0.731729 0.392159 1.330413 0.106974 1.913724 0.326683 0.432158 1.543253 0.670911 0.022710 0.322190 1.802829 0.443297 1.635125 1.061016 1.342173 1.421636 1.826161)
     )

;;; 38 all -------------------------------------------------------------------------------- ; 6.1644
#(38 7.1993880271912 #(0 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0)
     7.1926069259644 #(0 0 1 0 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0 0)
     7.1880865097046 #(0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0)
     7.1807923316956 #(0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0)
     7.1668581962585 #(0 0 1 0 1 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 0 0)
     7.1260185241699 #(0 1 0 1 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0)
     7.1221342086792 #(0 0 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 0 0 0)
     7.0688242912292 #(0 0 1 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 0)

     6.106333 #(0.000000 0.434523 1.232452 1.590516 0.836713 0.138216 -0.095509 1.537371 0.469612 0.772082 0.748819 1.723571 1.820323 0.854103 0.903800 0.048646 1.316356 0.369282 0.213334 0.798970 0.966914 1.376827 0.274641 1.618764 1.873131 -0.092091 -0.470518 1.150403 0.773945 1.198395 0.586433 1.306012 0.434228 0.963298 1.320012 1.145313 0.975992 1.528312)
     )

;;; 39 all -------------------------------------------------------------------------------- ; 6.2449
#(39 7.3091864585876 #(0 0 0 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0)
     7.2959136962891 #(0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 0 0)
     7.2940211296082 #(0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0)
     7.2713379859924 #(0 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0)
     7.2698922157288 #(0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 1 0 0 0)
     7.2519464492798 #(0 1 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0)
     7.2313327789307 #(0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0)
     7.1506487936623 #(0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 0 1)

     6.124729 #(0.000000 0.038926 0.172489 1.637986 1.176771 0.764549 -0.121134 0.531361 0.567860 -0.106734 -0.132254 0.222656 0.602471 1.033661 1.719556 1.942107 1.261975 -0.013035 1.519484 1.205137 0.906330 1.593641 1.660554 1.493083 0.901251 0.173465 0.594063 1.532295 0.098886 1.416040 0.769029 -0.146846 1.282920 1.609082 1.558579 0.288395 1.495508 0.151384 0.427053)
     )

;;; 40 all -------------------------------------------------------------------------------- ; 6.3245
#(40 7.4570450782776 #(0 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 0)
     7.448447227478 #(0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0)
     7.4427533149719 #(0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0)
     7.4250183105469 #(0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0)
     7.4126052856445 #(0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0)
     7.4104852676392 #(0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1)
     7.4014959335327 #(0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0)
     7.3913831710815 #(0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 0 0 0 0)

     6.292789 #(0.000000 1.471085 1.341998 0.245329 0.992219 1.367415 1.647640 1.733712 -0.043309 0.435254 0.541478 1.274450 0.325315 0.080514 -0.001756 1.724631 -0.351139 -0.103348 0.019247 0.164052 -0.161430 1.234128 0.804419 0.871401 0.518003 1.471468 0.171804 1.059678 1.507035 1.814550 1.251692 0.570971 1.417833 1.686084 0.621920 -0.107258 1.537304 0.355662 1.248327 0.717323)
     )

;;; 41 all -------------------------------------------------------------------------------- ; 6.4031
#(41 7.5969347953796 #(0 1 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0)
     7.5873513221741 #(0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0)
     7.5666546821594 #(0 0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0)
     7.5657444000244 #(0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0 0)
     7.544189453125 #(0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     7.4959030151367 #(0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0)
     7.4493231773376 #(0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0)
     7.4106826782227 #(0 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1)

     6.329579 #(0.000000 1.137515 1.769089 -0.299653 1.220039 1.077001 0.500218 0.459078 1.422117 1.896955 0.403781 0.295960 -1.896063 1.894488 1.648509 1.178752 0.665836 1.680158 0.461116 0.544058 1.334024 0.393903 -0.086472 0.752128 0.466827 0.515522 0.823902 0.898198 1.180070 -0.019178 0.946896 1.657633 0.728207 0.147415 0.129492 0.217718 0.871677 0.077986 1.489914 0.199522 0.411148)
     )

;;; 42 all -------------------------------------------------------------------------------- ; 6.4807
#(42 7.8644123077393 #(0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)
     7.8588690757751 #(0 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1)
     7.8527493476868 #(0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)
     7.8154973983765 #(0 1 1 0 1 0 1 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0)
     7.7903428077698 #(0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 0)
     7.7545323371887 #(0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1)
     7.6252284049988 #(0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)

     6.458172 #(0.000000 1.779802 1.359615 1.879962 1.432134 1.455720 0.050482 0.106359 1.650230 0.287470 1.684530 1.015736 0.662318 0.194172 0.755077 0.912369 1.865518 -0.192152 1.124016 1.730667 0.303300 1.844053 1.380373 1.179291 0.508850 0.434037 0.920988 1.193680 1.562155 0.705424 1.520812 0.671035 1.715494 0.817370 0.696580 0.646980 1.055448 -0.067178 0.041818 0.485277 0.025331 0.817692)
     )

;;; 43 all -------------------------------------------------------------------------------- ; 6.5574
#(43 7.8286972045898 #(0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0)
     7.824122428894 #(0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1)
     7.8140468597412 #(0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 0)
     7.8020606040955 #(0 1 1 1 0 0 0 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 0 0 0 0 0)
     7.7842569351196 #(0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1)
     7.7697319984436 #(0 0 1 0 1 0 1 1 0 1 0 1 0 0 0 1 1 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 1 1)
     7.7580170631409 #(0 0 0 0 1 1 1 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0)
     7.7244353294373 #(0 1 0 1 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1)
     7.6866073608398 #(0 1 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 0 0 0 0 0 0)
     7.6619415283203 #(0 1 0 1 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1)

     6.475528 #(0.000000 1.147280 1.691590 1.154893 0.714369 0.646602 1.063814 0.342787 0.213850 1.376847 0.672156 0.426784 0.173677 0.109251 0.014689 0.460742 1.795718 1.444694 0.313363 0.013263 0.820252 0.120195 0.582555 0.101192 0.622170 0.361066 1.291530 0.938584 1.771184 0.174409 1.101959 1.336204 1.397978 0.480940 1.800173 0.225504 0.935339 0.257627 0.673243 1.297971 1.467951 -0.222412 0.775605)
     )

;;; 44 all -------------------------------------------------------------------------------- ; 6.6332
#(44 8.0920171737671 #(0 0 0 0 1 0 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 0 1 1 0 1 0 0)
     7.9767818450928 #(0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1)

     6.545396 #(0.000000 0.517441 0.224743 0.527338 -0.270486 1.917846 -0.032391 -0.157592 0.071402 1.707870 1.778459 0.462403 0.275550 0.508406 1.164528 0.357130 -1.719783 0.465936 0.147582 1.209069 1.406641 0.741996 1.669336 1.403573 0.071721 0.264270 0.575085 0.758504 -0.025701 1.580932 0.914628 1.312214 0.227291 0.685476 1.567974 0.432459 -0.041278 1.284183 0.873890 0.466325 1.016813 0.066367 1.375808 0.157368)
     )

;;; 45 all -------------------------------------------------------------------------------- ; 6.7082
#(45 8.197151904921 #(0 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1)
     8.1777801513672 #(0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 1)

     6.631211 #(0.000000 0.966048 -0.045746 -0.238847 1.273744 0.170242 0.544640 0.770614 1.444046 -0.090722 1.217334 -0.019045 1.741945 0.948903 1.807290 0.254737 0.312327 0.363027 1.305146 0.644578 1.390424 0.026485 -0.051425 0.742565 0.033282 -0.417147 0.148909 1.021670 1.312396 0.296771 -0.049488 -0.148057 1.153450 1.675465 1.169715 1.136662 1.153609 -0.074065 1.377121 1.007032 0.502999 -0.238787 0.106138 1.570584 0.085416)
     )

;;; 46 all -------------------------------------------------------------------------------- ; 6.7823
#(46 8.4391345977783 #(0 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0)
     8.22203540802 #(0 1 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0)

     6.692130 #(0.000000 1.447890 1.082568 1.923283 0.599189 0.110681 0.060935 0.201444 1.125993 0.800050 0.134316 1.543466 0.423352 0.989326 1.043659 0.904075 0.393568 1.877084 1.780328 0.102937 0.812134 1.461412 1.299690 0.506970 0.691813 0.082240 0.740600 1.297273 0.919709 1.951069 1.522648 1.192041 1.863532 1.500219 -0.017560 0.925713 1.376685 1.111460 1.347977 1.465737 0.887440 1.243085 -0.114458 0.647201 0.156148 0.997344)
     )

;;; 47 all -------------------------------------------------------------------------------- ; 6.8556
#(47 8.4154777526855 #(0 1 1 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 0)
     8.3755550384521 #(0 0 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0)
     8.3640232086182 #(0 0 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 0)
     8.3221893310547 #(0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 0)

     6.829280 #(0.000000 1.710683 0.882189 0.232309 0.653317 -0.003608 0.225375 -0.027295 1.209953 0.356846 0.456579 0.227378 0.945275 1.342637 -0.056534 0.653228 0.967879 1.470070 0.747826 1.214603 0.625507 1.482699 1.914049 -0.197177 1.482172 0.775288 1.112777 1.266256 1.799944 0.658034 0.099589 1.297160 1.005264 1.034860 1.147816 0.302009 1.478177 1.080930 0.363730 1.769208 0.262493 0.338246 0.326450 1.167161 1.778909 1.087506 1.331188)
     )

;;; 48 all -------------------------------------------------------------------------------- ; 6.9282
#(48 8.6921081542969 #(0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1)
     8.5232070520636 #(0 0 1 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 1)
     8.4671268463135 #(0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1)

     6.862991 #(0.000000 0.599723 1.243012 1.032677 1.050352 0.598029 1.660005 1.332443 0.655971 1.788676 1.337409 0.009469 0.382194 1.917475 0.167554 0.198650 1.572203 1.516368 0.642380 0.517698 0.942841 -0.405370 1.600258 0.836886 0.797813 0.742501 0.173335 0.974435 0.364609 0.471654 1.258646 0.661559 1.164408 0.894678 1.704989 0.727287 0.456810 0.350063 0.208838 0.807943 1.129989 1.478527 0.316193 1.581070 0.356599 0.761341 1.603102 0.628284)
     )

;;; 49 all -------------------------------------------------------------------------------- ; 7
#(49 8.7310771942139 #(0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 1 0 0 1 0 1 0 1 0 1 0)
     8.6587047576904 #(0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 0 0 1 0 1 0 0)
     8.7183141708374 #(0 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1)
     8.5157623291016 #(0 1 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0)

     6.914368 #(0.000000 1.428029 -0.117441 -0.216462 1.069482 1.017942 0.649317 1.622364 0.540688 0.420878 1.871094 1.163270 0.983991 1.722029 0.368443 0.059607 0.531858 1.516682 1.461580 0.723747 0.962175 1.540443 1.566329 1.434125 0.934269 1.182962 1.506462 -0.165504 1.667569 0.675845 0.243267 0.674701 0.268385 1.085267 0.367229 -0.139029 -0.050886 1.095963 1.977791 0.481943 1.203408 0.172699 0.857834 0.509700 1.644207 0.139829 0.242216 1.855958 0.304321)
     )

;;; 50 all -------------------------------------------------------------------------------- ; 7.071
#(50 8.8124130871436 #(0 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1)
     8.8096923828125 #(0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1)
     8.7809114456177 #(0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 1)

     7.005413 #(0.000000 1.517876 0.573482 1.180666 -0.071952 1.653904 0.384916 1.941926 1.192969 0.894193 0.880869 1.205899 -0.288178 0.828155 0.567425 1.512413 -0.440448 -0.089772 1.002471 1.020876 1.187021 0.469606 0.728938 0.145636 0.627935 0.678233 0.647832 0.283338 1.287529 1.504536 0.871696 -0.095817 0.470954 1.182985 -0.604307 0.913363 1.209152 0.441722 1.279997 0.878832 -0.173660 1.482710 1.116047 1.666798 0.162901 0.521703 0.174069 -0.335781 0.803954 1.499634)
     )

;;; 51 all -------------------------------------------------------------------------------- ; 7.141
#(51 8.8691492080688 #(0 1 1 1 1 0 1 0 1 0 1 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1)
     8.8213935921978 #(0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1)

     7.063719 #(0.000000 1.276984 1.272463 1.603498 -0.114668 1.092865 -0.115492 0.583224 0.517741 0.110652 1.395863 0.470307 0.526421 1.781251 1.011215 1.307651 0.597875 1.172906 0.653106 0.685559 0.654556 0.575395 1.696783 1.668473 1.661504 -0.233184 0.199360 0.717409 -0.176428 0.108145 -0.041395 0.924608 1.331272 1.398814 1.535592 0.345734 -0.106480 1.449999 1.223882 0.352153 1.460735 0.191915 1.884262 0.819786 0.140686 0.967515 0.015691 -0.015407 1.274417 1.510922 0.228257)
     )

;;; 52 all -------------------------------------------------------------------------------- ; 7.211
#(52 9.1133499145508 #(0 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 0 1)
     9.109245300293 #(0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0)
     8.9920463562012 #(0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0)

     7.136822 #(0.000000 0.617659 1.463939 1.479821 0.141073 1.349902 0.581755 0.542527 1.785450 0.392076 1.747014 0.530215 1.415499 1.250300 1.330275 1.004670 0.932813 1.579912 0.520763 0.309957 0.476780 1.121847 -0.056276 0.241138 0.396679 1.244250 1.887242 1.120099 1.700674 -0.145541 0.212227 1.133940 0.533307 1.226244 0.251411 -0.119506 1.263800 0.851644 0.880141 0.689710 0.675947 1.109636 1.382877 1.042320 1.337328 0.413624 1.596207 0.875731 0.546507 1.408353 1.246481 0.818153)
     )

;;; 53 all -------------------------------------------------------------------------------- ; 7.280
#(53 9.171422958374 #(0 0 1 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 1 1 1 0)
     9.0914754867554 #(0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0)

     7.199748 #(0.000000 0.611149 0.848127 1.598828 1.160551 1.714147 0.523990 -0.053642 0.293805 0.319633 0.990898 1.371867 1.087555 1.751235 1.596571 0.164330 0.928029 -0.367660 0.848367 1.637231 0.732549 1.007151 0.882588 0.292794 0.175971 0.884132 1.771468 0.907137 -0.022251 0.081049 0.260312 1.591164 0.329249 1.892354 1.403891 1.105721 0.717598 0.359182 1.354386 1.830472 0.573023 1.403480 1.846806 1.637659 1.667166 -0.124551 1.652787 0.847486 0.187524 1.797748 0.328847 0.102292 1.703619)
     )

;;; 54 all -------------------------------------------------------------------------------- ; 7.348
#(54 9.2755253455568 #(0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 1 1 1 1)
     9.1825122833252 #(0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1)

     7.256421 #(0.000000 1.659491 -0.128590 1.383433 -0.143790 1.239473 0.073717 0.451269 1.198251 -0.230958 0.110202 0.005901 0.129651 1.043720 -0.221353 0.679566 1.437942 0.447035 0.556798 1.087188 1.044918 0.269972 0.431665 0.187800 1.459099 -0.061373 1.603679 1.075622 1.037255 -0.059052 1.626549 1.136382 0.013366 1.423443 0.765039 0.527266 1.175310 0.676300 1.457898 0.404321 0.548996 0.832559 1.201809 0.765715 1.010344 1.774654 1.633500 0.873697 0.209327 0.455367 0.081887 1.238965 0.538185 0.780999)
     )

;;; 55 all -------------------------------------------------------------------------------- ; 7.416
#(55 9.2178440093994 #(0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0)
     9.0889595835043 #(0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1)

     7.329858 #(0.000000 0.946434 0.377686 1.733345 1.135187 1.114396 -0.197016 1.057816 0.982418 1.741140 0.451849 0.852574 1.634409 0.968871 1.084351 0.999787 1.403836 1.477113 -0.290407 1.532523 1.687527 0.973109 0.920259 1.408941 0.402778 0.417430 1.362622 0.021948 1.437019 0.094132 0.950917 1.024298 1.292845 0.836906 1.423446 0.667431 1.669673 0.345008 0.452347 -0.159222 1.065805 0.335944 0.247739 -0.005233 1.631961 0.774083 0.405371 1.393385 1.823321 -0.222483 -0.235468 0.863412 1.173072 0.609807 1.503686)
     )

;;; 56 all -------------------------------------------------------------------------------- ; 7.483
#(56 9.4667987823486 #(0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0)
     9.3902807235718 #(0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1)
     9.1394176483154 #(0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0)

     7.351523 #(0.000000 1.543556 1.524236 -0.220549 1.568063 0.074432 1.227046 1.349591 0.293098 1.633876 -0.248890 0.062551 -0.027330 1.597130 1.558104 0.547203 0.520775 1.130352 0.106397 0.044566 1.190110 0.102257 1.309263 1.048077 1.846929 1.740264 0.734083 0.626802 0.965213 1.420356 1.259179 1.584601 1.816946 1.272841 -0.020179 0.638771 1.569366 1.137728 0.544530 0.685344 0.940702 0.308371 0.683990 0.230169 0.727122 -0.246726 1.524724 0.598122 1.232409 0.018040 1.782207 1.871993 1.028053 0.552892 1.150325 -1.908492)
     )

;;; 57 all -------------------------------------------------------------------------------- ; 7.5498
#(57 9.650218963623 #(0 0 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0)
     9.616 #(0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 1)
     9.370246887207 #(0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0)

     7.495949 #(0.000000 0.538215 0.976825 0.789775 1.576932 0.440085 0.416087 0.318459 1.820908 1.015308 1.074929 0.993069 0.172590 0.635655 1.505397 1.453104 1.810053 -0.068124 1.596676 1.498097 -0.088688 0.258595 -0.125022 1.278731 0.623990 0.596706 1.578148 1.107354 1.064560 1.463508 1.755446 0.763555 0.952929 1.385753 0.762349 0.424530 1.585923 0.431172 1.481725 1.441840 1.019948 1.821332 1.352509 0.233747 1.134963 0.583121 1.104293 1.440535 0.278664 1.394550 0.171575 0.823627 0.110842 1.675955 1.176224 1.460982 1.331940)
     )

;;; 58 all -------------------------------------------------------------------------------- ; 7.6157
#(58 9.623 #(0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1)
     9.6140956878662 #(0 0 1 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1)
     9.4419231414795 #(0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1)

     7.595071 #(0.000000 0.990083 1.507308 0.860143 0.383344 0.505985 -0.052664 0.090547 1.244322 1.160125 0.168579 1.094679 1.755952 -0.124751 0.550548 1.553960 0.687171 1.587397 1.475552 1.050760 1.278330 0.780777 1.365646 0.611590 0.181726 0.638599 1.027492 -0.188669 0.295755 -0.050729 0.357330 -0.169211 1.823284 0.904236 1.169528 -0.304166 0.025837 0.169344 -0.048903 1.993783 0.047429 0.418349 -0.026980 0.784857 0.433612 0.203615 1.495119 0.774803 1.361606 0.698832 -0.159411 1.856621 0.815303 0.353444 1.669083 1.298815 1.604336 0.190696)
     )

;;; 59 all -------------------------------------------------------------------------------- ; 7.6811
#(59 9.9013983722749 #(0 0 0 1 1 0 0 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 1)
     9.4819116592407 #(0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0)

     7.644775 #(0.000000 -0.112174 0.411016 1.384098 1.500080 0.118953 0.998973 0.521534 1.600099 0.200375 1.134179 -0.296628 -0.209355 1.397606 0.212639 1.293052 -0.064538 0.653420 0.185409 0.285558 -0.034708 0.591387 0.973343 1.264562 0.482782 0.704932 0.782721 0.328988 1.410460 1.099035 0.452365 0.164411 0.677635 1.250849 0.461115 1.471487 0.982072 0.594269 0.828341 0.490759 -1.732909 1.698311 0.149146 0.415172 0.348675 1.857262 1.094663 1.412964 0.338198 1.527937 1.697032 0.087807 0.661715 0.678150 0.565974 1.017768 1.939890 1.299854 0.507027)
     )

;;; 60 all -------------------------------------------------------------------------------- ; 7.7459
#(60 9.783 #(0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)
     9.575254043103 #(0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)

     7.600424 #(0.000000 0.319585 0.262038 0.915274 0.689012 -0.660447 0.044528 1.968570 1.154307 0.421991 0.866636 1.411325 0.141900 -0.313222 1.398790 1.053081 0.771648 0.062243 1.506882 0.101650 1.336250 1.485950 1.611542 0.832074 -0.220688 0.987525 0.776721 0.090849 1.688307 1.227204 0.671286 0.885473 0.145234 0.266825 0.627126 0.168167 0.158810 0.190079 -0.180076 0.553988 0.408191 1.285941 0.868461 0.791889 0.942798 1.157145 -0.195408 0.036368 0.559169 -0.233323 0.127923 0.726313 0.294140 1.019494 1.776119 0.680031 0.109867 0.820900 0.094798 0.379645)
     )

;;; 61 all -------------------------------------------------------------------------------- ; 7.8102
#(61 10.140303840769 #(0 1 0 0 0 0 0 0 0 0 1 0 1 1 1 0 1 0 0 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 0 0 1 0 0 0 1)
     9.9175914844707 #(0 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1)

     7.764539 #(0.000000 0.501749 1.326260 -0.002830 0.440140 1.954758 -0.008202 0.999918 0.013473 0.542424 0.025115 0.566063 0.591900 -0.196853 0.709527 1.494974 0.701049 1.000710 1.261876 0.543883 0.605458 1.371875 -0.020772 0.931648 0.804346 0.926420 0.633175 0.027958 1.257581 0.427959 1.076239 -0.091270 1.537981 0.146252 0.640848 0.257921 1.798714 0.191485 0.663913 1.946117 1.528077 1.065296 -0.320137 1.459211 1.030583 1.751744 1.068882 0.287431 0.162869 0.095930 0.749409 1.433537 1.416981 -0.082974 0.219907 0.200900 1.575224 1.106230 0.733650 1.327996 1.447241)
     )

;;; 62 all -------------------------------------------------------------------------------- ; 7.8740
#(62 10.281167984009 #(0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0)
     9.9292116165161 #(0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0)

     7.798803 #(0.000000 0.805547 1.782707 0.189679 1.676614 1.436575 1.812241 1.058226 0.097387 0.692526 0.057179 1.439321 1.428151 0.064412 1.727032 0.152892 0.953669 0.004533 0.908740 1.219778 0.678578 0.674815 0.109839 1.588562 0.226793 1.128914 0.420289 0.239789 0.739134 0.624055 0.344055 1.542003 1.524238 1.657603 0.230208 1.495417 1.129148 0.764835 1.158835 1.491879 -0.003697 1.022064 1.286088 1.156897 0.394798 1.617052 1.464985 1.778002 1.875215 0.687517 1.682872 1.502873 0.697317 0.696024 0.940976 1.167656 0.119243 1.202268 0.795357 0.695557 1.268019 1.490379)
     )

;;; 63 all -------------------------------------------------------------------------------- ; 7.9372
#(63 10.265982627869 #(0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0)
     9.9866892843745 #(0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0)
     9.9555234909058 #(0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 1 0)

     7.905693 #(0.000000 0.118910 0.105094 0.622413 1.543591 0.211795 -0.212265 1.275618 0.119584 0.224478 1.510442 0.118241 1.908141 1.161125 1.900961 0.315152 1.296653 0.861239 1.497197 1.233683 0.161755 1.733143 0.954659 1.019180 1.156638 1.056572 1.327722 1.142310 0.382008 1.018641 0.200083 1.812978 1.495933 1.369808 -0.021063 1.329348 1.652261 1.266123 1.342845 0.422458 0.901606 1.810496 1.456490 0.288481 1.564221 0.472524 0.850586 0.489011 -0.003573 1.573817 1.205532 1.046687 0.196677 1.000489 1.508760 -0.098415 -0.151485 -0.000746 1.076043 1.806358 0.285497 0.668507 0.697196)
     )

;;; 64 all -------------------------------------------------------------------------------- ; 8
#(64 10.1628899603246 #(0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 0 1)
     9.957244923706 #(0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1)

     7.967489 #(0.000000 0.062475 0.215041 1.945489 0.375775 1.203268 1.446182 0.581947 0.619024 1.221341 1.325742 -0.257083 1.856274 1.626471 0.296988 -0.187632 1.803453 1.315170 1.873378 0.734975 0.879587 1.565354 0.432830 0.562499 1.091665 1.478203 -1.705221 1.261490 0.493144 1.198557 1.268115 0.230172 -0.063233 1.606426 1.872320 1.700281 1.176048 1.034214 0.340481 -0.098173 -0.258889 1.100168 0.269702 0.635473 0.454154 1.342465 0.648140 1.415622 0.067684 0.189207 1.066248 0.412055 1.219590 0.537252 1.497045 1.037489 0.818293 0.386908 1.054593 0.490726 0.755389 1.743936 0.863846 0.945240)
     )

;;; 65 all -------------------------------------------------------------------------------- ; 8.0622
#(65 10.598279953003 #(0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0)
     10.18968963623 #(0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0)
     10.157649040222 #(0 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0)

     8.037236 #(0.000000 -0.447272 1.150457 1.277212 1.473633 1.869212 1.646838 -0.199509 0.997838 1.839863 1.029918 1.627832 0.686926 0.950638 1.436480 1.474337 1.716508 0.116286 0.685158 1.799228 -0.032754 1.121864 0.857588 1.162840 1.737814 0.857125 1.491384 0.172605 0.891950 0.624544 1.380291 0.165482 1.748565 0.453292 1.138664 0.477024 0.451404 1.465231 1.689596 0.504151 -0.182695 0.475263 0.300570 1.442536 1.880347 0.242497 0.702494 0.155411 0.931110 0.163673 1.483691 1.085605 1.179794 1.307127 1.188788 0.970948 0.910420 0.127258 0.020035 1.436619 1.076430 0.075897 1.362988 0.537720 0.279138)
     )

;;; 66 all -------------------------------------------------------------------------------- ; 8.1240
#(66 10.450973400896 #(0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0)
     10.26798183746 #(0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1)
     10.208241079264 #(0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0)

     8.064146 #(0.000000 1.153676 1.932196 0.463774 1.728709 1.710057 1.716289 0.944632 0.645495 -0.292421 0.723244 0.880547 0.716047 1.250932 0.308223 0.381567 1.057781 0.366029 1.885263 0.164467 0.986021 1.585560 -0.305362 0.613124 -0.010716 1.395742 1.416666 1.264870 0.135882 0.443609 0.121508 1.715673 1.079494 1.076356 0.783126 0.939371 1.271021 0.301817 0.286223 1.507113 0.286342 1.239549 1.590232 1.516887 0.304542 0.461663 1.002674 0.271393 1.087310 0.151697 1.646731 0.711098 0.603784 1.974621 0.943278 0.108690 0.948993 0.032116 0.540157 0.739208 0.141107 0.107399 0.569978 0.286069 0.661557 0.740021)
     )

;;; 67 all -------------------------------------------------------------------------------- ; 8.1853
#(67 10.780866622925 #(0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 1)
     10.514228551195 #(0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1)
     10.445269388021 #(0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1)
     10.422191619873 #(0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 1)

     8.149225 #(0.000000 0.839205 1.682338 1.197752 0.077613 0.940913 1.806879 1.065262 0.260296 1.470081 0.146507 0.010273 0.115262 0.789317 0.861756 0.360833 1.092254 0.938621 1.356376 1.675527 0.793819 -0.166583 1.664496 1.819723 -0.094527 1.800150 0.406266 1.462391 0.991552 -0.011270 0.624184 -0.049233 -0.108630 0.045247 -0.056327 1.059227 0.476822 -0.473770 1.303839 0.099139 0.870106 1.581517 1.540458 1.749708 0.867248 1.189258 0.989760 1.038532 -0.130518 1.439250 0.760909 0.623194 0.625171 1.154265 1.533775 0.322221 1.701464 -0.121936 0.937660 1.706979 0.104939 1.244474 1.527200 1.062729 0.668691 0.057313 1.792741)
     )

;;; 68 all -------------------------------------------------------------------------------- ; 8.2462
#(68 10.585594177246 #(0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1)
     10.460547747753 #(0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1)

     8.175862 #(0.000000 0.351691 1.873276 1.061554 0.765573 0.947202 0.715881 0.728228 0.373531 0.201460 0.470147 0.084967 1.511467 0.927455 0.817667 0.937672 0.791824 1.071594 1.207692 1.051384 0.730301 1.727680 0.059327 1.737334 1.415055 0.226224 0.094419 -0.007369 0.541684 0.692171 1.310551 0.132661 1.526984 1.541460 0.063451 0.206062 1.780588 0.996541 1.298142 1.408969 0.106617 1.262967 0.724706 0.018937 1.431817 1.101371 0.749474 1.481155 0.392223 1.286804 0.559586 1.445518 1.216525 0.175758 0.466670 1.149604 -0.020780 1.460358 0.199630 1.132822 -0.138319 0.685241 1.459168 -0.237365 0.547088 0.684581 0.984835 1.512195)
     )

;;; 69 all -------------------------------------------------------------------------------- ; 8.3066
#(69 10.631803698099 #(0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0)
     10.544771744298 #(0 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0)
     10.495518383865 #(0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0)

     8.220347 #(0.000000 0.537085 0.165120 -0.178782 0.603757 1.667616 0.841707 -0.122036 1.597046 0.769985 -0.250165 1.456847 0.730303 0.530195 1.419615 0.563468 0.090718 0.716746 0.356272 -0.108026 1.352219 1.475080 0.461364 -0.067366 0.633499 0.170935 1.610486 0.069026 1.000273 1.245335 1.705379 1.082481 0.314603 0.570747 0.235957 -0.082400 1.698063 1.065891 0.303363 0.503955 1.303125 1.151344 1.698514 0.010152 0.387000 0.511078 0.358844 0.262773 1.496346 0.072757 -0.760151 1.631335 0.287604 0.133337 1.381232 1.577217 0.342685 0.443510 1.434756 0.374431 1.065913 0.127565 0.960872 0.795010 0.987225 1.135186 1.219501 1.053209 1.251134)
     )

;;; 70 all -------------------------------------------------------------------------------- ; 8.3666
#(70 10.957886695862 #(0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0)
     10.651799201965 #(0 0 0 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0)
     10.635682482778 #(0 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0)
     10.532930374146 #(0 1 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0)

     8.185843 #(0.000000 0.589888 1.425946 0.221477 0.968281 1.246018 0.792005 1.191784 1.327552 0.153387 0.791899 1.800772 0.410057 0.843272 1.093752 1.586183 0.864541 1.947387 1.026805 -0.097448 0.437298 1.082123 1.881994 1.027922 0.090172 0.157651 0.512351 0.038787 0.220530 -0.078260 0.187748 1.515155 -0.015586 1.577333 0.499846 1.764178 1.210820 0.057258 1.935344 0.083926 1.227812 0.190261 0.588934 0.845257 0.768665 -0.215873 0.469707 0.413831 0.148089 1.441723 1.016142 0.077689 -0.144310 0.679104 1.278630 0.998476 -0.082293 1.723591 1.379587 0.565871 0.213228 -0.023165 0.112809 -0.077933 0.958327 1.026650 0.854633 0.661544 -0.013503 1.294149)
     )

;;; 71 all -------------------------------------------------------------------------------- ; 8.4261
#(71 10.922951698303 #(0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 0)
     10.610488331633 #(0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0)

     8.329396 #(0.000000 0.140759 -0.159348 1.385740 0.212726 0.202866 1.043796 1.429961 0.014527 1.538652 0.356111 1.060291 -0.209054 0.647057 0.414923 0.991966 1.125811 0.877931 0.869501 0.442574 0.771663 0.442345 0.498365 1.102772 0.463533 1.199862 1.158733 0.971549 1.301599 0.773406 -0.488934 0.567516 0.813120 0.529610 0.258919 1.659001 -0.162234 0.664704 1.056178 -0.128989 1.022692 0.113824 0.671851 0.460281 1.766249 1.324372 0.777261 0.101914 0.766092 1.171768 1.487936 1.776802 -0.146866 1.536356 -0.045962 0.365826 1.056334 1.119930 0.564321 0.251631 1.475216 0.270529 0.889436 1.154283 1.034812 0.256449 1.615761 0.309723 1.401099 0.561381 0.165515)
     )

;;; 72 all -------------------------------------------------------------------------------- ; 8.4853
#(72 11.061260849739 #(0 1 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1)
     10.908146369485 #(0 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0)
     10.800657366855 #(0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0)

     8.472893 #(0.000000 -0.093428 0.860520 0.651650 0.036400 1.174208 -0.214755 0.653075 0.661176 1.355137 1.759893 1.116459 1.283776 0.222435 0.388195 1.541066 0.171819 0.911538 0.292609 1.508023 0.997352 1.385529 0.022962 0.061408 -0.061153 0.241196 0.345845 0.923448 0.626801 0.283115 0.129077 0.499608 0.703807 0.614285 0.908458 0.403245 1.817077 1.458947 0.221667 1.213107 1.163972 1.117128 0.465749 0.627880 0.010093 0.512887 0.278332 0.535697 1.736410 -0.297420 0.467311 1.419905 1.531806 0.300181 0.244309 1.719696 1.200428 1.778805 1.081039 0.613164 1.654092 1.161237 1.675808 0.051072 0.709895 1.432879 0.690303 1.567340 0.453011 1.156931 0.253055 -0.113821)
     )

;;; 73 all -------------------------------------------------------------------------------- ; 8.5440
#(73 10.9493838342178 #(0 0 0 1 0 0 1 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0)
     10.889594078064 #(0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0)
     10.876985549927 #(0 0 1 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0)
     10.773231506348 #(0 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1)

     8.435528 #(0.000000 -1.845432 0.237856 1.465783 0.629378 1.095362 0.713424 0.012907 1.169537 0.065412 1.016861 -0.329860 1.126058 0.966763 1.108450 -0.062516 1.197659 -1.806924 0.091875 0.974554 1.580554 1.035812 -0.066747 1.876994 0.423439 1.574950 0.943946 0.996539 1.254018 1.730249 0.520922 0.343655 -0.022295 1.604728 0.419127 0.362917 0.327386 1.057065 0.529949 0.587239 1.282875 0.066107 0.246329 0.034678 -0.021119 -0.245004 -0.103002 1.631803 0.461237 1.532240 0.133510 0.081467 0.451745 1.061459 1.899745 0.508638 1.228384 0.665467 0.378417 1.659499 1.360208 0.405781 0.570698 0.877687 1.829846 -0.331254 1.110144 0.322656 1.297236 0.006636 0.120844 1.612924 0.586211)
     )

;;; 74 all -------------------------------------------------------------------------------- ; 8.6023
#(74 11.023842939777 #(0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0)
     10.97177028656 #(0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0)
     10.70422077179 #(0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 0)
     10.684138298035 #(0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1)

     8.509324 #(0.000000 1.307420 0.178177 1.525703 0.938038 -0.025276 1.085926 0.614936 0.050805 0.860535 0.092722 0.739079 1.853954 0.005674 1.316611 0.117314 1.182772 1.498306 0.318979 0.591092 1.531467 -0.087422 -0.133360 1.005491 1.096551 -0.190871 1.049145 0.964190 0.086253 1.641112 0.508495 -0.557851 1.723489 1.627005 0.042156 -0.072601 1.390074 -0.010443 1.250928 0.217272 -0.004873 1.634439 1.609311 1.030857 0.811034 1.285888 1.519203 -0.524810 0.345771 1.051998 1.364513 0.634815 -0.114698 0.040311 0.288428 0.636174 0.015603 0.292911 1.104756 1.063454 0.969617 0.983822 -0.058764 0.391465 -0.024242 0.785923 0.236722 0.846540 1.405607 1.101248 -0.033546 -0.292860 1.408733 1.196783)
     )

;;; 75 all -------------------------------------------------------------------------------- ; 8.6603
#(75 11.477107048035 #(0 1 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 0)
     10.935811368418 #(0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1)

     8.616591 #(0.000000 1.763745 1.252829 1.380564 0.143928 0.884598 1.327289 0.150108 0.153577 1.315541 0.888389 1.246498 1.573246 0.307345 0.433867 1.534352 1.739951 0.961894 1.871289 1.037730 1.278069 1.361704 1.314067 1.227862 1.382876 1.652561 0.772899 0.600207 0.257515 1.027731 1.195829 0.578510 0.070107 1.191912 1.340051 0.302808 0.815466 1.849575 0.732278 0.581782 0.792292 1.073266 1.406130 0.035937 1.241835 0.204701 1.338853 1.557862 1.579802 1.693493 1.740838 0.075683 1.110124 0.215728 1.130837 0.441376 -0.149500 1.355631 0.030090 1.301436 0.831205 0.423247 0.205123 1.308296 1.829157 0.044169 0.067098 0.211035 1.546669 0.841536 1.073773 0.246181 0.771134 0.375515 1.449159)
     )

;;; 76 all -------------------------------------------------------------------------------- ; 8.7178
#(76 11.329963225913 #(0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 0)
     11.208243370056 #(0 1 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0)
     10.689208030701 #(0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0)

     8.629190 #(0.000000 0.388371 -0.170079 1.421507 1.244496 0.170595 0.714619 1.792054 0.677639 1.519150 0.963820 -0.181215 1.261508 1.597549 0.382293 0.446123 1.533428 0.666935 1.195371 0.798589 1.744253 0.574034 1.405768 1.802839 1.255294 0.623670 0.886369 0.856787 0.711909 1.461185 -0.182353 0.640814 1.414651 -0.056729 0.856766 0.615799 0.850551 0.303936 0.320090 0.359076 0.814140 -0.216567 0.556729 0.172413 1.148400 0.880751 1.332133 0.010874 0.367310 -0.033887 1.718657 1.027306 0.360423 -0.096528 0.192211 0.262633 1.073953 0.777882 1.177313 1.081766 0.655488 1.137912 0.192724 0.750070 0.736676 0.252618 1.092469 0.795640 -0.196601 1.664491 0.914790 0.666756 1.503838 1.581382 1.584539 1.085085)
     )

;;; 77 all -------------------------------------------------------------------------------- ; 8.7750
#(77 11.25105381012 #(0 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0)
     11.114716461811 #(0 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0)

     8.701799 #(0.000000 0.344104 0.501607 0.595773 1.398309 1.795458 0.102914 0.260787 0.938052 0.391467 0.659277 0.285210 1.143975 0.209624 0.207597 0.815684 1.399298 1.685390 0.520838 0.161602 -0.261972 0.364744 0.093027 -0.142264 0.770793 0.072494 -0.058749 0.789718 0.718808 1.679573 0.736440 1.234768 -0.109958 1.583960 0.657972 -0.032639 -0.146458 1.610600 1.467814 0.702345 -0.053393 1.227566 0.878514 0.475188 0.493825 0.319799 1.619833 0.589866 0.569301 0.911625 0.704628 1.139831 0.709113 -0.076328 0.364876 0.181670 0.722372 1.470718 0.759843 0.753621 1.495477 1.653081 1.482127 1.747880 0.981290 1.371166 0.544996 -0.602787 1.840080 0.847424 1.037384 0.313591 0.517132 0.004130 1.330223 -0.113615 1.303353)
     )

;;; 78 all -------------------------------------------------------------------------------- ; 8.8318
#(78 11.559678967298 #(0 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1)
     11.541502084124 #(0 1 1 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1)
     11.471938943963 #(0 1 1 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1)

     8.730994 #(0.000000 1.239292 1.237536 0.078393 0.092150 1.616328 0.343024 1.852418 1.549456 0.025380 1.407023 1.785320 1.255026 0.692833 0.315456 1.055325 0.782512 1.714363 0.550297 0.558207 0.787940 1.844126 0.774086 1.429597 0.898175 0.580098 1.609655 0.278925 1.207699 1.490688 0.746381 1.733989 1.568229 1.438859 1.461306 0.640517 1.124970 1.570701 1.454568 0.684220 0.614586 1.390206 -0.086070 0.660844 0.477308 1.289847 1.793211 0.995020 1.631753 0.403757 0.790059 1.298067 0.984650 1.875588 0.990647 0.174896 0.342683 0.032603 -0.175050 1.451943 -0.071181 1.634007 0.479541 0.257775 0.031281 -0.139584 0.166047 1.014878 0.850301 0.981045 1.405417 1.591016 0.154921 -0.217363 1.811670 0.241249 1.847176 1.012804)
     )

;;; 79 all -------------------------------------------------------------------------------- ; 8.8882
#(79 11.431832400958 #(0 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0)
     11.407577489438 #(0 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0)
     11.334476470947 #(0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 1 0)

     8.853202 #(0.000000 1.235072 1.172904 1.293243 0.811581 0.615095 1.389165 1.894712 0.138257 0.771251 0.091492 -0.063408 0.075019 0.963001 0.726027 1.919213 0.395926 -0.055159 1.175966 0.805584 0.413567 0.105962 0.950789 0.546610 0.934625 0.140446 1.179117 0.672954 0.042621 0.399831 0.188354 0.522957 0.653069 0.644750 0.569987 1.380840 1.082562 0.414568 1.765813 1.389180 1.483062 0.058247 1.809293 0.631392 0.026610 1.603956 1.825725 1.358863 1.340819 0.478717 1.679075 0.470125 0.535251 1.182297 1.606438 1.232330 0.082457 0.425227 1.035074 0.833101 0.688961 1.224036 0.076026 0.129968 1.457891 1.607591 1.617537 0.849583 1.859449 0.447098 1.246029 0.120765 1.539693 0.225059 0.916751 -0.010238 0.646225 1.405148 1.648434)
     )

;;; 80 all -------------------------------------------------------------------------------- ; 8.9443
#(80 11.828915596008 #(0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1)
     11.745326966911 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0)
     11.438133302082 #(0 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0)
     11.30185508728 #(0 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0)

     8.839863 #(0.000000 0.717836 0.750938 0.705576 1.104172 1.551539 1.677572 1.744510 1.742501 1.405814 0.732909 -0.001548 0.792087 0.610013 0.224516 0.543851 1.248555 0.528198 1.737136 1.157995 0.133926 0.560837 0.482636 1.178016 0.209695 1.695417 1.870085 -0.023412 0.442667 -0.097113 1.426811 0.293798 1.414555 1.362219 0.716643 -0.279996 0.876209 0.376052 0.713758 0.898405 0.588570 1.679087 -0.011604 0.621876 -0.260434 0.675297 1.397367 0.022620 0.495605 1.195788 0.589068 0.258283 0.580282 0.641721 1.737774 0.176607 0.510560 1.084751 0.696594 0.375026 0.527358 0.713359 1.396970 1.515481 1.146954 0.670832 0.304992 -0.147034 1.058949 1.484701 0.687879 0.134540 1.270364 -0.335699 0.344561 1.877617 1.914376 1.631947 0.777553 -0.165153)
     )

;;; 81 all -------------------------------------------------------------------------------- ; 9
#(81 11.712129592896 #(0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0)
     11.501712958685 #(0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0)
     11.22668050284 #(0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1)

     8.965874 #(0.000000 0.631646 0.914913 0.369209 0.487800 1.335005 0.656506 1.761714 1.144919 1.455053 0.441308 0.217099 1.112567 0.040241 1.343621 1.779556 1.252349 0.751542 1.115144 0.030864 1.598759 0.102122 1.912090 -0.009015 0.864251 0.823095 1.305625 1.355509 1.030320 0.122158 0.953160 1.170093 0.279074 1.516384 1.811727 0.551077 1.369111 0.695850 0.658259 1.695765 1.002473 1.817921 -0.148379 -0.021365 0.745318 1.665640 0.379532 0.500343 0.705175 0.732424 -0.187673 0.506004 0.352256 0.005955 -0.214913 0.935402 -0.626089 1.647175 1.777298 1.357632 1.130530 0.312926 1.895579 0.203877 1.180569 0.911208 0.382637 -0.059870 0.315442 0.088721 1.059315 -0.080418 1.143582 0.312598 -0.110534 -0.214841 0.241238 1.569747 0.119719 0.125861 -0.132191)
     )

;;; 82 all -------------------------------------------------------------------------------- ; 9.0554
#(82 11.697486877441 #(0 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0)
     11.601468306037 #(0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0)

     9.076594 #(0.000000 1.647541 0.113077 0.966301 0.614442 1.874882 0.593997 0.034515 1.126485 0.537094 0.406535 0.340043 -0.287448 1.668022 0.944390 0.483758 1.363084 -0.178091 1.134195 1.030914 0.613598 1.632132 0.346456 1.894375 0.334370 0.277660 1.049558 1.674867 0.391190 0.207220 0.883686 1.312517 1.804259 1.008867 0.185835 -0.072736 0.144309 1.517203 1.173823 0.663718 1.387863 1.633475 0.129798 0.355653 0.227175 1.023534 1.608964 0.663404 -0.024591 -0.423203 1.062648 1.411720 1.561946 0.787727 1.563319 0.023706 0.362244 1.609964 1.816863 0.962262 0.269625 0.897303 0.862133 0.462331 0.119063 0.573079 0.807000 1.846928 0.648679 0.717444 0.294021 -1.866437 0.482941 0.300570 0.356962 1.359458 0.999685 0.880798 1.510621 1.111773 1.774482 0.442136)
     )

;;; 83 all -------------------------------------------------------------------------------- ; 9.1104
#(83 12.009690094281 #(0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0)
     11.868338980165 #(0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0)
     11.429935034332 #(0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0)

     8.946939 #(0.000000 0.416361 0.123129 1.160033 0.086699 0.819679 0.336725 1.203242 -0.173285 1.746629 1.589222 1.159128 1.283869 0.189598 1.472322 0.236935 1.622889 0.222344 1.646775 -0.136060 1.525513 0.690450 0.553990 1.524523 -0.230214 -0.009143 0.040835 0.593351 0.905655 0.774063 0.839564 0.724642 0.985023 0.614028 0.407601 0.152541 0.902934 0.108275 0.411025 0.843202 0.541464 1.678242 1.473802 0.630409 0.156442 -0.009840 1.456411 0.983790 0.180540 0.725728 0.638016 1.107716 0.612485 0.234687 0.664846 1.526859 1.836970 0.936460 -0.055571 1.273664 0.324413 1.831692 1.004999 -0.161942 0.288130 0.348645 0.405975 0.043852 0.573386 1.370059 1.603276 0.760565 1.455149 -0.008205 0.692061 1.519552 0.987487 0.563150 0.031695 0.040946 0.190996 0.848306 1.340431)
     )

;;; 84 all -------------------------------------------------------------------------------- ; 9.1652
#(84 12.073565240583 #(0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 0 1)
     11.956374168396 #(0 1 1 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 1 1 1 0)
     11.944072619199 #(0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 0 1)
     11.81104850769 #(0 0 1 1 1 1 1 0 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 0 1)
     11.774056434631 #(0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1)

     9.027879 #(0.000000 0.159227 -0.209067 0.195604 1.194298 0.516638 0.195663 1.420812 1.601332 0.071884 0.595853 0.496889 1.880257 1.302806 1.378029 1.011682 1.568040 1.090244 0.588422 1.188459 0.185708 0.621935 0.441017 1.756722 0.220415 -0.164272 1.504668 1.955436 0.143300 0.856655 1.260647 1.293479 -0.291188 0.449574 -0.216495 -0.355849 1.221832 0.997394 1.648052 1.481563 0.240088 -0.156053 0.755323 1.704966 0.970632 0.358322 0.144616 1.151132 0.482607 0.971277 0.615639 1.331451 0.786352 0.726599 0.570318 1.452426 1.036286 0.764854 0.692283 1.021855 0.007154 0.083957 1.746408 0.711058 0.857564 1.262848 1.337120 0.606159 1.025163 1.515185 0.103681 1.494115 -0.042116 0.924412 0.284830 0.771006 -0.211617 0.728653 0.795735 1.593213 1.080213 1.207742 1.606639 0.584354)
     )

;;; 85 all -------------------------------------------------------------------------------- ; 9.2195
#(85 12.387479800774 #(0 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1)
     12.285636929325 #(0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0)
     11.953980403239 #(0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1)
     11.927130699158 #(0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 1 1 0 1)

     9.139965 #(0.000000 0.380171 0.039871 1.427781 0.419169 1.143006 0.738915 -0.138323 -0.454694 0.632771 1.400977 1.828740 0.612696 1.329496 0.766211 1.636414 1.583950 0.375006 0.768640 0.485246 0.235378 1.112012 0.802384 1.647088 0.007303 0.655427 0.985351 -0.056163 1.740153 1.799115 1.125542 0.080028 1.414868 0.455963 0.390644 0.823137 0.576178 1.355834 1.536972 0.403598 0.911042 1.261125 0.960464 0.667420 1.345507 0.258996 0.337135 0.291720 1.568842 0.045546 0.924957 1.714538 0.917787 1.031664 0.714927 1.564013 1.328756 1.247579 0.225894 0.893634 0.619748 0.858818 0.594817 1.301147 0.832657 1.435014 0.913069 1.215029 0.459943 1.521233 1.284033 0.637989 0.992776 0.653909 1.358959 -0.241778 0.713693 0.314048 -0.004968 0.034335 -0.161980 1.683030 0.652142 0.587640 0.083810)
     )

;;; 86 all -------------------------------------------------------------------------------- ; 9.2736
#(86 11.942325532619 #(0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 0 0)
     11.819784750357 #(0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)
     11.780031204224 #(0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)

     9.214322 #(0.000000 -0.333632 0.926907 -0.124718 1.092137 0.081366 0.851341 -0.012977 1.473994 1.306179 0.416139 0.296876 1.664121 0.507014 1.692547 1.169270 0.793740 0.981151 0.975658 1.054704 1.792184 1.475230 1.869862 1.489458 1.919806 0.456702 1.688522 0.600006 0.953698 -0.162662 0.843877 1.043513 0.895553 0.723890 0.150646 1.619844 1.195038 1.519535 0.801967 1.177889 0.836253 0.862839 1.519237 1.511250 0.387674 0.393774 0.799989 0.809268 1.193890 1.751477 0.271691 0.590739 0.332188 1.537288 0.763577 0.691019 1.019084 0.687466 -0.031134 0.955432 0.190370 0.394736 1.616598 0.227284 0.907187 1.313493 1.425622 0.601212 1.493460 -0.656273 1.696580 0.971054 1.426446 1.445511 1.279129 1.173032 0.629454 0.323488 1.751771 0.770336 1.540123 0.210697 0.103528 1.141471 -0.367020 0.041249)
     )

;;; 87 all -------------------------------------------------------------------------------- ; 9.3274
#(87 12.170317807503 #(0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1)
     12.065419665482 #(0 0 1 1 1 0 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1)
     11.76194265333 #(0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1)

     9.340147 #(0.000000 0.912931 -0.310985 0.638987 -0.202809 0.582474 1.896169 -0.027334 0.333497 0.269903 0.441003 1.455740 0.464683 1.071559 0.244120 0.905446 0.060696 0.588359 0.993789 1.416673 0.139031 1.535440 0.887211 0.149261 1.727428 1.287749 1.085449 0.257001 1.239182 -0.129772 0.115908 0.993965 -0.202896 0.672501 0.737867 -0.061800 0.734381 1.293394 0.862869 1.243223 0.573567 1.883541 1.292488 0.367126 0.190498 1.158446 1.588456 1.260334 1.278211 0.374313 0.262544 0.810406 0.816914 0.460624 1.014812 1.638371 1.702086 -0.065427 0.326253 -0.323606 1.919750 -0.207436 0.479135 -0.203412 1.068004 0.593005 1.517559 1.291607 0.347643 0.683807 0.845507 1.643986 0.424883 0.170513 0.453730 0.579584 0.515289 1.665231 0.119017 1.176707 0.722690 0.531563 0.303977 0.458231 0.258429 1.401733 1.754018)
     )

;;; 88 all -------------------------------------------------------------------------------- ; 9.3808
#(88 12.085149765015 #(0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1)
     11.991882324219 #(0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 1 1)
     11.638312339783 #(0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1)

     9.326646 #(0.000000 0.885495 0.462693 1.614521 0.822874 1.646618 0.219042 0.316194 0.392397 1.256352 0.881080 1.623201 1.371090 1.450157 1.794713 1.472461 0.067037 0.791237 0.330136 0.640443 0.085039 1.084711 0.335886 0.037407 0.466008 0.199773 0.539728 1.536375 -0.277123 1.370427 0.262083 0.228387 1.407262 0.978415 0.714084 0.468274 0.500354 1.312679 -0.019967 0.343889 0.847056 0.798735 -0.076535 0.538266 1.597548 0.707858 0.580489 1.625719 0.815879 1.482666 1.172436 0.088789 0.455524 -0.175874 1.173899 -0.283815 0.417571 1.200873 1.295636 1.008430 0.959028 -0.000590 1.192769 1.768886 1.743986 1.196980 1.238011 1.114019 1.125584 1.013427 0.224694 0.018762 0.930439 0.758425 -0.283601 0.563176 0.179623 0.503865 1.250502 0.535102 1.116225 1.113966 0.525100 0.529708 1.668706 1.591852 0.540356 1.280184)
     )

;;; 89 all -------------------------------------------------------------------------------- ; 9.4340
#(89 12.644 #(0 0 0 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 1)
     12.148494905477 #(0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1)

     9.360806 #(0.000000 0.117574 0.949702 1.130145 0.087978 0.255045 0.446845 0.470250 0.940783 0.468980 0.579296 0.454275 1.528451 0.711723 1.849049 0.403130 0.666414 1.457045 0.272629 0.314751 0.063845 -0.015452 0.256341 -0.289071 0.913996 0.593253 1.485784 0.949229 1.469495 0.519983 -0.302959 -0.076714 1.830116 1.062692 1.454151 1.504670 0.758829 0.844724 0.214232 0.734387 0.609096 1.277345 0.935361 0.642742 0.063128 0.623826 1.288002 0.660436 0.604124 1.656994 1.440543 1.035181 -0.545161 1.264739 1.260329 1.120838 0.118328 0.115300 1.278071 0.903108 0.005880 0.756976 0.059546 -0.031486 1.799934 -0.299981 0.304478 1.272803 0.521728 0.811127 -0.274139 1.154904 -0.055426 0.291158 1.269543 1.398549 -1.698613 0.049621 0.943950 0.443742 1.380087 0.876644 -0.613718 0.277413 0.399310 0.168619 1.026555 1.882599 0.930601)
     )

;;; 90 all -------------------------------------------------------------------------------- ; 9.4868
#(90 12.524876494276 #(0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1)
     12.364291918726 #(0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0)
     12.299262768523 #(0 0 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 0)
     12.059710502625 #(0 0 1 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0)

     9.414835 #(0.000000 0.887936 1.058714 0.210683 0.193253 1.394246 1.058170 0.039205 1.142862 0.116837 0.461549 1.638546 1.577409 1.351487 0.249566 0.098904 1.250896 1.513593 0.028869 0.736266 0.841136 1.223261 0.016696 0.422299 0.324654 1.147680 1.804544 0.442170 -0.400647 -0.014305 1.382189 -0.225678 0.274862 1.224942 0.250709 0.205568 0.964546 0.042516 0.582079 0.262583 0.973136 1.332056 0.898927 1.130095 1.428648 1.170119 1.031639 0.857189 0.861918 0.031937 1.192091 0.311047 1.889538 0.719790 0.475352 1.749920 0.762422 0.941457 -0.112338 1.227715 0.088725 0.749043 0.296452 0.681979 1.859283 1.627601 0.545940 0.574364 0.415836 0.759632 0.584088 -0.299372 0.032734 1.863093 1.697883 0.732871 -0.279335 0.703083 0.271328 0.757120 0.274510 1.426880 1.342817 1.271846 0.334657 0.228493 0.564841 0.871196 0.730896 0.488051)
     )

;;; 91 all -------------------------------------------------------------------------------- ; 9.5394
#(91 12.389336585999 #(0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0)
     12.363633155823 #(0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 0)
     12.335505485535 #(0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0 1 1 1 0)
     12.130150794983 #(0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0)

     9.476159 #(0.000000 0.443235 1.518653 1.679357 0.698270 1.381930 1.717681 1.212256 0.625327 0.942176 0.784807 1.782731 0.917589 1.084909 0.501289 1.163783 1.202736 0.320136 0.104735 1.691535 1.769392 0.109129 0.405993 1.503735 -0.048691 0.632092 0.477021 0.632428 1.517976 0.374619 1.834847 -0.013720 1.627346 1.899863 -0.087450 -0.016408 1.593632 0.343426 0.361952 0.156833 0.524777 1.674405 1.383716 0.544974 1.166887 0.116093 0.910130 -0.127257 1.115523 0.403715 1.644613 0.603891 0.900911 1.685823 0.317713 0.350137 -0.103934 1.715418 -0.235341 0.917730 1.708750 0.321794 0.192894 0.293268 1.008757 0.987158 1.433491 1.453539 0.494004 1.884861 0.712097 1.065651 1.012421 0.493873 1.106024 1.139580 1.724388 -0.001198 0.188514 1.240672 0.378753 -0.177022 1.448893 0.144684 1.421517 1.012171 0.929699 0.106084 1.670293 -0.017956 0.847515)
     )

;;; 92 all -------------------------------------------------------------------------------- ; 9.5917
#(92 12.627931418696 #(0 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1)
     12.009957507951 #(0 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1)

     9.530987 #(0.000000 0.082969 0.746634 -0.078318 0.112781 -0.237460 0.126032 1.379468 1.172372 0.033431 1.039178 0.532020 0.642675 1.016133 0.796536 0.312184 1.035430 0.766134 1.884144 0.695027 0.376691 0.680853 0.586524 0.060106 1.829544 1.675617 -0.374593 0.104261 1.781320 0.845660 0.021452 0.917131 0.596550 1.612127 0.404993 1.694522 -0.359716 0.405629 1.473535 1.469002 0.947468 1.131426 0.529485 1.026541 1.475685 0.266899 0.461354 1.231649 1.044689 0.262889 0.302167 0.988638 1.048721 1.069612 1.065546 1.009442 -0.161087 1.640508 1.272376 1.036819 0.364299 0.144725 0.530098 1.061931 1.330011 -0.328061 0.944292 1.438370 0.753049 0.884529 -0.400784 1.752952 1.471801 0.457481 1.849952 0.535627 1.162554 0.094876 1.835384 0.223586 0.918851 1.875359 0.737396 1.404798 0.626840 0.051182 0.396903 -0.098856 1.271599 0.619373 0.963961 -0.213773)
     )

;;; 93 all -------------------------------------------------------------------------------- ; 9.6437
#(93 12.624432854783 #(0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1)
     12.125471062226 #(0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1)

     9.671593 #(0.000000 1.503334 1.736477 1.812084 -0.104487 0.482184 0.500414 -0.183198 -0.047322 1.295479 0.115946 1.000145 1.690263 0.950788 0.883965 1.357360 1.703850 0.882900 1.095934 1.399915 0.327899 0.528165 0.298510 0.654560 0.188206 0.422684 1.151274 0.114977 0.251588 -0.218330 0.508510 -0.044625 0.270902 1.166064 0.983555 0.517634 0.009253 1.846054 1.101369 0.567055 0.419480 1.030411 1.502804 1.838746 1.639839 1.379095 1.656004 1.136610 1.562785 -0.040920 0.807595 0.834128 1.587859 -0.168665 1.554417 -0.320407 1.414056 1.419474 0.215275 0.924164 0.158487 0.608288 0.283032 -0.362064 1.496294 1.475517 0.335049 1.532413 0.872293 -0.176412 1.421398 0.170337 0.668574 1.332784 0.521377 0.512643 1.505611 1.242416 1.793362 1.352770 0.148399 0.097126 1.230536 1.502217 1.188812 0.402455 1.805529 1.364111 0.386324 1.436754 0.656026 1.735634 0.518767)
     )

;;; 94 all -------------------------------------------------------------------------------- ; 9.6954
#(94 12.840441703796 #(0 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0)
     12.510846178591 #(0 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0)

     9.623823 #(0.000000 0.354444 0.984435 0.690878 0.074531 1.079782 1.089432 -0.010226 1.376603 1.051023 0.023181 0.641832 0.916511 1.017297 -0.312413 0.127834 1.403964 0.785482 1.029072 0.380106 1.267828 0.450698 0.597937 0.643894 0.907899 0.578713 1.246017 0.799429 -0.011701 -0.102835 0.874684 0.412253 1.301528 1.377891 -0.400771 1.689063 0.637613 1.700286 0.551802 -0.022491 1.545937 1.526110 1.670182 1.277854 1.662249 1.389337 1.435240 0.590442 1.522877 0.934908 1.284824 1.060735 -0.150840 0.077491 0.131352 0.713152 0.345711 1.816756 0.107507 1.078916 1.052020 1.185425 0.546608 1.223592 1.093518 -0.059070 -0.190719 1.237022 1.377907 0.840589 0.357100 0.925003 0.628396 1.400912 1.383693 0.237492 0.893632 -0.037322 1.360156 -0.163041 1.245012 1.168616 0.340448 1.021732 1.767691 0.456944 1.063179 0.075940 0.539967 1.306467 1.353391 0.936607 0.692716 0.191057)
     )

;;; 95 all -------------------------------------------------------------------------------- ; 9.7468
#(95 12.744465939438 #(0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     12.706251144409 #(0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     12.448801040649 #(0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     12.431831359863 #(0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1)

     9.604455 #(0.000000 1.389541 1.172215 1.121692 0.857659 0.606867 0.055987 1.196051 0.870087 0.058082 1.680216 -0.012720 0.088002 1.775018 1.311324 1.613429 0.851265 -0.102091 0.921575 1.158424 0.456388 1.630820 1.174624 0.784813 0.403951 1.472624 1.250915 0.701412 1.782487 1.673400 1.625051 1.349258 1.054782 0.714875 1.786155 0.230110 0.627274 1.045496 1.447906 1.193739 0.999672 0.281951 0.715781 0.834409 0.896243 1.561840 0.396483 0.604225 1.221512 0.100400 0.666822 -0.072444 0.121576 0.252020 0.753244 1.691201 0.812341 -0.423214 1.073193 1.140654 0.014870 1.747528 0.021710 0.360612 1.204165 0.091070 0.590908 1.135350 0.840295 1.209459 0.837721 0.355863 0.989320 0.091382 1.784951 0.845439 1.321336 1.215515 -0.119312 1.050945 0.190751 1.207597 0.887845 1.666108 1.115848 1.565973 -0.206442 1.609503 0.019491 1.360371 0.845627 1.005066 -0.410431 0.193229 1.774845)
     )

;;; 96 all -------------------------------------------------------------------------------- ; 9.7980
#(96 12.828451411951 #(0 0 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 1)
     12.705632891559 #(0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1)
     12.682573318481 #(0 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1)
     12.586637130548 #(0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1)

     9.715002 #(0.000000 1.684960 0.449177 0.356049 0.040123 1.531898 1.128482 1.517815 0.057485 0.647269 0.742435 1.830656 0.016202 -0.236504 0.158946 -0.018392 0.120615 1.020253 1.433796 1.449798 1.516848 1.081175 0.631936 0.516630 -0.085807 1.446517 -0.253050 0.538338 0.699784 1.127064 0.394108 0.525292 0.105922 0.827505 1.794932 1.035700 1.111208 0.635372 0.772742 -0.506114 0.560894 0.696700 1.753466 1.745111 0.365890 1.451533 0.872960 1.134745 0.043065 1.475376 1.271784 0.757219 1.231467 -0.450827 1.082634 -0.253591 0.941394 1.690936 1.407143 -0.279494 0.675429 1.065832 -0.068713 0.095457 0.707026 -0.054313 0.862983 0.911929 0.017260 1.003366 -0.005564 1.434207 1.102582 0.568736 1.830870 1.155675 1.245889 1.151079 0.992180 -0.312677 0.159069 0.897861 0.915136 1.573113 1.062684 0.132121 1.354159 0.158729 -0.376088 0.263198 0.397081 0.770649 -0.048874 1.277672 1.025226 1.548342)
     )

;;; 97 all -------------------------------------------------------------------------------- ; 9.8489
#(97 13.438 #(0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0)
     12.872588157654 #(0 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)
     12.585 #(0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)
     
     9.821217 #(0.000000 1.592896 0.915868 0.150482 1.276512 1.387554 1.512617 0.758045 0.808763 1.017083 0.627345 1.880010 1.224380 0.807036 -0.030829 1.504077 1.749618 -0.212870 -0.283024 -0.059450 0.244036 0.733349 1.685273 0.086145 1.594562 0.615363 1.159068 1.234224 1.445554 0.831155 0.848569 0.211071 1.369273 0.436080 0.369918 1.456286 0.210106 1.446471 1.136027 1.391704 0.910177 1.762379 0.071812 1.475230 1.265597 0.806182 -0.166571 -0.034835 0.036512 0.938475 0.459149 -0.451361 -0.009003 1.684504 0.934620 1.755104 1.291991 0.706523 0.032518 1.698445 1.939945 -0.154472 1.603766 0.779790 1.447925 1.071895 1.394767 0.024209 1.941562 0.446124 0.607194 0.872499 1.321048 0.509019 0.897510 1.622338 0.224973 1.374116 1.190321 0.660963 0.449356 0.802144 1.444329 0.391225 1.047656 0.189536 0.832278 0.173279 0.389856 0.562271 1.798033 0.568292 1.223606 0.837449 -0.110881 0.707154 1.250119)
     )

;;; 98 all -------------------------------------------------------------------------------- ; 9.8995
#(98 13.163645755645 #(0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1)
     13.161917686462 #(0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 1 1 1)
     12.724907890996 #(0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1)

     9.780776 #(0.000000 -0.184104 0.671707 1.163943 -0.147437 1.671445 0.365672 0.492663 0.190131 0.715624 1.719725 0.379086 1.018018 0.547318 0.342175 1.540213 0.971139 0.936914 -0.110124 1.642719 1.646360 0.039163 1.858936 1.214476 1.297877 1.228019 0.028658 0.399411 1.200608 1.645396 -0.156153 0.270837 1.281192 1.670814 1.151590 0.909789 1.137794 1.469621 0.856079 0.443733 0.762563 -0.417367 1.879552 1.728545 -0.232713 0.761350 0.560891 0.612508 0.223371 -0.021547 1.526688 -0.044461 0.583700 0.028408 0.481786 0.554194 -0.034278 1.258872 1.346563 0.062748 0.282088 -0.240911 0.618464 0.497770 0.821670 -0.007759 0.584400 1.232419 0.840225 1.220759 0.681003 1.656049 0.296974 1.894870 0.730674 0.050248 1.540491 0.177423 1.453434 0.360102 0.119065 1.523091 1.185702 0.506713 1.415320 0.849998 0.006708 1.481201 0.611520 0.208396 0.551061 0.259020 1.780702 0.268136 1.158789 -0.082117 0.200878 1.209574)
     )

;;; 99 all -------------------------------------------------------------------------------- ; 9.9499
#(99 13.236550650051 #(0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1)
     13.002375571256 #(0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 0 0 0)

     9.868417 #(0.000000 0.534576 1.130138 0.053541 1.657537 0.269675 1.098460 1.562891 1.613922 1.111190 0.727698 0.733123 -0.128959 0.356954 0.665463 1.668455 -0.489290 -0.198868 1.605213 1.800337 1.039481 0.120554 0.388535 1.684605 0.428029 1.560910 0.046489 1.545136 1.445086 0.897136 1.326959 1.658523 1.131698 0.465211 1.314195 0.675644 0.797369 0.442424 1.272861 0.336591 0.150652 -0.191377 0.750865 0.467789 1.605669 -0.007805 1.649608 1.840489 0.400574 0.553130 -0.017232 1.477736 0.899978 1.115162 -0.053835 0.182599 -0.027075 1.806484 0.073134 -0.015032 0.066184 0.359855 1.204108 0.947735 0.070642 1.514819 0.008009 0.205617 0.735106 -0.336084 0.755050 0.538924 1.814872 0.455591 1.383728 0.873152 1.077148 1.708625 0.668481 0.919198 1.715232 -0.566737 1.421765 1.209427 0.385763 0.382773 1.496432 1.641712 0.246925 1.814568 0.865368 1.844506 1.032085 0.593557 1.518768 0.833058 1.243498 1.646987 1.331644)
     )

;;; 100 all -------------------------------------------------------------------------------- ; 10
#(100 13.230233676417 #(0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0)
      12.998435541498 #(0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0)

      9.944339 #(0.000000 0.000362 1.130820 1.929009 1.310394 0.901046 0.274970 1.552819 -0.054824 1.308404 0.254097 0.118397 1.654092 -0.475539 0.833290 0.369478 1.742790 0.570764 0.826333 0.730992 0.672509 0.989942 1.551395 -0.008371 1.183821 -0.087256 0.000139 0.105223 0.576830 -0.414224 1.749326 1.266632 1.703106 1.051974 -0.197124 1.283842 0.938879 0.706852 0.574852 1.462768 1.234075 0.074052 1.469947 1.656524 0.231167 1.708021 -0.098658 0.398123 1.783151 0.045310 0.718305 1.746924 1.294127 0.467638 0.594206 0.993669 1.908332 0.303020 0.318089 1.901694 1.332944 0.631707 0.210154 1.034716 1.353061 0.938194 0.941600 -0.023333 0.011151 0.262215 1.507271 1.474026 0.316319 1.376356 0.299073 1.346620 1.923210 1.235681 0.459143 1.125199 0.939911 1.625303 0.280840 1.555740 1.581998 1.271675 1.060881 1.020276 1.652288 1.029727 0.345799 0.843723 0.944449 1.303278 1.634903 1.288478 0.095244 0.617909 0.891172 1.703691)
      )

;;; 101 all -------------------------------------------------------------------------------- ; 10.0499
#(101 14.018204689026 #(0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0)
      13.645306283587 #(0 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 1 0 0)
      13.268 #(0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0)
      13.219774246216 #(0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0)

      10.063960 #(0.000000 1.439477 0.306835 -0.044034 1.600307 1.555732 1.098792 0.419965 0.366434 0.097902 -0.328325 0.641671 1.908456 0.786860 0.738747 -0.106473 1.701536 0.036650 1.601054 -0.507607 0.666405 1.451074 0.833935 0.190249 0.363241 1.586234 0.780378 1.306150 0.655928 0.164127 0.928532 1.433750 0.670396 0.845921 0.839080 0.546210 1.581723 1.182656 -0.091344 -0.036402 0.116137 1.690123 0.707695 0.059555 1.556744 0.802351 1.536036 0.382275 0.619072 -0.297381 0.509264 0.493781 0.837747 1.575032 1.864941 1.163262 1.188216 0.200340 -0.346245 1.531966 1.104638 0.109434 1.030226 1.546301 0.506520 1.749825 1.164617 0.646001 0.100430 0.745681 1.690398 1.855444 1.883964 1.344913 1.615679 1.348678 1.495217 0.471750 0.814427 1.215126 0.656879 1.286828 1.454298 1.042293 1.473382 1.041966 1.177271 1.308908 0.006270 1.263024 0.019538 0.156917 0.532121 1.015436 1.145245 1.529098 1.606311 0.362145 0.807326 1.703000 -0.101960)
      )

;;; 102 all -------------------------------------------------------------------------------- ; 10.0995
#(102 13.521512151222 #(0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 0)
      13.497511863708 #(0 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1)
      13.300039088203 #(0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 0)
      13.194128990173 #(0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 0)

      10.088316 #(0.000000 0.095626 0.514266 0.420449 0.749499 0.992394 -0.193393 0.039052 0.057117 1.575374 1.352773 1.322452 0.794003 0.750383 0.756593 0.273089 1.675537 0.407815 0.550801 -0.538502 0.957909 1.336960 1.614983 0.508708 1.910222 1.874209 0.940387 0.222605 0.538045 1.356000 1.741919 0.598382 1.550605 1.131133 0.773140 -0.232481 0.055269 1.822145 0.659426 -0.100655 1.261624 0.557410 0.214081 0.588453 0.458097 0.577319 1.055339 1.792023 0.525700 0.097434 0.222735 0.356704 1.885210 0.037676 0.938171 0.984298 1.949046 1.455206 0.941409 1.068679 0.637889 0.330852 0.138031 1.619860 0.674126 -0.251106 1.183963 1.959835 0.213213 0.066073 0.132459 0.329261 0.847485 0.503486 0.122913 0.684764 1.979054 0.659531 0.231782 1.341252 0.124898 0.707447 -0.419234 0.913042 1.413830 0.741236 1.664719 1.833486 -0.410776 0.347702 1.045974 -0.368342 0.123701 1.012180 1.052039 1.226053 0.364036 1.015550 1.423284 1.022491 0.770674 1.877516)
      )

;;; 103 all -------------------------------------------------------------------------------- ; 10.1489
#(103 13.720711052869 #(0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1)
      13.673172572795 #(0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1)
      13.435972213745 #(0 1 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 0 1)

      10.082471 #(0.000000 0.779848 0.792112 0.549766 0.301138 -0.171353 0.807038 1.543296 0.477535 0.826769 0.407151 0.769491 0.056739 0.071499 0.247312 -0.005373 1.569101 1.042770 1.680906 0.059594 0.053954 1.441955 0.914538 1.449320 1.294874 -0.069091 0.475701 1.134724 1.127659 1.080820 0.123680 0.576705 1.005157 0.923560 0.243145 0.278344 -0.412784 1.416609 0.932213 1.132883 0.493513 -0.667618 0.532355 0.941368 1.389578 0.414431 0.044796 1.191618 0.283462 1.516743 1.584827 1.158022 1.236225 1.237040 0.109755 1.094373 1.341841 0.602799 1.179844 0.288293 1.474361 0.642735 1.306280 1.742843 1.343754 0.728272 0.062401 0.905871 -0.185547 1.481632 0.773558 1.388927 -0.159511 1.515570 0.592120 0.024953 -0.104029 0.856176 0.287406 1.414546 0.954888 -0.309243 0.130334 0.219966 0.633357 0.594654 0.502630 0.658737 1.183680 1.318908 1.217613 1.223727 0.662738 1.588868 0.876252 1.462262 0.040675 0.133752 0.987411 0.229575 0.206213 0.977110 0.998658)
      )

;;; 104 all -------------------------------------------------------------------------------- ; 10.1980
#(104 14.242193222046 #(0 1 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0)
      13.682311361591 #(0 1 1 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0)
      13.330215043333 #(0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0)

      10.131134 #(0.000000 1.620715 1.706924 0.966340 1.392944 1.097828 0.152963 1.208856 1.449587 0.836174 1.529949 -0.147270 1.087471 1.312494 0.833497 0.266164 0.957031 0.396338 0.447671 0.840230 1.677977 0.881761 1.605304 0.780240 0.387112 0.711006 1.702248 0.052358 0.842860 0.054971 0.546408 0.094631 1.769317 0.142354 0.938253 0.532414 -0.149430 1.624247 1.587064 0.685457 0.828530 0.094970 0.905302 0.262831 -0.300799 0.854972 -0.018034 0.746636 1.541395 -0.027939 0.019294 0.789501 0.531273 0.622622 0.348655 0.435308 0.703152 1.588104 1.487086 1.437905 0.298310 1.125935 0.356805 0.121939 0.724138 0.042346 1.714676 1.307736 0.118213 0.359387 0.405811 1.411854 1.457098 0.626919 0.905685 1.794258 1.087823 1.058814 1.814738 1.628779 0.514037 0.620467 1.215667 0.120288 0.453741 1.727276 0.071685 -0.178285 0.331549 1.540337 1.669639 -0.472693 -0.010004 0.139970 0.232730 0.628211 0.709683 0.674177 0.187159 1.334757 0.656929 0.472580 1.629203 0.746599)
      )

;;; 105 all -------------------------------------------------------------------------------- ; 10.2470
#(105 14.418999645918 #(0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 0 1 0)
      13.595993876506 #(0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 1 0)

      10.180884 #(0.000000 0.591981 0.234291 1.318079 1.359733 -0.402352 0.536203 0.620443 0.327192 1.061371 -0.154602 -0.031483 1.234466 1.771078 1.088955 1.511047 0.089661 0.999237 -0.060134 -0.053244 1.486257 0.778481 0.480250 1.422204 0.158654 -0.258226 0.123627 0.479665 1.176790 1.114620 1.075478 1.267486 0.962476 1.942207 1.085940 1.538344 0.309219 1.385733 1.944090 1.283759 -0.011813 1.359819 1.317157 1.087312 0.478590 0.458776 1.096311 0.480067 0.566819 1.559128 0.590877 1.382995 1.150707 0.199089 0.309180 0.584476 0.629587 0.851022 0.795261 -0.190166 1.491122 1.296392 0.276396 0.106215 1.748512 1.597199 1.901121 1.656825 0.405852 0.142405 1.354372 1.693716 1.125442 0.914352 1.245807 0.386901 -0.244323 0.149160 0.078350 0.823210 -0.022949 0.545752 0.329495 -0.041901 1.634629 0.433964 0.155451 0.394271 -0.277302 0.666742 0.202111 1.084088 1.062243 -0.044051 0.595079 0.639415 1.112809 0.039500 0.572577 -0.179814 1.651646 0.369721 0.619404 1.695073 1.280564)
      )

;;; 106 all -------------------------------------------------------------------------------- ; 10.2956
#(106 14.299785614014 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)
      13.811582734804 #(0 0 1 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)
      13.421741504769 #(0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0)
      13.200031373463 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)

      10.244219 #(0.000000 0.061900 -0.056757 1.221145 1.071258 0.965818 -0.112009 0.537607 0.772480 1.095141 1.603379 1.126677 1.251943 0.110613 -0.004174 -0.176558 1.222264 0.975934 0.255009 0.039072 0.331798 0.707855 1.496586 0.262274 0.845649 0.130072 0.523006 0.084091 1.210738 1.199337 -0.212930 0.554459 1.279221 0.075212 1.301718 0.399645 0.049903 1.019161 -0.134150 0.061134 1.217671 0.762311 1.650544 0.810150 1.479743 -0.163789 1.129237 0.394589 1.704430 0.388551 1.529529 1.033597 0.664311 0.951535 0.551128 0.741027 1.233727 1.731929 0.567940 1.600000 0.248999 1.204723 1.016883 1.617007 1.316903 0.221716 1.354374 1.142630 0.143952 0.416605 0.132049 1.750230 -0.008123 -0.200704 0.308583 0.114188 -0.497732 1.075126 0.023667 -0.091417 1.759101 1.352710 0.452639 1.059926 1.017933 -0.124373 0.260343 0.135653 0.025580 0.408361 0.032734 0.516237 1.132203 0.591624 1.430106 1.807190 0.368124 0.241595 1.501847 -0.346496 0.358613 1.653229 1.371624 1.291115 -0.211838 1.337447)
      )

;;; 107 all -------------------------------------------------------------------------------- ; 10.3441
#(107 13.927956268954 #(0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1)
      13.912716531306 #(0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 1 0 1 0 1 0 0)
      13.624429092956 #(0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)
      13.224366750161 #(0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)

      10.289200 #(0.000000 1.285172 0.728342 1.700046 1.795355 0.499293 0.002123 0.644979 1.557081 0.755607 0.414253 -0.176021 0.192102 1.383663 1.485521 0.553057 1.079812 0.127785 0.278323 1.055841 -0.210945 1.761717 1.161942 0.302890 0.025894 1.714918 1.381210 1.715367 0.539786 -0.078528 0.386660 1.912956 1.686242 0.389369 1.313954 1.059384 -0.007107 1.172842 0.100645 1.121252 1.584934 0.182465 0.043495 0.183842 1.516913 1.501647 0.021966 0.236693 0.050760 0.880918 0.490053 0.977890 1.366695 1.838735 1.225182 0.599876 0.938833 1.416998 0.949676 1.204959 0.360647 1.183078 1.486942 0.280110 0.113112 1.262046 1.511625 1.145005 1.492240 1.384698 0.506375 1.323678 1.038449 1.352371 0.523159 1.486392 0.342870 -0.086837 0.787345 0.279706 0.035400 1.660526 0.182725 1.101749 0.773607 0.664310 0.089239 1.418296 1.750412 0.066626 1.978350 1.533564 1.443632 0.283239 0.528601 1.121136 -0.444638 1.678462 1.309421 1.475777 1.451389 0.560730 0.115781 0.988286 0.498711 0.712681 1.608142)
      )

;;; 108 all -------------------------------------------------------------------------------- ; 10.3923
#(108 14.009567264777 #(0 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 0 0 0)
      13.998919339781 #(0 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 0)
      13.694299006963 #(0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 1 1 1 0 0 0 0 1)
      13.534 #(0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 1)

      10.321245 #(0.000000 1.293162 0.753887 1.806052 1.107099 0.764514 1.438748 1.629650 0.527994 1.809147 1.179826 0.012868 0.354380 0.092176 0.430684 0.199241 0.904012 0.742679 0.671441 -0.111301 1.145972 1.812285 0.549846 0.275662 0.836670 1.126274 -0.181881 -0.338701 0.644072 0.161331 0.865881 1.268082 0.831484 1.217177 1.664968 1.060926 1.941150 -0.010737 0.364930 0.720865 0.623247 1.572029 0.111454 0.570395 1.802085 0.876276 0.068844 0.071693 0.552493 0.329365 0.546403 0.338884 1.647343 1.034607 0.470258 1.774319 0.240758 1.848640 1.141588 1.225338 0.830479 0.425336 0.642118 1.258622 1.086934 0.643531 0.431191 0.970972 0.107563 0.689639 0.418011 1.804599 1.349060 0.149733 0.403352 0.573016 1.441033 0.531813 -0.175545 0.297931 0.921090 1.091005 0.411371 0.849566 1.520923 1.877748 0.520877 1.244033 -0.053820 0.834987 0.278284 1.955504 1.766600 1.536031 1.530651 -0.111104 1.325448 -0.070718 1.047226 0.535275 0.700692 0.067785 0.068435 1.207233 1.621169 1.071256 1.373169 0.850259)
      )

;;; 109 all -------------------------------------------------------------------------------- ; 10.440306508911
#(109 13.820175866598 #(0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0)
      13.496821304096 #(0 0 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0)

      ;; 10.439838 
      10.4402289706 #(0.000000 0.229786 0.393905 0.264939 0.979442 0.194696 1.256612 -0.055443 0.065517 1.495352 1.210813 0.258054 1.626969 1.731654 0.099659 1.772571 -0.437044 1.026887 -0.163135 0.238020 1.057173 1.552822 1.220361 1.637333 -0.255686 1.974751 1.565469 0.650160 0.970389 1.193950 1.380547 0.925977 -0.054093 -0.059026 1.567150 1.438141 0.812545 0.734406 0.115272 1.520948 -0.047428 1.425370 0.149198 1.450448 1.686911 1.546280 1.610820 0.672173 0.043038 1.008393 0.702035 0.846805 0.399684 1.435130 1.032605 1.048060 0.386036 1.255887 -0.133574 -0.132556 -0.026012 1.740866 1.269741 -0.029772 0.227895 0.941043 1.607835 0.461239 -0.013717 0.716440 1.261329 0.621772 0.897717 0.644053 0.248325 1.823223 -0.024387 0.564850 0.741422 1.133438 0.851976 0.144927 1.161747 1.085697 0.364365 1.037487 0.226188 1.785940 0.378074 0.870839 1.395568 1.779561 1.082541 1.260600 1.180692 0.677317 1.443257 0.327705 0.281236 1.176856 -0.190717 1.177170 0.132394 0.083110 1.239232 0.795570 -0.017382 0.371638 1.047440)
      10.439633 #(0.000000 0.229586 0.393924 0.265039 0.979405 0.194583 1.256575 -0.055087 0.065642 1.495196 1.210813 0.258154 1.626869 1.731654 0.099659 1.772671 -0.437044 1.026887 -0.163135 0.238120 1.057073 1.552722 1.220361 1.637333 -0.255686 1.974751 1.565469 0.650160 0.970389 1.193950 1.380547 0.925977 -0.054093 -0.059026 1.567150 1.438141 0.812545 0.734406 0.115272 1.520948 -0.047428 1.425370 0.149198 1.450448 1.686911 1.546280 1.610820 0.672173 0.043038 1.008393 0.702035 0.846805 0.399684 1.435130 1.032605 1.048060 0.386036 1.255887 -0.133574 -0.132556 -0.026012 1.740866 1.269741 -0.030088 0.227895 0.941043 1.607835 0.461239 -0.013717 0.716440 1.261329 0.621772 0.897717 0.644053 0.248325 1.823223 -0.024387 0.564850 0.741422 1.133438 0.851976 0.144927 1.161747 1.085697 0.364365 1.037487 0.226188 1.785940 0.378074 0.870839 1.395568 1.779561 1.082541 1.260600 1.180692 0.677317 1.443257 0.327705 0.281236 1.176856 -0.190717 1.177170 0.132394 0.083110 1.239232 0.795570 -0.017382 0.371638 1.047440)
      10.439385 #(0.000000 0.229731 0.393932 0.265050 0.979445 0.194707 1.256586 -0.055069 0.065653 1.495214 1.210758 0.258174 1.626919 1.731622 0.099749 1.772653 -0.437018 1.026855 -0.163167 0.238088 1.057024 1.552722 1.220361 1.637333 -0.255686 1.974751 1.565469 0.650160 0.970389 1.193950 1.380547 0.925977 -0.054093 -0.059026 1.567150 1.438141 0.812545 0.734406 0.115272 1.520948 -0.047428 1.425370 0.149198 1.450448 1.686911 1.546280 1.610820 0.672173 0.043038 1.008393 0.702035 0.846805 0.399684 1.435130 1.032605 1.048060 0.386036 1.255887 -0.133574 -0.132556 -0.026012 1.740879 1.269741 -0.030088 0.227895 0.941043 1.607835 0.461239 -0.013717 0.716440 1.261329 0.621772 0.897717 0.644053 0.248325 1.823223 -0.024387 0.564850 0.741422 1.133438 0.851976 0.144927 1.161747 1.085697 0.364365 1.037487 0.226188 1.785940 0.378074 0.870839 1.395568 1.779561 1.082541 1.260600 1.180692 0.677317 1.443257 0.327705 0.281236 1.176856 -0.190717 1.177170 0.132394 0.083110 1.239232 0.795570 -0.017382 0.371638 1.047440)
      10.439368 #(0.000000 0.229684 0.393927 0.265081 0.979411 0.194659 1.256579 -0.055069 0.065642 1.495178 1.210737 0.258179 1.626883 1.731680 0.099743 1.772667 -0.437020 1.026863 -0.163107 0.238096 1.057037 1.552722 1.220343 1.637351 -0.255686 1.974751 1.565469 0.650160 0.970389 1.193950 1.380547 0.925977 -0.054093 -0.059026 1.567150 1.438141 0.812545 0.734406 0.115272 1.520948 -0.047428 1.425370 0.149198 1.450448 1.686911 1.546280 1.610820 0.672173 0.043038 1.008393 0.702035 0.846795 0.399684 1.435130 1.032605 1.048060 0.386036 1.255887 -0.133574 -0.132556 -0.026012 1.740866 1.269741 -0.030088 0.227895 0.941043 1.607835 0.461239 -0.013717 0.716440 1.261329 0.621772 0.897717 0.644053 0.248325 1.823223 -0.024387 0.564850 0.741422 1.133438 0.851976 0.144927 1.161747 1.085697 0.364365 1.037487 0.226188 1.785940 0.378074 0.870839 1.395568 1.779561 1.082541 1.260600 1.180692 0.677317 1.443257 0.327705 0.281236 1.176856 -0.190717 1.177170 0.132394 0.083110 1.239232 0.795570 -0.017382 0.371638 1.047440)
      )

;;; 110 all -------------------------------------------------------------------------------- ; 10.4881
#(110 13.885513312292 #(0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 1 0)
      13.64278793335 #(0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1)
      13.592092514038 #(0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1)

      10.510065 #(0.000000 1.025212 -0.295486 0.703763 -0.054893 -0.039885 1.463939 1.422595 0.897186 1.585873 0.457132 1.462174 -0.041541 1.726694 0.631706 0.499087 1.239186 0.901823 1.393649 0.025479 0.723544 1.269051 0.984635 0.557380 0.164315 1.253065 0.788143 1.152242 1.215804 1.184592 0.385833 0.644672 0.757604 0.238281 1.810353 0.118189 0.650714 0.642268 1.108863 0.109155 1.880087 0.062675 0.980082 0.346239 0.110345 1.347792 1.378962 0.780525 1.430818 0.085486 0.507464 0.747472 0.373429 0.292201 0.484931 0.885050 1.221586 1.642944 0.749092 1.095082 0.552307 1.001499 1.174158 1.183107 1.014045 0.623205 1.875621 1.254172 0.583015 0.418005 -0.066397 0.176003 0.013239 1.017011 1.256397 0.859939 0.906176 0.500733 1.335703 0.502624 1.660317 1.077858 1.337115 -0.089193 0.412173 1.719935 0.539075 1.078357 0.973163 -0.112717 1.158436 -0.049388 1.914962 0.660096 -0.341941 1.974047 0.067883 -0.160430 1.148379 0.247718 0.942941 0.506409 1.157175 -0.064883 1.649419 0.919153 0.906529 1.942207 1.066522 0.657865)
      )

;;; 111 all -------------------------------------------------------------------------------- ; 10.5357
#(111 14.436 #(0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1)
      14.359505653381 #(0 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0)
      13.80813938144 #(0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1)

      10.507244 #(0.000000 1.272768 0.963005 -0.228688 1.899569 0.090562 1.826022 1.329952 0.303243 1.517005 -0.038964 1.168349 0.065907 1.257843 1.328000 -0.073951 1.429945 0.441612 0.544897 0.178538 0.789412 0.498121 1.034135 1.510065 0.259552 0.023336 0.992931 -0.052275 0.813156 1.315149 -0.207647 0.883468 1.685870 0.817408 1.411454 1.450809 1.328189 0.972130 0.453851 1.167657 -0.300346 0.521448 1.121616 1.346804 1.484668 1.337254 0.068696 0.511938 -0.053070 1.158074 1.177028 1.326077 1.285029 1.264045 0.079614 0.482841 1.928545 -0.078228 1.634893 1.119712 1.635704 0.782535 0.958217 1.049397 0.854316 0.391175 1.392832 0.791054 1.041833 1.607031 1.735375 -0.176916 0.893194 0.549587 1.576468 0.828284 0.118686 0.118286 -0.129497 0.371997 0.084586 -0.031375 0.543055 0.296815 0.381161 1.590768 1.093131 0.788489 1.655240 0.196406 1.856232 1.227023 1.576611 0.556329 0.445822 1.741677 0.298196 1.449150 1.622622 0.931864 0.451800 1.218447 -0.329328 1.521139 0.627424 0.314777 1.229932 0.084481 0.333184 0.797759 0.122302)
      )

;;; 112 all -------------------------------------------------------------------------------- ; 10.5830
#(112 14.387 #(0 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 1 1 0)
      14.250584755219 #(0 0 1 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 1 1 0)
      14.059637729172 #(0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1)
      13.719 #(0 1 1 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0)

      10.470952 #(0.000000 -0.066078 1.591007 0.942336 0.780671 0.818731 0.713519 1.049049 1.121816 0.290283 -0.314170 0.936775 0.364560 1.650912 1.191758 0.733286 1.257878 0.982576 0.504269 1.900772 1.620083 0.446890 0.456536 0.533921 0.686384 0.885064 1.295331 0.245985 0.353185 0.475653 1.785498 1.847534 0.797523 0.520992 0.164988 0.222187 0.883484 0.029080 1.768532 1.572657 1.347858 0.107563 0.386269 1.463833 1.530962 -0.027266 0.401776 0.273989 0.474025 0.231454 0.620997 0.028168 -0.068528 -0.095823 0.578846 0.717848 1.279023 -0.203769 0.373427 0.858643 0.817582 -0.327455 0.481719 0.802218 0.467648 0.632248 0.910368 0.440126 0.114317 1.520344 1.410599 1.227358 -0.132471 1.721692 0.276634 0.814516 -0.441536 0.264155 1.183259 -0.119493 0.752930 1.162482 0.231822 1.196651 1.266571 1.427337 1.110141 0.317039 0.582514 -0.112492 0.997984 0.151803 1.089950 1.914378 1.183265 -0.014353 0.298279 0.815983 0.400657 0.671147 1.537149 0.456530 -0.253877 0.788670 1.689260 1.259503 1.232980 1.364536 1.048382 0.028300 1.319921 0.390838)
      )

;;; 113 all -------------------------------------------------------------------------------- ; 10.6301
#(113 14.501041453443 #(0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1)
      14.027848738379 #(0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 1 1 1)

      10.606425 #(0.000000 0.803678 1.150094 -0.064140 0.152720 1.102412 1.520038 1.838706 0.207633 0.505473 1.406636 1.283262 0.273132 0.579221 0.337433 0.187905 1.774775 1.188325 0.101146 1.108363 0.010713 -0.137848 0.853701 0.686997 0.177610 -0.599332 0.446682 0.454320 1.859041 0.374505 -0.018834 1.370484 0.814265 1.286823 1.607888 0.427239 0.458397 0.424305 0.560698 1.702770 1.615135 -0.032890 1.140672 0.402315 0.676935 1.484434 0.383251 0.332654 1.077015 1.357779 1.106896 0.206329 -0.261068 1.245226 1.322161 -0.103802 0.096155 0.151895 1.818225 0.632479 0.860867 -0.123006 1.125410 -0.153054 0.641568 0.101060 0.775616 0.549052 0.403717 1.169503 1.101302 1.092627 1.064534 1.091938 -0.006031 1.297090 0.124050 1.432010 0.839262 0.967317 1.178206 0.210486 0.720733 0.094576 1.035393 1.192728 0.607850 -0.310323 1.252460 0.698015 1.429940 0.330711 0.934919 0.583092 0.112551 0.670733 0.788218 0.101847 0.749889 1.807575 0.411573 0.232277 -0.023436 1.470195 1.647762 1.088908 1.690827 1.868858 0.612646 1.538094 0.986415 1.244086 0.785909)
      )

;;; 114 all -------------------------------------------------------------------------------- ; 10.6771
#(114 14.119774267447 #(0 1 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1)
      13.847382931726 #(0 1 1 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1)

      10.638782 #(0.000000 0.619135 0.950545 0.746397 0.831572 0.289111 1.857144 0.926829 1.800961 1.156763 -0.675300 0.077227 -0.069301 1.150373 -0.215139 0.099731 1.741445 -0.014567 1.825153 -0.312439 0.152320 0.790997 0.806199 0.462922 0.625984 1.265900 0.397419 0.964625 1.686086 0.909220 0.270338 0.650357 0.109619 1.479378 0.044049 0.223454 0.513471 0.188636 -0.178438 1.593598 0.884258 -0.231703 1.238997 1.196738 1.564594 1.500169 0.806152 -0.015046 1.447867 1.211310 1.815557 0.635862 1.383469 0.614503 0.309056 1.428974 1.352319 1.098928 0.211389 1.659708 1.740908 1.408990 0.574093 0.820597 1.299075 1.212549 0.209061 1.160441 1.173909 0.000273 0.713749 0.403702 0.129970 0.527562 1.012763 1.535325 1.326770 1.268365 0.290134 1.411487 0.614537 1.278441 0.204918 0.416758 1.047619 -0.424508 1.685083 0.615702 -0.010627 -0.438718 1.767400 1.187092 -0.354232 1.539685 1.593968 0.840191 0.334982 0.945841 1.679758 -0.155393 1.505024 0.115100 1.076024 0.288360 -0.197668 1.241371 -0.032352 1.278488 0.076501 0.528271 1.039557 0.355036 1.455723 -0.218403)
      )

;;; 115 all -------------------------------------------------------------------------------- ; 10.7238
#(115 15.196797370911 #(0 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0)
      14.359978160099 #(0 0 0 0 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 0)

      10.693726 #(0.000000 0.226271 0.541542 1.125339 0.070063 1.833988 0.642338 0.438755 1.249498 1.601700 0.542795 -0.022464 0.885189 0.969775 0.099550 0.725872 0.408184 1.047122 -0.122122 1.174910 0.462025 1.042595 0.990894 1.253815 1.254901 0.893044 0.216986 1.831335 -0.117187 0.734223 1.368320 1.275350 -0.071526 0.805012 1.306079 0.095484 0.271879 0.384682 0.925191 0.086552 0.354278 0.901591 1.528035 1.449686 1.231290 1.328990 1.418748 1.497161 0.607797 1.313259 0.323783 1.176986 1.216159 0.230166 1.541320 -0.009550 0.673320 0.457436 0.260878 0.709892 1.784612 0.272401 -0.207754 0.366190 -0.144803 1.129101 1.476929 0.836194 0.398192 0.103466 -0.048002 1.379651 0.043917 1.014266 0.546858 0.525067 1.053902 1.082080 -0.481738 1.005776 0.464808 0.704016 1.266852 0.965055 0.097536 1.536508 0.686335 0.268480 0.898845 -0.034965 1.090862 1.071531 0.175198 1.197138 0.879155 1.679814 0.583284 0.748420 -0.010024 0.407130 -0.021393 0.116642 0.076217 0.854666 0.636631 0.087936 0.644749 1.224335 0.326296 0.004466 -0.387642 1.527901 0.523071 0.458102 0.353484)
      )

;;; 116 all -------------------------------------------------------------------------------- ; 10.7703
#(116 14.830805621528 #(0 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 0 0 1 1 1)
      14.175787507646 #(0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 1 1 0)

      10.675631 #(0.000000 0.795615 0.128011 1.153790 0.578433 1.671969 1.437483 0.801765 -0.071861 0.614504 1.011489 0.242817 1.425972 1.360175 0.520527 1.303300 0.112896 0.481990 1.248624 -0.063090 1.819885 1.002192 1.771509 0.995902 0.220705 0.236789 0.921423 0.251100 0.242533 1.207222 1.193056 1.545535 0.666520 0.275296 0.722426 0.042809 0.124832 1.054456 -0.473560 1.037954 0.453955 1.205838 1.060188 0.252381 0.912820 -0.469964 1.283859 1.263306 1.713371 0.146297 1.561208 0.118395 1.210200 1.204528 1.380587 1.281782 -0.395870 1.911712 1.608592 0.470217 1.106039 0.210397 1.458340 1.810530 1.435767 0.083569 1.197261 1.185488 1.575106 0.067467 1.160434 0.608486 0.567549 1.027239 1.124795 -0.212374 1.005725 1.009788 0.183274 1.529289 1.787782 1.236581 0.608219 0.764226 1.751804 1.422621 0.953269 0.296699 0.939742 0.321987 0.474389 0.040733 0.104660 0.215688 1.091219 1.136993 1.661453 0.521660 1.198246 -0.359942 1.525952 1.224467 -0.014599 1.277801 -0.475080 -0.460767 0.028493 0.972951 1.008037 0.424503 0.343218 0.465827 0.905312 0.747839 -0.295936 0.076447)
      )

;;; 117 all -------------------------------------------------------------------------------- ; 10.8167
#(117 14.857519237248 #(0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 1 0 1 0 1 0)
      14.522986412048 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1)
      14.136 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1)

      10.758849 #(0.000000 1.382904 1.211266 1.622050 0.017350 1.558348 1.295918 -0.383833 0.174853 0.812926 0.261773 -0.558859 0.495306 1.562089 0.493493 1.256778 1.584129 0.516418 0.600870 0.984536 0.308010 1.050787 1.415499 1.856577 -0.136318 0.882748 1.573111 0.986120 0.812158 1.609494 -0.293318 0.192496 1.567465 1.128859 -0.241469 1.440524 0.254114 0.607068 0.571318 0.054007 0.139954 0.140229 0.176066 1.927631 -0.034803 0.144636 1.625485 0.362059 0.022530 1.814831 1.447339 1.321707 1.696672 0.084622 0.932476 0.875012 0.601617 -0.296667 1.481661 0.811950 -0.230940 1.902933 0.270352 1.080060 0.272729 1.340147 0.729700 1.552390 0.988545 0.799487 0.583494 0.840653 1.578898 0.482165 1.603458 1.564195 1.143729 1.139069 1.663467 0.418703 -0.176076 1.256717 1.612545 0.832984 0.249181 0.092316 0.339754 1.792594 1.077407 1.071048 0.798406 1.133568 1.463945 1.391775 -0.111168 0.799686 -0.092825 -0.167250 0.778194 -0.242112 0.807346 1.310946 0.325411 1.461264 0.618892 1.034122 1.003688 -0.075556 0.004677 1.234707 0.566765 0.357700 -0.481077 0.718288 1.222015 0.068111 0.932063)
      )

;;; 118 all -------------------------------------------------------------------------------- ; 10.8628
#(118 15.151820108516 #(0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0)
      14.496 #(0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1)
      14.207115029287 #(0 1 1 1 1 1 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0)

      10.808712 #(0.000000 -0.177819 -0.142018 0.022137 0.034297 0.762637 -0.178953 1.639668 0.351306 1.391782 0.879368 1.707912 0.470519 0.076420 1.085984 0.613181 0.281761 0.704000 1.761696 -0.450828 1.252874 0.347511 0.722157 0.261768 1.833792 1.530127 1.423795 1.317881 0.645365 1.425787 1.603868 0.067621 0.693608 0.315181 0.216801 0.554195 0.686224 0.407184 0.627132 1.952161 1.292393 1.271160 1.530177 -0.446947 1.101663 -0.428479 1.100041 0.928752 1.318823 0.357126 1.783255 1.254926 1.225710 1.249305 1.401473 0.029514 1.077242 1.094609 0.125094 1.238956 1.009997 0.638001 1.110132 0.448569 -0.285578 1.508694 1.290165 0.246393 1.536026 0.833608 0.977871 0.553922 0.156534 1.041282 1.097042 0.554554 -0.048869 0.956418 1.034988 0.136278 0.886087 0.985257 -0.029222 1.706181 1.894726 0.752941 1.637213 1.588292 1.010224 1.543264 0.764487 1.514534 -0.228471 0.121142 -0.238795 0.273421 1.257066 1.100696 1.123237 0.216699 1.333314 0.104460 0.660793 -0.112560 1.001496 0.255445 1.033152 -0.279279 1.839757 0.194809 0.644631 1.059675 0.213726 1.060990 1.902610 0.067278 0.791436 1.186690)
      )

;;; 119 all -------------------------------------------------------------------------------- ; 10.9087
#(119 15.63721370697 #(0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1)
      14.803846337507 #(0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1)
      14.502624011553 #(0 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0)

      10.895267 #(0.000000 0.630336 0.843262 1.285812 0.340587 -0.017332 0.327169 1.385171 1.082018 1.397857 0.680839 0.599495 0.760808 1.651624 1.943215 0.601150 0.438753 0.220032 0.283706 0.321000 1.848806 -0.818805 1.279239 0.233383 -0.265065 0.149488 0.866113 1.211455 -0.153192 1.086507 -0.117739 0.108345 0.296077 0.924788 0.407609 0.257469 1.108157 0.337516 1.501434 -0.160734 0.937661 1.194914 0.677862 1.064411 -0.083066 0.280209 0.164734 0.604351 1.488726 0.546557 -0.173942 0.258452 -0.144704 1.931749 1.121694 0.070973 1.246077 0.433607 -0.015989 1.447158 1.307009 0.290513 1.032586 0.483509 0.866614 0.896091 0.118763 0.703456 1.160811 -0.272718 1.618947 0.922379 0.186934 0.444686 0.391527 -0.170445 0.686201 0.072390 -0.083273 0.261424 1.315326 1.343146 -0.078550 0.581799 0.100158 0.342044 0.531455 0.823995 0.311378 0.398507 -0.067564 1.021721 0.099971 0.375472 1.694822 -0.129069 0.760774 0.760279 0.907128 1.373425 1.265414 0.699858 -0.214864 -0.228584 1.101084 1.533737 1.209100 1.477560 0.508584 0.989498 0.862450 0.271952 1.549833 0.881136 1.017209 0.041014 1.240632 1.019564 1.718786)
      10.894037 #(0.000000 0.630386 0.843125 1.285949 0.340650 -0.017357 0.327019 1.384996 1.081793 1.397782 0.680727 0.599720 0.760758 1.651799 1.943215 0.601150 0.438753 0.220032 0.283706 0.321338 1.848806 -0.818805 1.279239 0.233383 -0.265065 0.149488 0.866113 1.211455 -0.153192 1.086507 -0.117739 0.108345 0.296077 0.924788 0.407609 0.257469 1.108157 0.337516 1.501434 -0.160734 0.937661 1.194914 0.677862 1.064411 -0.083066 0.280209 0.164734 0.604351 1.488726 0.546557 -0.173942 0.258452 -0.144704 1.931749 1.121694 0.070973 1.246077 0.433607 -0.015989 1.447158 1.307009 0.290513 1.032586 0.483509 0.866614 0.896091 0.118763 0.703456 1.160811 -0.272718 1.618947 0.922379 0.186934 0.444686 0.391527 -0.170445 0.686201 0.072390 -0.083273 0.261424 1.315326 1.343146 -0.078550 0.581799 0.100158 0.342044 0.531455 0.823995 0.311378 0.398507 -0.067564 1.021721 0.099971 0.375472 1.694822 -0.129069 0.760774 0.760279 0.907128 1.373425 1.265414 0.699858 -0.214864 -0.228584 1.101084 1.533737 1.209100 1.477560 0.508584 0.989498 0.862450 0.271802 1.549833 0.881136 1.017209 0.041014 1.240632 1.019564 1.718786)
      )

;;; 120 all -------------------------------------------------------------------------------- ; 10.9545
#(120 14.761 #(0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1)
      14.534638752286 #(0 0 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0)

      10.889709 #(0.000000 1.762122 1.431359 0.659014 0.094052 0.677087 1.323906 0.556688 0.077366 1.892002 0.977425 0.232399 0.032677 1.869395 0.116194 0.807225 1.701430 0.189200 0.348433 1.322011 0.129028 0.627208 -0.294553 -0.170234 0.422988 1.483318 -0.234549 0.324472 -0.372760 1.705789 0.943822 0.923060 1.724477 1.322323 1.329904 0.319476 1.343773 0.101250 0.694275 0.027148 -0.055326 1.335636 -0.012605 1.696036 0.251234 -0.179344 1.469557 1.710633 1.252786 0.726226 1.872221 0.005483 0.027473 0.696211 1.533869 0.478993 1.105411 0.658480 1.221126 0.634405 0.379909 0.378888 0.089648 0.804475 0.434378 0.298691 0.944837 -0.112927 -0.115646 1.183608 1.268736 0.985844 0.238503 0.778353 1.628061 -0.282287 -0.187805 0.618430 0.089836 1.405167 0.488825 -0.294365 1.289533 1.728556 1.583666 1.189909 0.278782 0.234670 1.440512 0.585036 1.522072 0.607754 0.879286 1.437436 1.061920 0.936028 1.262659 0.013171 -0.130490 0.102784 1.394041 1.180347 1.830131 1.737398 0.232378 0.367367 0.653661 -0.128438 0.090327 0.078222 0.691731 1.076759 1.070896 -0.153349 1.072959 -0.217716 0.133679 -0.211311 0.460106 1.365246)
      )

;;; 121 all -------------------------------------------------------------------------------- ; 11
#(121 14.765577345045 #(0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0)
      14.619540214539 #(0 1 0 1 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)
      14.286643427331 #(0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)
      14.184466362 #(0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)

      10.943701 #(0.000000 1.015985 1.329069 0.694564 0.489160 0.312745 0.182507 1.319755 0.943123 -0.065077 1.472642 1.210590 0.458957 1.620872 1.349915 0.350044 1.538542 1.155670 0.656972 1.751402 0.882505 0.683458 0.342798 0.637126 0.243755 0.049793 1.686715 0.609864 -0.649051 1.581986 1.419821 1.294615 0.372760 1.683740 1.337961 1.100172 0.422003 0.178009 0.669590 0.746955 1.347044 0.605854 0.951197 1.721202 0.108136 1.761263 1.762641 0.677682 0.702696 0.915948 1.294465 1.672780 -0.006300 1.670365 1.422124 0.534778 1.062588 0.078497 -0.156217 1.669847 -0.269100 1.601405 0.219529 0.485715 0.666598 0.100593 0.261972 0.317134 0.369100 0.519302 1.213052 1.201859 0.772950 0.203711 0.776595 0.974304 -0.216223 0.706295 0.286759 1.832822 0.465424 1.902590 0.967300 0.017044 1.246480 1.353568 0.479424 0.835888 1.140175 1.670297 0.766264 -0.072567 0.463550 1.322723 1.044177 1.739376 0.813979 0.776485 1.028162 0.077119 0.790687 1.360709 0.706734 0.074650 0.584618 0.515517 1.210792 0.842362 0.583683 0.857561 1.813506 1.062798 0.159914 0.766330 -0.157503 0.239145 0.294828 0.310061 1.298090 0.195644 0.581835)
      )

;;; 122 all -------------------------------------------------------------------------------- ; 11.0454
#(122 14.800878258504 #(0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0)
      14.536 #(0 1 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0)

      10.965528 #(0.000000 1.705630 0.117914 0.689982 1.245106 1.258731 -0.202933 0.409081 1.203318 1.274208 0.643305 1.291284 1.784807 0.040899 1.157531 1.158507 1.691292 1.498148 1.000104 1.433405 1.723984 0.879681 0.378124 1.617294 0.125871 1.151791 1.079818 0.461805 1.105031 1.527993 1.423081 0.717122 0.759800 0.292054 1.148134 0.686741 0.064542 0.474543 1.091053 0.425479 1.086481 0.492892 0.937062 1.659147 0.464479 0.977733 0.374140 1.452000 1.600047 -0.404369 0.541753 1.731840 0.049441 1.197153 0.534241 0.739558 1.587791 -0.027628 0.028953 0.995193 0.348648 -0.036082 1.294232 0.194119 0.604889 1.008656 0.911830 1.099776 1.288430 0.928230 1.419114 1.310151 1.823172 0.253400 0.988288 0.675454 0.636118 0.445907 1.499609 0.533132 1.180395 0.520862 0.127021 1.068089 1.975283 0.740622 1.233627 1.283195 1.634171 -0.058759 1.207106 1.263150 1.055335 0.852462 1.196060 0.869787 -0.315611 0.469015 0.078969 0.416901 1.325156 1.931328 1.584617 1.253533 -0.172348 -0.892137 0.382273 0.206309 0.285454 1.673522 1.516152 0.759515 1.658814 0.756675 0.236246 -0.132933 1.687908 -0.343902 0.867611 -0.095802 1.099093 0.946115)
      )

;;; 123 all -------------------------------------------------------------------------------- ; 11.0905
#(123 15.175 #(0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1)
      15.041822824398 #(0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1)
      15.006 #(0 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)
      14.80501968131 #(0 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)
      14.67458183944 #(0 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)

      11.096930 #(0.000000 -0.090260 0.499072 0.849988 1.264649 0.050634 -0.137781 1.229112 0.772393 -0.395642 1.196316 0.021061 0.217720 0.186674 1.201236 1.846959 1.294897 1.297088 0.822254 1.903482 0.130155 0.228198 0.848495 1.342821 0.171564 -0.085167 1.368305 0.992222 0.855120 -0.351691 -0.077616 -0.217680 1.683055 1.040078 1.127439 0.304031 0.516373 1.795282 -0.100467 0.653634 1.569330 1.325182 0.674690 -0.215866 1.545185 0.619895 0.866189 0.165749 -0.038110 1.045169 0.815087 1.105333 1.736872 0.010198 1.053944 0.655178 1.858823 0.172771 0.633119 0.405291 -0.035202 1.549337 1.408424 -0.073380 1.598607 0.356822 -0.068390 0.298126 0.437461 -0.149812 -0.069300 0.230125 1.153104 0.045797 -0.179289 1.801198 1.247290 1.458418 1.255724 1.062590 -0.008892 1.160754 1.837548 -0.099427 1.039749 0.127138 1.385344 0.242466 0.809851 -0.255303 1.705120 0.553964 0.094347 0.548747 -0.021077 0.507578 1.851257 1.277493 0.277363 0.330041 0.992572 0.070511 0.950924 1.381053 1.150222 1.394072 0.621819 1.521787 0.870178 0.461615 0.791131 1.758217 0.736789 -0.163341 0.107141 0.777957 1.376746 1.064415 1.250397 1.262056 1.188744 -0.052627 -0.316492)
      11.096521 #(0.000000 -0.091562 0.498557 0.848479 1.264506 0.052326 -0.137240 1.228787 0.773949 -0.396281 1.198577 0.020717 0.215256 0.186475 1.199873 1.849810 1.299330 1.299483 0.825063 1.906491 0.129648 0.226260 0.849969 1.346870 0.173142 -0.085135 1.369404 0.995509 0.857074 -0.351844 -0.075416 -0.217132 1.684581 1.038635 1.126966 0.305758 0.512495 1.795789 -0.098669 0.655571 1.568887 1.322703 0.674452 -0.217526 1.543517 0.622329 0.867153 0.161938 -0.037281 1.044055 0.813976 1.102650 1.739493 0.012345 1.052322 0.655846 1.860089 0.171238 0.630432 0.405570 -0.037968 1.549275 1.407372 -0.072635 1.599959 0.359442 -0.068809 0.296555 0.437762 -0.149401 -0.065351 0.232484 1.152422 0.047335 -0.179811 1.800380 1.247387 1.455160 1.258882 1.060032 -0.008942 1.159562 1.836306 -0.101972 1.035966 0.126560 1.385634 0.236816 0.808168 -0.256811 1.710215 0.551705 0.093630 0.547806 -0.024726 0.508660 1.850943 1.275531 0.271139 0.331636 0.990282 0.072200 0.950688 1.380231 1.151397 1.389542 0.624043 1.527480 0.873064 0.461890 0.793614 1.761784 0.735808 -0.160953 0.104302 0.780848 1.371409 1.063428 1.249418 1.265028 1.184944 -0.051865 -0.314043)

      ;; unchecked
      11.096185 #(0.000000 -0.096064 0.503692 0.842856 1.263757 0.054163 -0.134948 1.232834 0.770731 -0.396108 1.197810 0.026771 0.213056 0.183778 1.198476 1.846499 1.297991 1.301661 0.823876 1.902592 0.132831 0.231201 0.849745 1.353343 0.173411 -0.090649 1.375474 0.988137 0.861157 -0.350827 -0.071388 -0.222707 1.693130 1.037529 1.127071 0.306398 0.514232 1.789494 -0.103105 0.653903 1.564952 1.313015 0.676058 -0.211834 1.538698 0.619897 0.864819 0.164772 -0.033916 1.038917 0.813961 1.107095 1.737170 0.013716 1.051036 0.655866 1.858671 0.169903 0.632944 0.406307 -0.041427 1.544829 1.394830 -0.073532 1.608850 0.359824 -0.071700 0.299184 0.437250 -0.145211 -0.062900 0.230334 1.150308 0.045272 -0.178166 1.801012 1.255226 1.460501 1.253236 1.055406 -0.015664 1.158739 1.835459 -0.101905 1.042919 0.128661 1.385053 0.234226 0.812946 -0.260758 1.710067 0.543191 0.096830 0.540335 -0.024940 0.508456 1.858789 1.288061 0.269932 0.339234 0.987291 0.066134 0.954286 1.380629 1.160344 1.383096 0.624976 1.534654 0.877247 0.459608 0.787120 1.761371 0.737385 -0.164433 0.106417 0.781962 1.372588 1.057323 1.257304 1.250706 1.184251 -0.045338 -0.316063)
      11.095636 #(0.000000 -0.093230 0.503492 0.843242 1.263316 0.051744 -0.140073 1.231086 0.772422 -0.396876 1.200349 0.025495 0.216024 0.183016 1.200231 1.845301 1.299939 1.300404 0.823628 1.903685 0.128321 0.227887 0.851306 1.348657 0.171101 -0.086068 1.372819 0.989710 0.858331 -0.353462 -0.074733 -0.215504 1.692841 1.037221 1.126441 0.307100 0.515637 1.792795 -0.104269 0.651134 1.564595 1.319484 0.674969 -0.217482 1.541059 0.618337 0.865395 0.164291 -0.032529 1.037480 0.812422 1.099952 1.737647 0.013615 1.050412 0.655037 1.857838 0.172831 0.633424 0.403579 -0.039540 1.548037 1.404485 -0.074490 1.606393 0.360310 -0.071061 0.299193 0.435765 -0.144176 -0.063293 0.233580 1.149212 0.048398 -0.176862 1.801391 1.250390 1.457232 1.258161 1.059505 -0.013884 1.159072 1.842074 -0.100593 1.039905 0.129853 1.387846 0.238018 0.810876 -0.260558 1.709257 0.546953 0.094261 0.546221 -0.024807 0.507151 1.855963 1.285992 0.270543 0.332069 0.984739 0.069937 0.951711 1.389421 1.151387 1.388989 0.621944 1.525818 0.878027 0.461085 0.789232 1.763163 0.738884 -0.162713 0.107666 0.781368 1.374474 1.060455 1.256681 1.260198 1.184492 -0.048166 -0.320377)
      11.095246 #(0.000000 -0.093635 0.502846 0.843919 1.263902 0.051602 -0.140248 1.231261 0.772454 -0.396941 1.200323 0.025461 0.215814 0.183110 1.200010 1.845688 1.300002 1.300619 0.823564 1.903573 0.128357 0.227861 0.851138 1.348946 0.171040 -0.086281 1.372824 0.989453 0.858340 -0.353875 -0.074545 -0.216001 1.692391 1.037049 1.126181 0.306886 0.515331 1.792709 -0.104588 0.651227 1.564738 1.319124 0.674721 -0.217336 1.541059 0.618092 0.865605 0.164479 -0.032657 1.036889 0.812412 1.099620 1.737290 0.013272 1.050483 0.655320 1.857856 0.172499 0.633627 0.403914 -0.039470 1.547647 1.404275 -0.074194 1.606752 0.360272 -0.070849 0.299275 0.435901 -0.144107 -0.063295 0.233784 1.149458 0.048430 -0.176700 1.801184 1.250131 1.457091 1.258062 1.059113 -0.013926 1.159364 1.841932 -0.100324 1.039972 0.129732 1.387575 0.238066 0.811057 -0.260544 1.709275 0.546488 0.094476 0.546346 -0.025013 0.507038 1.855641 1.286184 0.270588 0.332027 0.984898 0.069615 0.951625 1.389061 1.152223 1.388899 0.622002 1.525439 0.877326 0.461548 0.789275 1.762843 0.738677 -0.162443 0.107221 0.781527 1.374217 1.060450 1.256245 1.260172 1.184169 -0.048057 -0.320106)
      11.095234 #(0.000000 -0.095417 0.503299 0.842849 1.263509 0.054849 -0.135252 1.233197 0.770330 -0.395582 1.197806 0.027528 0.212093 0.183139 1.198607 1.846942 1.298555 1.301349 0.825151 1.901655 0.131658 0.231027 0.849596 1.353958 0.173189 -0.091160 1.376294 0.988048 0.861511 -0.350535 -0.071733 -0.221949 1.693715 1.037026 1.127519 0.307368 0.513321 1.789219 -0.103568 0.654480 1.565813 1.312656 0.674922 -0.212615 1.539316 0.619569 0.864048 0.163935 -0.033343 1.038585 0.813708 1.107168 1.737612 0.013811 1.050903 0.656653 1.857739 0.169311 0.632994 0.406184 -0.040550 1.544475 1.394529 -0.073590 1.609521 0.359997 -0.070753 0.298993 0.437391 -0.145127 -0.063630 0.230321 1.151222 0.047578 -0.178426 1.800798 1.255344 1.459929 1.253894 1.056346 -0.014571 1.158774 1.835891 -0.102498 1.042074 0.128680 1.384965 0.233071 0.812681 -0.261514 1.710542 0.542999 0.096868 0.541081 -0.025205 0.508319 1.858981 1.287978 0.270165 0.339267 0.987230 0.066990 0.954420 1.381217 1.159410 1.382916 0.625426 1.535045 0.877406 0.459306 0.787630 1.763393 0.737999 -0.164618 0.105862 0.781501 1.372109 1.057422 1.256334 1.251664 1.183221 -0.045369 -0.315672)
      11.094749 #(0.000000 -0.096024 0.503544 0.843073 1.263454 0.054390 -0.135224 1.233184 0.771288 -0.395745 1.198106 0.026744 0.212511 0.183216 1.198793 1.847173 1.298800 1.300729 0.825200 1.901774 0.131640 0.231561 0.849372 1.353164 0.173131 -0.091103 1.376431 0.988048 0.861092 -0.350795 -0.071915 -0.222300 1.694469 1.036820 1.127324 0.307782 0.513288 1.789418 -0.103492 0.654595 1.566083 1.312932 0.674361 -0.212198 1.539309 0.619620 0.864728 0.163773 -0.033150 1.038826 0.813560 1.106865 1.737125 0.013444 1.051001 0.656345 1.857901 0.169598 0.632547 0.406321 -0.041288 1.544665 1.394996 -0.072963 1.609546 0.360420 -0.071682 0.299422 0.437195 -0.145287 -0.063862 0.230738 1.151891 0.046929 -0.178450 1.801102 1.255392 1.459732 1.254218 1.056127 -0.014871 1.158709 1.835893 -0.102334 1.042144 0.128596 1.384751 0.233089 0.812454 -0.261710 1.710398 0.543161 0.096141 0.540998 -0.025298 0.508284 1.859405 1.287614 0.269341 0.340053 0.987247 0.067575 0.954375 1.381252 1.159001 1.383487 0.625526 1.534723 0.877498 0.459766 0.787393 1.763468 0.737632 -0.164457 0.105643 0.781625 1.372030 1.057015 1.256218 1.251495 1.183065 -0.045624 -0.315593)

      ;; checked
      11.096129 #(0.000000 -0.095907 0.503402 0.842929 1.263256 0.054321 -0.135128 1.233310 0.770790 -0.396428 1.198505 0.026622 0.212425 0.183639 1.198325 1.847661 1.298792 1.300718 0.825357 1.901278 0.131758 0.231726 0.849023 1.353385 0.172888 -0.091036 1.376377 0.988112 0.861004 -0.351026 -0.071703 -0.222062 1.694123 1.036899 1.127144 0.307744 0.512661 1.788853 -0.103345 0.654976 1.565602 1.313124 0.674310 -0.212754 1.539443 0.619735 0.864291 0.164020 -0.032659 1.039142 0.813321 1.107046 1.737454 0.013762 1.050672 0.656132 1.857667 0.169121 0.632810 0.405947 -0.040898 1.544766 1.394906 -0.073341 1.610018 0.360528 -0.071586 0.299670 0.436934 -0.144922 -0.064155 0.230725 1.151854 0.047156 -0.178300 1.800995 1.255566 1.459772 1.254005 1.056341 -0.014499 1.158200 1.835455 -0.102503 1.042121 0.128558 1.384908 0.232862 0.812409 -0.262096 1.710301 0.543143 0.096075 0.541137 -0.025261 0.508344 1.859541 1.287916 0.269241 0.339535 0.986920 0.067975 0.954874 1.381381 1.159007 1.383454 0.625414 1.534887 0.878300 0.459633 0.787712 1.763462 0.737710 -0.164223 0.105751 0.781571 1.371843 1.057424 1.256214 1.251912 1.182715 -0.045846 -0.315499)


      )

;;; 124 all -------------------------------------------------------------------------------- ; 11.1355
#(124 15.808239936829 #(0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 0 1)
      15.141 #(0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 0 1)
      14.607 #(0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1)

      11.083412 #(0.000000 0.148698 1.689390 0.682772 0.998598 0.908039 0.515181 0.230893 1.635158 0.160629 0.129339 -0.006549 -0.050208 0.893903 0.979099 0.034909 0.431361 0.970160 1.303242 0.931925 0.234212 1.332860 0.055008 -0.001526 1.066906 0.428847 1.393475 0.540890 1.473950 -0.652353 1.633827 0.614193 0.455969 0.357663 0.200001 1.438197 -0.285006 1.020844 1.383394 1.363115 0.383727 0.746900 0.299739 0.249963 0.728499 0.902111 0.494064 0.381146 1.441724 0.487321 1.486329 1.307101 0.999733 -0.128844 0.920497 1.798086 0.160448 0.309260 0.424465 0.672565 1.773539 0.972376 -0.022752 1.345744 0.141398 0.034025 -0.111784 1.519742 0.138980 1.860943 0.908800 1.301188 0.022096 0.765756 1.194182 0.678976 1.202776 0.348280 0.591679 -0.402923 1.458685 1.663396 1.374458 0.541724 1.127985 1.865357 -0.462809 -0.449928 0.669131 1.830792 1.547266 0.604960 1.103736 0.217777 0.461574 0.193958 1.089519 0.495740 1.273132 1.686188 0.191894 0.666938 0.547007 1.360373 -0.319587 0.237160 0.188850 1.736208 0.765216 0.277262 -0.401083 1.006056 0.639014 0.541059 0.770658 1.281481 0.739937 0.760893 0.885101 1.335393 0.628830 1.100107 0.598660 0.496892)
      )

;;; 125 all -------------------------------------------------------------------------------- ; 11.1803
#(125 15.546414800183 #(0 0 0 0 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0)
      14.985 #(0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0)

      11.165791 #(0.000000 1.016746 1.207524 1.411288 0.620469 0.042383 0.787818 0.544291 0.371661 0.928465 1.153922 0.165268 1.425913 0.897570 1.656498 0.989949 1.803062 1.466841 1.745789 0.607799 -0.598958 0.729211 -0.140491 0.986055 0.073611 1.875744 0.337281 1.603548 0.142780 0.019146 0.447717 0.117704 0.041718 0.523559 0.072700 1.051384 -0.308133 1.513412 1.102427 1.600423 -0.120421 0.638709 0.000390 1.593976 1.740028 0.421622 0.591954 1.179087 0.814030 1.200225 1.341708 1.284004 1.570169 1.244106 0.606142 0.928587 0.080893 0.615860 1.102158 0.431033 -0.459028 0.122248 0.263753 0.028959 1.138297 0.787273 1.006723 0.514461 1.116476 1.288547 1.242659 0.913547 0.450099 1.255516 0.873032 0.017770 1.423917 1.222078 1.299188 0.651324 0.954674 0.758846 -0.212067 0.223026 -0.422625 1.125167 0.506822 1.406581 0.083196 0.829761 1.264655 1.845873 0.401929 0.474216 -0.530955 1.213074 1.004599 1.690843 0.432486 1.055865 1.072281 1.090061 0.148428 -0.002495 0.319066 1.611442 -0.179819 1.005749 1.819538 0.765514 1.139846 0.353477 -0.090942 1.449895 0.822036 0.113801 0.247668 0.936340 1.320560 0.849437 1.482108 0.045522 1.493389 0.854590 0.869209)
      )

;;; 126 all -------------------------------------------------------------------------------- ; 11.224972
#(126 15.477880483871 #(0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1)
      14.898634217167 #(0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1)
      14.722991453869 #(0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)
      14.67419786533 #(0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)

      11.160504 #(0.000000 0.899150 0.373103 1.290186 0.770161 0.861481 1.615708 1.739475 1.949492 0.838075 -0.088577 1.704018 0.328926 0.830449 -0.115161 0.080915 0.999752 0.928744 1.332157 0.403847 1.471513 0.864378 0.735001 0.284791 0.613680 0.940899 0.872291 0.128929 0.099719 0.034648 0.338219 1.697316 1.194129 1.203451 1.020206 0.867165 0.775308 0.513983 1.283446 0.986083 0.200087 0.684276 0.585424 1.226896 0.836066 0.878343 1.321457 1.208361 -0.038257 1.274790 0.559466 0.325425 0.896288 0.126089 0.359224 1.406546 1.385966 1.053062 1.087294 0.695752 1.263922 1.111926 1.321342 0.551498 1.767554 1.417591 1.188434 1.411251 0.265015 0.468756 0.363583 0.620130 1.834985 -0.007296 0.888597 0.178698 -0.165650 0.467294 0.844270 0.102742 0.482063 0.763318 0.174405 0.507441 1.310699 1.830520 0.518055 0.138627 1.278412 1.028136 -0.050190 1.655839 1.724565 0.165047 0.997195 1.525919 0.933108 1.606752 1.537468 -0.674852 0.141889 0.125798 0.517556 -0.139822 1.029065 1.049830 0.842562 0.159453 1.019063 0.218465 1.386367 0.228877 1.296038 0.067074 0.604187 1.227348 0.024037 1.814586 0.803108 0.778910 1.110459 0.656030 -0.104557 0.141569 1.272455 0.718369)
      )

;;; 127 all -------------------------------------------------------------------------------- ; 11.269427
#(127 15.59486896452 #(0 1 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0)
      14.859080656941 #(0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0)
      14.851 #(0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0)

      11.193888 #(0.000000 1.072292 1.248602 0.284046 1.249888 0.287873 1.765984 0.241927 1.155606 1.311559 0.080621 1.854314 1.715531 1.371725 1.050660 -0.393638 0.001231 1.373630 0.296058 1.620429 1.165084 1.749174 1.231342 0.378363 0.351506 0.124138 0.307320 -0.164515 0.016568 1.228296 0.227565 0.372379 0.198081 1.134216 0.213611 1.632900 0.742342 -0.281193 0.636779 0.997018 0.073426 0.741323 1.835331 1.423566 0.645639 0.716708 0.225362 1.630849 0.898776 1.166508 1.173566 0.278127 0.796836 1.897454 0.957076 1.872912 0.211939 0.457420 0.464326 1.418611 1.260545 1.174430 0.215954 0.216434 1.936763 0.847607 1.693848 -0.189590 -0.281802 0.913593 0.425446 1.349761 0.172960 0.585590 0.496464 0.439713 0.014868 -0.061313 0.872103 -0.116794 0.146959 1.759667 1.718207 -0.046544 0.126524 0.276913 0.179072 1.080831 1.088793 1.213211 1.172458 1.385400 -0.187645 0.236959 0.872010 1.584899 1.752608 1.499984 1.245228 0.251763 -0.023115 1.419056 0.771842 0.063059 1.321616 0.615005 1.669484 0.351115 0.558340 1.121216 1.679878 0.494528 1.035011 1.344312 1.286148 1.665396 0.582478 0.498556 -0.037641 0.054260 0.133481 1.508961 0.315780 1.291655 1.417240 0.250982 1.518649)
      )

;;; 128 all -------------------------------------------------------------------------------- ; 11.313708498985
#(128 15.689241428851 #(0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1)
      15.287684641887 #(0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1)
      15.249417304993 #(0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1)
      15.138 #(0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1)

      11.314847 #(0.000000 1.242883 0.069906 1.687469 1.126673 1.390666 0.849739 1.017135 0.286150 0.448775 0.159149 0.411001 1.557482 1.031548 0.738481 1.416590 1.168928 0.227783 0.139186 0.207391 -0.223498 -0.481663 0.872379 0.457941 0.070554 1.466346 -0.049916 -0.139560 1.058020 1.534159 0.336716 1.201437 1.374860 -0.035246 0.604389 1.848917 -0.101872 0.813159 0.108189 0.799833 0.027307 0.761493 1.110479 0.854065 0.653394 0.717243 0.489771 1.185045 -0.091460 0.283031 -0.432296 1.209753 1.320016 0.444410 1.300119 1.359913 0.000481 0.450769 -0.089862 0.282204 0.131195 -0.104460 0.647301 0.588019 1.264881 1.186155 1.378500 1.177611 1.173765 0.356906 1.575397 0.074144 1.310347 1.094808 0.641689 0.579241 1.273935 1.294408 0.296906 1.282585 1.353599 0.879494 0.049991 0.137932 0.950024 1.138913 0.625440 -0.397750 0.331718 0.078214 0.803696 0.674243 1.386839 0.952813 1.440329 0.328691 0.703425 0.559345 1.044956 0.665071 0.326126 0.388125 0.414211 0.266182 1.113044 0.656131 0.204662 1.020897 -0.208701 0.974749 0.122838 1.341808 1.014446 1.058655 1.549618 0.685664 1.750614 0.776021 1.038237 0.182051 0.350955 0.880701 1.134744 1.612839 -0.037555 1.369539 0.188212 1.176216)
      11.314564 #(0.000000 1.242683 0.070056 1.687394 1.126773 1.390541 0.849539 1.017210 0.286125 0.448850 0.159074 0.410876 1.557582 1.031392 0.738525 1.416484 1.168903 0.227702 0.139286 0.207491 -0.223554 -0.481719 0.872454 0.457866 0.070554 1.466346 -0.049916 -0.139560 1.058020 1.534159 0.336716 1.201437 1.374860 -0.035246 0.604389 1.848917 -0.101872 0.813159 0.108189 0.799833 0.027307 0.761493 1.110479 0.854065 0.653394 0.717243 0.489771 1.185045 -0.091460 0.283031 -0.432296 1.209753 1.320016 0.444410 1.300119 1.359913 0.000481 0.450769 -0.089862 0.282204 0.131195 -0.104460 0.647301 0.588019 1.264881 1.186155 1.378500 1.177611 1.173765 0.356906 1.575397 0.074144 1.310347 1.094808 0.641689 0.579241 1.273935 1.294408 0.296906 1.282585 1.353599 0.879494 0.049991 0.137932 0.950024 1.138913 0.625440 -0.397750 0.331718 0.078214 0.803696 0.674243 1.386839 0.952813 1.440329 0.328691 0.703425 0.559345 1.044956 0.665071 0.326126 0.388125 0.414211 0.266182 1.113044 0.656131 0.204662 1.020897 -0.208701 0.974749 0.122838 1.341808 1.014446 1.058655 1.549618 0.685664 1.750614 0.776021 1.038237 0.182051 0.350955 0.880701 1.134744 1.612839 -0.037555 1.369539 0.188212 1.176216)
      11.314404 #(0.000000 1.242683 0.070014 1.687333 1.126639 1.390558 0.849683 1.017197 0.286191 0.448830 0.159063 0.410930 1.557475 1.031418 0.738539 1.416515 1.168928 0.227851 0.139272 0.207414 -0.223498 -0.481738 0.872372 0.457841 0.070554 1.466346 -0.049916 -0.139560 1.058020 1.534159 0.336716 1.201437 1.374860 -0.035246 0.604389 1.848917 -0.101872 0.813159 0.108189 0.799833 0.027307 0.761493 1.110479 0.854065 0.653394 0.717243 0.489771 1.185045 -0.091460 0.283031 -0.432296 1.209753 1.320016 0.444410 1.300119 1.359913 0.000481 0.450769 -0.089862 0.282204 0.131195 -0.104460 0.647301 0.588019 1.264881 1.186155 1.378500 1.177611 1.173765 0.356906 1.575397 0.074144 1.310347 1.094808 0.641689 0.579241 1.273935 1.294408 0.296906 1.282585 1.353599 0.879494 0.049991 0.137932 0.950024 1.138913 0.625440 -0.397750 0.331718 0.078214 0.803696 0.674243 1.386839 0.952813 1.440329 0.328691 0.703425 0.559345 1.044956 0.665071 0.326126 0.388125 0.414211 0.266182 1.113044 0.656131 0.204662 1.020897 -0.208701 0.974749 0.122838 1.341808 1.014446 1.058655 1.549618 0.685664 1.750614 0.776021 1.038237 0.182051 0.350955 0.880701 1.134744 1.612839 -0.037555 1.369539 0.188212 1.176216)
      )

;;; 256 all --------------------------------------------------------------------------------
#(256 23.353 #(0 0 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1)

      19.419887 #(0.000000 1.716123 1.732087 -1.159217 -1.111520 -0.968808 -1.435400 -0.980823 -1.916807 -0.777076 -0.006575 -1.146768 -1.413466 -0.191988 -0.866295 -1.754753 -1.834771 -1.414461 -0.004612 -0.668272 -0.899105 -1.045292 -1.394965 0.031304 -1.790029 -0.414595 -0.628926 -0.793341 -0.055059 -1.758819 -1.799745 -0.999573 0.034849 -0.438143 -0.082246 -1.718822 -1.067223 -1.726228 -1.738785 -0.419090 -0.072253 -0.101418 -0.158940 -0.227475 -0.805306 0.102396 -1.029779 -0.944501 -1.627544 -0.240643 -0.800061 -1.852822 -0.736694 -0.374906 -0.992797 -1.321129 -1.165724 -0.132383 -0.296684 0.074652 -0.170663 -1.021946 -0.249235 -0.014896 -1.684156 -0.101483 -1.472567 -1.065248 -0.193000 -1.821851 -1.577478 -0.971415 -1.706313 -0.460547 -0.802154 -1.066096 -0.465880 -1.780964 -0.317180 -1.128696 -1.243327 -1.545720 -0.981842 -1.941220 -1.430454 -0.739300 -0.401708 -0.807818 -0.139664 -1.670340 -0.370514 -0.908540 -1.051026 -0.655448 -0.201175 -1.447197 -1.020563 -0.461820 -0.563775 -0.492581 -1.123348 -0.019694 -0.284015 -0.493247 -1.800533 -0.026879 -1.684265 -0.072889 -1.236206 -1.605481 -0.854278 -0.780460 -1.556451 -0.100281 -1.481863 -1.785235 -0.054386 -1.322733 -1.272196 -0.484418 -0.487202 -0.934744 -0.351935 0.001840 -1.361830 -1.761915 -0.791484 -1.765946 -0.130275 -0.078233 -1.712033 -1.491273 -1.447810 -1.802668 -1.915196 -0.812291 0.020535 -0.059922 -0.115027 -1.741334 -1.716313 -0.574287 -1.796141 -1.411787 -0.352083 -0.219272 -0.492707 -1.281724 -0.237492 -0.661764 -0.251830 -1.447982 -0.928988 -0.834556 -1.105051 -1.600594 -0.610828 -0.521753 -1.538844 -1.739439 -0.438630 0.200255 -1.495825 -0.208613 -1.899242 -0.565203 -0.701498 -0.013982 -0.268393 -0.851043 -1.316608 -1.311782 -1.571398 -0.868046 -0.450718 -1.523921 -1.175122 -1.013090 -0.336313 -0.297343 -0.710311 -0.121169 -0.855768 -0.583293 -1.278840 -1.685639 -0.237176 -1.113655 -0.038017 -0.925030 -0.002618 -1.084014 -0.914850 -1.109784 -1.951680 -0.258074 -1.242904 -1.747165 -1.546773 -0.010135 -0.293716 -0.365165 -0.380179 -1.009365 -0.199175 -0.107143 -0.355342 0.056494 -1.740548 -0.797850 -1.195468 -1.012191 -0.519448 -1.741712 -1.728278 -1.202843 -0.439103 0.018019 -0.505945 -0.712019 -0.888461 -0.466715 -1.884487 -1.110926 -1.377129 -1.412918 -0.283507 -1.736733 -0.423668 -1.180448 -0.750304 -0.826461 -0.252142 -0.607448 -0.795197 -1.729275 -1.937314 -1.775060 0.018302 -1.136763 0.041039 -1.517119 -0.102466 -0.808497 -0.452532 -1.777418 -1.448279 -0.170123 -0.689274 -1.668514 -0.718568 -1.461386 -0.741628 -0.144206 -0.275574 0.275344)
      )

;;; 512 all --------------------------------------------------------------------------------
#(512 34.212551772691 #(0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1)

      31.391244 #(0.000000 0.536490 0.982156 1.426326 -0.129626 1.732808 0.654778 -0.037467 0.717993 0.534761 1.425863 1.198865 1.682980 1.546213 -0.071047 1.401448 0.937782 0.982596 0.016895 0.072103 0.569596 0.486124 -0.097286 1.158349 0.918371 1.039216 -0.251432 0.819547 0.575793 0.544080 0.369375 -0.184848 0.368901 0.803569 1.569591 0.698176 0.192969 0.724313 0.149571 1.805778 1.481586 1.290110 0.699094 1.248324 0.394364 0.244421 1.636448 0.053830 1.021639 0.391890 0.621807 0.669918 0.722984 1.661047 -0.053982 1.184501 1.452118 -0.038748 0.079581 -0.157031 0.040992 1.236847 1.450072 0.167693 1.624681 -0.088284 1.086971 0.793397 0.916304 0.324493 0.532068 0.802293 0.153202 1.762480 0.101252 1.207328 -0.129231 0.230528 1.030310 1.154258 1.508591 0.616033 0.882311 1.661175 1.953694 1.099650 0.966354 0.501383 1.007682 0.222557 1.610959 1.720178 1.247885 0.606186 0.834708 1.558361 -0.017869 1.310156 1.008083 0.659261 0.131563 1.937703 0.412195 0.236592 1.603060 1.101767 0.827617 0.591143 0.816380 1.263921 0.148742 0.104597 0.053092 1.950756 0.641813 0.585000 1.924936 1.150271 1.393796 1.729921 0.941614 1.154412 0.016709 0.693894 0.725621 1.812021 0.151548 0.913871 1.847999 1.447775 0.154900 1.383798 1.268622 1.684293 0.167755 0.064703 1.097955 1.093726 0.462700 1.179880 -0.028079 1.477485 1.219357 0.751030 -0.060337 1.210332 0.214512 -0.561537 0.631221 0.866225 0.505200 1.649399 0.763462 -0.177460 -0.124321 0.301932 1.215601 1.531126 1.037628 1.084693 0.882199 1.071766 -0.102511 1.933157 0.994409 1.327775 0.857160 0.274823 0.564669 -0.099448 1.183881 1.389926 0.212160 0.718775 0.317581 0.924967 0.405513 1.649930 1.527277 0.183790 1.201712 0.469506 -0.155659 0.854295 0.612216 0.966494 0.705453 0.102052 0.675180 1.609733 0.239829 1.243022 1.279694 0.667433 0.574003 0.556613 0.553333 0.600770 0.751871 0.860635 1.492204 1.208264 1.697379 1.870484 0.648885 0.791931 0.713354 1.230332 0.984751 0.006536 1.150837 1.690631 -0.027051 0.380760 1.276448 0.938348 0.619960 1.881157 0.864399 0.721671 0.604021 0.280855 1.903049 1.689084 0.993376 0.147486 0.728308 1.043826 -0.093977 0.201345 0.211713 0.591694 1.563665 0.629162 0.028541 1.220537 0.848678 1.673148 1.269501 1.423564 1.256969 0.563220 1.571156 1.255956 0.182322 0.799277 0.912648 0.801445 0.560308 0.589828 0.497125 0.933069 0.424475 0.705311 1.598444 -0.187983 0.441238 0.761108 -0.025473 1.486361 1.415485 -0.420955 -0.301161 0.451074 1.599095 0.958690 0.764750 1.826910 0.763259 1.565082 0.482133 0.634148 0.689109 0.870842 0.258187 1.307766 -0.061122 1.322321 0.737932 1.331468 0.501857 1.012652 0.853045 1.281963 0.626236 1.018208 0.355320 1.778787 -0.216416 0.289103 1.466104 0.834557 1.495024 1.347843 0.915718 0.019062 0.109237 0.935987 0.642501 1.116001 0.102778 1.044616 0.401839 0.000557 1.388259 1.103344 0.236147 1.095986 1.490085 0.811184 1.620642 0.447193 -0.162667 0.472053 0.254521 -0.249527 1.201426 0.405149 1.876543 0.266187 0.130139 1.907565 0.661173 1.806986 1.714549 -0.045649 0.161300 1.867579 0.410807 0.692661 0.164446 1.373170 0.784111 1.624643 1.842397 0.851982 0.372586 -0.153180 0.163399 0.937623 1.029810 0.577761 1.885373 0.257007 1.919724 0.221390 0.992752 0.799199 0.726916 0.499383 0.847904 1.435092 1.516436 1.415791 0.718336 0.775042 0.214479 0.693437 1.416323 0.376686 -0.088726 1.305444 0.236013 1.760923 0.882461 0.966026 -0.039945 1.586889 0.146351 1.058484 -0.153465 0.874027 1.562558 0.221053 0.700956 0.490493 0.224584 0.721736 0.907632 1.824769 1.463914 1.787340 0.284520 0.447051 0.015084 0.421417 0.946031 1.985021 0.625260 1.706503 0.181495 0.118414 1.205197 1.823047 1.191165 1.046795 1.286118 -0.026177 0.916951 1.695990 1.490318 1.309732 1.464060 1.688925 0.463066 0.812221 1.691121 0.060699 1.771571 0.651609 0.701067 0.994197 1.863648 1.878055 0.461586 1.225301 1.689333 0.585832 0.163978 -0.087727 0.814512 1.996254 0.412873 -0.094955 0.264337 0.270751 1.142549 -0.024966 0.070370 0.161447 0.009507 0.773710 1.826772 0.919015 0.469842 1.605350 0.130163 0.372875 0.706787 0.275237 -0.485192 0.934255 0.076963 1.578025 1.319281 -0.268275 1.006626 1.518212 0.244270 0.393465 0.362653 0.762951 0.101773 0.641925 -0.044830 -0.086144 0.912315 0.865131 0.751696 0.355646 1.669420 0.959146 1.402229 0.790946 1.375834 1.946560 0.829893 1.038967 0.415598 0.605293 0.953370 1.545858 0.816660 0.535574 0.545621 1.444071 1.427861 0.317581 1.324961 0.709073 0.233889 1.997939 0.837353 0.714659 0.502688 1.282277 0.578831 -0.367027 0.456635 0.005356 0.566115 1.015260 0.456787 1.559690 0.821948 0.873735 -0.125757 1.347975 1.234391 0.394165 1.313322 1.674955 1.957471 0.199796 -0.216128 1.145281 0.020796 -0.033417 1.546313 0.684777 0.721518 1.014713)
      )

;;; 1024 all --------------------------------------------------------------------------------
#(1024 54.490282136658 #(0 0 0 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0)

       49.867216 #(0.000000 0.327463 1.836047 0.835169 1.252076 1.674070 0.220548 1.042475 1.509095 1.579464 0.895304 1.247426 1.151972 1.490500 0.157542 1.123668 0.047756 0.787232 0.294584 1.733356 0.107736 1.156565 0.757337 0.396950 1.528176 1.246645 0.358019 1.104207 0.205112 -0.175155 1.961979 0.116865 1.705056 1.224069 1.280180 1.615850 -0.006555 1.362186 1.094292 -0.132951 0.689557 -0.034245 1.478824 0.731044 0.924965 0.400017 0.459628 0.386074 -0.101383 1.148365 0.704241 0.744738 -0.052844 0.067315 0.369521 0.758466 1.902583 1.899586 1.598319 1.737623 1.540374 1.696560 1.697499 0.487205 1.085963 1.880631 1.477181 1.668863 0.024424 1.517648 0.365516 0.200991 1.320714 0.186157 0.388617 1.467282 1.382441 0.897334 0.626981 0.319121 1.447908 0.616025 1.804381 1.745575 1.813291 0.789135 0.051659 1.904341 0.503423 1.476255 0.310011 0.604315 1.774089 1.349431 0.552058 0.129885 0.768054 -0.042991 0.438904 1.716492 1.079908 0.082240 1.637563 1.782814 1.167399 1.555367 1.493576 1.678716 -0.108181 1.820002 0.874064 1.607670 0.305117 1.407464 1.406799 0.699493 1.582569 1.388350 0.152096 1.215999 0.220403 0.345901 0.015759 0.103791 1.475118 1.377921 1.679643 0.718421 0.305952 1.129388 0.650190 1.214505 0.313791 1.900895 -0.280859 0.827104 0.966094 0.952334 0.465933 0.582045 1.202693 0.486327 0.130731 1.189722 1.845737 0.943304 1.846468 0.736959 0.494820 0.406920 0.444435 1.414861 1.519794 0.691958 1.296671 0.239996 1.370349 1.087196 0.317189 1.730290 0.211314 0.381111 1.011776 0.833783 0.304407 0.204684 0.592149 1.184369 1.190663 0.322231 1.702889 0.256307 1.071017 0.840867 -0.242520 0.479950 0.584840 -0.105808 1.448894 0.833770 1.887925 0.447183 0.314914 0.590005 0.817397 1.520556 1.737874 0.323699 0.068906 0.069837 1.455903 1.768167 1.147201 1.651376 0.903538 0.404965 0.830838 1.574402 1.302241 0.460573 0.902816 1.351294 1.845320 -0.081248 0.117244 1.311180 1.295830 0.026240 1.722593 0.293615 0.016937 -0.020631 1.563094 0.366968 0.499012 0.343554 0.941646 1.842772 0.263412 0.928044 0.666097 0.965699 0.095392 0.386295 0.685342 1.098466 0.314857 0.096187 1.378947 1.725601 1.638174 1.066852 0.324141 0.309496 0.903826 1.884009 0.246373 1.446212 0.826576 0.056908 0.590948 1.115228 0.881198 1.458300 0.734711 1.242163 1.780534 0.853455 1.667872 0.196825 1.537188 1.607676 1.937251 1.074072 1.633616 0.370489 0.008710 0.036175 1.429420 1.071794 1.840602 1.451692 1.243956 1.431107 0.691835 0.914980 1.199410 0.181293 1.253487 1.088758 1.075474 0.108051 -0.045571 0.503001 0.028741 1.519924 0.162181 0.231314 1.014758 0.853208 1.665684 1.803304 1.068408 1.146822 1.117985 0.847058 0.807390 1.300311 0.358831 -0.176058 1.632353 0.793462 1.223895 1.408096 0.574718 1.116086 1.528188 1.863540 0.148438 1.178815 1.094527 1.806614 -0.012374 0.398182 0.065034 0.201600 1.678653 1.635712 1.101239 1.677879 1.376663 0.893127 0.765563 1.312772 0.394500 0.623281 1.386574 1.609733 1.397744 0.447440 0.193906 0.667070 1.098978 1.496626 1.415310 0.148141 0.472594 0.260368 0.383833 1.628233 0.220327 0.047597 1.174267 1.122635 0.357754 1.987414 0.602071 0.303888 1.036218 0.431162 1.929514 1.164116 1.448233 0.387663 1.542441 0.132675 1.507592 0.773415 1.237768 1.176487 0.709116 1.107050 1.826342 1.282624 0.165318 1.688758 1.353368 1.369182 0.103481 0.492312 0.148528 0.820568 0.043996 1.646622 0.840124 0.753421 0.628590 0.827439 0.938395 1.158874 1.692810 0.816126 1.584484 0.133035 0.633441 1.856698 0.223451 1.094007 1.265750 1.192640 0.395952 1.640962 1.917364 1.688116 1.442386 0.211922 0.568924 0.069021 0.337714 0.057686 1.444757 0.805875 1.387495 1.241537 1.258564 -0.138313 0.232318 1.082810 0.919288 0.672564 0.858948 1.226057 0.513353 0.916746 0.480683 0.371996 1.820855 1.467856 -0.009218 -0.283047 -0.004140 0.307827 1.551706 1.336385 0.311540 -0.227376 1.460075 1.374821 1.644972 0.942584 -0.008731 1.230541 -0.050886 0.756145 1.492824 0.234443 1.038831 0.415396 0.259582 0.094433 1.743809 1.773181 1.193767 1.144637 1.107278 1.073467 0.192765 1.121611 1.358143 0.256730 -0.001826 0.319586 0.785692 0.371007 0.790865 0.733080 1.010016 0.365066 -0.098482 0.630804 0.165791 1.416869 0.881841 1.014309 0.992919 0.234901 1.418323 1.609100 1.112565 1.226695 1.306198 -0.096032 1.659930 1.253925 1.468504 1.649207 0.667054 0.642219 0.816619 1.780578 1.068621 1.659145 0.823854 0.791623 0.343295 1.504822 1.385473 1.019994 1.644651 0.766151 1.645632 0.537825 0.398247 1.293204 0.059160 0.178873 1.447287 0.527125 0.387974 0.131115 0.312785 1.604447 1.506949 1.620066 1.861402 0.145250 0.285949 -0.076877 1.710147 1.391166 0.304424 1.033493 1.242586 0.544670 1.096730 0.523155 -0.189246 1.481005 1.033398 0.768935 0.023972 1.612024 1.483055 0.518798 0.299824 0.004960 0.939759 0.174131 0.190042 1.122756 0.636602 1.584671 0.313933 1.551720 0.904685 -0.060326 0.005540 -0.025426 1.183830 1.574816 0.451159 0.567990 0.636937 1.946081 0.103934 1.024172 0.668272 0.598832 0.942076 0.803712 0.025316 0.279283 0.860683 1.108376 0.495592 -0.216459 0.511102 0.839492 0.325629 0.423941 0.964281 1.869174 1.376322 0.695771 0.307933 0.728584 0.258248 1.021908 0.522105 1.443610 0.699209 1.445438 0.129220 0.656902 0.367233 1.583887 1.284330 0.304291 1.225496 0.476577 -0.012778 1.769867 1.304421 1.416331 1.394685 1.657958 0.575537 1.154454 1.482178 0.502570 1.130768 0.623558 1.451860 1.828731 1.028878 -0.009475 0.876872 0.279098 0.766784 1.311330 0.735794 0.541035 1.842543 0.936643 1.574537 1.396428 1.299258 0.148915 0.106232 1.382409 0.363703 1.437792 0.458828 0.697511 0.377860 0.415873 0.707742 0.076333 0.899058 1.164566 0.519739 1.494067 0.722474 0.267706 0.170213 0.062507 1.608638 1.572808 0.586666 0.770343 0.501734 1.095273 0.909347 1.158611 1.763224 0.928306 1.155477 -0.094050 1.234292 1.636569 0.857401 1.601954 1.562867 0.898006 0.745695 1.244420 1.045502 0.037133 1.054100 0.435628 -0.045614 1.310834 1.323179 1.515436 0.396760 1.549668 0.626053 0.262609 1.128936 -0.206617 0.519603 -0.070276 0.368711 0.384606 -0.046953 0.004776 1.132741 0.208440 1.125384 0.279383 0.206414 1.581812 0.366788 1.631341 0.047828 0.984452 0.695910 0.001831 0.818618 -0.063551 1.509031 1.770858 1.145267 0.218736 0.163266 0.304181 0.524463 -0.107417 0.636073 0.319627 0.873046 1.806848 0.905657 1.431126 1.307693 0.411432 1.050612 0.383394 0.297520 1.470377 1.512342 1.119568 -0.164563 1.409877 1.369612 0.893616 0.187194 1.160112 -0.426584 1.472282 1.524100 0.642913 0.291994 1.439671 0.405710 0.699882 0.685768 1.837220 -0.135020 0.618382 1.538502 1.936925 1.869902 1.304847 1.204678 1.245764 0.849343 0.077370 1.376208 0.128986 0.683191 1.168443 0.773303 0.918277 0.361282 1.325992 0.182420 0.557109 0.856130 0.916468 1.073525 -0.056735 0.457839 1.415303 1.493321 0.837421 1.245510 0.324402 1.072023 1.495966 0.779674 1.792871 0.438686 1.400304 -0.029656 0.771387 1.191604 0.497478 0.949389 0.583656 1.568371 0.818618 0.376624 1.922430 1.597926 1.106025 1.349123 1.097987 1.226814 0.449548 0.978715 1.149809 0.090419 1.181951 0.196841 0.169854 1.157525 0.672195 -0.013396 1.381930 0.763467 1.101984 1.081354 1.745447 0.052582 0.434851 0.710038 0.252432 1.547955 1.291922 0.243233 0.084185 1.718412 0.754270 1.712834 -0.113817 -0.185231 0.645607 0.602242 0.698745 1.484932 0.708616 0.806637 1.321352 0.822224 0.486883 0.890968 0.415997 0.868384 0.439809 0.369575 0.155202 0.890177 0.736148 1.282829 0.496635 0.179507 0.581791 0.861737 1.329786 0.952408 1.311372 0.616676 1.793129 0.198151 0.583196 0.014657 0.736984 0.943676 1.304757 0.104216 1.131163 0.886646 1.431121 0.607723 1.834661 0.350032 1.233992 0.553257 1.415608 1.339899 -0.021117 1.320488 0.646222 1.478825 0.253185 1.344375 0.782507 0.242220 1.348393 1.611945 1.891346 0.403449 0.420262 1.560522 0.492852 1.786347 0.954743 0.927910 1.007730 0.966809 1.183914 0.132915 0.235582 1.182222 0.510621 0.119231 1.400333 1.559546 0.434169 0.106340 1.159731 1.145452 1.403938 0.593410 0.423464 1.214964 0.097415 0.659427 1.330465 0.265373 0.978681 -0.241303 1.410817 0.374681 0.982607 0.620477 1.028389 1.023993 0.703520 1.277773 0.757705 1.040223 0.694910 0.158208 1.192658 1.103184 1.154745 0.138529 0.659537 1.567368 0.955008 -0.008595 1.044148 0.615600 0.596413 1.600428 -0.130936 0.209722 0.597264 0.214794 0.424799 0.791647 0.212593 1.490120 0.029575 0.222065 1.056546 0.514551 1.117830 0.080900 0.698795 0.825148 0.128150 -1.946314 1.296496 1.764967 -0.109275 0.619906 1.046853 -0.050885 1.414055 0.243491 0.805047 0.478126 0.210018 0.383272 1.147815 -0.142393 0.254600 0.974724 1.253165 0.759822 0.390277 1.900341 0.600527 0.913172 1.508819 0.838474 0.842307 0.052699 0.015556 0.443439 0.953984 0.747720 -0.054054 0.972040 -0.241904 1.438074 0.685282 0.673901 0.604914 0.601935 0.592279 0.658902 1.125537 0.853760 1.677094 1.268821 0.909583 0.771236 0.955089 1.189800 0.847715 0.318412 1.928436 1.740119 0.412900 1.589818 1.013917 1.215481 -0.014813 1.247880 0.223321 0.897915 0.951870 0.304753 1.763894 1.166419 1.525081 1.491253 1.646299 0.047929 0.453022 0.624295 -0.345040 0.250292 1.322349 1.263984 0.481892 1.819190 1.498516 0.274084 0.915689 1.490261 0.159303 1.347132 1.407289 -0.117297 1.828899 1.616281 0.092870 0.390260 -0.086407 1.668212 0.707778 -0.125709 -0.068702 -0.008020 1.483304 1.668166 0.205490 0.775194 1.173496 1.068329 -0.181766 1.426966 1.728307 1.644513 0.798234 0.762223 -0.195164 0.527024 1.036420)
       )

;;; 2048 all --------------------------------------------------------------------------------
#(2048 89.570060996356 #(0 1 1 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 0)

       77.350213 #(0.000000 0.555539 0.501262 1.044749 0.287771 1.412682 1.651595 0.929560 0.549846 1.324740 1.935869 1.135478 1.476903 0.201893 1.072368 1.469797 1.856304 1.710124 0.155645 1.734478 1.438672 1.662318 0.369149 1.305539 1.380565 0.760274 1.791213 0.758033 1.460302 0.314773 1.273350 1.445081 1.922068 1.981608 0.787530 0.220848 0.749937 0.852506 1.079197 1.596357 0.533643 1.661423 1.309207 0.570204 0.799186 0.806331 0.147029 1.886462 -0.011055 1.620080 0.764653 1.039822 1.399443 0.540383 1.263941 1.520079 0.955253 1.475051 0.569591 1.021593 1.696488 1.384568 0.888621 1.246065 0.141108 1.760633 0.530062 0.078663 -0.052280 1.231263 1.886752 1.022966 0.731660 1.519866 0.815188 1.842595 0.428998 0.982542 0.268300 0.449940 0.825066 0.093779 1.541877 1.530942 -0.044025 1.404789 1.172967 1.495494 0.986869 1.354411 0.977699 1.323218 0.290527 0.642299 1.141685 0.305403 0.116047 1.498648 0.363158 1.133291 1.021968 1.050915 0.004007 0.316776 -0.008246 1.753451 1.448398 0.727763 0.491974 0.467132 0.349093 0.846144 -0.057302 0.451593 -0.185527 0.954499 -0.017687 1.738336 1.132264 1.277860 1.255149 0.644067 1.787009 0.975542 0.787661 1.834522 0.750059 0.165831 1.781394 0.656243 0.189155 0.885417 1.864367 1.861898 0.835353 1.925872 0.784282 0.149366 0.389909 1.891355 0.667211 1.629093 -0.156731 0.686377 -0.046381 1.379719 0.174257 1.815414 1.782186 1.460458 1.225364 0.215276 0.433813 0.778669 0.770455 0.591200 1.467950 1.402450 1.237374 1.213320 1.107618 1.577857 0.153528 1.496479 1.690453 0.757018 1.164466 1.863222 1.556344 0.411893 0.045128 -0.148474 0.690145 1.255681 1.262642 1.053606 0.652441 1.807011 1.212250 1.298870 1.843582 0.679071 1.071529 1.212117 0.457856 0.037265 0.056807 0.289533 1.340623 0.191271 0.023689 0.079151 1.691347 0.427278 0.798824 0.971986 0.219384 1.510317 1.755539 0.020056 -0.108987 1.920829 0.654279 1.269937 0.625973 1.626210 1.557939 0.060795 1.054050 0.688441 1.815486 1.547017 1.227524 0.184287 0.725676 1.529612 0.145770 1.961037 0.740800 1.404065 0.938756 0.807687 1.820918 0.792546 -0.054241 0.457527 1.314210 1.386331 1.330133 1.364743 0.425434 0.805132 0.601427 1.151039 0.181880 0.588421 1.746772 0.525817 -0.062391 0.174995 -0.229241 1.865325 0.777080 0.576100 1.157737 1.173633 1.108300 0.620180 0.679835 1.829428 1.415691 1.510131 0.278064 0.869124 1.774022 1.810644 -0.249575 -0.122332 0.003232 1.632364 1.298768 0.233819 0.326577 0.745415 0.803076 1.768981 0.251203 0.915819 1.691281 0.742817 0.546973 0.218234 1.629248 1.253580 1.354290 0.528862 1.813762 0.263825 0.781654 1.287354 0.093701 0.698575 0.887912 1.137370 1.529613 1.518332 0.469199 1.225525 0.065649 0.280063 0.033222 0.909971 0.563943 1.914227 -0.065120 1.804400 0.103014 0.719986 1.951068 0.757568 0.217891 0.598460 1.177422 0.353950 1.684496 1.079766 1.303468 0.083664 -0.101540 0.424187 1.703711 0.337732 0.080405 0.592311 1.778334 1.635999 0.889894 1.617811 -0.035024 0.001647 0.924071 0.404662 1.353001 0.748591 1.771296 1.263408 -0.089484 0.221854 0.796659 -0.134496 0.228028 -0.006122 0.001128 1.259921 0.408335 1.472770 1.057188 1.208943 0.859616 0.951961 0.715820 0.286498 1.182115 0.918625 1.616017 1.001494 1.156487 0.467273 0.762620 1.416134 1.041549 1.777524 1.975901 1.424345 1.013724 1.528658 0.546749 1.515054 0.722119 1.165674 -0.188903 1.095713 0.017814 1.713209 0.808498 0.510307 0.811778 0.118225 0.831248 -0.024877 0.111979 0.001521 0.995340 -0.029678 0.290675 0.273513 0.805748 0.398880 0.215141 1.450122 1.736611 1.571552 1.456815 1.117397 1.312031 1.124964 0.952301 0.371672 1.874636 1.681841 0.351506 1.462640 0.011383 0.220945 0.998689 1.953549 -0.140064 0.559134 1.277572 1.812283 0.159287 1.701742 0.028876 0.066961 1.832832 1.596575 1.021889 0.172947 -0.123165 1.617572 0.738832 0.135822 0.899103 0.675147 0.590566 1.141705 0.619940 1.835079 1.810902 0.002593 0.085103 0.459750 1.324431 0.679980 1.499886 1.342828 0.113834 0.419635 0.474996 1.341851 0.784830 0.644960 1.049676 0.463071 -0.083825 0.357307 1.521176 1.668760 1.414541 0.331217 0.933878 0.750349 -0.094259 1.512555 0.057719 1.957253 1.855659 0.525060 0.191371 0.086135 0.778769 1.177665 1.138710 0.469141 0.550747 1.927353 0.597089 0.788555 -0.049972 0.972408 0.774953 0.590333 0.590142 1.188901 0.464196 0.937929 0.701475 1.283776 1.839285 0.195083 1.905586 1.378602 0.369590 0.773647 1.495702 1.010798 1.832039 1.743886 1.062461 1.551722 0.161056 0.247843 0.963386 -0.138497 0.113261 1.624467 1.660928 0.708473 1.847610 1.082010 1.479425 0.325611 0.661837 0.996064 1.316217 0.550535 0.354734 1.792945 0.587728 0.521299 1.867430 0.374452 1.069128 1.359185 1.163695 0.951998 1.554486 0.652597 0.335947 -0.007622 0.361202 1.522520 0.972243 1.090924 1.066404 1.473604 0.640795 1.326138 1.634896 0.633935 0.819042 0.374617 0.068108 0.899846 0.802853 1.002802 0.759373 0.912908 1.407252 1.871269 1.750381 1.651341 0.745903 0.461669 0.010571 1.287847 0.966184 0.583195 0.846835 0.694802 0.418880 1.389707 0.135708 0.155010 1.328469 0.737490 1.774328 0.368667 1.177429 1.152407 0.410099 1.383384 1.321282 1.568075 1.554693 1.238949 1.708897 0.117567 1.335460 1.803251 1.767886 0.012287 0.229862 0.355011 1.249238 1.512803 0.578011 1.451312 1.246621 -0.119738 1.826298 1.173428 0.117885 1.168928 0.345406 1.476069 -0.166920 1.034463 0.382725 0.245749 0.326820 0.118853 -0.057706 0.849665 0.007921 0.613571 0.734308 1.134450 0.749676 1.890959 0.378518 1.752809 1.108432 1.225504 0.442657 0.756270 1.860343 0.369036 1.527507 0.444954 0.930412 1.102519 1.878509 0.479922 1.150077 1.602579 0.058713 0.962265 0.328221 1.661628 0.457747 0.271408 1.870263 1.306306 0.335093 0.169626 0.654033 1.444649 0.614644 1.787700 0.114577 0.749670 0.270604 1.159625 0.989586 0.567069 1.072818 1.888945 -0.085294 0.121997 0.763024 0.984919 0.155703 -0.016260 0.191743 0.212740 0.115788 0.830523 1.683788 0.348500 0.124881 0.670456 0.678523 1.096574 0.897665 1.161154 0.986261 0.052581 0.418547 1.926610 1.527221 0.733566 1.720164 0.588071 0.718754 0.656306 1.222241 0.299541 1.655932 1.738610 0.208473 1.377056 1.640789 0.933028 0.500950 0.266025 0.202787 1.158416 1.726212 1.606686 0.645745 1.477768 1.448364 1.953745 0.028736 0.535783 0.762769 0.101338 1.101876 0.758538 0.004060 1.805216 1.598025 1.230557 0.047096 1.594085 0.215135 0.853051 1.296541 1.417117 0.235968 0.643987 1.405340 1.661579 0.911175 0.443065 1.589884 0.446420 1.073318 0.341514 0.657629 1.701362 1.726879 1.038635 1.625078 0.744561 0.038576 0.786606 0.041993 1.298454 0.218073 0.832914 0.079816 1.047928 0.782023 1.638485 1.342287 1.936893 0.724752 -0.015138 0.922139 1.148652 1.670824 0.337136 0.637705 1.001048 -0.228216 1.495036 0.605922 1.410177 1.011580 0.373865 -0.050306 -0.030282 1.482241 1.182296 0.616043 1.884674 1.514223 0.449114 1.217143 1.156828 0.699730 0.102999 0.250137 -0.031123 1.355748 1.655393 1.161987 1.872025 1.869860 1.112928 1.115924 0.563079 0.100168 1.165211 0.614544 1.264233 1.208279 0.960027 1.628427 1.610521 0.459497 0.403669 1.211322 0.657728 0.590534 1.175789 1.353568 1.427489 1.516217 1.243310 0.036331 1.415204 1.335414 0.312401 0.846162 1.692827 0.881253 1.673563 1.476773 0.491668 0.078271 1.772063 0.429881 0.829599 1.510362 1.324221 0.970839 1.031818 1.605683 0.417137 0.539905 1.124071 1.428885 0.758991 1.336089 0.469378 0.968420 1.462076 0.079466 1.439924 1.447561 1.037226 0.032416 -0.028897 0.368902 0.151743 1.133019 1.512185 1.860937 1.628533 0.118447 1.427979 0.445947 0.232361 0.041062 1.774814 -0.000513 0.970153 0.175939 -0.114292 0.214713 0.557618 0.732536 1.302739 0.889277 1.136665 1.083674 0.654661 1.702739 0.901405 1.509089 0.547946 0.795351 1.387886 0.101319 1.071538 0.300259 1.362963 1.449746 1.621519 0.648860 1.238117 0.385683 0.777458 1.582777 0.090560 1.423196 0.518231 0.129612 0.369422 1.062708 1.137679 1.093619 0.410051 -0.028865 0.764992 0.842311 0.311702 1.830111 0.825103 0.859872 1.362654 0.443486 0.796728 0.015052 1.894804 0.178369 1.350106 1.080421 0.074839 1.798439 1.439047 0.543832 1.787518 1.095677 1.399291 1.218684 1.329215 0.024198 1.277854 1.781214 1.897330 0.663755 0.933197 1.460518 0.015174 0.890021 0.299191 0.591948 0.637994 0.192189 1.518365 0.789317 0.221733 1.393516 1.452171 1.164045 1.425340 1.211899 0.133999 1.809860 1.760137 0.786782 0.058488 1.033658 1.696528 0.115067 1.775639 1.843275 1.658795 1.102731 0.033810 1.518485 0.287243 0.872813 1.110274 1.284147 1.409632 0.002816 1.287616 1.920460 1.545101 0.357241 0.586921 0.250178 0.941329 0.683970 1.816670 1.249502 0.715161 1.288352 1.693684 -0.049681 0.500555 0.738239 0.766636 1.371281 0.427733 1.686588 1.002051 0.758627 0.719945 0.772296 0.797069 1.369126 1.077561 0.114153 1.255930 1.134835 0.290465 1.528414 1.156214 1.255893 0.569904 0.306550 1.578306 -0.027271 0.175993 0.505511 1.123829 1.257104 0.836799 0.957553 0.983670 0.264465 1.266100 0.704111 0.184087 1.468253 0.982413 -0.018410 0.765235 0.844886 0.194386 0.957304 0.466408 0.358006 1.273348 0.958858 0.192485 1.537449 0.762105 1.953919 0.360697 1.896891 0.771484 1.562116 0.477611 0.862940 1.057378 1.667997 0.072578 0.987503 0.634043 1.564453 1.444159 1.122332 0.573990 -0.026527 0.262861 0.694100 1.056833 0.776423 1.948071 1.715568 1.887729 0.174970 -0.171751 1.467195 1.339357 1.881230 0.084291 1.864481 1.857912 0.659248 0.423773 -0.012834 1.278787 1.236726 0.247062 0.279965 1.858545 1.197597 0.522526 0.880799 0.648553 0.790672 1.467274 -0.136872 0.250201 0.665615 0.060502 0.639605 0.387814 0.576618 0.316508 1.567811 0.098866 0.141794 1.102771 0.799866 0.345332 1.009816 0.888907 1.440320 1.300171 1.855403 0.546924 0.083787 1.421153 1.562621 0.072527 0.037440 0.573282 1.293324 1.351032 1.399589 0.771864 1.155326 0.219484 0.989074 0.912196 1.752766 1.745645 1.137247 0.591051 0.105617 0.254271 0.434891 -0.094733 0.689956 1.337531 0.526193 0.871788 1.523712 1.319939 -0.014173 0.862280 0.823385 0.054355 0.629683 0.514687 1.439869 0.563628 0.106880 0.266513 0.239968 1.239315 1.205902 1.537987 1.098124 0.859805 0.863555 0.449285 1.422210 0.199768 1.541420 0.165019 0.357841 1.333702 0.780552 1.817421 1.326090 1.556642 0.158090 0.988718 0.674445 1.749600 0.960378 0.084288 0.655024 1.656664 0.587799 0.266345 1.475692 0.355335 1.516077 0.871619 0.114120 0.528946 -0.021508 1.566964 0.763272 -0.041987 1.595826 0.231857 1.599241 1.621312 1.104850 1.046262 0.120831 0.746877 0.255028 1.065960 1.308573 1.030611 0.412491 1.820905 0.676300 0.872818 1.288694 1.324473 0.222472 -0.042336 0.351502 0.979300 0.592070 1.751901 1.130980 0.635238 1.762905 1.273495 1.080044 0.919480 1.179593 1.820413 -0.178963 1.488909 1.547676 1.413473 0.037220 0.540918 0.498348 0.519105 1.466716 1.160558 1.879868 1.779510 0.227415 1.843328 0.973617 1.469836 0.661373 0.789077 1.686318 1.083096 0.731552 0.631974 0.625195 0.518437 0.775161 0.599994 1.433824 1.546850 0.244876 1.235352 1.089325 0.745382 0.631062 0.172135 1.346869 0.691421 0.557946 0.547526 0.910145 1.806512 0.841829 0.035993 0.164089 0.876851 0.419736 1.447045 0.857337 1.449753 0.335596 1.526369 1.237708 0.224164 0.915030 1.895158 0.321894 0.243163 0.253147 0.767202 1.294104 1.921776 0.626583 0.519179 1.368603 1.836644 0.124415 0.786054 0.509813 0.419967 1.197343 1.868597 0.775064 0.252892 0.318984 0.927666 1.932340 1.673779 0.940320 1.012894 1.522815 1.848921 1.524047 0.876052 0.835068 0.202396 0.794377 1.439611 0.074539 -0.075361 1.885112 0.757920 0.329423 1.361749 0.638054 1.833880 1.623912 1.949599 1.140473 0.640646 1.616862 1.093454 0.364866 1.044146 1.776136 1.508751 1.419919 0.732729 1.039208 1.607877 1.063599 1.218045 1.039226 0.726168 0.417832 1.530379 1.814359 0.766578 1.503198 0.394050 1.486705 1.297175 1.401889 -0.082990 1.629865 0.667706 -0.397919 1.071902 1.710567 1.259419 0.488686 0.774842 0.495281 0.690810 -0.138360 0.995138 0.649084 1.726986 1.822386 1.675677 0.871295 0.552178 0.176435 1.151023 1.706719 1.714074 1.232741 1.305463 1.102357 1.338847 1.735865 0.353156 0.053635 1.854965 0.082734 1.117492 1.602812 0.202797 0.527913 1.196926 0.224179 0.259190 1.607857 0.393217 0.665176 0.698877 1.498248 0.402702 0.734968 0.030220 0.717933 0.287575 0.263201 1.292487 0.766597 1.392089 1.702156 0.928571 0.132747 0.718224 -0.022519 0.695395 0.961009 0.836784 0.544693 0.008738 0.733264 1.627723 1.340817 1.883794 0.273239 0.966759 -0.014448 1.703981 0.745520 0.782103 1.349896 0.309738 1.248191 0.900551 0.446724 1.461235 1.068695 1.874609 0.429643 0.991606 0.853954 0.549724 0.691665 0.919866 1.355260 0.399310 1.207242 1.036111 0.331131 1.923340 1.034344 1.785499 1.692182 1.469165 1.114091 0.784790 1.244341 1.215443 0.532863 1.669624 1.876519 0.370732 1.081205 0.630715 0.067840 0.069610 0.360604 0.248517 0.996373 0.072779 1.278622 0.558082 0.871795 0.006302 -0.080693 0.699858 0.670774 0.036839 0.792313 1.053054 0.373523 0.895965 0.219529 0.603841 1.529929 1.571200 1.572745 1.371021 0.483877 0.339338 0.252508 1.449230 0.776954 -0.037096 1.490924 0.862926 -0.010051 1.492206 0.908991 0.850959 0.799315 1.197209 1.798803 1.906307 0.600800 1.929103 1.773167 1.595466 1.116230 1.849141 -0.138473 1.401561 1.089434 1.454707 1.516034 0.405189 0.364581 0.477576 1.238788 1.699265 1.225421 1.132382 0.818130 0.342357 -0.093965 0.277981 1.214872 1.234457 1.644311 0.791369 1.302431 1.793582 0.731030 1.184737 1.815189 0.836787 1.397548 0.795514 1.731490 1.978947 1.699272 -0.087754 1.229538 0.342806 1.370505 1.915848 0.745665 -0.007586 0.973025 0.820357 0.688041 1.687190 0.295857 1.467741 0.510938 1.446447 0.725517 0.934034 0.280828 0.016119 0.464653 0.039176 0.699325 0.325100 0.107226 0.235540 -0.001189 1.374634 0.697151 1.094635 0.813547 1.004845 0.482350 0.999131 0.106594 0.262632 1.035519 1.040389 1.543929 1.111148 0.589803 0.294786 0.739019 0.976084 0.242874 1.533302 1.797675 0.710897 0.037253 1.540031 -0.138585 0.099110 0.002289 0.351043 1.535626 1.094114 1.596706 1.760672 0.111407 1.067403 0.300312 1.066585 1.479561 0.664804 1.829358 -0.133782 0.959441 1.032728 1.396513 1.674422 1.797836 1.031267 1.515695 1.300521 1.221482 1.135268 1.060354 0.280176 0.099445 0.768971 1.623602 1.175004 0.859700 0.318892 1.048016 1.141598 0.451777 0.809913 1.805898 -0.088147 0.408319 0.962852 0.001868 0.190438 -0.086998 1.638471 0.448879 1.897520 0.102606 1.398992 0.552579 1.630596 1.779521 1.459921 1.806379 -0.015856 0.522021 1.606515 0.866415 1.424116 0.555575 1.948281 1.030085 1.522586 1.487448 0.345793 0.419242 0.262081 -0.137605 0.615015 1.404327 0.444728 1.303330 1.429523 1.612489 0.842585 0.811464 1.213611 1.776209 0.851089 0.965962 0.450547 1.048746 0.577828 0.621931 1.428382 1.449142 0.237328 1.159246 1.621752 1.046157 1.746994 0.219170 0.418162 1.636099 1.220316 1.860240 1.104417 0.911381 -0.221721 0.477919 0.648802 1.465706 1.034322 0.722603 0.484344 0.507547 1.362755 0.260305 0.012258 1.063129 0.125427 0.731236 1.951972 1.460277 1.336222 1.327980 0.292992 1.466729 0.979436 1.525635 1.525911 0.335487 0.473741 -0.076837 0.875218 0.622684 0.081840 0.662885 1.733616 0.541135 0.388849 0.020387 1.077932 1.301097 1.479384 0.696331 1.842813 0.869590 1.665039 0.472033 0.087064 0.068769 0.055497 0.502784 1.571676 1.461867 1.681430 0.147791 1.648422 1.206459 -0.037747 0.322247 1.620310 0.330283 0.874529 1.548328 0.082016 0.899640 0.252738 1.639547 1.115960 0.718372 1.473943 0.699136 1.736238 1.746811 1.089863 0.308838 1.120907 1.649835 0.230940 0.599980 0.596666 1.447764 0.198200 1.696185 0.270568 -0.052189 1.459685 1.889516 0.973187 0.172200 1.005083 0.140394 -0.325498 0.227479 1.423139 0.675559 1.625686 1.773134 1.707271 0.913240 1.631036 0.019460 -0.103583 0.286102 0.291320 0.171705 1.446563 0.484585 0.563140 1.120302 1.858354 -0.041253 1.012849 1.296992 1.301978 0.760269 1.753296 0.283422 0.885422 1.492344 1.329990 0.612597 1.921560 0.200214 0.943390 0.512296 1.447564 1.846183 1.707477 0.147308 1.193487 0.573805 0.940372 0.256928 1.884388 0.083286 0.452700 0.291224 0.183037 0.545393 0.513289 1.568504 0.086795 1.616080 0.313708 1.244178 1.366657 0.283715 0.918206 0.203207 1.448705 1.446830 1.040873 1.730698 1.611476 0.946093 0.666703 0.615895 -0.026318 1.856548 1.350941 0.160944 1.170338 0.103712 1.306411 1.265492 0.066769 0.766652 0.588182 1.233682 0.122447 1.681384 0.412335 0.178479 1.660841 1.811596 0.064779 1.196947 0.102828 1.177751 1.680742 0.449282 0.904230 1.612891 0.610492 1.241968 1.399466 0.400447 1.883535 1.261774 1.133011 0.954793 1.391021 0.070613 1.790155 0.647170 1.538113 0.897498 1.281308 0.839515 0.299338 1.976000 1.258249 1.677501 0.492876 0.811265 1.486293 1.219526 0.118255 0.198524 0.778925 0.559223 0.356595 0.911936 0.224097 0.843920 0.757074 1.245721 1.201767 1.503895 1.262673 1.087280 1.841884 0.809693 0.271807 0.201811 0.731278 1.725985 1.815260 0.626935 0.345144 1.819499 0.455162 1.284539 0.586586 -0.039343 1.180043 1.600481 1.257565 1.070955 1.769321 1.284756 0.544339 0.946351 1.252154 1.036230 1.576752 1.153164 0.375443 1.727961 1.571085 -0.025115 1.130257 1.617683 0.962908 1.778427 0.723156 0.083418 0.399245 1.317049 1.776371 1.599518 1.205637 0.260734 1.602902 0.159849 0.015420 1.100020 1.095699 0.079940 0.912501 0.640796 0.462014 0.677260 1.211741 1.516331 1.260972 0.602754 1.418955 1.106479 1.705887 -0.011794 -0.109286 0.655006 0.832139 0.926535 1.469372 0.543237 -0.034228 1.638292 1.960348 1.105376 1.332042 1.230009 0.928482 0.888952 0.046935 0.000507 1.314819 0.300831 0.937048 1.256196 0.493401 1.660853 0.728526 -0.110992 1.233577 0.930248 0.678472 -0.188603 1.218183 0.336483 1.191586 0.137376 1.533100 0.065052 0.981398 0.031577 0.994203 0.870125 0.262473 0.406748 0.511844 0.815002 0.421443 1.909838 1.226523 0.209198 0.929653 1.101747 0.799872 -0.201492 0.710339 1.291323 0.977953 1.379452 1.641037 0.096914 1.857579 -0.096609 0.337720 0.155086 0.269412 1.616182 0.568248 0.498010 1.652758 1.650958 0.244174 0.661813 1.505931 0.002924 0.107270 1.744250 -0.050778 1.467242 1.623260 0.801762 0.194925 0.642578 1.510339 1.586904 0.355100 0.041208 0.186780 1.201510 0.782417 -0.071305 1.709116 1.537271 1.490599 0.543263 -0.128944 1.746343 1.737663 -0.131604 0.721233 -0.033503 0.381659 0.516023 0.468830 0.968358 1.682010 1.574023 1.572387 0.110095 0.087750 1.339801 0.879220 0.721407 1.874303 0.700889 0.258858 1.621111 0.253234 1.424104 1.511284 0.981212 0.722846 0.700750 1.110812 0.395794 1.195186 0.912389 1.340990 0.476183 1.514745 1.613236 0.410309 0.055535 0.162381 0.534469 0.793452 1.780666 0.700207 1.016778 0.157602 0.161820 1.110015 0.882580 0.709147 1.213415 -0.036555 1.633111 1.171847 0.640753 0.205253 1.266074 1.492664 0.580884 0.765533 1.322154 0.370372 1.440758 0.830815 1.501849 1.539966 1.852372 0.365379 1.004282 1.053251 0.251083 0.118197)
       )

;;; 4096 155.67;     (expt 4096 .6) is 147
;;; 65536 704.86! [.59 = 697, .5 = 256]

))


;;; ---------------------------------------- odd numbered harmonics ----------------------------------------

(define nodd-min-peak-phases (vector

#(1  1.0   #(0)
     )

#(2  1.539 #(0 0)
     )

;;; 3 odd --------------------------------------------------------------------------------
#(3  1.7548747062683 #(0 1 1)

     1.7393749801561 #(0.0 1.205686890924528215096600547440175432712E0 1.297035953235478072942399307976302225143E0)
     1.7387926578522 #(0.0 1.2094986438751 1.3025436401367)
     1.7387455701828 #(0.0 0.79018270969391 0.69699490070343)

     1.738745 #(0.000000 1.209826 1.303017)
     1.738744 #(0.000000 0.790172 0.696980)
     )

;;; 4 odd --------------------------------------------------------------------------------
#(4  2.19460272789 #(0 1 0 0)

     2.050 #(0 39/25 26/29 27/22)
     2.048743724823 #(0 111/256 281/256 195/256)
     2.0466175079346 #(0 223/512 563/512 49/64)

     2.045218 #(0.000000 1.563819 0.899661 1.233860)
     2.045217 #(0.000000 0.436172 1.100327 0.766122)
     )

;;; 5 odd -------------------------------------------------------------------------------- ; 2.2360679
#(5  2.7317879199982 #(0 1 1 0 0)

     2.3731805734023 #(0 7/16 7/4 5/8 7/16)

     2.307252 #(0.000000 0.393369 1.754476 0.596108 0.424804)
     2.307253 #(0.000000 1.606636 0.245540 1.403918 1.575230)
     )

;;; 6 odd -------------------------------------------------------------------------------- ; 2.44948
#(6  2.8638670444489 #(0 0 0 0 1 0)

     2.522759 #(0.000000 1.360421 1.129847 1.035439 1.320248 0.102465)
     2.522749 #(0.000000 0.639403 0.869779 0.964074 0.679243 -0.103102)
     )

;;; 7 odd -------------------------------------------------------------------------------- ; 2.64575
#(7  2.9204399585724 #(0 0 0 1 1 0 1)

     2.618497 #(0.000000 1.527527 0.524623 0.177241 0.453108 1.577456 1.970355)
     2.618376 #(0.000000 0.474123 1.477585 1.824644 1.552691 0.429533 0.035303)
     2.618302 #(0.000000 0.474154 1.477730 1.824846 1.552894 0.429720 0.035636)
     )

;;; 8 odd -------------------------------------------------------------------------------- ; 2.828427
#(8  3.2507002353668 #(0 1 1 0 1 1 1 0)

     2.8071956634521 #(0 109/128 7/4 1 13/16 123/64 21/128 43/128)

     2.790858 #(0.000000 0.802399 1.672681 0.887888 0.680265 1.767889 0.004580 0.126233)
     2.790799 #(0.000000 1.197514 0.327251 1.112061 1.319778 0.232086 -0.004810 -0.126263)
     2.790663 #(0.000000 1.196617 0.325818 1.109894 1.316877 0.229200 -0.008217 -0.130363)
     )

;;; 9 odd -------------------------------------------------------------------------------- ; 3
#(9  3.5549147642153 #(0 1 0 1 1 0 0 0 0)
     3.46973755015 #(0 1 1 0 1 0 0 0 1)
     3.4140722751617 #(0 0 1 1 1 1 0 1 0)

     2.886575 #(0.000000 0.394663 0.625974 1.648922 0.070810 1.803585 1.908749 0.903752 0.378081)
     2.886464 #(0.000000 1.605518 1.374012 0.351118 1.929257 0.196622 0.091381 1.096286 1.622082)
     2.886241 #(0.000000 1.605727 1.374318 0.351747 1.930232 0.197770 0.092557 1.097753 1.623786)
     )

;;; 10 odd -------------------------------------------------------------------------------- ; 3.162277
#(10 3.5391488075256 #(0 0 1 1 0 1 0 0 0 0)

     3.054055 #(0.000000 0.508058 0.119325 0.663858 1.627094 1.847660 0.043999 1.283121 0.512586 0.295891)
     3.054035 #(0.000000 0.528914 0.163543 0.741593 1.737455 -0.019531 0.179460 1.441592 0.691200 0.513749)
     3.054019 #(0.000000 1.467927 1.828996 1.243932 0.242207 -0.005741 1.795358 0.528965 1.275954 1.445527)

     3.053923 #(0.000000 0.530606 0.167556 0.749983 1.748996 -0.005015 0.193787 1.458258 0.709754 0.536958)
     3.053807 #(0.000000 0.524885 0.155185 0.727764 -0.282439 -0.043214 0.155190 1.412864 0.658810 0.474600)
     3.053435 #(0.000000 0.525383 0.155614 0.727601 -0.282536 -0.043650 0.155330 1.412909 0.659050 0.474369)
     )

;;; 11 odd -------------------------------------------------------------------------------- ; 3.31662
#(11 3.6182308197021 #(0 0 0 1 1 1 0 1 1 0 1) ; 3.31662

     3.177383 #(0.000000 1.758655 0.386236 -0.008172 1.159122 0.785208 0.739625 0.606297 1.367332 0.311355 0.827147)
     3.177220 #(0.000000 0.232935 1.599549 -0.005436 0.822576 1.185453 1.230375 1.357659 0.594255 1.644007 1.122113)
     3.177201 #(0.000000 1.748294 0.370273 -0.021500 1.141958 0.751903 0.709536 0.566072 1.323348 0.262962 0.769859)

     3.177182 #(0.000000 1.764972 0.396592 0.001274 1.171590 0.806702 0.760785 0.632485 1.395663 0.343598 0.864498)
     3.177098 #(0.000000 1.745038 0.362715 -0.030740 1.128748 0.736155 0.690326 0.545405 1.303285 0.236832 0.743503)
     3.176608 #(0.000000 1.744464 0.362417 -0.030039 1.129933 0.735652 0.691339 0.545454 1.302582 0.237082 0.742494)
     )

;;; 12 odd -------------------------------------------------------------------------------- ; 3.464101
#(12 4.0877377663658 #(0 0 0 0 1 0 1 0 0 1 1 0)
     4.0507665657231 #(0 1 0 1 0 0 1 1 0 0 0 0)
     4.0 #(0 0 1 1 0 0 0 0 0 1 0 1)
     4.0 #(0 1 1 0 1 0 0 0 1 0 0 0)
     4.0 #(0 1 0 1 0 0 1 0 0 1 1 1)
     4.0 #(0 1 0 1 1 0 0 1 0 0 0 0)

     3.363698 #(0.000000 0.073271 0.585961 0.960666 0.978302 0.113696 1.500041 1.186734 1.772452 0.944338 1.321484 0.602060)
     3.362737 #(0.000000 -0.077029 1.405769 1.027930 1.006574 1.870564 0.481680 0.791450 0.202834 1.026360 0.648485 1.363973)
     3.361884 #(0.000000 -0.077168 1.405944 1.028559 1.007566 1.871331 0.482574 0.792122 0.203932 1.027727 0.649507 1.365630)
     )

;;; 13 odd -------------------------------------------------------------------------------- ; 3.60555
#(13 3.9482246631869 #(0 0 0 0 0 0 1 1 0 0 1 0 1)
     3.8778836727142 #(0 0 1 1 0 0 1 0 1 0 0 0 0) 

     3.476053 #(0.000000 0.380793 0.961293 0.353157 0.446308 0.965358 0.539394 0.172183 -0.067910 0.976833 -0.486927 1.072643 -0.036066)
     3.475486 #(0.000000 1.620375 1.040657 1.650169 1.557159 1.039441 1.466014 -0.165746 0.075570 1.032228 0.496820 0.937529 0.047188)
     3.475452 #(0.000000 1.620672 1.042066 1.652912 1.561748 1.044454 1.472771 -0.159565 0.082334 1.041828 0.507070 0.948164 0.058404)
     3.474532 #(0.000000 1.621213 1.042646 1.653413 1.561849 1.044891 1.473168 -0.158623 0.083544 1.042513 0.507800 0.949479 0.059341)
     )

;;; 14 odd -------------------------------------------------------------------------------- ; 3.741657
#(14 4.2126383781433 #(0 0 0 0 0 1 1 0 0 1 0 1 0 0)
     4.2575645446777 #(0 1 0 0 1 0 0 1 0 0 0 1 1 1)
     4.2842662512094 #(0 1 1 0 0 1 1 1 0 1 0 0 0 0)

     3.606512 #(0.000000 0.785150 1.482463 -0.077041 0.773052 0.357080 1.202237 -0.069790 1.584889 0.769902 0.652503 0.409520 0.740393 0.675317)
     3.600425 #(0.000000 1.139545 0.351170 -0.114733 0.966482 1.234831 0.292454 1.539190 0.009726 0.589539 0.769919 0.798632 0.417679 0.467195)
     3.599409 #(0.000000 0.851134 1.636505 0.091221 1.006010 0.744090 1.678264 0.418648 -0.048848 1.351639 1.174737 1.143087 1.519418 1.448182)
     3.598494 #(0.000000 0.850577 1.637081 0.089423 1.006545 0.749551 1.681409 0.420517 -0.044040 1.351533 1.177890 1.148728 1.524043 1.447267)
     )

;;; 15 odd -------------------------------------------------------------------------------- ; 3.872983
#(15 4.4701427567987 #(0 1 0 0 1 0 1 1 1 1 1 0 0 1 1)
     4.4776539802551 #(0 0 1 0 1 0 0 1 0 0 0 1 1 1 1)
     4.5555243492126 #(0 1 0 0 1 0 1 0 0 1 1 0 0 0 0)

     3.739752 #(0.000000 1.191367 0.176518 1.591145 1.710423 1.309889 1.422724 0.785426 1.754948 1.707551 1.122738 1.744847 0.127913 0.663567 0.776627)
     3.738430 #(0.000000 1.190239 0.174514 1.589466 1.706591 1.305812 1.416225 0.779885 1.746839 1.699566 1.113488 1.734421 0.117674 0.652032 0.763074)
     )

;;; 16 odd -------------------------------------------------------------------------------- ; 4
#(16 4.5778832343715 #(0 1 1 0 0 0 0 1 0 0 1 1 1 0 1 0)
     4.5854911804199 #(0 0 1 0 1 0 1 1 0 1 1 1 1 1 0 0)
     4.6032500267029 #(0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0)
     4.6629304885864 #(0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 1)
     4.6691436767578 #(0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1)

     3.858242 #(0.000000 0.144652 0.676444 0.017002 0.269119 1.012194 1.772841 1.585260 1.809100 0.289620 1.399960 0.670537 0.175237 0.296937 -0.017357 1.108803)
     3.857020 #(0.000000 0.144607 0.675956 0.016527 0.269112 1.012147 1.772535 1.584482 1.808783 0.289484 1.400085 0.669674 0.174650 0.295492 -0.017769 1.108482)
     )

;;; 17 odd -------------------------------------------------------------------------------- ; 4.12310
#(17 4.5790815353394 #(0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0)
     4.6202440261841 #(0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1)
     4.8765740394592 #(0 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 0)

     3.927805 #(0.000000 0.618908 0.864629 1.180783 1.677629 1.929621 0.580975 1.820904 0.468136 1.289907 0.485211 0.029658 1.160895 0.856998 0.644358 0.814931 0.296558)
     3.926355 #(0.000000 0.619515 0.864447 1.181990 1.677700 1.930862 0.582927 1.823955 0.470265 1.290931 0.488790 0.031736 1.163146 0.861017 0.648828 0.818286 0.301049)
     )

;;; 18 odd -------------------------------------------------------------------------------- ; 4.2426406
#(18 4.801501750946 #(0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0)
     4.857753276825 #(0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0)
     4.86248254776 #(0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 0)
     5.0418791770935 #(0 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0)
     5.0524249076843 #(0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0)
     5.0652704238892 #(0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 0 0)
     5.0697374343872 #(0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0)
     5.0979032516479 #(0 1 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0)

     4.071185 #(0.000000 0.956640 1.083713 0.493342 0.797185 0.138960 0.613585 0.388904 -0.007616 0.968034 0.616152 1.753096 0.351362 1.174080 1.220111 1.511627 0.186455 1.775153)
     4.069528 #(0.000000 0.956814 1.082990 0.493213 0.796608 0.137780 0.611831 0.387091 -0.011186 0.965014 0.614046 1.752338 0.348807 1.169857 1.216059 1.508238 0.182073 1.770765)
     )

;;; 19 odd -------------------------------------------------------------------------------- ; 4.358898
#(19 5.0520766258263 #(0 0 0 0 1 1 1 1 0 1 1 0 1 0 0 0 1 0 0)
     5.0155117084604 #(0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0)
     4.9927339414282 #(0 1 0 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1)
     4.9885946763115 #(0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0)
     4.9724504091175 #(0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 1)
     4.9609222566765 #(0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0)
     4.8924918279945 #(0 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1)
     
     4.173923 #(0.000000 0.329738 1.407540 1.252167 0.448297 0.551162 1.341659 1.859617 1.357020 0.222879 0.553639 1.254187 0.641694 -0.208417 1.489583 1.646436 1.391179 1.758274 1.299312)
     4.171858 #(0.000000 0.330499 1.406874 1.250304 0.450026 0.551790 1.342413 1.858827 1.359366 0.223792 0.553485 1.256415 0.641759 -0.208630 1.490602 1.646088 1.388713 1.758053 1.297635)
     )

;;; 20 odd -------------------------------------------------------------------------------- ; 4.472135
#(20 5.136606875959 #(0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0)
     5.104093841111 #(0 1 1 0 1 1 0 1 0 1 0 0 0 1 1 0 0 0 0 0)
     5.043 #(0 1 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0)

     4.357980 #(0.000000 0.074668 -0.007236 0.182274 -0.090904 0.683075 1.087950 1.620610 1.402047 0.349796 1.096502 -0.498958 0.949574 -0.321894 1.411823 0.831379 -0.654670 0.294879 -0.284984 1.407225)
     )

;;; 21 odd -------------------------------------------------------------------------------- ; 4.5825756
#(21 5.2726634376804 #(0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0)
     5.2359894831295 #(0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1)
     5.2142992491192 #(0 1 1 0 0 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 1)
     5.2105652502144 #(0 1 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0)
     5.1372244578347 #(0 1 1 1 0 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1)

     4.448460 #(0.000000 1.232455 0.090847 0.908719 0.292484 1.788804 -0.065161 1.337389 1.076226 0.741452 1.053336 1.212537 1.463874 0.812811 1.503269 1.665124 0.651549 0.032446 1.058206 1.235365 -0.036822)
     )

;;; 22 odd -------------------------------------------------------------------------------- ; 4.6904157
#(22 5.5119525535942 #(0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0)
     5.473 #(0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1)
     5.1805551751198 #(0 1 0 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0)

     4.581017 #(0.000000 0.180996 0.414015 1.937535 0.354831 0.584078 1.521008 1.778595 1.533807 1.338106 -0.034930 1.700610 0.808153 0.348626 1.850606 -0.102689 0.038967 0.664253 1.395687 0.513457 1.627689 0.472162)
     )

;;; 23 odd -------------------------------------------------------------------------------- ; 4.7958315
#(23 5.5374279022217 #(0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0)
     5.4125407453101 #(0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1)

     4.661614 #(0.000000 0.402662 0.143299 -0.307618 -0.213995 0.796949 1.006633 1.285380 1.569840 0.564104 0.342477 0.293161 1.200899 0.723618 0.539973 0.518746 0.907665 0.184015 1.163786 0.995418 -1.860771 1.039418 -0.124574)
     )

;;; 24 odd -------------------------------------------------------------------------------- ; 4.89897948
#(24 5.6568542494923 #(0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 0)
     5.6584029055795 #(0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0)
     5.62041703818643 #(0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1)
     5.6193280144865 #(0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1)

     4.786434 #(0.000000 0.498846 1.191572 1.399155 0.479838 1.497230 -0.058887 0.823598 0.010384 0.864577 0.051220 1.057330 0.998513 1.799328 -0.041050 0.199658 0.646825 0.272218 0.034139 0.159133 0.043804 -0.115906 1.177655 0.690674)
     )

;;; 25 odd -------------------------------------------------------------------------------- ; 5
#(25 5.7861609458923 #(0 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 1)
     5.7734115151023 #(0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1)
     5.7220960914079 #(0 1 0 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1)

     4.886819 #(0.000000 -0.128793 0.647898 0.792536 -0.285146 0.144218 1.160103 1.183437 -0.004858 -0.239530 1.215352 0.277973 0.699697 1.110172 0.616181 1.458993 0.406636 0.121039 0.182656 -0.085662 1.058149 0.147121 0.546131 0.378165 0.309175)
     )

;;; 26 odd -------------------------------------------------------------------------------- ; 5.0990
#(26 5.8912210464478 #(0 1 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0)
     5.8572101593018 #(0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0)
     5.8545204896237 #(0 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0)
     5.8537594936002 #(0 0 0 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1)

     5.006443 #(0.000000 1.694135 1.368613 1.372881 0.625230 0.749494 1.218456 1.691757 1.088538 0.652397 -0.134215 1.088115 0.314540 0.197061 0.715518 1.230349 1.542812 -0.159343 1.427261 1.767442 0.867761 1.850745 0.671024 -0.112496 0.172562 0.147817)
     )

;;; 27 odd -------------------------------------------------------------------------------- ; 5.196152
#(27 5.9741146989154 #(0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0 0 1 0)
     5.968769496567 #(0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 1)
     5.9206547737122 #(0 1 0 0 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0)
     5.8637111082051 #(0 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1)

     5.088823 #(0.000000 0.108028 1.216984 1.164689 0.975005 -0.022884 0.035464 -0.148996 0.575654 1.005987 1.378471 0.117457 0.956928 1.741009 0.131397 -0.243584 0.873140 0.514628 1.810242 0.918281 0.161062 1.222969 1.595595 1.233298 1.211975 1.332117 1.297417)
     )

;;; 28 odd -------------------------------------------------------------------------------- ; 5.291502
#(28 6.0999548630948 #(0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0)
     6.0720555632906 #(0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 1)
     6.057788848877 #(0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 0 1 0 0 0)
     6.0276107788086 #(0 0 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1)

     5.088899 #(0.000000 1.695594 -0.042323 0.221585 0.121059 0.906440 0.747864 0.144725 -0.170880 0.198031 0.623261 -0.016920 1.187997 1.805776 0.526952 0.257290 0.181436 1.671568 1.634262 0.482276 1.385748 1.687591 0.368532 1.304502 0.925524 0.205838 0.775793 0.352193)
     )

;;; 29 odd -------------------------------------------------------------------------------- ; 5.385164
#(29 6.2191140571712 #(0 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1)
     6.1821198011886 #(0 0 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0)
     6.1290216445923 #(0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 0)
     6.1179310275088 #(0 0 1 0 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 1 1 1)
     6.0348020511367 #(0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 1 1 1 1)

     5.263365 #(0.000000 0.151064 0.558177 0.735081 1.367806 -0.011277 1.649265 0.435302 1.718318 1.203162 0.977127 1.010028 0.703023 1.591655 0.710208 0.371369 0.285721 1.400549 0.654738 0.961707 0.849244 0.833954 0.047113 1.107680 1.103136 1.834278 0.611441 1.521356 0.107658)
     )

;;; 30 odd -------------------------------------------------------------------------------- ; 5.4772255
#(30 6.2854590415955 #(0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0)
     6.2697563171387 #(0 1 0 1 0 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 1 1)
     6.2528157234192 #(0 1 1 1 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1)
     6.2357559204102 #(0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1)

     5.353062 #(0.000000 -0.273797 0.780589 0.428126 1.742006 0.813705 1.826779 0.243133 0.799231 0.444552 0.600071 1.280010 -0.037027 0.801371 0.587721 1.132556 0.784854 1.819749 1.361833 1.646165 1.057885 0.274456 0.188906 0.072120 0.645190 1.511097 1.900389 1.698668 1.288971 1.535352)
     )

;;; 31 odd -------------------------------------------------------------------------------- ; 5.56776
#(31 6.3631281852722 #(0 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1)
     6.3062944412231 #(0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1)
     6.269211769104 #(0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0)
     6.1342258453369 #(0 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1)

     5.418933 #(0.000000 1.386056 -0.055103 1.470738 1.133338 0.301486 1.278842 0.118113 0.785586 0.164711 0.277129 1.264947 0.805303 0.592921 0.251470 0.348783 0.666372 0.600263 0.392807 1.237206 -0.185182 1.790868 1.684032 0.764715 0.385641 1.091814 0.146242 0.339596 0.884327 1.106807 0.158763)
     )

;;; 32 odd --------------------------------------------------------------------------------  ; 5.65685
#(32 6.5067925453186 #(0 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 0)
     6.5040426254272 #(0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1)
     6.4926128387451 #(0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1)
     6.4840421676636 #(0 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 1)
     6.4720740318298 #(0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1)
     6.3532226957365 #(0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1)

     5.563263 #(0.000000 0.861343 1.208721 0.520795 1.054113 1.500902 0.176395 1.932292 0.475897 1.249746 1.078677 0.960255 1.432432 1.363500 0.301492 1.951062 1.402695 1.767079 1.762968 0.052405 1.191435 0.031852 1.950934 1.508841 1.124488 1.063642 0.897258 1.672866 0.358501 1.273522 0.844792 1.935288)
     )

;;; 33 odd -------------------------------------------------------------------------------- ; 5.74456
#(33 6.6069865226746 #(0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 1 0)
     6.6028137207031 #(0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1)
     6.5531010627747 #(0 1 0 0 1 1 1 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0)
     6.5466594696045 #(0 1 1 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1)
     6.5448527336121 #(0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1)
     6.4944429397583 #(0 1 0 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 1 1 0)
     
     5.602961 #(0.000000 1.602314 1.153414 1.251950 1.483737 0.842898 0.331110 1.775787 1.322292 1.204304 1.308143 0.894156 0.779513 0.992393 1.543652 0.196767 0.377438 0.791269 1.809959 1.067569 0.948715 1.605054 1.761811 1.528262 1.622887 0.603858 1.560497 -0.275070 0.725193 1.894504 0.570411 -0.063928 0.717166)
     )

;;; 34 odd --------------------------------------------------------------------------------  ; 5.8309518
#(34 6.7313859392731 #(0 1 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0)
     6.7289090156555 #(0 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0)
     6.7241077423096 #(0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0)
     6.6926617622375 #(0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 0 0)
     6.6887402534485 #(0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0)
     6.67742395401 #(0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0)
     6.5771403312683 #(0 0 1 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0)

     5.740544 #(0.000000 1.128136 0.272558 -0.038354 0.299624 0.550945 0.313230 0.243494 0.297552 -0.035270 1.018110 0.345979 1.524929 0.448210 1.252682 0.941202 0.533185 0.349491 1.187324 0.383773 0.599245 -0.155984 1.372487 0.578854 1.244062 1.476419 0.215593 0.058496 0.148247 1.077304 1.406503 0.859804 1.327046 0.146527)
     )

;;; 35 odd -------------------------------------------------------------------------------- ; 5.9160
#(35 6.8717794418335 #(0 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 0)
     6.8709630966187 #(0 1 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0)
     6.8534955978394 #(0 1 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0)
     6.8080215454102 #(0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 0 0 0)
     6.7822489738464 #(0 1 1 0 0 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0)
     6.7593507766724 #(0 0 0 1 1 1 1 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 0 1 0 0)
     6.7392678260803 #(0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 1 0 1 0 0)
     
     5.833275 #(0.000000 0.446552 1.591598 1.665970 0.393066 0.930519 1.356028 1.466278 0.225797 1.216894 0.009583 0.233020 1.866671 1.148796 1.079614 1.602870 0.201424 1.366765 -0.045388 1.214248 0.402056 0.196949 1.726073 1.538289 -0.146596 -0.105825 1.452686 0.350527 1.133547 0.212285 1.683225 0.967867 0.587559 1.049939 0.968758)
     )

;;; 36 odd -------------------------------------------------------------------------------- ; 6
#(36 6.9997129440308 #(0 0 1 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 0 0)
     6.9918489456177 #(0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 1 0 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0)
     6.9864625930786 #(0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0)
     6.9756178855896 #(0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0)
     6.9730844497681 #(0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 0 0)
     6.9310870170593 #(0 1 1 1 0 1 1 1 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 0 0 0)
     6.838840007782 #(0 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0)
     6.8277182579041 #(0 1 1 0 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0)

     5.977640 #(0.000000 -0.070466 1.538192 0.984355 0.488221 1.019554 1.547512 1.704002 1.584416 0.668394 -0.001385 0.884114 1.504028 -0.187464 0.437132 1.457048 0.752720 0.480053 1.746828 0.789836 0.816665 1.133277 1.144098 1.330854 0.114924 1.293712 1.538716 1.521496 0.841528 0.693020 1.172435 0.408530 0.666143 -0.084621 1.417045 -0.037001)
     )

;;; 37 odd -------------------------------------------------------------------------------- ; 6.0827
#(37 7.1364183425903 #(0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 0 0 0)
     7.1333456039429 #(0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 0 0)
     7.1091394424438 #(0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0)
     7.1067843437195 #(0 1 0 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0)
     7.0880541801453 #(0 1 0 1 0 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     7.0842223167419 #(0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0)
     7.0678915977478 #(0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0)
     7.0 #(0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0)

     6.019116 #(0.000000 1.198867 1.849092 0.935330 1.781957 0.496846 0.026335 0.303736 1.089299 1.074310 1.006658 1.377317 0.271438 1.654659 0.071833 0.494433 1.198697 -0.081156 0.936704 0.883271 1.529398 0.425484 0.218240 1.480439 1.569267 1.446099 0.465358 0.265303 1.385278 0.810099 0.212275 0.106695 0.522036 0.380536 0.175723 0.325421 -0.016008)
     )

;;; 38 odd -------------------------------------------------------------------------------- ; 6.1644
#(38 7.1993670463562 #(0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0 0)
     7.1947164535522 #(0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 1 1)
     7.1848387718201 #(0 1 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 0 0 0 0)
     7.1674456596375 #(0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0)
     7.0878057479858 #(0 1 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0)
     7.027690410614 #(0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0)

     6.144502 #(0.000000 0.458868 0.978476 1.181930 1.502616 1.306826 0.862573 1.146757 1.405645 1.059905 0.794095 1.421586 1.625599 0.940496 1.764567 -0.199122 0.756820 1.331219 0.861096 0.933187 0.734530 -0.017756 1.393231 0.221059 1.805565 0.259500 -0.109877 1.181072 1.136110 0.287177 1.542085 0.219906 1.088940 1.358980 1.068605 1.590143 0.413553 0.247367)
     )

;;; 39 odd -------------------------------------------------------------------------------- ; 6.2449
#(39 7.3710842132568 #(0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0)
     7.3583292961121 #(0 1 0 0 1 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 0 0)
     7.3438787460327 #(0 1 0 1 0 1 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0)
     7.3397698402405 #(0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0)
     7.3336853981018 #(0 0 0 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     7.3038640022278 #(0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0)
     7.2819819450378 #(0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0)
     7.2700448036194 #(0 0 1 1 0 0 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 0)
     7.2362656593323 #(0 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0)

     6.181539 #(0.000000 0.390214 1.432668 1.784856 0.372658 0.651343 0.590730 1.420862 1.232876 1.274776 1.031604 0.648830 1.314325 1.550338 0.798266 0.829350 0.920173 0.286182 1.175424 0.776791 1.481341 -0.170207 1.810272 0.591377 1.604472 0.287027 1.660006 1.308050 0.895442 0.027306 0.915319 0.337380 0.586293 1.687170 1.285611 1.205943 1.760871 1.039296 0.923977)
     )

;;; 40 odd -------------------------------------------------------------------------------- ; 6.3245
#(40 7.6328768730164 #(0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 0 1 1)
     7.5038495063782 #(0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 1)

     6.272478 #(0.000000 1.284197 1.055354 1.062168 0.387815 0.825054 0.121504 1.716073 1.070732 1.544312 0.376494 1.037163 0.380448 0.304545 1.428265 0.150454 0.740589 -1.906896 0.496136 -0.130727 1.453974 1.546206 0.424585 1.220704 1.332527 1.409234 0.400583 1.072058 1.397035 -0.550500 0.327899 1.771283 0.928925 0.550551 1.392166 1.184654 1.462753 1.291611 1.910777 1.578007)
     )

;;; 41 odd -------------------------------------------------------------------------------- ; 6.4031
#(41 7.86743174872036 #(0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 0)
     7.7093445316966 #(0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1)

     6.321636 #(0.000000 0.581881 1.284007 1.435590 0.968036 0.414485 0.203921 -0.085398 1.011694 1.215509 0.697775 0.907045 0.006237 0.289299 0.751565 0.182523 1.917428 0.830815 0.908047 0.267572 -0.061197 0.319855 0.591342 1.699511 1.912692 1.683447 0.192711 0.461781 0.828435 1.122559 0.524721 1.057548 0.753199 0.901168 -0.077807 0.957092 -0.092721 1.453709 0.349112 1.539336 1.035529)
     )

;;; 42 odd -------------------------------------------------------------------------------- ; 6.4807
#(42 7.9323644638062 #(0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0)
     7.8349797520917 #(0 0 1 0 0 0 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 1)
     7.77445936203 #(0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1)

     6.403222 #(0.000000 0.615457 1.471291 0.696790 0.198813 1.064683 0.257669 1.499443 1.009189 1.331704 -0.126692 0.668087 -0.151536 1.235993 1.351147 1.834812 1.622001 1.575606 0.387431 1.123625 1.738720 0.186291 -0.093048 -0.362694 1.268339 0.808624 0.147243 0.174237 0.939940 0.098301 1.557405 1.899768 1.063327 1.398074 1.503515 -0.309876 1.592871 1.047295 0.347548 0.500256 0.502585 1.050388)
     )

;;; 43 odd -------------------------------------------------------------------------------- ; 6.5574
#(43 7.8550543785095 #(0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 0 1 0 1)
     7.8274940102143 #(0 0 1 0 0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0)
     7.7573688953539 #(0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 1)

     6.474181 #(0.000000 0.163031 0.868018 0.644438 0.499955 0.314476 0.501651 0.136276 0.115801 1.311189 1.257885 1.003167 1.668510 0.653556 0.900535 0.185303 1.792109 1.097281 0.880040 0.351492 0.533331 1.402396 1.722630 -0.341451 0.699659 1.677594 1.684893 1.301554 -0.032447 0.458521 1.242927 0.587312 1.726991 0.987710 0.168427 1.112409 0.233710 0.476465 1.063291 1.023410 1.387257 1.104431 1.814614)
     )

;;; 44 odd -------------------------------------------------------------------------------- ; 6.6332
#(44 8.20137867697624 #(0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0)
     7.9338580613871 #(0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0)

     6.599250 #(0.000000 0.351178 1.306835 1.466283 1.319851 0.565360 0.401323 -0.237018 1.055625 0.418518 0.685726 1.681541 1.845435 1.019294 1.472175 1.617323 0.599443 0.202024 1.548869 0.896807 1.498980 -0.449736 0.958935 0.672395 0.465421 0.363298 0.745996 0.800573 1.320237 0.704768 1.103042 1.233693 0.653096 1.449790 0.411870 1.110453 0.556583 1.736823 0.345497 0.024788 0.937504 1.224464 1.559019 1.346766)
     )

;;; 45 odd -------------------------------------------------------------------------------- ; 6.7082
#(45 8.1525803340105 #(0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1)
     8.1351366043091 #(0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0)

     6.624897 #(0.000000 1.004365 0.475962 1.144412 0.404466 0.708852 0.590380 0.024072 1.172296 1.113281 1.630362 1.256665 1.314082 0.342438 0.579726 1.460036 0.838934 0.298273 1.354989 1.643563 1.558056 1.967600 0.749164 1.349815 0.523705 0.276619 1.145711 1.733713 1.155806 1.020242 0.468578 1.677226 1.799379 1.623813 1.799356 0.670303 1.547676 1.429802 1.095547 0.114545 0.743241 1.141259 0.963105 1.247487 0.978965)
     )

;;; 46 odd -------------------------------------------------------------------------------- ; 6.7823
#(46 8.2970391011104 #(0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 1 0 1 0)
     8.1455316543579 #(0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1)

     6.709237 #(0.000000 0.588728 0.764172 0.948247 0.778447 1.268756 0.080491 -0.381973 0.448541 1.688302 0.583900 0.609230 0.913000 1.244782 0.098190 0.458033 0.787717 0.012905 0.854674 1.035325 1.255759 0.507374 1.208176 0.514489 0.741105 1.441899 0.585374 1.583344 0.643511 1.525932 1.201616 0.846916 0.319659 0.030560 0.895113 0.341984 -0.007305 1.588064 0.007988 0.334683 0.349739 -0.215667 -0.068989 1.488454 0.988215 0.867211)
     )

;;; 47 odd -------------------------------------------------------------------------------- ; 6.8556
#(47 8.4595276184949 #(0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 0 1)
     8.336971282959  #(0 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 1 0)

     6.785244 #(0.000000 0.898263 0.698671 0.821497 0.370262 0.536725 0.016930 1.555315 1.553643 1.249848 -0.203480 1.765177 0.026588 0.111231 -0.039332 0.662791 0.096267 1.286138 1.353013 0.226230 0.057438 1.648120 -0.088502 0.524016 1.306955 -0.084552 0.350695 1.753518 1.303444 0.678968 0.693452 0.498589 1.005882 1.660165 0.430707 0.068634 0.587061 1.130543 1.939600 0.152146 1.459634 0.723147 1.428638 0.763075 1.800028 1.481715 0.488673)
     )

;;; 48 odd -------------------------------------------------------------------------------- ; 6.9282
#(48 8.35563071219336 #(0 1 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1)

     6.828028 #(0.000000 0.998004 1.077433 0.148071 1.527370 -0.144913 1.645316 1.723923 0.412024 1.174877 0.494923 1.411660 0.605628 1.628272 1.064698 1.228914 0.098971 0.692407 0.395792 1.297327 -0.001580 1.140646 1.342219 1.577941 0.241000 1.510351 1.184692 1.697190 1.378912 1.591005 -0.082196 0.468455 0.883072 0.625939 0.755107 0.095773 0.293743 0.637279 1.770381 1.345208 0.924216 0.393583 0.137327 1.278382 0.157871 0.442417 0.371701 -0.029442)
     )

;;; 49 odd -------------------------------------------------------------------------------- ; 7
#(49 8.57458718352971 #(0 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0)

     6.990085 #(0.000000 -0.164573 0.064173 1.159473 1.338282 0.224180 0.048446 -0.092188 1.330797 1.727540 0.871224 0.492473 0.773133 1.548572 0.177790 0.784854 1.699457 1.313478 1.727541 1.406322 1.009787 0.643130 1.162870 0.987477 1.316457 -0.175756 0.076378 1.241288 1.483083 1.781489 0.939535 0.040638 -0.010657 1.151404 0.905018 1.771955 1.158390 1.424788 0.818223 1.841437 0.476721 1.452980 0.759090 0.411734 1.319163 0.058919 0.263536 0.090298 0.204038)
     )

;;; 50 odd -------------------------------------------------------------------------------- ; 7.07
#(50 8.7349090576172 #(0 0 1 1 1 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 1 1 0 1)
     8.7194833755493 #(0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1)
     8.711 #(0 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1)

     6.947137 #(0.000000 1.361221 1.058873 0.255818 1.371652 1.848584 -0.002271 1.052656 0.139885 0.680884 0.885258 1.006144 1.663943 1.665052 1.470510 1.693036 0.091983 0.825894 1.755289 1.033123 0.055566 1.508725 0.691199 1.233170 0.641006 1.442066 1.557992 1.909688 0.175284 1.577225 1.678517 1.358807 1.558359 1.883371 1.133931 1.053187 0.137949 1.901321 0.058023 0.971798 1.378739 0.843519 0.357409 0.498187 1.235125 0.734586 0.653589 0.242791 1.085625 -0.043484)
     )

;;; 51 odd -------------------------------------------------------------------------------- ; 7.141
#(51 8.7549686431885 #(0 1 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 1 1 0 0)
     8.5829010009766 #(0 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0)

     7.087726 #(0.000000 0.875029 0.865937 0.367918 1.900818 0.762934 0.081270 0.353365 0.070375 -0.037477 1.275772 -0.100171 1.088567 1.481918 0.798713 1.260047 0.731048 1.035501 1.384103 0.728234 0.608922 1.769831 1.228331 0.727930 1.038826 -0.062865 0.731133 1.490525 1.564219 0.530975 0.845759 -0.127106 1.209031 0.537607 1.042200 0.906452 -0.105250 0.353212 0.368083 1.395843 1.206034 1.694293 0.348968 0.222228 0.523051 0.375570 0.283017 1.406111 0.934909 0.587260 0.940073)
     )

;;; 52 odd -------------------------------------------------------------------------------- ; 7.211
#(52 9.0527429580688 #(0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0)
     8.8599758148193 #(0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 1 0 0 0 1)

     7.080087 #(0.000000 0.216994 0.815073 0.651401 0.471967 0.035007 -0.067747 0.660856 0.580235 0.052345 1.785696 0.529423 0.205578 -0.247148 1.238971 0.096672 0.952857 0.166426 0.759284 1.719458 0.161518 1.592928 0.883009 0.245604 1.208605 0.995562 0.029395 0.487673 1.152615 0.362903 0.721410 0.862934 0.090743 0.014994 0.082182 0.993529 1.056537 1.708353 0.746025 -0.333233 1.155949 0.740213 0.619117 1.020646 1.502770 1.347142 1.371490 1.480724 0.363059 1.828476 0.147552 0.424061)
     )

;;; 53 odd -------------------------------------------------------------------------------- ; 7.280
#(53 9.2427225112915 #(0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 1 1 1)
     9.1345848658318 #(0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1)
     9.127 #(0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 1 1 0)
     9.037 #(0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0)

     7.252601 #(0.000000 1.316368 0.101159 0.287376 -0.120486 -0.146148 -0.293575 0.279566 1.566833 0.692861 -0.116203 1.111486 1.592177 1.082742 0.010661 0.754630 0.400780 0.795713 1.670109 1.185717 1.226796 -0.120012 0.262637 0.206364 0.738299 0.157263 0.604374 0.683095 1.946305 -0.043066 0.580881 1.320138 -0.043078 1.307240 1.171743 0.356072 0.398418 -0.096678 0.059824 1.235855 0.057573 -0.031810 1.322088 0.600804 1.405030 -0.237620 -0.007423 -0.083489 1.021491 1.628805 -0.222749 0.516076 0.301362)
     )

;;; 54 odd -------------------------------------------------------------------------------- ; 7.348
#(54 9.3444428264144 #(0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1)   
     9.025 #(0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0)

     7.329312 #(0.000000 0.351739 1.363055 0.097866 1.595965 -0.031621 1.223437 1.245795 0.697126 0.969411 0.163431 1.058197 0.540303 0.010799 0.315862 -0.095418 1.225457 -0.107067 0.248144 0.434422 1.750004 0.123968 0.094562 1.557111 1.218362 1.414702 0.342118 0.690465 1.846293 1.658303 0.531174 1.423356 0.398528 0.613245 1.927498 0.675629 0.534008 1.080504 0.634299 -0.022567 1.283631 0.612696 0.825441 1.798942 1.266262 0.442581 0.838484 1.350811 1.194061 1.784713 -0.134977 0.098913 0.583789 0.361397)
     )

;;; 55 odd -------------------------------------------------------------------------------- ; 7.416
#(55 9.3425494397445 #(0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 1 0)
     9.2039985656738 #(0 0 1 1 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)

     7.364233 #(0.000000 0.395190 -0.153867 1.307052 0.778840 1.201427 1.584425 -0.091689 1.563398 0.221226 1.485388 0.595790 -0.041635 0.380534 0.103234 0.445988 1.706774 1.178799 1.315522 1.096083 0.260274 -0.072891 0.228062 0.239593 1.575799 0.203611 0.427975 1.251992 1.620128 0.666682 0.636489 0.025180 0.388251 0.546392 1.107252 0.996609 1.708598 0.607806 -0.354744 1.114522 1.187212 0.060556 1.020751 1.136440 0.719385 1.579705 0.166783 0.736570 0.421572 0.534881 0.141987 1.649951 0.500500 0.386302 -0.074892)
     )

;;; 56 odd -------------------------------------------------------------------------------- ; 7.483
#(56 9.5274312814935 #(0 0 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0)
     9.3816785812378 #(0 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 0)

     7.419120 #(0.000000 0.417128 1.082491 1.276854 0.765982 1.295111 1.835030 1.786443 0.675192 1.020185 0.394420 0.359608 0.697463 1.166247 0.564899 1.087103 0.889865 0.844186 1.419287 1.562675 0.248998 1.869468 1.111986 1.294693 1.863255 0.052934 0.338636 1.626312 1.601681 -0.021561 1.462490 1.791020 0.409025 1.675990 1.011444 1.359048 1.605820 1.247285 1.024241 0.457113 0.153603 0.242127 1.175155 0.206257 1.412766 1.496703 -0.140135 1.270904 0.393803 1.315634 0.897708 1.585792 0.563930 1.722379 1.612675 1.047507)
     )

;;; 57 odd -------------------------------------------------------------------------------- ; 7.549
#(57 9.5457010269165 #(0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0)
     9.543363571167 #(0 1 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1)
     9.3903837203979 #(0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 0)

     7.488896 #(0.000000 -0.127939 1.380652 0.701541 0.779535 0.090662 1.662797 0.879717 1.570316 1.307786 1.211090 0.971455 0.738042 1.474139 1.501173 1.322773 -0.333947 0.651999 1.407414 0.559437 0.970911 0.613447 1.441437 0.387240 1.769723 0.695953 -0.175580 0.102181 0.180022 1.529463 0.468743 0.084931 0.062956 0.298511 0.524008 0.924744 1.286647 1.428978 0.334028 1.302926 0.807711 0.283976 0.097723 1.284073 0.038191 0.329167 1.275797 0.351298 1.518403 1.571791 0.227818 0.842734 0.707030 0.435243 0.618490 0.867851 1.852691)
     )

;;; 58 odd -------------------------------------------------------------------------------- ; 7.6157
#(58 9.7054271697998 #(0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1)
     9.6265433375878 #(0 1 1 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1)
     9.5893135070801 #(0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0)

     7.588141 #(0.000000 0.516748 -0.136186 1.326262 0.394312 0.908336 0.526212 1.062877 1.237119 1.277388 1.783022 1.592124 0.539013 1.423986 1.604063 0.377519 0.890060 1.361066 1.917245 1.466235 0.488204 0.037073 1.362105 1.047070 0.701943 1.227802 0.064639 0.349075 0.483328 1.187781 1.000952 0.893065 0.200465 0.208401 1.801615 1.050197 -0.101204 1.813524 1.482790 -0.163336 1.425001 0.560709 -0.223866 0.436937 1.101224 0.466240 0.283139 1.511423 0.399414 1.608830 -0.048028 1.496480 -0.267355 0.338595 0.923916 0.218669 1.902345 -0.037474)
     )

;;; 59 odd -------------------------------------------------------------------------------- ; 7.681
#(59 9.955 #(0 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0 0)
     9.6750946044922 #(0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1)
     9.5173864364624 #(0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0)

     7.617785 #(0.000000 1.762340 0.513621 1.350480 0.395272 0.369068 0.305583 0.831518 1.232517 0.676844 0.014044 1.888953 1.633364 1.298874 0.424500 1.402106 0.715815 1.275937 1.488547 1.873193 1.738228 0.570388 0.057875 1.975863 0.297300 1.563912 0.772704 0.090655 0.241787 1.145030 0.785784 1.432008 1.006607 1.408581 0.812224 0.224382 0.926131 0.944185 -0.064326 0.205583 1.060366 0.673429 1.237483 1.421583 0.464247 1.651757 1.984268 1.030220 1.489122 1.350599 0.646010 1.371095 0.262034 0.720620 1.557135 1.181053 0.745491 0.926931 1.443337)
     )

;;; 60 odd -------------------------------------------------------------------------------- ; 7.7459
#(60 9.8824768066406 #(0 1 0 1 1 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 0)
     9.6560277938843 #(0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0)

     7.699628 #(0.000000 -0.021305 0.599580 1.675097 0.724803 0.358532 0.890770 0.765518 0.237166 0.821603 0.185949 0.996346 -0.076908 1.733595 1.718331 -0.080896 1.631867 0.229557 1.219113 -0.444442 1.509828 0.286787 0.741904 1.151478 1.816287 -0.008152 -0.169986 1.514652 0.248473 1.296089 1.211441 0.399013 0.342384 1.801962 0.377537 0.181714 1.809056 1.599925 0.494049 0.298590 0.110648 0.855221 1.804868 0.666943 1.224265 1.636192 1.425598 0.559152 0.087897 0.972335 -0.105600 1.103327 1.345409 0.428767 -0.084957 1.609410 0.060258 0.846549 0.678506 0.580784)
     )

;;; 61 odd -------------------------------------------------------------------------------- ; 7.8102
#(61 9.9989261627197 #(0 0 0 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1)
     9.9643812179565 #(0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1)
     9.8069976254571 #(0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 0 0 0)
     9.6689287776524 #(0 0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1)

     7.775467 #(0.000000 -0.343145 0.781525 1.809127 0.251480 0.512435 0.079273 1.157280 0.819596 0.391398 -0.518556 1.678636 0.560600 0.125318 0.035700 1.744672 1.824327 1.087291 1.692006 0.706036 0.269610 1.403225 1.233897 0.487088 1.476172 -0.284871 0.794501 1.368364 0.656660 0.974817 1.000338 0.175726 1.024682 0.865508 0.404847 0.718158 0.071740 1.457732 -0.480756 0.735357 1.217441 0.811494 1.022056 0.829877 1.509011 1.174960 1.639594 0.781475 -0.011943 1.221853 -0.208689 0.133149 0.650142 1.217107 -0.446658 0.092120 -0.062880 0.676055 0.910707 0.946198 0.780527)
     )

;;; 62 odd -------------------------------------------------------------------------------- ; 7.8740
#(62 10.200 #(0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0)
     10.048614501953 #(0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1)
     9.8772821666628 #(0 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0)
     9.7982149124146 #(0 0 1 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0)

     7.816985 #(0.000000 0.185485 -0.254761 0.263400 0.632430 0.127767 1.483161 1.282005 1.556675 0.709224 0.293439 0.049467 -0.087443 1.425471 0.595679 0.678957 0.447779 0.382124 0.717681 0.082649 -1.563917 -0.140691 0.229960 0.339346 0.083428 0.640485 0.923623 -0.076532 1.385224 0.166806 1.518517 1.222370 1.575074 0.899045 0.324075 1.508603 -0.064272 0.115115 0.407781 0.298344 1.252368 1.084082 0.264721 0.922346 1.331199 0.689780 0.795795 1.526817 0.163429 0.888100 0.510259 1.478381 0.318687 1.341508 1.785614 0.798865 0.525568 1.053899 1.308203 0.410567 -0.026960 1.103176)
     )

;;; 63 odd -------------------------------------------------------------------------------- ; 7.9372
#(63 10.203475952148 #(0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 1 0)
     10.191082449969 #(0 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 1 0)
     9.8550319671631 #(0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 1 0)

     7.904133 #(0.000000 1.545501 0.155683 0.898914 0.625696 0.564119 0.345790 0.703891 0.981672 1.014462 1.740323 0.008567 -0.039871 0.470077 1.202746 0.366398 0.367999 1.293490 0.310624 1.016687 1.843528 0.474437 1.864085 0.859066 0.880435 1.525047 0.949229 0.065485 0.658928 0.625456 0.890422 0.157110 0.668174 1.537633 -0.133525 1.887056 1.094821 1.580831 1.506736 1.621226 1.791740 1.492769 0.830911 0.166732 1.797834 0.044991 1.834240 1.000450 1.479368 0.610232 0.816463 1.240492 0.107919 -0.111385 1.348751 1.167090 0.907202 0.154866 1.422414 0.720983 0.430601 -0.041659 0.656229)
     )

;;; 64 odd -------------------------------------------------------------------------------- ; 8
#(64 10.559404013831 #(0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 1 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0)
     10.301 #(0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1)
     10.113667488098 #(0 1 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 0 0 0 0 0 1)
     10.022200584412 #(0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 0 1)
     10.0 #(0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0)

     7.957414 #(0.000000 0.941670 0.218463 1.054436 0.821282 0.779097 1.084317 0.220811 0.530574 -0.001214 1.277468 1.056444 1.434429 0.244804 0.635637 0.374642 1.294283 0.051882 1.563945 0.856817 0.659797 0.848723 0.789207 0.004337 0.642492 -0.752744 0.794434 0.546992 1.340010 0.716341 1.722360 1.081100 1.009399 0.345867 1.393328 1.377443 1.264631 0.487017 1.142544 0.031648 0.469271 -0.098334 -0.019627 0.567023 1.791954 0.511740 0.421519 0.992945 1.133377 1.668348 -0.054246 0.158608 -0.042808 1.772093 0.331126 0.762153 1.499580 1.813299 1.079657 1.088576 0.368377 1.519001 0.864479 0.914946)
     )

;;; 65 odd -------------------------------------------------------------------------------- ; 8.0622
#(65 10.517309434908 #(0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1)
     10.169842720032 #(0 0 1 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1)

     8.044753 #(0.000000 1.512463 1.425803 1.698466 1.501683 1.180897 -0.085002 1.276313 0.247368 1.453837 1.114229 0.402369 0.070703 0.505008 0.788829 1.682291 -0.027473 0.150401 0.261684 0.575835 1.904190 0.050057 1.634210 1.088971 1.405971 1.615167 0.542032 1.593593 0.704715 1.184830 1.723465 0.255847 -0.286792 0.361726 1.805927 1.245465 1.638035 1.268898 1.405162 0.049912 1.071155 0.033445 0.084923 0.129350 0.852108 1.223537 1.270369 0.841833 0.943137 1.723105 0.176866 0.955128 1.524504 1.306059 0.466655 -0.022545 1.792414 1.039037 0.490191 1.800964 0.198517 1.249555 0.566365 0.910107 0.857592)
     )

;;; 66 odd -------------------------------------------------------------------------------- ; 8.1240
#(66 10.212840820553 #(0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 0)

     8.138581 #(0.000000 0.866942 -0.091637 0.942335 0.984326 1.120858 -0.061285 0.797722 1.394513 1.715163 0.173841 1.493202 0.091134 -0.054093 0.779246 -0.176694 1.507558 0.929619 0.551020 0.709182 -0.228554 0.808434 0.021797 1.139843 0.188468 1.460722 1.589241 0.461836 1.666041 1.373367 0.709169 0.826732 0.307933 0.059434 1.518188 1.451271 1.679200 0.263769 0.281327 0.107733 0.991368 -0.062831 1.163827 0.343008 0.649387 1.140403 0.631742 0.963337 1.935902 0.002225 1.504426 0.075847 0.786205 1.101903 1.156645 1.692930 1.813654 1.292994 1.326685 1.731842 1.606847 1.133992 0.873835 1.252611 1.512790 0.968938)
     8.138125 #(0.000000 0.866892 -0.091612 0.942285 0.984501 1.120808 -0.061235 0.797897 1.394463 1.715263 0.173891 1.493127 0.091184 -0.054068 0.779246 -0.176694 1.507558 0.929619 0.551020 0.709182 -0.228654 0.808434 0.021797 1.139843 0.188468 1.460722 1.589241 0.461836 1.666041 1.373367 0.709169 0.826732 0.307933 0.059434 1.518188 1.451271 1.679200 0.263769 0.281327 0.107733 0.991368 -0.062831 1.163827 0.343008 0.649387 1.140403 0.631742 0.963337 1.935902 0.002225 1.504426 0.075847 0.786205 1.101903 1.156645 1.692930 1.813654 1.292957 1.326685 1.731842 1.606847 1.133992 0.873835 1.252611 1.512790 0.968938)
     )

;;; 67 odd -------------------------------------------------------------------------------- ; 8.1853
#(67 10.718281745911 #(0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1)
     10.287303318203 #(0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 0 1)
     10.209677696228 #(0 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 1)

     8.127999 #(0.000000 0.156189 0.759312 0.316632 1.612933 0.605013 0.952530 0.423099 -0.112233 1.447269 0.863131 0.200670 1.538179 0.172873 0.737196 0.916694 1.524894 1.423218 1.337268 0.799228 0.023760 0.359774 1.033535 1.252717 0.399347 1.736421 0.199827 0.358145 1.847858 -0.157369 -0.118965 -0.296280 1.764663 0.918422 0.547247 0.781682 -0.101912 1.939111 1.078792 1.928250 0.777073 0.358591 1.566766 0.658960 0.895914 1.285541 1.636763 -0.098157 1.684110 0.891684 1.386081 0.068089 0.497477 0.528377 0.140207 0.953073 0.655659 0.018618 0.774991 0.503967 1.384065 0.100041 0.959741 0.153740 0.654728 0.200720 0.384936)
     )

;;; 68 odd -------------------------------------------------------------------------------- ; 8.24621
#(68 10.698028101377 #(0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 0 1 1)
     10.359804316765 #(0 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 0 1 0)

     8.227899 #(0.000000 0.286807 1.636936 0.913213 0.670336 0.328654 0.246136 0.137092 0.771244 0.020961 1.324640 0.954343 1.084876 0.872701 0.283914 1.694341 0.472896 0.749346 0.775906 0.819824 1.601908 1.300740 0.415230 0.511035 1.014539 0.551639 1.246964 0.003220 0.286294 0.258910 0.059314 0.707778 0.359123 0.896419 0.581441 0.437950 1.243584 1.693191 0.780957 1.534343 -0.139956 0.644656 1.658338 0.850299 -0.010619 1.614776 1.679548 1.052764 1.431211 0.975031 1.747594 0.516417 0.357368 1.159436 -0.221237 0.714651 0.161719 1.479044 1.651230 0.021689 0.291741 1.854548 1.422861 0.383054 0.985559 1.342793 0.716436 0.486585)
     )

;;; 69 odd -------------------------------------------------------------------------------- ; 8.3066
#(69 11.012202262878 #(0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 1)
     10.744618415833 #(0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1)
     10.636575441359 #(0 0 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1)
     10.452348709106 #(0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1)

     8.274908 #(0.000000 1.788801 1.283513 -0.242756 0.145250 0.146755 0.584479 1.353542 0.821070 0.189803 1.413669 0.749926 1.058442 1.185407 1.095039 1.015258 0.161858 0.034929 0.498704 0.198138 1.711445 0.157768 0.616185 1.421248 1.168404 0.254474 1.519482 -0.175837 0.581687 0.194579 0.931780 -0.336100 0.287461 1.495068 0.039168 1.507647 0.993152 1.382317 1.231363 0.721890 1.622206 1.080570 0.186638 0.155662 0.909604 1.203958 1.050254 1.890059 0.428940 0.701250 -0.160137 0.279994 1.502298 0.567568 0.585424 0.686015 -0.246566 0.662061 0.986133 1.103373 0.572438 0.607162 -0.159332 0.926622 1.112278 0.937694 0.624990 1.345312 0.670451)
     )

;;; 70 odd -------------------------------------------------------------------------------- ; 8.3666
#(70 11.087729454041 #(0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 1 1)
     10.431521047498 #(0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 1)

     8.328488 #(0.000000 1.209391 0.655351 -0.224668 0.270551 0.912782 1.006468 0.115362 1.639506 1.394128 1.775544 -0.158964 -0.191285 0.916307 -0.148807 -0.343643 0.171981 0.447415 0.684977 -0.187759 0.122627 0.642332 0.846737 0.920787 0.824105 -0.455822 1.004331 0.650453 0.327784 -0.378239 0.335174 0.883411 0.475111 1.924029 1.429019 1.351303 -0.183533 1.395982 0.599233 0.896200 1.135652 0.575692 1.213789 1.853140 0.377792 1.790714 0.835251 1.493542 0.305236 1.538414 0.647163 0.263422 1.348466 1.037276 0.893701 1.108073 -0.492190 -0.249170 1.081128 0.973414 0.593299 0.786885 0.003725 0.855855 1.605169 1.050037 0.831705 1.193285 0.128148 0.709803)
     )

;;; 71 odd -------------------------------------------------------------------------------- ; 8.4261
#(71 11.111848131381 #(0 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1)
     11.002258540604 #(0 0 0 0 0 1 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 1 1 0 0)
     10.642364501953 #(0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 0)

     8.477170 #(0.000000 1.240440 0.752058 1.905714 0.007212 0.112054 -0.131785 1.588035 0.183930 0.768888 1.141613 0.824049 0.830266 0.743392 -0.275429 0.323983 1.096472 0.414994 1.671445 1.205638 0.981213 1.539185 1.843952 1.813875 1.493660 1.725853 0.530086 1.372959 0.848266 0.442962 1.149711 1.770217 -0.171141 0.709766 -0.055396 1.108317 1.554862 -0.109268 0.104880 0.994085 1.004164 0.449466 1.033543 1.366133 1.611016 -0.047540 1.214396 1.135534 1.182536 1.359043 0.750295 1.079172 1.185332 0.272785 1.419014 0.404681 1.092212 -0.188793 0.856627 0.123616 -0.055286 1.073444 1.267954 0.522273 1.879002 0.238846 -0.053537 1.527695 1.495988 0.440044 1.847473)
     )

;;; 72 odd -------------------------------------------------------------------------------- ; 8.4853
#(72 11.026193997702 #(0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1)
     10.912703440154 #(0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1)
     10.880306243896 #(0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 0 0 0 1)

     8.366430 #(0.000000 1.529157 0.709835 0.191619 0.777505 1.673931 1.052039 1.157229 0.197845 1.188203 0.205209 0.808312 1.907251 0.734102 1.471024 1.752009 0.976735 0.215092 1.669497 0.039070 0.308185 0.805661 0.414650 0.685942 0.933087 1.104471 0.869537 0.010581 1.431457 1.039490 0.654718 0.051163 1.637896 0.041328 0.434461 1.596916 0.630066 0.513683 1.126090 1.472280 0.029687 0.729904 0.900726 0.364456 0.829387 0.775767 0.087943 1.122617 0.054278 0.980310 0.814649 1.331669 0.404897 1.438813 0.751132 1.069103 1.033498 0.950755 0.588560 0.206118 0.697556 1.364322 0.007771 0.225318 -0.029948 1.266843 1.008881 -0.515131 0.251545 0.235634 0.009431 1.881826)
     )

;;; 73 odd -------------------------------------------------------------------------------- ; 8.5440
#(73 11.087996391987 #(0 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1)
     10.907942771912 #(0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1)

     8.558305 #(0.000000 1.480855 0.402754 -0.003088 1.138586 1.533495 0.084344 -0.228035 0.976401 1.318604 1.722730 -0.020908 0.243408 1.584604 0.062358 0.462119 0.754724 1.120814 0.583539 1.645548 0.496944 0.434535 1.292100 0.600701 -0.190681 0.076118 0.094895 1.344004 1.515768 0.073925 1.477472 1.408012 0.042935 0.417184 0.077015 0.402578 0.977872 0.572157 1.016016 1.217395 0.655590 0.746379 0.249659 0.574395 -0.200894 0.425938 0.207638 1.429560 0.681050 1.128783 0.383277 0.107153 0.285286 1.176926 1.265876 0.597708 0.119823 -0.141364 -0.011359 0.306566 1.731834 0.331345 0.693333 -0.253511 1.434854 1.148251 0.258472 1.513303 0.273687 0.979819 0.290223 1.602954 0.007342)
     8.558282 #(0.000000 1.480862 0.402744 -0.003027 1.138609 1.533447 0.084331 -0.228024 0.976394 1.318582 1.722730 -0.020943 0.243414 1.584651 0.062349 0.462148 0.754721 1.120762 0.583497 1.645538 0.496950 0.434535 1.292100 0.600701 -0.190681 0.076118 0.094895 1.344004 1.515768 0.073925 1.477472 1.408012 0.042935 0.417184 0.077015 0.402578 0.977872 0.572157 1.016016 1.217395 0.655590 0.746379 0.249659 0.574395 -0.200870 0.425938 0.207638 1.429560 0.681050 1.128783 0.383277 0.107153 0.285286 1.176926 1.265876 0.597708 0.119823 -0.141364 -0.011359 0.306566 1.731834 0.331345 0.693333 -0.253511 1.434854 1.148251 0.258472 1.513303 0.273687 0.979819 0.290223 1.602978 0.007342)
     )

;;; 74 odd -------------------------------------------------------------------------------- ; 8.6023
#(74 11.4198214166449 #(0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 0)
     11.288741871055 #(0 0 1 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 1 0)
     11.262331896     #(0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0)

     8.487915 #(0.000000 0.229202 0.328610 0.886519 0.913243 -0.092303 1.469261 1.392280 0.102684 0.875868 1.119399 -0.375546 1.138609 1.792722 0.270873 0.158504 1.300583 0.337402 0.457798 0.994721 0.720190 1.266403 1.157785 0.204200 0.832717 1.368187 -0.207911 0.551921 0.143469 0.767289 -0.041673 0.248888 0.686134 1.808117 1.719833 1.634354 -0.372228 1.923379 1.132948 1.667043 0.857041 1.387145 0.637791 -0.326159 0.280564 1.478231 0.572776 0.063470 1.115045 1.234238 1.093760 0.166042 1.189669 0.933614 0.159392 1.594960 1.079073 1.251388 1.747471 1.137640 1.343339 1.096317 0.655141 0.037576 1.286106 -0.396608 1.310863 1.072774 0.013655 0.220749 -0.215382 0.087335 1.489739 0.952386)
     )

;;; 75 odd -------------------------------------------------------------------------------- ; 8.6603
#(75 11.202813597023 #(0 0 0 1 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 1 1)
     11.190553665161 #(0 0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1 1)
     10.942812919617 #(0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 0 1 1)

     8.651331 #(0.000000 1.110787 1.874383 -0.024932 0.873791 0.093797 0.966691 0.182278 1.799644 0.765547 1.706990 0.245092 0.917620 -0.032301 0.074728 1.465055 -0.541993 1.310570 1.354075 0.936694 0.141657 0.972446 1.649078 0.074998 0.306029 1.082120 -0.054388 -0.033988 0.418208 0.003235 0.511328 0.332435 0.923172 0.576919 0.862095 0.517667 0.508351 0.091228 1.846528 0.266335 1.635971 0.771938 1.707550 0.145318 0.983709 1.756811 1.504773 0.044223 0.093313 0.323458 0.881556 1.062335 1.254244 0.310921 1.866251 0.311380 1.581776 1.908863 0.733800 1.787300 0.038613 0.024122 0.921540 0.856353 0.318481 1.739538 1.289723 0.868851 -0.237512 1.530691 1.358161 0.609877 0.671740 0.983088 0.033220)
     )

;;; 76 odd -------------------------------------------------------------------------------- ; 8.7178
#(76 11.511628975629 #(0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 1 0 0)
     11.446428749262 #(0 0 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0)
     11.21743106842 #(0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 0 0 0)

     8.651279 #(0.000000 0.173353 0.839453 0.789458 1.213196 0.485342 1.020793 1.079117 1.510944 0.872759 1.658963 0.469539 1.282086 0.224500 1.187595 1.001928 0.601189 0.457802 1.523606 0.013310 0.486526 1.038767 0.887428 0.818932 0.429987 0.518887 0.949464 1.376735 0.275451 0.805159 0.132159 1.431344 0.575428 0.009721 1.711880 1.360202 0.416637 0.859810 0.491831 0.882963 0.253397 0.012929 1.530000 0.177927 1.883242 1.959160 0.357646 1.604277 0.939839 1.031583 0.502599 0.924357 -0.060587 1.148550 0.762073 0.585290 1.515308 1.022656 0.505967 0.958132 1.937796 0.289650 0.388753 1.349929 0.430727 1.688517 1.350532 0.156971 0.890960 0.708951 1.606885 1.582622 1.628222 1.565608 0.127771 0.825769)
     )

;;; 77 odd -------------------------------------------------------------------------------- ; 8.7750
#(77 11.623893901139 #(0 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1)
     11.38523739395 #(0 0 1 0 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 1)
     11.302083969116 #(0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1)
     11.192246437073 #(0 1 0 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0)

     8.707019 #(0.000000 1.733898 1.602888 1.700625 0.951967 1.205480 0.494785 0.079322 1.861432 1.411332 0.615577 0.456043 0.176616 0.522662 0.530871 0.948923 1.312747 1.035434 -0.217439 1.260792 0.366350 -0.233439 0.849314 1.174459 -0.193276 1.451248 0.290403 1.453670 0.668542 0.644436 1.306523 1.198202 0.657361 0.888118 1.964614 0.824349 -1.765380 0.784141 0.143386 -0.053030 0.033585 0.726269 -0.055055 0.121221 1.064245 1.578078 0.715470 -0.211778 1.194974 -0.095151 0.313319 0.914111 -0.007802 0.154723 0.086177 1.895682 1.191957 -0.344176 -0.285803 0.072705 0.944928 0.649978 0.107843 0.251480 -0.267013 1.016287 0.107966 1.055797 1.067984 1.857635 0.230948 0.492625 0.104053 0.572353 1.732176 0.353482 0.821975)
     )

;;; 78 odd -------------------------------------------------------------------------------- ; 8.8318
#(78 11.455265310659 #(0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 0 0)

     8.715270 #(0.000000 1.669247 0.757594 0.165819 0.288294 0.684770 0.557521 0.680526 1.097350 0.470057 1.849497 1.090608 0.922922 1.129049 0.104794 -0.129005 0.326960 -0.051784 1.142568 0.483331 0.896117 0.813482 0.302867 0.073158 -0.168821 0.656167 0.700004 1.004810 -0.007423 -0.189996 0.560929 0.412734 0.830296 1.110767 -0.043008 0.613326 0.576197 0.610404 1.233787 0.583712 0.887457 1.853983 1.162911 1.497407 0.204463 1.117898 1.731543 1.711291 0.816677 1.207698 1.691953 0.214296 -0.046452 0.692536 0.108168 0.208702 0.459557 1.630550 -0.229002 1.446147 1.208030 -0.028606 1.708585 1.336818 1.004606 0.393864 1.182948 -0.208442 1.255124 0.056920 1.572769 0.643674 1.170025 0.291140 1.025254 0.562266 0.633856 0.124004)
     )

;;; 79 odd -------------------------------------------------------------------------------- ; 8.8882
#(79 11.710210993982 #(0 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0)
     11.54291004024 #(0 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0)

     8.867762 #(0.000000 0.361330 0.038438 1.294996 -1.621546 1.174123 0.541181 0.399675 0.110060 0.618645 0.701291 1.117014 1.422998 1.210089 0.003062 1.620338 0.263829 0.011488 1.211087 1.600182 -0.058321 1.219518 0.202538 0.614884 0.760713 0.127942 1.246457 1.257717 1.114955 0.695791 1.169236 1.054682 -0.089287 1.026927 1.102347 1.491458 0.673992 0.948541 -0.158271 0.259573 1.334027 0.774178 1.528524 -0.081535 1.663948 1.490371 0.143924 1.058665 0.726371 1.145031 0.012814 0.600546 1.427968 1.325851 1.320582 -0.093957 0.487048 0.441091 1.225317 0.318609 0.334151 -0.008466 1.079972 1.504607 1.248892 0.215151 1.134157 1.248261 0.548506 1.075841 0.599824 0.779175 0.108750 1.331003 1.055692 1.059492 0.288082 1.670436 1.088283)
     )

;;; 80 odd -------------------------------------------------------------------------------- ; 8.9443
#(80 12.0 #(0 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 0 1 0)
     11.963202476501 #(0 0 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 0 1)
     11.681501776885 #(0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1)
     11.501195907593 #(0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 0 1 1)
     11.122416496277 #(0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 1)

     8.948092 #(0.000000 0.669470 0.585435 1.541755 0.373313 1.437385 0.293459 1.715288 1.162572 1.216836 0.354541 1.125148 0.412957 0.769877 0.135280 -0.231192 0.002943 0.871561 1.183767 0.565206 1.714884 1.044986 0.575371 0.182151 0.764300 -0.045423 0.160634 1.474190 0.659513 1.328229 0.873252 0.034671 1.246302 1.127573 0.146960 0.738327 1.087766 -0.088490 0.933612 0.126653 0.367799 1.496933 0.487026 0.857031 -0.113906 0.314514 0.831513 1.293157 1.439074 0.864911 0.384904 1.171276 0.491309 0.832410 0.093356 1.517381 1.191714 0.509791 0.485403 0.904183 1.391224 1.474363 0.115501 0.978007 0.595968 0.314183 0.560614 0.832213 1.363284 1.485761 1.658432 1.946619 -0.026770 -0.177080 1.694244 0.103988 -0.188925 0.023814 -0.360982 1.079265)
     )

;;; 81 odd -------------------------------------------------------------------------------- ; 9
#(81 11.757609887857 #(0 1 1 0 0 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1)
     11.553661099057 #(0 0 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1)
     11.381307601929 #(0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1)
     11.372210502625 #(0 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1)

     8.926326 #(0.000000 0.164735 -0.380225 0.081555 1.097918 1.524480 0.077656 0.977304 0.407700 0.831319 0.533822 0.615403 1.642513 -0.058036 0.444751 1.446330 0.995710 0.841112 0.528746 0.832226 0.248085 0.502898 1.190162 0.745146 -0.208212 0.492995 1.110378 0.980131 0.817203 1.338834 1.000001 1.336192 1.804389 0.900670 0.555661 1.748659 0.603816 0.728857 -0.167279 1.058563 1.176033 1.277029 1.122180 1.127499 -0.224172 0.316000 1.080199 0.508511 0.252234 0.338999 0.400496 1.857653 0.607017 0.245631 0.807136 -0.037588 -0.063570 1.552479 1.126540 0.180335 0.976685 0.410774 1.244176 1.541645 1.450598 0.050542 0.208414 1.102430 0.959489 0.189328 0.354550 1.724776 1.384943 0.545643 1.965929 0.479461 0.756949 1.038515 -0.004640 1.477899 0.906680)
     )

;;; 82 odd -------------------------------------------------------------------------------- ; 9.0554
#(82 11.815696616621 #(0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0)
     11.662058134504 #(0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 0 0)

     8.895498 #(0.000000 1.650756 0.929235 0.669074 0.458613 1.575883 1.406092 1.106790 0.596730 0.021347 1.134970 0.616933 1.701827 0.504785 1.614982 1.519418 0.470952 1.289129 0.059550 0.427695 0.231422 1.559220 0.383709 0.161407 0.068209 -0.031038 1.865998 -0.109083 1.124535 0.249567 0.520329 0.463755 1.759816 0.122747 -0.063135 1.879507 0.089457 0.845717 1.061947 -0.248630 -0.240924 0.207853 1.548893 0.621489 0.599673 1.031885 -0.104736 1.726398 0.898686 0.128558 0.928155 1.723232 0.730130 1.329452 0.779285 1.207734 0.370523 1.269134 1.812531 0.562255 0.696469 1.440871 0.214062 1.838981 0.082605 1.605017 1.504365 0.122097 0.273097 0.895327 0.555120 -0.358045 0.959494 0.864915 1.049696 1.458692 1.063317 -0.105762 0.240946 0.516137 0.295184 -0.035654)
     )

;;; 83 odd -------------------------------------------------------------------------------- ; 9.1104
#(83 12.05688291879 #(0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1)
     11.795211509729 #(0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1)
     11.732900669843 #(0 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1)

     9.060733 #(0.000000 0.847614 1.074595 0.345210 0.202371 1.511917 1.112425 0.572830 1.582187 0.218687 0.979697 0.829284 0.504832 0.409321 1.581223 1.031036 0.666780 1.347208 1.680503 1.486577 0.618089 -0.256946 0.905019 0.230952 0.059969 -0.145434 0.545921 0.384376 1.384380 0.665205 1.583895 0.055621 1.669433 1.386960 1.917214 0.552314 1.477586 0.229404 -0.049820 0.210015 -0.192839 1.819422 0.656731 1.258726 0.062676 0.649682 -0.033937 1.076469 0.763030 0.654748 1.032680 0.850557 0.101236 1.303860 1.683735 0.917766 1.133625 0.788918 0.091033 0.752267 0.650807 0.661591 0.956487 -0.151184 1.699725 0.067039 0.562858 0.669739 1.945082 0.507537 0.168655 1.291963 1.367257 0.073343 1.018407 0.584241 1.284655 0.733315 0.794277 0.838058 0.819351 1.776021 0.236189)
     )

;;; 84 odd -------------------------------------------------------------------------------- ; 9.1652
#(84 12.003616535189 #(0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1)
     11.724502770898 #(0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1)
     11.626023292542 #(0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1)

     9.188976 #(0.000000 -0.024434 -0.040539 1.164665 1.900022 0.946475 0.647249 1.863147 1.926736 0.124895 0.553682 0.966063 -0.072068 1.074212 1.816451 1.287276 1.050164 0.802063 0.602827 0.428737 0.506032 1.307650 1.611972 -0.515816 0.752141 1.701134 1.584602 0.520405 0.491322 0.836192 1.700561 0.271777 1.850965 1.869065 0.836555 0.279505 1.080872 1.440812 0.955127 1.282128 1.016780 1.663729 1.604853 1.116639 0.771625 0.685398 0.023405 0.691841 0.538776 0.839054 0.012757 1.099485 0.327593 0.615620 0.200517 -0.093738 0.909843 0.523563 1.084106 1.001180 0.727308 0.930030 0.304685 0.356903 0.974646 0.001353 -0.520379 0.526712 0.569702 0.272840 1.271087 0.822066 1.530566 1.322491 0.210979 1.078087 1.318434 0.087549 1.348572 1.889259 0.413554 1.231476 1.449028 0.371498)
     9.188933 #(0.000000 -0.024459 -0.040576 1.164666 1.900042 0.946441 0.647204 1.863170 1.926780 0.124879 0.553692 0.966063 -0.072081 1.074249 1.816454 1.287310 1.050144 0.802036 0.602834 0.428710 0.506032 1.307650 1.611972 -0.515816 0.752141 1.701134 1.584602 0.520405 0.491322 0.836192 1.700561 0.271777 1.850965 1.869065 0.836555 0.279505 1.080872 1.440812 0.955127 1.282128 1.016780 1.663729 1.604853 1.116639 0.771625 0.685398 0.023405 0.691841 0.538776 0.839054 0.012757 1.099467 0.327593 0.615620 0.200517 -0.093738 0.909843 0.523590 1.084106 1.001180 0.727308 0.930030 0.304685 0.356903 0.974646 0.001353 -0.520379 0.526712 0.569702 0.272840 1.271087 0.822066 1.530566 1.322491 0.210979 1.078087 1.318434 0.087549 1.348572 1.889259 0.413554 1.231476 1.449028 0.371498)
     )

;;; 85 odd -------------------------------------------------------------------------------- ; 9.2195
#(85 12.48290348053 #(0 1 1 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1)
     12.309050256429 #(0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1)
     11.829360154975 #(0 0 0 1 0 0 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1)

     9.172932 #(0.000000 1.198268 -0.046093 0.496651 0.155499 0.438914 1.717129 -0.153996 0.255959 0.942459 -0.112043 1.664994 1.597976 1.071752 0.293731 1.489898 -0.088206 1.402767 1.814932 1.099748 -0.400724 1.351064 1.265640 1.075629 0.060651 -0.371046 0.814537 0.326687 0.633977 1.654428 1.582553 0.618025 1.054016 1.391986 1.098803 0.284271 1.476963 1.042434 1.922088 0.305413 -0.626240 1.791879 1.777727 0.678099 1.505684 1.182071 0.629820 1.357783 0.665420 0.341784 0.926591 0.193623 1.006880 1.192651 -0.116178 0.080172 1.591790 1.522361 0.438822 1.766471 0.395503 1.446548 -0.046614 0.961931 0.316539 0.616763 1.087859 0.290761 0.142685 0.155135 0.508154 0.686168 1.471184 1.165229 0.372220 0.294409 0.404832 -1.767095 1.243980 0.993281 1.007462 0.784244 1.104711 1.671816 0.086342)
     )

;;; 86 odd -------------------------------------------------------------------------------- ; 9.2736
#(86 12.300269991896 #(0 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1)
     12.274354058598 #(0 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1)
     12.140432277993 #(0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1)

     9.213343 #(0.000000 0.676268 0.369198 1.486263 -0.026625 0.678855 0.928889 1.200870 0.763422 0.131815 -0.064018 0.334478 0.754549 0.549209 0.781916 -0.164085 1.831169 -0.359871 0.452632 0.395640 1.217523 1.666783 1.263104 0.462675 0.487261 1.713262 0.419400 0.982422 0.818648 0.009279 0.749148 0.986045 1.410580 0.251205 1.543152 0.685375 0.249458 0.699138 0.175620 0.312944 1.884362 1.099441 1.640835 1.728596 -0.397229 1.509431 0.364317 1.073248 1.571193 0.690550 1.201949 -0.104903 0.984182 0.850373 -0.106842 1.582861 -0.052279 0.837387 1.423896 1.118738 -0.077783 0.539913 1.394923 -0.009295 1.541216 0.438460 0.217352 0.527395 0.855264 0.357004 0.424674 0.870332 0.435096 0.770273 0.096843 1.702425 0.991351 1.315154 1.133850 0.440564 0.044541 0.788769 0.138246 -0.080948 1.096067 0.575869)
     )

;;; 87 odd -------------------------------------------------------------------------------- ; 9.3274
#(87 12.733045578003 #(0 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 1)
     12.481803894043 #(0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 0 1)
     11.937030388359 #(0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1)

     9.355504 #(0.000000 1.287750 0.779612 1.374569 0.614001 1.400179 0.632998 1.081585 1.014078 0.745612 0.089837 0.213662 1.243008 0.937703 0.640815 -0.253008 0.477175 0.652403 0.775421 1.377863 1.817946 0.202038 1.184832 0.439289 0.719218 0.647200 1.513646 1.344719 0.737689 0.906777 0.966430 1.591779 -0.118046 1.050659 0.502430 0.443552 0.202102 0.751761 1.495915 1.741696 1.111228 0.930576 0.667434 0.355008 0.654809 0.342576 -0.057076 0.122353 1.075905 0.119007 0.865060 1.104894 -0.553899 1.233312 0.307806 -0.272801 1.208631 0.511489 -0.049495 1.639712 0.449063 -0.015286 0.206150 1.683654 0.713324 1.392059 0.685173 -0.298381 -0.092970 -0.623421 1.628494 0.369083 0.623011 1.244669 0.298338 1.016429 0.126627 0.253631 0.906706 0.241655 0.373895 0.778801 0.881325 1.325665 0.615581 -0.240021 1.132056)
     )

;;; 88 odd -------------------------------------------------------------------------------- ; 9.3808
#(88 12.652858832418 #(0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0)
     12.592202186584 #(0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0)
     12.128922775356 #(0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1)

     9.324023 #(0.000000 0.720070 1.146170 1.623229 0.919914 1.475051 1.669418 0.417706 1.222880 1.077800 0.636671 0.109954 0.709268 0.401961 1.342317 0.470950 1.038199 -0.014165 -0.223115 1.401527 0.255061 -0.053613 1.038430 1.524899 0.900064 0.540757 0.958685 1.268571 0.665381 1.798791 1.658869 0.625852 0.519615 0.589311 -0.003435 1.345809 -0.056260 0.616788 0.290786 1.478184 0.854964 0.750706 1.853143 1.837616 0.068009 0.196260 1.496079 0.820255 1.744388 0.146057 0.230788 1.434358 -0.205448 1.616936 0.981163 0.921532 1.591565 1.188825 -0.476209 1.518808 0.443241 0.115647 0.334751 1.367563 0.160132 1.179927 1.012776 0.498582 1.276116 0.704338 1.396987 -0.001804 0.959954 1.167324 1.287070 1.914346 1.400505 1.413492 1.484414 -0.463663 0.122173 0.488918 -0.038072 1.041389 -0.101511 -0.067115 1.661217 1.643428)
     )

;;; 89 odd -------------------------------------------------------------------------------- ; 9.4340
#(89 13.0 #(0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0)
     12.521632157997 #(0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0)
     12.4725522995 #(0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0)
     12.362 #(0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0)

     9.331615 #(0.000000 0.049094 0.763150 0.136548 0.483778 0.759076 0.333224 1.220929 0.134557 0.764345 0.615745 -0.054859 0.470862 1.549452 1.042755 0.304443 0.281140 1.178803 1.496311 1.304814 1.254180 1.214938 -0.188361 1.642263 1.456263 1.200682 1.159330 0.518402 1.259168 1.450349 0.156876 1.423052 0.526144 0.557187 0.211944 1.876505 0.927439 -0.029530 0.421763 1.206664 0.690297 1.789526 1.067082 0.003086 0.897179 1.065326 1.434687 0.576391 -0.150316 1.287422 1.126966 1.259277 1.431443 0.305104 0.343134 0.824875 1.068860 1.722713 1.668311 0.909968 1.314221 0.346498 0.614998 0.306500 1.059400 1.495807 -0.733779 1.277563 0.627585 1.184462 -0.276841 0.360604 0.535684 -0.101891 0.124422 1.197248 0.778353 1.945787 1.307086 0.922575 0.921600 0.870062 1.105219 1.606237 0.868032 -0.120196 0.316193 -0.191814 0.432808)
     )

;;; 90 odd -------------------------------------------------------------------------------- ; 9.4868
#(90 13.064256668091 #(0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1 0 1)
     12.44910044225 #(0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 1)
     12.309 #(0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 0 0 0 1)

     9.421684 #(0.000000 0.773463 -0.034237 0.815187 0.818292 -0.048506 -0.025177 1.145716 1.124687 -0.087471 0.982715 1.911529 0.885016 -0.169554 0.478422 0.410159 1.012688 0.169228 0.764485 0.758910 1.289872 0.618276 -0.229660 1.549110 0.758331 0.279930 1.553579 0.672439 0.162166 0.690601 0.847281 1.562839 1.023152 1.146052 1.063766 0.943600 -0.316637 0.816595 1.430319 0.223152 0.862408 0.935019 0.764642 0.942440 1.888157 1.614273 1.641359 1.139335 1.700104 1.516977 1.001915 0.698936 0.890613 1.412580 1.482707 0.374132 0.486389 0.409585 0.664613 0.728056 0.135717 1.017586 1.427256 0.114262 0.459920 0.985474 0.828118 0.029864 1.115880 0.182529 0.074455 0.121011 1.384155 1.498024 1.812648 0.488592 0.254186 1.880026 1.059948 0.152702 0.760476 0.236696 1.396118 1.492214 0.743805 1.035917 1.060796 0.484826 0.509085 -0.305704)
     )

;;; 91 odd -------------------------------------------------------------------------------- ; 9.5394
#(91 13.107619285583 #(0 0 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0)
     12.7095674403 #(0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0)
     12.351367950439 #(0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0)

     9.456608 #(0.000000 0.103422 0.965610 0.946880 1.775735 -0.122619 1.034051 0.168472 0.730448 0.272671 0.778481 0.021689 0.033093 0.984786 1.059637 0.145824 1.327186 1.317989 0.064861 1.738590 0.743092 0.115729 -0.009073 0.235258 1.253963 0.597261 1.473274 1.451939 1.654969 1.556762 -0.031925 0.584248 1.188923 1.752060 0.699420 0.272619 1.021928 1.546707 1.001394 0.687724 1.015815 0.834084 -0.085438 1.600278 0.991105 1.336531 1.547902 0.640465 0.462581 1.062100 1.213310 0.321259 0.291622 0.063730 0.566090 0.852786 0.847201 -0.174185 1.395263 1.222072 0.870150 0.708746 0.513822 0.978903 0.739358 1.760219 0.991895 1.423353 0.493188 0.952658 -0.084183 1.857020 1.060335 -0.192588 0.702407 1.144217 1.162221 1.656319 1.357097 0.810997 -0.196628 1.185541 1.692605 1.048778 1.191279 0.597890 1.575870 0.403387 0.283378 0.378021 0.172627)
     )

;;; 92 odd -------------------------------------------------------------------------------- ; 9.5916630
#(92 12.42142723142 #(0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1)
     12.280749613899 #(0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 0 1)

     9.552661 #(0.000000 1.217977 1.385618 0.939614 0.500483 1.851006 0.319542 1.708679 0.556310 0.891376 0.674923 0.365733 -0.175465 0.892985 1.540146 0.973262 0.317469 1.925159 0.685389 1.371188 0.200154 1.709968 0.177693 -0.300538 0.695154 0.829261 0.826887 0.518213 1.033752 1.220316 0.472703 1.153927 1.069740 0.054639 0.285291 1.692400 0.723359 -0.010143 1.422901 0.759732 0.421539 1.178988 0.292771 1.282542 0.969261 0.723210 1.587532 1.451565 0.985309 0.576854 0.032105 1.279589 0.637040 0.836814 1.053214 1.607968 0.083343 0.618958 1.664826 -0.072056 0.366474 1.110340 1.463534 0.789016 1.455017 1.061490 0.999534 0.659448 0.541265 1.191626 1.594463 0.899514 1.279707 0.844186 0.855539 -0.116804 0.909316 1.750334 1.598414 1.853269 0.368452 0.535158 0.818452 1.438032 0.503813 0.301666 0.154109 0.506999 0.079492 -0.057406 1.894913 0.600742)
     )

;;; 93 odd -------------------------------------------------------------------------------- ; 9.6437
#(93 13.111316272074 #(0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1)
     13.078753471375 #(0 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0)
     12.587555885315 #(0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 0 1 1 0 1 0 1 1 1 1)
     12.403578299298 #(0 1 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1)

     9.645868 #(0.000000 1.241537 1.333708 0.787569 0.050971 -0.078248 0.923773 1.369685 0.857784 1.262179 0.504370 0.896402 0.916469 1.799887 1.610173 1.398197 0.284925 1.134582 1.726453 0.983413 1.496906 0.200895 -0.309917 1.463448 0.601750 1.025687 0.355896 0.414371 0.188043 1.486702 1.569727 -0.264110 -0.146955 0.147874 -0.341508 0.911587 -0.107042 0.514714 0.232177 0.180635 0.019614 0.771036 0.258879 1.736936 1.383563 -0.202554 -0.363340 0.903757 1.907544 0.036939 0.039746 0.681623 -0.181331 0.587821 0.785217 1.300789 0.035509 1.393486 1.686671 0.394124 0.833491 1.182554 1.435857 1.862223 1.093380 1.273202 0.948015 1.723843 0.725719 1.326295 0.064893 -0.056493 0.979679 0.436974 0.295757 0.674884 -0.206299 1.581759 0.310301 0.015330 0.960233 0.967623 1.630985 0.703751 1.279982 1.191480 1.542942 1.677290 0.767801 -0.039491 1.413101 1.253640 0.851915)
     ;; 9.646

     9.645859 #(0.000000 1.241537 1.333708 0.787569 0.050971 -0.078248 0.923773 1.369685 0.857784 1.262179 0.504370 0.896402 0.916469 1.799887 1.610173 1.398197 0.284925 1.134582 1.726453 0.983413 1.496906 0.200895 -0.309917 1.463448 0.601750 1.025687 0.355896 0.414371 0.188043 1.486702 1.569727 -0.264110 -0.146955 0.147874 -0.341508 0.911587 -0.107042 0.514714 0.232177 0.180635 0.019614 0.771036 0.258879 1.736936 1.383563 -0.202554 -0.363340 0.903757 1.907544 0.036939 0.039746 0.681623 -0.181331 0.587821 0.785235 1.300789 0.035509 1.393486 1.686671 0.394124 0.833491 1.182554 1.435857 1.862223 1.093380 1.273202 0.948015 1.723843 0.725719 1.326295 0.064893 -0.056493 0.979679 0.436974 0.295757 0.674884 -0.206299 1.581759 0.310301 0.015330 0.960233 0.967623 1.630985 0.703751 1.279982 1.191480 1.542942 1.677290 0.767801 -0.039491 1.413101 1.253640 0.851915)
     ;; 9.646132

     
     )

;;; 94 odd -------------------------------------------------------------------------------- ; 9.6954
#(94 12.792093608509 #(0 1 1 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1)
     12.789479876738 #(0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1)

     9.661159 #(0.000000 1.588804 0.971217 0.766459 0.767867 0.711260 1.091790 0.349817 1.303164 0.299105 0.484292 0.598368 1.197926 1.747062 0.722622 -0.396188 1.399245 0.439766 0.958248 0.111299 1.178047 -1.744930 0.301555 1.425169 0.084000 -0.025537 0.535943 1.284537 0.181712 0.411199 1.539823 0.225792 -0.423981 0.343896 1.366011 0.345843 0.465663 0.361851 1.176776 1.072341 0.953491 0.775606 0.716473 0.829273 0.969342 0.640627 0.296206 -0.156650 1.324608 0.193879 0.425337 0.333109 0.196756 0.404183 1.170266 0.249250 0.563527 0.899667 0.753079 0.196206 1.581045 1.275062 0.369856 1.345791 0.040679 1.219119 0.515687 1.086098 0.960464 1.907787 0.492577 1.687493 -0.290881 1.469486 0.108096 0.281684 0.764577 1.432368 1.142516 0.132850 1.826271 1.229052 -0.053102 1.491479 1.263260 0.075817 1.206478 0.628961 0.641919 0.938117 -0.083906 1.739885 1.619796 0.747023)
     )

;;; 95 odd -------------------------------------------------------------------------------- ; 9.7468
#(95 13.132 #(0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0)
     12.981590594561 #(0 1 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0)
     12.858592033386 #(0 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0)
     12.575266058635 #(0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 0 0)

     9.735600 #(0.000000 1.292497 0.048203 -0.369619 1.658994 1.560061 0.879899 1.137112 1.447970 0.335324 0.984709 1.427085 1.844799 1.225424 0.635600 0.989096 0.331429 0.249737 0.360756 1.194267 0.197730 1.702054 1.070270 0.300034 0.741905 0.166347 0.139998 0.842776 1.379510 1.374446 0.645029 0.228595 0.386049 1.780109 0.890796 1.059972 0.114385 0.569940 1.431936 1.250898 0.833089 1.819195 1.160456 0.868281 0.830018 0.420271 1.732442 1.276161 1.064351 1.463862 0.178792 0.641407 0.715907 1.085416 0.876646 1.641268 -0.093492 0.088286 -0.321731 1.685143 1.003045 -0.167024 1.045631 -0.115517 1.198908 -0.027166 0.885640 1.516232 0.099833 0.111214 1.258272 1.084176 0.251115 0.992461 0.662549 0.904491 0.810201 1.142504 1.354205 1.561331 0.123435 1.445070 1.912561 1.219904 -0.162585 -0.297214 1.393516 0.424985 1.423284 1.199928 0.614322 -0.026818 1.027314 1.052945 0.134212)
     )

;;; 96 odd -------------------------------------------------------------------------------- ; 9.7980
#(96 13.232 #(0 1 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0)
     13.00986051659 #(0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0)
     12.956554412842 #(0 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 0 0 1 1 0)
     12.803173065186 #(0 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 1 0)

     9.765375 #(0.000000 0.434211 1.538074 0.231972 0.103404 0.264750 0.996479 0.091686 0.470361 -0.102622 0.584434 1.902662 0.672355 1.003087 1.282415 0.083224 0.269790 0.436355 0.731956 0.096073 0.805918 -0.067716 0.579099 -0.103871 0.334241 1.262008 1.472212 0.331174 0.587892 0.217183 0.352704 1.351196 1.835041 1.561263 1.207796 0.649612 0.812693 0.139308 1.107541 -0.141380 1.693656 1.776654 0.081750 0.374104 0.451494 -0.068302 0.754329 0.867293 1.797313 0.792370 0.569326 0.646979 1.351054 1.185472 1.790426 0.860858 1.746807 1.212636 0.581516 0.653566 0.962517 1.014627 0.606360 0.146221 0.283416 -0.354566 1.284376 0.473762 0.642247 0.511279 1.459193 0.929998 1.240921 0.226151 0.228494 1.199410 1.808265 -0.003950 0.745625 0.180103 1.363422 -0.374760 1.422743 1.453269 1.392463 1.334806 0.036384 1.547199 0.888311 0.461368 1.742662 0.894476 0.308121 1.812971 0.219980 0.928326)
     )

;;; 97 odd -------------------------------------------------------------------------------- ; 9.8489
#(97 13.340280990563 #(0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0)
     12.954301727663 #(0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0)
     12.837450993031 #(0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1)

     9.838272 #(0.000000 0.379964 1.472644 0.133744 -0.140157 1.476134 0.221972 1.269309 1.616315 0.577131 1.660679 0.193905 0.628189 1.028522 0.068957 0.935760 0.702977 -0.308435 0.091948 0.689934 0.311682 0.952950 0.648520 0.816819 0.598841 0.699303 0.257522 0.733644 1.510696 0.132133 -0.162771 1.666146 1.755542 0.415995 1.461531 1.220198 0.220925 0.355118 0.560028 0.621627 1.423657 -0.142295 -0.284424 1.751423 0.296941 1.799636 0.501228 1.835724 -0.066329 -0.181418 1.655191 0.652554 1.575413 1.231429 0.785002 1.898549 1.695601 1.071631 0.093384 0.069533 0.376107 0.773015 1.100214 0.008306 0.223388 1.727061 0.802968 0.010879 0.687837 0.511554 0.473390 0.943552 1.720768 1.586270 0.921978 0.792555 0.177911 -0.134945 1.214262 1.814337 0.678718 0.281091 1.335940 1.751537 1.535792 0.882447 0.417089 0.835247 -0.026430 0.656838 0.682717 1.076945 1.523637 0.827371 1.103525 0.670966 -0.103179)
     )

;;; 98 odd -------------------------------------------------------------------------------- ; 9.8995
#(98 13.53905582428 #(0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 0 0 1 0)
     13.128762135265 #(0 1 1 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 1 0 0 1 0)
     13.062 #(0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 1 1 0)
     12.972 #(0 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 0)

     9.920902 #(0.000000 1.126403 0.809709 -0.157186 -0.281915 1.012657 1.654541 0.885619 0.592079 -0.166614 0.039987 1.689962 -0.133278 1.386822 0.753516 1.606064 0.457015 0.728735 1.602275 -0.179409 0.981311 1.558602 1.120736 0.609937 -0.041897 1.652659 1.694935 1.548108 1.544753 0.720875 0.132813 1.190135 1.204099 1.195628 1.299628 -0.156596 0.828437 -0.088570 0.691334 1.038891 0.358838 1.487075 1.027059 0.068314 1.142997 0.328484 0.720712 0.849295 0.355815 0.712246 1.038989 1.234905 1.576884 0.318035 -0.157390 0.053010 -0.509879 1.521694 0.204391 -0.061210 0.036866 0.961361 1.058641 0.697722 0.808257 0.742292 1.685141 0.456959 0.420272 0.760483 1.461579 1.499848 0.638955 0.416173 0.965394 1.155161 0.695578 0.104415 -0.351742 1.110602 1.632197 0.591900 1.392995 1.260256 0.567673 0.750837 1.211579 0.009429 0.814837 0.265021 1.455455 1.586312 1.548449 1.856683 1.738263 0.227547 1.056798 1.697612)
     )

;;; 99 odd -------------------------------------------------------------------------------- ; 9.9499
#(99 13.792359352112 #(0 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1)
     13.577017376954 #(0 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1)
     13.046126365662 #(0 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 0 0 1)
     13.000000000002 #(0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0)

     9.965958 #(0.000000 0.555507 0.098779 1.439319 1.089958 0.896088 0.994889 0.048464 1.063375 0.588411 1.421977 1.592920 1.460161 1.544736 1.960389 0.424482 0.350720 1.293512 1.003419 0.062161 0.736988 -0.763991 1.089588 1.339080 1.075397 -0.023419 1.362933 1.111600 0.368857 1.483848 1.770279 0.197535 0.673504 -0.141015 0.680626 1.239162 0.008338 1.147754 0.904976 -0.117839 1.652298 0.572773 0.628492 1.403376 1.461867 0.500593 0.939662 0.535313 0.581379 0.193981 0.765486 -0.240335 0.400702 1.170247 0.236363 1.341517 0.383994 -0.060044 0.608106 0.595252 1.153583 1.000343 1.161168 0.958679 0.387497 0.873399 0.533956 0.331196 0.809909 0.803574 -0.160894 -0.380871 1.844122 1.159171 0.602052 -0.157771 0.175788 1.102714 0.553954 0.041196 0.423087 0.254922 1.521307 -0.287096 1.144486 1.678247 0.212092 0.416444 1.126314 1.120602 1.091858 0.674606 1.407311 0.572645 1.294521 -0.162897 0.972088 1.049381 1.082099) ; new

     9.964762 #(0.000000 0.546613 0.108623 1.446203 1.102480 0.885844 0.995223 0.048339 1.053181 0.573269 1.424115 1.592450 1.456756 1.557988 1.951729 0.437235 0.348781 1.296576 1.004655 0.067420 0.734482 -0.755441 1.084552 1.333560 1.072807 -0.019290 1.352674 1.107522 0.374109 1.477728 1.780357 0.190167 0.689132 -0.135453 0.686760 1.243930 0.009120 1.144796 0.907459 -0.122664 1.650261 0.556444 0.642942 1.399646 1.453155 0.485620 0.938975 0.535104 0.594746 0.193277 0.762182 -0.240547 0.412861 1.174813 0.238513 1.339174 0.382226 -0.062101 0.615411 0.592991 1.152708 1.001979 1.161587 0.971242 0.385733 0.875093 0.538177 0.330642 0.810173 0.810101 -0.144721 -0.377582 1.820957 1.149190 0.599927 -0.163049 0.173155 1.119005 0.553825 0.038603 0.441494 0.248854 1.533944 -0.294504 1.139838 1.685678 0.208575 0.407090 1.122405 1.125899 1.077851 0.670444 1.406076 0.579870 1.292074 -0.145259 0.966482 1.080376 1.077736)
     9.964695 #(0.000000 0.546613 0.108623 1.446147 1.102480 0.885900 0.995223 0.048395 1.053237 0.573213 1.424115 1.592450 1.456756 1.557988 1.951729 0.437235 0.348781 1.296576 1.004655 0.067420 0.734482 -0.755441 1.084552 1.333560 1.072807 -0.019290 1.352674 1.107522 0.374109 1.477728 1.780357 0.190167 0.689132 -0.135453 0.686760 1.243930 0.009120 1.144796 0.907459 -0.122664 1.650261 0.556444 0.642942 1.399646 1.453155 0.485620 0.938975 0.535104 0.594746 0.193277 0.762182 -0.240547 0.412861 1.174813 0.238513 1.339174 0.382226 -0.062101 0.615411 0.592991 1.152708 1.001979 1.161587 0.971242 0.385733 0.875093 0.538177 0.330642 0.810173 0.810101 -0.144721 -0.377582 1.820957 1.149190 0.599927 -0.163049 0.173155 1.119005 0.553825 0.038603 0.441494 0.248854 1.533944 -0.294504 1.139838 1.685678 0.208575 0.407090 1.122405 1.125899 1.077851 0.670444 1.406076 0.579870 1.292074 -0.145259 0.966482 1.080376 1.077736)
     )

;;; 100 odd -------------------------------------------------------------------------------- ; 10
#(100 13.916926312979 #(0 1 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 1 0)
      13.24493912033 #(0 1 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0)
      13.117680368039 #(0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0)

      9.980383 #(0.000000 1.021922 1.076820 0.673847 0.575885 1.533332 0.370570 1.093376 1.755083 0.655580 1.330543 0.692562 -0.458101 0.490851 0.838293 1.092809 0.186122 -0.010575 1.325587 -0.093097 0.865219 1.307433 0.241116 -0.049406 0.065854 1.251624 0.884244 0.524953 1.907530 0.908817 0.869203 1.167859 0.403361 0.050869 1.542545 -0.083281 1.550973 1.724484 -0.192868 -0.000926 0.850954 1.399191 0.792168 1.733492 0.267684 0.780517 0.302360 0.087572 0.407115 -0.063586 0.755726 0.308351 0.688474 1.168256 0.213560 0.955933 0.515782 -0.238765 1.965262 0.258280 0.493914 0.414014 0.952777 0.109999 0.808226 0.619322 0.009522 1.221417 0.621965 -0.066642 1.169555 1.630223 0.359269 0.498199 1.172396 1.573325 1.458987 0.249669 0.487537 0.298683 0.244833 0.266323 1.299523 1.746073 -0.157289 1.024756 0.053292 0.441201 -0.030602 1.367429 0.368826 1.526611 1.263784 1.147239 0.266733 -0.395066 0.678513 0.982843 1.111068 1.120171)
      )

;;; 101 odd -------------------------------------------------------------------------------- ; 10.0499
#(101 13.462674500314 #(0 1 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1)
      13.28250751675 #(0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1)

      9.964634 #(0.000000 -0.073111 1.535769 -0.102555 0.949824 0.661791 1.376397 0.389320 1.429271 1.382915 0.702074 0.190023 0.165010 0.880936 1.053717 0.381858 1.515003 1.204543 0.504035 0.920455 0.391206 0.949414 1.113429 0.554900 1.897469 1.768789 1.766679 1.550589 0.402518 0.254763 0.394916 1.625563 0.833640 0.744524 0.452145 -0.082936 0.892795 1.873582 1.781184 -0.418454 1.636196 -0.022737 0.903335 -0.412208 1.924024 0.194797 -0.087158 0.651748 1.188278 0.341571 0.583987 1.814760 1.207941 1.789448 0.551284 0.991618 0.259118 0.282624 1.011184 1.611901 1.372798 1.012968 0.839711 1.331909 1.264042 0.325794 0.343316 -0.075857 -0.460634 0.488689 1.512646 1.806638 1.012723 -0.303497 1.575625 0.027198 0.002241 1.290806 1.657896 1.438044 0.654010 1.150362 0.652919 1.476118 -0.053999 -0.024155 0.726437 0.454484 1.497660 0.765182 0.287065 1.425963 0.079052 0.750136 1.836142 1.337567 -0.185862 1.924720 -0.153672 0.400041 1.450120)
      )

;;; 102 odd -------------------------------------------------------------------------------- ; 10.0995
#(102 13.701085090637 #(0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0)
      13.159336831147 #(0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0)

      10.045766 #(0.000000 -0.279070 0.173878 0.081403 1.768938 1.607495 0.603256 0.555897 0.375867 1.098499 0.557935 1.658062 0.679353 0.435605 1.704584 0.882188 0.675710 1.226519 -0.017413 0.221732 -0.211376 1.307302 0.689909 0.655783 0.993058 0.615004 1.764502 1.131327 0.119482 0.185094 1.035751 1.439320 1.373211 1.418236 0.503946 0.310742 0.195150 1.345393 1.645648 0.392993 0.050135 0.685592 0.243679 0.754096 0.965418 1.162001 1.767714 0.912263 1.540226 0.989163 0.153496 1.180193 0.495181 0.826820 -0.194339 1.268780 1.482827 -0.154668 1.003093 0.057371 1.563631 1.606126 0.908893 1.017810 0.439667 -0.174146 0.280275 0.399111 1.342959 -0.098826 1.087834 1.050762 0.557805 0.752893 -0.400427 0.095731 0.689016 0.552247 0.778927 0.058727 0.428406 0.269116 0.480708 0.192361 0.563638 0.686642 0.128600 1.864221 -0.045520 1.018032 1.780635 -0.005046 0.881801 1.021244 0.513775 1.482476 0.956890 0.518235 1.186738 -0.018819 1.609204 0.515712)
      )

;;; 103 odd -------------------------------------------------------------------------------- ; 10.1489
#(103 13.551587266363 #(0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1)
      13.142812158651 #(0 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1)

      10.111415 #(0.000000 1.369365 0.405900 1.488781 1.297953 1.174843 0.723558 1.119299 0.563474 1.504545 1.425250 0.056872 1.552986 0.366288 0.261580 -0.028580 1.679320 0.354104 1.366160 0.206627 -0.181243 0.842753 0.284420 1.193404 1.753516 1.261312 0.897716 0.187196 0.403928 0.535986 0.048320 0.851056 1.320855 0.927805 0.675374 0.099015 1.569905 0.543193 0.858885 1.852497 0.289649 1.099326 1.162432 -0.048854 1.182600 -0.112285 0.640579 0.486946 1.088064 0.673507 1.804943 0.331085 0.762463 0.502333 0.945836 0.125886 1.094108 1.174128 1.305209 -0.085398 1.064126 -0.229516 1.339602 1.007787 0.463923 0.562480 0.421047 0.862475 1.823075 1.617828 -0.234042 1.270044 1.411666 0.288137 -0.512483 1.287193 0.552746 0.692496 1.553888 1.229657 1.840347 0.905113 0.869393 0.230800 1.453875 0.970539 1.068305 0.133261 0.916437 0.815294 0.472897 1.432924 0.213798 0.664480 0.772635 0.945954 1.152482 0.551639 0.888122 1.133675 0.035558 -0.040676 1.756562)
      )

;;; 104 odd -------------------------------------------------------------------------------- ; 10.1980
#(104 13.622 #(0 0 0 1 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)
      13.301904678345 #(0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)
      13.214084551284 #(0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)
      13.176067352295 #(0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)

      10.177244 #(0.000000 0.864103 -0.115636 0.951995 1.177634 1.343254 0.083492 1.782382 0.042679 -0.276147 0.492752 1.369302 1.589198 0.307315 1.039450 0.305210 0.639376 1.602449 -0.081928 1.174210 0.016692 0.882490 0.741870 1.016502 -0.391093 0.681985 1.682689 1.015700 0.454753 1.274594 0.662876 1.380252 0.930293 0.628459 0.876456 1.106916 0.852789 1.100736 0.940561 1.637607 -0.086148 1.212746 0.912069 1.028817 0.381236 0.942494 0.984780 0.177347 0.221288 1.147986 1.624713 0.099574 0.989931 1.826359 0.937597 0.312746 -0.015182 0.174387 -0.021839 0.755325 0.027577 0.666064 0.817895 1.635084 1.403925 1.157509 1.355861 1.542951 1.255220 1.010734 0.855263 0.927495 0.020066 0.368108 -0.088669 1.049630 -0.032826 0.657091 -0.094808 -0.157862 1.260974 0.333447 0.456316 1.159383 1.298201 0.128795 1.629996 0.810636 0.920204 1.390571 0.700319 0.324638 1.336733 1.512810 1.484477 1.949532 0.780843 0.351950 0.613905 1.434518 1.465239 0.829351 0.677452 -0.332550)
      )

;;; 105 odd -------------------------------------------------------------------------------- ; 10.2470
#(105 14.179738044739 #(0 1 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0)
      13.491228801467 #(0 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0)

      10.115828 #(0.000000 0.049019 1.344835 1.091641 0.665700 0.968893 0.648602 0.707898 1.514354 1.538919 0.526334 1.493761 1.624995 0.707437 0.593803 0.874212 1.543010 1.853745 0.426397 0.026573 1.615940 1.506593 0.465693 1.159200 -0.404908 1.664358 0.782410 1.352302 -0.234654 1.360029 1.390064 0.562127 0.900595 -0.305834 1.198378 1.369945 1.005775 0.397773 0.628843 1.626964 0.837449 1.061154 1.446306 1.380391 1.599960 0.270806 1.328543 -0.187842 -0.215850 0.275407 1.674813 1.481684 0.685411 -0.076514 1.172112 0.021028 -0.282040 0.805083 0.169438 0.519532 1.238467 0.912197 -0.108203 0.770912 1.223603 1.260598 0.243317 1.416653 -0.085803 1.793597 1.018898 0.209596 0.637018 0.680644 1.218601 -0.251927 1.342315 0.794662 0.530948 1.151958 0.965018 0.768542 0.003792 0.487969 1.528116 0.185132 1.582165 0.376426 0.269883 0.979543 1.678175 1.757906 1.492507 0.386900 1.219606 0.328787 1.292795 -0.100060 0.401454 0.164930 0.339091 0.226350 0.418706 -0.115549 1.296351)
      )

;;; 106 odd -------------------------------------------------------------------------------- ; 10.2956
#(106 13.492804348903 #(0 1 1 1 1 0 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 0 1 0 0 1)
      13.091135978699 #(0 0 0 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0)

      10.198335 #(0.000000 0.831679 1.059524 0.595983 0.203261 1.202829 1.655547 1.163399 0.731912 1.050991 -0.085268 1.049064 0.669107 0.707558 1.587356 0.103456 0.095032 1.177165 1.677580 0.458849 0.488238 1.294418 -0.328225 1.742764 0.960376 0.232688 1.221102 1.139466 1.165521 0.274312 -0.217213 1.769983 -0.106435 0.980799 0.424668 1.120797 1.738923 1.408831 0.326124 1.349134 0.307375 0.275240 0.392410 1.221176 0.352509 0.866366 0.344959 0.656333 0.909394 0.940268 0.976614 0.141881 0.684412 0.786921 -0.062121 -0.010568 1.690036 -0.088688 1.427313 -0.052874 1.785355 0.109989 0.958795 1.179624 0.324837 1.229886 1.616903 1.768092 1.318950 1.675999 1.563712 0.225381 0.575251 0.774252 -0.022742 1.783220 1.405786 0.332796 1.613495 1.352845 1.308309 0.373980 1.918112 1.162561 0.910064 1.737277 1.152808 -0.033675 0.058425 1.406045 -0.253836 0.991335 1.479963 0.005130 1.832773 0.614974 0.073456 1.352269 1.161897 0.192184 0.857686 0.091488 0.263380 1.392944 0.202339 1.603064)
      )

;;; 107 odd -------------------------------------------------------------------------------- ; 10.3441
#(107 13.864 #(0 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 1 1)
      13.762476921082 #(0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1)
      13.722554538648 #(0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1)
      13.537808159641 #(0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 1 0 1)

      10.309402 #(0.000000 1.451306 1.657176 0.103526 0.785742 1.255118 -0.022276 1.748796 0.347513 1.600152 1.552130 0.117107 1.641169 1.667132 0.228638 1.701190 0.203157 1.049079 -0.310557 0.171411 0.851600 0.165296 1.474009 0.765654 0.798906 0.361454 1.294669 0.490998 -0.037671 -0.031873 0.341124 1.593711 0.671646 0.114033 -0.107655 1.019602 0.906388 0.722753 0.347338 1.024259 -0.167257 0.888686 0.078086 1.762772 1.317462 1.594271 1.627741 0.009537 1.510992 0.470557 0.666728 1.172591 0.339101 0.139264 0.337454 0.439081 1.263956 -0.190753 0.397474 0.259013 0.102571 1.040973 0.821082 1.958212 1.113622 0.701131 1.569842 -0.334290 0.783001 1.202394 0.708455 -0.341265 0.479212 0.495499 -0.059199 0.692184 0.973618 0.384505 1.782703 -0.026011 1.853473 0.369542 0.297789 0.539980 0.113917 0.897004 1.816394 1.009839 1.611208 -0.211894 -0.141919 0.734675 0.879690 0.127451 1.843661 -0.068539 1.634042 0.223977 1.204516 0.869170 0.061960 0.692492 1.779440 1.816359 1.575323 1.074729 1.558448)
      )

;;; 108 odd -------------------------------------------------------------------------------- ; 10.3923
#(108 13.775 #(0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 0 0 0)
      13.751863479614 #(0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0)
      13.584542754139 #(0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0)
      13.472808406168 #(0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0)

      10.325467 #(0.000000 1.823999 0.121670 1.358801 0.589768 1.029967 -0.433790 1.041582 -1.274122 0.780646 -0.169734 1.604597 1.010159 1.810789 0.632723 -0.206688 0.463178 1.073646 1.521165 -0.178712 1.523791 0.423100 0.144424 0.899019 -0.452142 0.547962 0.895764 1.662227 0.346193 1.471302 -0.164671 -1.901696 0.406602 0.262326 0.474119 -0.030228 1.801622 1.325384 1.588387 0.343116 0.445611 0.273212 0.831258 1.871029 -0.312461 1.896993 1.025139 0.721577 0.726171 0.338346 0.861017 1.378901 0.847116 0.469202 -0.383235 0.452023 -0.496006 1.102062 1.102044 1.646809 0.311243 -0.456688 0.949926 0.520943 0.921326 0.643117 0.781598 1.182150 0.966506 0.456713 0.498859 1.075971 1.927079 0.160322 0.159648 0.419881 0.925743 0.446322 0.326978 1.459788 0.903977 -0.021458 1.063237 1.175806 1.223175 0.258595 0.623246 1.572004 0.621332 1.978290 1.546402 1.672410 0.423727 1.205710 1.436589 0.182917 0.251425 0.718333 -1.375705 0.497395 0.186440 0.550196 0.272118 1.380692 1.012574 0.305814 1.433937 0.098087)
      )

;;; 109 odd -------------------------------------------------------------------------------- ; 10.4403
#(109 13.889015913621 #(0 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 1 0)
      13.798 #(0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 1 0 0 1 1 0 0)

      10.420655 #(0.000000 -0.327487 1.851479 0.298451 0.481543 1.937119 1.087771 1.271543 0.729749 1.367479 1.485066 1.201545 1.941365 0.159174 0.999314 1.515181 0.972814 0.871845 0.601338 0.917052 0.064094 1.624417 1.206609 0.451607 0.458289 1.382214 0.277670 0.389981 1.292079 1.096489 0.940391 0.509581 0.474950 1.478192 1.214054 0.995466 1.143113 0.402156 1.277347 -1.545309 1.223960 0.409788 -0.139909 1.014510 1.168815 0.593894 1.500239 0.802756 0.426932 0.366358 1.280533 0.894990 1.752354 0.238068 0.786786 1.405496 1.441070 1.291183 1.237393 0.491038 1.514732 1.094416 0.055877 1.475763 0.699420 0.038785 0.959300 1.785824 0.482166 0.726557 0.218897 0.214123 1.343999 -0.396507 1.667643 -0.044315 1.728798 0.984031 0.442302 -0.012294 0.257981 1.489796 -0.120823 0.688197 0.830964 1.001478 1.663108 0.777848 1.045298 1.101214 1.089134 1.690343 1.098703 0.293079 0.901078 -0.010724 0.472490 1.242201 1.392719 -0.547630 0.296408 1.088182 0.358521 0.906756 0.649371 1.936659 -0.126784 0.054443 0.190454)
      )

;;; 110 odd -------------------------------------------------------------------------------- ; 10.4881
#(110 13.816418806615 #(0 1 0 0 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0)
      13.75 #(0 1 0 0 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0)
      13.576010454591 #(0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0)

      10.408073 #(0.000000 1.583299 1.129147 0.924363 0.405386 0.106463 0.654471 1.235816 1.676675 1.424024 -0.320821 -0.106137 1.651584 1.223458 1.376470 0.070578 0.035561 0.618393 1.591071 1.247092 1.420738 1.407145 1.068993 1.180774 1.368120 -0.309458 -0.227815 -0.257077 0.341569 0.189699 1.898096 1.209271 -0.362341 0.480813 1.176223 1.497789 1.567432 0.970389 -0.047452 0.764481 1.364232 1.546603 0.838685 0.519999 0.785088 1.840526 0.201375 0.694162 0.995107 0.138310 0.417265 -0.004223 1.430441 0.548174 0.456155 0.879102 0.021026 0.612402 1.448544 1.143273 1.475463 0.804075 0.821149 0.175404 1.164546 0.079156 1.149637 1.448505 1.656091 1.757415 0.521205 0.257194 1.707629 0.482292 1.377093 0.507438 0.991226 -0.612661 0.868064 0.306724 0.414844 0.138628 0.061298 1.129023 1.487975 0.706799 -0.099480 1.383589 0.290834 1.123787 -0.072238 0.982011 0.038233 1.760058 0.405531 0.016972 -0.604791 1.005236 1.670267 -0.215358 1.779967 0.879139 0.413047 1.290874 0.860692 0.804540 1.190191 0.135277 0.110128 0.732322)
      )

;;; 111 odd -------------------------------------------------------------------------------- ; 10.5357
#(111 14.376 #(0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0)
      14.114 #(0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0)
      13.709900383304 #(0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0)

      10.616461 #(0.000000 0.085818 0.443790 -0.174729 0.551185 0.004310 1.221006 0.846049 -0.320056 0.104305 1.710246 0.012349 -0.041875 1.020740 0.834675 1.935430 1.436334 1.336744 1.623165 1.601495 0.201575 0.327893 1.960009 0.968787 0.029357 1.608234 0.806292 1.912528 1.469098 0.056621 0.963844 0.899705 0.548494 0.699809 -0.020780 1.430738 0.837910 0.946271 1.266882 0.818748 0.405189 0.790557 0.337845 -0.098433 0.607346 0.092551 1.049274 1.285909 0.128382 1.276535 1.355464 0.200070 0.815193 1.634054 1.605647 0.460327 1.359077 -0.174286 1.703901 0.624690 0.127994 0.277045 0.090096 0.930974 0.609225 0.483129 0.490530 0.349810 1.747931 1.434080 -0.376568 0.022861 1.378762 1.453225 -0.216695 0.531908 0.004985 0.714572 1.447707 1.892025 0.813762 0.039250 0.000713 1.670283 1.806664 0.388848 1.457690 0.580726 1.618073 0.411256 1.285386 0.195354 0.490975 0.828655 1.239362 -0.092454 -0.016282 -0.030362 0.372991 1.756010 1.384456 1.236363 0.022162 -0.128508 0.375349 1.042349 0.109295 1.202359 1.573759 0.752541 0.501044)
      )

;;; 112 odd -------------------------------------------------------------------------------- ; 10.5830
#(112 14.528804585299 #(0 0 1 1 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0)
      14.383410482601 #(0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0)
      13.92684841156 #(0 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1)

      ;; 10.58839?
      10.587210 #(0.000000 0.316988 0.143936 0.764315 0.246101 0.878947 1.451664 0.246273 1.508247 0.783082 1.178823 1.084461 0.034393 1.782575 0.278684 0.763914 0.713711 1.579443 1.275609 1.242445 1.017437 -0.137729 1.720757 1.645444 1.252516 0.573423 0.523306 0.367458 1.129122 1.011679 0.283137 0.012500 0.103897 1.705011 0.798633 1.601435 0.554696 1.023779 0.562147 0.380710 0.153528 0.522613 0.029811 1.723996 0.184836 1.184847 0.913687 0.558063 1.657228 0.875459 0.114176 1.049513 0.935619 -0.057730 0.650793 1.056918 -0.391158 1.469298 0.243715 0.389824 0.413059 0.949725 1.003394 1.332346 0.600118 0.797282 0.305378 -0.482677 0.467696 1.296894 0.604530 0.417640 0.076560 0.294735 0.484475 0.231378 0.630991 1.123367 -0.231446 0.664557 1.184842 -0.091849 1.129416 0.779429 1.502768 1.551686 1.148093 0.573322 0.282145 1.468938 0.181449 0.273173 1.640806 1.230598 0.156043 0.340045 1.579513 0.098567 0.039950 1.019858 1.151793 1.444677 0.639695 1.567130 1.089930 1.535700 1.605075 0.886897 1.388680 0.655474 1.357969 -0.052673)
      ;; 10.58841?? 
      10.587246 #(0.000000 0.316988 0.143936 0.764334 0.246101 0.878947 1.451639 0.246273 1.508247 0.783082 1.178823 1.084461 0.034393 1.782575 0.278703 0.763914 0.713711 1.579443 1.275609 1.242445 1.017437 -0.137729 1.720757 1.645444 1.252516 0.573423 0.523306 0.367458 1.129122 1.011679 0.283137 0.012500 0.103897 1.705011 0.798633 1.601435 0.554696 1.023779 0.562147 0.380710 0.153528 0.522613 0.029811 1.723996 0.184836 1.184847 0.913687 0.558063 1.657228 0.875459 0.114176 1.049513 0.935619 -0.057730 0.650793 1.056918 -0.391158 1.469298 0.243715 0.389824 0.413059 0.949725 1.003394 1.332346 0.600118 0.797282 0.305378 -0.482677 0.467696 1.296894 0.604530 0.417640 0.076560 0.294735 0.484475 0.231378 0.630991 1.123367 -0.231446 0.664557 1.184842 -0.091849 1.129416 0.779429 1.502768 1.551686 1.148093 0.573322 0.282145 1.468938 0.181449 0.273173 1.640806 1.230598 0.156043 0.340045 1.579513 0.098567 0.039950 1.019858 1.151793 1.444677 0.639695 1.567130 1.089930 1.535700 1.605075 0.886897 1.388680 0.655474 1.357969 -0.052673)      
      )

;;; 113 odd -------------------------------------------------------------------------------- ; 10.6301
#(113 14.292 #(0 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0)
      14.00348588593 #(0 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0)
      13.825498858186 #(0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0)

      10.600603 #(0.000000 0.881119 0.177416 1.176041 0.321835 1.333960 0.321613 -0.071815 0.812053 1.766195 1.046716 1.892305 1.275959 -0.461937 -0.015171 1.795446 -0.048137 0.620929 0.697484 1.103818 0.926866 1.531979 1.769224 1.414500 1.564917 0.839151 1.755254 0.695258 1.111646 0.815717 0.793322 0.904346 0.123745 1.289632 1.439134 1.235399 0.428960 0.220510 1.272676 0.679603 0.494936 0.901640 0.258846 0.498781 0.436040 1.274597 0.390356 0.253738 1.419744 1.336402 1.286789 0.686393 0.384401 1.757370 0.378734 1.866679 0.149109 1.602185 0.623630 0.535255 0.874221 1.685311 0.859596 0.906715 0.279966 1.652736 0.428511 1.158812 0.385707 1.686690 1.736542 0.621739 0.169614 0.759680 0.890691 1.875235 1.610581 0.208567 0.311624 1.382460 0.832610 0.485955 -0.062699 0.027271 0.044052 1.375004 1.677491 0.502953 1.056565 0.336492 0.862340 0.998307 0.380496 0.740050 0.850577 0.390372 0.488666 0.839508 0.726241 1.158324 1.974533 0.573427 1.425562 1.555265 1.486426 0.835003 1.218102 1.011646 -0.079290 -0.201968 0.709973 0.654345 1.389187)
      )

;;; 114 odd -------------------------------------------------------------------------------- ; 10.6771
#(114 14.507795639854 #(0 0 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 1)
      14.388 #(0 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0)
      13.974405288696 #(0 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0)
      13.920305720092 #(0 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 0 0)

      10.620769 #(0.000000 -0.265733 0.572658 0.316585 0.923883 1.614948 0.728669 0.692865 0.985653 1.596503 0.291068 0.153708 1.761462 0.140269 1.183433 -0.379854 1.503387 1.143776 0.747711 1.619251 0.404594 1.157009 0.378840 0.537946 0.751007 0.739900 0.914353 1.624008 0.450778 0.962869 0.588872 1.869278 0.721483 1.557011 0.902276 0.776013 1.285044 0.345048 1.685952 1.091106 0.263288 1.107778 -0.009439 0.420734 1.806464 1.410193 1.769595 1.251788 0.691963 1.604897 1.666646 1.531003 0.963757 -0.680527 1.705352 1.126307 -0.203837 0.277321 0.178995 1.809866 0.763029 0.031476 0.539819 0.755127 0.685061 1.837935 0.717076 1.848829 1.364997 0.950055 -0.061791 1.853324 0.123916 -0.136693 1.146568 0.362176 0.781284 1.598429 1.120688 1.139170 0.560329 -0.015310 0.331374 1.472918 0.199430 0.303861 1.321918 1.569172 1.548780 -0.090459 1.912266 0.810039 -0.152547 1.372081 1.425080 0.264711 1.614349 0.175290 0.789472 1.260114 1.370945 1.918464 1.489942 1.397616 0.963993 0.516634 0.516943 1.244942 0.283787 1.709141 1.616073 0.810759 1.316742 1.696489)
      )

;;; 115 odd -------------------------------------------------------------------------------- ; 10.7238
#(115 14.773869138996 #(0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 1 0 1 0 1 1 1 1 1)
      14.449532208006 #(0 0 0 0 1 0 0 0 0 1 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0)
      14.20306968689 #(0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1)

      10.685586 #(0.000000 0.788956 -0.304462 -0.034426 0.759795 0.633889 0.249550 0.847810 1.261880 0.570408 0.946639 0.502284 0.310171 1.284142 0.845344 0.049256 1.567312 1.292703 0.243399 0.280884 1.569320 0.755513 1.490038 0.037373 0.166153 0.197466 0.962160 1.000629 0.173664 1.450266 -0.300709 0.085930 1.672227 1.097749 1.143106 0.383390 1.331810 0.653833 1.176136 0.649840 0.441329 0.865428 1.260429 -0.113231 0.068627 1.537397 0.071716 1.737274 1.208804 0.080658 -0.238500 0.215220 0.144094 0.344280 0.007001 0.036661 0.313861 0.890126 0.309940 0.066795 -0.267535 -0.015074 1.284917 0.527186 -0.401928 1.184316 0.828609 0.023559 0.879458 0.265076 1.091490 1.078007 -0.000849 0.040965 0.042737 1.571236 0.908978 0.684845 0.722642 0.060053 0.405475 1.454756 1.402793 1.359455 1.220360 0.090094 -0.916007 0.818517 1.446936 -0.047533 0.554626 0.624158 1.799761 0.513849 0.656407 0.749453 1.853195 1.129272 1.638943 0.406703 -0.004761 0.883191 0.100722 0.544168 0.543192 0.997237 1.502304 1.856500 1.262889 0.578118 0.923399 0.262403 0.597058 0.824442 0.351113)
      )

;;; 116 odd -------------------------------------------------------------------------------- ; 10.7703
#(116 14.661133289609 #(0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0)
      14.619069099426 #(0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0)
      13.887789451571 #(0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0)

      10.739916 #(0.000000 0.477489 1.879241 1.178922 0.827974 1.453354 0.787338 1.051542 1.213823 0.179497 0.746613 1.269489 0.032032 1.633864 -0.151329 0.777158 0.274841 1.469832 0.563157 1.806583 0.216963 0.156511 1.049107 0.169063 0.220748 0.776005 0.397674 0.635852 -0.104402 0.313905 1.774365 0.161158 1.716447 1.119271 1.392526 0.104260 1.024732 1.530395 1.549343 -0.247114 0.490315 1.544528 0.177517 0.659413 0.262680 1.053035 0.895041 1.443935 1.721955 0.002704 1.150439 1.059278 0.111130 0.864129 0.780766 1.278702 0.502792 0.942527 0.796930 1.334562 1.657313 1.680191 0.258937 0.886444 0.070781 1.519968 1.240071 1.554574 0.514600 1.256384 1.259155 1.030467 1.356849 1.907652 1.281713 1.171494 0.248874 1.621439 0.212540 1.521799 -0.091398 0.707258 1.859558 0.182337 0.746913 0.759487 0.246612 -0.157271 1.664252 0.235686 -0.217854 1.216484 1.459287 1.518944 1.204911 0.477818 -0.382313 0.212369 0.338718 1.438036 1.043369 0.855288 0.389216 1.703950 1.439985 -0.139739 1.281293 0.715378 0.736367 1.587518 1.781754 1.653989 -0.317416 0.173632 1.443245 0.989607)
      )

;;; 117 odd -------------------------------------------------------------------------------- ; 10.8167
#(117 14.63381513714 #(0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1)
      14.427604264985 #(0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1)

      10.793469 #(0.000000 0.106035 0.678038 -0.037332 1.070398 0.984635 0.909978 1.470398 1.731643 0.840220 1.306739 0.613632 1.551399 -0.230781 1.485372 0.841765 1.241967 0.246073 0.851488 -0.025558 0.454168 0.812115 1.487733 1.565587 1.186755 0.777993 0.110007 0.901710 1.168530 -0.157285 0.506307 1.681196 1.684692 1.223196 1.843701 0.539406 0.346352 0.042456 -0.075937 1.470650 1.572015 0.179701 -0.067456 0.912807 0.597779 1.573740 0.693635 1.128209 -0.428029 0.609051 1.499236 0.863811 0.893768 1.362643 1.653181 1.404897 0.040458 1.691895 1.091241 0.739679 1.241157 0.479069 1.443620 0.985070 0.802256 1.512584 0.964298 0.280061 0.104250 1.597609 -0.010474 1.896898 1.409550 1.243858 0.385523 0.520476 0.420296 1.056590 0.157593 0.781861 0.758458 1.875380 0.023515 1.471792 0.080045 1.799306 0.431499 0.734747 0.443197 -0.062855 1.251251 0.139459 1.732484 1.866537 1.568948 0.429821 0.536294 0.905734 1.632670 1.127257 0.408884 0.762546 0.281382 1.400462 0.259791 0.020003 0.274318 0.682142 -0.077023 0.499053 0.230234 1.244925 1.642057 0.247333 0.026930 1.133953 1.454213)
      )

;;; 118 odd -------------------------------------------------------------------------------- ; 10.8628
#(118 14.922 #(0 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 0 0)
      14.72793006897 #(0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1)
      14.399567650824 #(0 1 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1)

      10.812235 #(0.000000 1.507972 1.809575 1.323971 0.671235 0.977919 0.397118 0.294709 0.400614 1.800046 0.492728 1.565979 -0.363038 1.100463 1.075231 0.502016 0.457037 0.406728 0.228418 0.756367 1.513939 0.347068 1.450936 0.868009 1.501709 0.352220 -0.413052 -0.148923 0.240400 1.115439 0.653043 -0.505473 -0.021974 1.853042 0.586305 0.428092 0.050201 0.752546 1.451411 1.228490 1.754283 1.881544 0.485306 1.754300 0.007006 0.163634 0.582385 0.998129 -0.090614 0.952205 1.425714 1.513296 1.570494 -0.259048 0.529336 1.498547 1.326491 -0.594238 1.538496 0.728657 0.444244 1.055319 1.385207 0.874327 0.074427 1.100816 1.734905 0.605814 1.533043 1.017063 0.482871 0.438583 1.108829 1.808956 0.029357 0.297016 -0.063569 0.780909 1.283400 0.359665 -0.032425 1.363808 0.687851 1.190450 1.438414 1.141910 1.126025 1.239471 0.136191 1.489911 1.026641 0.526687 0.890040 -0.022700 0.140687 -0.353757 1.164330 1.005641 0.099661 1.220163 1.081145 1.773078 1.376716 1.458019 0.703593 0.987305 1.493840 1.628605 0.957392 -0.054994 1.652856 0.431213 1.736293 -0.162073 0.279632 -0.110283 1.166212 1.877544)
      )

;;; 119 odd -------------------------------------------------------------------------------- ; 10.9087
#(119 15.03294064107 #(0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1)
      14.647579104049 #(0 1 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1)
      14.464 #(0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1)

      10.920399 #(0.000000 1.469111 -0.070220 0.746680 0.860314 0.743575 1.373811 1.854134 1.498255 0.003572 1.552728 1.878072 0.487277 1.613604 0.160707 1.366964 0.909546 0.761757 0.324425 -0.313954 0.387040 0.647614 0.409381 -0.205223 1.635252 0.332678 1.582118 1.660886 -0.012856 0.559302 0.057330 -0.007451 1.613838 0.116400 0.550984 1.353870 1.030149 0.040359 -0.251026 0.455279 -0.186782 1.050710 1.654930 0.734409 1.050821 0.179022 -0.062131 0.017148 0.174511 1.493980 1.293893 1.362148 0.210710 0.896579 1.384710 0.578681 1.285256 1.672120 0.837362 1.092866 -0.061159 0.751236 0.925903 0.986104 0.740196 1.786112 0.901620 0.096293 0.003280 0.768174 1.258965 1.478315 1.309881 1.198720 1.420103 1.730995 1.282932 1.840205 1.078765 0.379905 -0.076866 -0.024445 0.665740 1.348631 0.825833 0.230111 1.373130 1.455238 0.547797 0.396833 1.338283 0.076243 0.455449 0.585906 0.926225 0.828751 -0.163595 1.151762 0.493738 1.765523 0.205477 1.480659 -0.317615 0.098868 1.152567 0.695814 1.514867 1.484432 0.920914 0.109085 1.164340 0.724298 1.390844 1.739616 1.451558 0.767732 1.225923 0.587168 1.582405)
      )

;;; 120 odd -------------------------------------------------------------------------------- ; 10.9545
#(120 14.701 #(0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 1)
      14.672351088208 #(0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 1)
      14.578378677368 #(0 1 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1)
      14.530112637252 #(0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0)

      10.920607 #(0.000000 1.631584 1.382612 1.215045 0.281714 1.388814 0.113701 0.266817 0.981205 1.227412 0.889311 1.654028 1.767427 0.692614 1.239252 0.725673 0.694790 1.130080 0.996567 1.303005 0.312581 0.603938 1.496746 1.438939 -0.030750 0.722511 0.805615 1.403255 1.845041 -0.007462 0.490534 -0.093654 0.225268 -0.182357 0.141845 0.993104 0.359178 0.281279 0.966354 0.230022 1.507762 0.177772 0.401564 1.445356 0.492041 0.992556 -0.062702 1.516205 0.634624 0.455915 1.142630 1.114054 0.763209 -0.132849 1.232808 1.405601 0.198111 0.000638 1.365429 0.728920 0.859650 1.278728 0.563812 1.309442 0.590949 0.235908 1.178785 1.733051 0.364794 -0.144556 0.520384 1.739668 0.220718 1.631088 0.604322 0.929637 0.627190 0.437229 1.782281 0.937299 1.481578 0.991942 1.706139 0.222184 0.004588 0.767350 1.682826 1.554453 0.975758 0.320274 0.437322 0.260997 1.688914 0.972542 0.208757 0.730228 0.383877 1.065085 0.672851 0.703864 0.107553 1.760380 1.844083 0.290517 0.558852 -0.058991 0.526411 0.467949 -0.086612 1.744763 0.455486 1.252438 1.359601 0.403985 1.133184 1.055975 0.444377 0.811734 0.712115 0.098906)
      )

;;; 121 odd -------------------------------------------------------------------------------- ; 11
#(121 15.185772112492 #(0 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0)
      14.673 #(0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0)
      14.355115628334 #(0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0)

      11.019363 #(0.000000 0.718450 0.952882 0.390235 1.801839 0.222479 1.898786 0.917640 0.395769 1.087238 1.372817 1.622238 0.540358 1.206490 1.236002 0.908330 0.763030 0.915483 1.092337 0.396642 0.051322 0.088780 1.418775 0.993721 1.199584 0.324206 0.165546 1.021283 1.778832 1.805816 0.307490 0.798902 0.436634 1.544494 0.342827 1.730486 0.584195 0.217067 0.366740 0.051968 1.418477 1.538669 1.077402 -0.033040 0.482341 0.365405 0.560537 -0.126956 0.363000 -0.118378 0.494914 0.024541 0.634063 0.698800 1.805737 0.834613 0.780218 -0.017682 0.341433 -0.323978 0.036401 1.411826 -0.177795 1.802944 1.182691 0.171293 0.762289 1.530301 0.944963 0.768246 0.215633 0.433193 0.753694 1.322237 1.756010 0.363037 0.377764 1.752353 0.609736 0.449265 1.808005 0.739594 0.430301 0.750144 1.341313 0.082848 0.846540 0.441423 1.172158 -0.467828 1.540285 1.474752 0.457720 -0.324987 0.231145 1.119232 1.185132 -0.234167 1.597235 1.148408 1.821575 1.379555 0.341780 0.228339 0.284960 1.221880 0.524546 0.951845 1.032739 1.478331 1.413400 0.884212 -0.105159 0.655049 0.792213 1.768871 0.895731 0.775922 0.196040 -0.022769 1.370013)
      11.019174 #(0.000000 0.718261 0.953182 0.390206 1.802130 0.222599 1.899003 0.917141 0.396632 1.086955 1.373179 1.622118 0.540312 1.206753 1.235559 0.908042 0.762571 0.915706 1.091860 0.395909 0.051492 0.088126 1.418372 0.993414 1.199454 0.324181 0.165607 1.020392 1.779131 1.805896 0.307708 0.798716 0.436177 1.544577 0.342893 1.730840 0.583814 0.216109 0.366730 0.052347 1.418744 1.539155 1.077530 -0.032253 0.482300 0.365039 0.561716 -0.127154 0.363452 -0.117084 0.494428 0.024852 0.633898 0.698331 1.806404 0.834245 0.780627 -0.017755 0.341752 -0.324642 0.036393 1.411864 -0.177672 1.802602 1.183710 0.171100 0.762460 1.530176 0.944801 0.767888 0.215573 0.432858 0.754090 1.321876 1.755972 0.362757 0.378197 1.752507 0.609359 0.449065 1.807227 0.739665 0.430364 0.750396 1.341199 0.083505 0.846295 0.441945 1.171068 -0.467872 1.540665 1.474712 0.458455 -0.325068 0.231557 1.119829 1.184414 -0.233837 1.597613 1.148543 1.820402 1.379801 0.342024 0.228309 0.284770 1.221715 0.524921 0.951972 1.032779 1.478185 1.413100 0.884157 -0.105129 0.655046 0.791373 1.768951 0.895479 0.775255 0.195936 -0.021942 1.370727)
      )

;;; 122 odd -------------------------------------------------------------------------------- ; 11.0454
#(122 15.079724293912 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0)
      14.561 #(0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1)
      14.266534958875 #(0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 1)

      11.036279 #(0.000000 1.291067 1.116954 1.752439 1.130862 0.028803 1.375343 -0.034413 -0.039143 0.473434 1.539173 0.247519 1.204261 0.136454 1.295812 1.932553 1.390096 1.405769 1.742934 1.273283 1.504997 -0.044843 1.533540 0.220837 1.243571 0.362140 0.494990 1.256456 1.151510 0.081618 1.289038 1.649016 1.399391 0.282991 0.259642 -0.413996 0.547407 -0.097919 1.440154 0.775930 0.238819 1.568565 0.737365 0.591641 1.525365 0.561703 1.459739 0.000917 1.678322 1.749599 0.502434 1.606770 0.300252 1.402475 0.647992 -0.368828 -0.184148 -0.629519 0.868658 0.913323 0.041174 0.811679 0.974808 1.317693 0.192815 1.544040 0.915662 1.841153 -0.335544 0.551272 0.990390 0.856701 0.960929 0.665295 0.807108 0.639016 1.921390 0.215403 1.074118 0.306933 0.410045 1.352109 -0.321278 0.603814 0.760523 1.286664 0.570245 1.113925 -0.035259 0.310084 0.018192 1.582601 0.988611 1.001767 0.934598 1.315943 1.600149 -0.010927 0.380401 0.510943 1.488755 1.293430 -0.271982 0.452098 0.312423 -0.014944 0.088621 -0.310936 -0.036677 1.826390 0.581489 0.390337 0.025467 1.669390 1.255150 0.571638 0.908413 0.828935 1.450409 1.624399 0.814977 0.739106)
      )

;;; 123 odd -------------------------------------------------------------------------------- ; 11.0905
#(123 15.249 #(0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 0 1 0)
      15.019962594276 #(0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0)
      14.795100232697 #(0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0)

      11.131274 #(0.000000 1.253987 1.733471 1.066627 0.850717 0.777329 0.498425 0.594725 0.579807 -0.087276 1.667269 1.092627 -0.078316 1.739557 0.146903 0.408900 0.522084 1.121093 1.619716 0.921303 1.372208 0.438361 0.809688 0.044326 0.107167 1.200482 0.425097 1.242032 1.202780 -0.254536 0.073795 -0.066869 0.727684 0.892881 1.167057 0.472891 0.800448 1.108147 0.736463 1.581881 0.134582 0.303648 1.718789 0.180917 1.461905 -0.211156 0.654801 0.216730 0.412516 1.153217 0.350638 1.145148 0.212956 1.472253 1.352986 0.848168 1.119708 1.579902 0.087248 0.601916 0.354818 0.616343 1.012333 0.465007 1.789356 1.539313 0.337684 0.916315 1.284885 1.435465 0.064010 0.944955 1.875134 1.415707 0.525654 0.528680 1.940981 1.364662 1.771109 0.266121 0.599394 0.398861 0.101589 0.003867 0.756773 0.305722 0.981153 0.263433 0.826299 0.678094 1.493513 0.416815 1.364707 1.394586 0.538099 1.450167 1.004210 0.286753 0.961241 1.128589 -0.141927 0.208787 1.796558 -0.441258 -0.217222 1.009578 -0.665944 0.556088 -0.112099 1.192628 -0.500365 1.255225 0.903414 1.546248 1.467435 1.445552 1.210705 0.597734 1.385616 1.647242 0.853825 0.495129 1.311280)
      )

;;; 124 odd -------------------------------------------------------------------------------- ; 11.1355
#(124 15.930208950198 #(0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0)
      14.82254124518 #(0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0)

      11.204612 #(0.000000 0.759965 0.248025 1.177716 0.490442 0.729356 -0.075761 1.131951 0.499916 -0.636287 0.140372 -0.073643 0.955066 0.664872 0.646046 1.778529 0.085447 0.356016 0.690352 1.345341 -0.397532 0.157376 1.092639 0.399301 1.221625 0.298529 0.106697 1.357187 1.806036 0.703518 0.667918 0.148978 -0.136549 0.780534 0.366512 1.658806 0.648188 1.769012 1.387642 0.563824 1.553693 -0.061936 0.159883 1.081350 1.601749 0.517328 0.098161 0.078077 1.071765 -0.017655 -0.508328 0.694350 0.341979 0.924412 0.567105 0.959682 1.670162 0.123208 0.552882 0.337268 0.975820 0.695804 0.524517 0.085250 -0.389327 0.929257 0.620795 1.264729 1.148298 0.941345 1.132369 1.763342 0.932418 -0.663102 1.708812 1.256615 0.181019 1.358314 1.704142 0.640444 0.135901 0.852490 1.268929 1.446709 0.392266 0.507133 0.795345 0.488621 0.859061 0.064160 0.019069 -0.366487 -0.022268 -0.439519 -0.299810 0.794746 0.218054 1.099259 -0.088867 1.239028 1.678458 -0.271661 1.351815 0.098752 0.396799 1.244598 1.526175 0.654241 0.763546 0.464915 1.723932 1.431744 1.343763 -0.624164 1.498332 -0.076321 1.533230 1.843309 0.616140 1.034835 0.918429 0.730007 0.501219 -0.232384)
      )

;;; 125 odd -------------------------------------------------------------------------------- ; 11.1803
#(125 15.409635839002 #(0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0)
      14.833 #(0 0 1 1 0 1 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 0)
      14.82163143158 #(0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 1 0 0 1 1 1 0 0)

      11.122080 #(0.000000 0.847003 0.165605 0.564848 0.227076 1.866949 1.345525 0.694388 0.959809 0.220564 0.772501 1.602410 1.604719 1.034958 1.311625 0.093909 0.283228 1.337145 0.377730 0.845137 0.466461 0.350583 0.723543 1.140286 -0.106738 0.112805 0.654453 1.405583 0.488341 1.115481 0.791692 -0.180702 0.024701 0.675117 -0.401907 0.966930 1.823188 0.970009 -0.163692 0.487827 0.774136 1.664048 1.147399 1.934923 -0.055579 1.590906 1.404741 1.937024 1.297324 -0.074406 0.012276 -0.101828 0.157087 0.049344 0.227099 0.402796 0.390545 1.452083 1.063131 0.134397 1.038993 1.058234 -0.172834 -0.157850 -0.051398 -0.166122 0.368524 1.765197 1.164117 1.233067 1.255917 0.100656 0.389203 0.162934 0.701475 1.871318 0.234658 1.379710 -0.022077 0.663615 1.352469 0.392445 -0.083922 1.307168 0.973714 1.219169 0.823481 0.152576 0.585169 0.393119 0.296805 1.754607 1.427512 0.110549 1.353534 -0.062637 0.005406 0.988733 0.551978 -0.032302 1.396422 1.051496 1.232496 1.873765 0.104448 1.090614 -0.186610 1.107217 0.405013 0.371843 1.166939 1.223105 0.199359 1.547104 0.541567 1.118832 0.462118 -0.111041 0.497800 0.551619 0.175381 1.513543 0.771791 0.282381 0.491699)
      )

;;; 126 odd -------------------------------------------------------------------------------- ; 11.2250
#(126 15.556811374771 #(0 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 1)
      14.961482935205 #(0 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1)

      11.250719 #(0.000000 1.333055 1.857065 -0.354031 0.933443 -0.571267 0.881903 1.235969 1.243039 1.741021 0.787282 0.873059 1.032986 0.833494 1.226501 -0.137095 -0.406503 0.372947 1.655801 0.761158 -0.035756 0.124653 0.200126 1.600053 0.107431 0.890443 1.241508 1.570728 0.389294 -0.253619 0.171729 0.409508 -0.066894 0.903761 -0.243105 -0.012832 -0.126690 1.157298 0.876349 1.424410 0.859063 1.834093 0.080832 1.681305 0.596204 0.925056 1.696693 1.551779 0.358809 0.003280 -0.107662 -0.042966 -0.069602 -0.073392 0.932655 1.097360 1.494228 1.552532 0.993295 0.022270 0.353694 0.203512 0.463817 -0.014483 -0.029060 0.569381 -0.129976 0.818995 1.082300 0.051512 0.735631 1.242872 1.298403 0.910934 -0.221957 1.647033 0.571701 1.071110 1.206774 1.347286 1.495958 0.750632 1.228583 1.800365 0.629840 0.384647 0.016989 1.383897 0.408577 1.675839 1.285083 0.867095 0.957471 -0.205068 1.361489 1.257618 1.243115 0.664903 1.528110 1.477162 0.389623 0.301892 1.636096 1.614232 0.878407 0.434386 0.808524 0.387432 1.385881 -0.229862 0.512039 -0.111275 0.742098 -0.200000 0.437934 1.019359 0.595716 1.125365 -1.855213 1.752854 1.184608 1.558943 0.720676 0.692615 -0.015051 1.209743)

      11.250762 #(0.000000 1.323688 1.858199 -0.371382 0.922356 -0.566384 0.870567 1.241654 1.240084 1.740785 0.784059 0.868888 1.036717 0.845418 1.203885 -0.141676 -0.412530 0.370540 1.650514 0.757402 -0.025693 0.120472 0.203687 1.603627 0.102330 0.891721 1.245076 1.559103 0.404350 -0.253047 0.166682 0.411574 -0.055199 0.908601 -0.242737 -0.017807 -0.119490 1.160133 0.873010 1.432277 0.866824 1.812691 0.073328 1.685924 0.590947 0.922240 1.705070 1.549967 0.369413 0.009468 -0.108461 -0.056261 -0.069219 -0.074229 0.932521 1.103018 1.511522 1.541635 0.986294 0.006823 0.341645 0.196137 0.458786 -0.020425 -0.016349 0.564114 -0.132084 0.807359 1.082761 0.058531 0.734900 1.242065 1.305902 0.919745 -0.216780 1.653252 0.576949 1.061604 1.219727 1.329217 1.503664 0.752314 1.225483 1.805469 0.615363 0.392319 0.012419 1.368294 0.409692 1.665415 1.286477 0.874965 0.951923 -0.195000 1.373632 1.257199 1.238728 0.674417 1.527344 1.454728 0.391984 0.314429 1.626492 1.621393 0.875824 0.441019 0.809953 0.386939 1.392603 -0.238051 0.512997 -0.115560 0.746580 -0.202724 0.433715 1.016833 0.589645 1.106597 -1.836977 1.751179 1.194468 1.565365 0.728703 0.707998 -0.010136 1.198887)
      11.249777 #(0.000000 1.325018 1.858888 -0.370577 0.922820 -0.567552 0.868688 1.243461 1.240774 1.741889 0.783795 0.869919 1.035322 0.846015 1.205820 -0.141431 -0.413369 0.372440 1.650457 0.757202 -0.025129 0.118987 0.202936 1.603981 0.101691 0.891515 1.246296 1.559071 0.404442 -0.252586 0.167829 0.411886 -0.054348 0.908903 -0.241887 -0.016698 -0.119319 1.159932 0.871702 1.432507 0.866129 1.814384 0.073951 1.686601 0.590749 0.923198 1.704193 1.550218 0.369714 0.010152 -0.108725 -0.056694 -0.069758 -0.074859 0.932367 1.103904 1.512090 1.542044 0.986088 0.007387 0.342069 0.197123 0.458730 -0.020084 -0.018023 0.566473 -0.130913 0.807758 1.082706 0.058231 0.734983 1.242204 1.304789 0.920724 -0.216899 1.651483 0.576866 1.061603 1.219396 1.329763 1.503715 0.752101 1.224720 1.803831 0.616106 0.393166 0.011594 1.368820 0.407792 1.666357 1.286650 0.874339 0.950938 -0.195494 1.373840 1.257521 1.239919 0.674896 1.527296 1.454511 0.392671 0.313266 1.626651 1.621259 0.875615 0.440401 0.808900 0.385699 1.392833 -0.239029 0.510297 -0.114570 0.744576 -0.203310 0.433206 1.016219 0.589835 1.107438 -1.839896 1.751630 1.195808 1.565270 0.729992 0.707251 -0.012647 1.197755)
      )

;;; 127 odd -------------------------------------------------------------------------------- ; 11.2694
#(127 15.055509004493 #(0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 1 0)
      15.018874168396 #(0 0 1 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1)
      14.695912364919 #(0 0 1 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0)

      11.2833828 #(0.000000 0.471002 0.791008 0.352238 -0.202742 1.306949 0.980116 0.524963 1.344088 0.380240 -0.240093 1.372641 1.536553 0.434625 0.315998 -0.346348 0.300958 0.472042 1.236032 0.790081 0.396947 1.213436 1.363692 0.263923 0.870786 1.154825 0.296546 1.036368 0.837965 1.805969 0.621422 0.019639 1.626723 1.153580 0.103058 0.764515 -0.016314 1.818870 1.769227 -0.168446 1.160709 0.589805 1.010850 0.688942 1.346329 0.976330 1.231493 1.607789 1.160266 1.597343 -0.308670 0.369500 0.827154 1.180477 0.883685 0.398773 0.664375 0.944204 1.509443 1.778682 0.535398 1.065638 -0.361851 1.699959 1.256318 -0.278276 0.921354 1.599172 1.087877 0.957670 1.197889 1.098600 0.879052 1.734604 1.802729 1.251291 1.307827 0.565436 1.383589 1.413753 0.595609 -0.234190 0.156848 -0.042176 0.163606 1.496007 0.373093 1.027008 0.706928 1.167142 0.324561 0.642426 0.427312 0.037666 1.132920 0.425841 0.539137 0.545738 0.012831 1.395564 1.655509 0.817302 0.212104 1.533457 0.972698 1.717536 0.160175 -0.428464 0.807367 0.991951 0.895516 1.746336 1.631805 0.083709 0.210011 -0.010564 0.902333 1.208451 1.322502 1.287738 0.393039 0.780449 1.094791 0.223857 1.129225 -0.140515 0.986038)
      11.2832233 #(0.000000 0.471640 0.790590 0.352931 -0.202475 1.306017 0.979379 0.525764 1.343897 0.380168 -0.240578 1.373184 1.537071 0.434581 0.316529 -0.346684 0.301744 0.472405 1.235816 0.789698 0.396887 1.213714 1.363531 0.264136 0.871453 1.154990 0.296626 1.036520 0.838628 1.805519 0.621336 0.020899 1.627078 1.152578 0.102959 0.763590 -0.016288 1.819198 1.768318 -0.168374 1.160987 0.588715 1.010614 0.688601 1.347452 0.976038 1.231320 1.608464 1.160958 1.596641 -0.307697 0.369575 0.827662 1.179818 0.882676 0.399903 0.664767 0.944407 1.510057 1.779260 0.533914 1.064585 -0.362211 1.700648 1.256896 -0.278753 0.921992 1.599565 1.088622 0.956280 1.198539 1.098740 0.880252 1.734339 1.801172 1.251241 1.308461 0.564780 1.382522 1.415588 0.595944 -0.234540 0.157743 -0.041695 0.164526 1.496198 0.371340 1.027956 0.706818 1.168946 0.324084 0.642643 0.427619 0.036819 1.133051 0.425655 0.539036 0.546566 0.012057 1.395939 1.654636 0.817187 0.211902 1.533751 0.973849 1.718668 0.160516 -0.428405 0.807378 0.991778 0.894765 1.746666 1.631410 0.084601 0.209781 -0.010239 0.902525 1.208383 1.322410 1.286926 0.393000 0.780572 1.094198 0.223038 1.129195 -0.140928 0.985187)

      11.2834442 #(0.000000 0.470290 0.792777 0.354175 -0.203776 1.308925 0.977325 0.525480 1.349302 0.381243 -0.237692 1.376651 1.535770 0.435098 0.315697 -0.347867 0.299794 0.473678 1.235616 0.786574 0.399074 1.213217 1.369721 0.260149 0.870860 1.154358 0.295826 1.038077 0.841335 1.805710 0.618550 0.015777 1.623353 1.155128 0.099322 0.763060 -0.019125 1.816979 1.766148 -0.169137 1.162010 0.589542 1.010174 0.693579 1.349370 0.976145 1.229936 1.605184 1.164423 1.596401 -0.311171 0.371667 0.825396 1.179043 0.886475 0.398356 0.672019 0.946105 1.512660 1.776429 0.538456 1.067475 -0.357947 1.701696 1.252221 -0.279844 0.924413 1.600353 1.084519 0.954394 1.198562 1.098478 0.880102 1.735414 1.801395 1.249361 1.303869 0.561792 1.383269 1.410794 0.594502 -0.231194 0.156158 -0.040507 0.160209 1.501066 0.370378 1.027348 0.709196 1.167262 0.320743 0.641060 0.429949 0.035185 1.130584 0.419614 0.538246 0.545786 0.010512 1.399060 1.652822 0.816454 0.215539 1.534619 0.972695 1.711984 0.156841 -0.427704 0.808982 0.993710 0.895395 1.746158 1.625758 0.078646 0.211663 -0.004701 0.905945 1.211560 1.319238 1.284579 0.392476 0.780259 1.096897 0.221588 1.129119 -0.139825 0.983830)

      11.280717 #(0.000000 0.471316 0.793365 0.352664 -0.204141 1.308041 0.977943 0.526965 1.351414 0.383275 -0.238445 1.374685 1.536512 0.435183 0.314902 -0.349167 0.299302 0.476852 1.237042 0.786645 0.398269 1.214111 1.368053 0.259076 0.870060 1.154366 0.294517 1.039270 0.840348 1.805155 0.619142 0.016744 1.622873 1.153946 0.096943 0.764078 -0.019728 1.817132 1.766742 -0.167821 1.162152 0.588968 1.008019 0.693476 1.348110 0.975315 1.229457 1.605751 1.162146 1.597112 -0.311449 0.371365 0.826335 1.177838 0.886641 0.397999 0.672480 0.946213 1.510915 1.778133 0.539107 1.067381 -0.359462 1.701617 1.254194 -0.279405 0.922680 1.600107 1.084098 0.953795 1.196545 1.096731 0.881065 1.734808 1.800935 1.250515 1.304550 0.560924 1.384835 1.413562 0.594126 -0.228979 0.158508 -0.037696 0.160105 1.499737 0.372530 1.028788 0.709823 1.166312 0.319874 0.641396 0.427839 0.036430 1.131337 0.420025 0.536584 0.544407 0.010613 1.398404 1.650298 0.817364 0.213406 1.537692 0.971839 1.712465 0.157395 -0.426913 0.809583 0.992288 0.896700 1.745561 1.626323 0.080024 0.210586 -0.006021 0.906764 1.208814 1.321940 1.286980 0.390853 0.779368 1.094993 0.220523 1.129136 -0.139077 0.983486)
      11.280152 #(0.000000 0.471381 0.793481 0.352885 -0.204108 1.307569 0.977424 0.526475 1.351531 0.382892 -0.238473 1.374993 1.536614 0.435071 0.315384 -0.348882 0.299642 0.476825 1.236250 0.787005 0.398733 1.214537 1.368636 0.259724 0.870000 1.154294 0.294069 1.039367 0.840649 1.804789 0.619171 0.016796 1.622434 1.153608 0.097123 0.764122 -0.019539 1.817939 1.767004 -0.168129 1.162334 0.589178 1.007824 0.693876 1.348609 0.975867 1.229664 1.606135 1.162240 1.596947 -0.311834 0.371225 0.826552 1.178118 0.886895 0.398361 0.672225 0.945870 1.510721 1.778054 0.539032 1.067709 -0.359093 1.701376 1.253668 -0.279187 0.922519 1.600242 1.084321 0.953615 1.196953 1.096412 0.881069 1.734767 1.800952 1.250956 1.304800 0.560243 1.384373 1.413434 0.594256 -0.228640 0.158934 -0.038241 0.159979 1.499396 0.372162 1.029227 0.709811 1.166205 0.319826 0.640723 0.427952 0.036112 1.131232 0.419985 0.536559 0.544351 0.010788 1.398067 1.650280 0.817958 0.213374 1.537783 0.971792 1.712369 0.157660 -0.426764 0.809790 0.992212 0.896788 1.744849 1.626358 0.080366 0.211451 -0.006188 0.907095 1.209587 1.321415 1.286791 0.391083 0.779565 1.095014 0.220919 1.128770 -0.139119 0.983665)
      )

;;; 128 odd -------------------------------------------------------------------------------- ; 11.3137
#(128 15.527 #(0 0 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 1 1 1 1 0 1 1 1)
      15.003612518311 #(0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1)
      14.876242756695 #(0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1)

      11.261196 #(0.000000 0.166552 0.658187 0.892812 0.275075 0.681304 0.935134 0.976324 1.751013 1.223679 0.531374 0.670158 0.738172 0.131342 0.784571 -0.001918 0.261947 -0.271711 1.074675 0.180917 0.495904 1.378525 0.720362 0.537440 1.116473 -0.311806 0.462073 0.021129 0.764859 1.361657 1.645691 -0.164691 0.135735 1.576068 0.824450 0.335134 1.099359 0.719625 0.791638 0.999013 0.348593 0.103014 1.062792 0.739933 1.675943 0.488371 0.860700 0.759566 1.276788 -0.135237 0.780818 -0.165115 1.024663 -0.327864 0.608127 1.454969 0.958609 0.555060 1.331156 0.762777 0.625297 1.411237 1.470303 1.190821 0.207444 0.108639 1.023133 1.165243 1.464221 1.564262 0.616076 0.019451 0.729986 0.402652 0.078552 0.454134 0.152695 0.263463 0.361958 1.475980 0.276689 1.365673 0.254488 -0.143709 1.946127 0.309551 1.760348 1.294342 0.981564 0.863637 1.477654 -0.019128 0.751338 0.878849 0.050601 0.063334 1.353561 1.669390 1.451518 0.535767 0.012898 0.428045 -0.011136 0.975409 -0.201088 0.677802 0.866124 0.188482 0.625213 1.342113 1.315837 0.879874 0.445664 1.081775 0.978490 1.662778 0.529736 1.946523 1.542905 0.571344 1.054205 0.430980 0.402697 -0.095096 1.487261 1.198691 1.754313 1.700742)
      )

;;; 256 odd --------------------------------------------------------------------------------
#(256 22.546259712247 #(0 1 1 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1)
      
      19.779971 #(0.000000 0.287166 1.811728 0.003647 1.563327 -0.199797 1.748861 -0.027658 1.491523 0.358283 1.786152 0.407453 1.895896 1.702005 0.820432 1.443342 0.126567 0.528978 1.062681 0.144427 1.060071 0.368932 1.288502 1.669328 0.601969 1.609873 0.009521 0.796369 0.509981 1.904275 0.044862 0.614773 1.710675 1.495519 1.692276 1.250582 1.156222 1.594534 0.298597 1.684540 0.924734 0.804943 0.689590 1.177326 0.902799 0.909396 0.954254 0.261017 1.169485 0.938560 0.019866 1.334679 1.574350 0.442405 0.413355 1.552164 0.377894 1.422514 0.243015 0.559434 1.800624 1.468365 1.592498 0.584550 0.034812 0.293061 0.193868 1.089628 1.551790 0.037622 1.190818 0.318859 0.819004 1.851057 0.518624 0.663998 0.448473 0.066841 0.121442 0.912629 1.902379 1.968342 0.338155 1.260192 0.187056 1.823089 0.529718 0.076074 1.893909 1.177725 0.252346 0.193078 1.743428 1.843296 1.581080 0.130352 0.411188 0.552704 1.459730 -0.190870 1.185873 1.213912 1.881537 1.413927 0.390691 0.406250 1.645390 0.152258 0.066573 1.047526 0.945901 1.029638 1.224255 1.274278 1.742960 0.466865 1.882173 1.585879 1.499684 1.765278 0.688359 1.510365 0.729048 1.561332 0.482075 1.161051 0.635742 0.621496 0.237812 1.429801 1.538338 1.807873 0.866385 0.985705 0.165602 0.760224 1.891478 1.496052 0.933548 1.722668 0.466509 0.099331 0.101735 0.991972 1.628542 1.607529 1.751580 1.265628 0.234833 0.306012 1.365655 1.492678 1.262225 1.708575 1.110893 1.962624 1.207292 1.779446 0.254648 1.807960 1.406200 0.343366 1.203432 0.955798 0.389970 1.528111 1.208576 0.010439 0.869974 0.035552 1.208552 0.683287 0.473739 0.683814 1.317711 0.374975 1.738225 0.120217 -0.175098 1.582996 0.867052 0.692109 0.493305 1.718047 1.208498 1.811081 1.821705 0.654337 0.217531 -0.099005 1.010084 0.259226 1.288077 1.708184 0.570772 0.336605 0.604351 0.689981 1.178933 -0.158272 0.131307 -0.014422 0.959472 1.490474 1.313114 0.053727 0.366844 0.481538 1.929683 0.975977 1.124109 1.896357 0.758496 0.888582 0.159146 0.818597 1.655710 0.590078 1.621154 1.243084 0.695850 0.941639 0.608910 -0.136277 0.932800 1.416731 0.412678 0.218232 0.303734 0.129337 1.481931 0.515983 0.719833 1.705010 0.804065 1.067955 0.475270 0.737429 1.074355 1.333884 0.284629 1.317930 1.349354 1.980213 0.481352 1.075718 1.302558 1.547761 1.722849 1.882200 1.571505 0.804632 1.874854 -0.081974 1.014450 0.864487)
      )

;;; 512 odd --------------------------------------------------------------------------------
#(512 35.541 #(0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0)

      31.627573 #(0.000000 0.641971 0.823435 1.073329 0.539150 1.644256 0.942410 0.791472 1.064522 0.907704 1.428794 0.001231 1.342358 1.365932 0.655059 1.273217 0.387305 1.151713 0.464556 0.040873 1.211746 0.565890 0.572488 0.447248 1.881382 0.212994 1.677831 1.225395 1.627225 1.565389 0.526112 0.810610 1.095356 0.987163 1.475014 0.670579 0.628158 0.893664 1.170671 1.124505 0.755854 0.300778 0.869316 0.919963 0.365823 1.723706 1.014851 0.498120 0.637194 0.352754 1.176211 0.866662 0.273392 -0.100029 0.834522 1.417914 0.163216 0.001094 0.094626 0.941186 0.740318 1.686733 0.919502 0.781344 1.668460 1.372868 1.926722 -0.013075 1.859527 0.808579 1.050819 1.202535 -0.065064 1.005084 0.221611 0.092920 0.014314 -0.126624 1.411892 0.640148 1.726499 1.132514 0.613199 0.879500 1.336432 1.600858 0.194537 1.580641 0.936076 1.506791 0.812228 0.638475 1.187229 1.635303 1.915488 0.799069 0.160834 0.881635 0.830638 -0.237466 1.203243 0.069071 1.015759 1.594863 0.741846 0.396797 1.024115 1.576269 0.297798 0.159265 1.736938 1.305428 -0.180384 0.324437 1.638834 1.298223 1.545155 1.094452 0.373838 1.545743 1.267383 0.175106 0.836172 0.339434 1.641107 0.308164 0.618412 0.020865 1.493642 1.738528 0.223837 1.728277 -0.001512 0.572589 0.109109 1.031926 0.299462 0.994195 1.218696 0.638982 0.509796 1.559371 0.148304 0.598851 1.007413 1.005303 1.318366 0.405786 1.262346 1.267264 0.506932 1.133813 0.475700 1.880509 0.789002 0.453480 0.239026 0.227558 1.059055 0.767671 0.566336 0.870093 0.650822 1.420300 0.752287 0.068587 0.289154 0.589494 0.967799 0.716662 -0.136748 0.894624 1.762980 0.374462 0.652941 0.795161 0.405835 0.987008 1.149128 0.792408 1.814055 0.946290 1.372088 1.420931 0.766271 1.803197 0.048647 0.842236 1.000451 1.426188 0.472345 1.886308 0.733469 0.500330 1.201671 0.533436 0.047414 0.185851 0.012020 0.210052 0.058992 0.149168 0.225954 1.275422 1.600178 0.027805 0.734000 1.142974 0.760770 1.247212 1.162280 1.726486 0.314615 0.098353 1.326208 1.035621 0.171545 0.304654 0.998041 1.758815 1.437338 0.710766 0.526788 0.043168 0.406921 0.608124 1.606403 0.893683 0.477997 0.000670 0.488634 -0.069036 -0.061680 0.112820 1.036929 1.548689 0.075054 1.741209 1.196178 0.352973 1.109566 -0.088309 0.774755 0.401376 0.242119 1.087618 0.068851 0.857888 1.221587 -0.019816 1.439372 1.169566 1.554426 1.678997 1.788747 0.784626 0.497675 1.010605 0.845773 1.777904 0.686256 1.393740 1.509084 1.190820 0.403592 1.261550 1.103977 0.536027 1.461863 1.261457 0.063297 0.362984 1.275933 0.945974 -0.109974 -0.203292 0.297974 1.745096 1.406757 0.680111 1.145314 0.780465 1.423008 -0.110897 0.521349 0.893654 1.653106 1.409408 1.732378 1.643879 1.021437 0.297832 0.198983 1.426222 1.445222 0.925063 0.860053 1.108162 1.379936 1.207276 1.543307 0.381530 -0.226848 -0.264262 0.012490 0.992932 0.864424 1.492055 0.915972 1.732040 0.817003 0.307476 1.352170 0.423888 1.329013 1.399071 0.992404 1.355255 1.651646 0.309776 1.671406 1.043917 1.869139 1.594136 -0.005031 1.744908 0.655800 1.327847 1.409992 -0.103359 0.063715 0.768347 -0.043384 1.369031 0.587208 1.037146 1.074892 1.093514 0.744290 0.053865 0.348258 1.204096 1.167382 -0.131176 0.694914 -0.167478 0.848484 1.882004 0.096415 1.570844 0.993590 -0.020994 0.913612 1.588955 0.704219 1.085327 1.546526 0.651243 0.540599 0.940847 0.628133 0.081446 1.846942 0.928486 0.107920 0.007586 -0.062816 1.188460 1.236358 1.495043 0.028409 1.657622 1.712531 1.879651 0.801929 0.276453 0.178559 0.124729 0.356095 1.077818 1.274958 -0.171551 0.461760 0.426529 0.303303 0.286626 1.048164 1.799901 1.036822 1.694543 0.305443 1.309533 1.256076 0.827871 0.345051 1.259048 0.783575 0.662862 0.523535 0.764332 1.439512 1.490591 1.277727 1.771280 0.968938 1.828813 0.616693 0.026985 0.630998 1.165842 1.604957 0.506658 1.643773 -0.010849 1.199100 -0.097492 1.070350 1.825319 1.071090 -0.091097 0.476000 0.246988 0.001741 1.570443 0.157951 1.654163 0.256397 0.418448 0.401357 1.115814 -0.163746 0.006042 1.620231 1.476353 0.625221 1.336783 1.237377 1.107035 -0.011244 0.501244 0.937261 0.874984 1.284656 0.415597 0.001246 0.170531 1.295187 1.042093 1.554322 0.772877 1.325785 1.217688 0.441610 -1.899803 0.043140 1.813774 0.405185 1.057689 0.374283 1.706719 1.083516 0.941168 1.031645 1.166947 0.663039 1.808751 0.239071 1.846075 0.787534 1.538073 1.752155 0.737674 0.162097 1.744119 0.626675 1.785334 0.656878 1.530504 1.882550 -0.066498 0.448671 1.407281 0.142294 0.329252 0.502527 1.533283 1.717776 1.422026 0.012518 1.271419 1.775104 0.652861 0.652894 0.475309 1.835944 1.609988 -0.142017 0.251089 0.591652 0.158013 0.883469 1.255936 0.571626 0.204126 1.716678 1.066841 0.807994 1.069000 0.686395 1.517494 1.291233 1.140441)
      )

;;; 1024 odd --------------------------------------------------------------------------------
#(1024 52.508 #(0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0)

       48.812539 #(0.000000 1.519639 1.650443 1.195998 1.376729 1.899699 1.970244 0.812566 0.904608 0.600090 1.324454 0.983250 1.017466 0.767844 0.473656 1.362846 0.411668 1.143136 1.709002 1.799336 1.634334 1.127351 -0.096953 1.054946 0.631221 1.250117 1.431825 1.462402 0.392219 1.150149 0.361692 -0.007895 1.410301 -0.155259 1.559313 1.025404 0.848567 0.413175 1.206342 0.941843 1.655170 1.899345 -0.179528 1.520982 0.422331 1.843755 0.338626 0.259524 1.219677 0.928668 0.359292 -0.035002 0.292293 1.153387 1.456000 -0.123570 1.766526 1.738248 0.524497 0.103671 1.368994 0.239364 0.976560 1.227616 0.548531 0.854823 0.785093 -0.197237 1.336605 1.539099 0.835663 1.511255 0.962715 0.529653 1.142525 1.602263 1.389138 0.657746 1.560084 0.537641 1.281309 1.646253 0.540975 0.972241 -0.100372 0.678740 1.332669 1.561545 0.551248 1.375355 0.212979 1.193149 1.549790 0.906638 1.351033 1.793558 1.975586 1.399301 1.183386 0.721803 1.068055 0.343392 -0.284674 0.637779 0.099731 1.080489 1.644659 1.671862 0.243661 1.739989 0.343292 0.666143 1.387914 0.983866 0.682169 1.307094 0.441588 -0.079958 1.574357 0.516534 0.821922 0.946185 1.676179 1.618357 1.436315 1.560073 0.444652 1.752148 1.545784 1.140653 1.762060 0.454780 1.132888 1.286946 0.909353 0.217248 1.608014 0.408949 0.982308 0.842400 -0.210310 0.264674 0.498652 0.910983 1.178934 -0.004034 0.340697 0.615753 -0.136166 1.321752 0.263196 1.709158 0.839955 1.174310 0.322353 0.297043 1.553360 1.401766 1.007148 1.677521 0.741845 0.907691 1.276494 0.432523 1.605921 1.143725 1.756996 0.320225 1.288530 0.332776 -0.196583 0.603381 1.336746 0.086445 1.672621 0.890109 0.463938 1.357177 0.922958 0.697499 0.299459 1.219213 1.829846 1.943642 0.749969 0.829949 0.653853 0.398390 0.727336 1.275356 0.674723 0.748253 0.256595 0.201768 1.419157 0.468013 -0.030328 1.410807 0.229406 1.979323 1.794527 -0.016365 1.616308 1.369367 0.712107 1.706465 1.848255 0.226421 1.849134 0.380595 1.411511 0.299912 0.108735 1.186805 0.457520 0.271926 -0.067552 1.609142 1.431855 0.868110 1.197096 1.629939 0.035468 1.862078 0.753638 0.605706 1.277352 1.735611 1.272105 0.935222 1.246256 1.571576 1.870573 0.025272 1.040066 0.940302 1.227315 1.882565 1.396880 0.843794 1.345301 0.792983 1.395248 0.706526 1.661413 0.446114 0.907125 -0.062988 1.049496 1.071169 1.136989 1.421889 0.905366 0.518945 1.552620 0.983677 -0.059829 1.561292 1.006026 0.133199 1.906396 0.441897 1.763764 1.574203 1.360252 1.738862 -0.148160 1.201349 0.701943 1.000967 1.904072 1.310693 -0.020100 0.178949 0.724875 0.252065 0.310697 1.382325 1.227708 0.408125 0.958815 0.649841 -0.077987 1.301784 0.826432 1.474625 0.805014 1.200874 0.124273 0.639817 0.336398 0.230644 0.675556 0.205384 1.219305 0.297402 0.896968 0.099148 1.180783 0.995222 1.801650 1.005890 1.669304 1.555321 0.893841 0.076777 0.821684 0.103460 1.274312 1.641740 0.108476 0.474745 0.106818 1.121379 0.259728 1.241445 0.558062 0.844266 0.902584 1.679800 1.962091 1.160123 1.751210 1.564581 1.787630 0.017232 0.526177 0.946544 1.537788 0.162595 0.274043 -0.044734 0.870207 1.061828 1.973221 0.316719 1.874725 1.919981 0.798782 -0.079217 1.207291 0.982608 0.779931 0.543867 1.919099 1.476795 0.646670 0.139511 1.457573 1.694085 0.629716 1.716191 0.131491 0.664390 0.787058 0.586046 0.644992 -0.006434 1.389868 1.461697 1.509464 1.325643 1.325259 1.204176 1.780741 0.818762 0.535146 0.040136 1.734284 1.577489 0.131655 0.306406 1.644914 1.594499 1.639871 1.971222 1.349697 0.012654 -0.129510 1.611419 0.072394 1.749559 1.734331 0.117738 1.641966 0.797545 0.365172 0.268189 0.523823 1.624812 0.594331 1.509286 0.660606 0.244640 1.683550 0.574769 0.691397 0.958587 1.980250 -0.055636 0.626289 0.244708 1.483613 1.349865 0.598110 1.383298 0.003756 0.637659 -0.080158 0.676783 0.636104 1.458856 0.713675 0.532894 1.606586 0.019165 -0.068957 1.679326 1.139161 0.032928 0.191688 1.041482 0.050956 0.579658 -0.086398 0.011405 1.881689 0.667973 1.016102 0.664665 0.937454 1.751825 1.316685 0.124775 1.792093 0.746284 1.794429 0.643490 0.622783 0.556543 0.160050 0.107300 0.132343 0.640078 1.177660 1.821213 1.816797 0.766212 0.843537 1.824573 0.062901 1.724824 1.075620 -0.018658 1.030264 1.530522 1.314744 1.689721 0.324854 0.383385 1.535095 1.312333 0.745413 1.612902 0.986807 0.028575 0.527696 0.022035 1.685790 0.049529 0.258771 0.934595 1.292434 1.410893 0.805550 0.379555 1.953132 1.889999 0.256214 1.738588 -0.077133 1.023294 0.169218 0.252723 1.382993 1.154004 0.545944 1.321628 0.996409 1.398047 0.279943 0.403421 0.999037 1.888683 1.595423 1.628037 0.559370 1.693110 0.686705 0.382186 0.172950 1.892951 0.773946 0.976296 1.321030 0.111411 1.621968 0.153825 0.547817 1.789581 1.033120 1.189280 1.377718 0.724048 1.497776 0.211222 1.135220 0.266237 -0.119750 1.227078 1.763611 1.286882 0.019319 0.217713 1.199864 0.139524 1.574282 1.464184 1.150806 0.500220 0.119072 0.741896 0.924713 0.317970 0.222493 1.640251 0.523108 0.481320 0.822623 1.781413 0.213174 0.526517 0.784168 0.325984 1.630501 0.652451 0.316042 0.853892 0.706219 0.007041 1.327154 1.456855 1.828532 0.975735 0.357055 1.857690 1.354029 -0.002919 1.867148 0.775657 1.449311 0.258681 1.761863 0.655676 1.286698 0.401581 1.805723 0.089138 1.750159 -0.068260 1.189680 0.106126 0.502482 -0.049569 0.188084 0.806860 1.767305 0.783989 0.042035 -0.089529 1.620846 1.742942 1.638746 1.719033 0.620464 0.165571 1.198973 1.674614 1.772405 0.539545 0.054570 1.607511 1.487697 0.667428 0.150144 1.328158 1.098030 0.732064 1.431842 1.088525 0.593456 1.151458 1.172287 0.425020 1.182693 0.220969 1.859578 1.566433 0.923298 0.977581 0.362573 0.127506 1.222420 1.575324 1.416319 0.704553 0.751691 0.764554 1.478321 0.276418 0.260139 1.048863 1.597529 1.209535 1.071833 1.356900 1.823221 0.498971 0.746938 0.652020 1.900459 0.028526 1.481411 0.327912 1.079162 1.904872 0.898093 0.576127 1.484575 1.189478 1.135242 0.137399 1.126530 0.274352 0.797920 1.009056 0.338346 1.610297 -0.226829 1.631574 0.959330 1.320781 1.954762 1.442338 0.384065 0.746277 0.250366 1.096580 1.790088 0.003760 0.999329 1.147548 0.586431 0.599300 1.667488 1.279694 1.378872 0.759814 0.286225 0.889077 1.344080 1.453847 0.842622 0.487144 1.759146 -0.021070 1.741457 0.255220 -0.087000 0.379022 1.406398 1.296095 1.573207 0.547077 0.266035 1.220016 0.967606 1.841949 1.059298 0.545929 1.503344 0.057557 1.865376 0.175297 0.023235 -0.129818 0.081379 0.343826 0.309096 1.178139 1.234620 0.401212 0.247771 1.242728 0.215679 1.555335 0.391381 0.215626 1.318046 1.403085 1.109228 1.784926 -0.059823 0.366344 1.472272 0.134227 0.905526 0.317002 1.705593 0.778299 1.488104 1.866262 0.311398 1.071911 0.626873 0.238504 -0.012674 1.321815 0.134023 0.680665 0.878893 0.847214 0.978909 1.839554 0.440437 1.381565 0.402718 0.001953 0.405290 1.118864 1.625751 0.595378 1.714297 1.740414 0.774178 1.699347 1.192736 0.295696 1.260521 0.701036 1.140521 0.356675 0.978455 1.370680 1.420406 0.130293 1.653114 -0.018893 0.205569 1.517424 0.446663 1.261641 1.895881 1.784830 1.763404 1.312276 1.486071 1.216977 1.956752 0.167875 1.476998 0.857182 0.633043 1.109241 0.002331 0.823632 0.871605 0.377286 0.698788 0.438774 1.153781 1.232744 0.574432 -0.020814 0.677651 1.865215 0.654114 0.735767 1.621349 1.517040 1.717531 1.731811 -0.054153 1.877084 0.317175 0.457941 0.096350 1.311998 0.489681 1.413648 0.564409 1.706366 0.164517 0.790116 0.629520 1.107932 0.148285 0.249165 0.506282 0.500732 0.232053 1.264683 0.554141 0.156996 0.326906 1.494430 0.478989 0.922682 -0.195313 1.587851 1.760958 0.894217 0.283230 0.952266 0.740249 1.100321 0.880764 1.505061 0.604270 0.704770 -0.047172 0.511816 1.807854 0.422215 1.522333 0.963650 1.304077 1.666527 1.502872 0.589480 1.376377 1.698090 1.158540 0.370463 0.811208 0.347224 0.006019 0.975977 1.784091 1.823852 0.346739 0.110648 0.819458 0.262966 -0.022950 0.321824 0.959696 0.889141 0.219784 1.217523 1.828829 1.188780 0.642719 1.233994 1.041576 0.808517 0.545278 0.807380 -0.100107 1.389803 1.807516 0.153430 1.534635 1.483870 1.199173 0.558907 1.363742 1.066229 0.228446 0.249453 0.894989 0.990075 0.432789 1.489101 -0.125393 1.049266 -0.060522 0.592996 1.108054 0.556959 -0.010652 -0.122495 1.192843 1.419502 1.033551 1.312986 1.654147 1.925127 0.570975 0.668912 0.596661 0.829670 0.124816 1.442843 0.029297 1.031269 1.673783 0.961837 1.711478 0.674847 0.749091 0.236244 0.804937 1.696901 0.928621 0.764829 1.715576 1.230534 0.889448 0.986091 0.837907 1.573717 0.972857 0.317330 0.783659 1.499296 1.172750 0.024671 0.919212 1.526316 1.664955 0.823036 1.671347 0.781608 1.212905 0.794665 1.831645 0.704887 0.663996 1.716970 1.335391 0.027250 0.914860 1.219676 1.163079 1.499094 1.582351 1.784156 1.039722 0.794989 0.345994 0.696063 0.060440 -0.034531 -0.014465 0.729209 1.532895 0.872457 0.952792 1.406826 1.546432 0.813457 0.051863 -0.057923 1.613237 0.606250 0.434442 1.717713 0.718646 1.651523 1.780966 1.568871 1.319644 -0.013301 0.004435 0.210102 0.085420 1.825764 0.539987 0.842744 1.405067 0.388233 0.609273 1.790490 0.014141 1.051512 0.713006 1.582000 1.973531 0.351609 0.656460 -0.024499 1.169279 0.458410 1.325534 0.274793 0.654578 0.624672 0.130134 0.295107 0.020848 0.076070 0.118378 0.940751 1.186130 0.553624 1.471068 1.866328 1.822359 1.955424 1.788350 1.554351 0.750241 0.632195 1.295917 -0.114335 1.180616 -0.008546 1.109797 1.348653 1.327862 1.845807 0.705358 0.002658)
       ) 

;;; 2048 odd --------------------------------------------------------------------------------
#(2048 83.108 #(0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0)

       78.937441 #(0.000000 1.689846 1.018490 1.611502 0.639207 -0.082787 1.592906 0.601026 0.457537 0.853588 0.246480 0.384884 1.166407 1.518233 1.610776 0.682841 1.354812 1.022675 1.260499 -0.112300 0.069724 0.538233 1.350546 1.731710 1.788711 0.798385 1.720292 0.552885 1.914312 0.083341 1.189678 1.001287 -0.016752 0.082208 1.635077 1.097941 -0.211066 1.915710 0.755430 0.377368 0.141690 1.508951 -0.063008 0.455045 0.203452 0.898819 1.541895 0.734814 1.350906 1.164589 0.953740 1.385840 0.788728 1.463142 1.354194 0.191281 0.579789 1.257225 0.559072 1.122363 1.468759 0.308060 0.535123 0.171149 -0.035758 0.383213 1.313251 0.349952 1.270535 1.135458 1.334934 1.890883 0.201654 1.594547 1.903186 1.646471 0.951539 1.635073 1.622014 1.631851 1.367584 1.552595 1.728701 0.503153 -0.095067 1.062992 1.535287 0.428952 -0.115113 0.904825 1.834421 1.316028 0.139571 1.862408 1.474241 0.357211 1.399016 0.565894 0.914744 1.336730 -0.021306 0.427360 0.982944 0.246389 1.520693 1.429115 1.795578 1.639579 0.993318 1.397084 1.476412 0.372916 0.127072 0.078109 1.452725 1.376697 1.742105 0.223687 0.910528 1.065049 1.633967 1.318213 0.850379 1.824021 0.982950 1.747574 1.683992 0.758363 0.534234 0.648109 1.761061 1.684306 0.998762 0.599534 0.636315 1.560104 -0.085181 0.292286 0.687333 1.315914 1.968365 0.498146 0.872936 0.750372 1.064806 0.913607 -0.281292 1.049262 1.431464 0.630016 0.070509 0.782794 0.040723 1.266929 0.098300 0.871494 1.325216 0.428614 -0.023960 -0.257052 1.568632 1.612023 0.370339 0.462301 0.888796 -0.048313 0.277648 1.743637 1.021040 1.635300 0.468648 -0.299562 1.640302 0.579774 0.064992 0.038520 0.939604 1.190498 0.120304 0.541286 0.541673 1.009244 1.560773 1.452497 0.646789 1.167337 0.164892 1.045596 1.183654 1.504427 0.689198 0.507543 0.474697 0.285834 0.591708 1.250029 0.879318 1.605841 0.233841 0.888556 0.769118 0.609719 0.005003 1.165066 1.500099 0.895021 0.312884 -0.181818 -0.210240 0.557941 0.168915 1.201735 1.729684 0.438679 0.710349 0.066805 1.172545 1.217293 1.790687 0.425805 0.600925 1.609051 1.095530 0.709253 0.066051 1.122549 0.360681 0.504521 1.391375 1.336403 0.056554 0.787635 0.366142 1.100069 -0.145467 0.490070 0.750042 0.057074 0.500767 1.115333 1.323101 1.500424 1.652321 1.578052 1.424819 1.991538 1.503509 1.341974 0.124773 0.286553 1.512043 1.195123 0.116467 1.495999 0.150475 0.027458 1.256602 1.914178 1.348946 0.392902 1.287852 0.230423 0.958003 0.103199 0.114147 1.300265 1.337726 1.960234 0.875466 1.375678 0.887083 1.091556 1.629083 0.517975 0.251541 0.586015 0.521301 0.456918 1.797111 0.628470 0.222309 1.874302 0.151586 1.270942 0.496347 1.704067 1.347411 0.882141 1.354015 0.482906 0.856096 1.842757 1.198720 0.849675 1.254644 0.826368 1.421665 1.565656 1.849673 0.296163 1.321414 1.594984 0.087468 1.904057 1.770304 0.793373 1.811382 1.738248 0.462200 0.809299 0.173428 1.173632 0.144430 0.424475 1.053220 0.438286 1.053618 1.341106 0.601239 0.987605 0.470342 -0.084584 1.657004 0.844639 0.225215 0.485905 0.210184 0.877181 0.051768 0.365625 0.433545 0.746015 1.265726 1.261056 0.846870 0.380347 1.777246 0.734969 1.263058 1.188062 1.231298 0.176469 0.633541 0.141868 0.355117 1.292107 0.788635 0.283102 1.491545 0.163836 1.840225 0.320653 0.924229 1.684915 0.457135 0.366316 0.874699 0.332267 0.811181 0.009053 1.707102 1.224700 0.647231 0.470735 0.285938 1.249680 0.848736 0.154419 1.302189 0.895984 0.384598 1.149654 1.339615 0.657930 0.197967 1.099859 0.240221 -0.153442 0.545081 0.929453 1.706713 1.972300 1.409127 1.618121 0.006566 0.576765 0.166203 0.440455 0.587109 0.296341 1.125394 1.573122 0.397018 0.779058 0.971743 0.402398 1.799594 0.038208 1.672239 0.269341 0.945851 0.650314 1.220807 0.761092 1.240143 1.289371 1.635050 1.213648 1.046902 1.318709 1.036745 0.879976 -0.197862 1.091013 0.799716 0.415004 0.529374 0.637845 0.383399 0.463124 1.542566 0.699920 1.623643 1.293281 1.800152 -0.015788 0.322487 1.117097 0.956307 0.996452 1.172323 1.326188 1.147377 1.113843 0.785183 1.575362 0.649795 0.523062 1.860141 0.223472 -0.063293 1.909246 1.736574 0.279197 1.477865 0.554212 1.260388 0.277292 1.918266 0.649419 1.792368 0.946606 1.286217 1.246372 1.179007 1.168477 1.733196 0.040035 1.869694 0.417707 -0.156793 -0.001456 0.649687 1.705122 1.327413 -0.139936 1.559127 -0.059925 0.722765 0.854277 -0.012595 0.185935 0.880412 0.884245 1.159530 1.868145 1.721058 1.444300 1.726310 1.551803 1.792034 1.663910 1.037587 0.549667 0.246300 1.919241 0.898305 0.864542 0.391918 1.169414 1.044794 0.943499 -0.018653 0.086991 1.211404 -0.409634 1.709608 1.558102 1.500905 0.023446 0.566640 1.586175 -0.075684 0.457930 0.590761 1.012075 0.155814 1.237055 1.774284 1.163196 1.795167 1.756188 0.853326 0.344718 1.331156 1.207746 1.380685 0.825802 -0.204853 0.528726 1.294224 0.820804 1.714428 1.655171 0.596704 0.807545 0.528328 0.170826 1.360744 1.164118 1.534691 1.959252 0.988720 1.825915 0.954587 1.225160 1.067375 0.648538 0.689203 0.574944 0.228763 0.739069 1.338497 1.522466 1.148973 0.666870 0.301196 1.345073 0.515258 0.304323 1.626868 0.573854 0.770224 0.922824 0.986235 0.208474 0.534145 1.448620 0.464703 0.329886 0.435022 1.080056 1.761027 1.393992 0.840270 0.262735 0.545578 0.566577 1.039111 1.013874 0.439128 1.378553 1.474475 0.078150 0.097586 0.430367 1.040096 0.267498 1.407214 0.720580 1.398352 1.906690 1.573703 0.691050 -0.001253 1.087465 0.916375 1.561718 1.104275 -0.024568 1.743167 0.657410 0.043592 -0.071737 1.277783 1.669473 1.445207 1.805207 1.084871 0.357552 0.482975 -0.129299 0.222610 0.964868 1.674946 1.111144 0.811232 1.444958 0.936872 0.630285 0.291784 0.547889 1.274707 0.491720 1.178913 1.597362 1.417560 0.905568 0.064594 -0.006279 0.681924 0.572009 0.510396 0.882066 1.337806 0.824705 0.900296 0.161452 1.480708 0.429205 0.998680 0.862028 0.872584 1.079492 0.049996 -0.061398 0.641068 1.223042 0.895426 0.016166 1.705578 0.370580 1.235064 -0.076644 0.016159 1.553502 0.272781 1.680527 1.735360 1.216306 0.022477 1.458031 0.335270 1.029615 1.390275 -0.072170 0.673519 0.918164 0.172376 1.873272 0.143937 0.143151 1.946490 1.050878 1.389078 1.718545 0.761876 1.584491 0.076813 0.426127 1.157282 1.665873 1.282022 0.297428 1.612887 1.525788 0.109507 0.850433 1.541619 1.906604 1.351349 0.712067 0.032909 1.741764 1.603154 0.331176 1.967791 -0.047457 0.458334 0.650869 1.822431 1.699982 0.392443 0.889921 0.738170 1.855018 1.469024 1.304174 0.145973 0.241900 0.483690 0.610548 0.244614 0.690385 0.625302 1.254416 1.724031 1.813264 0.692617 0.895372 1.588647 1.665977 1.093177 1.780833 0.040080 0.147953 0.452095 1.815039 0.610101 1.499230 0.418529 1.527535 1.809753 1.780717 1.208619 1.087756 0.044489 1.396951 1.008861 1.166751 -0.015608 1.040863 1.011715 -0.389544 1.669576 1.727841 0.409541 1.391926 1.267091 1.816381 1.266583 1.292674 1.538488 0.792896 1.144202 0.190028 1.168753 0.058544 1.008912 -0.033880 0.982838 1.145292 1.408490 1.218427 1.723407 1.907386 0.024240 0.720236 0.415344 1.872643 1.418392 0.399808 1.547256 0.227670 0.450452 1.674352 0.768133 1.757588 0.207193 1.366841 0.954998 0.102805 1.840467 1.672033 0.946903 0.828078 1.755832 0.884133 0.608293 1.688522 1.454057 -0.091730 -0.218085 1.430139 1.876307 1.361689 0.162513 0.428011 0.099895 1.496198 0.017040 1.527240 1.600076 0.702599 1.227307 0.445765 0.991653 0.193662 0.653609 0.032302 -0.082556 -0.076239 1.247906 1.725657 0.098284 0.458830 0.585844 0.788715 0.476530 1.571552 0.062623 1.411266 1.153636 1.113152 0.388102 1.666505 -0.010299 0.608357 0.002597 0.400810 0.236498 1.574672 1.024283 1.142883 0.739700 1.197592 1.569635 1.120229 0.086709 0.760356 1.446372 0.526550 0.983182 0.898425 1.210298 0.777244 1.126512 0.150391 1.780786 0.777891 1.141635 0.546798 1.666439 1.352269 0.900695 1.494562 0.579397 0.725360 0.320734 0.768538 -0.104320 1.309681 1.358290 0.178735 1.223322 0.916266 0.737696 0.608325 -0.024323 0.252577 0.022089 0.625930 1.055275 1.732884 0.450856 1.338871 0.564340 0.408611 1.468491 1.325711 0.758030 0.859666 0.600947 1.793976 0.169648 1.263140 0.822255 0.174901 0.291032 1.213018 1.398540 1.120993 1.022251 -0.023604 1.740733 1.244085 0.970147 0.777177 1.692535 0.188452 1.351635 1.161318 1.256602 1.751087 0.013196 -0.020020 1.265055 1.092603 1.917020 0.602027 0.227003 1.388828 1.812699 0.448303 0.993327 1.552104 0.642990 0.227204 0.536533 -0.171320 -0.037833 0.286305 1.107339 1.082198 1.823262 -0.118176 1.508469 0.574280 0.745998 0.151052 0.343717 0.754622 0.850362 0.188574 1.308237 0.557021 1.622333 0.740050 -0.106173 -0.036187 0.929924 1.028599 0.128394 0.655953 0.554832 0.478155 1.700954 1.480740 0.692557 0.784791 0.538025 1.181506 1.027617 1.061888 0.554753 1.885562 0.427859 0.878171 1.705383 1.731963 1.584336 0.604257 1.269572 1.224752 0.395571 1.377190 0.473402 1.037091 1.321103 0.241379 0.536589 1.212185 0.436461 1.328625 1.400157 1.301094 0.177789 0.219838 -0.214149 1.529232 0.144458 1.192349 1.282177 1.056078 1.550038 -0.173016 0.100030 0.265853 0.645390 0.923329 0.085731 1.043286 1.818031 1.237997 1.530902 0.423281 0.255900 0.058007 1.501958 0.593022 0.868580 1.054524 0.798523 1.892550 1.536475 1.470470 1.466108 0.333749 0.753592 0.381069 0.805574 -0.083849 0.230417 0.524273 1.576543 0.796882 1.326149 1.468547 0.883022 1.145331 1.129588 0.767485 0.714530 -0.051568 0.381323 0.900830 0.938250 1.115005 0.803678 0.478197 0.102689 1.790473 0.186175 1.138002 0.407343 0.081624 -0.078497 1.907566 0.568199 0.206528 0.698892 1.618703 1.116152 1.630912 0.735694 1.657675 -0.029995 0.597313 -0.074403 1.651119 0.671345 0.428239 0.340794 0.303227 1.221853 0.149125 1.845223 0.690593 1.519544 0.570921 0.378247 1.959188 -0.007756 0.533438 1.355284 0.385166 0.748448 0.519275 0.121959 0.127587 1.048075 1.696453 0.957310 1.509362 1.558839 0.717115 0.377524 0.867385 0.483117 1.383031 -0.097048 1.840125 1.664936 1.781564 0.631422 -0.103132 0.403964 1.771127 0.746246 0.918520 1.169435 0.737263 1.212805 1.178431 0.492576 0.605805 0.341944 1.377818 0.931836 0.529464 1.388507 1.052530 0.254824 -0.081377 0.937911 1.308701 1.681287 1.041637 0.101439 0.808291 0.144335 0.199211 0.907294 1.556385 1.606147 0.993618 0.565487 1.805140 0.626057 0.297878 0.108579 0.333362 0.383693 0.664077 0.780133 1.818635 1.485239 1.804957 1.845173 0.759440 0.296443 1.827938 0.708014 1.691701 0.097561 1.790460 0.002644 1.363152 1.554413 0.128835 0.088458 1.075820 1.662939 0.305822 0.097597 0.951771 0.612277 0.927043 1.564098 1.633525 1.149458 0.821430 0.621419 0.295695 -0.035046 0.526376 1.760242 0.054878 0.643260 1.248458 0.803343 1.623275 0.668091 0.657572 1.121589 1.524828 1.183610 1.417931 1.405314 0.536478 0.777992 1.514447 1.406728 1.296213 0.977414 1.302449 0.188034 0.494615 0.604689 1.593324 0.321907 1.433822 0.820379 0.896724 1.841162 0.648542 0.849222 1.488341 1.646264 0.422691 1.202526 1.552600 1.286227 0.205148 0.977204 0.071457 0.072226 0.854723 1.474934 0.490317 0.994710 1.695319 0.149264 1.945845 -0.050080 1.100174 1.428384 0.392919 1.388543 1.470599 1.687390 -0.209425 0.981376 1.820625 1.486939 1.163029 0.254903 1.663587 0.173397 1.158270 0.008252 1.527331 0.957022 1.565874 0.399190 1.405211 1.610452 0.517417 0.017736 1.604007 0.441982 -0.117242 1.540578 1.122133 0.783699 1.475956 0.425079 0.061031 1.809454 0.020958 1.791601 0.082641 1.232839 0.787976 0.330191 1.079316 0.726671 1.154152 0.664516 0.651535 0.733283 0.178061 1.170989 1.021345 1.431385 1.099593 1.694602 0.959398 1.896463 1.048918 0.980361 1.074828 1.193343 0.231910 1.142775 1.514885 0.820666 1.664680 1.082302 1.454204 1.588263 1.689028 1.772394 1.918052 0.740639 0.483110 0.712257 0.069489 0.905804 1.535153 0.363147 1.835617 0.006427 0.899992 0.380714 1.396011 0.685106 1.823151 0.493868 1.604512 0.224912 0.847624 1.141404 1.562281 1.012902 0.067857 0.682509 1.253834 1.124161 0.614664 0.283374 1.613595 1.434018 0.305996 1.201243 1.266871 0.838092 0.076908 1.420109 1.146620 0.622686 1.115452 0.924323 0.974351 0.825545 1.439257 1.047256 0.983947 -0.023433 0.739378 0.058896 1.009265 0.099088 0.208031 0.584839 1.555592 0.199829 1.098928 1.389603 0.203500 1.217365 0.487433 0.522761 1.901220 0.024564 0.335503 1.627773 0.511258 0.181775 1.136641 0.858910 1.135934 1.389248 1.254197 1.570636 0.887318 1.421787 1.619915 1.382710 0.324584 1.154740 1.550762 0.651293 0.306905 1.355501 0.026583 1.261312 0.455843 1.440013 1.036724 1.152275 0.920599 0.682892 0.672700 1.070057 1.453899 1.087117 1.098307 1.315810 1.292233 0.819280 0.701348 0.997834 1.209758 1.168699 0.077635 0.868252 1.083290 1.930890 0.353494 1.250223 0.310608 1.253033 1.727092 -1.975097 0.941442 0.539454 1.355973 1.005988 0.701618 1.813894 1.775295 0.242359 1.510528 0.986700 1.547890 -0.012287 1.356305 1.522370 0.878012 1.294380 0.155478 1.042814 0.348062 1.188096 1.135315 1.520515 0.878021 0.622847 1.073612 0.317276 1.370638 0.685988 0.992102 1.497485 1.458836 1.101655 0.035966 1.192860 0.380699 1.178862 0.618449 0.213396 0.559044 1.830349 1.447613 0.780973 0.149827 0.000783 1.578653 0.246629 0.619069 0.870396 1.009880 0.007773 1.529581 1.531002 1.437893 1.160448 0.240842 0.009787 1.814160 1.271699 0.449839 0.395650 -0.113986 -0.067771 0.643784 0.033350 0.664053 1.167828 1.330358 0.974541 1.039259 1.278764 0.649775 1.807600 1.456944 1.297261 1.733868 0.415873 -0.032983 0.865685 0.984468 1.747983 1.754950 1.624645 0.955834 0.669497 0.707638 0.496434 0.214751 0.573953 1.537258 1.920697 1.147869 0.279585 1.887307 1.463413 0.319350 0.444741 1.008618 1.021958 0.435657 0.185043 1.371241 0.855151 0.505792 0.741886 0.871680 0.370576 1.264162 1.034020 1.020442 -0.032455 0.151317 0.930427 1.250914 0.457365 1.711895 1.622588 1.474334 0.727044 0.158372 0.547219 1.964062 0.960274 -0.043104 1.429620 1.502524 1.799005 1.879995 0.965812 1.601466 -0.115173 1.786859 -0.082629 1.571997 0.151759 0.116636 -0.138644 1.220180 1.544541 0.711250 1.337424 1.122127 1.265975 1.641180 0.369341 0.941194 1.756270 1.554377 0.421053 0.367857 1.468897 0.120653 1.868696 1.648081 0.013217 0.546092 1.094144 0.662116 1.286971 1.508045 0.588153 1.236472 0.589536 0.744566 -0.014088 1.541068 1.703645 1.335776 0.751643 1.645108 1.835447 -0.004121 1.225363 0.415798 1.680503 0.651280 0.657478 1.380731 1.366587 0.360555 1.416929 0.218857 1.003629 0.196413 0.458188 0.219018 0.371207 0.792944 0.732561 1.096142 1.517356 0.544260 0.244358 1.027194 0.914613 -0.264228 1.386405 0.399853 0.192045 -0.056645 0.448320 1.168258 0.216500 1.282546 0.378607 0.437151 0.271768 0.227147 0.947933 1.169574 1.692082 0.352268 1.556365 0.430126 1.874195 1.391513 1.410537 0.937927 -0.099725 1.350224 0.198315 0.235114 1.785468 1.268030 1.467114 1.142498 0.972180 1.325000 0.953697 1.637360 1.870641 0.094691 0.308883 0.051680 0.986847 0.571862 0.079983 1.563896 0.588847 0.287709 0.038406 0.213414 0.278655 1.462399 0.910186 0.949603 0.231716 0.110559 0.750252 1.849528 -0.017336 1.351536 1.030800 0.135700 1.350730 1.752152 1.144277 0.825775 0.482093 0.451732 0.553985 0.050941 1.589921 1.226160 0.121789 1.892118 1.514707 1.947830 1.899008 0.106199 0.095068 1.481495 0.637728 0.793037 1.046402 0.656131 0.981478 1.645677 1.692830 1.201035 1.580738 0.862287 1.857116 0.752617 1.140952 0.535734 1.166873 1.813586 1.358043 1.562120 0.887429 0.453656 0.808900 1.329005 1.880473 1.667600 0.168656 0.082993 0.554744 0.113094 0.184322 1.116499 1.257143 1.463536 0.845188 0.753503 0.545217 0.808865 0.734823 0.010412 0.637141 0.721788 1.206453 1.725305 0.835897 0.641933 0.849589 1.122095 1.122129 0.082734 1.852811 0.736282 0.466664 0.727515 1.164618 0.912293 0.714009 1.682613 0.400246 0.931132 1.423104 0.690233 0.402124 0.519093 0.013658 1.495360 0.513651 1.911956 1.531564 0.638779 1.926638 0.085423 1.244383 1.405098 0.240999 1.024934 0.085108 1.136585 1.354954 0.694244 0.147529 1.114749 0.327110 0.099190 0.519456 1.197549 1.441452 0.985099 0.496182 0.344015 0.311060 0.341567 1.223570 0.104840 1.555720 0.310844 1.427243 0.253303 1.861208 0.751524 1.176798 0.011549 1.520196 0.725046 1.248869 1.766864 1.132848 0.788957 0.794897 0.471681 1.719229 1.386139 1.274509 -0.039519 1.527659 0.844650 1.774762 0.707953 1.216432 1.474809 0.078357 0.551012 1.506891 1.599422 0.243091 0.153408 0.457904 0.924834 1.678234 0.096402 0.949920 1.821400 0.824671 1.452500 1.524634 1.003177 1.464511 1.816518 1.713961 0.863097 0.517152 0.758012 0.136979 0.120142 0.690421 0.223639 1.498008 1.562219 1.678837 1.627798 0.839019 1.132131 1.535145 1.518018 0.297419 0.203623 0.546133 1.052566 0.784445 1.055616 0.148830 1.720326 0.140740 0.266692 1.425404 0.783229 0.124041 1.494743 0.644046 1.644611 0.750264 1.828214 1.787737 0.538946 0.550047 1.183492 1.041592 0.959210 0.270846 -0.035403 1.739175 0.534984 1.624026 1.611428 1.579430 1.022286 0.855608 1.828514 0.038338 1.291444 0.134507 1.254891 0.596733 0.399162 -0.114539 -0.055887 1.938324 1.170327 1.087488 1.697423 0.478833 0.757412 0.171117 1.059573 0.635458 -0.161792 1.015750 1.708417 0.270384 0.660484 1.333092 -0.030724 1.713327 0.151431 -0.174953 -0.041691 0.300599 0.725691 1.065660 0.588839 0.723013 1.086514 1.665008 0.904689 0.943094 1.548079 1.780577 1.098286 1.413405 0.080554 0.679165 0.451513 1.625382 0.791710 0.263149 -0.161505 1.192182 0.992099 0.009485 1.008730 1.535096 1.036929 1.297483 1.822460 0.975063 -0.085459 1.420746 0.376603 0.192391 -0.220597 0.389186 1.323278 0.098973 0.116023 0.308756 0.430429 1.250750 1.912196 0.463174 0.133615 1.184156 0.919106 1.188101 0.221491 0.139415 1.695088 1.043669 0.180492 0.167037 0.186236 1.544480 0.189182 1.816467 0.395217 1.129900 0.056081 1.599691 0.956415 1.935582 1.752012 1.235924 0.567385 1.236629 1.378551 -0.032682 0.967778 1.161775 0.439121 0.146630 0.210634 0.838256 0.256489 1.849426 1.034341 0.180033 0.002728 0.460610 -0.059008 1.026499 0.239384 0.014096 0.253629 1.317847 1.430188 0.739864 1.356334 0.501333 1.570755 0.964145 1.279445 0.064247 0.367146 1.924309 0.038641 1.441898 1.500527 0.252632 0.522914 1.127721 0.149886 0.482652 0.742163 0.866292 0.415201 0.038035 0.581754 1.410195 1.305935 1.399564 -0.002591 1.315112 0.506490 0.634606 0.712693 1.491569 0.763732 1.133934 1.646626 1.199255 1.255783 0.793887 0.463719 1.274033 0.646579 1.299227 0.074139 1.517832 0.680066 0.556593 0.198377 0.731884 1.265722 0.273535 0.174173 1.643091 0.233723 0.835886 0.331656 0.841667 1.950204 1.700806 1.493564 1.992014 1.047484 0.056101 0.246552 1.178977 1.446793 0.909130 0.666524 1.743752 -0.065462 0.647845 1.528075 -0.027380 0.892732 1.060713 0.961817 0.819512 0.522143 0.761281 0.549432 0.374579 0.281346 0.405971 1.961061 0.861053 0.951913 0.894288 0.120547 1.199477 1.578494 0.905148 0.153248 0.867220 0.425392 0.982660 0.841154 1.540130 1.454289 1.585546 1.708407 0.786107 0.741469)
       )
))



;;; ---------------------------------------- prime-numbered harmonics (and 1st) ----------------------------------------

(define primoid-min-peak-phases (vector

#(1  1.0   #(0)
     )

#(2  1.76  #(0 1)
     )

;;; 3 prime --------------------------------------------------------------------------------
#(3  2.1949384212494 #(0 0 1)
     1.980 #(0 62/39 13/41) ; 1 2 3 -- same as :all in this case
     1.9798574987316 #(0.0 1.5896952797511 0.31654707828801)
     1.9798030853271 #(0.0 1.5897271633148 0.31667485833168)
     )

;;; 4 prime --------------------------------------------------------------------------------
#(4  2.5978584289551 #(0 0 1 1)
     
     ;2.2039985204158 #(0 0 12 4) / 20
     2.1930510997772 #(0.000 0.996 0.596 0.217)
     2.1930510997772 #(0.000 1.996 0.596 0.217)
     2.1930510997772 #(0.000 0.004 1.404 1.783)

     2.1927945613861 #(0.0 1.0065363103693 1.4072853370949 1.7873527125308)
     2.1921416218407 #(0.0 1.0052774357064 1.4058145325161 1.7854903085184)
     2.1921210289001 #(0.0 1.0052587985992 1.4057868719101 1.7854607105255)
     )

;;; 5 prime --------------------------------------------------------------------------------
#(5  2.7172040939331 #(0 0 1 0 0)

     2.476848 #(0.000000 1.577434 0.385232 1.294742 1.022952)
     2.476837 #(0.000000 0.422530 1.614642 0.705077 0.976763)
     )

;;; 6 prime --------------------------------------------------------------------------------
#(6  3.1241359710693 #(0 0 0 1 0 0)

     2.805574 #(0.000000 1.568945 0.034019 1.082417 0.900415 0.797509)
     2.805492 #(0.000000 0.431060 -0.033992 0.917551 1.099550 1.202470)
     2.805413 #(0.000000 0.431110 -0.033974 0.917615 1.099635 1.202594)
     )

;;; 7 prime --------------------------------------------------------------------------------
#(7  3.5358893688327 #(0 0 0 0 0 1 0)
     3.4886319637299 #(0 1 1 0 0 0 0)

     3.061861 #(0.000000 0.715739 0.261422 0.169339 0.062479 1.180650 0.330190)
     3.061763 #(0.000000 0.715523 0.261251 0.168577 0.061828 1.179155 0.328665)
     )

;;; 8 prime --------------------------------------------------------------------------------
#(8  3.8668605608975 #(0 1 0 1 1 1 0 0)
     3.7088719446694 #(0 1 0 0 0 0 1 0)
     3.7088720798492 #(0 0 0 0 0 0 1 0)

     3.263115 #(0.000000 0.207652 0.035023 1.752163 0.064249 0.346105 1.403170 0.065734)
     3.262977 #(0.000000 0.792550 1.965637 0.248661 1.936840 1.655647 0.598935 1.936915)
     3.262789 #(0.000000 0.792261 1.965087 0.247823 1.935907 1.654053 0.597010 1.934463)
     )

;;; 9 prime --------------------------------------------------------------------------------
#(9  4.0320072303689 #(0 1 1 0 1 0 0 0 0)
     3.915482117267 #(0 1 0 1 1 1 0 0 0)
     3.9154822826385 #(0 0 0 1 1 1 0 0 0)

     3.382645 #(0.000000 0.562589 0.520940 1.521127 1.682374 0.721497 0.805534 1.254209 0.726847)
     3.382399 #(0.000000 1.437745 1.479554 0.480268 0.319088 1.280870 1.197460 0.749784 1.277141)
     3.382150 #(0.000000 1.437471 1.479039 0.479171 0.317977 1.279012 1.195104 0.746644 1.274032)
     )

;;; 10 prime --------------------------------------------------------------------------------
#(10 4.1794095733027 #(0 0 1 0 0 1 1 1 1 1)
     4.1718228801521 #(0 0 0 0 0 1 0 0 1 0)
     4.1209712028503 #(0 0 1 0 0 0 1 0 0 0)

     3.602602 #(0.000000 1.405079 0.694565 0.388252 0.756491 1.849937 0.076683 1.023761 0.374165 1.226329)
     3.602329 #(0.000000 0.594431 1.305346 1.611464 1.243212 0.149889 1.922392 0.975619 1.625276 0.772405)
     3.601897 #(0.000000 0.594605 1.305309 1.611462 1.242927 0.149405 1.922318 0.974872 1.624292 0.771826)
     )

;;; 11 prime --------------------------------------------------------------------------------
#(11 4.56653492525 #(0 0 1 0 1 1 1 0 0 0 0)
     4.487418596136 #(0 0 0 0 0 0 1 1 0 1 1)
     4.4176635742188 #(0 0 1 0 0 0 0 0 0 1 0)

     3.779046 #(0.000000 0.211414 1.453486 1.827574 1.811694 1.949216 1.313595 0.823256 1.334141 0.127849 0.824659)
     3.778444 #(0.000000 0.211392 1.453207 1.827566 1.811268 1.948666 1.312975 0.822389 1.333108 0.126706 0.823083)
     )

;;; 12 prime --------------------------------------------------------------------------------
#(12 4.7299025085604 #(0 0 1 0 1 1 1 1 0 1 0 0)
     4.6850221453825 #(0 0 1 0 1 0 1 1 1 0 0 0)
     4.3595271110535 #(0 0 0 0 0 0 1 0 1 1 0 1)

     3.936657 #(0.000000 0.367346 0.997085 1.763425 1.295636 0.140826 0.757652 1.565853 1.284651 0.304758 0.331248 0.325474)
     3.936584 #(0.000000 0.366730 0.995852 1.762390 1.293763 0.137304 0.753397 1.560313 1.278944 0.297723 0.322472 0.315856)
     3.935928 #(0.000000 0.367095 0.996695 1.763345 1.295131 0.139476 0.755820 1.563961 1.282494 0.302360 0.327995 0.321982)
     )

;;; 13 prime --------------------------------------------------------------------------------
#(13 5.06212613641 #(0 1 0 0 1 0 1 0 1 1 0 0 0)
     4.9963458682976 #(0 1 0 0 1 1 1 1 1 1 1 0 1)
     4.9494566649932 #(0 1 0 0 1 1 0 0 0 0 1 1 1)
     4.8980793952942 #(0 0 0 1 0 0 1 1 1 1 1 1 0)

     4.155503 #(0.000000 1.115751 0.463368 0.110540 0.613302 1.581997 1.394002 -0.005270 1.724217 0.023531 1.743892 0.616897 0.124222)
     4.155104 #(0.000000 0.888606 1.516761 -0.128988 1.376524 0.383262 0.572385 -0.041726 0.228441 1.918487 0.187862 1.304384 1.779710)
     4.154486 #(0.000000 0.888925 1.516611 -0.128449 1.377349 0.383874 0.573640 -0.040502 0.230047 1.920090 0.190320 1.307111 1.782269)
     )

;;; 14 prime --------------------------------------------------------------------------------
#(14 4.827317237854 #(0 0 0 0 1 0 0 0 0 1 1 0 0 0)

     4.325356 #(0.000000 0.359558 1.885647 0.244632 1.221244 1.839379 1.316045 0.525308 0.483244 1.183590 1.084986 0.271051 0.780356 0.855105)
     4.324364 #(0.000000 0.359123 1.885242 0.244967 1.221612 1.840358 1.317076 0.526663 0.485486 1.185929 1.087828 0.273652 0.783599 0.859686)
     )

;;; 15 prime --------------------------------------------------------------------------------
#(15 5.2087744996197 #(0 0 0 0 1 0 0 0 1 1 1 0 1 1 1)
     5.1680134390775 #(0 0 0 0 1 0 1 1 0 0 1 1 1 1 1)
     5.116711139679 #(0 0 0 0 1 1 0 0 1 0 0 0 1 1 1)

     4.467959 #(0.000000 1.165302 0.822381 1.719844 1.177673 0.000074 -0.047034 0.249259 0.174863 0.272306 -0.034377 1.204925 0.800910 1.798882 0.085175)
     4.466924 #(0.000000 1.164687 0.821843 1.719833 1.177792 -0.001130 -0.048114 0.246943 0.173930 0.269647 -0.036792 1.203532 0.796937 1.795273 0.083498)
     )

;;; 16 prime --------------------------------------------------------------------------------
#(16 5.3690811579971 #(0 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1)
     5.2829658956774 #(0 0 1 0 0 0 1 0 0 0 0 0 1 1 1 0)
     5.2015118598938 #(0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 1)

     4.602505 #(0.000000 0.065822 0.364277 0.133567 0.202441 1.541212 1.225002 0.832999 1.687176 1.503245 1.015565 1.715739 1.103351 1.602678 1.102870 1.723542)
     4.601495 #(0.000000 0.064663 0.363148 0.132261 0.201827 1.541434 1.224369 0.830652 1.686915 1.501871 1.012992 1.713503 1.102043 1.600360 1.101260 1.720212)
     )

;;; 17 prime --------------------------------------------------------------------------------
#(17 5.6171013426079 #(0 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1)
     5.5776449751108 #(0 1 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1)
     5.5725093120778 #(0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0)
     5.5318970680237 #(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1)

     4.719141 #(0.000000 0.742295 1.745265 1.857635 0.393094 0.085265 0.379253 1.692020 1.022244 0.008090 1.067230 1.241546 0.650781 0.027258 1.334059 1.354939 0.974983)
     )

;;; 18 prime --------------------------------------------------------------------------------
#(18 5.6380511040237 #(0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0)
     5.518 #(0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 0)

     4.855354 #(0.000000 0.761212 1.399765 1.386893 -0.022155 1.259519 0.806762 0.461717 0.840663 0.867450 0.860949 1.743030 1.407070 0.651538 1.045391 1.279111 0.110257 1.307989)
     )

;;; 19 prime --------------------------------------------------------------------------------
#(19 5.9841752522819 #(0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 0)
     5.707 #(0 0 1 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1)
     5.7069295560724 #(0 1 1 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1)

     5.015020 #(0.000000 1.616061 1.626145 1.313686 1.626275 1.187207 1.456980 0.377509 -0.071549 0.474989 0.997350 1.285450 0.372950 1.499943 0.593785 0.033723 1.161466 0.319734 1.064282)
     )

;;; 20 prime --------------------------------------------------------------------------------
#(20 5.9970674135126 #(0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 1)
     5.9696664680177 #(0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0)
     5.931 #(0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0)
     5.8879864574703 #(0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1)

     5.188618 #(0.000000 1.304708 0.831211 0.731788 0.021326 1.272273 1.777479 0.002778 1.612017 0.397413 0.057603 1.250739 0.234023 0.556087 0.011742 0.753589 1.624826 0.625035 1.017719 0.079500)
     )

;;; 21 prime --------------------------------------------------------------------------------
#(21 6.1566464314438 #(0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0)
     6.1375694270894 #(0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 0)
     6.1138607493652 #(0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0)

     5.324980 #(0.000000 0.284388 0.190620 0.601870 1.760108 0.865412 0.509624 0.391482 -0.117180 0.413220 1.669494 1.501699 0.066514 0.632948 0.866546 1.073191 0.975355 1.318609 0.054208 1.081180 1.759607)
     )

;;; 22 prime --------------------------------------------------------------------------------
#(22 6.389194775669 #(0 0 0 0 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1)
     6.3868380259357 #(0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1)
     6.33751039349071 #(0 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0)
     6.3374844973589 #(0 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0)

     5.444390 #(0.000000 1.499825 1.282805 1.145752 0.718322 0.527629 0.660515 1.924701 0.466877 0.510672 0.652853 0.187109 1.099971 0.084112 0.857217 -0.068874 1.056229 1.751779 1.460546 0.258516 0.957206 1.594508)
     )

;;; 23 prime --------------------------------------------------------------------------------
#(23 6.540168762207 #(0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 1 1)
     6.5358400344849 #(0 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 1)
     6.5309901747782 #(0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1)

     5.563562 #(0.000000 0.281094 0.583074 0.221311 1.169287 1.340406 0.217839 0.992042 0.637288 1.632696 0.471670 0.404966 0.171954 0.469626 0.291125 0.731904 1.276906 1.527897 0.612764 0.143351 1.082353 1.486999 1.452340)
     )

;;; 24 prime --------------------------------------------------------------------------------
#(24 6.6087727546692 #(0 0 0 1 1 0 1 1 1 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0)
     6.5951228141785 #(0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0)
     6.5623834870329 #(0 0 1 1 0 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0)

     5.645656 #(0.000000 0.825211 1.870903 1.169702 1.224751 0.476917 -0.084281 -0.215343 1.779853 1.403261 0.289331 1.689966 -0.267939 1.131483 1.839470 1.455399 1.365050 0.422908 0.906355 0.161003 0.266551 0.763039 1.248766 1.436520)
     )

;;; 25 prime --------------------------------------------------------------------------------
#(25 6.84773846418216 #(0 0 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0)
     6.8138422966003 #(0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 0 1 1 1 1)
     6.6733964421745 #(0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 1 1 0 0 0)
     6.635721206665 #(0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1)

     5.810968 #(0.000000 0.563917 1.200421 1.330710 1.448766 0.304645 -0.097726 1.177798 1.307063 0.187504 1.569664 0.364333 -0.022466 1.552164 -0.223823 1.040207 1.386783 1.015426 1.883597 0.549950 1.619700 0.870151 1.482110 0.449208 0.536377)
     )

;;; 26 prime --------------------------------------------------------------------------------
#(26 6.9502968788147 #(0 1 1 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 0 1)
     6.9264550209045 #(0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1)
     6.9264546836564 #(0 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1)
     6.8401503562927 #(0 1 0 0 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1)

     6.060342 #(0.000000 -0.041165 -0.003731 0.423811 0.999953 0.846414 -0.006772 1.678875 0.280560 0.164498 1.427575 0.432370 0.295956 0.293617 -0.083444 1.838911 -0.050243 0.444002 1.425675 0.812741 0.728420 0.505166 0.737245 1.256666 1.911599 0.384822)
     )

;;; 27 prime --------------------------------------------------------------------------------
#(27 7.0658421516418 #(0 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0)
     6.9657588005066 #(0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1)
     6.949148677349 #(0 0 0 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1)
     6.9491486549377 #(0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1)

     6.134217 #(0.000000 1.620269 0.266537 0.604987 0.260652 1.739692 1.689079 1.043220 0.091768 1.523537 0.679822 1.839210 1.225705 -0.050255 0.850197 -0.058431 1.520245 0.452060 0.220945 1.184549 1.244659 1.696081 -0.039257 1.790478 1.792853 1.556589 0.366532)
     )

;;; 28 prime --------------------------------------------------------------------------------
#(28 7.2303333282471 #(0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0)
     7.2299618721008 #(0 0 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     7.2240290641785 #(0 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1)
     7.1576952692751 #(0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0)
     7.1576952934265 #(0 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0)

     6.190947 #(0.000000 0.460822 1.000235 0.802902 1.169351 0.023696 1.059034 0.557253 0.339303 -0.037893 0.757652 1.745281 0.808299 1.572816 1.228654 0.154747 0.925847 0.957314 0.565556 0.484885 0.864794 1.110639 0.659146 1.596331 1.587743 0.524304 1.470688 0.086831)
     )

;;; 29 prime --------------------------------------------------------------------------------
#(29 7.2895045280457 #(0 0 1 0 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0)
     7.24235304747816 #(0 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0)
     7.2415904369233 #(0 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0)

     6.364996 #(0.000000 0.899299 0.027883 1.660781 0.583908 0.594226 1.394105 1.009420 -0.076432 0.063436 1.779221 1.537249 1.002516 1.590894 -0.057219 1.023692 1.515341 1.279493 0.140022 -0.035094 0.723643 0.484040 0.612756 1.373872 1.209603 1.304864 0.985337 0.845953 0.581252)
     )

;;; 30 prime --------------------------------------------------------------------------------
#(30 7.5369029045105 #(0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 0 0)
     7.5239403940776 #(0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1)
     7.5096759796143 #(0 0 0 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1)
     7.4977698326111 #(0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 1)
     7.1189651489258 #(0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 0)

     6.451812 #(0.000000 1.683608 0.803658 0.933316 0.850814 1.701341 1.277986 1.473972 1.214431 1.898492 0.954836 1.784293 1.951482 1.381903 0.107238 0.105553 1.260609 1.566570 0.409971 0.385253 1.590967 0.968660 0.054889 0.914665 1.664915 1.656054 1.094096 1.343614 0.650979 0.864222)
     )

;;; 31 prime --------------------------------------------------------------------------------
#(31 7.5859903003103 #(0 1 1 0 0 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1)
     7.5834159851074 #(0 0 0 1 1 0 0 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0)
     7.5718903541565 #(0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1)
     7.4906754493713 #(0 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 1)

     6.701515 #(0.000000 0.707031 0.658082 0.778665 1.395076 0.565253 0.395956 1.065744 1.710897 0.801620 1.512714 1.121124 1.688469 1.338401 0.622466 1.725968 1.295045 0.892738 0.244280 0.958065 0.828867 0.800413 0.064995 1.349330 1.878947 0.861664 0.695097 1.073201 0.907698 1.910585 0.416756)
     )

;;; 32 prime --------------------------------------------------------------------------------
#(32 7.7375974655151 #(0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0)
     7.719434261322 #(0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0)
     7.6655950546265 #(0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 1)
     7.6567826271057 #(0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1 1 0 0 0 0)
     7.6309351921082 #(0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0)

     6.840314 #(0.000000 0.318779 0.516839 0.074219 0.583611 0.129812 0.892723 1.218073 1.003682 1.318203 0.732548 0.776871 0.276192 0.952716 0.791401 1.672712 0.085899 1.952516 0.192237 -0.157165 1.402447 0.820395 0.125126 1.514398 1.367190 -0.162456 0.270637 0.922181 1.770495 1.089422 0.281630 1.539773)
     )

;;; 33 prime --------------------------------------------------------------------------------
#(33 7.9869227409363 #(0 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1)
     7.8325562477112 #(0 0 0 0 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0)
     7.7895503044128 #(0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 0 0 1)
     7.7389698028564 #(0 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 0)

     6.847135 #(0.000000 1.538851 1.266643 0.749279 0.963268 0.757743 0.877010 0.417537 1.020779 0.963307 1.083185 0.550108 1.496531 0.196129 0.925678 0.363413 0.602678 1.400650 0.181857 1.141798 0.265163 0.002858 0.995945 0.033000 0.434139 0.986241 1.781755 0.301635 1.605230 1.625113 0.716206 0.022022 0.684095)
     )

;;; 34 prime --------------------------------------------------------------------------------
#(34 8.0215682983398 #(0 0 1 1 0 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0)
     7.9724597930908 #(0 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 0)
     7.9716167449951 #(0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1)
     7.9716163031165 #(0 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1)
     7.9624452590942 #(0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 1 0 0 0)

     6.991847 #(0.000000 1.753734 0.197196 1.711499 0.361032 0.830477 0.344417 0.630037 1.914326 1.209945 1.175555 -1.879303 1.382041 0.682865 1.526474 -0.404047 1.591630 1.225623 1.048349 0.610665 0.689418 1.214009 0.622655 0.034861 1.290434 1.065912 0.499011 0.035148 0.803621 1.427845 1.248948 0.450302 1.561267 0.394918)
     )

;;; 35 prime --------------------------------------------------------------------------------
#(35 8.2040424346924 #(0 0 0 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 0)
     8.1993579864502 #(0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 0)
     8.1756086349487 #(0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 0 1)
     8.1555442810059 #(0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0)
     8.1336851119995 #(0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 0 0 0 0)
     8.1317510604858 #(0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 0 1 0 0 0 0)
     8.0019035339355 #(0 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 0 0)

     7.164678 #(0.000000 1.264059 0.439480 0.500868 -0.036174 1.026460 1.235779 1.853799 1.521621 0.898169 0.985374 1.339919 0.175589 1.927633 1.485752 0.808360 0.144138 1.546416 0.350788 0.195471 0.995732 1.587315 0.597171 0.529159 0.410060 0.179067 0.767853 0.340200 0.736853 0.537170 1.395434 0.152456 0.219018 0.207502 1.078712)
     )

;;; 36 prime --------------------------------------------------------------------------------
#(36 8.4211139678955 #(0 0 0 0 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0)
     8.4162702560425 #(0 0 0 0 1 1 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0)
     8.4114933013916 #(0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0)
     8.3864717483521 #(0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 0 0 0)
     8.3820142745972 #(0 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 1 1 1 1 0 1 0 0 0 0 0)
     8.3783054351807 #(0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0)
     8.3031883239746 #(0 0 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0)

     7.274340 #(0.000000 0.295214 1.648256 0.584870 0.666257 0.185867 0.791897 0.205307 0.094941 1.078003 0.393529 1.106172 0.869922 0.874970 0.914168 -0.075429 0.352173 -0.206951 1.433194 0.016874 1.804925 1.769354 0.780563 1.415336 1.733698 0.569376 0.514365 1.527457 0.738716 1.585860 0.004452 0.303849 0.468887 1.200500 1.687045 -0.272506)
     )

;;; 37 prime --------------------------------------------------------------------------------
#(37 8.6493539810181 #(0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 1 0 1 0 0)
     8.5117635726929 #(0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 1 1 0)
     8.4779825210571 #(0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0)
     8.4775905609131 #(0 0 1 0 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1)

     7.292298 #(0.000000 1.395539 1.098994 1.240036 0.588053 1.094285 0.654411 1.738044 1.139797 0.033465 1.502202 0.224627 1.626426 0.174539 1.299475 1.078388 0.677420 0.148563 1.835275 1.058363 -0.011774 0.027241 0.885410 0.700018 1.428034 0.166628 0.799973 0.614570 1.042496 0.117601 0.537683 -0.072738 1.316678 1.393693 1.919927 1.302540 1.676425)
     )

;;; 38 prime --------------------------------------------------------------------------------
#(38 8.6871099472046 #(0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0)
     8.67653465271 #(0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0)
     8.6688671112061 #(0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0)
     8.6612920761108 #(0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0)
     8.6306476593018 #(0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0)
     8.6206035614014 #(0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0)
     8.5991640090942 #(0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0)
     8.5527725219727 #(0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0)

     7.397239 #(0.000000 0.231714 1.167038 -0.110166 0.359115 0.958624 0.067694 0.724564 0.166890 0.631435 1.540963 1.733611 0.342146 1.111987 1.355498 -0.334591 0.298415 0.278567 1.095580 -0.228482 1.743063 0.486321 0.002745 0.659202 1.838897 0.967645 0.291092 0.439150 0.884656 0.648920 0.479452 1.513496 0.204579 0.150564 -0.153571 1.377719 0.627449 0.171427)
     )

;;; 39 prime --------------------------------------------------------------------------------
#(39 8.9125862121582 #(0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 0 0 0 0 0 0)
     8.8173857964668 #(0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0)

     7.457087 #(0.000000 0.007724 0.952084 -0.060727 1.651336 1.380190 0.944147 0.380617 -0.156899 0.995648 0.908746 1.436292 0.371293 0.331419 1.307831 1.593808 -0.021321 1.050329 1.533988 1.366033 1.175269 1.241366 0.683440 0.661695 0.493184 0.708242 0.997112 1.028148 1.009034 1.153315 1.460827 0.201476 1.248314 1.813294 1.397367 0.023646 0.377861 1.432421 1.555742)
     )

;;; 40 prime --------------------------------------------------------------------------------
#(40 9.0681540417544 #(0 1 0 0 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1)
     8.9134502410889 #(0 0 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1)

     7.703588 #(0.000000 1.735488 1.656851 1.224286 0.044381 0.581732 0.870499 0.678243 0.396963 1.559949 1.753552 0.343685 1.182244 0.436049 0.704051 1.315848 0.612950 0.283482 1.616300 0.417655 1.870367 0.045128 0.404846 0.027986 1.838093 1.350622 0.788217 0.264993 1.270928 0.453126 0.746731 1.438328 0.714772 1.669939 -0.004462 0.932368 1.451203 0.182154 1.479009 1.559243)
     )

;;; 41 prime --------------------------------------------------------------------------------
#(41 9.295313835144 #(0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 0 0)
     9.1567583084106 #(0 1 0 0 0 1 0 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0)

     7.867024 #(0.000000 0.608466 -0.058335 1.261083 0.343574 0.017139 -0.247368 -0.126080 0.108145 -0.086359 1.508985 0.480907 1.447745 -0.015373 1.347225 0.789235 0.037073 1.554640 1.065187 0.404226 0.488247 0.748255 1.296047 0.561729 1.715057 0.681783 0.619284 0.945732 0.939021 0.771135 1.742573 1.319613 0.557610 0.221489 0.655514 1.579724 0.293232 0.866341 0.312217 1.411973 0.730731)
     )

;;; 42 prime --------------------------------------------------------------------------------
#(42 9.3096771240234 #(0 0 1 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0)
     9.2193641662598 #(0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0)

     7.968899 #(0.000000 -0.295750 -0.099542 1.644936 0.993078 1.212131 1.301338 1.703363 0.311294 1.377680 1.019308 1.241840 0.341314 -0.025426 0.793454 0.385306 1.597828 0.301348 1.243351 0.805441 1.871561 1.514878 0.817845 0.278894 0.154044 1.791162 0.441648 1.043705 1.104365 0.811685 1.171408 0.352618 0.087123 0.393524 1.056963 1.166485 0.253915 0.201875 1.385631 0.806568 0.859705 0.587162)
     )

;;; 43 prime --------------------------------------------------------------------------------
#(43 9.4925568571597 #(0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1)
     9.4329051971436 #(0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1)

     8.046185 #(0.000000 1.817632 0.252010 -0.103671 1.211788 0.124593 0.188015 1.581262 0.803462 0.812007 0.976458 1.687252 0.502745 0.399046 1.201479 1.598548 0.040562 -0.019458 0.190067 1.533842 1.422464 1.489235 0.129680 1.199320 1.782083 0.095844 1.090119 0.282673 -0.033246 0.111087 -0.011893 0.684875 0.719396 1.698189 1.500459 0.281677 1.726771 1.306779 0.788248 -0.012627 1.705988 0.230393 1.474904)
     )

;;; 44 prime --------------------------------------------------------------------------------
#(44 9.6622378996026 #(0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0)
     9.6263332366943 #(0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1)

     8.178571 #(0.000000 1.258658 0.187034 0.795328 0.964699 0.871575 0.511439 0.771199 0.339117 0.781814 0.040381 0.860956 1.770646 0.078186 0.205606 1.742839 1.806102 0.918908 1.517130 0.316571 0.488652 0.196326 1.291961 1.256825 0.594155 0.225516 1.097627 1.257360 0.602722 -0.027091 0.325643 0.019833 0.568859 1.050899 1.290389 1.484324 1.062984 -0.258069 0.220739 1.062220 0.812514 1.528101 0.926337 1.801266)
     )

;;; 45 prime --------------------------------------------------------------------------------
#(45 9.8476276594031 #(0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1)
     9.7923860549927 #(0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1)

     8.158690 #(0.000000 0.513341 0.822374 1.455533 0.214669 0.308027 0.457386 1.481156 1.270360 0.360385 1.143401 1.370256 0.826681 0.738860 0.258968 0.775237 1.245490 1.666246 1.265388 0.162151 1.559981 1.566329 0.363127 0.843078 1.459037 1.912872 0.922547 1.780697 0.526391 1.790889 0.580919 0.076389 1.284706 1.241855 1.308633 1.536619 0.146299 1.158082 0.825556 1.333430 0.588070 0.482808 0.728418 -0.256061 0.794222)
     )

;;; 46 prime --------------------------------------------------------------------------------
#(46 9.928765296936 #(0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0)
     9.8914480209351 #(0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 1 0)
     9.7220277786255 #(0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0)

     8.265588 #(0.000000 0.445589 0.084609 1.447014 1.087877 0.773077 1.030781 0.396756 -0.026527 1.856690 0.020952 1.354980 1.091968 -0.115876 1.241872 0.491323 0.417877 1.013974 1.842112 0.628891 1.148855 0.250185 0.789995 1.149311 0.946837 0.162201 0.887485 1.384351 1.953244 0.085153 -0.491957 0.493409 1.324326 0.813677 1.213296 0.713467 -0.027115 1.495972 0.879778 0.966152 1.300148 1.255602 1.312549 0.518574 0.520426 1.095967)
     )

;;; 47 prime --------------------------------------------------------------------------------
#(47 10.097447395325 #(0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 0 0 0)
     10.0            #(0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0)

     8.422540 #(0.000000 1.196216 0.223706 0.003787 0.969689 0.123094 1.208649 1.738400 1.097659 1.138395 1.183990 0.696423 -0.152942 0.757594 0.590180 1.723553 1.904824 0.166032 1.169638 0.391644 0.301127 1.647394 1.038745 1.885034 1.600696 1.909565 0.394868 1.445412 1.063151 1.300872 1.364096 0.996249 1.438822 1.278072 -0.028893 1.341161 0.032789 1.284303 1.327039 1.229164 -0.098756 1.251531 1.487792 0.140193 0.040109 0.623395 0.406224)
     )

;;; 48 prime --------------------------------------------------------------------------------
#(48 10.298553466797 #(0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 0)
     10.248653411865 #(0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0)
     10.073040962219 #(0 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1)

     8.470088 #(0.000000 0.334884 1.569856 1.666539 0.443148 0.426087 0.737463 1.691112 -0.014305 0.001454 0.948256 0.784127 0.530840 1.025426 0.766308 0.421499 0.980378 0.320595 -0.017923 0.451772 -0.012555 0.638201 1.620515 1.251544 1.850129 -0.213630 0.825077 1.367525 1.276147 0.688873 1.531806 1.115921 -0.141422 0.604468 1.704660 0.651645 1.381791 0.844605 0.436857 0.928450 1.366884 1.152885 1.850311 1.186968 0.735581 0.962056 0.284691 -0.263141)
     )

;;; 49 prime --------------------------------------------------------------------------------
#(49 10.28332063912 #(0 0 1 0 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0)
     10.207101821899 #(0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 1 0 0 0 0)
     10.209 #(0 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 0)

     8.638341 #(0.000000 1.499321 0.285809 0.984938 0.948313 0.314999 -0.082598 0.816018 0.760091 1.639123 1.094980 1.598850 1.203998 1.818570 0.349122 1.494271 0.114248 1.721426 0.374141 0.021514 1.168115 0.992275 0.549775 1.791784 -0.045504 0.145033 0.035057 0.505101 1.168880 1.082480 1.765245 1.966715 1.815704 0.052541 1.177619 0.724867 -0.107440 1.831426 1.688761 1.512788 0.959365 1.659106 0.893887 -0.051272 0.335383 0.873714 0.620449 1.854327 1.226483)
     )

;;; 50 prime --------------------------------------------------------------------------------
#(50 10.669495582581 #(0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1)
     10.402973175049 #(0 0 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1)

     8.677905 #(0.000000 1.490979 1.054295 1.020190 1.327514 1.081439 0.578838 1.658302 1.278920 1.219295 1.247454 1.458366 0.843823 1.787016 0.048598 0.679813 -0.108242 0.040273 1.115273 1.948094 1.168288 1.001629 0.956148 0.189209 0.761743 0.480321 0.973522 0.115402 0.838678 0.099478 1.319561 1.244862 1.951777 0.923334 0.455455 -0.194289 0.831975 1.073092 0.156668 1.601110 0.878291 1.362599 0.929305 1.476299 0.061466 1.604234 0.645331 1.303322 0.055933 1.230936)
     )

;;; 51 prime --------------------------------------------------------------------------------
#(51 10.5841327092253 #(0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1)

     8.654743 #(0.000000 0.552454 1.578742 0.858760 0.464404 0.049091 1.206382 1.406810 0.755451 -0.010200 -0.318061 1.576840 0.776020 -0.086927 1.972222 0.372020 1.193600 0.826198 1.042401 0.970425 -0.101431 0.019167 0.371202 0.809459 0.570313 0.781035 0.251096 1.521966 0.516471 0.488338 0.353998 1.791718 0.344622 0.181507 1.270288 0.433483 0.354354 0.458600 0.924602 0.368322 1.157540 1.183466 0.094841 1.564909 1.891011 1.171330 1.234544 0.740162 0.187939 0.007118 0.619735)
     )

;;; 52 prime --------------------------------------------------------------------------------
#(52 10.767134666443 #(0 0 0 0 1 0 1 1 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0)
     10.737469673157 #(0 0 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 1)
     10.64324760437 #(0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0)

     8.820263 #(0.000000 0.190145 -0.094213 0.104916 1.735583 1.636433 1.776850 0.447412 1.408912 0.717342 0.421573 -0.241411 1.065168 1.673902 0.096450 0.248286 1.268984 0.494674 1.428446 -0.093091 1.404795 0.420873 -0.037348 1.525969 0.039028 1.462796 -0.028124 0.496917 0.961840 0.306654 0.766213 0.680547 1.132855 1.623435 0.697623 1.781972 -0.039693 1.911929 1.156959 1.536607 1.833790 0.994913 0.918281 1.260395 0.145994 1.435911 0.596554 1.427778 0.741831 0.866820 1.092957 0.879763)
     )

;;; 53 prime --------------------------------------------------------------------------------
#(53 10.969209228042 #(0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0)
     10.959488868713 #(0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1)
     10.950836181641 #(0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 0 0)
     10.851609230042 #(0 1 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1)
     10.848851203918 #(0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0)
     10.678050692694 #(0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0)

     8.953737 #(0.000000 0.787575 1.225339 0.348272 0.334454 0.207582 0.898445 1.917863 1.003267 1.827690 1.665228 0.307406 1.690580 -0.197939 0.389012 0.060173 0.532086 0.679440 0.983850 1.778192 1.221889 0.337024 0.649037 -0.058468 1.547761 0.345271 1.142033 1.623406 1.517227 1.047290 0.925654 0.369495 1.876519 0.555486 0.470464 0.776468 0.839708 0.580148 -0.039042 0.259361 1.048708 1.261931 0.826101 1.841318 0.359714 1.361636 0.974990 0.708995 1.469834 0.679731 0.953097 1.112116 0.104328)
     )

;;; 54 prime --------------------------------------------------------------------------------
#(54 11.062943458557 #(0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 1 1)
     11.050 #(0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 1 1)
     10.781757504258 #(0 0 1 0 1 0 1 0 0 0 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 1 1 1)
     10.582709312439 #(0 0 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1)

     9.113524 #(0.000000 1.371105 1.648607 1.764718 1.072116 1.167045 0.497808 1.355267 1.097563 1.556782 1.723636 0.303158 1.362742 0.672100 0.597554 1.673902 1.200207 0.689939 0.332022 0.212393 0.119325 -0.067399 1.429171 0.808553 0.882997 1.616957 0.075103 0.411138 1.106667 -0.043091 -0.211560 1.350365 1.356954 1.301332 0.217910 0.763590 1.565958 0.201487 0.573138 1.688563 -0.053054 0.300709 1.046024 1.701281 0.903848 1.276306 0.972580 1.523286 1.750700 0.166396 0.961294 1.731692 0.155394 0.299307)
     )

;;; 55 prime --------------------------------------------------------------------------------
#(55 11.142364777492 #(0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1)
     10.806410031758 #(0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0)

     9.148578 #(0.000000 0.967945 0.926437 -0.360326 0.610597 0.766074 0.914573 1.392757 0.612814 0.952988 1.345172 -0.021540 0.736730 1.737847 1.629426 1.348970 1.308186 0.205851 1.283423 1.105007 0.627218 0.887999 0.369753 -0.355336 1.471927 1.218371 -1.841093 0.457399 0.319983 1.569992 -0.402726 1.291406 1.205166 1.401685 1.336009 0.648670 0.123692 0.662191 1.221004 0.574337 1.507091 0.326439 0.301122 0.227448 1.667546 0.067986 1.090816 1.792292 0.448712 1.706246 1.551948 -0.115842 1.845286 0.247054 0.002332)
     )

;;; 56 prime --------------------------------------------------------------------------------
#(56 11.365570068359 #(0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 0 1 0 0 0 1)
     11.143131256104 #(0 1 0 1 0 0 1 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1)
     10.976176261902 #(0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1)

     9.407618 #(0.000000 0.092294 0.693210 1.605081 1.098491 0.189191 1.613851 0.406415 1.587857 -0.053635 0.474250 1.058590 1.463555 1.477236 1.559165 1.147235 -0.091134 1.380552 0.059849 0.021862 -0.003201 0.412345 0.363526 0.300047 0.374105 1.732758 -0.237409 0.226941 0.348057 0.620258 1.609201 1.723008 -0.044665 1.606644 0.295020 0.787485 0.959628 0.773074 -0.316267 -0.225100 1.451429 0.795803 -0.015787 0.089344 1.493699 1.800962 0.954813 0.337654 0.745944 -0.184021 -0.017841 0.552838 1.594149 1.125921 1.582451 1.240752)
     )

;;; 57 prime --------------------------------------------------------------------------------
#(57 11.484163284302 #(0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1)
     11.352762647901 #(0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1)
     11.247724533081 #(0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1)

     9.569818 #(0.000000 -0.075762 1.764904 1.563295 -0.045294 1.688627 0.424412 0.788261 1.317693 1.700468 1.597697 0.759285 0.347402 -0.095038 0.969458 1.557590 1.226028 -0.005524 1.162707 1.817959 1.261019 1.123692 0.675640 0.664925 1.043746 -0.159080 1.684839 0.777243 1.334920 0.666625 0.251543 0.045770 0.136223 0.094858 -0.072710 1.315299 1.875511 1.316839 0.083128 1.515343 0.524271 0.814152 0.817569 0.420132 1.188706 0.647969 1.646441 0.552779 0.758460 1.053682 1.295499 1.094371 0.627163 1.402027 0.236201 1.483003 0.935564)
     )

;;; 58 prime --------------------------------------------------------------------------------
#(58 11.564489172529 #(0 1 1 0 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 1)
     11.261419321863 #(0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1)

     9.496347 #(0.000000 0.059743 0.548997 0.530263 0.226709 0.929160 -0.003047 0.125973 0.533773 1.548469 1.087643 1.570490 0.714949 0.863084 1.167817 1.094596 0.710052 1.511445 0.483704 1.291778 1.179203 1.180959 0.109073 0.094424 -0.384843 0.103787 0.722897 0.948977 1.484212 0.671726 0.961877 1.358209 1.232685 1.456297 0.651862 0.171910 0.370224 1.284842 1.052862 0.918644 1.853795 0.756435 1.065168 1.308648 0.977275 0.827028 1.655929 0.742384 0.217339 0.808896 0.296638 1.208667 1.265590 0.019271 0.389600 0.183945 0.533565 1.638734)
     )

;;; 59 prime --------------------------------------------------------------------------------
#(59 11.677247047424 #(0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0)
     11.650652430228 #(0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0)
     11.523194313049 #(0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 1)
     11.34253692627 #(0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1)

     9.448935 #(0.000000 1.026061 1.257478 0.308751 0.971304 0.408672 0.151573 1.791945 1.988410 -0.027565 1.420461 -0.028764 1.207077 1.130552 0.882916 0.848255 1.362983 -0.046245 1.807904 1.494761 -0.131409 1.566972 0.342692 1.947355 0.740428 0.985455 0.390530 1.584124 1.932986 0.721947 1.179636 0.976854 0.568454 1.189990 1.426538 -0.109496 0.165130 0.977642 1.346264 1.548425 0.663442 -0.011184 1.175073 1.167081 0.781836 1.100810 1.670554 0.567550 0.270091 1.914672 1.025447 0.080725 0.522143 1.724258 0.201718 0.120367 0.123533 0.434985 0.915393)
     )

;;; 60 prime --------------------------------------------------------------------------------
#(60 11.705318182776 #(0 1 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0)
     11.579921722412 #(0 0 1 0 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0)
     11.512454032898 #(0 0 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0)

     9.657740 #(0.000000 1.547780 1.677673 1.073672 -0.181562 1.466665 0.178185 1.296168 1.180984 0.799114 0.182696 1.568868 1.363180 0.494840 -0.056028 1.003607 1.541063 0.417763 1.700695 0.183440 0.905951 0.331420 0.794062 0.890276 1.122192 1.798420 0.731798 0.770804 1.703299 0.813575 0.660992 1.187791 1.645314 1.481351 1.240486 1.798220 0.254797 0.358769 1.758554 0.791594 0.131877 0.642084 0.956267 -0.226021 -0.095209 1.368914 1.922174 1.414955 -0.029158 0.411776 1.206976 1.720135 0.221233 0.679698 1.694654 0.956928 0.036757 1.792835 0.004408 0.786308)
     
     )

;;; 61 prime --------------------------------------------------------------------------------
#(61 11.989195823669 #(0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0)
     11.915099143982 #(0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0)
     11.850807189941 #(0 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1)

     9.848207 #(0.000000 0.465768 1.502052 1.208112 1.687111 1.098823 0.136558 1.242624 0.803898 1.305434 0.569022 0.707134 0.107360 0.681230 1.626786 1.180372 0.428544 0.064966 0.220601 0.606687 1.112200 0.761343 0.147814 1.074432 0.974575 0.150330 0.295078 1.965080 0.596171 1.395202 1.511902 0.719123 0.058806 0.162986 1.356055 1.017221 1.069746 0.022458 1.119273 0.473964 1.602481 0.117785 0.745272 0.467208 1.699348 0.892580 0.864605 0.883970 -0.281719 1.309124 0.657105 1.259919 1.224601 1.818239 1.863265 0.645463 0.762464 -0.184384 0.778659 1.743798 0.403645)
     )

;;; 62 prime --------------------------------------------------------------------------------
#(62 12.4221113188342 #(0 1 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 1 0)
     11.929849152918 #(0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 1 0)
     11.709966659546 #(0 0 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 0 1 0)

     9.793850 #(0.000000 0.170733 0.473670 0.215576 1.703744 -0.036957 1.103973 0.625149 1.606423 0.237060 0.049326 0.616656 1.278779 1.150528 1.100837 1.265326 0.344275 0.153687 0.440366 0.699535 0.312634 1.456390 -0.720843 0.296496 1.495061 -0.408748 0.243263 1.687707 0.591597 1.576113 1.089751 0.193976 0.926919 -0.113417 -0.086479 0.107749 1.535481 0.712662 1.228089 1.261343 0.243620 1.783269 0.892424 0.556947 0.842283 1.577225 1.202900 0.683925 0.137704 0.667578 0.163710 0.388591 1.874568 0.560786 0.696040 0.124105 0.660736 1.406639 0.640640 1.276289 1.811576 0.211535)
     )

;;; 63 prime --------------------------------------------------------------------------------
#(63 12.219760894775 #(0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0)
     12.000000000004 #(0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0)
     11.975765228271 #(0 0 0 1 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0)

     9.721240 #(0.000000 -0.194475 0.121647 0.206662 1.628174 0.226543 1.127026 0.674899 1.187999 0.608493 0.796199 -0.143184 0.276375 0.049342 -0.032284 1.281464 0.170466 1.510188 0.926244 0.721038 1.664333 1.429559 1.215181 1.501079 1.720613 0.373807 0.732362 0.843801 0.645288 1.771561 -0.063040 1.759534 0.658767 0.638300 1.431475 0.933966 0.449668 1.376315 1.658408 0.691605 0.902687 0.707305 0.261304 0.017351 0.759720 0.430141 1.446307 0.382113 -0.212136 0.419777 0.410917 1.770313 0.501753 1.413598 0.020515 1.330589 0.247395 0.601927 0.401887 0.097422 0.243370 1.015126 0.319135)
     )

;;; 64 prime --------------------------------------------------------------------------------
#(64 12.176999092102 #(0 0 1 0 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1)
     11.932915769505 #(0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1)

     9.918046 #(0.000000 -0.172483 0.277805 1.457359 0.410697 0.495540 1.259076 0.943212 0.459882 -0.041358 1.399339 0.587287 1.001695 1.550702 0.411477 0.896528 0.920261 0.341748 0.066544 -0.008060 0.023233 0.280976 0.970136 1.263061 0.103421 0.588731 1.539562 0.554558 1.656452 1.426443 0.093265 0.726482 0.380451 1.258726 0.367765 0.294078 0.691812 1.351451 0.835810 1.351734 1.365257 1.642212 0.644024 0.521175 1.143717 1.509783 0.366589 -0.120383 0.020779 1.359350 0.605184 0.518865 0.040336 1.604933 0.952520 0.773002 0.888212 1.326296 1.666503 0.942808 0.569835 0.682184 0.232646 0.549568)
     )

;;; 65 prime --------------------------------------------------------------------------------
#(65 12.496994018555 #(0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 1 0)
     12.264873504639 #(0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 0)

     10.273561 #(0.000000 1.323464 -0.132720 -0.055137 0.225384 0.297640 0.661639 1.810034 0.111963 1.328237 1.117316 1.792472 1.371279 0.714508 0.088267 1.244233 0.674930 0.077492 1.125340 -0.042526 0.219164 0.440442 1.290757 1.090148 1.096554 0.938138 0.670891 0.036802 0.220017 0.194106 1.070246 0.931738 0.568035 1.868110 1.937892 0.070437 0.686175 0.655635 1.395739 0.909666 1.451427 1.091491 0.102558 1.466641 0.131579 1.505351 0.151141 0.212595 0.325542 0.821431 0.280096 0.016410 1.407847 1.298561 1.877828 -0.118912 1.557418 0.242788 -0.204862 1.084900 0.177586 1.535371 1.625054 1.866410 0.417153)
     )

;;; 66 prime --------------------------------------------------------------------------------
#(66 12.564531326294 #(0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 0)
     12.359117360586 #(0 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0)
     12.347700119019 #(0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0)
     12.090668678284 #(0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0)

     10.216764 #(0.000000 -0.257739 0.414350 1.232021 0.031941 0.439015 1.203040 1.085484 0.397297 0.106463 0.398847 0.960781 1.285642 0.211392 1.033645 0.149714 1.730439 1.231937 -0.346328 0.156861 0.125794 1.131522 0.093573 0.474988 0.814344 0.546508 1.592403 0.342828 0.603283 0.212434 0.263789 0.089826 0.202694 0.947827 0.725411 0.054958 0.333154 0.861429 1.406276 1.256764 1.197797 0.023213 1.136393 1.204713 0.869289 1.542866 0.528562 1.703761 -0.165370 0.934062 0.606805 1.874933 1.184758 0.707079 1.057620 1.284452 1.131142 0.265490 0.623065 0.100791 0.657131 0.217618 1.501821 0.788192 0.030578 0.358280)
     )

;;; 67 prime --------------------------------------------------------------------------------
#(67 12.65784740448 #(0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 1 1)
     12.20425496356 #(0 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1)

     10.329509 #(0.000000 -0.061817 1.239792 1.937700 0.378031 0.132091 1.308741 1.039527 0.078152 0.041393 0.382932 0.611658 0.090130 0.254934 0.686381 0.089053 1.549754 1.652356 1.405641 0.680302 1.022148 0.989351 1.574862 0.949639 0.602940 0.848025 0.623115 1.084579 0.279202 0.704558 0.933880 1.624751 1.470703 0.853532 1.295046 0.813562 -0.167630 1.308008 1.665753 0.130770 1.416342 1.193946 0.753584 1.497957 1.288886 0.011607 0.970946 0.584942 1.096510 1.010636 1.347045 1.016354 1.430366 0.506090 0.028121 1.496639 0.684890 0.385603 0.740939 1.607950 1.195970 0.700238 0.192537 -0.004895 0.946258 0.489113 0.497273)
     )

;;; 68 prime --------------------------------------------------------------------------------
#(68 12.551372528076 #(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1)
     12.501034736633 #(0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 0 1 0 1 0 0 1 0 1)
     12.466281890869 #(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 0 1)

     10.401900 #(0.000000 0.175254 1.688561 -0.022176 1.014150 1.735614 0.106603 1.075507 -0.060900 1.298224 -0.215162 1.814388 1.567599 1.904753 0.113858 0.719810 0.160449 1.384396 1.000699 0.295499 0.001400 0.740033 0.182957 1.441904 0.972205 0.429959 -0.219777 1.134780 1.304204 1.952951 -0.055996 -0.044089 0.615360 -0.254880 1.159354 1.373314 1.941975 1.903453 0.661568 0.531937 -0.343853 1.267794 -0.042655 0.308155 1.404214 1.786528 1.816083 1.701941 0.895151 0.952565 1.266065 1.224824 0.893842 0.855298 0.294864 1.742552 1.509380 1.372558 0.598113 0.560036 0.130430 0.694502 0.130802 1.357605 1.479201 1.812346 0.337140 1.482807)
     )

;;; 69 prime --------------------------------------------------------------------------------
#(69 12.88109067433 #(0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 0 1)
     12.549396894774 #(0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1)
     12.336643218994 #(0 0 1 0 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1)
     12.29846572876 #(0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0)

     10.413885 #(0.000000 1.741951 1.382344 1.285702 1.273105 0.193255 1.714084 1.656676 0.786479 0.714567 1.976801 1.439591 1.180510 0.867934 0.226111 0.238121 0.163936 0.073842 1.458869 0.722108 1.958988 0.138718 0.871978 0.239531 0.531178 0.992538 1.761596 -0.251882 1.787976 1.678057 0.777442 1.938315 1.088441 1.770898 0.406677 0.999929 1.277966 1.375938 1.656295 1.029180 1.515387 1.712109 0.964209 -0.220484 0.859614 0.620221 0.751774 -0.255655 0.046212 0.589917 1.359624 1.071884 0.318745 0.870763 1.156713 1.463798 0.171028 1.160582 0.997243 1.062903 1.026924 0.471448 1.755826 0.013220 0.962874 0.314258 1.327839 1.293466 0.725806)
     )

;;; 70 prime --------------------------------------------------------------------------------
#(70 13.072455719834 #(0 0 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0)
     12.851739571463 #(0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0)
     12.797727584839 #(0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0)
     12.669577598572 #(0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0)
     12.665026664734 #(0 1 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 0 0)

     10.440635 #(0.000000 0.655330 0.151724 -0.211312 0.449999 1.050489 0.302151 1.608671 1.043604 1.661808 0.960844 1.098368 0.971375 0.783393 0.637218 0.180222 0.074231 0.656304 0.891614 0.444353 0.965327 1.662956 1.050038 0.021055 1.893532 1.736812 1.694528 0.834693 1.024630 1.916234 1.373334 0.505156 -0.109872 0.549862 0.201999 0.045591 1.288014 -0.077565 0.486213 1.773311 1.402395 0.481783 0.193422 0.620490 1.368109 1.208300 1.468499 1.578497 1.403476 1.925497 0.395364 1.532458 0.084063 0.218268 0.972001 -0.142536 1.510700 0.677934 1.375863 0.717557 0.330467 0.696050 1.625991 0.821341 0.079041 1.100311 0.139173 0.896320 0.866091 0.138009)
     )

;;; 71 prime --------------------------------------------------------------------------------
#(71 13.189444031428 #(0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 0)
     13.116391136133 #(0 0 0 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0 0 1 1 0)
     13.027417182922 #(0 1 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0)
     12.702159881592 #(0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 1 1 0)
     12.609085083008 #(0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 0)

     10.578784 #(0.000000 0.697960 0.912194 0.924258 1.615982 0.860795 0.820790 1.026513 0.524793 0.624450 0.710072 0.832509 1.645394 0.519789 0.758461 0.528724 0.945283 1.149653 1.239192 1.299164 0.388737 0.175660 0.801906 0.548808 0.620310 1.411871 0.132231 0.295890 0.011050 1.263024 0.757517 1.338816 1.075670 0.042224 0.560834 1.717010 1.670894 0.975768 0.064996 0.613665 1.095076 0.223160 1.418491 0.586455 0.900563 1.677618 1.229278 0.213833 1.747952 0.890064 0.949933 0.300014 1.012558 0.006690 1.240120 0.088867 1.220225 1.112868 0.260801 0.276566 1.833065 0.911144 1.766238 1.620422 0.377399 0.227024 0.295351 0.937010 0.701277 1.400373 1.368270)
     )

;;; 72 prime --------------------------------------------------------------------------------
#(72 13.268 #(0 1 1 1 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 0)
     13.043850898743 #(0 0 1 0 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 1 1)
     12.841200828552 #(0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0)
     12.708446502686 #(0 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 1)

     10.592203 #(0.000000 1.521008 1.113016 -0.193253 1.576723 1.055504 1.458797 0.760523 1.509207 1.254842 0.026872 -0.000733 1.670349 0.097601 1.613080 1.392357 1.624208 0.239992 0.075356 1.025667 -0.219272 1.862159 1.146995 0.098909 0.596020 0.270341 1.426883 0.151828 0.730689 0.082976 0.735287 1.760933 1.553588 -0.166869 1.859222 1.244645 1.253282 0.181062 1.192940 1.197078 1.636808 -0.042744 1.246031 0.649850 1.089895 0.187232 1.323501 0.690060 1.156452 0.156257 0.747804 1.283775 -0.038824 1.654009 0.986693 0.871293 1.684787 0.547311 0.614599 0.658708 0.332852 0.978072 1.238104 0.140658 1.587618 1.304987 0.079842 0.382284 0.139176 0.912997 1.167974 0.111602)
     )

;;; 73 prime --------------------------------------------------------------------------------
#(73 13.602198600769 #(0 0 1 1 0 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 0 0 1 1)
     13.40486240387 #(0 1 0 0 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0)
     12.986406962349 #(0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0)
     12.877750118249 #(0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0)

     10.761703 #(0.000000 0.603203 0.358357 0.661880 1.540427 0.300660 1.056090 0.000931 1.699477 0.464121 0.712677 0.323685 1.270461 0.744685 0.538832 0.084144 1.741276 0.355091 0.391483 0.909099 0.235831 1.506478 1.248584 1.651562 1.292796 0.386080 -0.025595 0.340516 1.550074 1.191563 1.085376 1.628536 1.313388 1.399364 1.586458 1.426351 -0.054950 0.159552 0.724296 -0.052193 0.559874 0.169918 -0.079474 0.178651 0.926200 1.019533 1.673641 0.741982 1.375811 1.362415 0.299178 1.346610 1.003697 0.418398 0.207054 0.068458 0.788054 1.873377 0.455826 1.059605 1.413516 0.339162 1.725493 0.614177 1.452893 0.544171 1.420647 0.832568 1.431101 0.271681 0.438822 0.100038 1.592857)
     )

;;; 74 prime --------------------------------------------------------------------------------
#(74 13.442555427551 #(0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1)
     13.395832061768 #(0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 1 1)
     13.261976242065 #(0 1 1 0 0 0 1 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1)
     13.115156173706 #(0 1 1 0 0 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 1 1 0 0 0 0 0 1)

     10.711457 #(0.000000 0.315592 1.345684 0.640300 0.569610 0.406800 0.063076 -0.000727 0.699926 1.411703 0.627772 1.256316 0.141266 1.195295 0.972644 0.812355 0.300314 0.775842 -0.179161 1.543984 0.001320 1.053401 1.129362 1.692735 1.964246 1.267964 -0.120417 1.482653 0.237885 1.226346 1.008100 0.404223 0.079928 0.132313 -0.004925 -0.187363 0.533973 0.152690 1.251166 0.028557 0.147130 0.057055 -0.063702 1.515831 1.423827 1.061370 1.865293 1.746619 0.246534 0.580908 0.651914 0.689128 1.438876 1.731405 1.060728 1.893661 1.549384 0.049386 0.035166 1.267817 0.472624 0.413561 1.817682 1.905355 0.654261 0.759655 1.216135 0.092325 1.218559 1.192627 -0.163217 0.807527 -0.179948 0.297247)
     )

;;; 75 prime --------------------------------------------------------------------------------
#(75 13.676464080811 #(0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1)
     13.618774108319 #(0 1 0 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 0 0)
     13.357945520561 #(0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1)
     13.254356384277 #(0 0 0 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1)

     11.022299 #(0.000000 0.351470 1.008124 1.291533 1.352523 1.219130 1.555492 -0.093523 0.793123 1.710126 0.845582 1.377487 0.007190 1.144398 0.030789 1.388046 0.801302 1.006307 1.228947 1.174967 0.712656 1.235684 0.437185 1.685920 1.628311 0.432535 1.406407 0.211487 1.631733 1.309990 0.088839 1.823347 0.645147 0.984102 0.938592 0.791055 1.200055 1.653923 1.369127 1.660169 1.684809 1.277014 1.423374 1.618705 1.761213 0.185242 0.737016 0.819843 1.700256 1.790111 1.582839 0.397943 0.430644 0.413691 1.861593 0.597392 0.781277 0.169222 1.035252 0.907321 0.225899 -0.109171 1.673244 0.994007 0.840763 0.321135 1.684359 1.522767 0.808080 0.918598 -0.016940 0.115899 0.890010 0.043957 1.335248)
     )

;;; 76 prime --------------------------------------------------------------------------------
#(76 13.691219362758 #(0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0)
     13.288178191792 #(0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1)

     11.072304 #(0.000000 1.178337 0.930261 0.920575 1.829562 0.563339 1.231473 1.345699 0.790086 0.090545 0.932159 0.724161 0.871672 1.601134 0.586792 1.204374 0.474983 -0.139226 0.782581 0.566506 0.532873 0.323331 1.817525 0.128123 0.911215 1.639283 1.337213 -0.048043 0.741901 1.786641 0.471010 -0.292455 0.659958 1.160370 1.825955 0.699424 0.865050 1.858162 0.032915 0.158274 0.523975 0.164419 1.641906 0.864785 1.762505 1.012138 0.596166 0.050733 0.694996 1.548566 1.213302 0.030773 0.471399 0.022751 1.069246 1.191825 1.198217 0.441409 0.782353 1.498765 0.681606 0.672075 1.585306 1.321055 0.048695 0.942239 1.215952 1.879066 0.592725 0.177047 0.633972 0.454093 -0.095592 1.831838 0.760254 0.600943)
     )

;;; 77 prime --------------------------------------------------------------------------------
#(77 14.029663085938 #(0 1 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1)
     13.845010757446 #(0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0)
     13.330450043717 #(0 1 0 1 0 0 0 1 0 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1)
     13.158900260925 #(0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 1 1 1 1)

     10.882533 #(0.000000 1.165000 0.917892 1.923433 0.144270 1.470097 1.847570 0.662131 0.899833 0.676468 0.914006 1.398051 1.745968 -0.222871 0.377303 0.160276 1.340128 0.223153 0.789862 0.315310 1.447381 0.486793 1.172423 1.115707 0.266506 1.314519 1.266961 0.667931 0.987037 0.053466 0.842285 -0.098502 0.506147 0.533108 0.523553 0.945276 0.353765 -0.139079 0.928021 0.906075 -0.344875 0.027378 0.380952 0.146057 0.324883 1.410896 0.128164 1.956468 0.523014 0.454733 0.133576 1.767790 0.483750 0.477150 1.701259 1.356742 1.169306 0.979109 0.805777 1.926877 0.590126 0.217503 0.632850 0.630228 1.453794 1.245645 0.241215 1.297932 0.999945 0.335736 1.479795 0.662986 1.439275 0.986049 -0.201748 1.662574 -0.099777)
     )

;;; 78 prime --------------------------------------------------------------------------------
#(78 13.920186042786 #(0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1)
     13.683882347187 #(0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1)
     13.498236182018 #(0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1)

     11.128810 #(0.000000 1.556151 1.350766 1.079560 1.627456 1.824396 0.970239 1.719188 0.076491 0.356551 0.956437 1.450393 1.649467 1.028644 0.913293 0.244507 0.114759 1.070289 1.644113 1.454817 0.980418 0.918084 0.619510 1.767585 1.807117 0.656270 1.762010 0.672983 0.042023 -0.071247 0.983492 -0.081135 0.135693 0.114828 1.357805 -0.252941 1.850579 1.671928 0.257832 0.920719 0.631282 0.706947 1.321680 1.346893 -0.182371 -0.272451 0.054087 1.657623 0.055118 0.350677 1.314600 0.063294 0.902678 0.105522 1.670846 0.405032 -0.075578 -0.012369 -0.068016 1.298918 0.818077 -0.266776 0.759067 0.508057 -0.040066 1.459059 0.532881 1.133191 1.019843 -0.486096 1.086169 0.894532 1.300427 1.601490 0.616399 1.768752 1.000095 1.636458)
     )

;;; 79 prime --------------------------------------------------------------------------------
#(79 14.000000000005 #(0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 0)
     13.77695274353 #(0 1 1 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 0 0 1 0 0)
     13.178678233398 #(0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1)

     11.226563 #(0.000000 1.314288 1.469472 1.322591 0.554274 1.138938 0.772940 1.074423 0.562834 1.790760 1.660821 0.758222 0.688097 1.552561 -0.053427 0.431415 1.776489 0.012701 0.618089 1.305965 -0.001964 1.605483 0.568935 0.245581 0.951521 0.977669 1.749226 0.453632 0.114555 0.444197 1.014919 1.420246 0.279126 0.859600 1.591184 1.546597 1.518332 0.558493 1.510360 -0.001562 1.651802 1.327971 1.374012 0.042702 1.539126 0.546958 0.709732 0.550541 0.019961 1.131355 1.532817 -0.036101 0.578340 -0.103029 0.234707 0.510288 1.033346 0.940778 -0.291431 -0.034459 -0.072192 1.457831 0.360287 1.599362 0.297646 0.728528 0.024649 0.534346 1.412230 1.693357 -0.006012 -0.007356 1.476244 1.696168 1.176599 1.818633 1.794148 1.423705 0.906164)
     )

;;; 80 prime --------------------------------------------------------------------------------
#(80 14.309369414534 #(0 1 1 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 0)
     14.119678497314 #(0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1)
     13.563344594765 #(0 1 1 0 0 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0)
     13.547472953796 #(0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 1)

     11.451369 #(0.000000 -0.011188 0.391305 0.222144 0.025668 0.977359 0.513223 0.531901 0.360643 0.616841 1.341911 0.888846 1.600347 1.373974 0.123418 0.279769 -0.016126 0.463887 1.222914 1.957299 0.569052 1.699668 0.580517 1.202146 1.407428 1.172831 0.507495 0.800333 0.267556 -0.108002 1.745992 0.435164 1.044228 1.843822 0.030677 1.871048 0.542929 1.649600 0.514183 1.864352 0.330625 0.131744 0.409433 0.986423 1.602974 0.780283 0.138004 1.178452 0.747173 1.116954 0.917346 0.796903 0.356061 1.164738 0.640385 1.216938 0.366648 0.258624 0.900284 0.041536 1.817962 1.403113 1.192348 0.700576 1.370480 0.286847 0.603480 0.172807 1.255252 0.148259 1.272121 0.592895 1.744785 0.951797 1.489669 1.384870 1.365248 1.727217 1.576364 1.630892)
     )

;;; 81 prime --------------------------------------------------------------------------------
#(81 14.317508929282 #(0 1 0 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0)
     14.256287400004 #(0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1)
     13.652944564819 #(0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 1)

     11.500874 #(0.000000 0.060156 1.198187 0.010810 -0.059627 1.336892 0.174682 0.177182 0.303039 0.507728 0.174616 0.162104 0.767672 0.283268 0.740356 1.244073 0.411651 0.771082 0.597722 1.646364 0.130092 1.399674 1.196320 1.542256 1.814795 0.969378 1.368552 0.008802 1.647015 1.538679 0.957584 0.562757 0.185463 0.612441 1.264483 1.129777 -0.291833 0.231345 1.808426 -0.095607 1.827790 0.807634 0.929515 0.025793 1.640598 1.271614 1.470525 0.036943 0.657753 0.872430 1.519719 0.128077 0.109048 0.492656 -0.089269 0.591629 -0.109776 0.882829 0.675418 0.557752 1.879709 0.050861 1.363712 1.313213 0.120759 0.673965 0.894225 1.390640 -0.198915 1.435867 0.650146 0.682721 0.919339 1.509191 0.176654 0.428794 0.550059 1.279511 0.067206 1.270072 0.509792)
     )

;;; 82 prime --------------------------------------------------------------------------------
#(82 14.492313651671 #(0 1 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0)
     14.126787045134 #(0 1 0 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0)

     11.479968 #(0.000000 1.167241 -0.045182 1.431900 0.006928 1.403861 0.545511 1.691768 0.899782 -0.077081 1.028643 0.382106 1.530199 0.075479 0.130994 1.428877 1.224718 1.066346 0.134368 0.253197 1.939237 0.220853 1.523234 0.080696 0.116590 1.164685 0.452172 1.075782 0.104717 0.322119 0.015920 0.012689 0.836359 0.583611 1.419163 0.375549 0.960878 0.106535 0.267036 0.160415 0.428158 1.135553 0.577704 1.594919 1.418104 -0.006664 1.734837 0.347259 0.714742 0.651634 0.176099 0.189689 0.618223 -0.014505 0.119097 0.503721 1.461665 1.343096 1.244598 -0.030343 0.817508 1.457214 1.769555 -0.005120 0.578504 1.249322 1.744151 1.355272 0.735779 0.403039 1.036467 1.243623 0.707927 1.652177 0.532109 1.167473 0.843983 0.089345 0.026331 0.421863 0.713589 0.173777)
     )

;;; 83 prime --------------------------------------------------------------------------------
#(83 14.249828726851 #(0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1)
     14.019070339131 #(0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1)

     11.515698 #(0.000000 0.476850 1.444123 0.757768 0.904341 1.500634 1.172056 0.150207 1.399168 1.718222 1.242901 1.599171 1.479889 1.407424 0.383997 1.635464 1.906757 1.571678 0.846779 0.450005 0.103137 1.981438 0.703734 1.449561 0.361823 0.581503 -0.030271 0.642212 0.969226 1.353072 -0.172628 1.708415 0.048244 1.730731 0.993670 1.701498 0.859175 1.740792 0.895733 1.353890 1.889492 0.628265 1.157017 0.152147 1.018231 0.389240 1.355474 0.566778 1.740146 0.772357 0.240403 0.444558 0.326601 0.645698 1.536930 1.580906 0.988045 1.423975 1.523235 0.570522 -0.021485 0.566594 0.634662 0.251495 1.922729 0.461288 0.400670 1.505130 1.698043 0.454115 1.859899 0.839223 0.826517 0.671026 1.807185 1.202343 0.218319 1.657302 1.546790 0.124357 0.644351 1.373263 0.323738)
     )

;;; 84 prime --------------------------------------------------------------------------------
#(84 14.422843763275 #(0 1 0 0 0 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 0)
     14.299305314276 #(0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 1)
     14.264351844788 #(0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 1 0 1 1)
     14.024940956301 #(0 1 0 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 0)

     11.560943 #(0.000000 1.281504 1.221914 1.430587 1.016577 1.316681 0.865988 -0.349818 -0.450682 0.539654 0.805734 1.142696 0.803514 0.772189 0.920570 -0.062121 1.900234 1.328317 0.637158 0.933725 1.470771 1.615705 -0.339576 1.477192 0.483636 0.390990 1.163512 0.470554 0.810129 0.219910 1.036454 0.113983 1.709679 0.573362 0.443985 0.250807 1.103469 0.710293 0.544384 0.757061 0.527559 1.366415 0.023058 1.409255 0.076295 0.455402 1.054634 0.584110 1.146332 1.240265 0.042614 1.096356 -0.037745 1.057424 0.479652 -0.635251 0.692062 0.690959 1.726479 0.565828 1.047911 0.856595 0.539485 0.961085 0.559723 1.097320 -0.120540 1.349211 0.182474 0.797756 0.972880 0.095173 -0.192601 1.398661 1.550702 0.660840 0.567708 1.234929 0.048617 0.900959 1.650948 0.830459 0.179842 0.670523)
     )

;;; 85 prime --------------------------------------------------------------------------------
#(85 14.721940394615 #(0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 0 1)
     14.400919537796 #(0 0 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1)
     14.253310943921 #(0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1)

     11.640254 #(0.000000 0.056720 0.207939 1.738977 0.566905 1.645836 1.164296 1.534833 1.062075 1.718533 0.612358 1.773505 0.699524 0.909646 1.285432 -0.077070 1.321460 1.260933 1.501352 1.254223 1.405955 0.898277 0.480628 1.255070 -0.017775 0.053556 0.134785 1.075613 0.929379 1.253092 0.830476 0.380456 0.659934 1.782934 1.116749 1.270402 1.022517 1.218306 1.188036 1.429205 0.699826 0.248255 0.608182 1.453164 0.174031 1.980755 0.172647 1.281934 0.610172 1.692635 0.885261 0.937170 0.244608 0.895682 -0.201169 0.784424 0.207134 1.128229 1.605656 1.726081 1.482842 -0.492816 1.786502 1.515255 1.723893 -0.436984 0.782469 1.860396 1.292546 1.179181 0.135900 0.781276 1.118886 -0.184031 1.745136 0.391228 -0.040389 0.614871 0.371110 0.247569 1.131915 1.583061 0.707959 -0.225613 -0.110651)
     )

;;; 86 prime --------------------------------------------------------------------------------
#(86 14.993455205117 #(0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1)
     14.394402956102 #(0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 0 1)
     14.017106967247 #(0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 1 1 0 0 0 0 1 0 1 1 1)

     11.524995 #(0.000000 1.256833 0.754559 1.761169 1.051575 1.125948 1.193560 0.995260 1.746440 0.712029 0.177949 0.563093 1.135136 0.235182 0.728693 0.301410 0.564390 1.273552 0.865785 0.293122 0.696826 0.364873 0.245097 1.692896 0.325228 1.483258 0.111424 1.764388 0.389856 1.097227 1.853431 0.384584 1.597888 0.323079 0.222164 1.453767 0.861101 1.218714 0.475704 0.148340 1.482860 1.779235 1.799558 1.719358 1.123100 0.712033 0.540703 -0.313815 0.993713 1.111378 0.122026 1.867950 1.335431 0.877059 1.683846 0.893155 1.000275 1.643334 1.227961 0.837657 1.947896 0.463951 1.057388 1.078120 1.536850 1.526342 0.007785 0.655159 -0.124255 0.280613 0.635073 1.773068 0.323494 1.302143 0.482393 1.467982 1.900245 0.569721 1.483604 0.830484 0.730755 0.635681 1.341532 1.296972 1.871702 1.498242)
     )

;;; 87 prime --------------------------------------------------------------------------------
#(87 14.798576861642 #(0 0 0 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0)
     14.519235937355 #(0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0)
     13.98394199918 #(0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0)

     11.926956 #(0.000000 0.480739 1.221469 1.271551 0.071604 1.832563 1.160531 1.532307 1.700863 0.898038 -0.154964 1.167110 0.132921 0.082756 0.642394 1.028938 0.305936 0.024673 1.632658 1.777919 -0.115051 0.308561 0.941441 1.397503 1.109948 1.769892 0.823876 0.223562 0.962890 0.046803 1.176980 -0.067930 1.411675 0.952514 1.437538 0.560086 0.969242 1.839669 0.499080 1.254606 1.036022 0.461763 0.138241 1.269029 0.375463 1.270790 0.977946 0.773165 1.311339 0.693529 1.909070 0.656791 1.689061 1.645352 0.092640 0.069892 0.827110 1.799771 0.492602 1.519008 0.471864 1.282638 1.379677 1.886215 0.437034 1.342606 1.600894 0.872180 1.288080 0.084064 0.572472 1.767577 1.252258 0.924903 1.591335 1.529532 0.685112 0.184634 1.928681 0.361317 0.709919 1.750879 1.601850 1.517876 1.614669 0.027397 1.760337)
     )

;;; 88 prime --------------------------------------------------------------------------------
#(88 15.158827781677 #(0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1)
     14.908 #(0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 0 1 1 0)
     14.84298551254 #(0 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0)
     14.837036132812 #(0 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0)
     14.825139803345 #(0 0 0 0 1 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0)

     11.988941 #(0.000000 0.784577 0.582655 -0.034103 0.163974 0.329543 0.693568 0.791635 0.508446 0.396915 1.248395 0.826252 1.437835 1.346260 1.098554 0.836111 0.285181 0.833650 0.396981 0.462954 0.362450 1.183096 1.004262 0.908804 0.301743 1.532670 0.011752 -0.072123 0.996811 1.778401 0.688894 0.044599 0.465473 0.579840 0.996613 0.177680 1.437542 0.677747 1.616279 0.045690 0.566144 1.136899 0.636783 0.355278 1.821475 1.658271 1.588631 1.539506 1.624123 1.239000 1.605890 0.921379 1.791768 0.223451 1.057625 1.753981 0.669208 1.245749 0.682902 0.319986 0.831757 1.041603 0.551747 0.279645 1.731984 0.406762 1.759751 -0.021178 1.248606 0.309853 0.756421 0.658187 1.127576 -0.365423 1.909061 0.823437 1.017441 0.941761 1.686220 0.570407 1.741961 1.705746 1.303576 0.477079 0.894393 0.214957 1.446786 0.714971)
     )

;;; 89 prime --------------------------------------------------------------------------------
#(89 15.157893052401 #(0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 1)
     14.69031483888 #(0 1 0 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1)

     12.218910 #(0.000000 0.347703 1.287576 0.007551 0.866941 1.348188 1.119521 1.165502 -0.027931 -0.156168 0.431794 1.701337 1.827081 -0.033337 1.773468 0.458272 0.513684 -0.429024 0.100603 1.171028 1.248057 0.825454 0.111866 1.348941 0.194970 0.787296 0.985932 1.482210 -1.838437 0.518386 1.644154 1.090937 0.061955 0.876464 0.741287 1.863658 1.249809 0.196205 -0.245301 0.670813 0.445662 1.126889 1.097876 1.069956 1.734096 1.147374 1.577436 0.999163 1.424341 1.858688 0.447886 0.010645 0.322444 1.678139 0.600570 1.714695 0.640910 0.766495 0.122811 1.639992 1.575245 1.581210 1.284584 0.187248 0.123767 1.299609 0.434472 -0.227959 -0.003084 1.356901 1.560710 1.657322 -0.424337 0.820737 1.427815 1.009911 1.555482 1.270712 0.441371 1.236011 0.904018 0.281522 0.017616 1.213130 1.296244 0.990040 0.290646 1.574203 0.302300)
     )

;;; 90 prime --------------------------------------------------------------------------------
#(90 15.253639451837 #(0 1 1 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1)
     14.917379556641 #(0 1 1 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1)
     14.831111851861 #(0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1)

     12.040546 #(0.000000 0.308535 1.831039 1.068784 1.207961 0.604913 0.255795 0.526051 0.518583 0.537818 0.271903 -0.101514 0.084843 1.021351 1.759427 1.149016 1.631495 1.385753 0.366181 1.831936 0.182890 1.691962 -0.414589 0.614351 1.438870 1.137327 0.624652 -0.137501 0.250788 0.625542 1.490935 0.096584 0.093082 1.435551 0.085073 -0.379083 1.234794 1.596277 1.427868 0.222468 0.334423 1.837553 0.656171 1.066181 0.249644 0.983158 0.112198 0.507520 0.545871 1.168895 -0.131170 0.478835 1.596236 0.394338 1.863574 1.027099 1.386887 0.022272 0.957642 1.170199 1.336324 1.448371 1.065275 0.071535 1.291681 1.653614 0.464730 1.500178 1.170431 1.205171 0.732180 0.207697 1.382733 0.214125 0.460604 1.160568 0.219196 1.655526 0.257161 0.978583 0.990159 1.074268 -0.281775 -0.408853 1.589587 0.386746 0.614297 -0.165126 1.180202 0.980619)
     )

;;; 91 prime --------------------------------------------------------------------------------
#(91 15.264 #(0 1 0 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 0)
     14.775403022766 #(0 1 1 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0)
     14.702056847646 #(0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0)

     12.124999 #(0.000000 1.675854 0.558125 0.722504 1.537946 1.103158 -0.101419 1.094191 0.860108 1.844659 1.153738 1.203619 0.546538 1.605814 1.578461 0.934155 1.202567 1.190355 1.915136 -0.167584 1.662294 1.224064 1.464427 0.619213 0.946226 0.717143 1.769260 1.681360 1.390672 1.331056 0.988954 0.506606 0.360065 0.615580 0.378200 1.413291 1.784281 1.997429 0.564876 0.541417 -0.206164 -0.066397 0.465888 0.521262 0.862789 0.160903 1.550802 1.123787 0.020601 0.714795 1.052955 0.907033 0.557234 -1.733159 0.758199 1.432811 0.412665 0.497545 1.438891 1.778039 0.569885 0.389137 1.755052 0.220533 -0.062879 1.429696 0.985662 1.847154 0.698621 1.432057 0.373769 1.546514 0.492124 0.676766 0.457427 0.962707 1.619101 0.944059 1.649970 0.604479 -0.290197 1.084673 1.760017 0.353650 0.338466 0.565818 0.619833 0.759429 1.406678 -0.042353 0.588561)
     )

;;; 92 prime --------------------------------------------------------------------------------
#(92 15.373 #(0 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 0 1 0)
     15.307026596891 #(0 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 0 1 0)
     14.9424 #(0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0)
     14.556435035882 #(0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0)

     12.123914 #(0.000000 1.121774 1.202485 1.172760 1.561029 1.384650 0.366084 0.100912 1.213710 0.684639 1.715353 0.264109 0.739365 0.903450 1.368064 0.161490 0.589910 -0.574430 0.238835 0.084495 1.758209 0.390575 0.365837 1.244123 1.816917 0.736358 -0.476895 0.928821 1.525830 0.278595 0.608525 0.848031 1.028188 1.752200 1.128895 1.838425 0.169557 1.143241 0.660720 1.345741 0.565114 0.276351 0.523229 0.008149 1.505122 1.113306 0.791629 1.810463 0.617645 1.305612 1.765307 0.755440 1.536552 1.638340 1.291064 -0.211770 1.323460 0.203502 0.023951 0.642188 0.595142 0.913222 1.367116 1.318794 0.793902 1.527263 0.199972 1.307873 1.122732 1.660535 0.584141 1.440416 1.305526 -0.151347 1.417346 1.230715 0.872230 1.515988 1.058810 1.942534 -0.427168 1.203093 1.293957 1.523281 0.451632 0.666545 0.669352 0.493685 0.181127 0.949221 0.720822 1.126236)
     )

;;; 93 prime --------------------------------------------------------------------------------
#(93 15.814494404587 #(0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1)
     15.072628413546 #(0 1 0 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1)
     14.994668960571 #(0 1 0 1 0 0 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1)

     12.323397 #(0.000000 0.199963 1.180724 -0.024343 1.226375 -0.402136 0.168523 1.313836 1.060714 1.370552 -0.471865 0.051393 1.826180 -0.226097 1.794079 0.176177 0.029279 1.765656 -0.022993 0.924413 1.319281 1.348871 0.657083 1.021102 0.556079 1.679658 0.119278 0.154784 0.786857 0.314106 1.909349 1.379970 0.486239 0.159940 1.547391 1.177792 0.671257 -0.176460 1.805002 1.892101 1.067471 1.153719 0.249337 0.426943 1.568658 0.284044 0.861446 -0.338286 0.531428 1.450755 0.605670 0.121121 1.131478 1.187561 1.041801 1.153378 1.486202 0.325760 0.201023 0.376157 0.907130 0.389618 0.779509 0.246617 0.355275 0.698575 1.371835 1.170196 1.188933 0.531048 0.008203 1.693556 0.426031 -0.330917 0.226068 0.478929 -0.022448 0.820583 0.181321 1.394112 0.214726 0.952096 1.780527 0.477402 0.370644 0.018381 1.506735 0.676340 -0.005190 1.098917 1.472044 0.136836 1.154585)
     )

;;; 94 prime --------------------------------------------------------------------------------
#(94 15.835750579834 #(0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1)
     15.441287870957 #(0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0)
     14.811392756555 #(0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0)

     12.372284 #(0.000000 0.443961 0.975468 0.665627 0.603420 0.053131 0.306985 1.398862 1.315822 1.027281 0.141353 0.068859 0.515109 1.551710 0.559483 1.154898 1.062171 1.088212 0.844250 0.492324 -0.085203 0.372997 1.377703 1.412362 1.590941 0.015253 -0.053671 1.084827 1.672259 1.823973 0.424632 1.792989 0.693404 1.273404 0.373397 1.282394 -0.222604 0.823730 1.821435 0.830056 0.905326 1.119027 0.338679 0.323132 1.572257 1.693368 1.617589 1.262068 1.377617 -0.071238 1.120960 0.924011 0.108375 0.409469 0.705856 1.358638 1.649735 1.159074 1.592832 0.679108 1.663652 1.223795 0.200633 -0.160917 1.201748 0.776569 0.821633 0.259058 0.902729 0.178012 1.711364 0.349704 0.758303 0.750335 0.936872 0.168192 0.485748 0.828259 1.367780 0.601135 0.970970 1.052074 1.846930 -0.031412 0.332694 1.027172 1.579686 0.520946 0.479472 0.979137 -0.124751 1.022187 0.809346 1.384445)
     )

;;; 95 prime --------------------------------------------------------------------------------
#(95 15.827 #(0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 1 0 0)
     15.616318215916 #(0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 1 0 0)
     15.240 #(0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1)
     
     12.510256 #(0.000000 0.317992 0.927893 0.597260 1.401589 1.607490 1.677492 1.497046 1.311990 0.167057 1.220195 -0.275898 1.090861 1.091651 0.630436 0.916875 0.660479 1.544881 1.745131 1.492217 1.235529 0.110786 0.950259 -0.239919 0.461971 0.813099 -0.022703 0.514302 0.905321 0.470121 0.047459 0.049772 0.386569 0.906197 0.759799 0.092680 0.960823 1.147229 0.606160 0.259335 1.310186 1.706266 1.852978 0.401665 0.217593 0.510927 1.427442 0.216993 0.137230 1.851339 0.418288 0.135947 0.081877 1.037880 1.391044 0.282600 0.893633 0.781555 0.768520 1.748815 0.946732 0.521672 0.707533 0.379804 1.363870 0.384535 0.045383 1.898323 -0.117111 0.478054 -0.143321 0.628264 1.443117 1.080549 1.727471 1.352404 0.661587 0.275644 0.185961 0.104981 0.261026 0.846627 0.746789 1.873558 0.251716 1.364940 0.641791 1.157693 0.384372 0.928797 0.022021 0.829256 -0.174655 1.861127 0.782995)
     )

;;; 96 prime --------------------------------------------------------------------------------
#(96 16.039880627473 #(0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 0 1)
     15.648203810823 #(0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 0 1)
     15.281 #(0 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 0)
     15.135 #(0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 0)

     12.668635 #(0.000000 0.917231 1.444662 1.651025 1.626476 0.217227 1.342479 0.082546 0.769400 0.697918 0.473934 0.738934 0.166439 0.946756 0.045800 1.282963 1.275622 1.280868 0.188483 0.557668 0.319739 1.195269 1.822309 0.654895 1.305806 1.077303 0.066610 0.817070 1.080630 0.397261 -0.016572 0.960881 0.787355 1.428628 -0.005112 0.519759 1.432833 1.372382 0.719445 1.297194 0.107288 -0.230799 0.232238 1.034059 1.643621 0.927304 0.421645 0.222732 0.127765 0.747342 1.664909 -0.327066 0.399925 -0.073586 1.851567 0.035512 0.749395 1.523885 1.393689 1.285868 1.078508 0.844354 1.050986 1.027071 0.908850 1.369452 1.220902 0.990145 1.637537 1.258288 -0.081170 0.726933 1.402614 1.506526 0.626316 1.888762 1.222687 0.905212 0.529528 1.520893 0.081868 1.269921 0.647120 1.481417 1.320328 1.749636 1.134283 0.847804 0.082697 -0.145388 1.448190 1.253118 -0.014956 1.136271 0.346762 0.665255)
     )

;;; 97 prime --------------------------------------------------------------------------------
#(97 15.972457232959 #(0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0)
     15.726 #(0 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0)
     15.685384750366 #(0 0 0 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1)
     15.404807595571 #(0 0 0 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1)     

     12.638179 #(0.000000 1.284324 0.143609 0.558137 0.269843 0.647411 0.365588 0.483053 -0.164761 0.661825 1.288987 0.501944 0.278559 0.770115 1.750859 1.050015 1.488708 0.484648 1.698700 1.398381 0.327499 1.029683 0.189845 0.305366 0.734789 0.786586 0.491266 1.590585 0.463796 1.367800 1.284696 0.783663 1.323715 0.012736 1.549764 1.673210 1.428225 1.695148 0.244284 1.012739 1.433180 -0.195196 0.021722 0.383148 0.793028 1.036364 1.665320 1.924744 0.561588 0.585600 0.410128 0.422262 1.147934 0.580897 0.031342 -0.197535 -0.158116 1.355327 1.607000 0.733340 1.896019 0.755840 1.681856 1.296150 0.615371 1.807443 0.365534 0.224875 0.882980 0.428617 0.568066 -0.062985 1.464920 0.878317 0.119327 1.513511 0.839927 0.048755 0.201128 0.282602 1.118430 -0.248157 0.444275 1.591347 -0.094161 1.248782 1.653484 0.606657 1.724357 0.818840 0.701424 -0.054599 0.176030 1.437011 0.772132 0.741975 0.966305)
     )

;;; 98 prime --------------------------------------------------------------------------------
#(98 16.082024156883 #(0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
     15.695913722267 #(0 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
     15.435913738557 #(0 0 0 0 1 1 1 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0)

     12.898782 #(0.000000 0.780136 0.072337 1.879089 0.914430 1.030432 1.323483 1.115760 0.522821 0.500247 1.420285 1.474281 0.416888 0.286320 1.527237 1.436861 1.724824 -0.033771 0.692674 0.967820 0.667222 1.432362 -0.065991 1.845598 0.627094 0.705607 1.800042 0.230591 0.773487 1.652911 0.170657 1.415157 1.039495 1.113500 1.892302 1.313900 0.735178 1.230354 0.694819 1.845770 1.220860 1.472071 0.603355 1.654843 1.502791 0.607151 0.656650 0.390356 0.206029 1.337044 1.590029 1.513012 0.779770 1.365493 0.033002 0.457269 0.672037 0.807247 0.592405 0.542404 1.234252 0.381961 1.575367 0.070987 1.838739 0.842003 1.038992 1.648865 1.576107 1.259229 0.680716 0.489307 1.036872 1.042978 -0.079215 0.009476 -0.348002 1.407737 1.404775 0.428796 1.719278 0.030337 -0.087357 0.053697 1.726959 1.312730 1.278743 1.667937 -0.005644 1.292285 1.690558 1.371937 1.573887 1.952748 -0.057991 0.561431 -0.271704 0.855499)
     )

;;; 99 prime --------------------------------------------------------------------------------
#(99 16.078 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0)
     15.391923904419 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0)

     13.089316 #(0.000000 1.571688 0.649975 0.615861 1.624518 1.794216 0.218947 -0.020075 0.927880 0.587380 1.132927 0.254485 0.625023 0.760802 0.820337 1.325878 0.661914 1.134112 1.528888 1.614621 1.186723 0.756518 1.180678 0.960556 0.728019 1.907091 -0.006375 1.107585 1.197778 0.966606 1.469869 1.621422 0.314402 -0.083479 0.810581 0.990724 0.998140 0.874249 0.842268 1.203377 -0.058710 1.589344 0.622909 1.017104 1.319378 1.368083 1.065422 0.642381 0.548099 0.173199 1.670418 0.575652 0.450894 1.053758 1.086958 0.107721 1.048930 0.478602 0.819354 0.000272 0.425231 0.271450 0.872097 0.666339 1.824743 0.067867 0.352398 -0.077185 -0.506206 0.583229 1.300521 0.111032 1.028257 0.835376 1.155205 0.059423 1.509305 0.987783 1.340770 0.926246 0.050399 0.432946 1.353314 0.444525 0.369712 1.190173 -0.031160 0.730246 0.650482 -0.045765 1.061412 1.892493 0.302705 1.561668 0.860003 1.592137 1.044231 0.486128 1.099008)
     )

;;; 100 prime --------------------------------------------------------------------------------
#(100 16.360503791276 #(0 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0)
      15.909478013087 #(0 0 1 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0)
      15.637986183167 #(0 1 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1)

      13.115818 #(0.000000 1.375246 1.374460 1.612001 1.545417 0.398417 1.473387 0.888767 0.902692 0.458102 0.140491 1.549476 1.110326 0.821227 0.283977 1.430429 0.371461 -0.228195 1.133050 0.057970 1.250651 0.558491 0.328112 0.745572 0.454418 -0.369839 -0.021076 0.358959 1.407902 0.595108 0.887085 1.236287 -0.010767 1.429798 1.294943 0.021593 1.377638 1.289550 1.168574 0.044307 0.117201 0.527042 0.360286 1.140394 1.631443 1.015835 0.000977 0.888331 1.374286 0.048905 1.542790 1.625066 0.860555 0.173394 0.533697 1.026204 0.793181 1.719792 1.921936 1.282342 1.674804 -0.020423 -0.231425 1.261605 1.668362 1.083499 1.680304 1.273426 0.461079 1.355130 0.102172 1.720726 0.412657 1.444096 1.572685 1.980106 1.001645 1.207776 -0.169689 0.053335 1.488112 0.666401 1.063362 0.570690 1.265073 1.520225 0.612569 0.698813 1.545991 1.922583 0.991138 0.982010 1.778124 1.691158 0.622414 0.349733 0.707857 0.146548 1.622656 1.238744)
      )

;;; 101 prime --------------------------------------------------------------------------------
#(101 15.994265071036 #(0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0)
      15.74836063385 #(0 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0)
      15.735968313601 #(0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1)

      13.068305 #(0.000000 0.723603 -0.175448 1.542710 0.743511 0.124099 0.340464 1.649565 0.390575 0.073213 0.369276 1.511194 0.282850 1.803105 1.102845 1.574270 -0.239783 1.515308 0.364806 1.004396 0.755858 1.310298 0.293302 1.317088 1.675376 0.096968 0.471612 0.756139 -0.357736 -0.097465 0.067053 1.477118 0.701729 1.075449 0.550880 1.321641 0.989176 0.113696 0.580007 0.080743 1.956570 0.188984 1.294092 1.230699 0.727574 0.517311 0.254880 1.621639 1.566692 1.147090 0.489479 1.752576 0.062566 1.245005 0.033032 1.050654 0.436604 0.115822 0.380937 1.010395 0.786017 -0.012925 1.266360 0.203269 0.700142 -0.006814 0.615420 -0.327041 0.859074 1.215869 1.133020 0.062929 1.243465 0.012090 1.665740 0.916156 1.101163 1.234142 0.578274 1.698453 0.655452 0.052818 0.504515 1.263307 0.597459 0.816441 0.355365 0.353053 0.990337 0.584457 0.387749 0.174410 0.873157 0.123687 0.230044 0.497615 1.110927 0.927730 0.241602 0.463539 0.458408)
      )

;;; 102 prime --------------------------------------------------------------------------------
#(102 16.342473246951 #(0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1)
      15.374809992584 #(0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 1)

      13.399115 #(0.000000 0.281360 1.197486 0.203837 0.436644 1.772947 0.299365 0.348392 0.862940 1.639869 1.493543 0.268575 1.587947 -0.183863 0.554047 1.110121 1.658736 0.228543 0.511263 1.320579 1.158051 -0.046708 1.561235 -1.937025 1.189617 1.178251 0.844832 1.544741 -0.045024 1.977832 1.235561 1.316833 0.806689 1.442507 0.162380 1.230247 0.809059 0.352783 0.156705 0.836244 0.486170 0.067017 1.641619 0.845339 1.343398 1.491202 1.457702 0.580508 0.484063 0.951130 1.251651 1.529505 1.696979 1.260688 0.307486 1.745091 1.156385 1.459924 1.554968 1.225977 1.283310 1.000319 1.667162 1.106623 1.601365 1.013887 1.573732 0.296882 0.742743 0.565022 0.539940 1.652857 0.415530 1.274487 0.960482 1.254301 1.337437 0.432754 0.014962 1.572366 0.141684 0.576459 0.739516 0.503263 1.792497 0.761820 0.566047 0.738732 0.259355 1.444179 0.722279 1.262855 0.141958 1.408585 1.413231 0.175513 1.250030 0.287723 1.413511 0.950817 -0.123783 0.026867)
      )

;;; 103 prime --------------------------------------------------------------------------------
#(103 16.7018587939366 #(0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 1 1 1 1 1)
      16.296298498866 #(0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1 1 1)

      13.424309 #(0.000000 0.270192 0.378141 0.293556 0.606850 0.441656 1.421604 1.591876 0.729956 1.524002 0.472051 0.825623 0.146632 0.175740 -0.034138 1.706929 0.754492 0.131630 1.742432 0.312502 0.867288 1.172218 -0.012284 0.651016 1.099218 0.133638 0.676403 0.146518 1.433827 1.304077 1.377956 0.758706 -0.047157 1.297586 0.260738 1.175143 0.407783 0.214496 1.861160 0.582137 -0.135036 1.517409 1.814915 0.540760 -0.098673 1.091955 0.475884 0.954596 0.192072 0.675975 0.460826 0.614261 0.883339 1.729528 1.609152 1.311336 1.224397 1.843224 0.345328 0.078478 0.702998 -0.038001 0.505916 0.301255 1.422429 1.664544 0.353645 0.955859 1.255643 0.219535 0.965650 -0.076419 0.033154 1.698893 0.489041 1.415700 1.517407 0.350881 1.071322 0.843317 1.755328 1.486772 0.821617 0.627427 1.255955 0.473786 1.097759 1.010203 0.145591 0.306327 1.532147 1.863823 0.830906 1.644647 0.661894 1.222543 0.422803 1.075551 1.482735 1.101338 0.682614 0.483166 0.734732)
      )

;;; 104 prime --------------------------------------------------------------------------------
#(104 16.659368297545 #(0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0)
      16.473171464163 #(0 0 0 1 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0)
      15.919013023376 #(0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 0 1)

      13.196868 #(0.000000 0.003486 1.021437 -0.068642 -0.415500 1.594880 -0.067497 1.265076 1.547994 1.269960 0.990455 0.201408 -0.032846 1.354885 1.170572 1.356970 1.161876 0.862866 1.034574 0.337578 0.265606 1.890570 0.388289 0.450081 0.777947 0.869883 0.542093 1.280505 0.485031 0.681185 0.591435 -0.073581 0.599987 1.637061 1.176376 1.308211 1.434042 1.331788 0.330491 1.259675 0.520361 1.046559 1.840139 0.642583 0.435236 1.539761 1.067237 1.447742 1.601099 0.122568 1.913240 1.720542 1.509255 0.909387 1.185266 0.747187 1.636130 0.411613 1.973006 1.379629 -0.129534 0.496709 1.178868 1.456246 1.456185 -0.260975 1.849514 1.437062 1.131234 -0.024810 1.635456 0.080026 0.600003 0.425769 0.581120 1.495553 1.924341 -0.469495 0.121677 1.502866 1.134734 0.780781 0.228075 0.442424 1.379798 1.669787 0.424644 1.390004 1.215590 1.343947 0.178009 0.297242 1.131521 0.160927 0.231017 0.971197 0.340258 0.631117 1.278763 0.785596 1.408715 0.638372 1.284511 -0.264450)
      )

;;; 105 prime --------------------------------------------------------------------------------
#(105 17.115185731735 #(0 0 0 1 0 1 0 1 1 0 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 1)
      16.038356734428 #(0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0)

      13.143893 #(0.000000 0.008746 0.199505 0.208382 0.073783 1.461865 0.545960 0.565781 0.227853 0.810226 0.491746 1.482018 0.511387 0.639687 1.766385 1.750728 1.027229 0.177023 1.351672 -0.180128 1.243478 -0.108411 1.611230 1.093765 1.222830 0.101187 1.525203 1.305258 1.228723 1.673740 1.763120 1.493579 0.104096 0.175449 0.862181 1.376243 1.460754 1.327582 0.650050 1.066205 0.618826 0.033597 0.263308 0.337088 1.521009 1.807111 1.798214 0.427360 -0.189759 0.457401 1.235734 1.335898 -0.073167 0.875457 1.419225 -0.103429 1.470188 1.876171 0.585829 0.912578 0.004186 0.325338 0.318292 1.428608 1.105510 0.909907 -0.170896 0.062797 0.943187 0.103488 1.128495 1.537335 1.435948 -0.144025 1.357741 -0.121349 1.800887 0.778549 1.394328 0.522065 0.739495 0.870178 0.660002 0.422734 1.515328 1.936452 1.124075 1.495864 1.629958 1.714732 1.283330 0.090638 -0.018260 1.185256 1.507123 0.072263 0.910996 1.878908 0.451820 1.051355 0.255264 -0.013610 0.766187 1.414106 1.897867)
      )

;;; 106 prime --------------------------------------------------------------------------------
#(106 16.130035426315 #(0 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1)
      15.730461834714 #(0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1)

      13.216116 #(0.000000 0.993224 1.704484 0.965516 -0.106421 0.929364 -0.103809 1.892920 0.528571 0.628202 0.611650 0.772360 1.409446 1.583944 0.705809 1.206311 1.251472 0.244082 0.995882 1.353046 0.389353 1.781881 1.103808 -0.955111 1.282735 1.430707 1.115753 0.602831 -0.045257 1.154869 1.312723 0.020460 0.406637 -0.183172 0.877428 1.322834 1.286980 1.302439 0.331488 1.033514 1.224727 0.649173 1.587018 1.184904 1.268382 0.234139 0.491657 0.046835 1.068515 0.484648 0.953527 1.046962 0.025703 0.960294 1.055168 1.236568 1.532126 0.280327 0.552356 -0.201509 0.203274 1.097184 0.604155 1.763365 0.885875 0.802029 1.044722 1.115297 0.975490 0.379076 1.362460 0.882270 0.523506 0.326526 1.479497 0.914614 0.257532 1.824617 0.594415 0.196692 -0.151576 -0.236422 1.377813 0.483333 1.301230 1.441585 1.075563 1.593986 1.088151 0.941155 -0.375980 0.182537 1.256736 1.731942 1.533860 1.857270 0.837386 1.296051 -0.129598 0.440325 -0.302009 0.370163 1.500663 0.731901 0.648770 1.076988)
      )

;;; 107 prime --------------------------------------------------------------------------------
#(107 16.541004232936 #(0 0 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1)
      16.328491210938 #(0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1)
      16.264743804932 #(0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1)
      16.2013 #(0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1)

      13.561785 #(0.000000 0.390935 0.217738 1.058248 0.775389 1.820796 1.025454 -0.018384 1.668618 0.097346 1.521402 1.669774 1.520621 0.811321 0.150272 0.807743 0.362052 0.734085 0.333190 0.055618 1.425024 0.775268 0.716322 1.057414 1.804724 0.898090 0.307531 1.656127 0.235919 1.614947 0.487368 0.715939 0.087395 0.906709 1.453609 -0.008004 1.029002 0.780523 1.211366 1.106510 0.010664 1.409877 1.534941 1.218507 1.214232 0.766885 1.465376 0.035582 1.395929 1.569232 1.479349 1.702871 0.887898 0.355531 1.479092 0.767568 0.322733 1.293429 0.494105 1.055303 0.718368 0.491146 0.229243 0.638205 1.457636 1.236211 0.508181 0.993425 0.230667 0.114329 0.725221 0.345782 1.797980 0.958998 0.175656 0.669919 0.678386 0.217803 0.768195 1.190394 0.800334 1.724007 0.097741 0.816421 0.347592 0.637389 1.697356 0.578653 1.431643 0.552992 1.487464 1.526021 1.227014 0.576005 0.270382 0.991257 0.957408 0.611130 0.290129 0.192565 0.622553 1.589563 1.235169 1.315336 0.647994 -0.003804 1.173237)
      )

;;; 108 prime --------------------------------------------------------------------------------
#(108 17.139458240072 #(0 1 1 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1)
      16.664336486859 #(0 1 1 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 1 1 1)
      16.517358779907 #(0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1)

      13.662807 #(0.000000 0.749773 0.660340 1.264055 0.294562 1.422805 -0.225728 1.535001 1.147766 1.627875 -0.100360 0.099553 1.185028 0.663816 1.657501 0.308113 1.697950 1.599838 1.274452 0.966535 0.844367 1.088386 0.628312 0.935081 0.012419 -0.042118 0.223109 0.238708 1.671623 1.866872 0.735284 0.877082 0.157085 0.539976 1.238928 0.706346 0.482566 1.254961 0.146887 0.313739 0.514041 1.282438 1.152971 -0.258766 0.534793 0.239352 0.338934 1.781858 0.565091 1.819618 0.719580 1.709506 1.617628 0.000815 1.340368 -0.145337 0.576895 1.446773 0.804520 1.494696 0.794642 0.335758 0.707538 0.674146 0.341021 0.350691 1.800196 1.299085 0.261056 0.035092 0.794226 0.574234 1.649503 0.725473 0.292125 1.433253 1.679468 0.186222 0.177033 0.470616 1.068889 1.122604 0.125798 -0.076699 1.598618 0.071431 0.897590 0.216427 0.242570 0.796686 1.468293 0.332997 0.566448 1.537794 0.956292 0.587191 1.092701 1.593313 0.582226 1.786941 1.360154 1.851364 0.131017 0.020834 1.696187 -0.088739 -0.222250 1.634353)
      )

;;; 109 prime --------------------------------------------------------------------------------
#(109 17.4553 #(0 1 0 0 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0)
      17.086888321276 #(0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 0)
      16.93954489715 #(0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 0)
      16.726722717285 #(0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 1 1)

      13.694286 #(0.000000 1.369938 -0.021715 0.759312 0.652362 1.150170 0.000503 0.315658 0.780099 0.702751 0.478092 1.040872 1.596546 0.079395 1.785852 1.186371 1.427100 1.143844 1.840204 0.232124 0.220312 0.855796 0.273639 1.455182 0.645692 1.486099 -0.095883 1.476106 0.581755 1.084822 0.859038 1.676571 0.635488 0.229340 1.467173 0.938758 1.282022 0.809255 0.815990 1.232416 1.573720 1.606908 0.619092 0.670224 1.239025 0.093506 1.462127 0.243973 0.882889 0.008046 1.566010 0.483280 1.399950 0.762535 0.673661 0.251024 0.821892 0.806381 0.857115 1.154389 0.832863 1.349563 0.795320 1.711108 0.401225 0.729018 1.519669 0.847986 1.591416 1.057427 -0.206143 0.920224 0.315949 0.279038 1.320980 0.442747 0.476334 1.408455 0.305782 1.661306 1.107761 1.179136 0.197783 0.609283 0.374820 0.006984 -0.285793 0.767077 1.669033 0.477594 0.564509 0.439472 0.725241 -0.015728 1.496734 -0.049392 0.475552 0.510286 1.892254 1.462099 0.581104 0.194764 1.332721 1.138487 1.012036 0.691533 0.901630 1.126510 0.393181)
      )

;;; 110 prime --------------------------------------------------------------------------------
#(110 17.014086078381 #(0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 1)
      16.799713998439 #(0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 1)
      16.455888332339 #(0 1 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1)

      13.779744 #(0.000000 0.850227 0.497220 1.537930 0.058540 1.195772 1.015455 0.995307 0.172620 0.058736 0.948192 -0.068413 1.886083 0.532532 1.935002 0.361692 0.203497 0.795311 0.696105 0.686768 0.315062 0.854655 1.699131 1.029888 1.541782 1.189731 0.005451 1.404510 1.392924 0.101410 0.646935 0.987955 -0.040950 1.073201 1.310060 0.575816 0.071457 1.405511 0.439718 1.853876 1.613995 0.005918 1.021734 0.276094 0.462015 1.424377 0.457480 1.773018 1.738625 0.264097 1.709458 0.587662 0.082780 0.067824 1.792777 0.027319 1.987101 1.792880 0.700595 1.565417 0.909661 1.305291 0.634467 1.310604 -0.024562 0.368437 0.342808 1.306505 -0.104324 0.334250 0.058782 -0.062861 0.556318 1.632801 -0.121229 1.758412 1.648544 0.830806 -0.149254 1.668365 1.986928 1.491954 0.797000 0.828703 0.350609 1.566054 1.723785 1.364427 1.338897 0.540369 0.830163 -0.096243 1.563975 0.919637 0.769115 1.792575 0.314543 1.354198 0.004126 0.577695 1.198788 -0.070786 0.262013 0.482165 0.881112 0.327757 0.485758 0.495241 1.469304 0.365631)
      )

;;; 111 prime --------------------------------------------------------------------------------
#(111 16.941944255543 #(0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1)
      16.783880166046 #(0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0)
      16.6662 #(0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0)

      13.765518 #(0.000000 0.606920 0.485461 0.498952 -0.155832 1.299755 1.834489 1.167647 0.874356 0.520102 0.019170 0.431085 0.345240 1.101886 1.495277 1.420196 0.997135 -0.128231 1.538202 1.223072 0.929170 1.779264 1.248824 0.488657 1.036346 -0.134269 0.909862 0.447884 1.540831 1.346574 1.033729 0.936195 1.591240 0.966294 1.877059 0.575466 1.325928 0.763375 0.098033 1.910381 1.713418 0.850602 0.779471 1.534020 0.282669 0.909433 0.709452 1.588751 1.103769 0.050237 1.071802 -0.014114 1.705292 1.002032 0.036542 0.638461 -0.001003 0.312797 1.731543 1.701566 0.042193 0.359097 0.617897 1.568178 1.268420 1.840308 1.918022 1.610367 1.580962 0.890308 0.957717 1.403970 1.032886 1.157102 1.538455 1.304846 0.006377 0.324462 0.654176 -0.006664 -0.272991 1.700005 0.851301 1.255638 0.841811 0.036747 0.365319 1.082793 1.066562 1.418390 1.072611 -0.182517 0.434879 -0.182571 1.188958 -0.209464 1.466318 -0.025701 0.086780 0.211702 1.481835 1.408797 0.613436 1.723700 0.685012 0.291133 1.432416 0.069327 -0.268733 0.341425 1.169744)
      )

;;; 112 prime --------------------------------------------------------------------------------
#(112 17.423562009124 #(0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1)
      16.697049415765 #(0 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1)

      13.864630 #(0.000000 0.667640 0.018427 1.084823 1.752566 0.872002 0.899942 1.348073 0.685309 1.848582 1.328389 0.709153 1.504571 0.457541 0.889972 1.920532 0.283199 0.734695 -0.081788 0.616048 0.509551 1.367076 1.085961 1.633362 0.515769 1.395558 1.420933 -0.387103 0.732081 0.174082 1.578214 1.915644 -0.001504 1.383162 1.276693 0.569217 1.647329 0.972795 0.322059 1.648646 0.181962 -0.093077 1.791500 0.877077 0.333186 0.392070 1.606606 0.781846 0.605114 0.176424 0.336533 0.358696 -0.122694 0.199074 1.071911 1.943406 0.628227 1.217258 0.058203 0.086860 0.861563 1.724974 0.898419 1.218727 1.087046 0.153676 0.001157 1.356470 0.843241 1.900054 0.222691 1.388345 1.227871 1.751514 0.405991 0.868840 1.665919 1.842744 0.219178 1.465864 0.268329 0.569268 0.636455 1.099737 0.687966 -0.003139 1.739586 1.184468 0.536619 1.090113 1.819836 1.403904 0.000599 1.459174 1.036490 0.836097 -0.159718 1.183378 0.569670 -0.077987 1.195238 0.837916 0.477895 0.949345 0.690918 0.909850 0.183127 0.480021 0.592386 0.955197 -0.047810 0.352038)
      )

;;; 113 prime --------------------------------------------------------------------------------
#(113 17.29593895793 #(0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0)
      16.7898 #(0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 0 1)
      16.203890830538 #(0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1)

      14.036359 #(0.000000 0.558289 -0.181905 1.023907 1.902151 0.986183 1.869170 0.948429 1.414349 1.257250 0.832685 -0.064129 0.676925 0.285633 1.031234 0.610209 1.245664 1.205570 0.348145 0.194986 1.227921 1.748105 1.275284 0.304531 0.566845 0.722018 1.722148 0.135662 0.960628 1.048052 0.279213 0.609207 -0.198589 0.801101 0.035851 1.577776 0.159877 1.399012 1.821444 0.184063 0.614962 0.920057 0.510977 1.336187 1.394647 1.553465 1.305703 0.043273 1.424638 0.435477 0.671973 1.101432 0.265133 1.307189 1.247626 -0.180297 1.250827 -0.078950 1.431618 1.853157 0.034385 -0.215510 0.012817 1.849433 0.981113 0.088478 -0.018194 0.836019 -0.231835 0.884661 0.427083 0.722589 1.751162 0.847236 0.157672 0.670547 1.917407 0.330150 0.591244 0.131065 1.245804 0.963519 1.620196 1.325566 0.409236 1.879476 1.026420 1.182890 0.515671 0.075046 0.122178 0.647559 0.025694 1.276893 0.171610 0.842099 1.200603 0.266627 1.333768 1.718676 1.552805 1.378130 1.103274 0.822528 0.380083 1.881664 1.552122 1.839615 0.683410 1.300008 1.076238 0.946559 0.315147)
      )

;;; 114 prime --------------------------------------------------------------------------------
#(114 17.592388063856 #(0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 1 1 1 0 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1)
      16.769464540605 #(0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1)
      16.442732865586 #(0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1)

      14.214351 #(0.000000 1.035492 0.828190 1.127174 -0.125232 1.828105 1.264982 1.161515 1.511548 1.495182 1.867364 1.525142 0.956786 1.357284 0.494132 1.618249 0.047663 0.829380 1.884109 1.162384 1.268553 0.159435 1.758618 1.396303 1.421484 0.958734 0.250279 1.226225 -0.103319 0.745211 1.023012 1.337763 1.598555 -0.076212 1.593825 0.365129 0.395173 1.431743 1.750068 0.667358 0.933705 1.491737 0.197417 0.383598 0.482074 0.601345 1.748721 0.270159 1.789348 0.371325 1.001890 0.675862 0.363590 0.464219 1.810122 1.942086 1.886614 1.181900 1.411532 1.834622 1.923740 1.418184 0.009084 1.753309 1.248930 0.753114 -0.122551 1.399069 1.249289 0.680977 1.260175 1.460526 -0.103408 0.193547 0.636890 1.102339 0.873185 0.456410 0.242324 0.516794 1.258822 0.020978 -0.005608 1.709759 1.306546 0.261654 1.287810 0.905492 0.857666 1.468235 1.336246 1.217318 1.434311 1.918652 0.273251 0.162134 0.369483 -0.249908 1.758902 0.770900 1.038462 0.579633 1.783856 1.108142 1.179829 1.064155 0.095754 0.070701 1.641782 1.256102 1.017838 0.080981 0.357541 0.418140)
      )

;;; 115 prime --------------------------------------------------------------------------------
#(115 17.480941944057 #(0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 0)
      17.1559 #(0 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 0)
      16.774665887963 #(0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 0 1 0)

      14.169785 #(0.000000 1.580697 0.357885 1.338626 0.279349 0.917750 0.363129 1.473952 0.384672 0.687731 0.641797 1.286936 1.583005 0.459793 0.255344 0.067928 -0.478552 0.954337 0.727939 1.251929 0.419780 0.944535 0.566124 0.085530 0.548368 0.469318 1.086844 1.620431 0.046843 1.515823 0.783946 0.485497 1.890854 -0.140230 0.404521 1.527525 0.213519 1.520471 -0.236336 0.581950 1.517510 -0.088906 1.676339 0.284175 0.744569 0.454166 1.488433 1.011552 -0.018043 1.570284 1.247177 0.437192 -0.031549 0.770992 1.107499 1.300128 0.330433 1.946310 -0.096915 1.904333 1.395615 1.272803 1.207661 1.829580 0.695231 0.529980 1.362453 1.276811 -0.090832 0.076980 0.166060 1.498254 1.095446 0.317841 0.360780 1.574425 1.488362 0.983855 1.702599 0.847308 0.122302 1.353810 0.942873 1.956533 0.688041 1.351474 0.814186 1.485438 1.309120 0.306567 1.783618 0.502315 0.850752 0.043710 0.890235 0.751509 1.580555 1.212711 1.035752 0.206316 1.480927 0.209741 0.176238 1.412530 -0.296804 0.460821 1.502482 1.520096 1.465724 1.640563 1.418950 1.024832 0.152768 0.002170 0.308325)
      )

;;; 116 prime --------------------------------------------------------------------------------
#(116 17.885190963745 #(0 1 1 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0)
      16.812931137234 #(0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0)

      14.467193 #(0.000000 0.853574 1.010677 0.778848 1.886393 1.264717 0.120494 1.195834 0.285539 1.778940 0.028076 0.557848 0.419047 -0.105491 1.346599 1.002182 -0.026379 0.541331 1.586318 0.517584 -0.235784 -0.092137 -0.005452 0.695055 1.629748 1.219658 1.194465 0.846858 0.903511 0.981815 0.638815 0.829710 -0.005221 1.551870 0.021628 0.893679 0.319922 0.099705 0.265954 -0.318627 0.722844 0.895740 -0.023688 -0.369412 0.104706 1.056050 0.801069 0.791807 0.148978 1.012968 0.383648 0.386866 0.202009 1.882271 1.579762 0.481219 0.237091 1.213495 0.019733 0.127630 0.532035 0.388102 0.691330 0.985557 1.747412 0.315417 0.567303 0.889226 0.862532 0.449679 0.681217 1.605719 0.637001 -0.146899 0.940661 0.313838 1.801725 0.270845 1.350493 0.828304 0.240368 0.833761 1.442438 1.790171 0.947841 1.243982 1.579142 -0.039530 1.475597 1.513695 -0.018788 0.644239 1.287000 1.656741 1.561682 1.601531 0.598176 0.399467 1.477053 -0.262508 0.895001 0.302303 0.340895 0.453801 1.604008 1.565786 0.988202 1.912435 0.860611 1.724833 0.939257 1.297724 1.312015 0.906229 0.239792 0.696106)
      )

;;; 117 prime --------------------------------------------------------------------------------
#(117 18.290939331055 #(0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1)
      17.710553146299 #(0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 1)
      17.5997 #(0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 1)

      14.600705 #(0.000000 0.221287 0.991141 0.120838 1.193967 1.237114 0.316090 1.900340 0.457301 0.670241 -0.069724 0.185307 0.147120 1.762836 0.115368 1.304729 1.221589 1.521751 1.453582 1.592955 0.139732 1.236351 1.530358 0.993652 0.298240 0.674661 1.235155 0.247899 0.574685 0.410834 0.593634 0.687853 0.849155 1.616605 1.789039 1.948639 -0.076042 0.768273 0.664784 0.278223 1.718246 0.440457 0.355133 1.183511 1.590359 0.434889 0.233769 0.946524 0.914225 0.527707 0.869431 1.335334 0.815823 0.063846 1.045542 1.263898 1.630179 1.606148 1.544756 0.580313 0.824169 0.668670 0.753078 0.493916 1.290212 1.928103 1.463698 0.321555 1.744044 -0.004940 -1.857734 0.202415 -0.084792 1.786115 0.697773 0.092412 0.428394 0.699265 1.018023 1.590262 1.403503 0.397031 -0.005019 1.637868 1.112448 1.232387 1.465121 1.389636 1.247702 0.471711 0.596397 -0.107371 1.272477 1.795151 0.428687 1.116421 0.230332 1.434893 0.222266 0.122652 0.263763 1.037158 1.551902 0.710385 1.620382 0.106770 0.447853 0.025736 0.197737 1.006543 1.616714 0.150781 1.400078 -0.020818 0.598493 1.918669 0.620661)
      )

;;; 118 prime --------------------------------------------------------------------------------
#(118 17.985612869263 #(0 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0)
      17.181785583496 #(0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0)

      14.545252 #(0.000000 1.594336 0.743219 1.723440 -0.234970 0.679052 0.503161 1.250027 0.810684 0.893233 0.048222 0.856270 0.316973 1.345269 0.375749 0.874393 1.470276 0.304288 0.952130 1.386721 0.133764 0.350714 0.579429 1.666460 0.573660 0.587256 1.165274 0.913798 0.433349 0.208640 1.738688 0.256886 0.412314 1.079449 -0.187285 0.982771 -0.115126 1.509050 0.491417 1.671684 0.029108 0.510803 0.525497 0.886510 -0.361074 0.175215 0.882393 1.495358 0.843775 0.808968 0.690873 1.277829 1.614206 0.829665 1.577589 1.334586 0.805912 0.091738 -0.174697 0.732268 0.637789 0.472866 0.523888 1.701525 0.748041 0.269094 0.686636 0.400962 0.028361 -0.024607 0.119568 1.337354 1.107243 1.698456 0.327679 1.242891 0.752637 1.161185 1.314534 0.986833 0.693033 1.637629 0.401199 1.707578 -0.267824 -0.076078 0.220828 1.707090 1.217042 1.663667 1.682006 1.383730 0.703478 0.289967 -0.016910 0.948586 1.854353 1.375369 0.534554 0.981833 1.396727 0.349584 0.281522 0.537884 1.661597 0.786624 0.014619 1.161210 0.128308 0.165187 0.642597 0.194568 0.090400 -0.214013 0.478019 0.675414 0.991722 0.775599)
      )

;;; 119 prime --------------------------------------------------------------------------------
#(119 18.0781 #(0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1)
      17.500297546387 #(0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 0 1 1)
      17.167841346875 #(0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1)

      14.390682 #(0.000000 1.375664 1.071878 1.242281 0.449872 0.997239 0.326902 1.844870 0.041292 1.299611 1.550408 0.729190 0.953350 0.209856 0.257680 0.853205 0.858641 1.807278 0.814295 0.490323 1.317949 0.220101 1.124178 0.689692 0.845713 1.610142 0.807190 0.053107 0.167263 1.261235 1.535767 1.158168 0.246566 1.099513 1.210170 1.481156 0.887639 1.096230 0.144442 0.446125 0.627726 -0.213400 0.869947 0.988021 1.647446 0.493250 1.672678 1.658411 -0.130924 1.196700 0.900590 0.905506 1.144054 1.144682 1.583644 1.532418 1.405419 1.861571 1.337158 1.938890 1.060547 0.949400 1.139259 1.324089 1.811791 1.700889 0.580433 -0.043873 0.685223 0.393731 1.345217 0.593893 0.307423 0.675865 1.845148 0.894101 0.377727 1.240396 0.150868 0.234381 0.772691 0.408668 1.155960 1.889975 0.784676 1.158424 1.614216 1.924591 0.178912 0.577105 0.980476 1.603643 0.495073 -0.104468 1.507041 0.927685 1.105445 1.078554 0.022413 0.000361 0.338859 1.519222 0.863311 0.615320 0.570559 1.762687 0.669024 0.026456 1.421100 1.955221 0.629611 -0.125129 1.900181 -0.021163 -0.020189 1.567842 0.924421 1.826999 0.630355)
      )

;;; 120 prime --------------------------------------------------------------------------------
#(120 17.635260884038 #(0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0)
      17.540792728815 #(0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0)
      17.067 #(0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0)

      14.506129 #(0.000000 1.300842 0.699059 1.323155 0.029576 0.076316 1.248030 0.928812 0.918482 1.171483 0.352941 1.154263 0.878275 0.139625 1.185810 0.875449 0.689819 1.688063 0.036302 0.235641 1.238697 0.528127 0.270021 0.644608 0.923907 -0.209246 1.214424 1.874199 1.932467 0.730893 0.895354 1.057631 1.135138 0.953814 0.334468 0.093391 -0.063354 1.543633 0.335243 1.523085 0.894347 1.016424 0.519396 0.890707 0.949225 -0.127752 0.261997 0.136956 0.496776 1.184854 1.684942 0.826921 0.579507 0.865816 1.365821 1.371772 1.895433 0.457517 0.433768 1.431985 -0.026871 1.474699 0.203629 1.317186 0.472452 0.493864 0.207488 0.318283 1.230241 1.521394 1.317422 0.340289 0.418039 0.501594 1.696219 1.228553 1.345526 1.343192 1.894603 0.952142 -0.214540 0.493121 1.946367 1.425358 0.216458 0.428738 0.200276 0.570492 0.980655 1.572774 1.176927 1.211114 0.032984 1.175452 0.288478 0.275703 0.774352 0.203144 -0.005407 -0.017841 0.629722 1.520589 0.347999 1.350292 0.555261 1.134612 0.491938 1.690467 0.943132 1.037142 0.626901 1.118027 0.538092 0.252140 0.836302 0.741950 0.997060 0.730851 1.529993 -0.074114)
      )

;;; 121 prime --------------------------------------------------------------------------------
#(121 18.236074758398 #(0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0)
      17.782977183017 #(0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 0)

      14.550648 #(0.000000 -0.104377 1.728779 0.015877 0.360660 1.561616 1.867526 -0.543391 0.362739 0.429648 1.184029 1.862384 1.389096 0.232866 0.228541 0.207789 0.309346 0.165082 1.219312 -0.112747 0.633604 1.280649 1.094003 0.844071 0.382963 0.337761 1.761493 -0.299347 -0.077832 0.030337 1.158850 1.396308 0.357223 1.065478 1.124409 0.702756 1.270092 0.594788 0.646685 0.435016 0.541860 1.298823 0.515459 0.781947 0.187661 0.127458 1.612077 1.109652 -0.111300 1.511035 0.372412 1.336544 1.121133 1.409798 0.028286 0.628212 1.483931 -0.142573 1.056072 0.829710 1.417471 0.806697 0.781228 1.460788 1.436396 1.549966 0.567738 0.569686 -0.533762 0.639951 0.997506 1.252042 -0.072179 1.123987 1.049992 -0.068665 1.801722 1.588021 0.588980 0.017861 1.330696 0.370809 -0.063387 1.255329 0.722041 1.832120 0.249471 0.351458 1.618948 1.476729 0.524913 1.355881 0.196243 0.314195 0.012827 1.276044 0.133658 1.173581 1.491855 0.644432 0.944980 1.012122 0.731464 0.643858 1.603990 1.115817 -0.240244 0.115728 0.543356 0.622781 1.654540 1.115048 0.276945 0.951072 1.631055 -0.159720 1.015230 0.317307 0.083539 1.033243 0.425160)
      )

;;; 122 prime --------------------------------------------------------------------------------
#(122 18.225525517344 #(0 1 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 1)
      17.876078447724 #(0 1 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 1)

      14.874787 #(0.000000 0.670095 1.879512 1.579924 1.770675 0.815114 0.565059 1.811295 1.702655 1.750333 0.998295 0.379603 -0.278247 1.315153 1.857734 0.091075 0.099685 1.593423 0.960776 0.934376 1.202563 1.164563 0.425273 0.613978 1.440205 0.417407 -0.048006 0.295351 0.529820 1.864059 1.308939 0.153806 1.896993 1.724309 0.316884 0.594636 -0.331384 1.315296 1.726170 1.056708 1.038253 1.029234 1.780442 1.606982 -0.118817 0.794547 0.337402 0.844614 1.652485 1.486764 0.824615 0.033510 0.947720 1.171102 0.105484 0.221835 -0.117939 0.786316 0.188138 0.508500 -0.096212 0.807896 0.572640 1.630861 1.205387 1.411462 0.803771 1.062599 0.353023 1.747713 1.151962 0.039894 1.370553 1.470732 0.309067 -0.052009 1.677723 1.539157 1.508435 0.442588 1.392651 0.705016 0.785906 1.264772 1.720309 0.402204 1.004437 0.223531 1.029106 0.132783 1.330489 1.466545 0.604437 -0.044864 1.407670 0.028371 0.118461 0.730221 0.219868 0.370955 1.670340 -0.236978 0.728609 0.288574 1.052016 -0.084744 0.418295 0.137534 1.577266 1.352579 1.819573 1.318043 0.285010 1.789351 1.044188 0.948019 1.452262 0.020308 1.584532 0.002061 1.199851 1.853825)
      )

;;; 123 prime --------------------------------------------------------------------------------
#(123 18.144585330068 #(0 1 0 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1)
      17.389867782593 #(0 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0)
      17.273 #(0 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0)

      14.606318 #(0.000000 0.018375 0.589471 0.983384 0.991984 0.372395 -0.040275 0.299423 1.756771 0.367581 1.925315 0.431987 -0.091930 1.365768 0.790238 1.730935 1.453895 0.945086 0.541022 0.665855 -0.133333 1.898784 1.614955 0.125913 -0.075642 1.042483 1.409785 1.598074 0.355453 1.697472 1.704234 0.447761 0.702787 1.037349 1.268895 1.641450 0.389018 0.691038 0.964549 0.799007 -0.028923 0.682141 1.218121 0.346438 0.248506 0.187480 1.166792 0.799601 1.529262 1.053370 1.663430 1.815223 1.438810 1.297963 0.281072 0.228128 0.996820 1.126305 0.635366 1.152238 1.612305 0.687034 0.492102 0.223406 1.290673 0.404319 0.673144 1.585101 1.003033 0.671106 0.630415 0.262596 -0.092794 0.970586 -0.143151 1.120737 0.513895 1.346570 0.209142 0.468700 0.483816 0.465304 -0.188333 0.812984 1.400518 1.773921 1.423889 0.414054 -0.317948 0.988906 0.349734 -0.120165 0.609604 -0.196752 0.649574 0.752742 0.402866 1.001890 0.667657 -0.097642 -0.022329 0.780061 0.422052 0.637506 0.933615 0.491032 1.329969 0.891484 0.826863 0.432342 1.071482 1.483913 0.545228 0.886707 1.473772 1.459843 1.911936 0.601733 -0.070730 1.820410 1.529051 0.044995 0.589246)
      )

;;; 124 prime --------------------------------------------------------------------------------
#(124 18.115 #(0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1)
      17.868420183527 #(0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 0 1 1 0 0 1)

      14.876858 #(0.000000 1.227535 1.001758 1.145151 1.506842 0.119210 1.071294 1.424488 0.400365 0.178962 0.357001 1.164239 0.271427 0.749293 1.395586 1.624515 0.513024 0.166361 1.542872 0.950855 1.297157 1.124243 0.341025 0.031220 1.888426 0.692061 -0.265781 0.611701 -0.181094 1.342523 1.650863 0.841326 1.080047 0.612269 0.720653 1.562285 0.023995 1.334907 -0.205592 0.068313 0.934507 0.947441 0.942528 1.357235 0.811111 1.105118 0.738782 0.597809 1.017472 0.239915 1.291555 0.884397 1.679540 1.308002 0.033266 0.111725 1.122030 0.578160 1.307440 0.280578 1.398276 1.452978 1.068125 1.123465 0.016943 1.553786 0.606243 0.377901 1.504790 0.366379 0.354285 1.266091 1.665332 0.042697 0.695167 0.615720 0.969753 0.705433 0.560170 -0.052357 0.763707 1.517203 0.415937 1.469067 1.638104 1.203844 0.588308 1.408067 0.239057 1.792842 1.688277 1.338780 1.698990 1.910375 1.138470 1.665618 0.009822 1.817902 0.953793 0.816671 0.582761 1.229732 1.187916 0.140235 1.229660 -0.231975 1.562026 0.573247 0.927364 0.331211 0.944204 1.581635 1.624559 1.847536 0.091435 -0.187153 0.015267 0.450717 -0.023440 0.929358 1.202991 1.673814 1.105775 1.137593)
      )

;;; 125 prime --------------------------------------------------------------------------------
#(125 18.072 #(0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1)
      17.637776156888 #(0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 0 1 1 1)

      14.772411 #(0.000000 1.488367 0.539453 0.636319 1.701536 0.864646 0.653079 -0.015234 -0.146959 -0.016393 1.159310 0.253720 0.483376 0.791134 0.148523 1.139178 0.651015 0.419622 1.011424 1.343222 0.375202 1.487445 1.136349 1.264222 1.195821 1.118452 0.058438 0.180283 -0.364874 1.141390 0.108460 0.432578 1.082489 -0.344327 0.561149 -0.050777 0.153514 0.046289 0.013379 0.201861 0.723817 0.636257 0.099730 -0.252366 1.579710 1.247947 0.727318 0.604484 0.768675 1.814508 0.866882 0.945446 1.203952 0.553202 1.570818 0.438899 1.210503 0.074303 1.805294 1.142851 0.477720 0.743449 -0.030259 0.761798 0.442190 0.180723 0.743309 -0.143585 1.116545 1.404371 0.204979 0.238499 1.331119 1.234638 1.176686 1.242725 0.433339 0.737611 -0.052694 0.108421 1.540317 0.211091 1.637087 0.618282 0.999958 1.643481 0.805826 1.863967 0.824505 0.797379 0.836059 -0.009548 1.065334 1.608230 -0.042496 0.454917 0.581669 0.915626 0.146732 0.685151 0.520442 1.115897 0.367688 0.129909 1.145807 0.921815 0.252576 -0.010734 0.180757 1.854774 0.546533 1.532747 1.382619 0.143523 0.214257 0.954384 0.657013 1.826584 1.432640 0.172761 -0.181378 1.290872 1.519863 0.506886 0.104986)
      )

;;; 126 prime --------------------------------------------------------------------------------
#(126 19.269804000854 #(0 0 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1)
      18.284595039843 #(0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1)

      14.919977 #(0.000000 1.469803 0.590807 0.764079 1.791170 0.333377 0.787711 1.497688 1.425800 1.198769 -0.142602 1.315353 -0.073058 1.238142 -0.046252 1.358363 0.881227 0.034517 0.376307 0.332870 0.693500 1.217503 0.199404 -0.446423 0.007791 1.544042 1.693684 1.705920 0.539256 1.329303 -0.184478 1.516336 1.012314 1.494800 1.597619 0.336783 1.080235 0.583130 1.276101 1.725256 0.652789 1.276830 1.460138 1.593259 0.514539 1.170620 1.278633 0.619783 1.325249 1.591358 0.207365 1.060129 0.815013 0.040269 1.468914 0.227402 0.515366 0.731820 0.621073 0.837063 1.275146 0.259307 0.585385 0.909317 0.921047 0.261764 0.230595 1.268807 1.340737 0.628738 0.406147 1.678580 0.814730 0.487283 1.140440 0.869819 1.474812 0.775855 -0.116531 0.130586 0.641169 1.517310 1.370799 1.423659 0.321563 0.178649 1.411675 1.146911 0.966764 1.521079 1.121859 -0.427787 0.506332 1.644605 1.138614 1.523684 0.664505 0.648038 0.075277 0.416802 0.443365 1.235830 1.173282 1.107298 0.136026 -0.032457 1.449977 -0.023926 1.087880 -0.136228 1.342249 1.136201 1.846662 0.865407 0.833970 1.810099 1.018847 -0.107251 0.065627 1.367299 0.507024 0.142912 1.416639 0.609252 0.711456 0.417251)
      )

;;; 127 prime --------------------------------------------------------------------------------
#(127 19.129140790802 #(0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1)
      18.198689419357 #(0 0 0 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1)

      14.965777 #(0.000000 -0.111675 0.316902 0.553785 0.709389 1.665160 1.773718 1.223907 1.870892 0.124352 0.659318 1.214748 -0.230061 0.430914 0.820039 0.606726 1.915463 0.933059 0.141265 0.700903 1.104666 0.342520 1.104803 0.861991 1.131090 0.356681 0.717592 1.097760 0.635835 1.470101 0.133634 1.185320 0.894468 1.885328 0.355145 0.962928 1.693462 0.779651 1.374926 -0.245382 1.185649 1.789218 0.704176 0.285542 1.867133 0.821585 1.711374 0.439203 0.276042 1.328502 1.295483 1.479199 1.084656 0.742745 1.267086 1.947108 0.779717 0.909414 0.327635 0.976570 0.621637 0.026316 0.941433 0.968265 0.263033 1.781989 0.202387 0.097148 -0.527543 1.902079 0.537345 1.807657 -0.149873 0.930711 0.775776 1.164532 1.634998 1.575386 0.666718 0.747688 0.895870 0.099498 1.160346 0.173837 1.190414 1.304739 1.245723 0.638618 0.424930 1.710033 0.864374 0.095659 1.260547 1.363866 1.340672 0.972096 0.211201 0.749451 1.255416 0.918101 0.089249 0.129796 0.822266 0.227183 1.416789 0.657353 0.150653 1.816977 1.922353 1.010211 0.968163 0.577493 1.525022 1.201802 0.965872 1.848671 0.832118 0.226787 0.378188 0.143057 -0.022344 0.510246 0.907111 0.883080 0.791239 1.298749 0.798347)
      )

;;; 128 prime --------------------------------------------------------------------------------
#(128 18.871676504971 #(0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1)
      18.306106723228 #(0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1)
      18.276384353638 #(0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1)

      14.646558 #(0.000000 0.931408 1.489207 0.989895 0.020597 0.226500 1.896297 0.891048 -0.377856 0.281742 1.322096 0.819409 1.651430 -0.055136 0.967147 1.088213 0.952068 1.525678 1.135738 0.856130 1.835891 0.361724 0.914390 1.573305 0.998234 0.945345 1.348275 1.718474 1.530311 1.622091 0.038854 -0.139337 -0.117511 -0.025784 0.100427 0.507080 0.130980 1.390168 0.570936 0.081614 0.721610 1.820020 0.326027 1.742475 0.337445 1.800913 1.660181 0.604036 0.256019 -0.212681 0.266145 1.837194 0.639673 1.175262 -0.322078 1.063901 0.350120 1.597968 1.829349 0.674362 1.281232 1.269759 0.942547 1.377542 1.658444 0.205176 0.482392 1.068642 0.600257 0.057559 0.599568 1.889115 1.804564 1.116495 1.754671 1.423259 0.974612 1.072218 1.528057 -0.378866 0.777909 1.333101 1.905515 1.771660 1.335490 1.330023 0.635244 0.886272 0.005936 -0.190347 0.965138 0.722596 0.447830 1.931519 1.755556 1.464552 0.934315 0.255649 -0.046785 1.156353 0.968221 0.466288 0.467266 1.652277 1.704884 0.901366 1.786335 1.359757 0.424635 1.133411 0.712955 0.756107 0.566094 0.972240 0.827424 1.520997 1.269787 0.434694 1.562958 0.744726 0.442320 0.565892 1.786013 1.190471 -0.034474 0.319887 1.096501 0.817652)
      )

;;; 256 prime --------------------------------------------------------------------------------
#(256 27.740 #(0 1 0 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1)

      25.419292 #(0.000000 1.139929 1.102745 1.741314 0.362270 1.867278 -0.105796 0.818148 1.710527 1.852271 1.124318 1.670890 1.153503 0.195801 1.002124 0.467505 1.049937 0.142894 0.085485 1.658937 0.491728 1.241311 1.322988 0.765513 1.862684 0.158048 0.184902 0.364251 0.607460 0.160072 1.059841 1.058104 1.188210 1.281788 0.605768 0.044404 0.063311 0.674089 0.592930 0.211703 0.030582 0.160150 1.609868 1.314862 1.540462 0.499958 0.255349 1.385713 1.225596 1.323240 1.907235 1.512131 0.755403 0.859403 1.645985 1.326003 0.062908 0.441796 0.954669 0.168027 0.516707 0.922222 0.189230 0.272544 0.472239 0.553957 1.434892 0.429635 1.400931 0.255779 0.446915 -0.097364 0.010974 0.185385 1.838088 0.722158 0.636251 0.319610 0.900579 0.585282 1.916411 0.284763 1.647549 0.469510 0.056494 1.051937 0.839561 0.491974 1.028802 1.773079 0.399350 1.305864 1.439648 1.938862 1.794159 0.371223 1.096547 0.742554 0.816016 1.210775 0.917874 0.861164 0.505923 1.824144 1.685486 0.860715 1.263824 1.850040 0.906459 1.245640 1.446237 0.478492 0.330388 0.240550 0.475287 0.333923 0.461789 0.887379 0.765592 1.453119 0.159768 1.029570 1.310462 0.743877 0.659014 0.156047 1.339711 1.733763 1.914764 1.783195 0.311674 0.523974 1.009176 1.284070 0.814963 1.982550 1.654619 1.786557 0.152975 0.552534 1.941831 1.909265 0.024048 1.982739 0.172030 0.361974 1.716273 -0.145229 0.059166 0.923627 1.369358 0.259568 0.603591 1.244786 1.772948 1.455451 0.278943 1.396699 0.483204 0.706810 0.610680 1.017552 0.504030 1.246537 0.695997 1.710753 0.064401 0.966739 0.486122 1.103392 1.069961 1.199883 0.173924 1.605015 1.493330 1.468259 0.224231 1.356642 0.799457 0.943289 1.443695 0.483173 1.340693 0.391180 1.005750 1.024557 0.693691 0.750249 0.307649 0.380108 1.914054 0.115308 0.520112 0.000006 0.467400 1.333649 0.446022 0.351018 1.570672 1.024307 0.066464 0.462119 0.177876 0.365882 0.903910 0.056543 1.482436 0.056456 1.134537 0.787030 0.268455 0.834182 -0.004538 1.625912 1.079081 1.485660 0.837184 0.498066 1.823166 1.225371 1.040093 0.129168 0.924645 0.160099 1.780342 0.192620 1.690804 0.751720 1.760030 1.260828 0.448859 1.138104 0.090032 0.250034 -0.145296 1.040075 1.391702 0.079881 0.515861 0.385145 1.779559 0.214107 0.743183 1.112600 0.419711 1.838072 1.427776 0.925752 1.817873 0.317608 0.532205 1.862275 0.506156 1.710729 1.157460 0.942925)
      )

;;; 512 prime --------------------------------------------------------------------------------
#(512 43.486 #(0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1)

      40.250883 #(0.000000 1.067513 1.698501 0.882175 0.731347 0.396065 0.813755 0.963760 0.557013 0.330055 0.624000 1.141499 1.802667 1.147883 0.326439 1.700018 0.473901 -1.947004 0.102662 0.379112 0.161997 0.698965 0.728968 1.831300 1.279360 0.816655 0.480698 0.093700 1.500681 0.898464 0.536091 0.756778 0.355391 1.392086 1.233289 1.645259 1.641894 1.615256 0.190786 0.267903 -0.286330 -0.089039 0.457097 0.658540 1.669825 0.917012 -0.042627 1.298688 0.946526 1.789310 0.083576 1.102187 0.738679 1.390586 0.999921 1.312093 1.826088 0.412733 1.685728 0.303259 1.268988 0.900854 0.694405 1.727172 1.988661 1.867458 0.705458 0.724026 0.979505 0.018063 1.080148 0.984039 0.301365 0.996085 0.485066 1.698333 0.099220 0.144439 1.014550 -0.046011 0.199879 0.463422 1.340837 0.783213 1.151598 0.929237 1.727193 1.863491 1.325152 0.546479 0.970852 1.131669 1.594581 0.745485 0.269563 0.379861 0.913425 1.716346 0.963726 0.148826 -0.018344 0.857745 0.892045 1.081944 0.100251 1.000912 0.257282 0.111202 -0.008496 0.039287 1.417113 0.640192 0.675981 0.443529 0.868295 0.738861 0.820750 0.210774 0.082349 0.151630 0.783391 -0.180922 -0.106637 1.765370 0.742155 1.145606 1.368009 0.515346 0.436263 0.531741 0.802011 1.255309 1.894160 0.809353 1.813552 0.281020 0.025004 0.747411 0.889253 1.421629 1.808561 1.930509 0.839043 0.610805 0.811512 0.326999 1.060202 0.726316 0.486908 1.524130 1.740371 0.854892 1.794712 0.054857 0.374885 0.689897 0.804719 0.518621 0.778791 0.586676 1.098197 0.585149 1.186102 0.137320 -0.004366 0.332212 1.070131 1.845537 1.823307 0.557314 0.209620 0.792755 1.166951 0.717837 0.512510 0.629260 0.191128 1.302358 -0.197581 1.489802 0.982325 1.740676 -0.076574 1.688248 0.129965 0.784432 1.177913 1.102657 0.962095 0.929165 0.113690 1.498481 0.501354 0.386777 1.808656 0.189192 1.582104 0.598519 1.088596 1.677954 0.635479 0.886732 1.765869 1.721541 1.323683 -0.029727 1.928583 1.600246 0.279454 1.267423 0.990704 0.156419 0.680659 1.338166 1.787057 1.240138 0.302495 0.331931 0.199416 0.603149 0.714679 0.722359 1.555137 0.579030 0.968070 0.619479 1.564829 -0.173450 0.479277 1.582690 1.625073 -0.082864 1.364367 0.506113 1.020073 0.013031 0.901348 0.115571 1.654832 1.160506 1.382047 1.813620 1.803032 1.458055 0.157051 0.295770 -0.207462 1.435226 1.701103 0.634436 0.784529 0.075139 0.479500 1.222882 1.537827 0.905886 1.390016 0.322620 1.008572 0.815478 1.829604 0.684699 0.623092 1.869009 1.370361 1.545318 0.088302 -0.093316 0.065215 1.068848 0.441787 1.694437 0.956069 0.531992 0.195136 0.288213 1.080005 0.403178 0.327435 0.601585 0.419989 0.803862 0.624187 0.121109 -0.032458 1.233677 1.888075 0.416680 0.921255 -0.123147 1.100991 0.523132 1.866156 1.580633 1.521367 0.834357 0.017950 1.945026 1.112936 0.074866 0.578255 1.851390 0.917212 0.470515 1.494667 1.926605 0.420451 1.685173 1.321757 0.252699 0.908983 0.451996 1.280635 1.347889 1.101279 0.819891 0.717237 1.824992 0.064816 1.741467 0.171609 0.367474 1.450054 1.791245 0.070692 1.882472 0.030173 1.297571 1.480154 1.019678 0.718667 0.009196 0.641561 1.714326 1.179383 0.407542 1.176762 0.501786 1.884444 1.476017 1.294272 0.449015 0.628767 1.217169 0.537140 1.715118 1.505923 0.199813 1.524782 1.165141 1.676667 1.223004 0.016727 0.463878 1.136164 -0.053033 -0.084847 1.208615 1.445901 1.497341 0.161310 1.250596 0.942847 0.829403 0.387769 0.719178 1.738210 0.958532 0.472944 0.434584 0.253559 0.806841 0.948416 1.626398 1.745251 1.181118 0.900461 0.328407 0.004865 0.656956 1.561263 0.493976 0.215685 1.621837 0.977926 0.157229 0.368698 0.411012 0.533672 1.014733 0.265047 1.919729 1.249631 0.505841 0.810354 0.808424 1.184479 0.057215 0.275118 1.014035 1.475267 0.761434 1.193820 1.598491 0.134348 1.906886 0.063865 0.360892 1.182738 1.769838 0.652317 0.819564 0.835923 0.873375 0.958236 1.235262 -0.217562 0.548985 0.580422 0.773421 0.815778 0.094611 0.051274 0.456619 1.003721 0.560851 1.398235 1.328115 1.445608 1.526814 0.276018 1.944863 1.629687 0.184749 1.510383 0.270380 1.027430 1.256674 0.015870 0.564502 0.718165 1.794438 1.735884 0.904383 1.655901 1.675424 0.066250 1.899808 0.176362 1.550287 1.717784 0.905738 1.345949 1.001299 1.577679 0.550037 1.204039 1.754941 0.899017 0.959777 1.948798 0.199359 1.227196 1.454662 0.390714 1.580219 0.079875 1.186840 0.105451 0.922283 1.889599 1.204774 0.367870 0.720431 1.167140 1.635057 1.070144 -0.105934 0.316941 1.460835 1.680478 0.253545 1.791164 1.507054 0.456342 0.357901 1.697439 0.953658 0.592291 1.033133 1.478020 1.576280 1.358444 0.415789 -0.015554 1.241819 0.088719 1.636832 1.709484 0.595426 1.748375 1.690569 1.694795 1.541541 0.654394 0.467730 0.368448 1.418385 1.025035 0.300805 -0.128955 1.867573)
      )

;;; 1024 prime --------------------------------------------------------------------------------
#(1024 70.140 #(0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1)
       )

;;; 2048 prime --------------------------------------------------------------------------------
#(2048 102.619 #(0 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1)
       )
     )
  )


;;; ---------------------------------------- even-numbered harmonics (and fundamental) ----------------------------------------

(define neven-min-peak-phases (vector 

#(1 1.0 #(0)
    )

#(2 1.7601724863052 #(0 0)
    )

;;; 3 even --------------------------------------------------------------------------------
#(3 2.2325525283813 #(0 0 0)
    2.0235652605711 #(0 33/64 63/128)

    2.0214650630951 #(0.0 0.52414411306381 0.48787820339203)
    2.021465 #(0.000000 0.475854 0.512123)
    2.021465 #(0.000000 0.524145 0.487877)
    2.021465 #(0.000000 1.475854 1.512123) ; etc
    )

;;; 4 even --------------------------------------------------------------------------------
#(4 2.8359191417694 #(0 0 0 0)
    2.450505601523 #(0 3/16 21/32 15/32)

    ;2.434727537119 #(0 37 52 46) / 31

    2.4311048984528 #(0.000 0.191 0.672 0.479)
    2.4311048984528 #(0.000 0.809 0.328 0.521)

    ;; (optit :even 4 1/4 (expt 2 -100) 2.8359191417694 #(0 0 0 0))
    2.4308773660653 #(0.0 -1.907463741733863571425899863243103027344E-1 -6.709215487223971763341978657990694046021E-1 -4.783757035623090736464746441924944519997E-1)

    ;; (optit :even 4 1/4 (expt 2 -100) 2.450505601523 #(0 3/16 21/32 15/32))
    2.430877366065 #(0.0 1.907463741737958073940717440564185380936E-1 6.709215487230322239042834553401917219162E-1 4.783757035631506226991405128501355648041E-1)
    2.4305741786957 #(0.0 0.19146482345276 0.67236139177392 0.47990912646831)
    )

;;; 5 even --------------------------------------------------------------------------------
#(5 2.816308259964 #(0 1 0 0 0)

    2.6048328876495 #(0.0 1.7889379262924 0.49464252591133 0.018512051552534 0.013387856073678)

    2.604848 #(0.000000 0.211049 1.505353 1.981536 -0.013355)
    )

;;; 6 even --------------------------------------------------------------------------------
#(6 2.9795869831363 #(0 0 1 0 0 0)
    2.9795892238617 #(0 1 0 1 1 1)

    2.8369779013614 #(0.0 0.17925976781335 1.4035822186281 0.79344665247706 0.91203230191116 1.0958477007498)

    2.836991 #(0.000000 0.178390 1.402472 0.792230 0.912414 1.093877)
    2.836980 #(0.000000 1.821818 0.597785 1.208038 1.087532 0.906567)
    2.836978 #(0.000000 1.178373 0.402442 1.792189 1.912334 0.093818)
    2.836972 #(0.000000 1.178483 0.402570 -0.207680 -0.087726 0.094035)
    2.836966 #(0.000000 0.821717 1.597697 0.207985 0.087685 -0.093549)
    2.836953 #(0.000000 0.821609 1.597559 0.207843 0.087745 -0.093780)
    )

;;; 7 even --------------------------------------------------------------------------------
#(7 3.4936672673663 #(0 0 0 0 1 0 0)
    3.3825581073761 #(0 0 0 0 0 1 0)

    3.0470769405365 #(0.0 0.503662109375 0.87483215332031 1.0009307861328 1.2656555175781 0.71012878417969 0.30850219726562)
    3.0469672679901 #(0.0 0.50373814372209 0.87540721456314 1.0012873875657 1.2663739438299 0.71078327011007 0.30959991380794)
    3.046965 #(0.000000 0.503616 0.874674 1.000689 1.265332 0.709676 0.308046)
    )

;;; 8 even --------------------------------------------------------------------------------
#(8 3.7968969947382 #(0 0 1 1 0 0 0 0)
    3.7706393073421 #(0 1 0 1 1 0 0 0)
    3.611234664917 #(0 0 0 0 0 1 0 0)

    3.197691 #(0.000000 1.463442 0.984712 1.413077 0.862890 0.889575 1.684691 1.613214)
    3.197689 #(0.000000 0.536983 1.016250 0.588185 1.138902 1.112562 0.318083 0.389844)
    3.197673 #(0.000000 0.463394 -0.015494 0.412641 1.862274 -0.111008 0.683799 0.612199)
    3.197643 #(0.000000 1.536907 0.016088 1.587997 0.138641 0.112256 1.317694 1.389405)
    3.197539 #(0.000000 1.536753 0.015811 1.587753 0.138248 0.111716 1.317048 1.388715)
    )

;;; 9 even --------------------------------------------------------------------------------
#(9 4.1871630323114 #(0 1 1 0 0 0 0 1 0)
    4.1397546805979 #(0 0 1 0 0 0 1 1 1)
    4.0601739883423 #(0 0 0 0 0 0 1 1 0)

    3.454235 #(0.000000 1.380130 1.542684 1.103203 1.094600 0.755189 1.642794 1.504783 0.092364)
    3.454343 #(0.000000 0.380149 0.542653 0.103243 0.094157 1.755278 0.642603 0.504207 1.092117)
    3.454167 #(0.000000 1.619814 1.457133 1.896576 1.905245 0.244460 1.356830 1.494866 0.907164)
    3.454104 #(0.000000 1.619789 1.457225 1.896592 1.905347 0.244468 1.356940 1.495046 0.907280)
    3.453978 #(0.000000 1.619848 1.457320 1.896841 1.905503 0.244896 1.357384 1.495389 0.907798)
    )

;;; 10 even --------------------------------------------------------------------------------
#(10 4.1456241150012 #(0 0 0 1 1 0 0 0 0 0)
     4.0054845809937 #(0 1 1 0 0 0 0 0 1 0)

     3.559069 #(0.000000 0.728493 1.283356 1.458356 0.068046 1.297046 -0.008724 1.763762 1.458102 1.082546)
     3.559031 #(0.000000 1.271816 0.716134 0.541742 -0.068143 0.702758 0.008941 0.237259 0.543599 0.918279)
     3.558934 #(0.000000 0.270311 1.713387 1.540231 0.930533 1.700561 1.006089 1.239216 1.544459 1.919820)
     3.558711 #(0.000000 0.271020 1.715408 1.541006 0.931409 1.702058 1.007613 1.237445 1.543048 1.918285)
     )

;;; 11 even --------------------------------------------------------------------------------
#(11 4.2814919726737 #(0 1 1 1 0 1 1 0 1 1 1)
     4.8058149616573 #(0 0 0 1 0 1 0 0 0 0 0)
     4.2754249521261 #(0 1 0 1 0 0 1 1 1 1 1)
     4.2368197441101 #(0 0 1 1 0 1 1 1 0 0 0)

     3.656997 #(0.000000 0.364553 0.246524 0.545081 1.820586 -0.010486 0.065265 0.895857 0.689390 0.398119 1.238723)
     3.656853 #(0.000000 0.636042 0.753996 0.455733 1.180490 1.011649 0.936897 0.106845 0.312362 0.605377 1.764604)
     3.656814 #(0.000000 1.363823 1.245209 1.543687 0.818338 0.986715 1.061848 1.892251 1.683956 1.393470 0.233084)
     3.656676 #(0.000000 1.635670 1.752596 1.453762 0.177717 0.008296 -0.065661 1.103599 1.306278 1.601279 0.759437)
     3.656141 #(0.000000 1.635206 1.752773 1.453484 0.177816 0.008586 -0.066147 1.102294 1.308244 1.599463 0.758738)
     )

;;; 12 even --------------------------------------------------------------------------------
#(12 4.5077774785482 #(0 1 0 1 1 0 1 1 1 0 0 0)
     4.4722682088655 #(0 1 0 0 1 0 0 0 0 1 1 1)
     4.4100483425078 #(0 0 0 1 1 0 1 0 0 0 0 0)

     3.787770 #(0.000000 1.448638 0.653979 0.460567 1.750296 1.187409 1.823828 0.621465 0.835166 0.896814 0.649295 0.954712)
     3.787607 #(0.000000 1.552098 0.349619 0.543969 1.255255 1.818801 1.184427 0.387699 0.175349 0.115468 0.364328 0.059990)
     3.787594 #(0.000000 0.551763 1.347551 1.541126 0.252553 0.815620 0.180247 1.383525 1.170726 1.109400 1.357991 1.052935)
     3.786929 #(0.000000 0.551301 1.345490 1.538545 0.249324 0.811835 0.175379 1.377915 1.164645 1.102028 1.349918 1.044104)
     )

;;; 13 even --------------------------------------------------------------------------------
#(13 4.7678911684727 #(0 1 1 0 0 1 0 1 0 0 0 0 0)
     4.4552875568415 #(0 1 0 0 1 1 0 1 0 1 1 1 1)
     4.4076361656189 #(0 0 1 0 1 1 0 0 1 1 1 1 1)

     3.973518 #(0.000000 1.227848 0.569459 0.032525 1.602849 0.995992 1.561449 0.851502 1.005100 0.700156 1.033637 1.225072 1.740227)
     3.973285 #(0.000000 0.221343 1.559694 1.013474 0.580564 -0.035047 0.522724 -0.190833 -0.044249 1.645456 -0.025041 0.160741 0.667019)
     3.973148 #(0.000000 0.225623 1.564256 1.022022 0.590378 -0.019884 0.539658 -0.171656 -0.022033 1.670109 0.001495 0.190555 0.699291)
     3.973041 #(0.000000 0.226214 1.565751 1.024299 0.592784 -0.015292 0.545848 -0.164098 -0.014254 1.677783 0.010954 0.201582 0.710821)
     3.972554 #(0.000000 0.227025 1.566229 1.025033 0.594027 -0.014872 0.545046 -0.165560 -0.014836 1.678196 0.010096 0.200561 0.709954)
     )

;;; 14 even --------------------------------------------------------------------------------
#(14 4.6162051765776 #(0 0 1 0 1 0 0 1 1 0 0 0 0 0)
     4.5770673751831 #(0 1 1 0 0 1 1 1 1 1 1 0 1 0)

     4.097747 #(0.000000 0.927497 0.986240 1.222647 1.417439 1.485272 1.245695 0.840056 0.775783 1.393795 0.027626 0.815063 1.945062 1.449403)
     4.096703 #(0.000000 0.927014 0.985352 1.221418 1.415761 1.483290 1.243140 0.836933 0.772657 1.390170 0.023348 0.810693 1.940171 1.444293)
     )

;;; 15 even --------------------------------------------------------------------------------
#(15 4.949674522378 #(0 1 1 1 0 0 0 0 1 0 0 0 1 0 0)
     4.8773546682689 #(0 1 1 0 0 0 1 1 0 1 0 0 0 0 0)
     4.7838921546936 #(0 0 0 0 0 1 1 1 1 0 1 1 1 0 1)

     4.193545 #(0.000000 1.673990 1.704095 0.184742 0.312157 1.759699 0.661838 0.338558 1.336129 0.060082 0.592895 0.470075 0.323799 1.690560 1.851587)
     4.193539 #(0.000000 1.674972 1.705674 0.187574 0.315997 1.764079 0.667192 0.344813 1.343115 0.068186 0.601740 0.479341 0.334140 1.702389 1.863580)
     4.192089 #(0.000000 1.673474 1.702683 0.182852 0.310553 1.756894 0.658556 0.335052 1.332116 0.055950 0.587971 0.464438 0.317829 1.684035 1.844319)
     )

;;; 16 even --------------------------------------------------------------------------------
#(16 5.1845584915919 #(0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0)
     5.1708735549117 #(0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1)
     5.1363370276686 #(0 0 0 0 0 0 0 0 1 0 1 1 0 0 0 1)
     5.0737318992615 #(0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0)

     4.326467 #(0.000000 0.954646 0.857741 0.564427 0.380619 -0.030405 0.027220 0.443651 0.347240 0.290827 1.057423 1.274647 0.193509 1.337335 0.715554 1.355809)
     4.326323 #(0.000000 0.953094 0.856111 0.562335 0.378555 -0.035716 0.021343 0.437774 0.341052 0.283988 1.049334 1.266917 0.184364 1.326298 0.704383 1.343207)
     4.325044 #(0.000000 0.953571 0.856165 0.561119 0.376819 -0.035768 0.021241 0.436352 0.339200 0.281830 1.047126 1.263828 0.181703 1.324018 0.701028 1.340302)
     )

;;; 17 even --------------------------------------------------------------------------------
#(17 5.2972948285536 #(0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1)
     5.2612584721964 #(0 1 0 0 1 0 1 0 1 1 1 0 0 1 1 1 1)
     5.2483402924188 #(0 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1)
     5.2332563400269 #(0 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0)

     4.464096 #(0.000000 1.478399 1.021179 1.293532 1.222041 1.188322 1.479616 1.284032 0.091138 1.349289 0.401522 0.364537 -0.044880 1.268488 1.386805 0.039323 0.607489)
     4.463016 #(0.000000 1.478182 1.023133 1.293051 1.222719 1.187462 1.479990 1.285327 0.088371 1.348357 0.403976 0.365587 -0.044469 1.267681 1.387786 0.039745 0.610112)
     )

;;; 18 even --------------------------------------------------------------------------------
#(18 5.4135673169319 #(0 0 0 1 0 1 1 1 0 1 1 0 0 0 0 1 0 0)
     5.3738845938103 #(0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 0 1)
     5.3310880661011 #(0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 0)

     4.580164 #(0.000000 0.088065 1.683756 0.348660 0.864971 1.361146 1.224199 0.124257 0.574705 0.001082 1.664767 0.723022 1.280851 0.880081 1.007566 1.375306 1.095774 0.962641)
     4.570825 #(0.000000 1.014207 0.576401 1.182722 1.623809 0.037366 -0.106276 0.719945 1.088940 0.493703 0.074031 1.074477 1.595481 1.109120 1.197779 1.498819 1.161324 0.997523)
     4.569421 #(0.000000 1.011793 0.580064 1.185332 1.624771 0.036509 -0.103084 0.721775 1.089226 0.493658 0.073953 1.074825 1.595710 1.108207 1.196849 1.497424 1.163445 0.995437)
     )

;;; 19 even --------------------------------------------------------------------------------
#(19 5.4721938266519 #(0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0)
     5.4619059562683 #(0 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0)

     4.743457 #(0.000000 1.217893 0.656820 0.434930 1.318439 1.234525 0.095173 -0.185206 -0.086731 0.407144 1.121209 1.131725 0.654678 0.822361 0.535204 1.154897 0.288114 0.908839 0.830917)
     4.741489 #(0.000000 1.217162 0.660633 0.437661 1.320878 1.235636 0.094939 -0.184508 -0.090396 0.415156 1.119340 1.141612 0.652398 0.817014 0.525642 1.150459 0.295913 0.906911 0.831168)
     )

;;; 20 even --------------------------------------------------------------------------------
#(20 5.670516977407 #(0 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1 0 0 0 0)
     5.5380347270104 #(0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0)
     5.5266017913818 #(0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0)

     4.839482 #(0.000000 0.882739 0.097549 0.018330 1.302731 0.272028 1.407538 1.702479 0.580972 1.045015 0.992304 1.669564 0.673981 0.282219 0.289947 0.363499 1.033218 0.803741 0.771035 0.508087)
     )

;;; 21 even --------------------------------------------------------------------------------
#(21 5.7292241651627 #(0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0)
     5.6852540969849 #(0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1)
     5.6849967470046 #(0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0)

     4.919735 #(0.000000 -0.021966 1.377831 1.499470 -0.139205 1.937761 0.320320 0.217546 0.069290 0.938854 1.308616 0.123782 0.469963 1.818882 1.581666 1.414927 0.056553 1.301602 0.788305 1.336052 0.607478)
     )

;;; 22 even --------------------------------------------------------------------------------
#(22 5.9318449080552 #(0 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 1 1)
     5.9259635937391 #(0 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 0 0)
     5.8572781078687 #(0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0)
     
     5.055233 #(0.000000 -1.550778 1.843415 0.900724 0.955590 0.677531 1.390686 0.133831 1.229871 1.016503 1.245622 1.546957 -1.869615 1.414871 -0.060378 -0.077148 1.210164 1.132173 0.909114 1.325478 1.285781 0.509617)
     )

;;; 23 even --------------------------------------------------------------------------------
#(23 5.9574251174927 #(0 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0)
     5.9548940658569 #(0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1)
     5.9208135892745 #(0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0)

     5.147900 #(0.000000 0.493561 0.617878 0.386087 -0.215675 1.136922 0.632292 0.891205 1.398746 0.878537 0.676611 0.945565 0.610792 -0.182076 0.354229 1.383426 1.649635 0.414770 0.152656 0.561509 0.267633 1.102796 1.466348)
     )

;;; 24 even --------------------------------------------------------------------------------
#(24 6.119236946106 #(0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 1 0)
     6.0757751464844 #(0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1)
     6.0318420391191 #(0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 0 0 1)
     6.0318420391191 #(0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0)

     5.253162 #(0.000000 0.045084 0.641921 -0.205904 0.266767 1.228115 0.912709 0.214922 1.487762 1.357882 0.864877 0.404420 0.601935 0.594931 0.069420 1.052347 1.659787 1.624121 0.035857 0.245103 1.406872 0.042697 -0.053953 0.167577)
     )

;;; 25 even --------------------------------------------------------------------------------
#(25 6.2507610321045 #(0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0)
     6.2422542572021 #(0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 1)
     6.152729668872 #(0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0)
     6.1513186981755 #(0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1)

     5.403228 #(0.000000 0.045060 1.794212 1.406802 1.249045 0.257853 0.430644 -0.020674 0.209605 1.159346 1.742584 0.244624 1.006989 0.948352 0.613996 0.229169 0.745474 0.773295 0.271006 1.529917 0.384835 1.822065 0.327936 0.153008 0.689262)
     )

;;; 26 even --------------------------------------------------------------------------------
#(26 6.3358421325684 #(0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 1 0)
     6.3140621185303 #(0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 1)
     6.2921685546228 #(0 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1)
     6.2921685546205 #(0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0)

     5.452331 #(0.000000 0.051327 0.204117 1.807782 0.408597 -0.021081 0.115796 0.407761 0.824888 0.626144 0.637118 0.067354 0.844059 0.574978 -0.127497 -0.091341 1.702516 0.546084 0.986055 1.260143 0.631019 1.781357 1.305578 1.812413 0.666374 0.989339)
     )

;;; 27 even --------------------------------------------------------------------------------
#(27 6.4054713249207 #(0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 0)
     6.243681443715 #(0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1)
     6.2436904245852 #(0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1)

     5.620374 #(0.000000 -0.021456 0.516604 0.372410 0.864531 1.336703 -0.209149 1.689313 0.033950 1.772624 0.571345 1.616802 0.355488 1.092886 1.391271 1.240098 1.111612 0.854249 0.888716 0.157123 -0.311986 1.252460 1.082038 -0.272435 1.564985 0.964546 1.600742)
     )

;;; 28 even --------------------------------------------------------------------------------
#(28 6.6246975836201 #(0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1)
     6.6145820617676 #(0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0)
     6.5361909866333 #(0 0 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1)

     5.731679 #(0.000000 1.447589 1.395977 0.797533 1.295906 1.462640 1.534875 1.774902 1.013697 0.705377 0.626264 1.242696 1.362454 0.181714 0.805604 1.271981 0.570662 1.779635 -0.124462 1.352040 -0.225912 1.764222 0.153642 1.298969 0.773437 0.201599 0.803480 0.102660)
     )

;;; 29 even --------------------------------------------------------------------------------
#(29 6.7166719436646 #(0 0 1 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 1 1 0 0)
     6.7148699760437 #(0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 0 0)
     6.6767044067383 #(0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1)

     5.766338 #(0.000000 1.750571 1.825931 1.106253 0.681108 0.654013 0.530242 0.078216 0.174544 1.354195 1.454712 1.045782 1.722411 1.607453 0.347380 0.849326 0.377709 1.136286 1.004911 0.970793 0.410809 0.919085 1.010160 0.193230 0.966878 0.662369 1.289507 1.533180 0.429508)
     )

;;; 30 even --------------------------------------------------------------------------------
#(30 6.8207087516785 #(0 0 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0)
     6.8207082748413 #(0 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1)
     6.799307346344 #(0 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 0)
     6.6998701095581 #(0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 0)

     5.906955 #(0.000000 0.906624 1.374273 1.276597 -0.178673 0.094922 0.333601 0.129339 0.400307 0.946356 1.401096 0.557587 0.654474 1.274947 0.061009 -0.048005 1.903626 1.753056 1.439902 1.944968 1.607217 1.115332 0.419220 1.617499 1.734563 1.091117 0.095163 0.781775 -0.001559 1.852411)
     )

;;; 31 even --------------------------------------------------------------------------------
#(31 6.9357690811157 #(0 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1)
     6.9057178497314 #(0 0 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1)
     6.9018726284795 #(0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0)
     6.8986349105835 #(0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0)
     6.8660564422607 #(0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0)

     5.987789 #(0.000000 1.294084 1.380328 1.151198 1.131917 1.032100 1.467500 1.317593 1.561230 1.149337 1.426512 0.310391 0.093956 -0.092069 1.618651 0.385482 1.276093 0.768907 0.092705 1.372235 0.935730 0.030657 0.353616 1.817773 0.372502 0.700675 1.341184 1.537494 1.331726 0.302069 0.818207)
     )

;;; 32 even --------------------------------------------------------------------------------
#(32 7.1377140468569 #(0 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 1 0 0)
     7.0221180915833 #(0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1)
     7.011866569519 #(0 0 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 1 1)
     7.003 #(0 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1)
     6.9974670410156 #(0 0 0 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 0)

     6.061091 #(0.000000 0.284769 1.824838 0.360868 1.114185 0.962149 1.153553 1.836957 0.183317 1.504519 0.431670 1.106470 0.465083 1.359049 1.532974 1.672623 0.833072 1.851412 -0.259099 1.829526 0.240313 0.782734 0.067562 1.704922 0.670838 0.000337 1.835105 1.184487 1.464400 1.660678 0.971147 1.137597)
     )

;;; 33 even --------------------------------------------------------------------------------
#(33 7.1199560165405 #(0 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 0 0 0 0 1)
     7.0745658874512 #(0 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0)
     7.0716042518616 #(0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1)
     7.0670447349548 #(0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0)
     6.978609085083  #(0 0 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0)

     6.162617 #(0.000000 -0.095863 -0.402980 1.394421 -0.306134 0.366840 0.337119 0.377845 0.129322 0.155850 1.349812 0.235845 0.252319 0.242909 1.431344 1.664418 1.236043 1.670315 1.653641 0.461681 0.695631 0.916345 0.353418 1.885954 1.309177 0.582371 1.382992 1.788982 0.399357 0.760664 0.154447 0.882692 0.073082)
     )

;;; 34 even --------------------------------------------------------------------------------
#(34 7.3321795463562 #(0 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 1 0 0 1 0)
     7.3251795768738 #(0 0 1 1 0 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 0 0 0)
     7.3184022903442 #(0 0 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0)
     7.314661026001 #(0 1 1 1 1 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1)
     7.3119759559631 #(0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0)
     7.2703185081482 #(0 0 1 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0)
     7.2649097442627 #(0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 0)
     7.2615523338318 #(0 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0)

     6.222816 #(0.000000 -0.031974 0.094234 0.502100 0.850042 0.574691 0.752336 1.914959 -0.024174 0.146232 0.295078 1.383128 -0.007584 0.943763 1.235227 0.413741 0.587141 -0.053979 1.839683 0.252526 0.156123 0.682869 0.409598 -0.127649 0.823619 0.505563 1.228553 1.452425 1.154757 0.224780 1.122198 1.589227 1.075252 0.529430)
     )

;;; 35 even --------------------------------------------------------------------------------
#(35 7.3807096481323 #(0 0 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 0 1 0 0)
     7.3793916702271 #(0 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 0)
     7.3590030670166 #(0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 0)
     7.3509883880615 #(0 1 0 1 1 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0)
     7.3254580497742 #(0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 0 1 1 1 0 0 0)
     7.3159041404724 #(0 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 0 0 0)
     7.3109955787659 #(0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0)
     7.2921919822693 #(0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0)

     6.362258 #(0.000000 -0.109595 1.553671 0.219728 0.238496 1.170971 0.131935 0.808676 1.471325 1.403853 0.916637 1.560710 -0.099827 1.196395 0.221158 1.202313 0.775632 0.876517 1.782554 1.124579 1.420710 0.952275 0.641256 1.819844 1.425015 -0.516862 1.352551 1.568353 1.482981 0.524776 0.577204 0.865347 -0.128894 -0.102429 0.426519)
     )

;;; 36 even --------------------------------------------------------------------------------
#(36 7.5039777755737 #(0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0)
     7.497097492218 #(0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0)
     7.4732356071472 #(0 1 1 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0)
     7.4679698944092 #(0 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 0)
     7.466917514801 #(0 0 0 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 0 0 0 0 0 0)
     7.4267778396606 #(0 0 0 1 0 1 1 1 1 0 1 0 0 1 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 0)
     7.4214091300964 #(0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0)
     7.3326554298401 #(0 0 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0)

     6.432117 #(0.000000 0.004340 0.086403 1.388728 0.898065 1.458617 0.131985 1.657435 1.521273 1.472417 0.951218 1.324245 1.241442 1.395549 0.150266 1.064974 0.650640 1.427046 1.086279 0.098701 0.328772 1.795832 1.461165 0.857821 1.693245 1.032679 1.245848 0.174782 -0.135078 0.155045 -0.013817 0.388292 0.719587 1.603641 0.575715 0.836424)
     )

;;; 37 even --------------------------------------------------------------------------------
#(37 7.6800961494446 #(0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0)
     7.6781373023987 #(0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0)
     7.6548581123352 #(0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0)
     7.6323590278625 #(0 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 0 0)
     7.6028599739075 #(0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 0 0)
     7.5926213264465 #(0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 0)
     7.5687103271484 #(0 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0)
     7.4919209480286 #(0 1 1 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0)

     6.580507 #(0.000000 0.011508 1.018447 0.697436 0.133090 0.853448 0.791291 0.128627 1.849542 0.687289 0.248503 0.205552 0.157901 1.585379 0.006297 0.199246 1.745097 -0.362216 0.556733 0.874920 0.785234 0.017492 -0.120441 0.200275 1.347604 1.018854 0.159701 0.559284 0.648896 0.970578 0.725605 1.094666 1.685944 0.610110 1.757671 0.445878 1.382502)
     )

;;; 38 even --------------------------------------------------------------------------------
#(38 7.7734541893005 #(0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0)
     7.7677249908447 #(0 0 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0)
     7.7656890155417 #(0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0)
     7.7583861351013 #(0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0)
     7.735631942749 #(0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)
     7.669114112854 #(0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0)

     6.536590 #(0.000000 -0.020563 1.377251 1.769036 0.243537 1.765876 1.779834 1.045673 1.286350 0.293614 0.321305 1.723518 1.560003 0.401205 0.333918 -0.059485 0.232219 0.960903 1.594163 1.401434 0.649608 0.412099 1.329747 0.099455 1.939824 0.267997 0.403580 1.515217 0.579512 0.002234 0.262847 1.800156 0.419089 1.615975 1.110793 1.305676 1.421012 1.714827)
     )

;;; 39 even --------------------------------------------------------------------------------
#(39 8.060715675354 #(0 1 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1)
     8.0530862808228 #(0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1)
     8.0486888885498 #(0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0)
     8.0062685830938 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 0)

     6.683157 #(0.000000 1.091390 0.284404 0.240879 1.660743 1.656550 0.223587 1.552502 0.232972 0.325977 1.767287 0.511127 0.573904 0.685387 0.354731 1.006014 0.648089 0.445081 1.696394 0.327980 -0.210151 0.338005 -0.052572 -0.119111 0.551717 1.087945 0.035621 1.385382 0.802270 1.342811 0.005749 0.410111 0.489512 1.361009 1.309724 1.490142 1.368577 0.636471 0.518214)
     )

;;; 40 even --------------------------------------------------------------------------------
#(40 8.1045722961426 #(0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0)
     8.0884717473459 #(0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 1)
     8.0304555793911 #(0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 0 1)

     6.748142 #(0.000000 0.029455 0.022065 0.136105 1.638522 1.203180 0.744941 -0.148784 0.506171 0.560051 -0.084723 -0.078289 0.149301 0.575133 1.046850 1.733499 1.932780 1.304846 -0.055855 1.484587 1.130478 0.869457 1.564935 1.665772 1.478237 0.851162 0.123617 0.568797 1.544770 0.060395 1.377474 0.739849 -0.238843 1.303906 1.521850 1.552033 0.224167 1.493979 0.103832 0.387098)
     )

;;; 41 even --------------------------------------------------------------------------------
#(41 8.3439186011904 #(0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 1)
     8.2169809341431 #(0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0)

     6.881035 #(0.000000 0.133290 0.436430 -0.019956 0.597994 -0.299445 0.298044 -0.291816 -0.125561 1.379945 1.227240 1.012471 0.995085 0.165521 0.059156 -0.315277 -0.410140 1.321719 -0.217071 0.006502 1.718169 0.636248 0.520158 0.977079 1.417462 -0.764436 1.377242 0.286309 1.475385 1.360726 0.551504 -0.329940 1.190956 0.377718 1.221012 1.703028 0.053941 0.664915 1.563928 1.320457 0.168607)
     )

;;; 42 even --------------------------------------------------------------------------------
#(42 8.3791161021838 #(0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1)
     8.3605623245239 #(0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1)
     
     6.941481 #(0.000000 -0.007293 1.286795 1.752349 -0.276621 1.210682 0.997503 0.480778 0.607692 1.419140 -0.000887 0.317063 0.225619 -1.792990 -0.085405 1.621718 1.141369 0.612500 1.711137 0.371822 0.494518 1.158070 0.720118 -0.061260 0.895705 0.558493 0.565336 0.673764 0.965927 1.131140 0.011389 1.067604 1.758075 0.687249 0.164819 0.032158 0.192333 0.816334 0.404498 1.292703 0.160108 0.486834)
     )

;;; 43 even --------------------------------------------------------------------------------
#(43 8.4720001220703 #(0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 1 0)
     8.3471550144283 #(0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0)

     7.055197 #(0.000000 0.047763 1.657931 1.619393 1.901312 1.535197 1.519084 0.139389 -0.012074 1.734976 0.124057 1.726677 0.967925 0.859090 0.315172 0.782383 0.749080 1.794616 -0.192964 1.214822 1.594002 0.299675 1.830679 1.396713 1.089896 0.461626 0.318824 0.888695 1.307168 1.600142 0.874003 1.625797 0.872538 1.803252 0.868969 0.618677 0.932144 0.968270 1.700058 0.258149 0.614848 0.031586 0.805044)
     )

;;; 44 even --------------------------------------------------------------------------------
#(44 8.6881771087646 #(0 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 1 0)
     8.4271850585938 #(0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 1 1)

     7.048255 #(0.000000 -0.024272 1.042039 1.706381 0.915231 0.667566 0.791468 1.060500 0.486474 0.357952 1.448848 0.555099 0.559674 0.047957 0.101663 0.263196 0.561105 1.754886 1.445748 0.607834 0.094941 0.549126 0.219045 0.643754 0.108792 0.622710 0.657739 1.176141 0.892775 1.899443 0.047927 1.097541 1.395320 1.432930 0.524754 1.590031 -0.111160 0.804186 0.328664 0.621384 1.470620 1.417525 -0.298999 1.020701)
     )

;;; 45 even --------------------------------------------------------------------------------
#(45 8.7060899734497 #(0 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0)
     8.6457691192627 #(0 0 0 1 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0)
     8.6353975051189 #(0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1)

     7.165216 #(0.000000 0.100769 0.427512 0.242955 0.443088 -0.380155 1.940929 -0.101098 -0.133968 -0.026473 1.678192 1.774836 0.508005 0.350465 0.553068 1.094302 0.286670 -1.617200 0.541014 0.212204 1.154970 1.344936 0.804485 1.614258 1.391670 0.188798 0.475817 0.610176 0.585642 -0.044233 1.516307 0.921356 1.091747 0.246161 0.592046 1.532410 0.320765 0.050475 1.141805 0.866052 0.300507 0.986581 -0.103223 1.338567 0.196051)
     )

;;; 46 even --------------------------------------------------------------------------------
#(46 8.9638475105267 #(0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1)
     8.7939519711145 #(0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0)

     7.276006 #(0.000000 -0.054506 1.032755 -0.130142 -0.261502 1.224902 0.252129 0.556107 0.758621 1.480820 -0.142360 1.184737 0.014000 1.776705 0.882036 1.883695 0.222183 0.298085 0.448405 1.172485 0.678362 1.341204 0.081280 -0.085381 0.763100 -0.029414 -0.367000 0.048240 1.040410 1.413704 0.227444 -0.058776 -0.204130 1.202166 1.632528 1.205475 1.219937 1.182203 -0.061521 1.269256 0.937830 0.491219 -0.180909 0.028085 1.489097 0.059386)
     )

;;; 47 even --------------------------------------------------------------------------------
#(47 8.8732557296753 #(0 1 0 0 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 1 0 0 1)
     8.8477687835693 #(0 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0)
     8.7835607528687 #(0 0 0 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1)

     7.292551 #(0.000000 -0.062265 1.442422 1.057676 1.927078 0.605872 0.092606 0.058532 0.177290 1.141099 0.824596 0.143569 1.542821 0.439342 0.943358 1.070588 0.909454 0.332472 1.825929 1.744493 0.079522 0.781524 1.378798 1.290207 0.477850 0.651309 0.041772 0.753335 1.194909 0.871931 1.816269 1.466251 1.199198 1.733301 1.531356 -0.102896 0.905701 1.309802 1.098908 1.238880 1.394185 0.875551 1.145434 -0.145313 0.593458 0.073230 0.938656)
     )

;;; 48 even --------------------------------------------------------------------------------
#(48 9.12184715271 #(0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1)
     8.9965600967407 #(0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1)

     7.467012 #(0.000000 0.069929 1.073767 1.157560 0.848786 0.447865 -0.109411 0.924106 0.709020 1.667128 0.400525 1.405781 0.366296 1.104974 1.805206 0.694613 1.382888 1.018670 1.129325 1.206879 1.370290 -0.147428 1.776145 0.264024 0.500700 0.569229 1.484602 0.430120 0.102064 0.025408 1.541842 1.143651 1.439930 1.212974 0.833509 0.105181 1.297142 1.350673 1.647476 0.837272 1.240307 1.466426 1.752493 0.800990 1.352861 0.848426 0.296629 1.379693)
     )

;;; 49 even --------------------------------------------------------------------------------
#(49 9.2634744644165 #(0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1)
     9.1650037765503 #(0 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0)

     7.587683 #(0.000000 0.096595 0.645667 1.135921 1.031588 1.069025 0.693912 1.560514 1.241521 0.632851 1.822870 1.544149 0.043844 0.213736 1.418508 0.386868 0.115296 1.352635 1.572225 0.802598 0.454944 0.930522 -0.250846 1.748196 0.473469 0.478265 0.785012 -0.169764 1.197529 -0.046584 0.415795 1.390642 0.586833 0.903320 1.082993 1.248029 0.910495 0.958791 0.365488 -0.017952 0.787876 1.142701 1.113574 0.784855 1.054540 0.537996 0.678549 1.684563 0.309661)
     )

;;; 50 even --------------------------------------------------------------------------------
#(50 9.348 #(0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0) ; symmetric??
     9.1582123370176 #(0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1)

     7.622449 #(0.000000 -0.055836 1.338648 1.713378 -0.211863 0.907302 0.760703 0.562477 1.574216 0.215735 0.269725 1.604497 1.094357 0.684113 1.366238 -0.123750 -0.031123 0.316842 1.016062 1.195339 0.821177 0.467037 0.972559 1.419370 0.763789 0.532834 1.244054 1.543248 -0.555946 1.384927 0.504092 0.181820 0.932888 0.125223 0.461703 0.398546 1.562784 1.715901 1.178148 1.817278 1.706240 0.980648 1.849877 0.952934 -0.135301 1.103297 -0.482972 -0.250278 1.490763 -0.002635)
     )

;;; 51 even --------------------------------------------------------------------------------
#(51 9.5728101730347 #(0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0)
     9.3615226745605 #(0 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0)

     7.654813 #(0.000000 -0.064271 1.656435 0.786493 1.196447 -0.043002 1.617539 0.290347 1.476181 1.081593 1.041915 0.815566 1.259791 -0.312788 0.780031 0.626812 1.629478 -0.270316 -0.309245 0.867931 1.105752 1.326462 0.800159 0.829817 0.424799 0.633459 0.774977 0.865137 0.331890 1.072960 1.502102 1.064036 -0.108209 0.349657 1.324683 -0.205438 1.485828 1.228802 0.304302 1.427871 0.829980 -0.226741 1.475417 1.337814 1.407423 0.079752 0.546814 0.169620 0.127211 0.872636 1.436670)
     )

;;; 52 even --------------------------------------------------------------------------------
#(52 9.5426025390625 #(0 1 0 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 0 0 0)
     9.449512348335 #(0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1)

     7.786334 #(0.000000 0.084325 1.267858 1.229885 1.681831 0.171914 0.825889 -0.018597 0.636042 0.494157 1.633040 1.589128 0.246248 0.508832 1.592270 0.715253 1.330388 0.761285 1.221206 0.809893 0.693260 0.589433 0.494522 1.742877 1.689978 1.788368 1.853588 -0.075553 0.734725 1.822818 -0.034510 -0.125426 0.482247 1.704072 1.619951 1.736489 0.286147 0.226113 1.269324 0.952894 0.224234 1.358479 -0.175843 1.809713 0.960285 0.087678 0.438349 0.077375 -0.042622 0.856690 1.137598 0.409973)
     )

;;; 53 even --------------------------------------------------------------------------------
#(53 9.7638588738802 #(0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1)
     9.627 #(0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0)
     9.6159172058105 #(0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 1 0)

     7.750487 #(0.000000 0.036779 0.620619 1.389030 1.448590 0.206060 1.401187 0.716369 0.552235 0.039103 0.347305 1.846613 0.552018 1.491421 1.339207 1.372862 1.129023 1.023345 1.671571 0.563034 0.162746 0.439370 1.163228 -0.070535 0.315773 0.561792 1.174490 1.839925 1.161557 1.788132 0.000155 0.215127 1.156326 0.635275 1.204301 0.236777 -0.137602 1.267159 0.914139 0.933059 0.732878 0.757869 1.209147 1.287260 1.087065 1.355017 0.578394 1.465757 0.725442 0.562270 1.513798 1.240390 0.721272)
     )

;;; 54 even --------------------------------------------------------------------------------
#(54 9.7764141549279 #(0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1)
     9.748743057251 #(0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 0)
     9.5190944671631 #(0 1 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 1)

     7.845083 #(0.000000 0.061451 0.633202 0.842273 1.609750 1.150617 1.710229 0.507090 -0.042557 0.310551 0.314728 0.987790 1.351858 1.063896 1.713078 1.603814 0.132592 0.924440 -0.380633 0.855851 1.637781 0.813597 1.013698 0.861640 0.327742 0.192164 0.896540 1.734094 0.874167 -0.001625 0.106463 0.214754 1.657275 0.272925 1.907315 1.437104 1.086576 0.701261 0.411048 1.402011 1.872416 0.559924 1.401281 1.776842 1.632661 1.672063 -0.088862 1.645896 0.861803 0.137030 1.828399 0.307366 0.083970 1.711361)
     )

;;; 55 even --------------------------------------------------------------------------------
#(55 10.131931993478 #(0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1)
     9.9292899584938 #(0 0 0 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1)
     9.7848987579346 #(0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1)
     9.6719217300415 #(0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1)

     8.007493 #(0.000000 -0.082445 1.618141 -0.078016 1.593444 0.266646 1.131662 0.009824 0.312557 0.669491 0.123570 1.912862 0.119550 0.163006 0.717333 0.198196 0.549271 1.718976 -0.070954 0.388881 0.590527 1.427770 0.073706 -0.092363 0.072595 0.962271 -0.041551 1.729249 1.279168 0.530533 1.382019 1.228054 0.661084 1.498468 0.645646 0.497604 0.413549 0.155330 -0.215751 1.114225 -0.033785 0.233335 0.640733 0.943248 0.358082 1.156653 1.453976 1.101954 0.139182 -0.078164 0.239634 1.395432 0.754021 0.084780 0.400247)
     )

;;; 56 even --------------------------------------------------------------------------------
#(56 10.014793395996 #(0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0 0 1)
     9.9184818267822 #(0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1)
     9.7564358364052 #(0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 1)
     9.6809562784664 #(0 0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1)

     8.041971 #(0.000000 -0.110547 1.000387 0.393269 1.768240 1.134081 1.139760 -0.333937 1.166693 1.039491 1.739347 0.355662 0.815015 1.516703 1.042893 1.213313 1.224344 1.656415 1.639656 -0.140215 1.641079 1.720229 0.732304 0.850659 1.194855 0.394676 0.561706 1.362535 -0.131158 1.419755 -0.300929 1.098207 1.468144 1.408434 0.638259 1.302226 0.434342 1.516620 0.481167 0.321554 -0.061311 0.782692 0.639734 0.432015 -0.056888 1.743271 0.538285 0.463993 1.106551 1.868104 -0.156166 -0.290270 0.756896 1.180294 0.539030 1.537455)
     )

;;; 57 even --------------------------------------------------------------------------------
#(57 10.246812120784 #(0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0)
     10.116240908787 #(0 0 1 1 1 0 0 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0)
     9.9813938140869 #(0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1)
     9.8992366790771 #(0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 1)

     8.115556 #(0.000000 -0.075043 1.610513 1.588792 -0.170776 1.410390 0.275208 1.069379 1.371800 0.181265 1.657590 -0.077758 0.229315 0.078470 1.563227 1.586227 0.354412 0.375067 1.172857 0.141142 -0.042413 1.246976 0.055961 1.298145 1.090952 1.783171 1.784793 0.654005 0.745110 1.193159 1.408792 1.198439 1.355169 1.776507 1.395740 0.024552 0.492974 1.561172 1.258987 0.560174 0.554203 0.795710 0.209724 0.830031 0.114489 0.752091 -0.174804 1.576603 0.580903 1.295566 -0.060997 1.668522 1.588836 1.007467 0.444852 0.805939 -1.921939)
     )

;;; 58 even --------------------------------------------------------------------------------
#(58 10.486150288901 #(0 1 0 1 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1)
     10.185283647732 #(0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 1 0 1 0 1)
     10.040289878845 #(0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 0 1 0 1)
     9.8761510848999 #(0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 1)

     8.102746 #(0.000000 0.021804 0.347449 0.712574 0.904596 1.645925 0.230015 0.473992 0.104969 1.934740 1.209012 1.104800 1.062683 0.358409 0.785934 1.465266 1.235573 1.772411 0.072477 1.559281 1.754795 0.147077 0.219637 0.050078 1.441852 0.333339 0.672730 1.789640 1.230725 1.303568 1.622831 1.659814 0.995447 1.205094 1.295826 0.837873 0.521849 1.476121 0.531055 1.439237 1.534776 0.923559 1.866584 1.504388 0.402718 1.262304 0.589470 1.403389 1.379169 0.218840 1.535374 0.130494 0.618342 0.285582 1.711521 1.399310 1.463120 1.577451)
     )

;;; 59 even --------------------------------------------------------------------------------
#(59 10.306503751934 #(0 1 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1)
     10.305177937827 #(0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1 1)
     10.237511634827 #(0 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1 1)
     10.094394683838 #(0 1 1 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1)

     8.194538 #(0.000000 0.192440 1.064997 1.405447 0.666893 0.441718 0.460123 -0.029893 0.102290 1.233991 1.287456 0.262828 0.891341 1.622477 -0.078945 0.794492 1.676056 0.757298 1.625170 1.288224 1.021602 1.270621 0.622162 1.173256 0.639594 0.085293 0.804874 1.211161 -0.067577 0.210901 0.178378 0.446246 -0.092053 1.813463 1.120832 1.269392 -0.271084 1.861664 0.195222 0.087459 0.045547 0.257753 0.386709 0.151559 1.002452 0.352762 0.090741 1.494023 0.840240 1.424148 0.778422 -0.109268 1.896909 0.853535 0.284500 1.503148 1.606229 1.606587 0.287318)
     )

;;; 60 even --------------------------------------------------------------------------------
#(60 10.491376876831 #(0 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0)
     10.333255371943 #(0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0)

     8.312421 #(0.000000 0.016764 0.099999 0.395290 1.344482 1.502674 0.248570 0.971438 0.736859 1.561216 0.263938 1.242184 -0.428796 -0.122031 1.528486 0.190921 1.269506 0.099840 0.618839 0.286668 0.310580 0.121766 0.645000 0.953645 1.140529 0.456214 0.631806 0.922426 0.396932 1.354468 1.176819 0.515695 0.171198 0.662750 1.320434 0.506395 1.565445 0.874857 0.531897 0.782628 0.471079 -1.819575 1.656923 0.206815 0.413621 0.205859 1.749126 1.236787 1.333671 0.085487 1.468799 1.666444 0.266215 0.649751 0.639546 0.431656 1.171882 1.863798 1.376382 0.482890)
     )

;;; 61 even --------------------------------------------------------------------------------
#(61 10.587104797363 #(0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 0 1 1 0)
     10.557340621948 #(0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1)
     10.209 #(0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0)
     10.120587847566 #(0 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)

     8.356578 #(0.000000 1.258388 -0.273980 -0.167264 1.504713 1.208501 0.124173 -0.059546 1.610005 1.088297 0.680391 0.360906 0.165623 1.519422 0.956953 1.666336 0.199221 0.791003 1.473864 0.319528 0.484639 0.418988 0.782792 1.900626 0.044880 1.164846 0.062643 0.827370 0.559635 0.680751 0.247274 1.841430 1.412286 1.374525 0.019320 -0.231244 0.397684 0.189771 0.475789 1.250193 1.548114 0.142785 -0.183958 0.874110 0.114719 1.522786 1.358343 0.317810 1.068242 0.312937 0.723760 0.496866 1.190457 0.404208 1.582896 1.899729 0.212338 1.625022 1.735446 1.908050 -0.189996)
     )

;;; 62 even --------------------------------------------------------------------------------
#(62 10.800075218392 #(0 0 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0)
     10.501984943687 #(0 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 0 1 1)
     10.318392753601 #(0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 0 1 1)

     8.390962 #(0.000000 0.864131 -0.039302 0.501838 0.179590 0.198870 0.408743 -0.099436 -0.035241 1.399095 1.555420 1.066003 1.126029 -0.412606 0.371657 1.690168 1.511157 0.827619 0.057876 1.184261 0.354886 0.869166 0.825315 1.069197 0.055544 0.926747 0.994446 -0.406535 1.243161 1.409918 0.623323 1.296612 0.600545 1.814707 1.913723 0.665613 1.150575 0.642943 -0.000728 0.108004 1.148509 1.338004 0.731747 0.682804 1.190657 0.379742 0.514953 0.586813 0.784946 1.269079 1.453729 1.496418 0.332671 -0.412333 0.644169 0.803815 1.053593 1.563066 0.967726 0.733563 -0.027726 1.710240)
     )

;;; 63 even --------------------------------------------------------------------------------
#(63 10.855396270752 #(0 1 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1)
     10.68339442069 #(0 0 1 0 0 1 0 1 0 0 1 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 1 1 0)
     10.562 #(0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 1 1 0)
     10.45694065094 #(0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 1 0)

     8.413888 #(0.000000 0.010634 0.820887 1.791906 0.180821 1.699733 1.457775 1.781040 1.049055 0.063682 0.656198 -0.016519 1.426220 1.490473 0.018505 1.749295 0.166920 0.934178 0.018879 0.949939 1.163838 0.694420 0.665805 0.087679 1.619302 0.169784 1.099805 0.390614 0.230991 0.703447 0.620497 0.345622 1.520041 1.514348 1.626503 0.238228 1.445149 1.071455 0.772257 1.186699 1.488207 -0.090097 0.947955 1.288711 1.143854 0.328539 1.581009 1.516219 1.752145 1.825272 0.656629 1.607807 1.482688 0.741468 0.684282 0.938749 1.078766 0.076298 1.127102 0.768415 0.654765 1.253057 1.466721)
     )

;;; 64 even --------------------------------------------------------------------------------
#(64 10.952004432678 #(0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1)
     10.532917976379 #(0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 0 0 1 1 1 1)
     10.487 #(0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 1)

     8.500897 #(0.000000 -0.110230 0.253682 0.149208 0.517156 1.680690 0.261962 -0.311932 1.499119 0.134139 0.193946 1.528316 0.126448 1.680960 0.957330 -0.015272 0.163098 1.233151 0.955877 1.516677 1.271750 0.225924 1.801609 0.924065 0.996478 1.135973 0.892170 1.311436 1.257336 0.314351 0.968388 0.136861 1.841069 1.348391 1.398845 -0.195293 1.345125 1.529238 1.112945 1.363188 0.328366 0.804723 1.816185 1.478898 0.163962 1.500837 0.226838 0.805475 0.515967 0.095385 1.528024 1.274946 0.915048 0.129649 1.022985 1.362093 -0.189345 -0.123957 -0.176055 0.992212 1.710004 0.183155 0.509794 0.492211)
     )

;;; 65 even --------------------------------------------------------------------------------
#(65 10.903659606228 #(0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 1 0)
     10.842938423157 #(0 0 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0)
     10.593795776367 #(0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0)

     8.665047 #(0.000000 0.111801 -0.021659 0.115758 1.900306 0.395975 1.680391 1.359808 0.348615 0.416803 0.967998 1.336912 -0.204065 1.378431 1.264093 0.200761 -0.126382 1.489383 1.150019 1.935734 0.883346 0.690689 1.772796 0.523096 0.644410 1.273961 1.471264 -1.905888 1.695916 0.751285 0.850823 1.495714 0.223788 -0.093538 1.667326 1.783468 1.446883 1.274332 1.071042 0.209816 -1.857097 -0.016975 1.017941 0.392590 0.267529 0.787886 1.376970 0.677665 1.511431 1.733296 0.560618 1.132581 0.709244 1.136153 0.973193 1.171285 1.352648 0.943370 0.011966 0.901621 0.153498 0.962814 1.791794 0.892898 0.983375)
     )

;;; 66 even --------------------------------------------------------------------------------
#(66 10.77367179842 #(0 0 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0)

     8.785604 #(0.000000 -0.016453 -0.199552 1.162314 1.340828 1.507789 1.885528 1.592200 -0.264493 1.192682 1.764029 1.249910 1.537964 0.543705 1.032134 1.490883 1.403153 1.716879 0.287685 0.532267 1.877234 0.316856 1.148551 0.919334 1.193708 1.641517 1.061703 1.597232 0.183503 0.877408 0.468612 1.277165 0.228291 1.745777 0.514662 1.112985 0.298706 0.431326 1.223544 1.529025 0.442244 -0.052489 0.261943 0.092743 1.260367 1.766629 0.227642 0.642856 0.322647 1.114441 0.112614 1.356884 1.090455 1.458174 1.160803 1.032958 1.056769 0.784558 -0.002365 -0.182767 1.222187 0.824632 -0.075297 1.346091 0.413061 0.096957)
     )

;;; 67 even --------------------------------------------------------------------------------
#(67 11.373999595642 #(0 0 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 1)
     11.240343093872 #(0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0)
     10.668939590454 #(0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 0 0 1 0 0 0)

     8.824400 #(0.000000 0.010231 1.067374 1.823310 0.521610 1.576594 1.616710 1.745373 0.829640 0.596613 -0.040827 0.698819 0.847426 0.694235 1.112182 0.095143 0.244238 1.232290 0.052825 1.836659 0.259527 1.003450 1.401009 -0.434844 0.595280 0.009745 1.327411 1.546522 1.103475 0.145579 0.411008 0.023164 1.316103 0.911720 0.977826 0.797591 0.869476 1.527168 0.141434 0.228949 1.274585 0.150024 1.175449 1.754876 1.483011 -0.005995 0.425686 0.852448 0.306671 0.830883 0.568287 1.599947 0.656439 0.602855 1.899073 0.916952 0.313741 0.511791 0.157642 0.489905 0.669564 0.005701 -0.295719 0.852536 0.481031 0.633899 0.789115)
     )

;;; 68 even --------------------------------------------------------------------------------
#(68 11.328473091125 #(0 1 0 0 0 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0)
     10.834321813096 #(0 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0)

     8.797435 #(0.000000 -0.201059 0.844343 1.587411 1.066026 -0.148779 1.120386 1.659406 1.088098 0.137105 1.655291 0.160402 -0.124245 1.735577 1.001269 0.711181 0.503685 1.213292 1.008635 1.204551 1.334941 0.904983 1.914570 1.907989 1.556989 -0.288182 1.587319 0.760737 1.388451 1.331657 0.077821 0.448937 -0.178856 -0.043846 -0.034531 0.027055 1.220963 0.350404 -0.197606 1.482470 -0.005903 0.929956 1.398979 1.457225 1.736153 0.445730 1.029144 0.901075 1.050633 0.147877 1.402078 0.555001 0.394576 0.571725 0.899520 1.448114 0.650063 1.959761 0.045085 0.922875 1.630899 0.516019 1.027131 1.436098 0.996732 0.735096 0.010291 1.883878)
     )

;;; 69 even --------------------------------------------------------------------------------
#(69 11.439030647278 #(0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0)
     11.237507249543 #(0 0 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 0 0)
     11.164121627808 #(0 0 0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0)

     8.870351 #(0.000000 -0.002928 0.090043 1.728264 1.193144 0.838010 0.865027 0.720973 0.639322 0.246096 0.057627 0.302959 -0.048089 1.638389 0.900762 0.946630 1.090094 0.801115 1.083281 1.325801 0.953024 0.800047 1.660883 0.042716 1.927302 1.582152 0.107129 0.057190 -0.097633 0.434745 0.530943 1.556013 -0.117080 1.617479 1.566580 -0.082197 0.137002 1.745306 1.025473 1.476477 1.524388 0.192617 1.281951 0.528156 0.227376 1.631586 1.077576 0.616842 1.479500 0.199402 1.336867 0.525138 1.593133 1.323175 0.217188 0.498012 1.287694 0.007842 1.310482 0.013236 0.970642 -0.011247 0.684481 1.560396 -0.131105 0.613388 0.586300 0.981366 1.715362)
     )

;;; 70 even --------------------------------------------------------------------------------
#(70 11.561226844788 #(0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 0 1)
     11.405939102173 #(0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 1)
     11.188811302185 #(0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 1)

     9.001001 #(0.000000 0.131474 0.592135 0.190557 -0.153373 0.552899 1.683034 0.676832 0.114035 1.445660 0.845973 -0.400266 1.334548 0.664616 0.497263 1.151914 0.417898 0.299707 0.898144 0.505845 -0.046486 1.144582 1.680096 0.271043 0.375231 0.828649 0.133202 1.612259 0.410697 1.132865 1.435106 1.541053 1.000344 0.349791 0.551555 0.558465 -0.055096 1.896281 0.975002 0.128079 0.671081 1.322501 0.944629 1.793121 0.061307 0.312652 0.594633 0.217284 0.386999 1.356327 0.034596 -0.419952 -0.051003 0.525924 -0.048723 1.515715 1.495013 0.639447 0.503167 1.794381 0.409806 1.279917 0.524725 0.917607 0.873570 1.138057 1.071746 1.351068 1.308571 1.153093)
     )

;;; 71 even --------------------------------------------------------------------------------
#(71 11.438183906719 #(0 1 1 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0)
     11.28450554254 #(0 1 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0)
     11.146488189697 #(0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0)

     9.099876 #(0.000000 0.079349 0.625159 1.258787 0.530013 1.102372 1.093136 0.924294 1.127485 1.464458 1.979600 0.782132 1.702782 0.437372 0.971925 1.154268 1.251030 0.950159 1.851280 1.203813 -0.103319 0.325594 1.399095 1.779856 0.761903 0.255905 0.297653 0.663248 0.186101 0.230115 0.275374 0.274993 1.443886 0.206730 1.663987 0.390044 1.587320 1.029520 -0.035358 1.645862 1.741915 1.373531 0.062465 0.509436 0.690625 0.633198 -0.002788 0.245448 0.213704 0.224115 1.243372 1.006837 -0.140824 -0.200037 0.435321 1.384917 0.505831 0.468032 1.777631 1.330087 0.575453 0.141264 1.636132 -0.042734 -0.187086 0.967087 1.052718 0.644082 0.360432 0.135772 1.188528)
     )

;;; 72 even --------------------------------------------------------------------------------
#(72 11.543568607158 #(0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 0)
     11.492732978803 #(0 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1)
     11.323646371629 #(0 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0)

     8.985526 #(0.000000 -0.132001 0.251840 -0.152367 1.238134 0.223104 0.102612 0.998567 1.283059 0.195894 1.573363 0.407537 1.033361 -0.202081 0.593147 0.635495 1.000647 1.220151 0.876169 0.891935 0.590452 0.848621 0.474219 0.520369 1.077034 0.562333 1.205154 1.187120 1.031050 1.268084 0.666333 -0.432529 0.483326 0.764356 0.428610 0.084679 1.685196 -0.154809 0.749260 1.099715 -0.153921 1.175926 0.117589 0.701530 0.528397 1.669792 1.315998 0.695987 0.047259 0.736352 1.073555 1.525504 1.860608 -0.168018 1.587814 -0.029717 0.367471 1.076978 0.934753 0.510954 0.369425 1.530708 0.338598 0.869566 1.012951 0.841118 0.372289 1.598627 0.202786 1.450618 0.578685 0.231358)
     )

;;; 73 even --------------------------------------------------------------------------------
#(73 11.708482477396 #(0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0)
     11.567651928526 #(0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0)
     11.416394233704 #(0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0)

     9.160436 #(0.000000 0.027950 1.900715 0.869822 0.646112 0.077426 1.155251 -0.021052 0.518493 0.617496 1.388215 1.522153 1.172906 1.149772 0.333734 0.393437 1.621197 0.185430 0.978846 0.372584 1.548540 1.130781 1.465337 -0.103634 0.006466 0.037357 0.391754 0.426758 0.819203 0.701815 0.292464 0.069457 0.577912 0.674450 0.714398 0.870930 0.471488 1.694561 1.422309 0.024178 1.159061 1.177900 0.997237 0.330723 0.617770 0.124367 0.702881 0.123322 0.616808 1.674332 -0.285869 0.254485 1.422041 1.560042 0.228472 0.264729 1.726773 1.335713 1.778611 1.198432 0.635667 1.729615 1.218174 1.736469 -0.025764 0.920389 1.363479 0.696780 1.620306 0.361633 1.171727 0.183150 -0.057205)
     )

;;; 74 even --------------------------------------------------------------------------------
#(74 11.869382858276 #(0 0 0 1 0 0 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 1 1)
     11.749699425492 #(0 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1)
     11.47264289856 #(0 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 1)

     9.250742 #(0.000000 -0.083965 -1.881815 1.821331 1.386347 0.815158 0.861194 0.758451 0.121974 1.299000 0.054807 1.146690 -0.196567 1.077391 0.909613 1.143984 1.888489 1.269531 -1.733427 0.151569 0.785590 1.819949 1.112424 -0.148411 1.931437 0.244580 1.662958 0.942860 1.105870 1.261679 1.618194 0.224247 0.028379 1.852048 1.669304 0.239353 0.498203 1.728796 1.313709 0.807114 0.891485 1.312681 -0.176379 0.372289 -0.005575 1.850794 0.023650 0.120381 1.553513 0.216126 1.685352 1.976122 1.786733 0.457794 1.346521 1.633128 0.393538 1.233954 0.957066 0.674775 1.604992 1.155294 0.690723 0.675446 1.253400 1.634669 -0.333881 1.030321 0.123348 1.136835 1.697505 0.217891 1.296168 0.608680)
     )

;;; 75 even --------------------------------------------------------------------------------
#(75 12.015588177241 #(0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1)
     11.787453747993 #(0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 0 0 1)
     11.599789619446 #(0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1)
     11.479255355845 #(0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1)

     9.208357 #(0.000000 0.084261 1.362946 0.177656 1.634527 1.009625 0.073053 1.095734 0.754367 0.140657 0.840998 0.079964 0.755605 1.734985 0.011592 1.279684 0.141928 1.017416 1.483503 0.041818 0.533102 1.484930 0.065498 -0.030739 1.192537 1.199139 -0.183682 0.921889 0.854797 0.103844 1.559565 0.494845 -0.611738 1.765464 1.655786 -0.041953 -0.011985 1.317391 -0.122845 1.445251 0.197471 0.029250 1.681285 1.557190 1.183445 0.922533 1.218194 1.571065 -0.484664 0.227500 0.999836 1.227580 0.722207 -0.002654 0.004008 0.223846 0.621401 0.014882 0.001860 1.251895 0.962821 0.692429 0.931749 -0.200785 0.437140 0.014383 0.744494 0.367562 0.804064 1.305444 1.115643 -0.150186 -0.349641 1.447670 1.333439)
     )

;;; 76 even --------------------------------------------------------------------------------
#(76 11.890932162956 #(0 0 1 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1)
     11.477294510597 #(0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1)

     9.391989 #(0.000000 0.083661 1.749065 1.383277 1.268685 0.331011 0.962366 1.064343 0.130949 0.045363 1.434392 1.152107 1.279944 1.669316 0.249701 0.393787 1.696976 1.581011 0.803000 1.930685 1.212962 1.250167 1.314706 1.413859 1.021702 1.409420 1.401054 0.862663 0.730311 0.385791 1.013853 1.271191 0.438935 0.151467 1.211394 1.482718 0.379332 0.802632 1.794780 0.607907 0.416440 0.498873 1.037564 1.244268 0.532659 1.076448 0.381587 1.202722 1.544856 1.431260 1.579045 1.538576 0.018175 1.228440 0.056007 1.221456 0.649101 -0.140745 1.406666 -0.018866 1.530954 0.680273 0.540545 0.587939 1.389288 1.692386 0.070933 -0.122750 0.167586 1.722730 0.856613 1.340694 0.199008 0.951704 0.606225 1.639914)
     )

;;; 77 even --------------------------------------------------------------------------------
#(77 11.909692733602 #(0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 0 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1)
     11.875939332637 #(0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1)
     11.594018936157 #(0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1)

     9.362848 #(0.000000 0.135190 -0.168805 -0.106734 1.466664 1.485793 0.488537 0.767878 1.294564 0.615402 1.373684 0.965920 -0.055085 1.225693 1.760290 0.169177 0.327972 1.432795 0.756334 1.139614 0.977377 1.502235 0.480130 1.455906 1.815326 1.254543 0.661135 0.508234 1.120550 0.606106 1.260571 -0.124519 0.828293 1.360997 0.198895 0.894447 0.815674 0.872999 0.199886 0.011330 0.602996 1.008955 0.037106 0.727539 0.181285 0.797945 0.739037 1.238860 1.974886 0.371186 0.036896 1.775015 0.994163 0.188774 1.830125 0.129488 1.938228 1.119164 0.779874 0.812141 0.852820 1.097270 0.878650 0.340801 0.818203 1.088844 0.598098 1.186513 1.149024 1.789189 1.738326 0.809347 0.582805 1.448480 1.851932 1.376296 0.993966)
     )

;;; 78 even --------------------------------------------------------------------------------
#(78 11.940728787203 #(0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 0)

     9.335941 #(0.000000 1.404748 1.136727 0.627680 0.129528 0.271686 0.002711 1.737837 1.295987 1.387168 0.097658 1.822832 0.846464 1.039100 1.481322 0.895294 0.827592 0.841157 0.429643 0.718521 1.651578 0.732848 0.670593 1.833752 0.966314 1.266799 1.852734 1.169793 1.403542 0.722295 1.054728 1.444480 1.323054 1.351419 0.414445 0.928183 1.497407 0.895056 0.003473 1.202042 1.804296 0.448756 1.139768 0.075452 1.121542 0.477216 1.723231 0.402648 0.668323 0.045598 1.846940 0.961710 0.765295 1.814929 0.327072 0.120487 1.324670 1.238079 1.405578 -0.005216 1.466365 1.535268 1.050547 0.249219 1.956711 0.420435 0.291291 0.855796 1.032224 0.874733 1.340034 0.852331 1.473861 1.078790 -0.021411 0.624891 0.620475 1.381664)
     )

;;; 79 even --------------------------------------------------------------------------------
#(79 12.421415328979 #(0 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1)
     11.878196632448 #(0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1)

     9.532396 #(0.000000 -0.016315 1.008231 1.404220 -0.132722 0.193112 1.896743 0.275812 1.798498 1.352213 -0.182798 1.587651 1.726663 1.190144 0.964896 0.333899 1.075260 1.001974 1.665160 0.294459 0.569575 0.895168 1.375606 0.740837 1.376644 0.651527 0.577547 1.536086 0.447529 1.183535 1.552628 0.904446 1.778212 1.513496 1.240703 1.119035 0.680896 1.199475 1.720835 0.918021 0.270627 1.101197 1.260915 1.926656 0.656384 0.686478 1.167872 1.943338 1.315551 1.408960 0.546635 0.721970 1.525946 1.110901 1.459115 0.741803 0.049893 0.532313 -0.063148 1.978589 1.617537 1.719612 1.276530 0.270764 -0.022015 -0.140029 0.286417 0.322519 1.051041 0.879612 0.876533 1.390213 1.425804 0.312105 -0.190111 1.694143 1.977481 1.551327 0.811100)
     )

;;; 80 even --------------------------------------------------------------------------------
#(80 12.739060401917 #(0 1 0 1 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 0 0)
     12.228775030303 #(0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0)
     12.095606803894 #(0 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0)
     11.989325523376 #(0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0)

     9.571318 #(0.000000 -0.039867 1.215075 1.224067 1.244422 0.818513 0.654424 1.435050 1.824765 0.129307 0.731173 0.082394 -0.061164 0.115614 0.971122 0.735679 1.804345 0.300253 -0.033316 1.069309 0.858380 0.390640 0.075046 0.835868 0.438933 0.971002 0.084902 1.112233 0.696836 -0.024250 0.373522 0.155454 0.458025 0.650316 0.690378 0.616972 1.259529 0.963098 0.347039 1.688455 1.430180 1.504693 -0.049975 1.544632 0.698185 -0.005603 1.647005 1.945039 1.352995 1.281066 0.340911 1.497452 0.549266 0.646768 1.181595 1.523682 1.147147 -0.003756 0.439826 1.031973 0.879960 0.775704 1.058226 0.072683 0.157975 1.513681 1.503850 1.567581 0.970204 1.642523 0.547761 1.183719 0.135366 1.597658 0.250367 0.887368 1.862274 0.610219 1.380117 1.460889)
     )

;;; 81 even --------------------------------------------------------------------------------
#(81 12.189952580352 #(0 1 1 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1)
     12.039585160315 #(0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0)
     11.979215621948 #(0 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0)

     9.543680 #(0.000000 0.469329 1.698696 0.271440 0.605478 1.525845 0.530399 1.207090 1.612228 0.187100 0.339592 0.231118 0.088316 1.188856 1.495509 1.768455 0.445970 1.628891 1.418616 1.113091 1.147587 0.596789 1.451698 1.836263 1.082721 0.722668 0.692598 1.361319 -0.033421 0.879382 0.694886 0.887268 0.123473 1.896222 0.196297 0.080949 1.607250 1.306200 1.349794 0.105289 0.838731 1.046031 0.506099 1.491562 0.551379 0.192156 1.478803 0.815206 1.906771 0.934252 0.172898 -0.072969 0.120891 0.997744 1.807947 1.171892 0.247615 0.799528 0.108242 0.134285 0.311754 0.954137 1.529645 0.902210 1.400170 1.647770 1.704695 1.788423 1.821309 1.619019 0.388480 0.191475 0.023952 1.631041 0.660546 1.726907 1.703779 0.183252 0.491368 0.139347 1.751046)
     )

;;; 82 even --------------------------------------------------------------------------------
#(82 12.307968522655 #(0 0 0 0 0 0 0 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0)
     12.071621513807 #(0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0)
     11.74796962738 #(0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0)

     9.663176 #(0.000000 0.053836 0.614988 0.818931 0.256253 0.588209 1.258770 0.664691 1.680531 1.349163 1.668437 0.347454 0.099421 1.175964 -0.053957 1.343838 1.718928 1.146815 0.902021 1.267865 0.085499 1.493936 0.057392 0.028833 0.002379 0.763887 0.873528 1.293005 1.330933 0.985403 0.094786 0.924254 1.024949 0.425845 1.650809 1.829244 0.828244 1.532147 0.611407 0.736121 1.677225 0.896613 1.891406 0.001536 1.840218 0.873485 1.625434 0.400795 0.568459 0.823247 0.780680 -0.214332 0.564499 0.412616 -0.080294 -0.132484 0.829890 -0.403419 -0.158748 1.881752 1.497657 1.118441 0.121153 -0.136792 0.378553 1.155760 1.062216 0.447639 -0.130733 0.357927 0.152353 1.134303 1.749012 1.148456 0.341262 -0.046354 -0.167100 0.094319 1.606147 0.248726 0.277653 -0.015430)
     )

;;; 83 even --------------------------------------------------------------------------------
#(83 12.587569236755 #(0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1)
     11.931811297539 #(0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1)

     9.752454 #(0.000000 0.102500 1.639196 0.081919 1.150835 0.627133 1.684333 0.783693 -0.057377 1.226872 0.605217 0.708694 0.358784 -0.243484 1.893916 1.134020 0.256660 1.553197 0.023105 1.674768 1.069158 0.270765 1.632036 0.323860 0.045702 0.268942 0.414205 1.126381 1.811514 0.408030 0.351594 0.813247 1.219706 1.910890 0.953351 0.079111 -0.101835 0.022871 1.415723 1.470346 0.506255 1.669825 1.567301 0.078552 0.348762 0.201757 1.180866 1.688424 0.367645 0.044259 -0.195944 1.365563 1.376866 1.610184 0.630672 1.651617 -0.070023 0.250452 1.458656 1.545910 0.828037 0.327211 0.795356 0.840434 0.323780 1.733453 0.564535 0.810292 1.455289 0.787283 0.674692 0.043586 -1.888239 0.545312 0.316805 0.398667 1.282786 1.236008 1.102629 1.685411 1.292891 1.746622 0.211245)
     )

;;; 84 even --------------------------------------------------------------------------------
#(84 12.747644424438 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 1)
     12.50866273996 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 1)
     12.426499838032 #(0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0)

     9.748673 #(0.000000 0.170386 0.576157 -0.028078 0.857287 0.181516 1.167906 0.416534 1.112306 1.829068 1.716695 1.578390 1.003239 1.288378 -0.155136 1.230201 0.392385 1.776427 -0.160592 1.714735 -0.010518 1.769332 0.694439 0.955118 1.707910 0.081138 -0.143534 1.831469 0.648453 0.673245 0.899978 0.925312 0.754196 0.520917 0.554168 0.252108 0.297124 0.980568 0.082042 0.245715 1.013324 0.415119 1.585651 1.693489 0.625108 0.301178 0.075903 1.553479 1.136099 0.208461 0.730449 0.735262 1.411780 0.672322 0.322123 0.461159 1.560333 1.855688 1.140003 0.308417 1.253125 0.090643 1.772945 1.226937 -0.056537 0.063839 0.182805 0.525922 -0.004765 0.124294 1.311864 1.293462 0.826182 1.680946 1.705291 0.826610 1.429973 1.482012 0.431476 0.058643 0.184624 0.154791 0.954457 1.394650)
     )

;;; 85 even --------------------------------------------------------------------------------
#(85 12.635076593197 #(0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1)
     12.624737923152 #(0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 1)
     12.270205061432 #(0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1)

     9.693668 #(0.000000 0.195989 0.490949 0.331600 0.887562 0.028445 1.546017 1.385311 0.812190 1.115113 1.801497 0.487288 0.525794 0.074082 1.723182 1.944316 1.781964 0.421600 0.177518 1.829367 0.571078 1.783004 0.344177 0.329133 1.891108 0.440324 0.259558 0.143603 0.779362 1.104207 1.976902 0.561742 0.767039 1.340228 0.253563 1.774888 1.741378 1.554241 1.474673 0.298807 0.272176 1.211675 1.002346 0.130871 1.176937 0.697418 0.199450 0.178715 1.330092 0.855241 1.512332 1.331159 0.219055 1.811575 1.934102 1.939888 1.043996 0.748687 0.643521 0.780509 1.267694 0.441215 0.667193 0.454905 1.688291 1.972173 0.503377 0.756581 0.239100 0.784029 1.470486 0.189182 1.795940 0.379978 1.569889 1.093199 1.711138 0.905143 0.045022 0.285289 1.219061 0.953496 1.196694 1.742789 0.902060)
     )

;;; 86 even --------------------------------------------------------------------------------
#(86 13.114136440046 #(0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0)
     12.791990425787 #(0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0)

     9.804520 #(0.000000 0.137494 0.326172 0.010382 1.487613 0.505001 1.228062 0.954717 -0.127893 -0.290666 0.636565 1.325872 1.732483 0.567284 1.353499 0.704440 1.806655 1.469223 0.382393 0.706107 0.545460 0.307640 1.039546 0.875080 1.787391 0.105900 0.639604 0.989302 -0.045857 1.717167 1.835064 1.163334 0.033557 1.525348 0.510815 0.463389 0.777198 0.612036 1.665125 1.493136 0.475659 1.095674 1.296538 1.117478 0.603294 1.233039 0.344624 0.414746 0.337889 1.713708 0.141791 0.820548 1.699043 0.899800 0.803706 0.771637 1.413475 1.319088 1.268258 0.265658 0.770528 0.659195 0.900807 0.683986 1.290180 0.800356 1.418815 1.036184 1.201710 0.337696 1.582663 1.435772 0.606855 1.068190 0.540979 1.320205 -0.195129 0.714820 0.387530 0.040243 0.270436 -0.038662 1.702501 0.563408 0.676006 0.165316)
     )

;;; 87 even --------------------------------------------------------------------------------
#(87 13.008953483644 #(0 0 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0)
     12.872 #(0 0 1 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0)
     12.669403362513 #(0 0 1 1 0 0 1 0 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1)
     12.625063286678 #(0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)

     9.874660 #(0.000000 0.366900 0.585885 0.360276 1.741378 1.383744 0.806085 0.218985 1.748601 1.513484 1.913086 1.499231 1.804617 1.560415 0.976184 0.564077 0.614555 0.706893 1.155782 1.743949 0.256106 1.587276 1.479629 0.499900 0.621596 1.318438 0.505053 -0.000351 1.493931 0.351932 1.677582 1.117619 1.631442 0.001969 0.286212 0.372264 0.187053 0.296894 0.961309 0.849648 1.557109 1.714474 -0.039206 1.347988 1.896634 1.217858 1.504538 0.380552 0.871895 1.911392 0.768943 1.752782 0.535064 0.764217 0.468880 0.181130 0.490835 1.212121 1.451975 1.107304 0.551132 0.225217 0.930971 0.652946 1.821236 0.839189 1.745456 0.283826 1.910401 1.397382 1.626785 0.236815 0.165723 1.103589 1.501862 1.903299 0.205800 0.189795 0.285228 0.129502 1.654212 0.651262 -0.043737 0.438462 1.813853 0.852642 1.712123)
     )

;;; 88 even --------------------------------------------------------------------------------
#(88 13.132745742798 #(0 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0)
     12.908752771202 #(0 0 0 1 1 0 0 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0)
     12.675436588537 #(0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0)
     12.661032846106 #(0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1)

     9.968289 #(0.000000 -0.196357 0.929221 -0.292758 0.583518 -0.150161 0.590446 0.047232 0.052420 0.246412 0.310641 0.574671 1.255763 0.526465 1.120164 0.264973 0.758035 0.236915 0.645326 1.021758 1.448970 0.311575 1.450268 0.826011 0.187310 1.722297 1.302724 1.119250 0.313110 1.079530 -0.080537 -0.033960 1.115452 -0.004159 0.625991 0.819699 -0.239392 0.716715 1.191258 0.940540 1.226468 0.689411 1.846094 1.403441 0.153558 0.077405 1.279276 1.497552 1.261202 1.239909 0.491588 0.403000 0.701399 0.883464 0.451754 1.032393 1.712522 1.614114 0.008049 0.437198 -0.139256 1.949506 -0.172033 0.665930 -0.214223 1.141893 0.504852 1.418238 1.150362 0.374555 0.424705 0.858809 1.469906 0.634464 0.161126 0.813327 0.754236 0.718520 1.610683 0.131948 1.211886 0.778216 0.449807 0.273476 0.430938 0.507028 1.242701 1.586191)
     )

;;; 89 even --------------------------------------------------------------------------------
#(89 13.321250915527 #(0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 1 0)
     13.191189069613 #(0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 1 1)
     12.707793861614 #(0 0 1 0 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1)
     12.335865540187 #(0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1)

     10.110339 #(0.000000 -0.047736 0.909765 0.376771 1.404843 0.899987 1.694737 0.140337 0.279732 0.352483 1.321245 0.831702 1.685845 1.264564 1.494433 1.732556 1.393906 -0.026459 0.674486 0.211415 0.528457 0.273991 1.091323 0.380875 0.090939 0.478814 0.092883 0.434794 1.648556 -0.302945 1.637721 0.242621 0.247276 1.326925 0.902219 0.807608 0.668807 0.691812 1.388287 -0.010569 0.133437 0.728657 0.782215 0.083421 0.429905 1.734507 0.782039 0.586030 1.686869 0.849475 1.634952 1.184726 0.229497 0.459480 -0.165153 1.451272 -0.261905 0.212703 1.514090 1.390991 1.012189 0.980809 0.166300 1.101464 1.767892 1.850472 1.333751 1.234406 1.310299 1.418091 1.077315 0.039033 0.085455 0.991907 0.878907 -0.090595 0.777081 0.143193 0.476774 1.647786 0.496393 1.097022 1.073630 0.565393 0.656993 1.471806 1.710671 0.587345 1.328207)
     )

;;; 90 even --------------------------------------------------------------------------------
#(90 13.53812119512 #(0 1 1 1 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 1 0 1)
     13.016282120103 #(0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0)
     12.781593429563 #(0 1 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0)
     12.716424196959 #(0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0)

     10.239536 #(0.000000 0.029165 -0.004751 1.149391 0.907579 0.296375 0.223370 0.535209 0.379693 0.944177 0.492949 0.426344 0.909452 1.143281 0.598468 0.007134 0.464010 0.323358 1.625221 0.259973 0.277021 -0.050165 -0.105204 0.195062 -0.039224 0.694292 0.918686 1.206093 0.664032 1.485235 0.505371 -0.158863 -0.104978 1.715476 1.137623 1.286318 1.237154 0.717720 0.620797 0.277669 0.677552 0.640712 1.359803 0.939527 0.609869 0.065066 0.357294 1.236931 0.604766 0.592694 1.321284 1.166360 1.169991 -0.405553 1.140328 1.225298 1.027404 0.097503 0.150158 1.621303 0.728032 -0.036266 0.884388 -0.004445 1.936948 1.644094 -0.046576 0.326281 1.229012 0.242965 0.848998 -0.246273 1.334798 0.145895 0.690297 1.236063 1.671596 -1.616960 0.384418 1.056917 0.472028 1.442148 1.311788 -0.178377 0.245345 0.752145 0.112086 1.196101 1.785850 0.738435)
     )

;;; 91 even --------------------------------------------------------------------------------
#(91 13.63089466095 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1)
     13.263186228373 #(0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1)
     12.853587071592 #(0 0 0 1 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0)

     10.167771 #(0.000000 -0.121337 0.775052 0.976018 0.304923 0.147835 1.218192 1.150287 0.078954 1.008975 -0.004967 0.272553 1.474186 1.551617 1.355615 0.136412 1.962600 1.335863 1.569420 -0.007704 0.880661 0.532860 1.282044 -0.110808 0.466603 0.413237 1.091718 1.766665 0.403652 -0.176828 0.162887 1.527964 -0.131327 0.265385 1.306727 0.281105 0.261651 1.119674 0.196797 0.761762 0.547948 0.983279 1.074551 0.996050 0.999624 1.607456 1.055760 1.044094 0.747826 1.176758 0.268951 1.017855 0.445017 0.045663 0.702171 0.526049 0.084839 0.852645 0.904790 0.032638 1.375859 -0.083999 0.687308 0.557889 0.830364 1.858815 1.721297 0.746840 0.571921 0.582318 1.134288 0.368347 -0.171640 1.657951 1.880887 1.584708 0.915224 -0.181721 0.663670 0.446115 0.729125 0.295179 1.576639 1.491865 1.267054 0.298294 0.278011 0.446465 0.926485 0.766416 0.546477)
     )

;;; 92 even --------------------------------------------------------------------------------
#(92 13.355320111641 #(0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 1 1 0)
     12.754180011349 #(0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 1 1 0)

     10.233292 #(0.000000 0.056537 0.365841 1.867190 1.667281 0.776353 1.205014 1.458909 1.169347 0.636628 0.947886 0.751945 1.912028 0.991233 1.500215 0.401351 1.115785 1.108650 0.520106 -0.131549 1.643576 1.643129 0.135531 0.330213 1.352568 0.108969 0.628507 0.468662 0.513882 1.552113 0.355421 1.528870 0.054497 1.678142 1.848022 0.127790 0.258529 1.369530 0.810700 0.491654 0.120845 0.643189 1.781797 1.585583 0.231829 1.322716 0.108825 0.835546 -0.100342 0.963311 0.505397 1.535587 0.659100 0.990598 1.513535 0.215290 0.746923 -0.326102 1.629054 -0.245634 1.198702 1.538390 0.192529 0.015095 0.150457 1.046371 1.233867 1.355797 1.173463 0.624454 1.510262 0.852453 1.007573 0.792960 0.515096 1.168534 1.218000 1.728796 0.005073 0.031207 1.306119 0.682725 -0.087479 1.431500 -0.019571 1.570718 1.084909 0.837648 0.078559 1.676508 1.809106 0.911505)
     )

;;; 93 even --------------------------------------------------------------------------------
#(93 13.783703804016 #(0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0)
     13.143995954461 #(0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0)
     12.876626968384 #(0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0)

     10.120779 #(0.000000 -0.035376 0.073991 0.427701 -0.282243 -0.018747 0.215658 -0.153445 1.426646 1.066559 1.939228 0.906624 0.410081 0.611941 0.984019 1.022397 0.624511 1.012954 0.533644 1.662254 0.644321 0.184706 0.621632 0.642800 -0.008009 1.949179 1.710653 -0.084032 0.277398 1.824022 0.699251 0.129968 1.020811 0.661971 1.702058 0.534563 1.888605 -0.287827 0.144583 1.379920 1.385073 1.054451 1.007433 0.338841 0.857467 1.489234 0.309837 0.300057 1.146999 0.772495 0.275152 0.667315 1.064213 0.727453 1.142263 1.118538 0.931092 1.595399 1.937578 1.220927 0.920538 0.541725 0.173459 0.580373 1.100745 1.191038 -0.340664 1.515332 1.223959 0.649170 0.846642 -0.414943 0.030223 1.461947 0.288064 0.141033 0.634411 1.011893 0.138288 1.584616 0.333385 0.901662 0.043826 0.951055 1.409243 0.569338 0.143517 0.644810 -0.103707 1.742249 0.748991 1.014192 0.003204)
     )

;;; 94 even --------------------------------------------------------------------------------
#(94 13.381710407562 #(0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 1 0)
     12.991560374803 #(0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1)

     10.436123 #(0.000000 0.077686 1.512242 1.687576 1.748775 -0.042495 0.545427 0.496993 -0.167749 1.818689 1.294169 0.158257 1.111313 1.693196 0.828268 0.831975 1.385685 1.752049 1.035307 1.138753 1.263799 0.475805 0.652786 0.473618 0.784033 0.219244 0.537649 1.245592 0.143085 0.146549 -0.194610 0.262825 -0.054323 0.065553 1.205203 0.961727 0.443925 0.031116 -0.006895 1.079616 0.499661 0.675592 0.950801 1.568015 1.811380 1.749281 1.413481 1.737809 1.309682 1.645025 -0.138801 0.751839 0.785369 1.541101 -0.031663 1.688181 -0.303851 1.624930 1.493028 0.091564 1.050183 0.458837 0.748021 0.299762 -0.134406 1.337884 1.679325 0.235544 1.565934 0.724407 -0.081186 1.656669 0.129795 0.540077 1.408279 0.556706 0.619362 1.531988 1.044793 1.679714 1.199908 0.134959 0.184647 1.211663 1.402740 1.123637 0.244749 1.724333 1.522024 0.403087 1.567300 0.902273 1.776168 0.744433)
     )

;;; 95 even --------------------------------------------------------------------------------
#(95 13.458537482645 #(0 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0)
     12.939489078295 #(0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 0)

     10.445310 #(0.000000 -0.051116 0.318152 1.109268 0.780397 -0.042780 0.856912 0.821977 -0.031838 0.919703 1.185438 0.134351 0.241768 0.630555 0.901054 -0.076759 0.207775 1.622576 0.870861 1.147802 0.451405 1.184669 0.781575 0.324543 1.095873 0.811917 1.006984 1.026509 0.292112 1.776001 -0.027399 1.244922 0.567806 1.344757 1.096939 -0.062151 1.369590 0.654609 1.519208 0.625429 0.173885 1.826139 1.268005 1.806897 0.971724 1.442284 1.171839 1.199414 0.203144 1.638097 1.000534 0.956656 1.120350 0.018640 0.052254 0.043573 0.298247 0.111129 1.640935 0.183421 1.093052 0.873238 1.083855 0.075695 1.555181 1.524656 1.819903 0.191505 1.119644 1.050115 0.917877 0.861484 0.586822 0.912806 1.350258 1.278350 0.704242 1.266040 1.267966 1.460775 0.083481 1.190142 0.853329 0.364244 0.709939 1.562143 0.266687 1.389727 0.112486 0.434122 0.614333 1.086133 0.806144 0.549026 -0.213689)
     )

;;; 96 even --------------------------------------------------------------------------------
#(96 13.465419214875 #(0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0)
     13.179516746745 #(0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0)
     13.077001047978 #(0 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1)

     10.547975 #(0.000000 0.153788 1.473197 1.120622 1.160730 0.821461 0.587273 0.167241 1.236856 0.827347 -0.057836 1.535401 -0.117552 0.274907 1.894598 1.284833 1.477954 0.868074 0.057941 0.687268 1.015281 0.329213 1.906506 0.947198 0.703351 0.385081 1.806930 1.328332 0.675989 1.662595 1.727408 1.295469 1.482524 1.137076 0.546624 1.750335 0.078617 0.791819 0.822504 1.490625 1.352152 0.334894 0.444980 0.643765 0.864293 0.815473 1.380682 0.184714 0.669713 1.140240 0.088465 0.541405 -0.157197 -0.132649 1.823232 0.846040 0.071003 0.952533 -0.065067 1.612984 0.885226 1.808095 1.635967 1.839317 0.543976 1.361216 -0.052367 0.562933 1.559827 0.784591 1.080062 0.973059 0.736210 0.975628 -0.162016 1.496403 1.626996 1.347588 1.450398 -0.115656 1.159064 0.634177 1.229067 0.997788 1.675671 1.364627 1.652672 -0.118019 1.360262 -0.079606 1.184278 0.786694 1.103484 -0.124273 0.091302 1.896912)
     )

;;; 97 even --------------------------------------------------------------------------------
#(97 13.449318349909 #(0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0)
     12.969611395004 #(0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0)

     10.454689 #(0.000000 0.337027 1.887094 0.227883 0.152600 0.092445 1.841424 1.439145 1.388254 1.616194 0.763400 0.654073 1.803756 0.108093 -0.143431 0.031662 -0.194818 -0.122138 0.493739 1.665255 1.409328 1.657685 0.928384 0.951844 0.601629 -0.001928 1.709771 -0.389979 0.699760 0.781956 1.060187 0.360713 0.491837 -0.003997 0.924662 1.831197 1.209076 1.527961 0.529587 0.498601 -0.539328 0.624507 0.775501 1.789171 1.612343 0.172204 1.057213 0.777805 1.097791 -0.150557 1.712991 1.552207 0.700476 1.365184 -0.473090 1.361660 -0.469809 1.027294 1.916045 1.666374 0.171261 0.611032 1.024401 0.234250 0.168975 0.768602 1.828650 0.788894 1.099238 -0.210206 1.104787 -0.006193 1.536099 1.303909 0.909469 1.937298 1.364209 1.175074 1.241805 0.899430 -0.184963 -0.018110 0.890358 0.561403 1.623314 1.349837 0.328241 1.363804 -0.103389 -0.276190 0.221529 0.178432 0.883325 -0.075306 0.892890 1.152539 1.623609)
     )

;;; 98 even --------------------------------------------------------------------------------
#(98 13.942760654268 #(0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1)
     13.490633234777 #(0 1 1 0 1 1 0 0 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1)
     13.468658765207 #(0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)

     10.529542 #(0.000000 0.335186 0.174804 1.835695 1.248408 0.850676 1.083056 1.569282 1.162506 1.479838 1.949415 1.857316 1.411683 1.217416 0.916314 0.559475 0.305919 0.918413 1.260542 1.473466 1.972042 0.558704 1.377417 0.530828 1.249299 0.948541 0.434934 1.312118 1.601808 0.091676 1.800391 0.131496 1.729727 1.239582 0.643872 0.886010 0.273922 1.214061 0.710423 0.758984 1.319095 1.146215 0.317033 0.911490 0.470786 0.784816 0.639508 1.915928 0.368606 0.640303 1.921197 1.635450 1.072962 1.815769 1.739636 1.461497 0.463304 0.135106 -0.042797 1.633025 1.493743 0.120934 0.361992 0.245120 1.918559 0.776575 0.712539 1.369836 0.276867 0.455169 1.367258 1.716475 0.286139 1.073080 0.521904 1.212329 0.128266 1.095677 0.637629 0.778613 0.410358 0.476983 1.225261 0.213459 1.391809 0.312775 1.917925 0.578713 0.449454 0.914668 1.339345 0.916468 0.076458 1.026517 0.800077 0.375508 1.215065 0.088716)
     )

;;; 99 even --------------------------------------------------------------------------------
#(99 14.049349722487 #(0 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1)
     13.942 #(0 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1)
     13.341398779709 #(0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 1)

     10.413963 #(0.000000 0.712347 1.280845 0.928930 0.133453 1.555378 0.117371 1.600661 0.491420 0.901750 0.193696 1.933219 1.386687 0.734776 0.985812 1.560698 1.512479 1.638145 0.383576 0.074705 0.540579 1.369130 0.484804 1.006900 1.150046 1.973082 0.610521 0.186312 1.292089 0.846832 0.072203 0.993368 0.161442 1.932147 1.073344 1.296851 1.795923 0.743699 1.869056 0.001246 0.351627 1.407819 0.962437 0.006791 0.634101 1.376740 1.110061 1.630535 0.477472 0.824121 1.405347 1.579377 0.790277 0.219555 0.390884 1.592629 0.359522 0.569274 0.575613 1.379010 0.890824 1.826277 0.051134 1.721938 0.270027 1.357854 1.296076 0.622100 0.011386 0.403225 1.517456 1.690306 1.416785 0.835328 1.163589 0.775139 0.843320 1.005869 0.523563 0.447945 0.141480 0.622535 0.816163 1.145756 1.213985 0.933881 1.081830 1.030912 1.231534 1.092662 1.436680 0.541606 0.954355 1.254628 0.475357 0.158784 1.645393 0.621643 0.430359)
     )

;;; 100 even --------------------------------------------------------------------------------
#(100 14.500160217285 #(0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 1)
      13.694382146343 #(0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0)
      13.512077331543 #(0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0)

      10.472141 #(0.000000 -0.079327 0.575962 1.216890 -0.014744 1.794579 0.223351 1.035736 1.450027 1.621511 1.146130 0.664482 0.663607 -0.266960 0.246822 0.754872 1.746592 -0.423496 -0.112090 1.668859 1.661047 0.950742 0.085504 0.302466 1.790192 0.512158 1.549763 -0.087872 1.606339 1.457814 0.979132 1.246348 1.572286 1.270907 0.557192 1.282392 0.773062 0.627296 0.449140 1.192929 0.105994 0.224683 -0.182519 0.743965 0.463017 1.607410 -0.217575 1.706348 1.917272 0.364576 0.425823 0.089107 1.477241 0.882347 1.143269 0.061661 0.026397 0.093540 1.833116 0.100956 -0.001875 0.084325 0.282798 1.183349 0.971365 0.306714 1.553029 0.062053 0.155585 0.754942 -0.336663 0.692895 0.554870 1.705080 0.442045 1.319460 0.995119 1.023180 1.734006 0.775241 1.099502 1.819778 -0.446034 1.513278 1.247469 0.530165 0.247921 1.473754 1.799924 0.292965 1.840516 0.908343 1.781887 1.143210 0.571911 1.546526 0.744154 1.261450 1.702101 1.407355)
      )

;;; 101 even --------------------------------------------------------------------------------
#(101 14.704120635986 #(0 1 1 1 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1)
      14.20509180893 #(0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1)
      13.916260357992 #(0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1)

      10.799526 #(0.000000 -0.144607 0.013859 1.186211 1.897323 1.284119 1.006273 0.249463 1.353348 0.000396 1.261695 0.039631 0.269884 1.581826 -0.306293 0.951683 0.285404 1.803165 0.621282 0.724745 0.672287 0.608766 0.914878 1.328473 -0.018663 1.325129 -0.013261 1.903652 0.194962 0.463363 -0.231820 1.629741 1.349193 1.628170 1.140984 -0.090902 1.443092 0.797141 1.001065 0.446968 1.256367 1.331869 0.592675 1.493826 1.821878 0.042448 1.844814 0.083350 0.209886 1.550981 0.150808 0.572192 1.818232 1.319474 0.173105 0.518680 0.765228 0.008927 0.193323 0.153137 1.891670 1.238987 0.567542 0.210254 1.199484 1.183822 0.587990 0.851754 -0.069708 -0.067958 0.115555 1.477273 1.369107 0.063458 1.384555 0.342004 0.790088 1.888377 1.572026 0.442620 1.045282 0.818179 1.536149 0.167035 1.737744 1.404785 1.206543 0.945795 1.310027 1.660119 1.096329 0.264639 0.898284 0.971595 1.319506 1.477808 1.080407 0.036054 0.713894 0.805709 1.681331)
      )

;;; 102 even --------------------------------------------------------------------------------
#(102 14.246722674125 #(0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1)
      13.955191612177 #(0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1)
      13.554303556646 #(0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0)

      10.825302 #(0.000000 0.062121 1.498454 0.229560 -0.067159 1.707790 1.455738 1.263638 0.236200 0.320689 0.125764 -0.270632 0.509239 1.558912 0.853347 0.800159 0.005253 1.781383 0.013460 1.467616 -0.413080 0.706033 1.622767 0.844541 0.474918 0.336931 1.701920 0.678601 1.382005 0.642564 0.140819 1.093904 1.378103 0.531070 0.896383 0.914549 0.689036 1.566499 1.297025 -0.188441 -0.107847 0.193824 -0.015123 0.436520 -0.030258 1.446811 1.129335 1.807438 0.376813 0.447849 -0.323182 0.476749 0.500319 0.802812 1.604971 1.911778 1.280729 1.062069 0.369607 -0.411935 1.602988 1.061778 0.172427 1.104631 1.777834 0.639744 1.680999 1.073668 0.721552 -0.031528 0.738562 1.772140 1.822954 1.730916 1.460278 1.632051 1.212895 1.455696 0.508934 0.916083 1.283063 0.685140 1.144864 1.155087 0.985699 1.629625 0.962308 1.294943 1.005976 0.062843 1.421725 0.120396 0.211607 0.585160 1.130798 1.300191 1.580504 1.727724 0.593270 0.896488 1.668068 -0.126261)
      )

;;; 103 even --------------------------------------------------------------------------------
#(103 14.267168699654 #(0 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 1 0 1 0)
      14.260 #(0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 1 0 1 0)
      13.923377530893 #(0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0)

      10.831475 #(0.000000 1.226555 0.635074 0.261743 1.378909 1.065458 0.488555 0.537095 0.048283 1.381745 0.297005 1.188675 0.355356 1.185708 0.295111 1.601685 0.525729 1.033382 1.041713 0.373911 0.727552 1.243913 0.903941 0.490310 0.740537 1.283136 0.552103 0.836137 1.517056 0.982154 1.204221 0.700619 0.731053 1.028913 1.761308 0.802787 1.014919 0.568395 1.728317 1.697728 0.205709 0.732883 1.364644 0.298250 -0.067315 1.045006 0.405782 0.167624 0.199764 0.056799 0.890582 0.707478 1.698550 0.383884 0.117404 0.152205 1.394758 1.518896 0.576114 1.270263 0.481537 1.343521 0.346128 1.282454 0.123770 0.510448 0.942235 1.324885 1.433364 0.923786 0.087041 1.558710 0.959553 0.778525 1.472891 0.405196 0.400417 0.765285 0.757399 1.510283 1.852251 1.951996 0.002908 0.028065 0.579141 0.359374 0.911688 1.051029 0.324790 1.587212 1.522967 1.479451 1.381737 1.319674 1.228305 0.591416 1.904388 0.426595 0.346042 1.933929 0.687662 1.984961 0.180460)
      )

;;; 104 even --------------------------------------------------------------------------------
#(104 14.290776635081 #(0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 1)
      14.080453047533 #(0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 1)

      10.782896 #(0.000000 0.876982 0.472655 1.568531 0.110662 0.706704 1.126772 0.792660 0.558247 0.237923 1.695003 1.875929 1.265467 1.551732 0.404022 1.469014 1.953305 0.549618 0.918215 0.412494 1.643077 0.509932 0.908864 1.028895 0.613640 1.285209 0.723711 0.234465 1.752639 0.588446 1.527525 1.243419 0.573785 -0.010596 0.766251 1.208321 1.945952 0.199876 0.704563 1.195347 0.321924 0.409317 0.453538 0.274016 1.699008 0.888299 1.017140 1.311764 1.139483 1.337266 1.488757 0.374101 0.945867 -0.015720 0.594544 0.462675 0.231926 1.364555 1.555165 0.993695 0.909359 1.121302 1.052939 0.540299 1.910287 0.566043 0.834556 0.879540 0.772056 0.622953 0.873846 1.210401 0.676098 0.063293 0.532588 0.571072 0.912420 1.481855 1.364528 1.586544 1.924310 0.069582 1.802799 1.024910 0.078502 1.465203 0.217289 1.179956 0.062264 1.368899 0.448634 1.249635 0.246437 0.137674 0.256024 0.257456 1.698478 1.369778 0.348761 0.105742 0.013448 0.959940 0.837687 1.651839)
      )

;;; 105 even --------------------------------------------------------------------------------
#(105 14.699862480164 #(0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 1 0)
      14.062 #(0 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 0 0)
      14.023490699521 #(0 1 1 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 0 0)

      10.923616 #(0.000000 -0.188078 1.419926 1.684107 0.965631 1.514098 1.010243 0.217423 1.347839 1.574887 0.724761 1.336465 -0.161827 0.930522 1.215482 0.910199 0.051336 0.871426 0.440962 0.216986 0.943782 1.595715 0.615689 1.702829 0.799026 0.301343 0.384998 1.715680 -0.119142 0.803887 0.411093 0.582550 0.068260 1.760555 0.297767 0.789939 0.346183 -0.212171 1.700623 1.532735 0.504537 1.138000 1.822230 0.777775 -0.029759 -0.207009 0.700671 0.062720 0.415342 1.433750 0.005311 1.622292 0.686466 0.591816 0.967753 0.273102 0.407126 0.526539 1.502177 1.519947 1.541489 0.030047 0.917045 0.326082 1.971120 0.460559 -0.003197 1.807481 1.291262 0.061340 0.253497 0.259335 1.370962 1.293166 0.755477 1.128548 1.417509 0.929135 1.005607 1.585048 1.746364 0.382599 0.374648 1.197742 0.073492 0.267949 1.428404 1.878362 -0.436782 0.357350 1.575220 1.590666 -0.214379 -0.146350 -0.000736 0.079344 0.640733 0.731485 0.859566 0.011051 1.393733 0.342468 0.269667 1.266284 0.520218)
      )

;;; 106 even --------------------------------------------------------------------------------
#(106 14.783208847046 #(0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 1)
      14.160224278203 #(0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 1)
      14.077123010357 #(0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1)

      10.917175 #(0.000000 -0.020270 0.602937 0.222316 1.224484 1.399447 -0.360723 0.368263 0.657525 0.336764 0.954569 -0.170916 -0.034143 1.251488 1.756518 1.072874 1.466951 -0.019378 0.940032 -0.017467 1.909674 1.527816 0.845014 0.358517 1.469083 0.134938 -0.193797 0.165476 0.486800 1.132643 1.157799 1.014175 1.284000 0.961321 1.857815 1.282628 1.497121 0.387489 1.480956 1.902670 1.346183 -0.017769 1.396548 1.352330 1.038013 0.567887 0.485950 1.094044 0.509452 0.687397 1.542184 0.535643 1.318992 1.221968 0.238271 0.286836 0.510819 0.718556 0.925876 0.742796 -0.109950 1.480681 1.343215 0.339148 0.268000 1.789913 1.681450 1.876026 1.564682 0.268516 0.220642 1.308392 1.593473 1.256566 0.848416 1.116725 0.214376 -0.128812 0.194371 0.141854 0.817797 0.005825 0.592648 0.459151 0.022325 1.663836 0.368171 0.277396 0.429997 -0.229967 0.718461 0.257532 1.132224 1.002313 -0.019592 0.727079 0.691713 1.004380 0.029267 0.637718 0.017112 1.694590 0.332071 0.720398 1.766714 1.317060)
      )

;;; 107 even --------------------------------------------------------------------------------
#(107 14.355038210217 #(0 0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 1)
      13.979104817741 #(0 0 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)

      10.984383 #(0.000000 -0.152094 0.059547 0.188062 1.464347 0.930518 0.805334 0.136506 0.653289 0.810316 1.016590 1.350205 1.062471 1.365776 -0.040707 0.168747 -0.360435 1.217765 0.796793 0.501059 -0.023068 0.201676 0.639920 1.454182 1.776554 0.764995 0.160142 0.443916 0.258445 1.439949 1.245770 0.069846 0.327019 1.297263 0.046010 1.025002 0.546804 0.019056 0.918599 -0.198693 -0.059162 1.433566 0.650644 1.648774 0.840623 1.338224 -0.050793 1.154837 0.354936 1.606216 0.303454 1.380701 0.830726 0.793835 0.676336 0.505892 0.609064 1.102733 1.628972 0.622668 1.284759 0.433754 0.973125 1.212800 1.582547 1.132732 0.166098 1.404639 1.016844 0.034917 0.547708 0.070346 1.893202 -0.058873 -0.419936 0.347566 0.239717 -0.374020 1.388217 -0.213160 -0.022898 1.698804 1.361983 0.962922 1.262343 0.835118 -0.250950 -0.005377 -0.177351 0.116565 0.534458 1.792348 0.158036 1.085272 0.655253 1.419734 1.808376 0.311913 0.472625 1.417744 -0.170900 0.167218 1.602412 1.549073 1.308728 -0.177534 1.223702)
      )

;;; 108 even --------------------------------------------------------------------------------
#(108 14.418597227362 #(0 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 0 0)
      14.367991447449 #(0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1)
      14.247987286758 #(0 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 1)
      14.201394892821 #(0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)

      11.025440 #(0.000000 0.137620 1.270331 0.547671 1.651636 1.800359 0.470230 -0.009984 0.578827 1.564259 0.737742 0.558220 -0.037596 0.340629 1.303561 1.441685 0.578298 1.095039 0.076458 0.317817 1.083218 -0.201176 1.667322 1.038980 0.301361 0.016612 1.755541 1.339749 1.953075 0.613173 0.026196 0.482632 1.888353 1.498480 0.357645 1.293544 1.125375 0.086167 1.200846 0.130468 1.084564 1.614785 0.404266 -0.151891 0.236679 1.444582 1.615027 1.890655 0.364250 0.117746 0.995436 0.605762 1.037725 1.333876 1.627617 1.219466 0.575251 0.986842 1.304136 1.017257 1.292254 0.210319 1.187018 1.438759 0.172349 1.829649 1.327150 1.512358 1.255259 1.506367 1.347959 0.645276 1.282971 1.180376 1.416226 0.557474 1.504593 0.180455 -0.025561 0.706271 0.517715 0.018052 1.779142 0.177796 0.999648 0.826868 0.653090 0.029840 1.521172 1.816438 -0.065832 1.905611 1.408653 1.658595 0.291957 0.514934 0.871404 -0.367574 1.654733 1.412154 1.455794 1.431943 0.582000 0.032751 1.110209 0.516903 0.787389 1.756878)
      )

;;; 109 even --------------------------------------------------------------------------------
#(109 14.988188773557 #(0 1 0 1 0 1 0 1 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 0)
      14.476561866583 #(0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1)

      11.080357 #(0.000000 0.028019 1.385169 0.551045 1.877288 1.178082 0.890218 1.468096 1.688391 0.574448 1.679398 0.989988 0.255230 0.353645 0.011570 0.495519 0.095241 0.596459 0.800116 0.830624 -0.205925 1.361043 1.668923 0.635633 0.010576 0.692029 0.913774 -0.194695 -0.133142 0.637371 0.293887 0.716553 1.318015 0.927686 1.182882 1.385639 1.120772 1.756045 -0.153107 0.482587 0.625687 0.706990 1.717195 0.380541 0.876243 1.716034 0.872746 1.898136 0.173074 0.842234 0.022673 0.477320 0.256951 1.552021 1.016401 0.252986 1.759658 0.195271 1.785460 0.972719 1.237507 1.061917 0.494492 0.679965 1.149537 1.052580 0.977901 0.264787 0.601074 0.346031 1.021214 0.028231 1.710202 1.329540 0.009363 0.000369 0.652698 1.376945 0.335377 -0.080909 0.416874 0.836626 0.868811 0.218483 0.563510 1.157062 1.560531 0.437612 1.434337 1.776773 1.024633 0.339376 1.737945 1.807289 1.535474 1.301844 -0.180557 1.531942 -0.298801 1.167455 0.373126 0.683662 -0.038534 1.852989 1.539931 1.583872 1.114205 1.286052 0.856273)
      )

;;; 110 even --------------------------------------------------------------------------------
#(110 14.433 #(0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0)
      14.401108392424 #(0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0)
      14.141825477743 #(0 0 0 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0)

      11.264678 #(0.000000 0.086579 0.435768 0.404194 0.209232 1.002452 0.019334 1.219506 -0.099053 -0.147591 1.734263 1.417977 0.022670 1.477881 1.693016 1.816308 1.732058 -0.089458 0.961672 0.270079 0.079363 1.198764 1.287581 1.431281 1.184072 -0.288572 1.726780 1.514642 0.423833 1.027127 0.993555 1.296829 1.205588 1.648938 -0.075800 1.827676 1.160324 0.671476 0.223050 0.316536 1.728766 -0.230378 1.185033 0.473895 1.308040 1.623971 1.562485 1.615960 0.937808 0.139189 1.123434 0.506696 1.206426 0.265525 1.342696 1.019616 0.861750 0.445470 1.258852 1.836940 -0.057756 0.161277 1.664928 1.421504 0.261843 0.314008 0.892725 1.607122 0.337861 1.883352 1.051641 1.012965 0.388075 0.709934 0.825684 0.037973 1.767022 -0.120025 0.325760 0.847556 1.122314 0.769465 0.487209 0.626925 0.697349 0.646028 0.961289 -0.198501 1.757493 0.360256 1.126718 1.206198 1.800220 1.130415 0.981099 1.479914 0.674563 1.214886 0.045112 0.500887 1.364208 0.068880 1.220625 0.488600 -0.091551 1.603021 0.817213 -0.130819 0.370657 1.381993)
      )

;;; 111 even --------------------------------------------------------------------------------
#(111 14.983455708572 #(0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 1)
      14.470418444168 #(0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 1)
      14.043108609984 #(0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 0 1)

      11.352599 #(0.000000 0.116660 1.224856 -0.122830 0.748305 -0.001119 0.154576 1.348855 1.456073 0.673697 1.501559 0.204183 1.639537 0.020981 1.581310 0.177181 0.785012 1.196960 0.868927 1.281096 0.145320 0.749957 0.926308 0.889619 0.553129 0.376409 0.924251 0.956329 1.264042 0.944787 1.127896 0.118295 0.583379 0.924143 0.345191 1.763680 -0.047715 0.994909 0.447404 1.042622 0.037723 1.902082 0.172661 1.200524 0.316130 0.378721 1.240188 1.493040 0.842223 1.682049 0.171602 0.658625 0.799765 0.095337 0.171771 0.515040 1.059407 1.552583 1.746932 1.037662 1.137068 0.702239 1.279191 1.223973 1.003273 1.099836 0.672532 1.704132 1.368043 0.192592 0.415758 1.761975 -0.159349 -0.019639 1.049293 1.355274 0.610782 0.918045 0.230614 1.328846 0.983906 1.510342 1.193444 1.376028 0.006275 0.227327 1.922932 0.580608 1.193579 0.721070 -0.150649 1.148572 0.009697 1.853400 0.532132 -0.239671 1.576488 -0.051160 -0.139567 1.284222 0.545047 0.723426 0.500505 1.402282 0.244187 1.737870 1.115701 0.795652 1.887009 1.382332 0.559525)
      )

;;; 112 even --------------------------------------------------------------------------------
#(112 14.939 #(0 0 1 0 1 1 0 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 0 0 0)
      14.53456401825 #(0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1)

      11.272767 #(0.000000 0.051407 1.449913 0.815039 -0.247395 1.894888 0.135215 1.734739 1.574803 0.333018 1.660963 -0.230904 1.310301 0.149694 1.246913 1.295904 -0.005130 1.247162 0.465397 0.477357 0.112919 0.367074 0.627775 1.122922 1.387257 0.071020 0.068372 0.958695 0.028224 0.815830 1.279549 -0.292702 0.888325 1.592315 0.839697 1.474407 1.353899 1.277123 1.049832 0.567424 1.186913 -0.237430 0.466577 0.931230 1.283886 1.447819 1.329942 0.070943 0.457980 -0.174091 1.219686 1.087580 1.288574 1.376982 0.986821 0.113938 0.555094 1.691609 -0.153112 1.609275 1.135504 1.427208 0.710478 0.926174 0.938214 0.749235 0.239576 1.308632 0.957322 1.000897 1.454815 1.501060 -0.142700 0.728746 0.832849 1.600161 0.792946 -0.055899 0.116487 -0.214609 0.345245 0.019788 0.084299 0.537430 0.164370 0.322796 1.531641 1.053375 0.871333 1.487825 1.865050 1.830536 1.168792 1.583405 0.613723 0.449161 1.671459 0.345038 1.622827 1.604659 0.857994 0.279642 1.305075 -0.412531 1.406254 0.577665 0.351164 1.348775 0.157800 0.228630 0.699176 0.181745)
      )

;;; 113 even --------------------------------------------------------------------------------
#(113 15.33184168793 #(0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1)
      14.840950350147 #(0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 0 1)
      14.699631659332 #(0 0 1 1 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0)

      11.197840 #(0.000000 0.032831 -0.151949 1.459331 1.037261 0.545797 1.064952 0.810528 0.881016 1.151321 0.361847 -0.224418 0.819474 0.300544 1.379751 1.163412 0.720437 1.274204 1.036741 0.377565 0.006302 1.529682 0.323519 0.523320 0.608174 0.791078 0.711727 1.387964 0.276082 0.369960 0.522663 1.867227 1.736637 0.806495 0.266058 0.330727 0.239937 0.752198 0.223914 1.599784 1.479003 1.501139 0.009397 0.526276 1.500737 1.722591 0.024441 0.365530 0.289827 0.404725 0.393720 0.776416 0.072951 0.005124 -0.256401 0.542473 0.682256 1.514513 -0.060480 0.676132 0.865634 0.874554 -0.239277 0.433998 0.836967 0.805597 0.630527 0.753348 0.268297 0.053274 1.652755 1.400283 1.316307 0.018921 1.802961 0.433304 1.130272 -0.222962 0.201316 1.276295 -0.052350 0.560144 1.169559 0.404032 1.334126 1.141575 1.455778 0.999738 0.479198 0.557918 -0.073777 1.253078 0.243729 0.993243 1.837011 1.123053 0.231415 0.353676 1.073381 0.474155 0.710191 1.736875 0.422119 -0.193122 0.923505 1.552547 1.279069 1.153091 1.327241 1.335265 -0.001927 1.280215 0.424508)
      )

;;; 114 even --------------------------------------------------------------------------------
#(114 14.84645338611 #(0 1 0 1 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1)
      14.794 #(0 1 0 1 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1)
      14.492 #(0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 0 0 0 0 0 1)

      11.336193 #(0.000000 0.976342 0.807757 0.077020 -0.091980 1.126465 1.017694 0.514901 1.805505 1.173066 0.454865 0.371659 1.127004 1.076680 0.531058 1.132428 0.250613 0.761511 1.030406 0.937991 1.067766 0.864505 1.917871 1.625569 0.606673 1.000715 1.274938 1.406650 0.255569 0.804630 0.325244 1.023087 1.225463 1.552360 1.222046 0.388515 0.414161 1.367696 0.317121 1.376516 1.597000 0.527046 1.894472 0.015683 0.339619 1.563157 1.223658 1.194787 0.111832 0.004020 1.133849 1.975429 -0.035206 0.619150 1.106109 0.117795 1.763922 0.851985 1.929020 0.583657 0.449023 1.592398 1.663011 1.833443 1.520046 1.385772 1.834234 1.488178 0.341591 1.196635 0.973305 1.765173 0.869048 1.731359 0.924318 0.761149 0.989732 0.854622 1.253146 1.484859 0.626765 1.819010 1.885333 1.544007 1.773917 1.786853 0.740825 1.148478 1.420263 1.965696 0.453324 0.069872 -0.034741 1.613138 0.280062 0.851344 0.397404 1.266347 1.619681 1.379232 1.345758 1.077447 1.858076 0.513050 1.194036 0.199195 0.617151 0.308353 1.507080 1.346863 1.167632 1.511382 0.876492 1.295429)
      )

;;; 115 even --------------------------------------------------------------------------------
#(115 14.597 #(0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)
      14.568 #(0 1 0 1 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)

      11.336669 #(0.000000 0.131668 0.807526 0.765579 0.926922 0.829819 0.272456 1.626793 0.912135 1.655648 1.164057 -0.651086 0.172413 0.024837 1.024046 -0.245468 0.266226 1.668463 1.737094 1.680458 -0.585481 0.224020 0.919972 0.584978 0.398223 0.477344 1.355324 0.430757 0.992372 1.422785 0.930557 0.479663 0.822936 0.239546 1.602630 0.011009 0.050533 0.089353 0.285765 -0.180657 1.660877 0.967937 -0.128932 1.169920 1.336222 1.591298 1.616615 0.952150 -0.128167 1.641333 1.197601 1.653725 0.746422 1.225761 0.722217 0.390699 1.161757 1.656922 1.010531 0.194501 1.954238 1.675178 1.545476 0.807426 0.819433 1.038829 1.106210 0.510705 1.058750 1.219853 0.157418 0.878275 0.763875 -0.103344 0.297161 0.917064 1.388005 1.377178 1.134858 0.439316 1.328089 1.011096 1.189134 0.175119 0.583958 0.926184 -0.475549 1.378393 1.055903 1.928068 -0.319320 1.779629 0.990142 -0.164108 1.620783 1.490498 0.789932 0.471553 0.891860 1.537358 -0.225926 1.543281 0.143643 1.148589 0.536778 -0.027654 1.096423 -0.058870 1.332826 -0.011047 0.327073 0.881777 0.342182 1.112725 -0.274916)
      )

;;; 116 even --------------------------------------------------------------------------------
#(116 15.190026349904 #(0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1)
      15.016979484255 #(0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1)

      11.554812 #(0.000000 -0.099546 0.210093 0.271796 0.945266 -0.202516 1.516235 0.285844 0.366341 1.445973 1.646259 0.500803 -0.273239 1.071021 1.101617 0.131558 0.690030 0.424078 1.003178 -0.156194 1.139602 0.136823 0.916693 0.528987 1.200950 1.326423 1.142588 0.044580 1.703847 -0.153206 0.799632 1.405376 0.791994 0.145270 0.627087 1.452423 0.032679 0.242990 0.542730 0.767705 -0.080417 0.338485 1.000792 1.723599 1.524458 1.216943 1.389297 1.319993 1.622342 0.700803 1.569558 0.189563 1.598526 1.377821 0.615793 1.432843 0.266853 0.732594 0.486152 0.301235 1.086052 1.692127 0.293852 -0.003212 0.163591 0.292203 1.069304 1.367801 0.806071 0.098842 0.077802 0.106775 1.714450 0.015546 1.386099 0.729046 0.535722 0.863453 1.080253 -0.245867 1.094589 0.875866 0.920702 1.571791 0.913568 0.309772 1.763491 0.558304 0.283324 1.142237 0.078030 1.437157 1.292859 0.405256 1.113065 0.791989 0.042677 0.604777 0.831165 0.074390 0.448017 0.088750 0.314730 0.170259 0.743369 0.672405 0.296165 0.881312 1.095075 0.538730 0.534840 -0.091445 1.613024 0.582462 0.284884 0.312172)
      )

;;; 117 even --------------------------------------------------------------------------------
#(117 15.56056534994 #(0 1 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 1 0)
      15.070538411179 #(0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0)
      14.875072951405 #(0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0)

      11.367327 #(0.000000 -0.089078 0.923184 0.030035 1.408257 0.432548 1.722135 1.422187 0.780502 -0.090631 0.874210 1.147780 0.015439 1.449688 1.341283 0.468218 1.345454 0.065053 0.556580 1.488244 1.914052 1.842443 0.989096 1.946666 1.115747 0.117316 0.441213 0.921624 0.427478 0.327394 1.146061 1.198562 1.821162 0.321937 0.235564 0.868025 0.310147 0.068408 1.211233 -0.510148 0.835051 0.469360 1.215964 0.851960 0.141147 1.171352 -0.351982 1.253455 1.458885 1.593598 0.123940 1.602636 0.086999 1.278181 1.236234 1.402873 1.222322 -0.179209 1.792934 1.424300 0.673502 1.001577 0.077987 1.451761 1.568866 1.601063 0.119873 1.191122 1.103597 1.591081 0.297764 1.436968 0.740445 0.671005 0.993624 1.090499 -0.232867 1.164071 1.205265 0.211384 1.612591 1.924339 1.345674 0.582851 0.825126 1.772285 1.598454 1.034017 0.460336 0.831808 0.536681 0.105772 0.106614 -0.086522 0.400784 1.341819 1.127608 1.667089 0.459324 0.973222 -0.068200 1.590699 1.411322 -0.095324 1.478759 -0.490877 -0.288663 0.152103 1.003756 0.819910 0.475957 0.436459 0.494438 0.707857 0.744038 -0.093921 0.202081)
      )

;;; 118 even --------------------------------------------------------------------------------
#(118 15.425480892646 #(0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1)
      14.841081077183 #(0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1)
      14.774983755641 #(0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1)

      11.580522 #(0.000000 0.272454 0.072194 0.112438 0.726119 1.387085 1.316497 1.225142 -0.000129 0.755275 1.654300 1.285919 0.954953 0.140307 1.790966 0.715206 1.779649 0.473245 1.551479 1.953221 0.842374 0.051912 1.507218 0.077813 0.705546 0.905654 0.348962 1.343550 1.090547 1.194801 0.089277 0.486157 1.339990 1.098021 0.736225 1.625149 1.747189 0.898053 1.522438 1.696856 1.556739 1.892769 0.200343 0.478381 0.401752 0.792808 1.383532 1.014662 0.190326 0.128818 0.142987 0.062943 0.203987 0.845226 1.660106 0.626075 0.783013 0.918996 0.420092 0.414297 -0.078496 1.120727 1.647131 0.210691 1.491449 0.866376 0.218421 1.797666 1.008287 0.809554 0.937820 1.039787 1.462421 0.511552 1.586311 1.114068 1.238635 1.264506 1.533693 0.235977 1.388899 1.009078 0.590504 1.330135 0.847089 0.505084 0.624415 1.144874 0.911694 0.574588 0.838409 0.746388 1.493677 1.976500 0.181384 1.011921 0.402340 1.672591 -0.086744 1.198619 0.744698 1.603836 0.520643 0.013256 1.266826 0.561537 1.091074 1.377329 0.808227 1.089342 0.835283 0.380000 0.372015 0.163149 1.482072 0.170882 1.444137 0.455834)
      )

;;; 119 even --------------------------------------------------------------------------------
#(119 15.519069915733 #(0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 0 1)
      14.971 #(0 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1)

      11.624828 #(0.000000 0.533412 0.755057 1.449196 0.241500 0.787023 1.916340 1.508530 1.753882 0.992508 0.500181 0.540710 -0.029018 1.396103 1.371851 0.780082 0.930284 1.126302 1.831825 1.359207 1.730636 -0.026436 1.547566 0.589030 0.788687 0.610258 0.913305 1.245277 1.570143 1.419146 0.969333 1.719219 0.451788 1.699506 1.758456 0.307915 1.175477 1.876769 1.872503 0.471294 0.458718 0.524774 0.932446 1.733885 0.049632 0.195670 1.465467 1.277496 1.452645 0.612129 0.002524 1.909484 1.870900 0.384388 0.855704 1.693821 0.784037 0.441377 0.851004 0.471175 0.118856 0.230779 0.380759 1.367738 1.483324 1.254738 1.343190 1.619830 1.034837 1.027189 0.951122 1.483967 1.807312 1.676196 0.931907 1.662723 1.751316 1.509109 1.093038 1.774714 1.292992 0.553042 1.120254 0.476619 0.800744 1.522744 1.052611 0.346224 0.822590 0.950176 1.909721 1.426464 0.731458 1.646603 0.600947 0.575633 1.639149 1.028894 1.316611 0.033768 1.483891 1.256029 0.638728 1.666187 1.378317 0.781756 0.666640 -0.044323 1.293318 1.917518 0.815270 1.717194 0.319031 0.365963 1.576591 0.794379 1.652048 1.012416 1.730394)
      )

;;; 120 even --------------------------------------------------------------------------------
#(120 15.824793168635 #(0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
      15.350 #(0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
      15.153992567168 #(0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)

      11.716736 #(0.000000 1.214109 0.973540 0.242616 1.863188 0.244822 0.640498 0.435130 0.501615 1.338416 1.114181 1.617334 0.411449 1.839894 1.692332 1.044300 0.916716 1.852041 0.924777 0.412916 1.378735 1.932834 0.743428 1.713757 1.875916 0.467622 -0.029618 1.810120 1.419702 1.117635 1.904126 1.759013 0.933597 0.315526 0.087875 0.615127 1.847519 1.758568 0.107528 0.594673 0.105855 0.211297 1.374533 0.376814 1.668849 1.858144 1.508610 0.213993 1.930464 -0.026996 0.193783 0.551532 0.373833 0.912404 0.125914 0.521992 0.226775 0.996096 1.080018 0.079363 0.445455 1.733394 1.631716 1.573025 0.180403 1.832035 0.813199 1.387804 0.892608 0.592189 0.448923 1.296905 1.750203 0.299596 1.740813 0.982003 1.410793 1.525224 1.802426 0.938338 0.427455 0.755862 0.097963 1.712263 1.529456 0.105312 1.386212 0.860440 0.278911 0.640922 0.014655 0.907849 1.103085 1.242198 0.530892 1.279909 0.733467 0.857276 1.607627 0.947468 0.661167 1.604747 0.466778 0.673940 1.688916 0.200087 1.950874 0.537359 1.883257 0.084664 1.720323 0.688043 1.263882 -0.036553 0.185950 1.655275 1.820289 1.918066 0.918637 0.760582)
      )

;;; 121 even --------------------------------------------------------------------------------
#(121 15.507 #(0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1)
      15.168510014453 #(0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1)
      14.652157793709 #(0 0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 1 1 0 0 0 1)

      11.579889 #(0.000000 0.073820 1.851099 1.644401 0.982878 0.503715 1.137184 1.917614 1.256715 0.833147 0.643132 1.886936 1.320488 1.229835 1.088871 1.471945 0.059522 1.149500 1.745892 1.912944 0.988149 1.899523 0.406048 1.687481 1.918115 0.492966 1.708855 0.109010 0.724915 0.104361 0.214291 1.563492 1.725392 0.495577 0.237627 0.318058 1.379604 0.550586 1.359822 0.025819 1.446041 1.333435 0.872460 1.675017 1.438119 0.156263 1.803227 1.506621 1.799032 1.433956 0.914303 0.230842 0.403307 0.485331 1.331971 0.253863 1.269382 0.025130 1.591179 0.314335 1.836264 1.557366 1.751121 1.574644 0.225523 1.946222 1.946303 0.664089 1.642443 1.727948 1.205837 1.260988 1.175158 0.530793 1.016538 1.946951 0.190105 0.417762 1.308140 0.820517 0.181344 1.366628 0.827680 0.446444 0.873684 0.824767 0.507906 1.654801 1.734090 1.149718 0.329337 1.257657 0.560670 0.897321 1.484032 1.139846 1.139833 1.523796 0.365728 0.290409 0.644325 0.064612 1.928856 0.569008 0.601857 1.246419 1.476175 1.749676 1.094622 1.365202 1.445915 0.134750 0.579236 0.688345 1.600320 0.925213 1.781567 0.037942 1.907240 0.634167 1.603064)
      )

;;; 122 even --------------------------------------------------------------------------------
#(122 16.162 #(0 0 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1)
      15.305 #(0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1)
      15.057187309653 #(0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)

      11.780487 #(0.000000 0.206402 1.499105 1.781993 1.650752 1.405649 1.707571 1.890346 1.056775 1.017893 0.199761 0.022254 1.913864 1.287626 0.375934 0.669295 1.779627 1.095392 1.263613 0.561949 0.145210 1.566429 1.501703 1.434701 1.921230 1.691969 1.588820 1.473944 0.735769 -0.044675 0.211582 0.013167 0.368903 1.614540 0.964100 1.023718 0.712032 0.456395 0.363723 0.928985 1.479425 0.219299 1.625897 0.463640 1.220886 -0.032833 1.876520 0.033587 1.341720 1.219447 -0.029568 0.507538 0.965637 1.689006 1.505882 1.381264 0.765761 1.585868 0.814260 0.716311 0.851525 1.087660 1.113178 0.075088 0.565879 0.789725 0.627423 0.980031 1.133609 1.394537 0.079015 0.569963 0.890601 0.691291 0.311638 1.230013 1.527790 0.671607 1.731510 1.352044 1.256598 0.353243 1.762184 1.281277 0.357382 1.530375 0.078640 1.717050 0.133443 0.515050 1.289083 0.710366 0.002787 0.742350 1.828681 1.670703 0.828690 0.077137 0.069733 0.655483 1.715541 1.091901 1.329331 1.107926 0.669540 1.266113 1.855361 0.642995 0.486418 0.377603 0.840297 -0.093306 1.420883 0.879091 1.591811 1.165620 1.606359 1.679163 -0.074501 0.993052 0.467588 0.974274)
      )

;;; 123 even --------------------------------------------------------------------------------
#(123 15.443287674437 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0)
      15.448 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0)
      15.332496766406 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0)
      15.156582832336 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0)

      11.752630 #(0.000000 0.095520 -0.071752 -0.018757 0.995322 1.260068 1.358835 -0.301907 0.355249 1.224362 1.694883 0.654601 1.308303 1.790521 0.265046 0.952535 1.115658 1.553119 1.515673 1.142790 1.309587 1.686243 0.968235 0.254062 1.384339 0.057281 1.298511 0.866995 0.313500 1.064948 1.550167 1.310069 0.424948 0.733753 0.449726 1.284121 0.777868 0.330778 0.323261 1.141177 0.604956 1.160640 0.537399 0.803269 1.505737 0.340206 1.096242 0.194024 1.577502 1.972771 -0.260749 0.410474 1.654560 -0.078448 0.892993 0.410334 0.682510 1.789213 1.829302 1.713451 0.867396 0.490942 -0.098226 1.219275 0.219254 0.274363 0.674877 1.042917 1.272298 1.555335 0.893201 1.358387 1.122174 1.658519 0.233637 1.059231 0.724638 0.404947 0.407576 1.393149 0.567525 1.003205 0.484998 0.295273 0.944873 1.761183 0.571360 1.350717 1.328329 1.640248 1.902025 1.516821 1.287209 1.038399 1.214113 1.220127 0.806696 -0.199599 0.454603 0.216377 0.671219 0.900993 1.596257 1.466654 1.425869 -0.222261 -0.722849 0.133322 0.132036 0.097118 1.717439 1.308896 0.542800 1.960744 0.756146 0.210711 -0.056818 1.498092 -0.395225 0.620217 -0.283048 1.014557 0.969790)
      )

;;; 124 even --------------------------------------------------------------------------------
#(124 15.877207326383 #(0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1)
      15.402028019163 #(0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 0)
      15.192802705519 #(0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 0)

      11.839819 #(0.000000 -0.040363 -0.148804 0.466434 0.720402 1.197666 -0.187016 -0.065300 1.145482 0.769511 -0.333682 0.975677 0.103159 0.302354 0.223434 1.257854 1.770338 1.134584 1.286555 1.077643 1.866275 0.063390 0.045616 0.652976 1.129710 0.042928 0.055166 1.207591 0.952009 0.759692 -0.499334 -0.183466 -0.217155 1.649612 0.998533 1.244104 0.236380 0.653951 0.017490 -0.083429 0.619956 1.620611 1.413208 0.943748 -0.184029 1.526915 0.696378 0.727657 0.067891 -0.131449 1.020399 0.764432 1.134914 1.657530 0.064850 0.931337 0.558196 1.725783 0.192755 0.714037 0.329448 0.011489 1.481193 1.440870 -0.063181 1.566751 0.183842 0.326251 0.396279 0.232529 0.028344 -0.109599 0.075839 1.085481 0.122608 -0.078349 1.784806 1.298974 1.655252 1.145739 1.170936 -0.061052 1.082564 1.820766 -0.138146 1.153226 0.010729 1.353884 0.341123 0.655730 -0.143566 1.663660 0.346673 0.332914 0.390646 0.155158 0.662140 1.921188 1.235634 0.396903 0.162639 0.863155 -0.212428 0.989654 1.277835 1.396339 1.426358 0.543658 1.382377 0.799274 0.409308 0.691840 1.623298 0.738691 -0.197350 0.039945 0.720458 1.365907 1.102908 1.357707 1.218828 1.486592 -0.121101 -0.255238)
      )

;;; 125 even --------------------------------------------------------------------------------
#(125 15.874541816027 #(0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0)
      15.743360519409 #(0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0)
      15.340427254326 #(0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0)

      11.819368 #(0.000000 0.132932 0.519769 0.384408 1.640741 0.008561 0.003167 1.914348 -0.010978 1.414509 0.318990 0.305585 0.558008 0.696805 1.810547 0.121313 1.459490 1.880044 0.707632 1.311850 0.883171 0.602166 1.869090 0.904844 0.760472 0.173884 1.732661 0.880106 0.304943 1.341958 1.483380 -0.046509 1.205815 1.230501 1.288943 1.246755 0.734353 1.163718 0.820833 1.127427 1.433147 0.864174 1.193160 1.128332 1.210656 1.833532 0.214163 0.221520 0.157221 1.476063 0.574496 -0.001217 1.704242 1.820307 0.841607 0.137697 1.179794 1.661571 0.090002 0.479471 0.875723 -0.050504 1.536359 0.590033 0.337855 1.323720 1.497408 1.512190 1.297344 0.139217 1.927238 1.320481 1.797319 0.762536 1.923754 0.369563 0.103518 0.971659 0.213443 0.706417 1.960143 1.889098 0.282118 0.234137 1.689917 0.481657 1.406670 1.206102 1.452664 0.849928 0.087627 0.210119 1.643508 0.056392 1.265387 1.845248 1.403098 0.637307 0.571891 1.436490 1.852523 0.886616 1.440911 1.509306 0.387147 1.211639 1.828917 1.872675 1.642380 0.693824 0.552134 0.273373 1.738049 1.552828 1.553310 0.211996 1.013127 0.392357 0.837457 1.068275 1.529918 1.377346 0.032434 1.608314 1.781380)
      )

;;; 126 even --------------------------------------------------------------------------------
#(126 15.964 #(0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1)
      15.680 #(0 1 0 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1)
      15.28212621738 #(0 1 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1)

      11.981489 #(0.000000 1.759580 0.812129 0.624304 0.566780 1.308717 0.698292 1.059536 0.470883 0.321806 0.835015 0.684153 1.313056 0.463398 1.827502 0.266140 1.330084 -0.131507 1.514545 1.352849 0.000421 0.578355 1.703308 0.668670 1.424553 0.458625 1.810644 -0.006831 1.337845 1.396747 1.155488 1.293575 0.958769 0.681254 0.616510 0.143654 1.159214 1.427513 0.764517 0.164921 0.630199 0.604095 1.326819 0.198431 1.858330 1.572882 1.888367 1.606744 0.560094 1.870762 1.801132 -0.048607 1.677825 1.588309 0.889779 0.398133 0.191113 1.087970 1.331897 1.796077 0.880632 1.772894 0.116160 -0.015816 1.522727 0.526901 1.815368 1.617744 1.083861 1.395342 1.413306 1.266373 0.462935 1.856084 0.631269 1.843259 0.722898 1.798762 1.747946 1.721207 0.327204 0.516225 0.545394 1.143285 1.419590 0.528506 1.734013 0.398537 1.430940 1.705075 0.625070 0.724675 0.925781 1.251588 1.179527 -0.006208 1.091450 0.927772 1.565111 1.890145 0.397625 0.169497 1.892073 0.673268 0.614815 0.688411 1.727956 1.731632 0.745992 1.044553 1.860638 0.249338 1.145311 0.205723 1.680228 0.903032 1.833842 0.001850 0.337707 0.179480 1.824941 0.153862 0.209796 1.475500 0.630128 0.510463)
      )

;;; 127 even --------------------------------------------------------------------------------
#(127 15.859804776319 #(0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1)
      15.609939955803 #(0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1)
      15.237931718393 #(0 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)

      11.890763 #(0.000000 0.458749 1.749450 1.687514 1.016224 0.989052 1.523365 0.801064 1.303795 1.843371 1.218774 0.782920 1.019339 0.052705 0.919146 0.388051 1.104343 0.396039 0.904733 1.616389 1.279941 0.742326 0.352710 0.857609 0.778242 1.598129 0.417990 0.590723 0.462229 0.792101 1.268861 0.038266 1.771945 1.754586 0.065717 0.340380 0.734340 0.959151 1.113260 0.363531 0.582118 0.175756 1.108394 1.431874 0.472706 0.695752 0.963409 0.011926 0.246502 1.603010 1.272849 0.940044 1.131777 0.279380 1.897333 0.495070 0.154432 0.544735 0.607190 0.848938 0.957465 0.077668 0.327914 0.919255 0.733465 0.293286 0.304721 0.752845 1.302332 0.591541 1.234956 1.570937 0.187149 1.892202 0.529048 1.888388 1.495803 1.692245 0.615962 1.545273 1.222402 0.118169 0.750489 0.687320 1.422791 0.751249 1.485122 0.709744 0.821414 0.365460 0.639859 -0.048567 0.128752 0.627192 1.562718 0.741697 1.720292 1.599138 0.745986 1.014315 1.368700 0.628052 0.728893 1.664279 1.419260 1.133309 1.699294 1.738610 1.496140 0.768472 0.622309 0.228663 1.469828 0.912153 0.122645 1.255160 0.180207 1.435237 1.590695 1.065826 1.546576 0.191968 0.168216 1.960513 0.585560 0.102158 0.135673)
      )

;;; 128 even --------------------------------------------------------------------------------
#(128 16.159544533014 #(0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0)
      15.889096531102 #(0 1 0 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 0 0)
      15.651492555885 #(0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0)

      11.924285 #(0.000000 0.109665 1.317315 1.796821 1.102576 0.209714 1.429092 1.131177 1.632417 0.966021 1.116961 0.052303 0.090987 0.080054 0.153226 1.910519 0.650221 1.205455 0.796371 1.680404 1.324668 1.168423 1.543195 1.540649 1.032872 1.216185 1.084492 1.453686 1.218606 1.444556 0.722373 -0.021981 0.418465 0.262843 1.497292 0.790517 0.462382 1.671733 0.890182 1.811409 0.508111 1.763295 0.516824 1.844375 1.536793 1.096719 1.226496 1.023038 0.738468 -0.077559 0.652748 0.394924 1.810496 0.693811 1.884456 1.227656 0.137799 0.811031 1.317856 1.488722 0.514136 0.557669 0.617495 1.885049 0.019323 0.075940 1.174495 0.234454 0.504330 0.475161 1.878223 1.591307 0.735319 1.822467 0.361879 0.475946 0.592216 0.265050 0.510642 1.681811 0.781668 1.165399 0.943794 1.048444 1.529324 0.036645 0.349053 0.428286 1.229153 1.269157 1.815565 1.975277 0.352218 1.148288 1.567194 0.323287 1.522447 1.595460 1.832890 1.642795 0.933111 0.720727 0.420462 1.662569 1.281865 0.923440 0.357080 1.588237 0.247829 0.671429 1.456496 0.329349 1.281397 1.773469 0.592644 0.624894 1.183835 0.352162 0.520907 0.046490 0.462735 0.609191 0.251018 1.189099 0.342916 0.670611 1.685277 1.329707)
      )

;;; 256 even --------------------------------------------------------------------------------
#(256 24.434719362486 #(0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1)

      21.147051 #(0.000000 0.013043 0.920117 0.211418 0.668306 1.385627 1.906635 0.858012 -0.025540 1.212427 1.778724 0.580100 0.439691 1.356157 -0.119063 0.434266 0.154352 0.442955 -0.005968 1.535794 1.403556 0.183703 0.719695 0.808134 0.717026 -0.004795 0.750023 0.510510 -0.111539 0.030727 1.471914 0.702448 0.847566 0.053362 -0.108798 1.030415 0.581323 1.534487 0.340353 1.468027 1.258297 0.652253 -0.177908 1.046447 0.259688 1.647334 1.350135 0.131395 0.878222 0.018247 1.361793 1.595723 -0.194803 1.278955 0.422974 0.308531 1.680151 0.819388 0.650454 1.170154 0.982131 0.916385 0.251795 0.614215 0.058138 0.237243 0.480617 0.078361 0.274005 1.104676 -0.049561 0.890974 0.285114 1.560285 -0.042858 1.287080 0.986201 0.225144 1.911656 0.412797 1.906001 1.113150 0.002975 0.378566 0.185842 0.978524 0.886147 1.174987 1.402841 1.532148 0.452840 1.653473 1.368866 1.142209 0.399142 -0.053477 1.387350 1.063119 1.101594 0.660387 0.318690 -0.075495 1.596588 1.423152 0.699488 1.066220 0.932593 0.726316 0.721243 0.616117 1.231920 1.204386 0.280095 0.737486 0.246794 1.225672 1.938762 1.669744 1.911752 0.028184 0.352670 1.169110 1.138933 0.911609 1.153860 1.295188 1.451568 1.222645 1.836765 0.315515 1.661130 0.665886 1.423539 -0.027924 1.624245 0.211892 0.318464 1.015468 1.652245 0.240743 1.150550 1.257988 1.368042 0.690738 1.931274 -0.034743 0.771903 1.856503 0.683190 0.957751 0.409827 0.925581 0.140171 0.602555 0.465835 0.338671 1.281554 0.705219 1.397775 1.170389 0.382381 0.242999 0.668790 0.700098 1.973505 0.627343 0.670404 0.886476 0.982946 0.759522 0.694097 0.252884 0.859515 1.570045 1.546775 0.284098 0.314092 0.168123 1.469812 1.098694 0.268268 1.420670 1.272723 0.382719 0.671480 1.435402 -0.110241 0.561019 1.353828 1.506014 0.931446 1.044498 1.647818 0.262634 1.666668 0.124893 0.309225 1.239534 0.520530 1.500534 0.061664 1.274884 -0.244216 1.650214 0.424051 0.892559 0.202169 0.442374 0.683088 1.684786 1.219867 0.391490 1.016231 1.491883 1.765165 1.764702 1.283017 0.934137 0.230333 1.283241 -0.045685 1.411918 1.307833 1.725023 0.245397 0.538120 1.457284 0.616433 0.168907 0.521502 0.384247 0.974783 0.364292 0.076939 -0.235106 1.283357 1.428764 1.664927 0.374574 1.099794 0.852722 1.803641 0.274149 1.335009 1.914350 -0.207888 0.073165 1.428393 1.365955 1.849232 0.634655 0.268387 -0.166276 0.397839 0.357434 0.489122)
      )

;;; 512 even --------------------------------------------------------------------------------
#(512 35.776 #(0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1)

      31.628149 #(0.000000 0.193458 0.879636 1.705304 0.490370 0.075082 0.075683 1.300845 1.564891 0.673316 0.757185 0.241756 0.594649 0.885118 0.323693 1.454812 0.908273 1.351061 1.781313 0.564771 0.183286 0.637926 0.622421 1.045142 0.517278 0.296784 1.410403 0.602065 0.772561 1.389650 0.527960 1.708369 0.033642 1.830155 1.178018 1.593299 0.764263 1.671821 0.206173 1.235732 1.402783 1.788135 0.201137 0.539609 -0.025782 0.918770 0.935892 0.891239 1.913603 1.292613 -0.101151 0.722659 0.055747 -0.088554 0.598806 0.380559 1.211892 1.546048 0.916625 1.399887 1.565523 0.904754 1.010130 1.643551 1.461234 0.875915 0.213846 0.357475 1.186241 1.381267 0.754949 1.779095 1.006740 1.311595 1.737320 1.086140 0.608280 1.768795 1.226748 0.139423 0.844731 1.174543 0.052337 0.835236 0.709458 1.432591 0.165398 0.442884 0.896570 1.597184 1.133267 1.895467 1.175626 0.109893 1.094502 1.928908 -0.087649 1.565508 0.274473 0.027155 1.554166 1.239019 1.373234 1.458458 1.546571 0.031108 1.855623 1.647770 1.494922 1.630144 0.041700 1.725269 0.114205 1.279109 0.713125 1.361675 1.293302 0.370706 1.155957 0.160127 1.306020 1.564145 0.329533 1.577490 0.426179 0.865540 0.506954 0.836528 1.895468 1.155187 1.524271 1.949386 0.062295 1.616901 0.556622 0.305661 1.919946 1.844259 0.313013 0.024129 1.635243 1.597075 1.722121 0.294542 1.002701 1.459972 1.504069 0.899408 0.331782 0.396363 1.663102 1.290621 1.116303 1.021895 0.255551 1.181969 0.645937 1.543659 1.606428 0.192360 0.894664 -0.002504 0.398536 1.481294 0.918465 0.074277 0.749762 0.689678 0.975924 0.653357 1.294427 1.063153 0.441398 0.872255 0.882166 0.959648 1.175046 1.530354 0.796278 0.915558 0.628151 0.260515 1.245714 1.010362 -0.030800 0.853342 0.047830 1.010196 1.020267 0.045034 1.849312 1.096281 0.221294 1.343819 1.249551 0.337281 0.664846 1.064716 1.335370 1.464875 0.181615 -0.072256 0.046603 1.522391 0.275503 0.681141 1.127342 0.430827 1.110432 1.803612 0.451171 0.807526 0.146612 0.741306 0.879652 0.538416 0.789395 0.835580 0.727230 1.500085 1.242144 0.634364 1.803171 1.822514 0.007316 0.582259 1.098006 1.111451 1.052686 0.268482 1.292779 0.408770 0.900978 1.129338 1.119845 0.000211 0.183560 0.409985 1.130318 0.154686 0.903140 1.250848 0.304084 0.291391 0.665312 0.134932 1.031483 1.180817 0.740031 0.591860 0.493782 0.623373 1.760510 1.738938 0.012331 1.868767 0.485398 0.081272 0.744972 1.162890 1.398893 0.348679 1.033764 1.570188 1.891519 0.983723 -0.050025 1.963561 0.683179 1.444931 1.720623 1.922344 1.346126 0.185147 0.425063 0.833788 1.212862 -0.059036 0.979852 1.030316 0.907000 1.585882 1.726983 1.272771 0.520458 -0.246594 0.841441 0.243286 0.398740 1.568681 0.966791 0.492237 1.295293 0.553432 1.719542 1.511716 0.828907 1.018781 1.032010 1.199895 1.666214 1.226917 1.062734 1.392689 0.232672 1.537926 0.453832 1.574299 1.015965 1.273439 -0.120286 1.196312 0.890951 0.947130 0.079812 0.887578 0.233129 0.272637 1.660534 0.099048 0.112940 0.379953 0.313779 0.871859 0.259424 0.974751 0.544740 0.642333 0.302637 -1.970061 0.729276 1.344147 1.146828 0.710229 0.621069 1.365003 1.840156 1.310442 1.151197 1.477337 0.559900 0.108648 0.736983 0.902099 0.115156 1.417090 0.059287 0.355397 1.408677 1.265478 0.852907 -0.030095 0.935670 1.092577 1.649094 -0.066605 0.057334 0.214826 0.920179 1.511506 0.311621 1.288626 0.990573 1.623492 -0.026333 0.306924 1.579035 1.170370 1.732023 1.379262 1.454543 0.891698 0.314877 1.693038 1.768550 0.910599 1.712155 0.945812 0.118254 1.453481 1.939489 0.720326 0.426107 1.203759 1.574972 0.592306 0.975781 0.305093 -0.166629 0.079805 0.409358 0.854323 0.437473 1.528093 0.769890 0.423876 1.508832 1.226392 -1.878260 -0.092214 1.155334 0.010793 1.006280 1.091219 0.386780 0.322578 0.667815 0.434221 1.551779 1.471623 0.419732 1.605348 0.905476 0.713039 0.202928 1.354968 1.929707 0.296628 1.021984 1.535443 0.083646 0.013591 1.615944 -0.015945 1.228774 1.545535 0.273210 1.194157 1.343078 1.185077 1.122175 0.433956 0.758581 0.690958 0.339400 1.730253 0.001977 1.448248 0.615799 0.047214 0.859970 0.772423 1.342656 0.293016 -1.937301 1.859989 1.689477 1.784597 1.602245 0.845767 1.643665 -0.004067 0.091824 1.211465 0.680110 0.230715 0.070609 1.607121 1.378560 0.381059 0.163719 0.922614 0.053089 0.596216 0.562829 1.081319 -0.048350 0.527026 1.238211 0.277364 1.357698 1.757117 1.384714 1.522857 1.368884 0.056972 0.225257 0.823227 0.584976 -1.935447 0.491177 0.763213 1.717924 0.488438 1.535602 0.456160 0.375383 0.517346 1.517261 0.749545 1.085532 0.050128 1.339560 1.741740 1.301265 1.630336 1.618351 1.672383 1.593969 0.959235 0.695771 0.230646 1.678169 0.693007 1.099661 1.490070 0.420988 1.438392 0.212033 1.272969 1.845317 1.413990)
      )

;;; 1024 even --------------------------------------------------------------------------------
#(1024 51.895 #(0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0)

       51.627202 #(0.000000 1.029633 -0.012293 0.012880 0.026980 0.979853 0.999814 -0.000026 0.008393 -0.008618 -0.022589 0.994746 0.002832 1.008481 0.003050 0.997875 0.996213 1.012876 0.966656 0.015767 1.000358 -0.002088 0.014429 0.990790 0.013957 1.001392 -0.004078 0.967774 1.013049 1.007123 0.985283 0.013699 0.971495 0.995694 1.026385 0.974549 0.984726 0.014450 1.020521 1.057512 -0.000030 1.035989 1.011331 -0.003193 -0.024617 1.040479 0.999058 0.999748 1.023188 0.015959 0.999918 -0.018936 0.999973 -0.023246 -0.020062 1.051671 0.022658 0.002794 0.974167 0.991086 1.010851 -0.001529 1.001922 1.036863 0.021006 0.005011 1.000699 0.000936 1.014853 0.987112 0.961076 -0.027263 -0.000447 0.965279 -0.006262 -0.009089 0.013976 0.015081 0.978343 0.998354 -0.031203 0.998879 0.993033 0.003160 1.007951 -0.029531 0.037120 0.015294 -0.004457 0.999168 0.006669 0.003518 -0.020636 0.989249 1.037455 0.983981 1.009819 0.041730 1.025735 0.004988 1.017361 0.003502 1.042945 0.015924 1.024463 0.960856 0.011509 0.010562 0.988670 0.024436 0.966800 -0.002597 -0.016676 0.022567 -0.028052 0.946179 -0.017664 1.028163 1.003919 0.001928 1.027279 -0.018987 0.026212 1.037909 0.988421 0.989442 0.020639 0.966655 1.036646 0.002339 0.008427 -0.005614 0.995024 0.983470 0.983405 0.042460 0.974342 0.994593 0.956085 0.009439 0.014059 0.004228 -0.019889 0.026260 0.974355 0.992867 -0.012583 0.984210 0.977740 1.012509 0.987531 0.000750 1.019558 0.026047 1.016442 1.035160 0.993711 -0.030273 1.002476 -0.005058 1.000699 -0.013934 0.956348 1.046660 -0.027964 0.032912 0.003031 0.977465 0.004538 0.989628 0.963685 1.010626 -0.012712 1.018052 -0.017753 1.015077 0.998898 -0.009983 0.997626 0.017615 -0.000785 0.002492 -0.012174 0.002126 -0.016138 1.012447 0.997926 0.966007 -0.013935 1.029393 -0.013026 -0.007371 1.016575 1.007787 1.056292 0.973143 -0.033484 0.035206 0.014191 -0.029943 -0.028705 0.008654 1.000375 -0.021321 0.995735 0.005904 -0.005691 0.957727 0.987992 -0.036335 0.960456 -0.001191 1.023020 0.989914 0.968869 0.041460 0.977261 -0.011659 1.009737 -0.021828 1.008003 -0.001250 0.022942 -0.048050 -0.009089 1.009767 1.043325 1.003191 0.971106 -0.021518 1.028051 -0.011409 1.025024 0.979361 1.044646 1.011438 1.010722 0.031823 -0.028157 0.983741 -0.020268 1.009392 -0.007202 0.998145 -0.026679 1.026788 -0.081497 1.010086 0.018136 -0.018995 -0.001939 0.022706 -0.023740 -0.007240 -0.012899 -0.018640 1.038529 1.020417 0.968369 0.994357 1.027397 0.000794 -0.000991 0.991696 0.031240 0.998445 1.044540 0.970462 0.026110 1.010814 1.020783 0.015899 1.018002 -0.031991 0.007949 0.001502 -0.012758 1.001363 0.004017 -0.007267 0.010560 0.013211 -0.009000 0.009694 1.014273 0.018818 -0.034834 1.028054 -0.003934 1.000986 1.002141 0.992753 -0.028723 1.028360 0.987299 -0.013088 0.996655 1.026438 1.006617 -0.029586 0.003482 0.997825 0.977397 -0.001844 0.989263 0.017137 -0.018305 -0.000071 0.035462 -0.000083 0.020862 0.961786 1.014986 -0.009066 0.004347 0.961092 0.991390 1.004558 0.027069 0.984372 -0.023434 0.988090 0.035406 -0.013962 1.041369 0.024094 0.005763 -0.024629 0.999857 0.043759 0.025275 0.984999 0.997705 0.974194 0.991177 1.004969 0.984649 0.030149 0.982526 0.026091 0.008305 0.993917 0.948422 -0.015968 0.018284 1.030583 0.048958 1.046400 0.020097 -0.041524 0.961135 0.980055 1.003964 1.036523 -0.038536 0.993082 -0.008009 0.037197 0.005452 0.985760 1.009046 0.989319 -0.023085 0.000904 0.027545 -0.000386 1.003513 -0.003653 0.001093 1.022776 0.997472 1.001837 0.009261 0.012077 0.942776 -0.005592 0.975448 0.004766 0.991773 0.016776 0.978178 -0.007370 0.982051 0.960966 1.011421 -0.023355 0.980278 0.973420 0.045377 -0.005290 0.956521 0.992809 0.027688 0.025117 -0.022656 -0.030804 -0.015162 1.036309 -0.026387 0.983041 -0.021172 0.035189 -0.027150 1.004452 0.027891 0.011484 0.034644 0.978769 0.023693 0.998483 0.986597 0.987475 0.010519 0.029762 1.001533 0.993668 -0.016914 1.024557 1.048005 0.011502 1.011339 0.994209 1.017864 0.992986 0.014354 -0.013499 0.992949 -0.060393 -0.016525 1.005615 0.984517 0.995298 0.015187 1.030776 -0.033503 0.000253 0.037666 1.025964 1.007485 0.988947 0.022461 0.006082 -0.020616 1.004962 0.012512 0.962994 -0.004937 1.011421 1.041467 1.008283 0.995643 0.971042 0.987471 0.001468 -0.007697 0.991715 1.049958 1.012746 1.035164 -0.032069 1.013038 0.006264 1.006054 0.035898 0.032052 0.963860 1.014151 0.949502 0.999608 0.009928 0.001465 1.029049 1.025787 1.026326 -0.043190 -0.007875 0.009982 0.011519 0.983107 0.005975 1.006135 -0.001058 -0.024465 1.034626 0.978896 1.011989 1.027524 1.041145 -0.025044 0.018773 0.023996 -0.011560 1.024837 -0.013806 1.002818 0.015362 1.050348 0.022866 0.962501 0.984475 0.010984 -0.010308 0.952987 0.024839 -0.026681 1.012307 1.001104 0.036619 -0.025891 0.014527 0.990542 0.011253 0.024178 1.008209 0.016545 -0.034511 0.036489 -0.014980 1.008478 0.989790 0.976929 1.025218 0.995142 0.987581 0.028634 0.033934 0.019969 -0.021838 1.028720 -0.028955 1.015472 -0.006441 -0.020510 -0.018391 0.978147 0.015688 -0.021362 0.952391 0.029016 0.001211 -0.008983 1.017301 0.981964 -0.001380 0.985470 0.022753 -0.004467 1.038918 -0.047590 1.013576 0.992650 1.023843 0.035368 0.026779 0.037419 1.014741 0.995189 0.997746 -0.034357 0.995854 0.003107 0.951826 -0.014409 0.013970 1.057036 -0.046316 0.969485 1.013522 -0.031630 0.992596 0.019914 -0.030536 0.998738 1.009072 0.042841 0.007827 -0.040331 0.996280 0.005153 0.977472 1.017287 -0.007443 1.023492 1.008942 0.976506 0.991476 0.021767 0.994859 -0.020314 0.017953 0.030219 -0.014664 1.027291 0.995978 0.994587 0.009074 0.983176 0.979563 0.026420 -0.010245 0.972168 1.035690 0.001320 0.993513 -0.006353 0.993098 1.018795 1.026884 1.026658 0.970022 0.999193 1.016983 0.979543 -0.022890 0.020692 -0.040886 1.018579 -0.011065 0.055122 0.983881 0.025346 -0.040047 1.013370 0.955646 1.036308 0.991315 0.033330 -0.025327 0.016975 0.995791 0.981244 0.961974 1.008112 1.057891 -0.001461 0.987480 0.009720 -0.026757 0.013022 0.980104 0.999666 -0.012002 -0.002490 1.031008 -0.036579 -0.019712 -0.012903 0.988206 0.016822 0.004518 1.021480 1.018658 0.022505 -0.040063 0.965796 0.967095 -0.030506 0.986755 0.009185 -0.029252 0.027913 -0.001038 0.005149 1.030725 -0.022649 -0.050486 0.985861 1.023283 -0.035330 -0.003861 -0.024807 -0.017869 1.007192 0.991993 -0.037209 -0.015099 1.024263 0.988398 1.000630 -0.011148 1.011225 1.003859 1.000624 0.027737 1.030697 -0.007960 0.015120 0.030404 1.063288 -0.015487 0.009610 0.997903 -0.014983 0.009095 0.001637 0.028463 -0.017241 0.980929 1.031302 0.957184 1.006390 -0.000930 0.026429 -0.035760 -0.008466 0.002222 1.003563 0.029085 0.031352 0.955169 0.956096 1.049753 1.023909 0.993320 1.004337 0.981836 0.009217 0.959911 0.028388 0.983865 -0.035427 -0.010471 -0.031064 -0.002590 0.956357 0.036784 -0.009809 0.991834 -0.034104 -0.018459 0.012906 0.991005 0.022404 1.021742 0.004101 -0.003005 0.999319 0.002777 0.970118 0.020836 -0.025284 1.027935 -0.012000 -0.004879 -0.034122 0.007932 1.021494 0.992149 1.020224 0.016422 1.035923 1.005921 0.970291 1.017378 1.005947 -0.036189 -0.030483 0.001790 0.032815 1.014774 0.983789 0.988084 0.023220 -0.019774 0.971264 -0.028081 -0.029889 0.992294 1.005999 0.977060 1.014232 -0.021160 -0.010988 0.959821 0.005604 0.021718 -0.021955 1.054722 -0.016545 0.964984 0.985050 0.984349 1.031167 0.974286 0.002534 0.035348 -0.012068 -0.013231 1.015785 0.023828 1.015996 -0.031622 1.005232 -0.009273 -0.019787 1.025036 -0.026464 0.006101 0.967905 1.014269 0.979093 -0.029265 -0.021119 1.021888 0.954078 0.000085 0.002622 0.994485 1.000089 0.999748 0.998280 0.023211 0.988740 -0.018255 0.960366 0.045586 -0.019498 0.008522 1.020829 1.008354 0.006514 1.022643 0.015185 0.000755 0.018782 1.014301 0.027370 -0.012785 1.014767 0.991316 1.003698 1.039078 0.005598 0.005237 1.002700 1.029163 0.004849 -0.028907 -0.023045 1.017953 0.020296 0.006471 1.017652 -0.022322 1.034186 1.027202 -0.016734 1.002485 0.047223 0.040688 0.006990 0.990955 0.022236 1.031053 -0.003084 1.020609 0.017659 0.020197 0.011235 0.962757 0.001996 1.044123 0.976238 -0.019950 1.030412 0.011057 1.017582 0.014033 0.025446 1.004206 -0.003240 0.027075 -0.007050 -0.035685 0.992859 1.011519 0.014202 0.981388 1.005139 1.004029 1.006912 1.005778 1.021140 0.983053 -0.016137 -0.014145 1.000304 0.997530 1.003746 1.049578 0.959733 0.000454 -0.009718 -0.026521 0.029837 0.007222 1.010987 0.005317 -0.030318 1.007035 -0.032687 -0.011029 0.989009 1.041889 0.982391 -0.018390 0.038156 1.006608 0.000964 0.020590 0.018089 1.004892 1.001298 0.040112 1.005506 1.015600 -0.009035 0.940825 0.000076 0.006269 0.006741 -0.012462 -0.037129 0.010208 -0.024410 -0.019642 -0.014977 -0.024707 0.990616 0.038768 0.010238 1.040880 -0.006119 -0.047665 0.986770 -0.011567 1.004318 -0.029971 1.013665 -0.022161 1.002074 0.010501 0.960155 0.984224 1.026497 -0.016095 1.010019 0.031642 0.999133 0.979670 0.000233 -0.007173 1.008576 0.977465 0.974203 0.962648 1.001036 0.999199 1.006937 1.008107 1.030886 0.032255 0.013490 1.006674 1.009720 -0.000453 0.030604 1.006832 1.002142 1.011386 -0.032413 -0.010262 1.028395 1.007678 0.997719 1.024479 0.960010 -0.004909 0.994707 -0.013372 0.977065 0.994209 0.973989 0.007180 -0.027035 0.985703 -0.005303 -0.038704 0.037271 1.004149 0.966830 1.029492 -0.024194 -0.015545 1.038917 1.042772 1.001889 0.998939 0.955875 -0.005453 0.980182 -0.007532 0.998567 0.983303 0.017570 -0.020865 -0.013117 1.027734 0.984047 0.038060 -0.007684 1.009226 -0.024667 1.000606 1.016532 0.981910 -0.010374 0.007713 1.032539 0.989510 1.024116 1.001067 0.024989 -0.020873)
       )

;;; 2048 even --------------------------------------------------------------------------------
#(2048 87.471149563312 #(0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1)

       78.079325 #(0.000000 1.036212 -0.043685 0.331976 0.639530 1.127516 1.095152 1.508236 0.077934 1.337557 0.072113 -0.092944 0.796909 1.784824 0.440076 0.246196 1.387524 0.190896 1.640182 0.925143 0.346541 1.367537 0.178172 0.900392 1.703536 1.678208 1.753849 0.425105 0.187619 1.751892 1.898170 0.616148 1.276449 1.748534 0.146310 1.804887 0.286781 -0.064076 1.520935 0.166848 1.246710 0.087250 0.943537 1.755401 0.334485 0.490353 1.501725 1.277784 1.245080 0.471353 0.764254 1.697034 1.056331 1.736214 0.463227 0.796303 1.150866 -0.021932 0.234603 0.080694 1.745115 0.716674 0.093762 0.744119 1.143077 1.540437 1.841607 1.711093 0.867517 1.296036 1.315314 1.006884 0.239668 1.666083 1.671147 1.716928 -0.027459 1.906723 0.073560 1.255469 1.796692 0.526703 0.076840 0.934228 0.293278 0.367456 0.305891 1.422085 1.299849 1.951249 1.462008 1.040367 1.853366 0.810937 0.603550 0.848743 0.268307 1.173776 1.919876 1.102197 1.660214 1.762553 1.781211 0.633437 0.456915 0.254253 0.486765 0.536153 1.493176 0.945749 1.791455 0.934973 0.284784 1.433744 0.425334 0.064742 0.690643 1.925513 1.755950 0.618329 1.632172 -0.059593 1.375330 0.869966 1.487228 1.414963 0.333672 0.780241 1.330677 0.484533 0.218933 0.162630 0.710074 0.419557 -0.032680 0.883965 1.717277 0.430915 0.263252 1.360127 0.169506 1.343179 1.234460 1.750884 0.164361 0.378299 1.460882 0.897871 0.213904 0.128719 0.360447 0.555828 1.579900 1.051631 1.398250 1.313610 0.220306 0.871110 1.178519 1.513441 1.303728 0.802201 0.242388 1.900778 1.477677 0.067540 0.652996 0.103896 0.687602 0.914043 0.697581 0.105317 1.825200 0.024458 0.235192 0.433521 0.312835 0.809192 1.808814 0.468703 0.865854 1.628971 1.590464 1.720208 0.790391 0.109924 1.554973 -0.023990 1.192392 0.712254 -0.008308 1.166932 0.323937 0.599507 1.428804 1.009547 0.297463 1.703546 1.729917 1.681205 0.524857 1.697748 0.256667 1.120927 0.047187 1.189398 0.820638 0.699302 0.002442 1.121649 1.667851 0.869163 1.641192 0.656529 0.841409 0.057676 -0.196215 1.453792 1.886624 0.125107 0.602688 0.239635 0.436713 1.300259 1.239844 0.261666 1.553825 0.240232 0.801341 0.507041 1.560623 1.566831 1.253461 -0.062284 1.669509 1.095250 0.027748 1.068831 0.602783 1.174264 1.815938 0.796036 0.386048 1.233720 1.401215 0.759974 0.913111 1.179032 1.213203 0.938878 1.696577 0.360595 1.305400 0.044128 1.743675 1.440756 1.459247 0.623194 1.508843 1.421417 1.629960 0.477983 0.835293 -0.070334 0.708287 1.142955 0.932387 1.813043 1.382192 0.381127 0.190410 0.729845 0.321732 0.824558 -0.020023 1.607442 0.200267 0.318647 0.044651 1.768240 0.643757 1.206201 1.468765 0.601437 1.706259 0.495261 0.956913 0.394710 1.176569 0.800067 1.886558 1.605179 1.122676 1.144265 1.561625 0.181947 1.309849 1.577300 0.495188 1.655610 1.180832 1.194001 0.875913 0.228611 1.639141 0.550083 1.839287 0.580971 -0.197365 0.327613 1.901067 0.522438 1.020637 1.267341 1.342859 0.445176 0.112095 0.457659 0.120276 0.250883 1.204237 1.402798 1.271260 1.255292 0.578618 1.686129 0.490946 1.771289 1.121957 0.127348 0.581481 0.812819 1.448200 -0.003892 -0.044962 0.952367 1.033247 -0.085086 0.150310 0.057854 1.842500 0.716853 0.935519 0.269127 1.299626 0.388259 0.164338 1.057650 1.178504 1.241059 0.565924 1.615325 0.390452 0.686889 1.489199 0.183366 1.767188 1.365040 1.248231 1.196393 0.220573 0.358798 0.163202 1.499695 1.793435 -0.212597 0.677471 0.562186 1.706417 0.638842 0.138384 1.541313 1.495553 1.825920 1.099565 0.289989 1.936921 0.388891 1.617689 0.315048 0.242499 1.724502 0.758918 0.479832 0.306301 1.154626 1.015534 1.286300 0.819723 0.897789 1.897385 0.811133 1.198870 -0.023538 1.581550 1.752737 0.752872 1.653243 1.098279 0.913859 0.290667 0.391090 0.448864 1.747363 1.628653 1.296395 1.685456 0.410609 0.613612 0.229500 1.978170 0.563390 1.684018 1.175413 1.421149 0.835252 1.423949 1.519247 0.020578 0.410433 0.532037 1.105479 1.305389 0.747326 0.273148 1.468421 1.561328 1.045465 0.300840 1.851806 1.623959 -0.020047 0.551127 0.952587 1.750489 0.425896 1.297055 1.252366 0.774082 0.008302 0.830022 0.354751 1.630433 0.527393 0.320074 0.992472 1.329100 0.937461 -0.124987 0.528489 0.860443 1.777412 -0.179698 1.649835 1.523675 0.255615 0.752546 1.044250 1.061394 1.473542 1.559139 1.750843 0.228407 0.244978 0.318506 0.214338 -0.127687 0.016065 1.683527 1.059087 1.084321 1.209844 1.162599 1.700206 1.028836 1.111259 0.965422 1.349098 0.449160 1.236238 1.152610 1.241247 0.441411 1.200500 1.575948 0.056337 0.109621 0.678763 1.605571 1.462870 0.670350 1.160814 0.178948 1.776617 0.814727 1.471143 0.666341 0.666497 0.003085 0.367263 1.764549 1.817682 0.565043 0.256262 0.744401 0.069362 0.856509 1.798907 0.484543 1.036560 1.448462 1.009617 0.983445 0.719152 0.713983 1.197878 0.928722 0.442562 0.632379 1.311255 1.163303 1.389071 0.013803 1.283658 0.183551 0.216748 0.742490 0.246195 0.580366 1.004491 0.032852 1.729133 1.159382 1.701779 0.944042 1.827589 0.917849 1.400392 1.223004 1.113159 0.052572 0.168081 1.615230 1.221824 1.526728 1.850771 -0.240328 1.487522 1.159816 1.866293 1.698164 0.013835 -0.093167 0.180008 0.018965 1.603158 1.613742 1.313466 1.035280 1.492647 0.815996 0.391557 1.242014 0.993247 1.401424 0.488225 0.393455 0.894952 0.309407 0.321448 0.558471 0.718740 1.467551 0.500281 0.439320 1.869730 1.364530 1.553036 0.969732 1.636285 1.798396 1.363995 0.920638 0.126592 0.286258 1.696296 0.331371 0.356812 0.490460 1.101761 0.373647 0.097306 0.453078 1.827015 0.179707 -0.019918 -0.106312 0.084833 1.193623 0.408083 0.143266 0.206533 1.082562 0.158416 0.854906 0.878107 0.339914 0.457130 0.154799 0.176600 0.085438 0.131041 0.453107 0.593969 0.303633 0.916178 1.161798 1.896318 0.930094 0.986481 1.688216 0.819416 1.265892 0.011344 0.265144 0.267354 1.189048 0.659992 1.171202 1.786897 0.902370 -0.041938 0.785186 0.246222 1.558295 1.890657 1.369584 1.616357 1.670144 1.849685 1.342838 1.757000 1.172827 0.103451 0.032886 1.109693 0.659929 0.371860 1.404352 1.477883 1.155474 0.555608 0.969331 0.650971 1.813202 1.603915 0.999884 1.494172 1.882922 1.689689 1.690194 0.705259 1.560645 1.081311 0.825846 1.685601 0.689103 0.269731 0.147349 0.167554 0.803327 0.198449 1.282138 1.170132 0.901085 1.709183 0.934868 1.972921 0.385259 1.488122 0.118213 1.387825 0.546603 0.472410 0.223942 0.792440 1.272964 0.539143 1.056110 0.965279 1.256909 0.069278 0.438772 0.688522 1.474529 1.518833 0.647516 1.850584 -0.061940 1.420599 1.301753 0.184502 0.147262 0.261775 0.575331 1.308330 1.224554 0.672189 0.758277 1.191895 1.228368 0.130276 0.482407 1.350231 1.750711 0.397622 1.713381 1.011249 0.522822 1.072918 1.821285 0.965512 0.063639 0.566385 1.807346 1.175784 1.223074 1.591887 -0.168041 0.271021 1.529439 0.521842 0.823001 0.940921 1.684294 0.286489 1.242930 1.937690 0.607200 0.275302 1.790606 0.491021 1.035487 -0.045868 0.085148 1.238065 1.129382 -0.053312 1.545108 0.434470 0.810550 1.100562 0.221267 1.037507 1.624758 1.555603 1.062386 0.144378 0.886916 0.149410 -0.066826 1.113563 0.490079 0.634885 0.842660 0.061321 1.725263 1.823881 0.115290 1.146242 0.979557 1.530480 0.067327 0.568197 0.897626 0.771983 0.563170 1.194766 0.655189 1.549104 1.322518 0.483177 0.760693 1.010138 0.534980 0.223935 1.152460 1.731132 1.519096 0.446488 1.420973 1.696386 1.157486 1.211136 1.546897 1.232762 1.175520 0.355595 1.525833 -0.042267 1.352048 0.992497 -0.093673 0.742530 0.634885 -0.089066 0.868194 0.573537 1.674126 0.329153 1.158907 1.178480 0.551158 1.486852 -0.071558 0.725909 1.395015 1.209212 0.379942 0.747225 0.444854 0.946742 1.211242 1.139390 1.010957 1.097783 0.203142 1.127162 1.614090 1.772287 0.331896 1.598023 1.816077 0.662803 1.330979 0.944114 1.383701 0.797215 1.196402 1.084443 1.184444 1.682543 1.168272 1.958979 -0.058496 0.841894 1.219141 1.365510 0.769766 1.232995 0.960628 1.742029 1.659964 0.361424 0.247996 1.622047 1.491439 1.012850 0.556413 0.070470 1.055118 0.709469 1.227676 1.050289 1.817507 1.250045 0.044881 -0.105998 0.360108 0.510639 -0.000754 0.913624 0.014253 0.869683 0.815496 -0.043945 1.463465 1.037174 0.323537 0.584260 1.687824 0.186494 1.408948 0.905638 1.501561 1.450375 1.647727 1.343515 0.997551 0.097973 0.620795 0.473197 0.975124 1.453483 0.888388 0.452833 1.689714 0.696728 0.633683 0.509294 1.106199 0.373384 1.699003 1.169996 0.082561 0.289835 0.757159 1.514061 1.528786 0.435419 0.161517 0.726914 1.380867 1.654754 0.604942 0.070114 0.541874 1.167294 1.310511 1.570194 0.673809 1.267196 0.489289 1.272471 1.573227 1.458789 0.530304 0.456318 1.679920 1.109017 0.240982 1.697797 0.777016 0.870109 1.599744 1.746059 0.193197 0.572600 1.617885 0.423393 0.264299 1.931463 0.929567 1.333438 0.553075 0.123102 0.783267 1.986789 1.667679 1.525086 1.102518 0.117178 0.013899 0.476557 1.428021 1.781881 0.479378 1.440749 0.433516 0.176847 1.747379 1.328355 0.058455 1.628266 1.215447 1.600718 0.965239 1.219616 1.227710 0.034900 1.335400 0.576945 0.169250 1.234608 1.110724 1.740429 1.656377 0.259109 1.608270 0.156542 0.335333 0.895697 -0.078619 0.093744 0.937474 0.090269 0.752748 0.885184 1.935435 1.556700 1.833155 0.379459 1.439350 0.281834 1.377687 1.469181 0.560304 0.350829 0.370361 0.413143 1.546821 1.107825 0.763796 1.687563 0.219324 0.055037 -0.020128 1.641061 1.731840 1.877911 1.717828 1.356597 1.730658 0.588868 0.835297 0.297291 0.088419 0.412212 1.415406 1.017343 1.423175 0.375775 1.302219 0.953702 0.678804 1.572374 1.727477 0.254556 1.094641 1.162163 0.143319 0.854688 1.063038 0.441476 1.282254 1.589355 0.648429 0.822071 1.490818 0.276396 1.213776 0.318534 1.167492 0.713979 0.593799 1.038818 1.843043 0.450884 1.098196 1.002340 1.751110 1.258344 0.802075 0.796882 0.068028 0.990778 1.404822 0.767441 0.258966 0.014912 0.397819 1.169281 0.671758 0.828982 0.684022 1.483627 0.060148 0.140681 0.965311 1.046164 1.448760 0.937335 0.043049 1.426389 0.175311 0.942467 1.289194 0.705897 0.195736 1.367220 0.481110 1.117710 0.026294 1.480040 1.701576 0.741539 0.129438 1.793396 0.216626 0.338432 1.293825 1.852766 0.567380 0.675267 1.660257 1.295361 0.379806 0.115345 0.037783 0.635233 0.390593 0.891898 1.623418 1.141114 0.967319 0.436616 1.163548 1.438313 1.028606 1.507879 0.276194 1.126750 1.086763 0.657033 -0.091488 1.327256 1.184128 1.357378 0.116523 1.532550 0.455893 1.613945 0.808970 0.183575 0.288911 -0.057175 0.416408 1.883558 1.036690 -0.004024 1.155543 0.908210 0.958228 0.735059 -0.149409 -0.109242 1.993416 0.061976 0.994397 0.312822 0.358556 0.357396 0.166228 1.906441 1.936369 1.954589 1.571014 0.719233 0.153949 0.028336 1.320995 1.240948 0.545995 1.805452 1.619213 0.231489 1.707803 0.618275 0.642514 1.471382 1.348917 1.095451 0.221991 0.792513 0.689445 1.882995 1.365514 1.063222 1.950163 0.465549 0.519653 0.736476 1.311946 1.452773 1.442715 1.517899 0.924450 -0.258534 0.766737 0.924843 0.502570 1.115330 1.657088 0.120016 1.780444 1.686548 0.035927 0.449644 0.309346 1.622740 0.581408 0.299807 1.408994 0.611973 0.764394 0.604130 1.299785 1.686040 1.006944 0.701090 1.243781 0.213973 0.887207 1.233295 1.666529 0.235283 1.402144 1.228392 0.531790 0.502582 1.344011 1.047300 1.113632 0.075538 1.422393 1.570034 1.313722 0.186419 0.938804 1.688331 0.356313 1.160071 1.677615 0.597077 0.892649 1.278418 1.866713 0.634605 1.131045 1.247527 0.323580 1.122900 0.478811 0.712857 0.778489 0.733910 0.492143 1.681476 0.182306 0.475863 1.491278 0.187728 0.437657 0.198048 1.236439 0.268664 0.149327 0.934080 1.438262 1.896760 0.457386 0.548858 1.210218 1.289090 1.057745 0.668857 1.173530 0.693912 1.373334 0.504490 1.774419 1.309479 0.081305 1.710946 1.383983 0.433639 0.367597 0.598191 0.968980 0.477561 1.759027 0.625170 1.727969 1.718828 0.634164 0.574901 1.059254 0.056017 0.516804 0.253417 0.694276 1.806842 1.251926 1.330344 0.582436 0.789520 1.835852 0.867891 1.822064 1.359273 0.296168 0.365411 0.131864 0.093576 0.901545 1.224841 -0.103847 0.409143 1.472189 1.522564 0.937037 0.936778 0.858129 0.405727 0.803283 0.405592 1.621314 0.477697 1.071232 1.490250 0.210905 0.388916 0.148961 0.484107 0.248858 0.677626 1.216797 1.366933 0.495657 1.673293 0.762780 1.143691 1.830348 0.353612 0.038958 1.687620 0.671154 0.712933 1.807885 1.122232 1.188992 1.701760 0.242220 1.603391 0.699724 1.054033 0.076868 1.632921 1.612600 0.087130 0.365903 0.458822 1.024159 1.354588 0.392699 1.423641 1.204423 1.164681 1.649578 1.256031 1.243822 1.042854 0.005560 1.024514 0.604398 0.680137 1.912453 0.670310 0.213643 0.446770 1.090682 1.474974 1.806865 0.764624 1.563431 0.473634 0.510617 1.001005 1.364194 0.537668 -0.014680 0.885588 -0.005747 1.738242 1.410596 1.602084 0.734862 1.493989 1.349989 0.406916 1.170482 -0.017990 1.034213 0.634019 1.456131 0.974789 -0.144669 1.737158 -0.037172 1.400515 1.623550 0.499450 1.479595 0.507050 1.358218 0.582744 1.475859 0.513808 1.600273 1.836597 1.059912 -0.072725 1.290524 -0.073595 1.937918 0.300206 0.119306 1.027133 -0.093444 0.011477 1.127890 1.399417 1.853798 1.657887 0.145866 0.588742 0.873359 0.762305 1.639168 0.778598 0.019634 1.817733 0.156595 0.169164 1.530459 1.438248 0.803585 -0.094272 0.468694 0.847016 0.311870 0.299559 0.551763 0.793044 1.160950 0.697742 1.837771 0.754430 1.758952 0.505686 1.737258 0.020417 1.293145 1.675271 0.394950 0.929538 0.720083 0.978614 0.784199 0.905034 0.921702 0.937761 1.562150 1.166453 1.603212 0.260741 0.602140 1.673881 0.673664 1.946860 1.010728 1.288978 1.297659 1.198620 0.504487 1.420515 1.576870 0.975311 1.683510 1.543454 1.716402 0.940588 1.162463 1.651787 0.589731 0.285012 0.638073 1.089187 1.489366 0.491525 1.435921 1.014411 1.601370 0.949407 1.694644 0.959875 -0.062780 -0.004119 1.163389 0.589582 1.149178 1.817933 0.849953 1.802695 1.461496 1.665429 1.837845 0.976053 0.862346 0.530923 0.811633 0.503788 -0.027013 1.611602 0.057407 0.611054 1.824034 0.259920 0.148035 0.105941 -0.021158 1.835611 1.319838 1.754236 1.193537 1.357026 0.094401 1.491186 0.366416 1.555586 1.669437 0.823707 1.243186 0.432020 1.052515 0.858115 1.022105 0.954847 1.455406 1.318994 0.283690 1.211015 0.710161 0.270613 1.714336 1.101135 0.235311 1.092475 1.008566 0.447003 0.602655 0.757184 0.009064 0.530056 1.724465 0.607925 1.121575 1.099024 0.882158 0.934761 0.125447 0.972944 0.967420 1.343086 0.315752 1.165505 1.109567 1.918061 1.478347 0.850704 0.940172 0.696083 0.793045 1.211155 0.866708 0.135821 0.480730 1.058685 0.463469 0.583533 1.522858 0.588384 0.353159 1.576867 1.754930 0.850029 1.919190 1.543405 0.995776 0.821301 1.793940 1.151072 -0.047846 1.508846 1.746284 0.877808 0.214307 0.787802 -0.003151 1.141139 1.698635 0.232169 1.093325 1.515191 0.901564 1.506350 0.135967 1.384636 -0.242650 0.302616 1.608186 0.459148 0.023364 0.249132 1.086552 0.992569 1.132819 0.061330 1.433907 1.539244 0.001712 1.876374 1.299743 1.030055 0.164439 0.092647 0.881217 1.088556 1.351722 -0.088421 0.062334 -0.051555 1.260415 0.983686 0.258617 0.860731 0.793959 0.416831 1.721077 0.095305 0.351122 0.421061 1.074247 -0.008811 1.438063 1.858745 1.305784 0.273960 1.682787 1.279785 0.274409 1.389220 0.882641 1.632991 1.590305 0.893791 0.055411 1.041678 1.451974 0.782716 0.213219 0.208404 1.139321 0.013312 0.073161 1.595535 1.686000 1.590328 0.023294 0.960934 0.758890 0.838775 1.710621 1.483697 1.281650 1.870804 0.139547 0.420537 0.308122 0.843944 0.520105 0.603303 -0.123864 1.234056 1.586800 0.927689 1.817960 1.506645 1.174470 0.276079 0.650528 0.932391 1.014056 0.664840 1.016866 1.426511 0.276789 0.219182 -0.115031 -0.164867 0.961712 0.416951 1.540063 0.375102 1.075987 1.313615 1.096641 0.764154 1.064504 0.355545 1.636517 0.212986 0.487153 0.606986 0.525136 0.094256 1.722629 0.854306 0.459009 1.050404 0.099495 1.863554 1.019865 1.702596 1.229915 1.749507 0.590639 0.164343 1.868513 1.170840 1.017598 0.404087 1.088319 0.595386 0.693810 1.531079 -0.137773 0.882791 1.035974 1.610308 1.572178 1.281505 1.448052 1.385965 0.085841 0.156089 1.020082 1.499413 1.367482 1.202166 -0.310324 1.093902 0.466865 0.481107 0.055940 1.626791 0.579934 0.932207 0.524863 0.771645 1.410464 1.781815 0.875062 1.565260 0.492144 0.931433 0.731301 0.464124 0.688570 0.033927 0.659049 -0.144339 1.390582 0.216364 1.564810 1.784761 0.542130 1.644616 0.892364 0.103014 1.151370 0.406893 0.685594 0.203695 0.116843 1.116841 0.017775 1.255535 0.180776 1.604852 1.357176 0.844518 1.917543 0.710840 0.586218 -0.084711 0.326304 0.583894 0.000981 1.527582 0.764193 0.691981 1.254365 0.042940 0.799959 1.234613 0.912676 1.261576 1.804612 1.772885 1.638278 1.452687 1.856363 1.017673 1.335012 1.093288 1.791716 0.240760 1.583614 0.215117 1.054497 1.759230 1.720795 1.725051 0.719870 1.536084 0.793019 0.072407 1.612325 0.603805 0.749790 0.930307 1.444787 0.076331 0.716031 0.751130 1.730048 1.119736 1.740692 1.642864 1.211815 0.613767 1.280443 0.196315 0.724783 0.377146 1.066938 1.497331 1.166708 1.287064 1.948271 1.408327 0.113842 -0.199587 0.630400 0.343945 1.153303 0.303357 -0.235653 1.575467 1.304018 0.481724 0.321926 1.036142 1.030288 0.337553 0.573686 1.834042 0.718673 0.182114 0.139978 0.253556 1.503381 0.215937 1.358417 0.238777 1.828073 0.206519 0.338254 0.358048 1.340274 1.144155 0.382861 -0.237688 1.081990 0.287210 0.604778 0.308728 1.486981 0.684669 1.827156 0.478181 1.795964 1.220849 1.367205 0.507990 0.995111 0.581857 0.196941 1.401782 0.618658 0.678201 1.941176 0.922033 0.346514 1.451221 1.191571 0.812039 0.176868 0.358644 0.856782 1.053754 0.172649 -0.008915 0.891004 1.275467 1.965871 1.446554 1.059213 1.698536 0.639863 1.290197 1.301277 0.460338 0.904108 1.206822 1.204141 0.172712 1.004515 0.611142 0.640455 1.099407 0.564655 0.577778 1.778285 0.167018 0.507458 0.762661 0.259884 0.066707 0.947613 0.965715 0.752844 0.822051 1.036867 1.496747 1.109711 1.909353 0.600886 1.668852 1.668992 -0.160977 0.189295 1.475624 0.412875 0.557318 1.130005 0.439886 1.255571 1.411751 0.901388 0.499673 1.791033 0.684314 -0.123345 1.518751 0.858235 1.779307 0.897544 1.242344 1.789823 1.117474 0.471404 0.148429 0.200067 1.627870 1.184473 1.258861 1.514572 1.105948 0.122797 0.601905 0.937069 0.692200 1.745527 1.038032 0.377653 0.204106 1.113841 0.997556 1.126370 0.095557 1.147967 0.559979 1.673772 1.556295 0.142426 1.654656 0.686755 0.114523 1.891052 1.870233 0.340505 0.325592 1.788001 1.691946 1.832371 0.254110 -0.056957 0.552635 0.359382 1.244098 0.331889 0.956126 1.636252 0.526733 1.070660 0.740225 1.503924 0.042864 0.662653 0.013249 0.159303 0.325720 0.297550 0.820869 1.730514 0.000052 0.161939 0.357257 0.877505 1.576861 1.847738 0.044951 0.597694 1.584933 -0.105788 1.430351 0.083180 1.563544 1.130148 1.599446 1.171509 0.524299 0.631284 0.480371 1.906399 0.915214 1.139324 0.334117 1.299283 0.373882 0.383787 0.345985 1.171992 0.720625 1.314793 1.338926)
       )

))


;;; triangle waves in place of sinusoids have different mimima at different places, so
;;;   we can't simplify in that direction

;;; the waveforms for a given number of peaks are surprisingly similar -- :odd and :even in particular
;;;   this includes cases involving all sines (0 and 1), as compared to all cosines (1/2 and 3/2)


(define (tstodd phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 2)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstoddderiv x phs) 
  (let ((sum 0.0)
	(len (vector-length phs)))
    (do ((i 0 (+ i 1))
	 (j 1 (+ j 2)))
	((= i len) sum)
      (set! sum (+ sum (* j (cos (+ (* j x) (* pi (phs i))))))))))


(define (tstall phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstallf mult phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 1)))
	    ((= k len))
	  (if (= k (- len 1))
	      (set! val (+ val (* mult (sin (+ (* j x) (* pi (phs k)))))))
	      (set! val (+ val (sin (+ (* j x) (* pi (phs k))))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tsteven phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* (max (* 2 k) 1) x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstprime phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* (primes k) x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstallderiv x phs) 
  (let ((sum 0.0)
	(len (vector-length phs)))
    (do ((i 0 (+ i 1))
	 (j 1 (+ j 1)))
	((= i len) sum)
      (set! sum (+ sum (* j (cos (+ (* j x) (* pi (phs i))))))))))


(define (get-best choice n)

  (define (vector-find-if func vect)
    (let ((len (vector-length vect))
	  (result #f))
      (do ((i 0 (+ i 1)))
	  ((or (= i len)
	       result)
	   result)
	(set! result (func (vect i))))))

  (vector-find-if (lambda (val)
		    (and val
			 (vector? val)
			 (= (val 0) n)
			 (let ((a-val (val 1))
			       (a-len (vector-length val))
			       (a-data (val 2)))
			   (do ((k 3 (+ 1 k)))
			       ((= k a-len))
			     (if (and (number? (val k))
				      (< (val k) a-val))
				 (begin
				   (set! a-val (val k))
				   (set! a-data (val (+ k 1))))))
			   (list a-val a-data))))
		  (if (eq? choice :all)
		      noid-min-peak-phases
		      (if (eq? choice :odd)
			  nodd-min-peak-phases
			  (if (eq? choice :even)
			      neven-min-peak-phases
			      primoid-min-peak-phases)))))

(define (showall len)
  (let* ((phs-data (get-best :all len))
	 (phs (cadr phs-data))
	 (mx (car phs-data))
	 (v (make-vct (ceiling (+ (* 2 pi 1000) 2))))
	 (incr 0.001))
    (do ((x 0.0 (+ x incr))
	 (i 0 (+ i 1)))
	((> x (* 2 pi)))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
	(set! (v i) val)))
    (new-sound)
    (vct->channel v)
    (set! (y-bounds) (list (- mx) mx))))


(define (get-worst-overall choice choices)
  (let ((diffs (make-vector 116))
	(total 0.0)
	(this 0.0)
	(last 0.0)
	(next 0.0)
	(choice-list '())
	(first (car (get-best choice 11))))
    (set! this first)
    (set! next (car (get-best choice 12)))
    (do ((i 12 (+ i 1)))
	((= i 128))
      (set! last this)
      (set! this next)
      (set! next (car (get-best choice (+ i 1))))
      (set! (diffs (- i 12)) (cons i (+ (- this last) (- this next))))
      (set! total (+ total (abs (- this last)))))
    (sort! diffs (lambda (a b)
		   (> (cdr a) (cdr b))))
    (do ((i (- choices 1) (- i 1)))
	((< i 0))
      (let ((c (diffs i)))
	(set! choice-list (cons c choice-list))))

    (list choice-list (- (+ total first) this)))) ; first to this would be a straight line



(define (find-other-mins peak-amp peak-phases)

  ;; given a point, find the 3 other matching points (this assumes all harmonics, but the other cases are similar;
  ;;   in the even case, we'd flip all above 0, not just every other one, because they're all even, but we end
  ;;   up with 4 equivalent points as before -- step by 1 not 2 in the 1st and 3rd loops below.  In the odd and 
  ;;   prime cases, I can only think of 2 such points, the symmetry being around 0 (2-val)).

  (let ((temp-phases (copy peak-phases))
	(n (length peak-phases))
	(results '()))

    ;; flip evens
    (do ((i 1 (+ i 2)))
	((>= i n))
      (set! (temp-phases i) (modulo (+ (temp-phases i) 1.0) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format #t ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    ;; get case symmetric around 0
    (set! temp-phases (copy peak-phases))
    (do ((i 1 (+ i 1)))
	((= i n))
      (set! (temp-phases i) (modulo (- 2.0 (temp-phases i)) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format #t ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    ;; flip evens on the previous case
    (set! temp-phases (copy temp-phases))
    (do ((i 1 (+ i 2)))
	((>= i n))
      (set! (temp-phases i) (modulo (+ (temp-phases i) 1.0) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format #t ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

;   (format #f "~{~{~,8F ~A~%~}~}" (reverse results))
    results
    ))

;;; :(find-other-mins (car (tstall #(0.0 0.1 0.2 0.3))) #(0.0 0.1 0.2 0.3))
;;; 3.49630991 #(0.0 1.1 0.2 1.3)
;;; 3.49630680 #(0.0 1.9 1.8 1.7)
;;; 3.49630979 #(0.0 0.9 1.8 0.7)

(set! (print-length) 123123)

(define (show-mins i)
  (let ((data (get-best :all i)))
    (let ((other-mins (apply find-other-mins data)))
      (let ((pk1 (cadr data))
	    (pk2 (cadr (car other-mins)))
	    (pk3 (cadr (cadr other-mins)))
	    (pk4 (cadr (caddr other-mins))))

	(if (or (> (abs (- (car (car other-mins)) (car data))) .001)
		(> (abs (- (car (cadr other-mins)) (car data))) .001)
		(> (abs (- (car (caddr other-mins)) (car data))) .001))
	    (format #t "trouble in ~D: ~A ~A~%" i data other-mins))

	(let ((phases (sort! (list pk1 pk2 pk3 pk4)
			     (lambda (a b)
			       (< (a 1) (b 1))))))
	  (format #t "~,8F~%    ~A~%    ~A~%    ~A~%    ~A~%"
		  (data 0)
		  (phases 0)
		  (phases 1)
		  (phases 2)
		  (phases 3)
		  ))))))

;; (09)
;; 1 Mar 5446.42
;; 1 Apr 5405.890
;; 1 May 5138.261
;; 1 Jun 5061.829
;; 1 Jul 4669.101
;; 1 Aug 4633.454
;; 1 Sep 4616.517
;; 1 Oct 4592.994
;; 1 Nov 4560.903
;; 1 Dec 4541.710
;; (10)
;; 1 Jan 4360.644
;; 1 Feb 4292.451
;; 1 Mar 4280.782
;; 1 Apr 4272.964
;; 1 May 4267.719
;; 1 Jun 4261.356
;; 1 Jul 4244.312, sqrts: 82 74 0 0
;; 1 Aug 4218.456, sqrts: 82 74 0 0
;; 1 Sep 4209.464, sqrts: 85 74 0 0   (9.5330)
;; 1 Oct 4202.347, sqrts: 89 75 0 0   (6.9438)
;; 1 Nov 4198.764, sqrts: 94 78 0 0   (5.5196)
;; 1 Dec 4196.395, sqrts: 98 84 0 0   (4.1226)
;; (11)
;; 1 Jan 4194.669, sqrts: 101 91 0 0  (2.9465)
;; 1 Feb 4194.106, sqrts: 105 91 0 0  (2.5054)
;; 1 Mar 4193.048, sqrts: 110 95 0 0  (1.6862)
;; 1 Apr 4188.373, sqrts: 114 104 0 0 (0.8505)
;; 1 May 4186.610, sqrts: 114 105 0 0 (0.6439)
;; 1 Jun 4186.498, sqrts: 115 105 0 0 (0.5422)

;    all 0.4860 (20) to 0.5008 (93), dist: 0.1650, 9.1734
;    odd 0.4820 (11) to 0.5020 (124), dist: 0.6855, 7.6952
;    even 0.5099 (99) to 0.5242 (22), dist: 66.0952, 0.0000
;    prime 0.5448 (24) to 0.5634 (117), dist: 254.3740, 0.0000

;    all 0.4860 (20) to 0.5008 (93), dist: 0.1327, 9.1812
;    odd 0.4820 (11) to 0.5017 (111), dist: 0.5112, 7.7581
;    even 0.5099 (99) to 0.5242 (22), dist: 66.0952, 0.0000
;    prime 0.5446 (24) to 0.5630 (117), dist: 252.8886, 0.0000

;    all 0.4860 (20) to 0.5006 (93), dist: 0.1044, 9.1858
;    odd 0.4820 (11) to 0.5016 (111), dist: 0.4378, 7.7637
;    even 0.5099 (99) to 0.5242 (22), dist: 66.0952, 0.0000
;    prime 0.5446 (24) to 0.5630 (117), dist: 252.8886, 0.0000



;(test-all-phases #f) in test-phases.scm

#|
:(load "test-phases.scm")
:(test-all-phases #f)
;all peaks... Fri 08-Apr-2011 03:15
;all 512: peak-phases value: 31.391244, current: 31.393507890848, diff: 0.0022638908477184
;all 1024: peak-phases value: 49.867216, current: 49.863543040531, diff: -0.0036729594690925
(0.0036729594690925 1024)
;odd peaks... Fri 08-Apr-2011 03:40
;odd 117: peak-phases value: 10.793469, current: 10.795579308294, diff: 0.0021103082937639
;odd 122: peak-phases value: 11.059922, current: 11.062351803457, diff: 0.0024298034566126
;odd 128: peak-phases value: 11.291219, current: 11.293793672832, diff: 0.0025746728319049
;odd 2048: peak-phases value: 78.937441, current: 78.931916185936, diff: -0.0055248140642448
(0.0055248140642448 2048)
;even peaks... Fri 08-Apr-2011 04:06
;even 124: peak-phases value: 11.839819, current: 11.842004575693, diff: 0.0021855756934652
;even 126: peak-phases value: 11.981489, current: 11.983725455888, diff: 0.0022364558875729
;even 256: peak-phases value: 21.147051, current: 21.149844044205, diff: 0.0027930442051805
;even 512: peak-phases value: 31.628149, current: 31.625265493922, diff: -0.0028835060781311
;even 1024: peak-phases value: 51.627202, current: 51.61731817532, diff: -0.0098838246798678
;even 2048: peak-phases value: 78.079325, current: 78.055349684919, diff: -0.023975315080577
(0.023975315080577 2048)
;prime peaks... Fri 08-Apr-2011 04:37
;prime 124: peak-phases value: 14.905565, current: 14.903183245254, diff: -0.0023817547457075
;prime 256: peak-phases value: 25.419292, current: 25.416395401039, diff: -0.0028965989614846
(0.0028965989614846 256)
;all done! Fri 08-Apr-2011 05:00

:(test-all-phases #f)
;all peaks... Thu 05-May-2011 04:34
;all 125: peak-phases value: 11.166205, current: 11.168404467666, diff: 0.0021994676657489
;all 512: peak-phases value: 31.391244, current: 31.393507890848, diff: 0.0022638908477184
;all 1024: peak-phases value: 49.867216, current: 49.863543040531, diff: -0.0036729594690925
(0.0036729594690925 1024)
;odd peaks... Thu 05-May-2011 04:59
;odd 117: peak-phases value: 10.793469, current: 10.795579308294, diff: 0.0021103082937639
;odd 2048: peak-phases value: 78.937441, current: 78.931916185936, diff: -0.0055248140642448
(0.0055248140642448 2048)
|#

;;; gad161: clean-up-evens
;;; t139.scm: show-circles
;;; t241.scm: canonicalize
;;; t283.scm: poly stuff
