/*******************************************************************************
* FILE NAME: icmnfun.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in icmnfun.hpp.                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
// Priority INT_MIN (-2147483647 - 1) + 1024 + 512
#pragma priority( -2147482112 )

#define INCL_WINFRAMEMGR               // WM_QUERYFOCUSCHAIN.
#define INCL_WINWINDOWMGR              // QWS_FLAGS.
#define INCL_WINDIALOGS                // WinEnumDlgItem, etc.

extern "C" {
  #include <iwindefs.h>
}

#include <icmnfun.hpp>
#include <icolor.hpp>
#include <ievtdata.hpp>
#include <ihandle.hpp>
#include <itrace.hpp>
#include <istring.hpp>
#include <iwindow.hpp>
#include <iwcname.hpp>

// Segment definitions.
#ifdef IC_PAGETUNE
  #define _ICMNFUN_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_WIN
void DrawTrackRect (HDC hdc, LPRECT lprc);
#endif

#ifdef IC_PM
/*------------------------------------------------------------------------------
| defaultbackgroundcolor                                                       |
|                                                                              |
| Determine the background color to use for the specified window,              |
| assuming that none has explicitly been assigned (choose between the          |
| system window background and system dialog background colors).               |
------------------------------------------------------------------------------*/
IColor defaultbackgroundcolor ( IWindowHandle hwndmain )
{
  IColor clrBackground = IGUIColor( IGUIColor::windowBgnd );
                                  // Default to system window background.

  /******************************************************************/
  /* The default background color will be based on the type of      */
  /* frame window we are sitting on (dialog background if the frame */
  /* is supposed to look like a dialog box, window background       */
  /* otherwise).                                                    */
  /******************************************************************/
  // Find the frame window.
  IEventResult mr = hwndmain.sendEvent( WM_QUERYFOCUSCHAIN,
                                        IEventParameter1( QFC_FRAME ),
                                        IEventParameter2( 0 ));
  IWindowHandle frame( mr.asUnsignedLong() );

  if ( frame  &&
       (IQUERYWINDOWUSHORT( frame, QWS_FLAGS ) & 0x100) )
  {           // Frame looks like a dialog box.
     clrBackground = IGUIColor( IGUIColor::dialogBgnd );
  }

  return clrBackground;
}
#endif
#ifdef IC_NOTYET
  Will this color model work with Windows???
#endif

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| WinTrackRect                                                                 |
| This function lifted from cclnt\cnr\cnrs3p1.c.  It is an incomplete          |
| implementation of the PM function of the same name.  This version is         |
| designed specifically for use in the split canvas handler.                   |
------------------------------------------------------------------------------*/
int WinTrackRect (HWND hwnd, void* , PTRACKINFO lpTrackInfo)
{
  HWND    hwndFocus = GetFocus ();
  BOOL    fTrack = TRUE;
  RECT    rcTrack, rcBoundary;
  POINT   ptCursor;
  int     xLast, yLast;
  MSG     msg;
  HDC     hdc;
  WORD    wQuitMessage;
  HBITMAP hbmHalftone;
  HBRUSH  hbrshHalftone;
  static  WORD wHalftoneBits[] = { 0xAA, 0x55, 0xAA, 0x55,
                                   0xAA, 0x55, 0xAA, 0x55 };

  if (!(hdc           = GetWindowDC (hwnd))                               ||
      !(hbmHalftone   = CreateBitmap (8, 8, 1, 1, (LPSTR) wHalftoneBits)) ||
      !(hbrshHalftone = CreatePatternBrush (hbmHalftone)))
  {
    if (hdc)          ReleaseDC (hwnd, hdc);
    if (hbmHalftone)  DeleteObject (hbmHalftone);
    return (FALSE);
  }

  /*-----------------------------------------------------------*/
  /* figure out which button will signal the end of the drag;  */
  /* if more than one button is pressed, the left takes        */
  /* precedence, followed by the right, followed by the middle */
  /*-----------------------------------------------------------*/
  wQuitMessage = (GetKeyState (VK_LBUTTON) < 0) ? WM_LBUTTONUP :
                 (GetKeyState (VK_RBUTTON) < 0) ? WM_RBUTTONUP :
                                                  WM_MBUTTONUP;

  /*------------------------------------------------------*/
  /* get the current mouse position in window coordinates */
  /* (we're overloading rcTrack here, but it saves stack) */
  /*------------------------------------------------------*/
  GetCursorPos (&ptCursor);
  GetWindowRect (hwnd, &rcTrack);
  xLast = ptCursor.x - rcTrack.left;
  yLast = ptCursor.y - rcTrack.top;

  /*------------------------------------------------*/
  /* make a working copy of the tracking rectangles */
  /*------------------------------------------------*/
  rcTrack    = lpTrackInfo->rclTrack;

  /*-----------------------------------------------------------------*/
  /* make sure the mouse doesn't move outside the boundary rectangle */
  /*-----------------------------------------------------------------*/
  ITRACE_ALL(IString("lpTrackInfo->rclBoundary=(") +
             IString( lpTrackInfo->rclBoundary.left) + IString(",") +
             IString( lpTrackInfo->rclBoundary.top) + IString(",") +
             IString( lpTrackInfo->rclBoundary.right) + IString(",") +
             IString( lpTrackInfo->rclBoundary.bottom) + IString(")") );
  // We add 1 to the right/bottom to prevent oscillation of the tracking
  // rectangle by 1 pixel.  Seems that if limits of the boundary are ==
  // the mouse position oscillates around the point.
  rcBoundary.left   = ptCursor.x -
                      (rcTrack.left - lpTrackInfo->rclBoundary.left );
  rcBoundary.right  = ptCursor.x +
                      (lpTrackInfo->rclBoundary.right - rcTrack.right ) + 1 ;
  rcBoundary.top    = ptCursor.y -
                      (rcTrack.top  - lpTrackInfo->rclBoundary.top );
  rcBoundary.bottom = ptCursor.y +
                      (lpTrackInfo->rclBoundary.bottom - rcTrack.bottom ) + 1;
  ITRACE_ALL(IString("rcBoundary=(") +
             IString( rcBoundary.left) + IString(",") +
             IString( rcBoundary.top) + IString(",") +
             IString( rcBoundary.right) + IString(",") +
             IString( rcBoundary.bottom) + IString(")") );

  SetCapture (hwnd);
  ClipCursor (&rcBoundary);

  hbrshHalftone = SelectObject (hdc, hbrshHalftone);
  DrawTrackRect (hdc, &rcTrack);

  while (fTrack &&
         (GetFocus() == hwndFocus) &&
         (GetCapture() == hwnd)    &&
         GetMessage (&msg, 0, 0, 0))
  {
    if (msg.message == wQuitMessage)  fTrack = FALSE;

    else switch (msg.message)
    {
      /*-----------------------*/
      /* eat keyboard messages */
      /*-----------------------*/
      case WM_CHAR:
      case WM_KEYUP:
      case WM_KEYDOWN:
      case WM_SYSCHAR:
      case WM_SYSKEYUP:
      case WM_SYSKEYDOWN:
        if (msg.wParam == VK_ESCAPE)  fTrack = FALSE;
        break;

      case WM_MOUSEMOVE:
        {
           int  xDelta = LOWORD (msg.lParam) - xLast;
           int  yDelta = HIWORD (msg.lParam) - yLast;
           ITRACE_ALL(IString("xDelta=") + IString(xDelta)+
                      IString(" x=") + IString(LOWORD (msg.lParam))+
                      IString(" xLast=") + IString(xLast)+
                      IString(" yDelta=") + IString(yDelta)+
                      IString(" y=") + IString(HIWORD (msg.lParam))+
                      IString(" yLast=") + IString(yLast) );
           ITRACE_ALL(IString("rcTrack=(") +
                      IString( rcTrack.left) + IString(",") +
                      IString( rcTrack.top) + IString(",") +
                      IString( rcTrack.right) + IString(",") +
                      IString( rcTrack.bottom) + IString(")") );

           /*-------------------*/
           /* erase, move, draw */
           /*-------------------*/
           DrawTrackRect (hdc, &rcTrack);
           OffsetRect (&rcTrack, xDelta, yDelta);
           DrawTrackRect (hdc, &rcTrack);
           ITRACE_ALL(IString("rcTrack=(") +
                      IString( rcTrack.left) + IString(",") +
                      IString( rcTrack.top) + IString(",") +
                      IString( rcTrack.right) + IString(",") +
                      IString( rcTrack.bottom) + IString(")") );
           xLast += xDelta;
           yLast += yDelta;
        }
        break;

      /*---------------------------------*/
      /* eat other mouse button messages */
      /*---------------------------------*/
      case WM_LBUTTONUP:
      case WM_MBUTTONUP:
      case WM_RBUTTONUP:
      case WM_LBUTTONDOWN:
      case WM_MBUTTONDOWN:
      case WM_RBUTTONDOWN:
      case WM_LBUTTONDBLCLK:
      case WM_MBUTTONDBLCLK:
      case WM_RBUTTONDBLCLK:
        break;

      default:
        DispatchMessage (&msg);
        break;
    }
  }

  /*----------------------------------------------------------------------*/
  /* if we fell out of the loop because GetMessage returned FALSE         */
  /* (i.e. PostQuitMessage was called), put the WM_QUIT back on the queue */
  /*----------------------------------------------------------------------*/
  if (fTrack && (GetFocus() == hwndFocus) && (GetCapture() == hwnd))
  {
    PostQuitMessage (msg.wParam);
  }

  DrawTrackRect (hdc, &rcTrack);
  ClipCursor (NULL);
  ReleaseCapture ();

  DeleteObject (SelectObject (hdc, hbrshHalftone));
  DeleteObject (hbmHalftone);
  ReleaseDC (hwnd, hdc);

  /*---------------------------------------*/
  /* if the user pressed ESC, return FALSE */
  /*---------------------------------------*/
  if ((msg.message == WM_KEYDOWN) && (msg.wParam == VK_ESCAPE))
  {
    return (FALSE);
  }
  /*---------------------------------------*/
  /* otherwise return the drop coordinates */
  /*---------------------------------------*/
  else
  {
    lpTrackInfo->rclTrack = rcTrack;
    return (TRUE);
  }
}

void DrawTrackRect (HDC hdc, LPRECT lprc)
{
  PatBlt (hdc, lprc->left, lprc->top, lprc->right-lprc->left,
               lprc->bottom-lprc->top, PATINVERT);
}

/*------------------------------------------------------------------------------
| isetDefaultPushButton                                                        |
| This function sets the specified pushbutton as the default pushbutton if     |
| the setAsDefault argument is true.  Otherwise, it sets the specified         |
| pushbutton style to non-default button.                                      |
| Action equivalent to the PM code:                                            |
|    pushbutton.sendEvent(BM_SETDEFAULT, setAsDefault, 0)                      |
| We use this instead of DM_SETDEFID so that we can have this behavior in      |
| canvases as well as dialogs.                                                 |
------------------------------------------------------------------------------*/
IEventResult isetDefaultPushButton ( IWindowHandle  pushbutton,
                                     IBase::Boolean setAsDefault )
{
   IEventResult  result = false;
   unsigned long ulStyle = ISTYLEOF(pushbutton);
   unsigned long primaryStyle = ulStyle & BS_PRIMARYSTYLES;
   if ( setAsDefault )
   {
      // make it default
      if (primaryStyle == BS_PUSHBUTTON )
      {
         pushbutton.sendEvent(
                       BM_SETSTYLE,
                       (ulStyle & ~((unsigned long)BS_PRIMARYSTYLES)) |
                          BS_DEFPUSHBUTTON,
                       true );
         // Need to clear default button if set on any other pushbuttons
         IWindowHandle hwndChild = GetWindow( pushbutton, GW_HWNDFIRST);
         while (hwndChild)
            {
            if ( (hwndChild != pushbutton) &&
                 (hwndChild.sendEvent(WM_QUERYDLGCODE, 0, 0) & DLGC_DEFAULT) )
               {

               hwndChild.sendEvent(
                             BM_SETSTYLE,
                             (ISTYLEOF( hwndChild ) &
                                   ~((unsigned long)BS_PRIMARYSTYLES)) |
                                BS_PUSHBUTTON,
                             true );
               }
            hwndChild = GetWindow( hwndChild, GW_HWNDNEXT );
            }


         result = true;
      }
      else if (primaryStyle == BS_DEFPUSHBUTTON )
      {
         result = true;
      }
   }
   else
   {
      // make it non-default
      if (primaryStyle == BS_DEFPUSHBUTTON )
      {
         pushbutton.sendEvent(
                       BM_SETSTYLE,
                       (ulStyle & ~((unsigned long)BS_PRIMARYSTYLES)) |
                          BS_PUSHBUTTON,
                       true );
         result = true;
      }
      else if (primaryStyle == BS_PUSHBUTTON )
      {
         result = true;
      }
   }
   return result;
}

/********************************************************************/
/* iclickButton                                                     */
/* No click equivalent in Windows - Simulate button selection by    */
/* setting focus to the button and then creating a down/up          */
/* keyboard press of the space bar.  The space bar is a selection   */
/* gesture for buttons.                                             */
/********************************************************************/
IEventResult  iclickButton( const IWindowHandle& buttonHandle )
{
   ISETFOCUS(IWindow::desktopWindow()->handle(), buttonHandle );
   keybd_event(VK_SPACE, 0x39, 0, 0);
   keybd_event(VK_SPACE, 0x39, KEYEVENTF_KEYUP, 0);
}
#endif  //IC_WIN

// DEFECT 3717 : available to all platforms now...
/*------------------------------------------------------------------------------
| igetNextDialogItem                                                           |
| Calls GetNextDlgGroupItem/GetNextDlgTabItem based on flag value.  Flag       |
| values are those used in PM WinEnumDlgItem function.                         |
| This is used instead of DM_GETDEFID so that it can be used in canvases as    |
| well as dialogs.                                                             |
------------------------------------------------------------------------------*/
IWindowHandle igetNextDialogItem ( IWindowHandle dialog,
                                   IWindowHandle child,
                                   unsigned long flags )
{
   IMODTRACE_ALL( "igetNextDialogItem " ) ;
   ITRACE_ALL( IString( " dialog=" ) +
                  IString( dialog.asUnsigned() ).d2x() +
                  IString( " child=" ) +
                  IString( child.asUnsigned() ).d2x() +
                  IString( " flags=" ) +
                  IString( flags ).d2x() );
   HWND hwnd = 0;

#ifdef IC_WIN                             // DEFECT 3717
   // set up initial child
   HWND hwndChild = child;
   // find immediate child of dialog window
   if (hwndChild)
      {
      HWND parent = IPARENTOF(hwndChild);
      while ( (parent != dialog) && (parent) )
         {
         hwndChild = parent;
         parent = IPARENTOF(hwndChild);
         }
      if (!parent)
         hwndChild = 0;   // bogus child ... default to first
      }

   switch (flags)
      {
// There appears to be a problem in the NT GetNextDlgTabItem function.
// It traps if there are no child controls with WS_TABSTOP in certain cases.
// Therefore we implement it ourselves
//         case EDI_FIRSTTABITEM    :
//            hwnd = GetNextDlgTabItem( dialog, 0, false );
//            break;
//         case EDI_LASTTABITEM     :
//            hwnd = GetNextDlgTabItem( dialog, 0, true );
//            break;
//         case EDI_NEXTTABITEM     :
//            hwnd = GetNextDlgTabItem( dialog, hwndChild, false );
//            break;
//         case EDI_PREVTABITEM     :
//            hwnd = GetNextDlgTabItem( dialog, hwndChild, true );
//            break;
      case EDI_FIRSTTABITEM    :
      case EDI_LASTTABITEM     :
         {
         // set up direction
         unsigned direction =
            (flags == EDI_FIRSTTABITEM)  ? GW_HWNDNEXT : GW_HWNDPREV;
         // set up first window
         hwndChild = GetWindow( dialog, GW_CHILD );
         if ((hwndChild) && (direction == GW_HWNDPREV))
            hwndChild = GetWindow( hwndChild, GW_HWNDLAST);

         // find next or previous child with WS_TABSTOP set
         while ( (hwndChild ) && (hwnd == 0) )
            {
            ITRACE_ALL( IString("hwndChild=") +
                        IString( (unsigned long)hwndChild).d2x() );

            if ((ISTYLEOF(hwndChild) & (WS_TABSTOP | WS_DISABLED | WS_VISIBLE))
                 ==
                (WS_TABSTOP | WS_VISIBLE) )  // 3717
            {
               //-------------------------------------------------------------------
               // DEFECT 23642 :
               //-------------------------------------------------------------------
               IWindow* pwndChild = IWindow::windowWithHandle( hwndChild );
               IWindowClassName className( hwndChild );
               if ( (className == WC_STATIC) && pwndChild->isTabStop() )
                  {
                  // static with a tabstop "should be" a canvas wnd
                  // So... only use this wnd IF it has a tabstop child
                  HWND hwndChildTab;
                  hwndChildTab = IENUMDLGITEM(hwndChild, 0, EDI_FIRSTTABITEM);
                  if (hwndChildTab)
                     hwnd = hwndChild;
                  }
               else
               //-------------------------------------------------------------------
                  hwnd = hwndChild;
            }

            hwndChild = GetWindow( hwndChild, direction);
            }
         }   // case
         break;
      case EDI_NEXTTABITEM     :
      case EDI_PREVTABITEM     :
         {
         // set up direction
         unsigned direction =
            (flags == EDI_NEXTTABITEM) ? GW_HWNDNEXT : GW_HWNDPREV;
         if (hwndChild == 0)
            {
            // get a child to verify at least 1
            hwndChild = GetWindow( dialog, GW_CHILD );
            }
         // set starting point
         HWND hwndStart = hwndChild;

         ITRACE_ALL( IString("hwndStart=") +
                     IString( (unsigned long)hwndStart).d2x() );
         // find next or previous child with WS_TABSTOP set
         if (hwndStart)
            {
            do
               {
               hwndChild = GetWindow(hwndChild, direction);
               // handle wrap around ....
               if (hwndChild == 0)
                  {
                  // wrapped
                  if (direction == GW_HWNDNEXT)
                     hwndChild = GetWindow( hwndStart, GW_HWNDFIRST);
                  else
                     hwndChild = GetWindow( hwndStart, GW_HWNDLAST);
                  }
               ITRACE_ALL( IString("hwndChild=") +
                           IString( (unsigned long)hwndChild).d2x() );

               if ((ISTYLEOF(hwndChild) & (WS_TABSTOP | WS_DISABLED | WS_VISIBLE))
                    ==
                   (WS_TABSTOP | WS_VISIBLE) )  // 3717
                  {
                     //-------------------------------------------------------------------
                     // DEFECT 23642 :
                     //-------------------------------------------------------------------
                     IWindow* pwndChild = IWindow::windowWithHandle( hwndChild );
                     IWindowClassName className( hwndChild );
                     if ( (className == WC_STATIC) && pwndChild->isTabStop() )
                        {
                        // static with a tabstop "should be" a canvas wnd
                        // So... only use this wnd IF it has a tabstop child
                        HWND hwndChildTab;
                        hwndChildTab = IENUMDLGITEM(hwndChild, 0, EDI_FIRSTTABITEM);
                        if (hwndChildTab)
                           hwnd = hwndChild;
                        }
                     else
                     //-------------------------------------------------------------------
                        hwnd = hwndChild;
                  }
               }
            while ( (hwndChild != hwndStart) && (hwnd == 0) );

            }  // if

         }   // case
         break;
      case EDI_FIRSTGROUPITEM  :
         hwnd = GetNextDlgGroupItem( dialog, 0, false );
         break;
      case EDI_LASTGROUPITEM   :
         hwnd = GetNextDlgGroupItem( dialog, 0, true );
         break;
      case EDI_NEXTGROUPITEM   :
         hwnd = GetNextDlgGroupItem( dialog, hwndChild, false );
         break;
      case EDI_PREVGROUPITEM   :
         hwnd = GetNextDlgGroupItem( dialog, hwndChild, true );
         break;
      }
#else                         // DEFECT 3717
   //---------------------------------------------------
   // DEFECT 3717 : do not return WinEnumDlgItem result
   //    for TAB items if the hwnd is disabled
   //---------------------------------------------------
   switch (flags)
   {
      case EDI_FIRSTTABITEM    :
      case EDI_LASTTABITEM     :
         {
            HWND hwndChild, hwndWrap;
            unsigned long newFlags;
            newFlags = (flags == EDI_FIRSTTABITEM) ? EDI_NEXTTABITEM : EDI_PREVTABITEM;
   
            hwndWrap = hwndChild = WinEnumDlgItem(dialog, child, flags);
            while ( (hwndChild ) && (hwnd == 0) )
            {
               IWindow* pwndChild = IWindow::windowWithHandle( hwndChild );
               if ( pwndChild && pwndChild->isEnabled() )
               {
                  //-------------------------------------------------------------------
                  // DEFECT 23642 :
                  //-------------------------------------------------------------------
                  IWindowClassName className( hwndChild );
                  if ( (className == WC_STATIC) && pwndChild->isTabStop() )
                  {
                     // static with a tabstop "should be" a canvas wnd
                     // So... only use this wnd IF it has a tabstop child
                     HWND hwndChildTab;
                     hwndChildTab = IENUMDLGITEM(hwndChild, 0, EDI_FIRSTTABITEM);
                     if (hwndChildTab)
                        hwnd = hwndChild;
                  }
                  else
                  //-------------------------------------------------------------------
                     hwnd = hwndChild;
               }

               if (hwnd==0)   // not yet found; continue searching list for a tabstop child
               {
                  hwndChild = WinEnumDlgItem(dialog, child, newFlags);
                  if (hwndChild == hwndWrap) // wrapped around, none found.
                     hwndChild = 0;
               }
            }
         }
         break;

      case EDI_NEXTTABITEM    :
      case EDI_PREVTABITEM     :
         {
            HWND hwndChild, hwndWrap;
   
            hwndWrap = hwndChild = WinEnumDlgItem(dialog, child, flags);
            if ( hwndChild == child ) {   // wrapped already... NO next/prev tab...
               hwndChild = 0;
            }
            while ( (hwndChild ) && (hwnd == 0) )
            {
               IWindow* pwndChild = IWindow::windowWithHandle( hwndChild );
               if ( pwndChild && pwndChild->isEnabled() )
               {
                  //-------------------------------------------------------------------
                  // DEFECT 23642 :
                  //-------------------------------------------------------------------
                  IWindowClassName className( hwndChild );
                  if ( (className == WC_STATIC) && pwndChild->isTabStop() )
                  {
                     // static with a tabstop "should be" a canvas wnd
                     // So... only use this wnd IF it has a tabstop child
                     HWND hwndChildTab;
                     hwndChildTab = IENUMDLGITEM(hwndChild, 0, EDI_FIRSTTABITEM);
                     if (hwndChildTab)
                        hwnd = hwndChild;
                  }
                  else
                  //-------------------------------------------------------------------
                     hwnd = hwndChild;
               }

               if (hwnd==0)   // not yet found; continue searching list for a tabstop child
               {
                  hwndChild = WinEnumDlgItem(dialog, child, flags);
                  if (hwndChild == hwndWrap) // wrapped around, none found.
                     hwndChild = 0;
               }
            }
         }
         break;

      case EDI_FIRSTGROUPITEM  :
      case EDI_LASTGROUPITEM   :
      case EDI_NEXTGROUPITEM   :
      case EDI_PREVGROUPITEM   :
         hwnd = WinEnumDlgItem(dialog, child, flags);
         break;
   }
#endif

   ITRACE_ALL(("hwnd=") + IString((unsigned long)hwnd).d2x() );
   return hwnd;
}

