#ifndef _IKEYEVT_
  #define _IKEYEVT_
/*******************************************************************************
* FILE NAME: ikeyevt.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IKeyboardEvent                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>

class IString;
class IKeyboardEventPrivateData;

#pragma pack(4)

class IKeyboardEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------ Constructors --------------------------------*/
  IKeyboardEvent     ( const IEvent& event );
  // DEFECT 25402 : must override system-provided copy constructor to
  //                avoid bit-copy of pData pointer into both events.
  IKeyboardEvent     ( const IKeyboardEvent& event );
virtual
 ~IKeyboardEvent     ( );

/*--------------------------------- Testing ----------------------------------*/
Boolean
  isCharacter        ( ) const,
  isScanCode         ( ) const,
  isVirtual          ( ) const,
  isUpTransition     ( ) const,
  isRepeat           ( ) const,
  isShiftDown        ( ) const,
  isCtrlDown         ( ) const,
  isAltDown          ( ) const,
  isForComposite     ( ) const;
#ifndef IC_WIN
Boolean
  isUncombined       ( ) const,
  isComposite        ( ) const,
  isInvalidComposite ( ) const;
#endif

/*-------------------------------- Accessors ---------------------------------*/
char
  character          ( ) const;
IString
  mixedCharacter     ( ) const;
unsigned long
  scanCode           ( ) const;

enum VirtualKey
{
  esc, tab, backTab, space, backSpace, enter, newLine,
  shift, ctrl, altGraf, insert, deleteKey, home, end,
  pageUp, pageDown, left, right, up, down,
  capsLock, numLock, scrollLock, pause, sysRq, breakKey,
  f2, f3, f4, f5, f6, f7, f8, f9, f11, f12,
  f13, f14, f15, f16, f17, f18, f19, f20, f21, f22, f23, f24,
  button1, button2, button3, other
#ifndef IC_WIN
  , endDrag, firstDBCS, lastDBCS, firstUser, lastUser
#endif
#ifdef IC_MOTIF
  , f1, f10,
  f25, f26, f27, f28, f29, f30, f31, f32, f33, f34, f35,
  pf1, pf2, pf3, pf4,
  clear, select, print, execute, undo, redo, menu, find,
  cancel, help, modeSwitch, alt,
  shiftLock, begin, meta, super, hyper, multiKey,
  kanji, muhenkan, henkanMode, romaji, hiragana,
  katakana, hiraganaKatakana, zenkaku, hankaku, zenkakuHankaku,
  touroku, massyo, kanaLock, kanaShift, eisuShift,
  eisuToggle
#endif
#ifdef IC_WIN
  , f1, f10
#endif
};

VirtualKey
  virtualKey         ( ) const;

unsigned long
  repeatCount        ( ) const;

#ifdef IC_MOTIF
static unsigned long
  ulShiftMask,
  ulAltMask,
  ulCtrlMask;
#endif

protected:
  // DEFECT 25402 : must override system-provided default constructor
  //                to at least initialize pData pointer.
  IKeyboardEvent     ( );
/*------------------------------ Implementation ------------------------------*/
static const unsigned long
#ifndef IC_WIN
  ulCharacterFlag,
  ulScanCodeFlag,
  ulVirtualFlag,
  ulRepeatFlag,
  ulUncombinedFlag,
  ulShiftFlag,
  ulCtrlFlag,
  ulForCompositeFlag,
  ulCompositeFlag,
  ulInvalidCompositeFlag,
#endif
  ulUpTransitionFlag,
  ulAltFlag;

private:

IKeyboardEventPrivateData
 *pData;
}; // IKeyboardEvent

#pragma pack()

/*----------------------------- Inline Functions -----------------------------*/
#ifndef I_NO_INLINES
  #include <ikeyevt.inl>
#endif

#endif /* _IKEYEVT_ */
