/*******************************************************************************
* FILE NAME: irefcnt.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in irefcnt.hpp.                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <irefcnt.hpp>
#include <isafeid.hpp>


// Segment definitions
#ifdef IC_PAGETUNE
  #define _IREFCNT_CPP_
  #include <ipagetun.h>
#endif


/*------------------------------------------------------------------------------
| IRefCounted::IRefCounted                                                     |
|                                                                              |
| Constructor sets the the reference count to 1.                               |
------------------------------------------------------------------------------*/
IRefCounted :: IRefCounted ( )
  : refCount( 1 )
  {
  }

/*------------------------------------------------------------------------------
| IRefCounted::~IRefCounted                                                    |
------------------------------------------------------------------------------*/
IRefCounted :: ~IRefCounted ( )
  {
  }

/*------------------------------------------------------------------------------
| IRefCounted::addRef                                                          |
|                                                                              |
| Add a reference by incrementing the reference count                          |
------------------------------------------------------------------------------*/
void IRefCounted :: addRef ( )
  {
  ISafeIncDec::increment(refCount);
  }

/*------------------------------------------------------------------------------
| IRefCounted::removeRef                                                       |
|                                                                              |
| Remove a reference by decrementing the reference count. If the refernce      |
| count goes to 0 then delete this.                                            |
------------------------------------------------------------------------------*/
void IRefCounted :: removeRef ( )
  {
  ISafeIncDec::decrement(refCount);
  if ( refCount == 0 )
    delete this;
  }
