/* ------------------------------------------------------------------ */
/* OS/2 Rexx file to start Netmush                                    */
/* ------------------------------------------------------------------ */

/* Stuff from mush.config                                             */

GAMEDIR="."                               /* Not actually used here.  */
GAMENAME="netmush"                        /* Filename base            */
OWNER="mush_admin@your_site.your_domain"  /* Not actually used here.  */

/* You should never need to change these.                             */

NEW_DB=GAMENAME||".db.new"
INPUT_DB=GAMENAME||".db"
GDBM_DB=GAMENAME||".gdbm"
CRASH_DB=GAMENAME||".db.CRASH"
SAVE_DB=GAMENAME||".db.old"
BACKUP_DB=GAMENAME||".db.bk"
LOGNAME=GAMENAME||".log"
SAVENAME=GAMENAME||".tar.Z"

MAKE_DB=""

/* Make sure there isn't already a MUSH running.                      */

if isrun( netmush.exe ) then
do
  say "MUSH already running."
  exit 0
end

/* Make sure the indices are up to date.                              */

'@mkindx news.txt news.indx'
'@mkindx help.txt help.indx'
'@mkindx wizhelp.txt wizhelp.indx'

/* Check for a panic dump.  If there is one and it is good, copy      */
/* it on top of the last checkpoint DB written by mush.  If it is     */
/* bad, just delete it.                                               */

if FileExist( CRASH_DB ) == 1 then
do
  if checkdb( CRASH_DB ) == 1 then
  do
    if FileExist( NEW_DB ) == 1 then '@del ' || NEW_DB || ' > nul'
    '@rename ' || CRASH_DB || ' ' || NEW_DB || ' > nul'
  end
  else
  do
    '@del ' || CRASH_DB || ' > nul'
    say "Warning: PANIC dump corrupt using older db."
  end
end

/* Save a copy of the previous input database and log.                */

if FileExist( INPUT_DB ) == 1 then
do
  if FileExist( SAVE_DB ) == 1 then '@del ' || SAVE_DB || ' > nul'
  '@rename ' || INPUT_DB || ' ' || SAVE_DB || ' > nul'
end

/* Copy the log to log.old                                            */

if FileExist( LOGNAME ) == 1 then
do
  if FileExist( LOGNAME || '.old' ) then '@del ' || LOGNAME || '.old' || ' > nul'
  '@rename ' || LOGNAME || ' ' || LOGNAME || '.old' || ' > nul'
end

/* If we have a good checkpoint database, make it the input database. */
/* If not, use the backup of the input database.                      */

if FileExist( NEW_DB ) == 1 then
do
  if FileExist( INPUT_DB ) == 1 then '@del ' || INPUT_DB || ' > nul'
  '@rename ' || NEW_DB || ' ' || INPUT_DB || ' > nul'
end
else
do
  if FileExist( SAVE_DB ) == 1 then
  do
    say "No recent checkpoint db. Using older db."
    '@copy ' || SAVE_DB || ' ' || INPUT_DB || ' > nul'
  end
  else
  do
    say "No recent db. Will initialise new database."
    MAKE_DB = '-s'
  end
end

say "Starting netmush..."
'@netmush ' || MAKE_DB || ' ' || GAMENAME || '.conf' /* '.conf > ' || LOGNAME || ' 2>&1' */

exit 0

/* ------------------------------------------------------------------ */
/* FileExist() and isrun() were cribbed from "REXX Tips & Tricks".    */
/* ------------------------------------------------------------------ */

/* ------------------------------------------------------------------ */
/* function: Check if a file exists                                   */
/*                                                                    */
/* returns:  -2 - invalid parameter                                   */
/*           -1 - cannot detect (e.g. the drive is not ready)         */
/*            0 - neither a file, a device nor a directory with this  */
/*                name exist                                          */
/*            1 - the file exist                                      */
/*            2 - a device driver with the name exists                */
/*            3 - a directory with the name exists                    */
/*                                                                    */
FileExist: PROCEDURE
  parse arg fileName .
  SIGNAL ON NOTREADY NAME FileExistError
  SIGNAL ON FAILURE  NAME FileExistError
  SIGNAL ON ERROR    NAME FileExistError
  thisRC = -2
  if strip( fileName ) <> "" then
  do
    thisRC = -1
    call stream fileName
    SIGNAL OFF NOTREADY
    if stream( fileName, "c", "QUERY EXISTS" ) <> "" then
    do
      if stream( fileName, "c", "QUERY DATETIME" ) == "" then
        thisRC = 2
      else
        thisRC = 1
    end
    else
    do
      thisDir = directory()
      tempDir = directory( fileSpec( "Drive", fileName ) )
      if directory( fileName ) <> "" then
        thisRC = 3
      else
        thisRC = 0
      call directory tempDir
      call directory thisDir
    end
  end
FileExistError:
RETURN thisRC
 
/* ------------------------------------------------------------------ */
/* function: isrun.cmd checks if a specific program is running        */
/*                                                                    */
/* returns:  0 - program is not running                               */
/*           1 - program is running                                   */
/*           2 - usage error                                          */
/*                                                                    */
/* Notes:    This program needs the program PSTAT to be in a          */
/*           directory in the PATH                                    */
/*                                                                    */
isrun: PROCEDURE
  thisRC = 0
  parse upper arg progname
  if progName = '' | pos( '?', progName ) <> 0 then
  do
    say 'Usage: isrun exeName'
    thisRC = 2
  end
  if thisRC = 0 then
  do
    do while queued() <> 0; parse pull; end;
    i = lastPos( '.', progName )
    j = lastPos( '\', progName )
    if ( i = 0 ) | ( i < j ) then
      progName = progName || '.EXE'
    '@pstat /c | rxqueue'
    processList.0 = 0
    do while queued() <> 0
      curLine = lineIn( 'QUEUE:' )
      parse upper var curLine ,
        1 ProcessID 11 ParentProcessID 21 SessionID 31 exeName .
      if pos( '\', exeName ) <> 0 then
      do
        i = processList.0+1
        processList.i = strip( exeName )
        processList.0 = i
      end
    end
    do i = 1 to processList.0 while thisRC = 0
      if pos( '\', progName )= 0 then
        thisRC = (progname = translate( filespec( 'n', processList.i ) ) )
      else
        thisRC = ( progName = processList.i )
    end
  end
RETURN thisRC

/* ------------------------------------------------------------------ */
/* function: checkdb makes sure the database was written fully        */
/*                                                                    */
/* returns:  0 - database not written                                 */
/*           1 - database written                                     */
/*                                                                    */
checkdb: PROCEDURE
  thisRC = 0
  parse arg filename
  do
    '@type ' || filename || ' | rxqueue'
    processList.0 = 0
    do while queued() <> 0
      curLine = lineIn( 'QUEUE:' )
      if curLine == '***END OF DUMP***' then thisRC = 1
    end
  end
RETURN thisRC
