#define DIVE_ENABLED
#define VCAI_ENABLED
#define VCAI_MONITOR

#define INCL_DOS
#define INCL_PM
#define INCL_OS2MM
#define INCL_SW
#define INCL_GPI
#define INCL_WIN
#define INCL_32

#include <os2.h>
#include <os2me.h>
#include <stdio.h>
#include <stdlib.h>

#define  _MEERROR_H_
#include <mmioos2.h>                   /* It is from MMPM toolkit           */
#include <dive.h>
#include <fourcc.h>
#include <vcadd.h>
#include <vcai.h>

#include "wtv.h"

/* External variables                                                       */
extern HWND HwndNBFrame;                /* Notebook frame handle            */
extern BOOL NotebookOpen;               /* Is notebook open?                */

static HWND                 hwndNotebook;       /* handle to the window     */

/* This function handles the call to the mmos2 setup notebook               */
MRESULT EXPENTRY NotebookDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static BOOL                 start;
static PWINDATA             win_data = NULL;    /* Pointer to window data   */
MCI_DEVICESETTINGS_PARMS    mci;                /* The notebook thru' MCI   */
HPS                         hps;
RECTL                       rcl;
ULONG                       id, result;
HWND                        hwndPage;
LONG                        bx, by, cx, cy, ty, x, y;
SWP                         swp;
char                        txt[100];

    /* Get the pointer to window data                                       */
    if (win_data == NULL)
    {
        if ((win_data = (PWINDATA)WinQueryWindowULong (hwnd, 0)) == NULL)
            return WinDefWindowProc (hwnd, msg, mp1, mp2);
    }

    switch (msg)
    {
    case WM_INITDLG:
        /* Set the notebook in the correct colours etc.                     */
        hwndNotebook = WinWindowFromID (hwnd, IDD_NOTE_BOOK);
        WinSendMsg (hwndNotebook,
                    BKM_SETNOTEBOOKCOLORS, MPFROMLONG (CLR_PALEGRAY),
                    MPFROMSHORT (BKA_BACKGROUNDPAGECOLORINDEX));
        WinSendMsg (hwndNotebook,
                    BKM_SETNOTEBOOKCOLORS, MPFROMLONG (CLR_PALEGRAY),
                    MPFROMSHORT (BKA_BACKGROUNDMAJORCOLORINDEX));
        WinSendMsg (hwndNotebook,
                    BKM_SETNOTEBOOKCOLORS, MPFROMLONG (CLR_PALEGRAY),
                    MPFROMSHORT (BKA_BACKGROUNDMINORCOLORINDEX));
        cy = WinQuerySysValue (HWND_DESKTOP, SV_CYSCREEN);
        if (cy <= 480)
        {
            WinSendMsg (hwndNotebook, BKM_SETDIMENSIONS,
                        MPFROM2SHORT (100, 24),
                        MPFROMSHORT (BKA_MAJORTAB));
            WinSendMsg (hwndNotebook, BKM_SETDIMENSIONS,
                        MPFROM2SHORT (75, 24),
                        MPFROMSHORT (BKA_MINORTAB));
        }
        else
        {
            WinSendMsg (hwndNotebook, BKM_SETDIMENSIONS,
                        MPFROM2SHORT (150, 24),
                        MPFROMSHORT (BKA_MAJORTAB));
            WinSendMsg (hwndNotebook, BKM_SETDIMENSIONS,
                        MPFROM2SHORT (100, 24),
                        MPFROMSHORT (BKA_MINORTAB));
        }
        mci.hwndCallback = HwndNBFrame;
        mci.hwndNotebook = hwndNotebook;
        mci.usDeviceType = 12;
        sprintf (txt, "TV0%ld", win_data->win_vcai_no);
        mci.pszDeviceName = txt;
        hwndPage = (HWND)InsertAddr (&mci);
        if (!hwndPage)
        {
            WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
                           (PSZ)"Unable to load setup pages",
                           (PSZ)WTV_NAME,
                           0, MB_OK | MB_ERROR);
            return 0;
        }
        NotebookOpen = TRUE;
        start = TRUE;
        WinPostMsg (hwnd, WM_PAINT, NULL, NULL);
        break;

    case WM_PAINT :
        if (start)
        {
            cx = WinQuerySysValue (HWND_DESKTOP, SV_CXSCREEN);
            cy = WinQuerySysValue (HWND_DESKTOP, SV_CYSCREEN);
            x = cx / 8L;
            y = 0L;
            if (cy <= 480)
            {
                cx = 480;
                cy = 480;
            }
            else
            {
                cx = 640;
                cy = 600;
            }
            WinSetWindowPos (HwndNBFrame, HWND_TOP, x, y, cx, cy,
                             SWP_SIZE | SWP_MOVE | SWP_SHOW);
            WinQueryWindowRect (HwndNBFrame, &rcl);
            bx = WinQuerySysValue (HWND_DESKTOP,
                                   SV_CXSIZEBORDER);
            by = WinQuerySysValue (HWND_DESKTOP,
                                   SV_CYSIZEBORDER);
            ty = WinQuerySysValue (HWND_DESKTOP, SV_CYTITLEBAR);
            WinSetWindowPos (hwndNotebook, HWND_TOP,
                             bx, by, rcl.xRight - (bx * 2),
                             rcl.yTop - ty - (by * 2),
                             SWP_SIZE | SWP_MOVE | SWP_SHOW);
            start = FALSE;
        }
        hps = WinBeginPaint (hwnd, NULLHANDLE, &rcl);
        WinQueryWindowRect (hwnd, &rcl);
        WinFillRect (hps, &rcl, CLR_PALEGRAY);
        WinEndPaint (hps);
        break;

    case WM_ADJUSTWINDOWPOS :
    case WM_MOVE :
    case WM_SIZE :
    case WM_WINDOWPOSCHANGED :
        WinQueryWindowRect (HwndNBFrame, &rcl);
        bx = WinQuerySysValue (HWND_DESKTOP, SV_CXSIZEBORDER);
        by = WinQuerySysValue (HWND_DESKTOP, SV_CYSIZEBORDER);
        ty = WinQuerySysValue (HWND_DESKTOP, SV_CYTITLEBAR);
        WinSetWindowPos (hwndNotebook, HWND_TOP,
                         bx, by, rcl.xRight - (bx * 2),
                         rcl.yTop - ty - (by * 2),
                         SWP_SIZE | SWP_MOVE | SWP_SHOW);
        break;

    case WM_COMMAND :
        return ((MRESULT)FALSE);

    case WM_CLOSE :
        WinDestroySecondaryWindow (HwndNBFrame);
        return ((MRESULT)FALSE);

    case WM_DESTROY :
        WinPostMsg (win_data->win_hwnd_frame, WM_SIZE, NULL, NULL);
        NotebookOpen = FALSE;
        break;

    default :
        break;
    }
    return WinDefSecondaryWindowProc (hwnd, msg, mp1, mp2);
}
