
/*------------------------------------------------------------------*
 *                                                                  *
 *  Video Toolkit For OS/2 Version 1.0                              *
 *  Example PM Application No. 2.                                   *
 *  Written by Stephen Sloan.                                       *
 *  Date : 22/02/95.                                                *
 *  Copyright (c) Abbotsbury Software Ltd., United Kingdom. 1995.   *
 *                                                                  *
 *  Filename : tune.c                                               *
 *                                                                  *
 *------------------------------------------------------------------*/

#define     INCL_PM
#define     INCL_DOS
#define     INCL_OS2MM
#define     INCL_SW
#ifndef     DIM
#define     DIM(a) (sizeof(a)/sizeof(a[0]))
#endif

#include    <os2.h>
#include    <os2me.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    <vcadd.h>
#include    <vcai.h>
#include    "ex2.h"
#include    "region.h"
#include    "tune.h"

extern  void    msg_box (UCHAR *txt, UCHAR *title, ULONG options);
extern  LONG    get_colour (HPS hps);

extern  DRIVERHANDLE    DevHandle;
extern  USHORT  DevInstance;
extern  CHAR    DevType[20];
extern  HAB     Hab;
extern  HWND    HwndFrame;
extern  LONG    ColourKey;
extern  LONG    Colours[256];
extern  LONG    NumColours;

static  CHAR    RegionFile[256];
static  CHAR    RegionBase[256];
static  CHAR    RegionNames[32][24];
static  USHORT  NumRegions;
static  CHAR    txt[256];
static  CHAR    txt2[256];
static  BOOL    SrcInit, RegionInit, VFInit;

MRESULT EXPENTRY TuneDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

static  void    position_tv (HWND hwnd, USHORT tv);
static  void    enable_tuner_options (HWND hwnd);
static  void    disable_tuner_options (HWND hwnd);
static  void    init_src_listbox (HWND hwnd);
static  void    init_region_listbox (HWND hwnd);
static  void    init_vf_listbox (HWND hwnd);
static  USHORT  load_celeb_src_data (PSOURCE_DATA psrc);
static  USHORT  load_celeb_vf_data (PVIDEO_FORMAT_DATA pvf);
static  USHORT  load_highq_src_data (PSOURCE_DATA psrc);
static  USHORT  load_highq_vf_data (PVIDEO_FORMAT_DATA pvf);
static  USHORT  load_prism_src_data (PSOURCE_DATA psrc);
static  USHORT  load_prism_vf_data (PVIDEO_FORMAT_DATA pvf);
static  USHORT  load_encore_src_data (PSOURCE_DATA psrc);
static  USHORT  load_encore_vf_data (PVIDEO_FORMAT_DATA pvf);

static  SOURCE_DATA     SrcData[MAX_SOURCES];
static  USHORT          NumSrcs;
static  VIDEO_FORMAT_DATA   VFData[MAX_VIDEO_FORMATS];
static  USHORT              NumVFs;

static  UCHAR   *Copyright =
  "Copyright (c) Abbotsbury Software Ltd., UK. 1994-1998. All Rights Reserved";

                        // functions.
MRESULT EXPENTRY TuneDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    static  ULONG   freq, ch, no_freq, region, vi, ck;
    static  LONG    fine;
    ULONG   max_ch, id, ul;
    APIRET  rc;
    USHORT  notify_code, src, vf;
    USHORT  lv, rv, lb, rb, lt, rt, mute;
    HPS     hps;
    RECTL   rcl, rcl_tv;
    UINT    i, j;
    USHORT  keytype;
    SHORT   data;
    HWND    hwnd_ef, hwnd_tv;
    UCHAR   *s;
    LONG    bx, by, dy, x, y;
    POINTL  pts;
    BOOL    valid;

        switch (msg)
        {
            case WM_INITDLG :
                if (stricmp (DevType, "celeb") == 0)
                {
                    NumSrcs = load_celeb_src_data (&SrcData[0]);
                    NumVFs  = load_celeb_vf_data (&VFData[0]);
                }
                if (stricmp (DevType, "highq") == 0)
                {
                    NumSrcs = load_highq_src_data (&SrcData[0]);
                    NumVFs  = load_highq_vf_data (&VFData[0]);
                }
                if (stricmp (DevType, "prism") == 0)
                {
                    NumSrcs = load_prism_src_data (&SrcData[0]);
                    NumVFs  = load_prism_vf_data (&VFData[0]);
                }
                if (stricmp (DevType, "encore") == 0)
                {
                    NumSrcs = load_celeb_src_data (&SrcData[0]);
                    NumVFs  = load_celeb_vf_data (&VFData[0]);
                }
                if (stricmp (DevType, "encor") == 0)
                {
                    NumSrcs = load_celeb_src_data (&SrcData[0]);
                    NumVFs  = load_celeb_vf_data (&VFData[0]);
                }
                vi = VcaiVideoInputQuery ();
                if (SrcData[vi].src_tuner_flag)
                    enable_tuner_options (hwnd);
                else
                    disable_tuner_options (hwnd);
                init_src_listbox (hwnd);
                init_region_listbox (hwnd);
                init_vf_listbox (hwnd);
                VcaiTunerGet (&region, &ch, &freq, &fine);
                WinPostMsg (hwnd, MSG_CHANGE_TUNER, NULL, NULL);
                break;
            case WM_PAINT :
                hps = WinBeginPaint (hwnd, NULLHANDLE, &rcl);
                WinQueryWindowRect (hwnd, &rcl);
                WinFillRect (hps, &rcl, CLR_PALEGRAY);
                WinDrawBorder (hps, &rcl, x, y, 0L, 0L,
                               DB_AREAATTRS | DB_DLGBORDER);
                WinEndPaint (hps);
                hps = WinBeginPaint (WinWindowFromID (hwnd, IDD_TUNE_TV),
                                     NULLHANDLE, &rcl);
                WinQueryWindowRect (WinWindowFromID (hwnd, IDD_TUNE_TV),
                                    &rcl);
                ColourKey = get_colour (hps);
                if ((ULONG)NumColours <= 256)
                    WinFillRect (hps, &rcl, Colours[ColourKey]);
                else
                    WinFillRect (hps, &rcl, ColourKey);
                WinEndPaint (hps);
                position_tv (hwnd, IDD_TUNE_TV);
                break;
            case WM_MOVE :
                position_tv (hwnd, IDD_TUNE_TV);
                break;
            case WM_COMMAND :
                switch (SHORT1FROMMP (mp1))
                {
                    case DID_OK :
                        WinPostMsg (HwndFrame, MSG_UPDATE_WINDOW, NULL, NULL);
                        WinDismissDlg (hwnd, TRUE);
                        break;
                    default :
                        break;
                }
                break;
            case WM_CONTROL :
                notify_code = (USHORT)SHORT2FROMMP (mp1);
                switch (SHORT1FROMMP (mp1))
                {
                    case IDD_TUNE_SRC :
                        if ((notify_code != CBN_LBSELECT) &&
                            (notify_code != CBN_EFCHANGE))
                            return 0;
                        if (SrcInit)
                            return 0;
                        WinQueryDlgItemText (hwnd, IDD_TUNE_SRC, 80L, txt2);
                        if (strcmp ("", txt2) == 0)
                            return 0;
                        valid = FALSE;
                        for (i = 0; i < NumSrcs; i++)
                        {
                            if (strcmp (SrcData[i].src_string, txt2) == 0)
                            {
                                src = i;
                                valid = TRUE;
                                break;
                            }
                        }
                        if (!valid)
                            return 0;
                        VcaiVideoInputSet (src);
                        if (SrcData[src].src_tuner_flag)
                            enable_tuner_options (hwnd);
                        else
                            disable_tuner_options (hwnd);
                        return 0;
                    case IDD_TUNE_REGION :
                        if ((notify_code != CBN_LBSELECT) &&
                            (notify_code != CBN_EFCHANGE))
                            return 0;
                        if (RegionInit)
                            return 0;
                        WinQueryDlgItemText (hwnd, IDD_TUNE_REGION, 80L, txt2);
                        if (strcmp ("", txt2) == 0)
                            return 0;
                        valid = FALSE;
                        VcaiTunerGet (&region, &ch, &freq, &fine);
                        for (i = 0; i < NumRegions; i++)
                        {
                            if (strcmp (&RegionNames[i][0], txt2) == 0)
                            {
                                region = i;
                                valid = TRUE;
                                break;
                            }
                        }
                        if (!valid)
                            return 0;
                        WinSendDlgItemMsg (hwnd, IDD_TUNE_REGION,
                                           LM_QUERYITEMTEXT,
                                           MPFROM2SHORT (region,
                                                         sizeof (RegionFile)),
                                           MPFROMP (RegionFile));
                        strcpy (txt2, RegionBase);
                        strcat (txt2, RegionFile);
                        ch = 0;
                        max_ch = get_region_data (txt2);
                        for (i = 0; i < max_ch; i++)
                        {
                            if (freq == Region_frequencies[i])
                                ch = i;
                        }
                        if (ch == 0)
                            ch = Region_lowchannel;
                        freq = Region_frequencies[ch];
                        VcaiTunerSet (region, ch, freq, fine, 0, 0);
                        sprintf (txt, "%lu", freq);
                        WinSetDlgItemText (hwnd, IDD_TUNE_FREQ, txt);
                        WinSendMsg (WinWindowFromID (hwnd, IDD_TUNE_FINE),
                                    SLM_SETSLIDERINFO,
                                    MPFROM2SHORT (SMA_SLIDERARMPOSITION,
                                    SMA_INCREMENTVALUE),
                                    MPFROMSHORT (fine));
                        sprintf (txt, "%lu", ch);
                        WinSetDlgItemText (hwnd, IDD_TUNE_CH, txt);
                        return 0;
                    case IDD_TUNE_VF :
                        if ((notify_code != CBN_LBSELECT) &&
                            (notify_code != CBN_EFCHANGE))
                            return 0;
                        if (VFInit)
                            return 0;
                        WinQueryDlgItemText (hwnd, IDD_TUNE_VF, 80L, txt2);
                        if (strcmp ("", txt2) == 0)
                            return 0;
                        valid = FALSE;
                        for (i = 0; i < NumVFs; i++)
                        {
                            if (strcmp (VFData[i].vf_string, txt2) == 0)
                            {
                                vf = i;
                                valid = TRUE;
                                break;
                            }
                        }
                        if (!valid)
                            return 0;

                                        // In order to change the input format
                                        // we must first set the variable
                                        // called INPUTFORMAT. Once this has
                                        // been set we must reset the digitizer
                                        // chip. The way I have reset the chip
                                        // is to close the device, then open
                                        // the device (thus resetting the
                                        // digitizer chip), then switch the
                                        // overlay monitor on, and then
                                        // call the VcaiRedraw function.
                        VcaiVarWrite ("INPUTFORMAT", VCA_VARIABLE_GENERIC, vf);
                        VcaiDeviceClose (DevHandle);
                        DevHandle = VcaiDeviceOpen (DevType, DevInstance);
                        if (DevHandle < 0)
                        {
                            sprintf (txt, "Cannot Open Device %u !",
                                     DevInstance);
                            msg_box (txt, "Error", MB_OK | MB_ERROR);
                        }
                        VcaiOverlay (TRUE);
                        VcaiRedraw ();
                        return 0;
                    case IDD_TUNE_FINE :
                        if ((notify_code == SLN_CHANGE) ||
                            (notify_code == SLN_SLIDERTRACK))
                        {
                            VcaiTunerGet (&region, &ch, &freq, &fine);
                            fine = (LONG)WinSendDlgItemMsg(
                                        hwnd, IDD_TUNE_FINE,
                                        SLM_QUERYSLIDERINFO,
                                        MPFROM2SHORT
                                        (SMA_SLIDERARMPOSITION,
                                         SMA_INCREMENTVALUE),
                                        NULL);
                            VcaiTunerSet (region, ch, freq, fine, 0, 0);
                        }
                        return 0;
                    case IDD_TUNE_FREQ :
                        switch (SHORT2FROMMP (mp1))
                        {
                            case EN_CHANGE :
                                VcaiTunerGet (&region, &ch, &freq, &fine);
                                WinQueryDlgItemText (hwnd,
                                                     IDD_TUNE_FREQ,
                                                     12L, txt);
                                freq = (ULONG)atol (txt);
                                VcaiTunerSet (region, ch, freq, fine, 0, 0);
                                return 0;
                            default:
                                break;
                        }
                        return 0;
                    case IDD_TUNE_CH :
                        switch (SHORT2FROMMP (mp1))
                        {
                            case EN_CHANGE :
                                VcaiTunerGet (&region, &ch, &freq, &fine);
                                WinQueryDlgItemText (hwnd,
                                                     IDD_TUNE_CH,
                                                     12L, txt);
                                ch = (ULONG)atol (txt);
                                freq = Region_frequencies[ch];
                                VcaiTunerSet (region, ch, freq, fine, 0, 0);
                                sprintf (txt, "%lu", freq);
                                WinSetDlgItemText (hwnd, IDD_TUNE_FREQ,
                                                   (PSZ)txt);
                                return 0;
                            default:
                                break;
                        }
                        return 0;
                    default :
                        break;
                }
                break;
            case MSG_CHANGE_TUNER :
                VcaiTunerGet (&region, &ch, &freq, &fine);
                vi = VcaiVideoInputQuery ();
                WinSetDlgItemText (hwnd, IDD_TUNE_SRC,
                                   SrcData[vi].src_string);
                WinSetDlgItemText (hwnd, IDD_TUNE_REGION, &RegionNames[region][0]);
                sprintf (txt, "%lu", freq);
                WinSetDlgItemText (hwnd, IDD_TUNE_FREQ, txt);
                WinSendMsg (WinWindowFromID (hwnd, IDD_TUNE_FINE),
                            SLM_SETSLIDERINFO,
                            MPFROM2SHORT (SMA_SLIDERARMPOSITION,
                            SMA_INCREMENTVALUE),
                            MPFROMSHORT (fine));
                sprintf (txt, "%lu", ch);
                WinSetDlgItemText (hwnd, IDD_TUNE_CH, txt);
                VcaiVarRead ("INPUTFORMAT", VCA_VARIABLE_GENERIC, &ul);
                i = (USHORT)ul;
                WinSetDlgItemText (hwnd, IDD_TUNE_VF, VFData[i].vf_string);
                VcaiTunerSet (region, ch, freq, fine, 0, 0);
                return 0;
            default :
                break;
        }
        return WinDefDlgProc (hwnd, msg, mp1, mp2);
}

static void position_tv (HWND hwnd, USHORT tv)
{
    HWND    hwnd_tv;
    RECTL   rcl_tv, rcl;
    POINTL  pts;
    LONG    bx, by, dy, x, y;

        hwnd_tv = WinWindowFromID (hwnd, tv);
        if (!WinQueryWindowRect (hwnd_tv, &rcl_tv))
            return;
        if (!WinMapWindowPoints (hwnd_tv, HWND_DESKTOP, (PPOINTL)
                                 &rcl_tv, 2))
            return;
        WinQueryWindowRect (HWND_DESKTOP, &rcl);
        pts.x = rcl_tv.xLeft;
        pts.y = rcl_tv.yBottom;
        if (!WinPtInRect (Hab, &rcl, &pts))
            return;
        pts.x = rcl_tv.xRight;
        pts.y = rcl_tv.yTop;
        if (!WinPtInRect (Hab, &rcl, &pts))
            return;
        bx = WinQuerySysValue (HWND_DESKTOP, SV_CXDLGFRAME);
        by = WinQuerySysValue (HWND_DESKTOP, SV_CYDLGFRAME);
        dy = WinQuerySysValue (HWND_DESKTOP, SV_CYSCREEN);
        VcaiVideoRectValidate (0, 0, 0, 0,
                               (USHORT)(rcl_tv.xLeft + bx),
                               (USHORT)(dy - rcl_tv.yTop - by),
                               (USHORT)(rcl_tv.xRight - rcl_tv.xLeft),
                               (USHORT)(rcl_tv.yTop - rcl_tv.yBottom));
}

static void enable_tuner_options (HWND hwnd)
{
        WinEnableWindow (WinWindowFromID (hwnd, IDD_TUNE_REGION), TRUE);
        WinEnableWindow (WinWindowFromID (hwnd, IDD_TUNE_FREQ), TRUE);
        WinEnableWindow (WinWindowFromID (hwnd, IDD_TUNE_CH), TRUE);
        WinEnableWindow (WinWindowFromID (hwnd, IDD_TUNE_FINE), TRUE);
}

static void disable_tuner_options (HWND hwnd)
{
        WinEnableWindow (WinWindowFromID (hwnd, IDD_TUNE_REGION), FALSE);
        WinEnableWindow (WinWindowFromID (hwnd, IDD_TUNE_FREQ), FALSE);
        WinEnableWindow (WinWindowFromID (hwnd, IDD_TUNE_CH), FALSE);
        WinEnableWindow (WinWindowFromID (hwnd, IDD_TUNE_FINE), FALSE);
}

static void init_src_listbox (HWND hwnd)
{
    USHORT  i, j;
    ULONG   vi;

        SrcInit = TRUE;
        for (i = 0; i < NumSrcs; i++)
        {
            WinSendDlgItemMsg (hwnd, IDD_TUNE_SRC, LM_INSERTITEM,
                               MPFROMSHORT (SrcData[i].src_no),
                               MPFROMP (SrcData[i].src_string));
        }
        j = VcaiVarRead ("VIDEOINPUT", VCA_VARIABLE_GENERIC, &vi);
        if (j == 0)
            i = VcaiVideoInputQuery ();
        else
            i = (USHORT)vi;
        WinSendDlgItemMsg (hwnd, IDD_TUNE_SRC, LM_SELECTITEM,
                           MPFROMSHORT (SrcData[i].src_no),
                           MPFROMSHORT (TRUE));
        SrcInit = FALSE;
}

static void init_region_listbox (HWND hwnd)
{
    APIRET  rc;
    PSZ     pmmbase, penv = "MMBASE";
    CHAR    filename[256];
    LONG    len;
    ULONG   num_files;
    HDIR    hdir;
    FILEFINDBUF3    ffb;
    USHORT  n, i;
    ULONG   region, freq, max_ch, ch;
    LONG    fine;

        RegionInit = TRUE;
        rc = DosScanEnv (penv, &pmmbase);
        if (rc != 0)
        {
            msg_box ("Unable to scan environment.",
                         "Error", MB_OK | MB_ERROR);
            return;
        }
        len = strlen (pmmbase);
        if (pmmbase[len-1] == ';')
            pmmbase[len-1] = '\0';
        strcpy (filename, pmmbase);
        strcat (filename, "\\REGION\\*.RGN");
        strcpy (RegionBase, pmmbase);
        strcat (RegionBase, "\\REGION\\");
        num_files = 1L;
        hdir = 0xffffffff;
        n = 0;
        rc = DosFindFirst (filename,
                           &hdir,
                           FILE_ARCHIVED | FILE_DIRECTORY | FILE_READONLY,
                           (PVOID) &ffb,
                           sizeof (FILEFINDBUF3),
                           &num_files,
                           1L);
        if (rc)
        {
            strcpy (txt2, "DosFindFirst Error");
            msg_box (txt2, "Error", MB_OK | MB_INFORMATION);
            return;
        }
        else
        {
            WinSendDlgItemMsg (hwnd, IDD_TUNE_REGION, LM_INSERTITEM, MPFROM2SHORT
                               (LIT_END, 0),
                               MPFROMP (ffb.achName));
            strcpy (&RegionNames[n][0], ffb.achName);
            n++;
        }
        while (!rc)
        {
            num_files = 1L;
            rc = DosFindNext (hdir, (PVOID)&ffb, sizeof (ffb), &num_files);
            if (!rc)
            {
                WinSendDlgItemMsg (hwnd, IDD_TUNE_REGION, LM_INSERTITEM,
                                   MPFROM2SHORT (LIT_END, 0),
                                   MPFROMP (ffb.achName));
                strcpy (&RegionNames[n][0], ffb.achName);
                n++;
            }
        }
        DosFindClose (hdir);
        NumRegions = n;

        VcaiTunerGet (&region, &ch, &freq, &fine);
        if (region >= n)
            region = 0;
        WinSendDlgItemMsg (hwnd, IDD_TUNE_REGION, LM_QUERYITEMTEXT,
                           MPFROM2SHORT (region, sizeof (RegionFile)),
                           MPFROMP (RegionFile));
        strcpy (txt2, RegionBase);
        strcat (txt2, RegionFile);
        WinSetDlgItemText (hwnd, IDD_TUNE_REGION, RegionFile);
        ch = 0;
        max_ch = get_region_data (txt2);
        for (i = 0; i < max_ch; i++)
        {
            if (freq == Region_frequencies[i])
                ch = i;
        }
        freq = Region_frequencies[ch];
        RegionInit = FALSE;
}

static void init_vf_listbox (HWND hwnd)
{
    USHORT  i, vf, j;
    ULONG   ul;

        VFInit = TRUE;
        for (i = 0; i < NumVFs; i++)
        {
            WinSendDlgItemMsg (hwnd, IDD_TUNE_VF, LM_INSERTITEM,
                               MPFROMSHORT (VFData[i].vf_no),
                               MPFROMP (VFData[i].vf_string));
        }
        j = VcaiVarRead ("INPUTFORMAT", VCA_VARIABLE_GENERIC, &ul);
        if (j == 0)
            vf = 0;
        else
            vf = (USHORT)ul;
        WinSendDlgItemMsg (hwnd, IDD_TUNE_VF, LM_SELECTITEM,
                           MPFROMSHORT (VFData[vf].vf_no),
                           MPFROMSHORT (TRUE));
        VFInit = FALSE;
}

static USHORT load_celeb_src_data (PSOURCE_DATA psrc)
{
    USHORT  i;

        i = 0;
        while (strcmp (celebnb_src[i].src_string, "") != 0)
        {
            psrc->src_no = celebnb_src[i].src_no;
            psrc->src_tuner_flag = celebnb_src[i].src_tuner_flag;
            strcpy (psrc->src_string, celebnb_src[i].src_string);
            i++;
            psrc++;
        }
        return i;
}

static USHORT load_celeb_vf_data (PVIDEO_FORMAT_DATA pvf)
{
    USHORT  i;

        i = 0;
        while (strcmp (celebnb_vf[i].vf_string, "") != 0)
        {
            pvf->vf_no = celebnb_vf[i].vf_no;
            strcpy (pvf->vf_string, celebnb_vf[i].vf_string);
            i++;
            pvf++;
        }
        return i;
}

static USHORT load_highq_src_data (PSOURCE_DATA psrc)
{
    USHORT  i;

        i = 0;
        while (strcmp (highqnb_src[i].src_string, "") != 0)
        {
            psrc->src_no = highqnb_src[i].src_no;
            psrc->src_tuner_flag = highqnb_src[i].src_tuner_flag;
            strcpy (psrc->src_string, highqnb_src[i].src_string);
            i++;
            psrc++;
        }
        return i;
}

static USHORT load_highq_vf_data (PVIDEO_FORMAT_DATA pvf)
{
    USHORT  i;

        i = 0;
        while (strcmp (highqnb_vf[i].vf_string, "") != 0)
        {
            pvf->vf_no = highqnb_vf[i].vf_no;
            strcpy (pvf->vf_string, highqnb_vf[i].vf_string);
            i++;
            pvf++;
        }
        return i;
}

static USHORT load_prism_src_data (PSOURCE_DATA psrc)
{
    USHORT  i;

        i = 0;
        while (strcmp (prismnb_src[i].src_string, "") != 0)
        {
            psrc->src_no = prismnb_src[i].src_no;
            psrc->src_tuner_flag = prismnb_src[i].src_tuner_flag;
            strcpy (psrc->src_string, prismnb_src[i].src_string);
            i++;
            psrc++;
        }
        return i;
}

static USHORT load_prism_vf_data (PVIDEO_FORMAT_DATA pvf)
{
    USHORT  i;

        i = 0;
        while (strcmp (prismnb_vf[i].vf_string, "") != 0)
        {
            pvf->vf_no = prismnb_vf[i].vf_no;
            strcpy (pvf->vf_string, prismnb_vf[i].vf_string);
            i++;
            pvf++;
        }
        return i;
}

static USHORT load_encore_src_data (PSOURCE_DATA psrc)
{
    USHORT  i;

        i = 0;
        while (strcmp (encornb_src[i].src_string, "") != 0)
        {
            psrc->src_no = encornb_src[i].src_no;
            psrc->src_tuner_flag = encornb_src[i].src_tuner_flag;
            strcpy (psrc->src_string, encornb_src[i].src_string);
            i++;
            psrc++;
        }
        return i;
}

static USHORT load_encore_vf_data (PVIDEO_FORMAT_DATA pvf)
{
    USHORT  i;

        i = 0;
        while (strcmp (encornb_vf[i].vf_string, "") != 0)
        {
            pvf->vf_no = encornb_vf[i].vf_no;
            strcpy (pvf->vf_string, encornb_vf[i].vf_string);
            i++;
            pvf++;
        }
        return i;
}

