
/*------------------------------------------------------------------*
 *                                                                  *
 *  Video Toolkit For OS/2 Version 1.0                              *
 *  Example PM Application No. 3.                                   *
 *  Written by Stephen Sloan.                                       *
 *  Date : 22/02/95.                                                *
 *  Copyright (c) Abbotsbury Software Ltd., United Kingdom. 1995.   *
 *                                                                  *
 *  Filename : region.c                                             *
 *                                                                  *
 *------------------------------------------------------------------*/

#define     INCL_PM
#define     INCL_DOS
#define     INCL_SW
#define     INCL_OS2MM
#ifndef DIM
#define DIM(a)  (sizeof(a)/sizeof(a[0]))
#endif

#include    <os2.h>
#include    <os2me.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    <vcadd.h>
#include    <vcai.h>


extern  void    msg_box (UCHAR *txt, UCHAR *title, ULONG options);

UINT    Region_lowchannel;
UINT    Region_highchannel;
ULONG   Region_frequencies[256];

static  UINT    region_obtain_frequencies (HFILE region_file);
static  LONG    get_next_numeric (HFILE region_file);

static  UCHAR   *Copyright =
  "Copyright (c) Abbotsbury Software Ltd., UK. 1994-1995. All Rights Reserved";

ULONG get_region_data (PSZ filename)
{
    ULONG   count;
    PSZ     pmmbase, penv = "MMBASE";
    CHAR    name[256];
    LONG    len;
    APIRET  rc;
    ULONG   action;
    CHAR    txt[256];
    HFILE   region_file;

        rc = DosOpen (filename,
                      &region_file,
                      &action,
                      0L,
                      FILE_NORMAL,
                      OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
                      OPEN_ACCESS_READONLY | OPEN_SHARE_DENYWRITE,
                      0L);
        if (rc)
        {
            sprintf (txt, "DosOpen Error %ld", rc);
            msg_box (txt, "Error", MB_OK | MB_ERROR);
            return 0;
        }

        Region_lowchannel = (UINT) get_next_numeric (region_file);
        Region_highchannel = (UINT) get_next_numeric (region_file);
        count = region_obtain_frequencies (region_file);

        DosClose (region_file);

        return count;
}

static LONG get_next_numeric (HFILE region_file)
{
    LONG value;
    CHAR textval[8];
    INT  pos, c;
    CHAR    ch[2];
    ULONG   bytes_read;
    APIRET  rc;

        ch[0] = '\0';
        DosRead (region_file, ch, 1L, &bytes_read);
        while ((ch[0] < '0') || (ch[0] > '9'))
        {
            DosRead (region_file, ch, 1L, &bytes_read);
            if (bytes_read == 0)
                break;
        }
        pos = 0;
        textval[pos++] = ch[0];
        while ((ch[0] >= '0') && (ch[0] <= '9') && (bytes_read != 0))
        {
            DosRead (region_file, ch, 1L, &bytes_read);
            if (bytes_read == 0)
                break;
            textval[pos++] = ch[0];
        }

        value = atol (textval);

        return value;
}

static UINT region_obtain_frequencies (HFILE region_file)
{
    UINT freq_count = 0x00;
    CHAR textval[8];
    INT  pos, c = 0x00;
    CHAR    ch[2];
    ULONG   bytes_read;

        do
        {
            do
            {
                DosRead (region_file, ch, 1L, &bytes_read);
            } while (((ch[0] < '0') || (ch[0] > '9')) && (bytes_read != 0) && (ch[0] != '-'));

            if (bytes_read == 0)
                continue;

            pos = 0;
            do
            {
                textval[pos++] = ch[0];
                DosRead (region_file, ch, 1L, &bytes_read);
            } while ((ch[0] >= '0') && (ch[0] <= '9') && (bytes_read != 0));
            textval[pos] = '\0';
            Region_frequencies[freq_count++] = atol (textval);
        } while (bytes_read != 0);

        return freq_count;
}
