<?php
//  getcwd liefert (unter www.zworks.de bei Host-Europe):
//	/is/htdocs/20372/www.zworks.de

// um aus diesem .orig ein .php4 zu machen: commandline> MakePHP.cmd

// --------------------------------------------------------------------------
// Process_One_Dir:
// ----------------
// Ausgehend vom bergebenen Pfad-Namen (immer kumulativ!) wird rekursiv
// der gesamte Baum unterhalb (und einschliessli.) dieses Pfad-Namens
// durchgesucht und alle Dateien aufgelistet
// --------------------------------------------------------------------------
function Process_One_Dir ( $CurrDir )
{
  Global $DirLevel, $Mode, $Func, $cmnd, $What, $Opt, $SkipDirs, $Dir, $ToTS,
         $Version, $AllFiles, $UsedSp,
         $EOL, $ID_Value,$ID_Commnt,$ID_Error;

  if(  substr($CurrDir,-1) != "/" )   $CurrDir.="/";

  $DirLevel++;

  echo $ID_Commnt."CurrDir=$CurrDir ".$EOL;

  $handle=opendir($CurrDir);

  if( $Mode != "appl" )
  { echo "Directory handle ... (Dir=$CurrDir): $handle $EOL";
    echo "Files im Verzeichnis (lt. 'getcwd()'=".getcwd()."): ".$EOL;		}

  while ($file = readdir($handle))
  {
    if( ($file != ".") && ($file != "..") )
    {
      $Objct = $CurrDir.$file;

      if( is_dir($Objct) )
      {
        if( $Mode != "appl" ) echo "'$Objct'<=====<-<< Verzeichnis auf Level $DirLevel $EOL";

	// Diesen Directory-Entry liefern, falls gewnscht:
        if( !$SkipDirs )
        {
          Insert_Stem( $CurrDir, $file, "d" );
        }
        Process_One_Dir ( $Objct );
      }
      else
      {
	if( is_file($Objct) )
	{
	  // ========== Dies ist ein File: ==========================
          if( $Mode != "appl" ) echo "$Objct  - is a file ".$EOL;

          $UsedSp+=(filesize($Objct) / 1024);	// total used space in kb

          $Version = Check_VersionDir( $CurrDir );
          if( $Version == "" )
          {
            $reason = "";
            if( substr( $CurrDir, strlen($CurrDir)-2, 1 ) == ' ' )
            {
              $reason = "Trailing spaces in version-dir. ";
            }
            if( $file == "index.html" )
               $reason .= " (index.html) ";
            echo $ID_Value.$ID_Error."<nobr>'$Objct' - has an ** invalid version-dir ** ($reason) !".$EOL;
          }

          else
          {  // ++ <--------------------------- do-level!! (nur gltige Versions-Directories verarbeiten!)
          if( $Func == "CleanUp" )
          { // ------------------------------------------------ "CleanUp": ---------------------------
            Insert_Stem( $CurrDir, $file, "f" );
          } // ------------------------------------------------ "CleanUp" Ende -----------------------

          else

          { // ------------------------------------------------ "Dir" | "SearchFile": ----------------
	    if($What != "")	// SearchFile: suche nach What
	    {
	      // bei SearchFile: nur bernehmen wenn es dies file ist:
	      $FN = basename( $Objct );	// ziehe FileName aus Pfad

              // ist Wildcard gefragt? 
              if( substr($What,-1) == "*" )
              {
                $leng = strlen($What)-1;
                if( strtoupper( substr($FN,0,$leng) ) == strtoupper( substr($What,0,$leng) ) )
                  Insert_Stem( $CurrDir, $file, "f" );
              }
              else
              {
	        if( strtoupper($FN) == strtoupper($What) )
                  Insert_Stem( $CurrDir, $file, "f" );
              }
	    }
  	    else
                Insert_Stem( $CurrDir, $file, "f" );
          } // ------------------------------------------------ "Dir" | "SearchFile" Ende -------------

          } // ++ <------------------------ do-level-Ende (nur gltige Versions-Directories verarbeiten!)

	}
	else
	{
          if( is_link($Objct) ) { if( $Mode != "appl" )   echo "$Objct  - is a LINK ".$EOL; }
          else	  		{ if( $Mode != "appl" )   echo "$Objct  - is Something ELSE! ".$EOL; }
	}
      }
    }
  }
  closedir($handle); 
  $DirLevel--;
}


//  Find Empty Dirs   + Delete Them !!
// ==========================================================================
// Delete_EmptyDir:
// --------------------------------------------------------------------------
// entlehnt aus Process_One_Dir
// ----------------------------
// Ausgehend vom bergebenen Pfad-Namen (immer kumulativ!) wird rekursiv
// der gesamte Baum unterhalb (und einschliessli.) dieses Pfad-Namens
// durchgesucht und alle Dateien aufgelistet
// --------------------------------------------------------------------------
function Delete_EmptyDir ( $CurrDir )
{
  Global $Func, $Opt, $DirLevel, $Mode, $PreView, $Dir,
         $Version, $AllFiles, $UsedSp, $ftp_strm, $HTTPDir,
         $EOL, $ID_Value,$ID_Commnt,$ID_Error;

  if(  substr($CurrDir,-1) != "/" )   $CurrDir.="/";

  $DirLevel++;

  echo $ID_Commnt."CurrDir=$CurrDir ".$EOL;

  $FilesInDir = 0;  // lokale Variable

  $handle=opendir($CurrDir);

  if( $Mode != "appl" )
  { echo "Directory handle ... (Dir=$CurrDir): $handle $EOL";
    echo "Files im Verzeichnis (lt. 'getcwd()'=".getcwd()."): ".$EOL;		}

  while ($file = readdir($handle))
  {
    if( ($file != ".") && ($file != "..") )
    {
      $Objct = $CurrDir.$file;

      if( is_dir($Objct) )
      {
        if( $Mode != "appl" ) echo "'$Objct'<=====<-<< Verzeichnis auf Level $DirLevel $EOL";

        // plunge recursive into next dir-level:
        Delete_EmptyDir ( $Objct );
      }
      else
      {
        if( is_file($Objct) )
        {
	  // ========== Dies ist ein File: ==========================
          if( $Mode != "appl" ) echo "$Objct  - is a file ".$EOL;

          $UsedSp+=(filesize($Objct) / 1024);	// total used space in kb
          $FilesInDir++;
	}
	else
	{
          if( is_link($Objct) ) { if( $Mode != "appl" )   echo "$Objct  - is a LINK ".$EOL; }
          else	  		{ if( $Mode != "appl" )   echo "$Objct  - is Something ELSE! ".$EOL; }
	}
      }
    }
  }
  closedir($handle); 

  // nun das (leere!) Directory lschen:
  if( $FilesInDir == 0 )
  {
    if( $PreView == "0" )
    { if( ftp_rmdir($ftp_strm, $HTTPDir.$CurrDir) )
         $ClnStat = "3";  // dir removed!
      else
      {  echo $ID_Commnt."FTP-Error - $CurrDir not deleted!".$EOL;
         $ClnStat = "6";  // FTP-Error!
      }
    }
    else
       $ClnStat = "4";    // not removed (Preview-Mode)
  }
  else
  {
     echo $ID_Commnt."$CurrDir not empty! ($FilesInDir files in it)".$EOL;
     $ClnStat = "5";
  }
  $Version = Check_VersionDir( $CurrDir );
  Insert_Stem( $CurrDir, "", "d", $ClnStat );

  // prepare for next higher directory:
  $DirLevel--;
}

// --------------------------------------------------------------------------
// Einen Entry in den Antwort-Stem einfgen
// --------------------------------------------------------------------------
function Insert_Stem ( $CurrDir, $file, $ObjType, $ClnStat )  // $ClnStat optional
{
  Global $Func, $Opt, $Version, $AllFiles;	// Antwort-Stem

  $Objct = $CurrDir.$file;		// FileSpec

  // Aufbereiten Modi-Datum:
  $i = ++$AllFiles[0]; 

  // Erstelle Wortliste (fr Rexx-Weiterverarbeitung):

  if( $Func == "CleanUp" )
  {
    if( $ClnStat == "" )
      $ClnStat = "1";	// bedeutet: erstmal ausgewhlt zum Lschen (Phase-1)
    //
    // sonst: $ClnStat=3/4/5/6 (Zustnde aus DelEmpty, s.dort)
    //
    if( $Opt == "DelEmpty" )
    {
      $OrigPath = $CurrDir;
      $file     = "";
      $HereVers = "";
      $FileSz   = "0";
    }
    else
    {
      $OrigPath = dirname( substr($CurrDir, 0, strlen($CurrDir)-1) ); // strip off Version-subir
      $HereVers = Invert_Version( $Version );  // hin ....
      $FileSz   = filesize($Objct);
    }
    $AllFiles[$i] = $ClnStat
       ."?".$OrigPath
       ."?".$file
       ."?".$HereVers
       ."?".$FileSz;
  }
  else		// Func = [ Dir | SearchFile ]:
  {
    $Arr = getdate( filemtime($Objct) );
    $AllFiles[$i] = strlen($file)			// Erstes Wort ist Byte-Lnge des Filenamens
       ." ".$file
       ." ".$ObjType					// 'd' | 'f'
       ." ".filegroup($Objct)
       ." ".fileowner($Objct)." ".filesize($Objct)
       ." ".$Arr["month"]." ".$Arr["mday"]." ".$Arr["year"]
       ." ".$CurrDir;				
  }

  $AllFiles[0]  = $i;
}

// --------------------------------------------
// Check if CurrDir is a valid Version-Dir:
// --------------------------------------------
function Check_VersionDir( $CurrDir )	// $CurrDir endet auf '/'!
{
  $Version = basename( substr($CurrDir, 0, strlen($CurrDir)-1) );  // etwas missbruchliche Benutzung der basename-Function
  // '20030116-201454'

  // Prfen, ob wirklich ein Versions-Dir:
  $Arry  = split("-", $Version);
  $Date  = $Arry[0];
  $Time  = $Arry[1];

  if( (strlen( $Date) == 8     ) & (strlen($Time) == 6      )
     &(settype($Date,"integer")) & (settype($Time,"integer"))
    )
     nop;
  else
     $Version = "";

  return $Version;	// oder ""
}

// ------------------------------------------------------------------------------
// Invertieren Timestamp a la Version (hin/her ist egal, Vorgang ist reversibel):
// ------------------------------------------------------------------------------
function Invert_Version ( $Version )
{
  $Arry  = split("-", $Version);
  $Date  = $Arry[0];
  $Time  = $Arry[1];

  return 99999999 - $Date."-".PadZero(999999 - $Time,6);
}

// --------------------------------------------------------------------------
function PadZero($What,$Many)
{
  return substr("000000000000",0, $Many-strlen($What)).$What;
}

// --------------------------------------------------------------------------
// Delete_One_Dir:	++ mittels FTP !! ++
// ----------------
// Steuerung analog zu Process_One_Dir
// Es wird jeweils bis zum untersten Dir navigiert, dort werden
// alle Files gelscht, dann zurck zum nchst hheren Dir etc.
// --------------------------------------------------------------------------
function Delete_One_Dir ( $CurrDir )
{
  Global $DirLevel, $Mode, $Func, $cmnd, $What, $SkipDirs, $Dir, $url, $HTTPDir, $login, $AllFiles, $EOL, $ID_Value,$ID_Commnt;

  if( substr($CurrDir,-1) != "/" )   $CurrDir.="/";

  $DirLevel++;

  echo $ID_Commnt."Curr-DelDir=$CurrDir ".$EOL;

  $handle=opendir($CurrDir);

  if( $Mode != "appl" )
  { echo "Directory handle ... (Dir=$CurrDir): $handle $EOL";
    echo "Files im Verzeichnis ".getcwd().": ".$EOL;		}

  while ($file = readdir($handle))
  {
    if( ($file != ".") && ($file != "..") )
    {
      $Objct = $CurrDir.$file;

      if( is_dir($Objct) )
      {
        if( $Mode != "appl" ) echo "$Objct <=====<-<< Verzeichnis auf Level $DirLevel $EOL";

        Delete_One_Dir ( $Objct );
      }
      else
      {
	if( is_file($Objct) )
	{
          if( $Mode != "appl" ) echo "$Objct  - is a file ".$EOL;

	  // nun file deleten:
// ++	  echo "unlinking file=$Objct"."<==".$EOL;	// nok wg. access prohibited
	  echo "ftp-deleting Objct=$Objct"."<==".$EOL;

    	  $i = ++$AllFiles[0]; 
// ++	  if( unlink( $Objct ) )			// nok wg. access prohibited
	  $DelSpec = $Remote_SubDir.$Objct;	// ???
	  if( ftp_delete( $strm, $DelSpec ) )
	  {
	    $AllFiles[$i] = "$file in $CurrDir wurde gelscht";	// Wortliste (fr Rexx-Weiterverarbeitung)
	  }
	  else
	  {
	    $AllFiles[$i] = "$file in $CurrDir nicht gelscht wg. Fehler";	// Wortliste (fr Rexx-Weiterverarbeitung)
	  }
	  $AllFiles[0]  = $i;
	}
	else
	{
          if( is_link($Objct) ) { if( $Mode != "appl" )   echo "$Objct  - is a LINK ".$EOL; }
          else	  		{ if( $Mode != "appl" )   echo "$Objct  - is Something ELSE! ".$EOL; }
	}
      }
    }
  }
  closedir($handle); 

  // nun das (leere!) Directory lschen:
  $i = ++$AllFiles[0]; 
  if( ftp_rmdir($strm, $HTTPDir."/".dirname($CurrDir."x")) ) // <--== +++ FEHLERHAFTER CODE ("x") !!
     $AllFiles[$i] = "Directory $CurrDir wurde gelscht";
  else
     $AllFiles[$i] = "Directory $CurrDir nicht gelscht wg. Fehler!";

  // prepare for next higher directory:
  $DirLevel--;
}

// ------FreeSpace: ----------------------
function FreeSpace()
{
  $df = diskfreespace("/"); // $df contains the number of bytes 
 
  $FreeMB = ( $df / 1024 )/1024;
  $FreeMB = number_format($FreeMB, 2, ",", "."); 	// formatieren

  return $FreeMB;
}

// ----- LogOn: ----------------------
function LogOn()
{
  Global $ftp_strm, $url, $login, $EOL, $ID_Value,$ID_Commnt;

  $ftp_strm = ftp_connect($url);

  // $login="08ftp20372luwa1862";

  $ok   = ftp_login($ftp_strm, substr($login,2, (substr( $login,0,2) )), substr($login,2 + (substr($login,0,2))) );
  echo $ID_Commnt."Stream=$ftp_strm, ok=$ok ".$EOL;

  return $ok;
}

// =================
// Hier gehts los:
// -----------------
//

// Params:
//	Mode= [ console | appl ]
//	Func= [ Dir | DelDir | SearchFile | CleanUp | ...   ]
//	What= [ e:\DATA\...\<filename> | <filename> ]		<-- in lokaler Notation!	
// abhngige weitere Params:
//	Opt=  [ DelEmpty | ..........	]
//	Root= [ "." | "DasiDir/"	]
//	SkipDirs= [ "no" | "all" | "empty" ]

// -------> Z.Zt. realisierte Aufrufe:
//	    ------------------------------
//		  Func=Dir,Dir=MyDasi/.../
//		  Func=DelEmpty,Dir=MyDasi/.../

// Lies Konfigurationsdatei:
// soon to come... REQUIRE "config.db";

$ID_Value  = '.';
$ID_Commnt = '..';
			// Keywords hinter $ID_Value:
$ID_Error   = "Error=";
$ID_FreeSp  = "FreeSp=";	
$ID_MxFSize = "MxFSize=";
$ID_UsedSp =  "UsedSp=";

$ftp_strm = "";		// wird bei logon() gefllt

parse_str($argv);

if($HTTP_USER_AGENT != "") $Mode = "browser";	// avoid invocation from browser and coming to download the result-data	

if($Mode=="console") 	{ $TextType = "html";	} else
if($Mode=="browser")	{ $TextType = "html";	} else
if($Mode=="appl")	{ $TextType = "bkpdem";	} else
			{ $TextType = "invalid";} 

Header("Content-type: text/$TextType");

//-------------------------
// echo "HTTP_USER_AGENT=$HTTP_USER_AGENT<hr>\n";
//-------------------------

if( $Mode != "browser" )
   $EOL = "\n";		// for use in commandline (Call_PHP.cmd) or application (VXRexx)
else
   $EOL = "<br>\n";	// for use in browser

if( $Mode != "appl" )
//  echo "Start BkpDemon with params:<br>	
// 	Mode=$Mode, Func=$Func, Cmnd=$cmnd, What=$What ".$EOL;
   {
     // die("<html><body><h1>go to hell!</h1><body></body>\n");      ++ ZURCK nach ENDE TEST ++ 
   }
$AllFiles[0] = 0;		// Rexx-like array-Verwaltung
$UsedSp      = 0;		// Used Space in KiloBytes

// Schau, welcher Aufgabenbereich gefragt ist:

// ---------- Dir: ------------- SearchFile: --------
if(($Func == "Dir") | ($Func == "SearchFile"))
{
  $DirLevel = 0;
  $CurrDir = "Spain/Sect03/Map012";
  $CurrDir = ".";			// start with root
  $CurrDir = $Dir;			// start with whatever is requested!

  if($Func == "SearchFile")
     Process_One_Dir ( $CurrDir );	// What = <filename> --> Global !!
  else
     Process_One_Dir ( $CurrDir );
}

// -----------DelDir: ------------------
if ($Func == "DelDir")
{
  if(!(LogOn()))		// Zuerst via ftp einloggen:
    echo $ID_Value.$ID_Error."Invalid login! ".$EOL;
  else
  {
    $DirLevel = 0;
    if(1)
       Delete_One_Dir ( $Dir );
    else
       echo "Dir=$Dir&lt;--".$EOL;
  }
}


// -----------         ------------------
// -----------CleanUp: ------------------
// -----------         ------------------
if( ($Func == "CleanUp") & ($Opt == "DelEmpty") )            // <---==========- Option: DelEmpty =============
{
echo "Opt=$Opt".$EOL;

  // -----------Option: DelEmpty: ------------------
  if(!(LogOn()))		// Zuerst via ftp einloggen:
    echo $ID_Value.$ID_Error."Invalid login! ".$EOL;
  else
  {
    $DirLevel = 0;
    Delete_EmptyDir ( $Dir );
  }
}
if( ($Func == "CleanUp") & ($Opt != "DelEmpty") )           // <---==========- no Option: =============
{
  echo $ID_Commnt."url=$url,Opt=$Opt,Dir=$Dir,HTTPDir=$HTTPDir,login=$login,ToTS=$ToTS,MinVers=$MinVers,PreView=$PreView,DelOnly=$DelOnly! ".$EOL;

  // so sieht's aus: "url=www.zworks.de,Dir=BkpDemon,HTTPDir=www.zworks.de/,login=08ftp20372luwa1862,...."

  if( LogOn( $url ) )		// Zuerst via ftp einloggen:
  {
     // HTTPDir: nur fr die FTP-Funtionen, Dir (=Remote_SubDir): fr die cgi(=HTTP)-Funtionen


     // ---------------------------------------------------------------------
     // Step-1: ermitteln alle files in Version-Dirs
     // ---------------------------------------------------------------------
     $SkipDirs = 1;
     Process_One_Dir ( $Dir );

     $MxFSize = 0;	// Max. FileSize (fr Anpassung der Spaltenbreite in CN_Clnup_Report)

     // ---------------------------------------------------------------------
     // Step-2: feststellen je File, ob mindestens MinVers noch drin sind
     // ---------------------------------------------------------------------
     $NumLines = $AllFiles[0];		// vorher den NumLines-Entry retten, weil der wrde nach unten sortiert:
     $AllFiles[0] = 0x00.$NumLines;
     sort($AllFiles);	
     $AllFiles[0] = $NumLines;		// restore orig. NumLines als ersten Entry

     $i=1;
     $OldGru="";
     $NewFiles[0] = 0;			// Rexx-like array-Verwaltung
     while ($AllFiles[$i])
     {
       $Rec = $AllFiles[$i];
       $Arry = explode("?", $Rec);	// nok mit split()!
       $ClnStat  = $Arry[0];
       $OrigPath = $Arry[1];
       $File     = $Arry[2];
       $Version  = $Arry[3];	// 9er-complement (invertiert)
       $FSize    = $Arry[4];

       $Version = Invert_Version( $Version );	// ...her (9er-complement wieder zurck)

       $MxFSize = max($MxFSize, $FSize);

       $NewGru = $OrigPath."?".$File;	// Fragezeichen wichtig ('/' wrde die Sortfolge ndern!)
       if( $NewGru > $OldGru )
       {
	 if(0) echo"=======>Gruppenwechsel: NewGru=$NewGru, OldGru=$OldGru".$EOL;

         // Gruppenwechsel: Abschliessen alte Gruppe:
         if($OldGru != "" )
         { nop; }

         // Vorbereiten neue Gruppe:
         $GruCount = 0;		// zhlt die Member einer Gruppe (=gleiche OrigPath+Filename)

         $OldGru = $NewGru;
       }

       // Einzelverarbeitung:
       // -------------------
       $GruCount++;
       if( $GruCount <= $MinVers )
       {
          // Diese Versionen mssen noch mindestens aufbewahrt bleiben

          $ClnStat  = "0";	// bedeutet: 'nicht zu reinigen'! (nur die, die mit '1' nachbleiben, werden spter gelscht)
       }
       if( $Version > $ToTS )
          $ClnStat  = "0";	// bedeutet: 'nicht zu reinigen'! (nur die, die mit '1' nachbleiben, werden spter gelscht)

       // ausgeben auf New Array:
       $Rec =  $ClnStat
          ."?".$OrigPath
          ."?".$File
          ."?".$Version	// kein 9er-complement mehr
          ."?".$FSize;

       $NewFiles[$i] = $Rec;	// do the 'Update' 

       $i++;
     }
     $NewFiles[0]  = $AllFiles[0];	// die Anzahl ist dieselbe

     // ---------------------------------------------------------------------
     // Step-3: Jetzt die ausgeben, die nicht mit "0" gekennzeichnet wurden
     //         bzw. je nach Request (DelOnly):
     // ---------------------------------------------------------------------
     
     // Zuerst Ausgabe-Menge ermitteln:
     $i=1;$j=0;
     while ($NewFiles[$i])
     {
       $ClnStat = substr($NewFiles[$i],0,1);
       if(( $ClnStat == "1" ) | ( $DelOnly != "1" ))	$j++;	// ClntStat = 1 (delete) werden immer gezhlt

       $i++;
     }

     echo $ID_Value.$ID_FreeSp.FreeSpace().$EOL;// ganz vorne weg: verschiedene Informationen
     echo $ID_Value.$ID_MxFSize.$MxFSize.$EOL;	// ganz vorne weg: verschiedene Informationen: Maximale FileSize
     echo $ID_Value.$ID_UsedSp.($UsedSp/1024).$EOL;// ganz vorne weg: verschiedene Informationen: Total used Space in MB
     echo $ID_Value.$j.$EOL;		// als erstes gib (gleiche) Anzahl lines aus
     $i=1;
     while ($NewFiles[$i])
     {
       $Rec = $NewFiles[$i];
       $Arry = explode("?", $Rec);	// nok mit split()!
       $ClnStat  = $Arry[0];
       $OrigPath = $Arry[1];
       $File     = $Arry[2];
       $Version  = $Arry[3];
       $FSize    = $Arry[4];

       if(( $PreView == "0" ) & ( $ClnStat == 1 ))
       {
         // ---------------------------------------------------------------------
         // Step-3.2: Jetzt tatschlich lschen:
         // ---------------------------------------------------------------------
         $DelFileSpec = $OrigPath."/".$Version."/".$File;
         if( is_file($DelFileSpec) )
         {
           echo $ID_Commnt."'$DelFileSpec' about to be deleted".$EOL;

           $DelFileSpec = $HTTPDir.$DelFileSpec;	// jetzt wird's ernst: prepend HTTP_Dir
           if( ftp_delete( $ftp_strm, $DelFileSpec ) )
	     $ClnStat = "2";	// Datei wurde gelscht
	   else
	     $ID_Value.$ID_Error."$DelFileSpec not deleted b/o error".$EOL;
         }
         else
           echo $ID_Value.$ID_Error."No file ==> '".$DelFileSpec."'!".$EOL;
       }

       // ---------------------------------------------------------------------
       // Zum Schluss noch ausgeben:
       // ---------------------------------------------------------------------
       if(( $ClnStat >= "1" ) | ( $DelOnly != "1" ))
       {
         $LocalPath = substr( $OrigPath, strlen($Dir) );	// ergibt '_E_/DATA/VXREXX/...'
         $NewRec = $ClnStat
              ."?".$OrigPath		// vormals $LocalPath
              ."?".$File
              ."?".$Version
              ."?".$FSize;

         echo $NewRec.$EOL;		// ausgeben fr Verwendung in vxrexx
       }
       $i++;
     }


  }
  else
  {
    echo $ID_Value.$ID_Error."Invalid login! ".$EOL;
    die("");
  }
}

// Nun die Dateien (samt Pfad) ausgeben:
// --------------------------------------

if( ($Func != "CleanUp") | ($Opt == "DelEmpty") )  // Cleanup (der normale) hat schon ausgegeben
{
  echo $ID_Value.$ID_FreeSp.FreeSpace().$EOL;	// ganz vorne weg: verschiedene Informationen
  echo $ID_Value.$ID_UsedSp.($UsedSp/1024).$EOL;// ganz vorne weg: verschiedene Informationen: Total used Space in MB
  echo $ID_Value.$AllFiles[0].$EOL;		// als erstes gib (gleiche) Anzahl lines aus
  $i=1;
  while ($AllFiles[$i])
  {
    echo $AllFiles[$i].$EOL;
    $i++;
  }
}


if (0) echo"##EOP##";	// nicht mehr erforderlich

?>
