:userdoc.
:title.File Freedom Help
:h1 res=1000.Overview
To see a list of :hp2.Contents:ehp2., press Control+C
:p.
:hp2.General Features:ehp2.
:p.
File Freedom is a program designed to help in the organization and
movement of files.  It has features to allow for the examination,
compression and manipulation of files which are intended to simplify
and speed this process.  With it's integrated Info-Zip support, it also
assists with back-ups of critical files as well as evaluations of new
software.  Create Desktop objects with the click of a button.
:p.
File Freedom provides two different methods for file handling - Drag And Drop file management
with which most users will be familiar, and an alternative file management method which
is described first.
:p.
File Freedom's alternative file management method is based on the concept of &csq.Source&csq.
and &csq.Destination&csq. file movement.  Using Copying a file(s) as an example:
.br
A destination is chosen for the file movement by moving to the drive
and/or directory desired.  Click on the destination button (or press F7) and the
destination is set.  Then, move to the drive/directory where the file(s)
are stored that must be copied.  Highlight the files and press the copy
pushbutton (or press Control+C).  Simple as that!
:p.
It must be remembered that all file movements, whether it is copying
or moving or unzipping, will go the Destination directory.  To copy
files to the same directory, but with a different name, simply make
the destination the same as the source (press F7) and change the file
name in the copy dialogue.
:p.
Drag and Drop file management is fast and easy.  Selected files can be dragged to a Drive Letter
Icon by holding down the right mouse key, and dropped on the desired destination drive.  A menu
will allow the user to guide the file to the correct directory.
Files may also be dropped on directories in the Directory Tree window or on directories
in the Files Window itself.  If files are dropped on other file names, they will be treated as though
they are being dropped on the current directory itself.  The
default operation is to Move files, but this can be changed to Copy by holding down the Control key
before releasing the right mouse button.  If the desired operation is to Zip a group of files, or
Unzip a file to a destination, these options are available when the Drag and Drop dialogue appears
after the files are dropped on the Drive Icon.  The Drag and Drop Dialogue also allows the user to
select the directory on the drive chosen, or to enter a path for a directory not yet created.
One important point to remember is that the mouse pointer must be over one of the selected files
when the drag operation is started.  If it is not, the file underneath the mouse pointer will be
acted on instead.  This allows the user to operate on single files without selecting them.
:p.
File Freedom also uses a split screen which divides the current source
into two views: Directory Tree and Files.  This allows somewhat easier movement
between sub-directories.  Folders in the tree view can be double-clicked
on to open that folder in the files view.  In the files view, double-clicking
on a sub-directory will open that sub-directory in the files view but
limits movement up or down to one level at a time.
.br
Although most operations are initiated from the Files Window, some may also be started from
the Tree Window such as Directory Tree Size, Rename Directory, Directory Tree Copy and
Directory Tree Delete.
:p.
The divider that separates the two windows can be adjusted either left or right.
:p.
Fonts and Colors can be dropped on the various parts of the File Freedom window.
These will be saved along with the size and position of the window for
the next time the program starts.
:p.
:p.:link reftype=hd res=1100.Menu Help:elink.
:p.:link reftype=hd res=1110.Pop-Up Menu Help:elink.
:p.:link reftype=hd res=2600.Settings Notebook:elink.
:p.:link reftype=hd res=1200.Keys:elink.
:p.:link reftype=hd res=1800.Mouse Usage:elink.
:p.:link reftype=hd res=1300.Tool Bar:elink.
:p.:link reftype=hd res=1400.Drive Table:elink.
:p.:link reftype=hd res=1500.Status Bars:elink.
:p.:link reftype=hd res=1600.Directory Tree Window:elink.
:p.:link reftype=hd res=1700.Files Window:elink.
:p.:link reftype=hd res=3200.Zip Viewer:elink.
:p.:link reftype=hd res=3300.Installing Other Viewers/Players:elink.
:p.:link reftype=hd res=3400.Installing User Programs:elink.
:p.:link reftype=hd res=3500.PMSeek or User Defined Search Tool:elink.
:p.:link reftype=hd res=1900.Colors and Fonts:elink.
:p.:link reftype=hd res=2000.Default Settings:elink.
:p.:link reftype=hd res=3600.Directory Bookmarks:elink.
:p.:link reftype=hd res=3700.Volume Labels:elink.
:p.:link reftype=hd res=3800.Refresh Timers:elink.
:p.:link reftype=hd res=3000.Program and Contact Information:elink.
.*....................................................
:h1 res=1200.Keys
:hp2.Key Use and Special Keys:ehp2.
:p.
Hot Keys are provided for file manipulation features such as :hp2.Copy, Move:ehp2. etc.
:p.
Pressing any alpha-numeric key, without using the Shift, Ctrl
or Alt keys, will move the cursor (selection box) to the first
file or folder that starts with that letter.  If the key is held
down, all files starting with that character will begin to be
selected.
:p.
Pressing the Enter key is the same as double-clicking on
an item with the mouse.  If the item is a sub-directory,
it will cause the directory to open.  If it is a file, it will
call up the viewer that has been selected for that file extension.
If the file extension does not have a viewer listed for it, the
defaut viewer (which is normally an ascii viewer) will be called,
unless the file is an executable file with an :hp2.exe:ehp2.,
 :hp2.cmd:ehp2. or :hp2.bat:ehp2. extension,
in which case the program will be started.
:p.
:p.Grey +   -   Causes the file within the selection box
.br
                 to be marked/unmarked (toggled) and
.br
                 moves the selection box to the next
.br
                 file.
:p.SpaceBar -    Marks/Unmarks the file within the
.br
                   selection box.
:p.Tab      -     Moves the focus between the Tree
.br
                  window and the Files window.
:p.PageUp   -    Moves the selection box a page up in
.br
                   the list.
:p.PageDown -   Moves the selection box a page down in
.br
                   the list.
:p.Home     -    Moves the selection box to the
.br
                   beginning of the list.
:p.End      -    Moves the selection box to the end of
.br
                  the list.
:p.Up Arrow -   Moves the selection box up one item in
.br
                  the list.
:p.Down Arrow - Moves the selection box down one item
.br
                   in the list.
:p.Ctrl a   -  Change File Attributes
:p.Ctrl b   -  Open Bookmark window
:p.Ctrl c   -  Copy File(s), and Directory Trees
:p.Ctrl d   -  Delete File(s), and Directory Trees
:p.Ctrl e   -  Move the Divider Right
:p.Ctrl f   -  Move the Divider Left
:p.Ctrl m  -  Move File(s)
:p.Ctrl p   -  Append File(s)
:p.Ctrl r   -  Rename File or Directory
:p.Ctrl s   -  Show Size of Directory Tree
:p.Ctrl t   -  Create Directory
:p.Ctrl v   -  Name View (File Names Only)
:p.Ctrl w   - File Flowed View (File Names in Multiple
.br
              Columns)
:p.Ctrl x   -  File Icon View
:p.Ctrl y   -  File Detail View (Show File Attributes and
.br
               Size)
:p.Ctrl z   -  File Headings (Display Headings over
.br
             Attributes in Details View Only)
:p.Ctrl Left Arrow  -   Switch to Preceding Drive
:p.Ctrl Right Arrow -   Switch to Next Drive
:p.Ctrl Up Arrow    -   Refresh Volume Labels
:p.Ctrl Down Arrow -   Write Volume Labels
:p.
:p.F1  -     Help
:p.F2  -     Zip Files, Directory Trees, Drives
.br
             using Info-Zip
:p.F3  -     UnZip Files using Info-Zip
:p.F4  -     Test Zip File Integrity
:p.F5  -     UnMark All Marked Files
:p.F6  -     Mark All Files
:p.F7  -     Set Current Directory as Destination
.br
             Directory
:p.F8  -     Swap Source and Destination Directories
:p.F9  -     Print File
:p.F10 -     Menu
:p.F11 -     Edit File
:p.F12 -     Settings Notebook
:p.
:p.Alt     - Menu
:p.Alt 1 - User's Program 1
:p.Alt 2 - User's Program 2
:p.Alt 3 - User's Program 3
:p.Alt 4 - User's Program 4
:p.Alt 5 - User's Program 5
:p.Alt 6 - User's Program 6
:p.Alt 7 - User's Program 7
:p.Alt 8 - User's Program 8
:p.
:p.Alt F4  - Quit
:p.Alt F5  - Restore from maximize
:p.Alt F7  - Move window
:p.Alt F8  - Size window
:p.Alt F9  - Minimize window
:p.Alt F10 - Maximize window
:p.Alt Space - System Menu
:p.
:p.Shift F2  -    Force Zip Viewer
:p.Shift F3  -    Unzip to New Dir
:p.Shift F5  -    Sort Files by Name Ascending
:p.Control + Shift F5  -    Sort Files by Name Decending
:p.Shift F6  -    Sort Files by Date Ascending
:p.Control + Shift F6  -    Sort Files by Date Decending
:p.Shift F7  -    Sort Files by Size Ascending
:p.Control + Shift F7  -    Sort Files by Size Decending
:p.Shift F8  -    Sort Files by Extension Ascending
:p.Control + Shift F8  -    Sort Files by Extension Decending
:p.Shift F11 -    Search Tool
:p.Shift F12 -    Refresh Display
:p.
:p.Control F11 - Create Desktop Object

.*...........................................................
:h1 res=1300.Tool Bar
:hp2.Using the Tool Bar:ehp2.
:p.
The Tool Bar contains single-click pushbuttons for many of the most often used features.
Hot keys are also available for all features except for the Push Button which can change the
tool bar position (see below).
:p.
:hp2.Tool Bar Push Button Descriptions:ehp2.
:p.
To identify the function of a tool bar button, simply move the mouse pointer to the push button
and a short description of the button's function will appear on the upper Status Bar at the
bottom of the window.
:p.
:hp2.Tool Bar Shape and Position:ehp2.
:p.
The Tool Bar can be oriented in either a vertical position
along the right side of the main window, or it can appear
horizontally along the top of the window, under the menu.
This is done by pressing the first pushbutton on the Tool Bar.
It will also fold itself into two columns if the space for it is
constrained by the size of the window.
:p.
:hp2.Hiding the Tool Bar:ehp2.
:p.
The Tool Bar can be hidden from view for those who prefer to use the keyboard equivalents
and want to reclaim the screen real estate taken up by the Push Buttons.  One thing to remember
is that since the Drive Bar moves with the tool bar when it is repositoned from/to
vertical/horizontal, place the drive bar in the orientation you desire before hiding the Tool Bar.
To hide the Tool Bar, press Control+F12 or click on the :hp2.ToolBar:ehp2. menu item under
:hp2.Settings:ehp2..  See :link reftype=hd res=2700.ToolBar:elink. :hp2.Help:ehp2. for more information.
.*...........................................................
:h1 res=1400.Drive Bar
:hp2.Using the Drive Bar:ehp2.
:p.
On start-up, File Freedom creates a Drive Pushbutton for every
drive the system has identified and positions a row of Drive buttons under the
Tool Bar.  A single click will change to the drive indicated.
Drives can also be changed using the Ctrl + Left or Right
arrow keys.
.br
There is also a final button at the right of the row with only an asterisk.  This button calls up
the Bookmark facility.  The Bookmark facility provides a list of up to ten Sub-directory paths
that can be used as short cuts to load your most frequently used directories.  It also allows the
the current directory path to be added to the list.
:p.
The Drive Bar will follow the Tool Bar around if the tool bar
is re-oriented.
.*...........................................................
:h1 res=1500.Status Bars
:hp2.Status Bar Descriptions:ehp2.
:p.
There is a status bar in each of the two main windows and two status bars
along the bottom of the frame.
:p.
The Status Bar in the Tree window indicates the Drive that is current and
displays how many free bytes are on that drive.
:p.
The Status Bar in the Files window shows the path to the files currently
being displayed.
:p.
The first (top) Status Bar along the bottom of the frame indicates how many files
and bytes are in the Source directory currently displayed.  If files are selected,
this information changes to show also how many files have been selected and
what their accumulated byte-count is.  This status bar also displays a mini-help line
for the pushbuttons in the Tool Bar when the mouse pointer is positioned on a
pushbutton.
:p.
The second (bottom) Status Bar along the bottom of the frame displays the current
drive and path of the Destination directory.  If the path is longer than 80 characters,
the path after the drive designator is foreshortened and periods inserted as indicators.
.*............................................................
:h1 res=1600.Directory Tree Window
:hp2.The Tree Display:ehp2.
:p.
The Tree window presents the directories contained on a drive or partition, arranged in
alphabetical order.
:p.
:hp2.Moving Around:ehp2.
:p.
The directory names are displayed beside a folder icon that represents the state of the directory,
open or closed.  The words 'Folder' and 'Directory' will be used interchangably. To move to
directory name that begins with a known letter, simply press that letter and the selection box
will move to the first directory that begins with that letter.  To move to the next directory
name beginning with the same letter, press the letter again. Moving around the window can also
be done by using the mouse and scroll bars or the PageUp, PageDn, Home, End, Arrow Up
and Arrow Down keys.
:p.
:hp2.Opening and Closing a Folder:ehp2.
:p.
Move the selection box to the folder.  To open the folder, press the Enter key or double-click
on it with the mouse pointer.  Opening a folder that is not a descendant of the folder currently
open will close the folder that is open.  Closing a folder will also close any descendant folders
that are open.  When a folder is opened, the contents will be displayed in the Files Window.
A folder can also be closed with a single mouse click.  This will not disturb the display in
the Files Window.
.*...............................................
:h1 res=1700.Files Window
:hp2.The Files Display:ehp2.
:p.
The Files window presents the files and sub-directories contained in a directory, sorted in
alphabetical order from name or extension, or sorted by size or date.  The sorting method can
be changed to any other sort order during the session and the last sorting method
used is saved from session to session.
.br
Sub-directory names can be distinguished from regular files since they end in a backslash
and are coloured blue.
.br
The class of file displayed can also be controlled via
the :hp2.Show Hidden Files:ehp2. and :hp2.Show System Files:ehp2. filters.
.br
There are also four different views of files available, :hp2.File Detail:ehp2., :hp2.Files Icon:ehp2.,
:hp2.Files Flowed:ehp2. and :hp2.Default:ehp2..  With the Files Detail View there is also an option
that allows column headings to be displayed which identify which column is the Date column,
the Size column etc.
:p.
Sorting and the other viewing options are found under the :link reftype=hd res=2400.View:elink.
Menu item.
:p.
:hp2.Moving Around:ehp2.
:p.
Sub-directory names that appear in the Files window are followed by a backslash.
These sub-directories may be opened by a double-click or by selecting and pressing the Enter key.
To move to a file or directory name that begins with a known letter, simply press that letter
and the selection box will move to the first name that begins with that letter.  To move to the
next name beginning with the same letter, press the letter again. Moving around the window can
also be done by using the mouse and scroll bars or the PageUp, PageDn, Home, End, Arrow Up
and Arrow Down keys.
:p.
:hp2.Selecting Files:ehp2.
:p.
Move the selection box to the file.  Pressing the space bar once will mark the file.  Pressing the
space bar again will unmark the file.  This can also be done with a single click of the mouse on
the file.  Multiple selections can be made in any manner.  See :link reftype=hd res=1800.Mouse Usage:elink.
for a description of the :hp2.Auto Scroll:ehp2. feature.  The :hp2.Grey &plus.:ehp2. key will also
mark or unmark a file (if it is already marked) and advance the selection box to the next file.  Files
can also be marked when a letter search is made by holding down the letter.  Again, if a file is already
marked, it will be unmarked.  Finally, all the files in the Files window may be marked at once by
clicking on the :hp2.Mark All:ehp2. button on the Tool Bar and all files can be unmarked by clicking
on the :hp2.UnMark All:ehp2. button.
:p.
:hp2.Viewing Files:ehp2.
:p.
File Freedom has built in connections that allow file viewers to be attached for various file
formats.  These viewers are external programs that can be activated from within File Freedom
by double-clicking on a file name in the Files window.  The viewers used can be selected
from the :hp2.Settings Notebook:ehp2. under the :link reftype=hd res=2620.Viewers:elink. choice.
Some default viewers are pre-set to take advantage of the viewers that come with the Multimedia
programs in the Bonus Pak.  While there are other freeware viewers that also are quite good, the
pre-set viewers are generally already installed on the system.  If these viewers are not installed,
others may be subsituted or added as desired.  See the section on :hp2.Viewers:ehp2. in the
:link reftype=hd res=2600.Settings Notebook:elink. for instructions on adding or changing viewers.
:p.
:hp2.Running Programs from the Files Window:ehp2.
:p.
Files that have an :hp2.exe:ehp2., :hp2.cmd:ehp2., or :hp2.bat:ehp2. extension can be run
in the same manner that files are viewed.
Double-click on the file or put the cursor over the file and press enter.  Be aware, however, that
not all programs or batch/command files will run simply because they may need a set-up
procedure to be run first, or may need access to other paths that have not been configured.
.br
If it is not desireable to have programs run in this way, this default action can be overridden by
designating a viewer for files that have these extensions.  The viewer could be a do-nothing
:hp2.cmd:ehp2. file or simply a text viewer.
.*..............................................................................
:h1 res=3200.Zip Viewer
:hp2.Using the Built-In Zip Viewer:ehp2.
:p.
Info-Zip's Unzip.exe must be installed to use the Zip Viewer.
See :link reftype=hd res=2640.Archiver:elink. for details.
:p.
If the user selects and presses Enter (or double clicks) on a Zip file, by default the built-in
zip viewer will open a window and display the contents of the archive.  If the archive has
a comment attached, it will automatically be displayed as well in a smaller window within
the main window.  Clicking the mouse anywhere outside of the comment window will cause
the Comment Window to close.  It may also be closed by double-clicking on the titlebar icon.
The display of the contents will include file names, compressed and uncompressed sizes,
method of compression, percentage of compression, date of file creation, time, CRC, individual
file comments (if available), number of files in archive, total uncompressed and compressed bytes
in archive, and percentage of compression for total archive.
The selection bar may be moved to a file of interest and the file extracted to the destination
directory (set in File Freedom) by pressing the spacebar.  By pressing the Enter key or
double-clicking on a file, the file may be viewed with the same viewers that are used elsewhere
in File Freedom.  These viewers are set-up in the :link reftype=hd res=2600.Settings Notebook:elink.
and are tied to the extension of the file being viewed.
There is also an option to force the use of the Zip Viewer
(:link reftype=hd res=2529.Force Zip Viewer:elink.) under the :hp2.Options:ehp2. menu.  This
enables looking inside self-extracting Zip executables whose extension is "exe" and other zip
packages with non-standard file extensions.
:p.
:hp2.Installing a Different Zip Viewer or Shell:ehp2.
:p.
If a different Zip Shell or Viewer is preferred, the default Zip Viewer can be replaced simply by
defining a Viewer for the :hp2.zip:ehp2. extension in the :link reftype=hd res=2620.Viewers:elink.
set-up.  This user-defined viewer will also respond to the Forced Zip Viewer option.
To go back to using the built-in Zip Viewer, just delete the viewer and extension pair previously
defined.
:p.
:hp2.Note:ehp2.
:p.
If the default built-in viewer is used, a zip file found within a zip file may also be viewed
in the same manner.  This ability is limited to two layers of zip files.
:p.:link reftype=hd res=3210.Help for View File:elink.
:p.:link reftype=hd res=3220.Help for Extract to File to Destination:elink.
:p.:link reftype=hd res=3260.Help for Extract to File to Destination with Path:elink.
:p.:link reftype=hd res=3250.Help for Delete File:elink.
:p.:link reftype=hd res=3230.Help for View Zip File Comment:elink.
:p.:link reftype=hd res=3240.Help for Quit:elink.
.*..................................................
:h1 res=3300.Installing Other Viewers/Players
:hp2.Using Third Party Viewers/Players:ehp2.
:p.
Viewers are configured in the :hp2.Settings Notebook:ehp2. on the :hp2.Viewers:ehp2. page.
File Freedom provides links for as many file viewers as desired.  These can be graphics viewers,
WAV players, document viewers or any other kind of specialized file handler that will take a
file name as a command line parameter.  Once installed, they are activated simply by
:hp2.double-clicking:ehp2. or pressing :hp2.Enter:ehp2. on a Filename.
.br
As a added feature, the viewer name can be a Rexx :hp2..cmd:ehp2. file.  This enables the use
of Rexx batch files for setting up more complex viewers.
The file name is passed as a parameter to the Rexx script.
:p.
By default, File Freedom is set to use the OS/2 multimedia viewers for examining graphics
files and sound files.  If the Multimedia package was not installed with Warp, these viewers
will be missing. Some may prefer other, more capable, viewers however.  A very capable and
fast freeware graphic viewer is GBMV written by Andy Key.  It is available on Hobbes
(hobbes.nmsu.edu) as "os2/graphics/gbm.zip".
.br
For viewing text files and file types that haven't been designated, the :hp2.EPM:ehp2. editor
(the Enhanced Editor) running in a read-only mode is the default.  This can be replaced by any
viewer or by other freely available viewers such as "pmview5b.zip" also available on Hobbes.
It is a freeware text viewer from the PC Magazine Utilities collection.
.br
Many other freeware and shareware file viewers can also be found there.
:p.
Note that the default action for :hp2.exe:ehp2., :hp2.cmd:ehp2. or :hp2.bat:ehp2. files is to run
the program when the file is double-clicked on.  If a viewer is specified for files with
these extensions, this default action will be unavailable.
:p.
For more instructions on :hp2.Setting Up Viewers:ehp2., see :link reftype=hd res=2620.Viewers:elink..
.*.................................................
:h1 res=3400.Installing User Programs
:hp2.Creating Links to User-Defined Programs:ehp2.
:p.
It is possible to run external programs from within File Freedom.  Links are provided for up to eight
programs determined by the user, which can be executable programs (OS/2, Windows or PC/DOS
programs) or Rexx :hp2.cmd:ehp2. files.
These User-Defined programs can be handed (optional) command line parameters as well as
(optional) a filename when a file is currently selected.
.br
Each program can also accept a defined working directory.  This makes it simple to set up a
link to a program if it has an object already on the desktop.  Simply copy the settings that are
specified in the settings notebook for that object.
.br
A name which will show up in the :hp2.Options:ehp2. menu can also be specified.
.br
These are entered in the :link reftype=hd res=2650.User:elink. page of the :hp2.Settings Notebook:ehp2..
.*.................................................
:h1 res=3500.PMSeek or User Defined Search Tool
:hp2.The PMSeek Search Tool:ehp2.
:p.
PMSeek is a great program that comes with OS/2 and can be found in the OS2/APPS directory.
It will search for duplicate files or text within files in any drives you select.  It is a great asset
and has many other features I will leave for you to discover.
:p.
:hp2.Using PMSeek:ehp2.
:p.
PMSeek is installed as the default Search Tool so that it can be run from within File Freedom.
.br
There is a Search pushbutton as well as a hot key (Shift F11) and a menu position as
:hp2.Search Tools:ehp2. under :hp2.Options:ehp2..  It is also simple to use.  To search
for duplicate files, highlight a filename and push the
Search Tool Pushbutton.  If PMSeek is used, the program will pop up (complete with it's own
online Help) with areas
indicating drives to search, editor selection (you can directly edit files located) and a listbox
containing files found.  You can also run programs selected from this list of found files.
.br
To search for text within a file, it is not necessary to select a file before calling PMSeek.  Just
summon PMSeek and fill in the :hp2.Text to Search For (if any):ehp2. area.  Then select the drives
to search and file pattern to search under and press :hp2.Enter:ehp2..
:p.
:hp2.Installing a Different Search Tool:ehp2.
:p.
If a different search tool is desired, it can be subsituted by opening the
:link reftype=hd res=2600.Settings Notebook:elink. and
turning to the page labelled :hp2.Search:ehp2..  Edit out PMSeek.exe and insert the pathname of the
program you wish to use, for example :hp2.c&colon.&bsl.utilities&bsl.pmgrep.exe:ehp2..  There is
also an area to
enter parameters that may be required for any particular program.  The file name (if a file is
selected when the search is started) will be handed to the program as a parameter also.
.*.................................................
:h1 res=3600.Directory Bookmarks
:hp2.Navigating with Directory Bookmarks:ehp2.
:p.
Directory Bookmarks will take you directly to a subdirectory on any drive without going through
the process of opening a drive and working through the subdirectory hierarchy.  Up to ten
bookmarks are supported.  To find out more go to :link reftype=hd res=2250.Directory Bookmarks:elink..
.*.................................................
:h1 res=3700.Volume Labels
:hp2.Reading and Writing Volume Labels:ehp2.
:p.
Every logical drive can have a Volume Label.  While some drives may already have a label,
others may not.  To determine if a drive is labelled, move the mouse pointer over the
drive button and the Label will show up on the status line.  If there is no label, the line will
remain blank.
:p.
Volume Labels will be read for all drives except floppies whenever the program is started
and whenever the :hp2.Refresh:ehp2. button is pressed.  The Volume Labels for floppies
will be read whenever a floppy drive is selected or when the Ctrl-Up Arrow is pressed.
:p.
Labels can also be written to drives by pressing Ctrl-Down Arrow or refreshed
by pressing Ctrl-Up Arrow.  See :link reftype=hd res=2330.Refresh Volume Label:elink. or
:link reftype=hd res=2340.Write Volume Label:elink. for more information.
.*.................................................
:h1 res=3800.Refresh Timers
:hp2.Refresh Timers for Network Users:ehp2.
:p.
Users on networks doing file maintenance have the additional problem of drives being taken off-line
as well as drives being put on-line at unscheduled times.  Files and complete directories may also
appear or disappear.
.br
File Freedom now contains two timers which can be enabled by the user, to allow automatic
refreshing of these resources at all times when the file manager is running.
.br
To set-up or activate these timers, open the :link reftype=hd res=2600.Settings Notebook:elink.
and turn to the :link reftype=hd res=2660.Refresh:elink. page.
:p.
:hp2.Single Refresh:ehp2.
.br
A one-time refresh of these resources may also be accomplished by pressing the
:link reftype=hd res=2109.Refresh Display:elink. button or :hp2.Shift-F12:ehp2.
.*.................................................
:h1 res=1800.Mouse Usage
:hp2.Basic Mouse Use:ehp2.
:p.
The mouse is used within File Freedom to operate push buttons on the Tool Bar and Drive Bar,
select files and Menu choices, and drop colors or fonts onto the program window.
.br
A single&minus.click of the first Mouse button selects, while a double&minus.click
acts as the Enter key.
:p.
:hp2.Pop-Up Menu:ehp2.
:p.
A pop-up Menu is activated near the position of the Mouse Pointer any time the second Mouse
button is clicked.  This menu contains all the same options as the main Menu in a cascading
format.
:p.
:hp2.Automatic Scrolling While Selecting:ehp2.
:p.
When making multiple selections/deselections with the mouse in the Files Window, upon reaching
the top or bottom of the visible files list, continue above or below the visible area of the window with the
mouse button held down to automatically scroll the window while selecting/deselecting.
.*..................................................
:h1 res=1900.Colors and Fonts
:hp2.Changing Colors and Fonts:ehp2.
:p.
Colors and fonts can be changed by dragging them from the system :hp2.Font Palette:ehp2. or
:hp2.Mixed/Solid Color Palette:ehp2. and dropping them on various parts of the File Freedom windows.
It would be a good idea to keep the Files window titlebar the same color as the upper Status bar
(Source status bar) to highlight the connection between the Source status information and
the actual Files (source) display.
.*...............................................
:h1 res=2000.Default Settings
:hp2.Restoring the Default Settings:ehp2.
:p.
Sometimes experimentation can lead to a hopeless blend of fonts and colors.  For these instances,
the out-of-the-box default colors and fonts can be restored by running File Freedom with a
:hp2.&minus.d:ehp2. parameter.  This can be done by closing the program and clicking on the File
Freedom icon with the Right mouse button.  This will display the Pop-Up menu for the program
object.  Select :hp2.Settings:ehp2. from the menu and the first screen presented will be for
Program Settings.  In the Optional Parameters field, enter &cdq.&minus.d&cdq. and close the
pop-up menu.  Re&minus.start the program and the fonts and colors will return to
their defaults.  If the &cdq.&minus.d&cdq. parameter is not removed, the program will continue to
re&minus.start with default settings regardless of changes made.
:p.
:hp2.FILEFRDM.INI File:ehp2.
.br
Many other settings for such things as divider line position, viewers, paths for the source and
destination, Editor and User Program settings, are saved each time the program is closed in a
file named :hp2.FileFrdm.ini:ehp2..  If this file is deleted while File Freedom is not running,
these settings will be lost and the program will restart with it's default settings (the INI file
will be recreated) .  File Freedom re-writes the ini file each time it is closed, so deleting it
from within File Freedom will not be effective.
.*.....................................................................
:h1 res=3000.Program and Contact Information
:hp2.File Freedom is Freeware:ehp2.
:p.
File Freedom is distributed electronically as Freeware.  Since there is no fee
associated with use, support will be provided only when time permits.
:p.
Bruce Henry
.br
Red Paint Software
.br
703 Hillview Rd.
.br
Cambridge, ON
.br
Canada N3H 5C2
:p.
My current email address is:
:p.
brhenry@kw.igs.net
:p.
Copyright (C) 1996, 1999  Bruce Henry
.br
FILE FREEDOM IS PROVIDED AS IS AND COMES WITH NO WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED. IN  NO  EVENT  WILL
BRUCE HENRY BE LIABLE FOR ANY DAMAGES RESULTING
FROM THE USE OF THIS SOFTWARE OR FROM THE FREELY AVAILABLE
SOURCE CODE ASSOCIATED WITH SAME.
.*..............................................................................
:h1 res=1100.Menu Help
:hp2.Menu Choices:ehp2.
:p.
Choose a Menu Heading:
:p.:link reftype=hd res=2100.Help for Files:elink.
:p.:link reftype=hd res=2200.Help for Directories:elink.
:p.:link reftype=hd res=2300.Help for Drives:elink.
:p.:link reftype=hd res=2400.Help for View:elink.
:p.:link reftype=hd res=2500.Help for Options:elink.
:p.:link reftype=hd res=2800.Help for Settings:elink.
.*....................................................
:h1 res=1110.Pop-Up Menu Help
:hp2.Menu Choices:ehp2.
:p.
The Pop-Up menu contains the same choices as the Main menu and only differs insofar as it
is summoned with a click of the second Mouse button and will appear close to the
Mouse pointer position in a cascading format.  To familiarize yourself with these menu choices, see
:link reftype=hd res=1100.Menu Help:elink..
.*....................................................
:h2 res=2100.Help for File Menu
:p.:link reftype=hd res=2109.Refresh Display:elink.
:p.:link reftype=hd res=2110.Copy:elink.
:p.:link reftype=hd res=2115.Append:elink.
:p.:link reftype=hd res=2120.Move:elink.
:p.:link reftype=hd res=2130.Delete:elink.
:p.:link reftype=hd res=2140.Rename:elink.
:p.:link reftype=hd res=2150.UnMark All:elink.
:p.:link reftype=hd res=2160.Mark All:elink.
:p.:link reftype=hd res=2170.Change Attributes:elink.
:p.:link reftype=hd res=2180.Quit:elink.
.*..............................................................
:h3 res=2109.Refresh Display
:hp2.Refreshing the Current Display:ehp2.
:p.
When using other programs concurrently with File Freedom, or possibly using an external program
from within File Freedom, the display of files and directories upon returning may
no longer reflect the current reality.  To quickly rebuild the display with current information, use
the :hp2.Refresh Display:ehp2. option.
.br
This also refreshs the Drive Map and rebuilds the drive button bar.
.*..............................................................
:h3 res=2110.Copy
:hp2.Comparing &csq.Copy&csq. Between Systems:ehp2.
:p.
Copying files with OS/2 uses rules different than Dos which mainly concern the possibility
of HPFS formatted partitions and the resultant use of long filenames and filenames with
extra periods and/or embedded spaces.  If your partitions are all FAT type partitions, filenames
are limited to standard 8.3 (eight character name, three character extension) format.
Use of wildcards, however, is still slightly different than Dos.  A single asterisk used as a wildcard
to reference a filename will reference both the name and the extension instead of the name only.
This is why, in the Copy Dialogue box, a single asterisk is presented in the Filename entry field.
Accepting the default asterisk will copy the filename in whole, without changes.  It is possible,
however, to edit the filename and Destination path.
:p.
:hp2.Using Wildcard Characters with HPFS:ehp2.
:p.
Use of wildcard characters with long filenames support in HPFS is slightly different.
Some examples will illustrate the differences best.
:p.
:hp2.Examples&colon.:ehp2.
:p.
When the filename is &odq.longfilename.with.many.dots&cdq.
:p.
&odq.Copy c&colon.&bsl.longfilename.with.many.dots d&colon.&bsl.*&cdq.
.br
                   :hp1.will produce:ehp1.
.br
   &odq.longfilename.with.many.dots&cdq.
:p.
&odq.Copy c&colon.&bsl.longfilename.with.many.dots d&colon.&bsl.*xx&cdq.
.br
                   :hp1.will produce:ehp1.
.br
   &odq.longfilename.with.many.dotsxx&cdq.:
:p.
&odq.Copy c&colon.&bsl.longfilename.with.many.dots d&colon.&bsl.*.*xx&cdq.
.br
                   :hp1.will also produce:ehp1.
.br
   &odq.longfilename.with.many.dotsxx&cdq.
:p.
&odq.Copy c&colon.&bsl.longfilename.with.many.dots d&colon.&bsl.*.xx&cdq.
.br
                   :hp1.will produce:ehp1.
.br
   &odq.longfilename.xx&cdq.
:p.
&odq.Copy c&colon.&bsl.longfilename.with.many.dots d&colon.&bsl.*.*.xx&cdq.
.br
                   :hp1.will produce:ehp1.
.br
   &odq.longfilename.with.xx&cdq.
:p.
&odq.Copy c&colon.&bsl.longfilename.with.many.dots d&colon.&bsl.*.*.??xx.yy&cdq.
.br
                   :hp1.will produce:ehp1.
.br
   &odq.longfilename.with.maxx.yy&cdq.
:p.
:hp2.Copying Files with Drag and Drop:ehp2.
:p.
Using Drag and Drop to copy files is done by selecting the files and/or directory tree structures
with the cursor/spacebar/grey+
or with a mouse single click or swipe.  Dragging the selected files to the Drive Letter Icon (or to
directories in the Directory Tree
window or to directories and general areas within the Files Window) is done with the
right mouse button held down, and dropping them on the target
is done by releasing the button.  The default operation is :hp2.Move:ehp2. but can be changed to
:hp2.Copy:ehp2. by holding down the Control Key.  If the mouse is not over one of the selected
files when the drag is started, the single file under the mouse pointer will be dragged instead.
This enables the user to operate on a single file without selecting it.
.br
The Drag and Drop dialogue is presented when the file(s) is dropped.  All of the options described in
the Copy Dialogue (below) are available, as well as the options to Zip, Unzip, Copy, Append
or Move files.
 A tree structure is shown which allows the user to choose the destination directory.
:p.
:hp2.Copying Files without Drag and Drop:ehp2.
:p.
Selected files and/or directory tree structures will be copied to the directory/drive chosen
as the :hp2.Destination:ehp2..
A destination is chosen for the file movement by moving to the drive
and/or directory desired.  Click on the destination button (or press F7) and the
destination is set.  Then, move to the drive/directory where the file(s)
are stored that must be copied.
Select the files/directories to be copied and press :hp2.Control+c:ehp2. or click on the
:hp2.Copy Files Icon:ehp2..
A Copy Dialogue appears which presents an entry box with the Destination Path entered, and a
Filename entry box with a single asterisk.  Below the entry fields there is a check box
which must be checked if the copy process must overwrite files in the destination directory.
:p.
The Destination Path can be edited should the wrong destination path be selected, and the
Filename can be edited as well, with or without wildcard characters.  If files are to be copied
to the same directory that they are found in, the names :hp2.must:ehp2. be changed, since files
cannot be copied onto themselves (this would be meaningless).
:p.
Press the Enter key twice to copy, or click the mouse on the &odq.OK&cdq. button.
:p.
To cancel the copy operation, click on &odq.Cancel&cdq. or use the tab key to select the Cancel button,
then press Enter.
:p.
:hp2.Creating a Destination Directory on the Fly:ehp2.
:p.
As mentioned above, the Destination path can be edited and a different destination directory
substituted.  This does not have to be a sub-directory that already exists.  If the Destination
directory needs to be created, a message box will pop up and request confirmation that
this is what is desired.  An opportunity exists to cancel the Copy or proceed and create the
Destination directory on the fly.
.br
A few rules must be followed when specifying a new directory name. If any subdirectory names
specified in the path name do not exist, the subdirectory cannot be created.  This is to say that a
new directory can only be added to a path that already exists.  Upon successful creation of the
new directory at the end of the specified path, the files are copied to this new Destination
as they would be normally.
:p.
:hp2.Copying Directory Trees containing Files and/or other Directories:ehp2.
:p.
Copy can also be used to copy complete directory structures that may contain files and various
other sub-directory structures.  These may be selected one-at-a-time from the Tree window or
as groups from the Files window.
 This is a very powerful tool and so when File Freedom encounters a directory marked for
copying, it queries the user for permission to continue with the operation.
If CANCEL is chosen at this time, the other selected files and directories will still be copied
but the directory in question will be skipped.
.*.........................................................
:h3 res=2115.Append
:p.
:hp2.The Append Operation:ehp2.
:p.
The Append operation should be used only with text or ascii files.  When Appending files,
bytes from one file are added or concatenated to an existing or newly created file so that
two or more
files are combined.  This is useful for combining a bunch of separate text files and having them
form a single file that can be later edited or used as a reference.
.br
A target file can be chosen from the list of selected files to be the master or mother file, or
a new or existing filename can be specified.  A default filename (:hp2.FFappend.txt:ehp2.) is
entered as the target file initially, but this can be replaced or edited.
:p.
When the selected files are added to the target file, a separator line is first written to the
current end of the target file
in the form of
.br
:hp2.+-+-+-+-+-filename-+-+-+-+-+:ehp2.
.br
where 'filename' is the
filename of the file being added.  This makes each file that is added to the master file easy to
distinguish or find using a search tool from within an editor.
:p.
:hp2.Deleting Selected Source Files:ehp2.
:p.
There is also a checkbox in the Append window that allows the user to specify that the selected
files are to be deleted when they are appended.  This saves a step in file maintenance and
organization.
:p.
:hp2.Appending Files with Drag and Drop:ehp2.
:p.
Using Drag and Drop to Append files is done by selecting the files with the cursor/spacebar/grey+
or with a mouse single click or swipe.  Dragging the selected files to the Drive Letter Icon (or to
directories in the Directory Tree
window or to directories and general areas within the Files Window)
is done with the right mouse button held down, and dropping them on the target
is done by releasing the button.  The default operation for Drag/Drop is :hp2.Move:ehp2. but
can be changed
by selecting the :hp2.Append:ehp2. button.  If the mouse is not over one of the selected
files when the drag is started, the single file under the mouse pointer will be dragged instead.
This enables the user to operate on a single file without selecting it.
.br
The Drag and Drop dialogue is presented when the file(s) is dropped.  A tree structure is
shown which allows the user to choose the destination directory from the folders.
 The destination directory path may be edited and the :hp2.Append:ehp2. button must be selected.
When this is done, press :hp2.OK:ehp2. and and the Append window will open.  You may then follow
the instructions given below, describing the Append Window.
:p.
:hp2.Appending Files without Drag and Drop:ehp2.
:p.
Appending files is a simple operation with File Freedom.
A destination is chosen for the target or master file by moving to the drive
and/or directory desired.  Click on the destination button (or press F7) and the
destination is set.  Then, move to the drive/directory where the file(s)
are stored that are to be appended.
Simply select the files to Append and press :hp2.Control+p:ehp2. or click on the :hp2.Append Files:ehp2.
button on the Tool Bar.
:p.
:hp2.The Append Window:ehp2.
:p.
A dialogue is presented that displays a scrollable list of the
file names selected.  This is to enable the selection of a target (master) file from the list.
 This is not necessary, however, and an original name or the default name can be used.
Double-click on a file name to make it the target file.  This will remove the file from the list and
make it the Target file.  A file in the destination directory that has
the same file name will have the files appended to it if it exists.  Otherwise a file will be created.
:p.
To cancel the Append operation, click on :hp2.Cancel:ehp2. or use the tab key to select the Cancel
button, then press Enter.
.br
Click on :hp2.Append:ehp2. to complete the operation.
.*.........................................................
:h3 res=2120.Move
:p.
:hp2.Moving Files with Drag and Drop:ehp2.
:p.
Using Drag and Drop to move files is done by selecting the files with the cursor/spacebar/grey+
or with a mouse single click or swipe.  Dragging the selected files to the Drive Letter Icon (or to
directories in the Directory Tree
window or to directories and general areas within the Files Window)
is done with the right mouse button held down, and dropping them on the target
is done by releasing the button.  The default operation is :hp2.Move:ehp2. but can be changed to
:hp2.Copy:ehp2. by holding down the Control Key.  If the mouse is not over one of the selected
files when the drag is started, the single file under the mouse pointer will be dragged instead.
This enables the user to operate on a single file without selecting it.
.br
The Drag and Drop dialogue is presented when the file(s) is dropped.  The option to edit
the destination directory name is presented, as well as the options to Zip, Unzip, Copy, Append
or Move files and the option to overwrite existing files.
.br
A tree structure is shown which allows the user to choose the destination directory.
:p.
:hp2.Moving Files without Drag and Drop:ehp2.
:p.
Moving files is a simple operation with File Freedom.
A destination is chosen for the file movement by moving to the drive
and/or directory desired.  Click on the destination button (or press F7) and the
destination is set.  Then, move to the drive/directory where the file(s)
are stored that must be moved.
Simply select the files to move and press :hp2.Control+m:ehp2. or click on the :hp2.Move Files:ehp2.
button on the Tool Bar.  A dialogue is presented that displays a scrollable list of the
file names selected.  This is to enable last minute removal of files from the list.  Double-click
on a file name to remove it from the list.  Files in the destination directory that have the same
file name will not be overwritten unless the check box below the list has been checked.
:p.
The Move dialogue also presents an entry box with the Destination Path entered.
The Destination Path can be edited should the wrong destination path be selected, and even a
directory that doesn't yet exist can be specified (see below).
:p.
To cancel the Move operation, click on :hp2.Cancel:ehp2. or use the tab key to select the Cancel
button, then press Enter.
.br
Click on :hp2.Move:ehp2. to complete the operation.
:p.
:hp2.Creating a Destination Directory on the Fly:ehp2.
:p.
As mentioned above, the Destination path can be edited and a different destination directory
substituted.  This does not have to be a sub-directory that already exists.  If the Destination
directory needs to be created, a message box will pop up and request confirmation that
this is what is desired.  An opportunity exists to cancel the Move or proceed and create the
Destination directory on the fly.
.br
A few rules must be followed when specifying a new directory name. If any subdirectory names
specified in the path name do not exist, the subdirectory is not created.  That is to say that a
new directory can only be added to a path that already exists.  Upon successful creation of the
new directory at the end of the specified path, the files are moved to this new Destination
as they would be normally.
.*................................
:h3 res=2130.Delete
:p.
:hp2.Deleting Files and Empty Sub-Directories:ehp2.
:p.
Files and Sub-Directories trees can be deleted from the Files Window as multiple selections
while Sub-Directory trees can also be deleted from the Tree Window as a single selection.
Read-only files cannot be deleted by Delete. To delete a read-only file, you must first remove
the file's read-only :link reftype=hd res=2170.Attribute:elink., then delete the file.
.br
As stated above, multiple files can be selected for deletion.  Press the Delete button on the
Tool Bar and the files
will be presented in a list.  To remove a file from the list, double-click on the file name.  Press
&csq.Delete&csq. and the files will be removed.
:p.
If a storage directory for the drive has been defined with the SET DELDIR command, the UNDELETE
command may recover the deleted file.
:p.
:hp2.Deleting Directory Trees containing Files and/or other Directories:ehp2.
:p.
Delete can also be used to delete complete directory structures that may contain files.
This is a very powerful tool and so when File Freedom encounters a directory marked for
deletion that is not empty, it queries the user for permission to continue with the operation.
If CANCEL is chosen at this time, the other selected files and directories will still be deleted
but the directory in question will be skipped.
.br
Proceed with caution!  Be sure that the window that you wish to operate on has the focus
(the colored title bar indicates the window with the focus) and that the Directory named is
indeed the Directory selected in the correct window.
:p.
:hp2.Delete and &csq.ACCESS DENIED&csq.:ehp2.
:p.
A common error message encountered when attempting to delete files or directories is
:hp2.ACCESS DENIED:ehp2..  This message usually means that a file with :hp2.Read-Only:ehp2.
or :hp2.System:ehp2. attributes has been found in one of the directories.  This will cause the
Delete routine to abort.  The file causing the problem will be easily found since it will be the
next file still highlighted or in the next directory still highlighted.  Use the Attributes pushbutton
or press Control+A to change attributes.  See :link reftype=hd res=2170.Change Attributes:elink..
.*.................................
:h3 res=2140.Rename
:hp2.Renaming Files or Directories:ehp2.
:p.
Renaming and the use of wildcards follows all of the rules for :link reftype=hd res=2110.Copying
Files:elink. to another
name.  Only a single file or directory can be renamed at a time.  The original name is presented for
editing or replacing. Be careful when using wildcard characters. The results may not be what
you expected!
.*................................
:h3 res=2150.UnMark All
:hp2.Unmark All Files:ehp2.
:p.
All files that have been selected in the Files window will be unmarked.  The cursor position
will be remembered.
.*.....................................
:h3 res=2160.Mark All
:hp2.Mark All Files:ehp2.
:p.
All files in the Files window will be selected.  The cursor position will be remembered.
.*.....................................
:h3 res=2170.Change Attributes
:hp2.Change File Attributes:ehp2.
:p.
File Attributes include the standard Archive, Read-Only, System and Hidden attributes as well as
Time and Date attributes.  Editing of EAs (Extended Attributes) is not supported at this time.
:p.
A list of the selected files is displayed in a listbox preceeded by their current attributes.
Attributes that aren't set for a file are indicated by a :hp2.-:ehp2..  For instance, if a file has
all of it's attributes set, the attributes would read :hp2.rhsa:ehp2. where:
.br
The letter :hp2.r:ehp2. stands for Read Only
.br
The letter :hp2.h:ehp2. stands for Hidden
.br
The letter :hp2.s:ehp2. stands for System
.br
and
.br
The letter :hp2.a:ehp2. stands for Archive
.br
If only the Read Only and Archive attributes were set, the attributes would appear as
:hp2.r--a:ehp2.
:p.
A list of files can be processed at one time.  Check the appropriate box to set the attribute, leave
the box unchecked to remove an attribute.
:p.
Time is set via Spin Buttons and defaults to the current time and date.  The time in Seconds has
not been included.
:p.
The standard attributes and the Time and Date attributes can be set in one operation or separately.
Press the appropriate pushbutton.  Press the Cancel pushbutton to exit without changes.
.*.....................................
:h3 res=2180.Quit
:hp2.Quiting File Freedom:ehp2.
:p.
Using Quit is the same as a double-click on the Title Bar Icon.  Window position, size, fonts
and colors will be saved for the next use.  The Hot Key for this is Ctrl-Q.
.*..............................................................
:h2 res=2200.Help for Directories
:p.:link reftype=hd res=2210.Create Directory:elink.
:p.:link reftype=hd res=2220.Set Destination:elink.
:p.:link reftype=hd res=2230.Swap Source and Destination:elink.
:p.:link reftype=hd res=2240.Show Directory Tree Size:elink.
:p.:link reftype=hd res=2250.Directory Bookmarks:elink.
.*.....................................
:h3 res=2210.Create Directory
:hp2.Creating a New Directory:ehp2.
:p.
A new Directory will be created in the current Source directory.  You will be prompted for the name
to give the directory.
.*.....................................
:h3 res=2220.Set Destination
:hp2.Setting the Destination Directory:ehp2.
:p.
The Destination Directory is the default destination of any file movement.  The current Destination
Directory is displayed on the lower Status Bar at the bottom of the window.  The startup Destination
and Source Directories can be set in the :link reftype=hd res=2600.Settings Notebook:elink. under
:link reftype=hd res=2610.Paths:elink..
.*.....................................
:h3 res=2230.Swap Source and Destination
:hp2.Swap the Source and Destination Directories:ehp2.
:p.
After a File copy or other file movement operation has completed, choosing this feature will
instantly move you to the target of the operation.  It also makes the current Source Directory the
new Destination Directory.
.*...............................................................
:h3 res=2240.Show Directory Tree Size
:hp2.Show the Size of the Directory Tree:ehp2.
:p.
If a directory is highlighted in the Files View Window, the size (in bytes) of this directory and
all of its subordinate directories will be totalled and displayed in a box.  Because the directory
will be deselected after the size is given, numerous directories can be highlighted and worked
through in order by repeatedly pressing :hp2.Ctrl-s:ehp2. after the size of the preceding tree has
been displayed.
.br
Directories shown in the Tree View Window can also be sized, but only one
directory at a time can be selected.
.*...............................................................
:h3 res=2250.Directory Bookmarks
:hp2.Using Directory Bookmarks:ehp2.
:p.
Directory Bookmarks offer a way to jump to frequently used Directories first without moving through
the directory hierarchy directory by directory.  This can be done with a few mouse clicks by
opening the Bookmark window and double-clicking on the directory path desired.
:p.
:hp2.Opening the Bookmark Window:ehp2.
.br
By pressing :hp2.Ctrl B:ehp2. or the Drive button with the :hp2.&asterisk.:ehp2. symbol, a
window opens that contains a list area that can be filled with up to ten directory paths.
Directory paths are added to this list by first moving to the directory and then, after opening the
Bookmark window, pressing the :hp2.Add Bookmark:ehp2. button.
It is always the current Source directory that is added to the bookmark list.  Once the
list is full, bookmarks
may be replaced by first highlighting the old bookmark and again, pressing the
:hp2.Add Bookmark:ehp2. button to substitute the current Source directory path.
:p.
:hp2.Selecting a Bookmark:ehp2.
.br
To load a Bookmark, open the Bookmark window and move the selection bar to the directory
desired and press the Enter key or double-click on the selection with the mouse.
.*...............................................................
:h2 res=2300.Help for Drives
:p.:link reftype=hd res=2310.Next Drive:elink.
:p.:link reftype=hd res=2320.Previous Drive:elink.
:p.:link reftype=hd res=2330.Refresh Volume Label:elink.
:p.:link reftype=hd res=2340.Write Volume Label:elink.
.*.....................................
:h3 res=2310.Next Drive
:hp2.Changing to the Next Drive:ehp2.
:p.
The Next Drive is the drive to the right of the current drive, in the Drive Bar directly below the
Tool Bar.  If the current drive is the last drive in the table, the Next Drive will be the first drive
in the Drive Bar (wraparound).  The Hot Key for this is Crtl-Right Arrow.
.*.....................................
:h3 res=2320.Previous Drive
:hp2.Changing to the Previous Drive:ehp2.
:p.
The Previous Drive is the drive to the left of the current drive, in the Drive Bar directly below the
Tool Bar.  If the current drive is the first drive in the table, the Previous Drive will be the last drive
in the Drive Bar (wraparound).  The Hot Key for this is Crtl-Left Arrow.
.*.....................................
:h3 res=2330.Refresh Volume Label
:hp2.Checking the Volume Labels for Removable Media:ehp2.
:p.
Some drives, such as floppies, CD Roms or Zip Drives, can have the media exchanged at any time.
 To find
out what the Volume Label is for these exchanged disks, place the mouse pointer on the Drive
Button and press the Ctrl-Up Arrow.  If it has one, the new label will show up on the status line.
If media is absent from the drive, a question mark (:hp2.?:ehp2.) will be displayed.
.*.....................................
:h3 res=2340.Write Volume Label
:hp2.Writing and Modifying Volume Labels:ehp2.
:p.
Anytime it is required to modify an existing Volume Label, or to write a new Volume Label, press
the Ctrl-Down Arrow.  A window will open that contains a drop-down list for Drives and an area to
write the new label.  If a label already exists, it will be displayed also, and allow editing.  This is
also an easy way to get an overview of existing labels, since they are displayed dynamically when
any Drive on the list is highlighted.  Labels are restricted to eleven alphanumeric characters.
Embedded spaces are also supported.
.*............................................................
:h2 res=2400.Help for View
:p.:link reftype=hd res=2405.Display Detail Headings:elink.
:p.:link reftype=hd res=2410.File Details View:elink.
:p.:link reftype=hd res=2415.File Icons View:elink.
:p.:link reftype=hd res=2420.File Flowed View:elink.
:p.:link reftype=hd res=2425.Name View:elink.
:p.:link reftype=hd res=2430.Sort By Name in Ascending Order:elink.
:p.:link reftype=hd res=2431.Sort By Name in Decending Order:elink.
:p.:link reftype=hd res=2435.Sort By Age in Ascending Order:elink.
:p.:link reftype=hd res=2436.Sort By Age in Decending Order:elink.
:p.:link reftype=hd res=2440.Sort By Size in Ascending Order:elink.
:p.:link reftype=hd res=2441.Sort By Size in Decending Order:elink.
:p.:link reftype=hd res=2445.Sort By Extension in Ascending Order:elink.
:p.:link reftype=hd res=2446.Sort By Extension in Decending Order:elink.
:p.:link reftype=hd res=2450.Show Hidden Files:elink.
:p.:link reftype=hd res=2455.Show System Files:elink.
:p.:link reftype=hd res=2460.Move Divider Right:elink.
:p.:link reftype=hd res=2465.Move Divider Left:elink.
.*.....................................
:h3 res=2405.Display Detail Headings
:hp2.Display Detail Column Headings:ehp2.
:p.
When the :link reftype=hd res=2410.File Details View:elink. is chosen, this option will display
column headings over the appropriate columns.  For instance, :hp2.File Name:ehp2., :hp2.File Size:ehp2.,
and so on.
.*.....................................
:h3 res=2410.File Details View
:hp2.Displaying File Details:ehp2.
:p.
Choosing this option displays the File Name, File Size, File Attributes, File Date and File Time
in sequence.  This option can be combined with :link reftype=hd res=2405.Display Detail Headings:elink..
Adjust the display divider to fit all the information in the Files Window.
.*.....................................
:h3 res=2415.File Icons View
:hp2.Display File Icons:ehp2.
:p.
Choosing this option displays the File Name alongside the System designated Icon or Program Icon.
Filename/Icon pairs are displayed in multiple columns that flow across the screen horizontally.
.*.....................................
:h3 res=2420.File Flowed View
:hp2.Display Files in a Flowed View:ehp2.
:p.
This option displays file names only in multiple columns that flow across the screen horizontally.
.*.....................................
:h3 res=2425.Name View
:hp2.Display File Names Only:ehp2.
:p.
The Name View is a simple view of the file names only in a single column.
.*.....................................
:h3 res=2430.Sort By Name in Ascending Order
:hp2.Files Sorted by Name in Ascending Order:ehp2.
:p.
In this view, files are sorted by the first letters in a file name.  The sort order is from
the lowest alphabetical value to the highest.
 The cursor selection box will remember it's position over the current file.
.*.....................................
:h3 res=2431.Sort By Name in Decending Order
:hp2.Files Sorted by Name in Decending Order:ehp2.
:p.
In this view, files are sorted by the first letters in a file name.  The sort order is from
the highest alphabetical value to the lowest.
 The cursor selection box will remember it's position over the current file.
.*.....................................
:h3 res=2435.Sort By Age in Ascending Order
:hp2.Files Sorted by Date in Ascending Order:ehp2.
:p.
In this view, files are sorted by the file date and time.  Files with the oldest date
come first.
 The cursor selection box will remember it's position over the current file.
.*.....................................
:h3 res=2436.Sort By Age in Decending Order
:hp2.Files Sorted by Date in Decending Order:ehp2.
:p.
In this view, files are sorted by the file date and time.  Files with the newest date
come first.
 The cursor selection box will remember it's position over the current file.
.*.....................................
:h3 res=2440.Sort By Size in Ascending Order
:hp2.Files Sorted by Size in Ascending Order:ehp2.
:p.
In this view, files are sorted by file size.  The smallest files are listed first.
 The cursor selection box will remember it's position over the current file.
.*.....................................
:h3 res=2441.Sort By Size in Decending Order
:hp2.Files Sorted by Size in Decending Order:ehp2.
:p.
In this view, files are sorted by file size.  The largest files are listed first.
 The cursor selection box will remember it's position over the current file.
.*.....................................
:h3 res=2445.Sort By Extension in Ascending Order
:hp2.Files Sorted by File Extension in Ascending Order:ehp2.
:p.
In this view, files are sorted by the first letters found in the File Extension.  If the file name does
not have an extension, it will come first in the list.  When many files with the same extension
are found, the sort order within that group is dependant on the last used sort order.
 The cursor selection box will remember it's position over the current file.
.*.....................................
:h3 res=2446.Sort By Extension in Decending Order
:hp2.Files Sorted by File Extension in Decending Order:ehp2.
:p.
In this view, files are sorted by the first letters found in the File Extension.  If the file name does
not have an extension, it will come last in the list.  When many files with the same extension
are found, the sort order within that group is dependant on the last used sort order.
 The cursor selection box will remember it's position over the current file.
.*.....................................
:h3 res=2450.Show Hidden Files
:hp2.Hidden Files Filter:ehp2.
:p.
Hidden files will be displayed if this option is checked.  The check mark is toggled with each
mouse click.  This option can be combined with the :link reftype=hd res=2455.Show System Files:elink.
option.
.*.....................................
:h3 res=2455.Show System Files
:hp2.System Files Filter:ehp2.
:p.
Sytem files will be displayed if this option is checked.  The check mark is toggled with each
mouse click.  This option can be combined with the :link reftype=hd res=2450.Show Hidden Files:elink.
option.
.*.....................................
:h3 res=2460.Move Divider Right
:hp2.Move the Divider Right:ehp2.
:p.
The line that separates the Files Window from the Tree Window can be moved to the right to give
a greater proportion of the available display area to the Tree Window at the expense of the Files
Window.
.*.....................................
:h3 res=2465.Move Divider Left
:hp2.Move the Divider Left:ehp2.
:p.
The line that separates the Files Window from the Tree Window can be moved to the left to give
a greater proportion of the available display area to the Files Window at the expense of the Tree
Window.
.*............................................................
:h2 res=2500.Help for Options
:p.:link reftype=hd res=2510.Print File:elink.
:p.:link reftype=hd res=2520.Edit File:elink.
:p.:link reftype=hd res=2528.Search Tool:elink.
:p.:link reftype=hd res=2529.Force Zip Viewer:elink.
:p.:link reftype=hd res=2530.Zip File:elink.
:p.:link reftype=hd res=2540.Unzip File:elink.
:p.:link reftype=hd res=2545.Unzip to New Dir:elink.
:p.:link reftype=hd res=2550.Test Zip File:elink.
:p.:link reftype=hd res=2560.User Option 1:elink.
:p.:link reftype=hd res=2560.User Option 2:elink.
:p.:link reftype=hd res=2560.User Option 3:elink.
:p.:link reftype=hd res=2560.User Option 4:elink.
:p.:link reftype=hd res=2560.User Option 5:elink.
:p.:link reftype=hd res=2560.User Option 6:elink.
:p.:link reftype=hd res=2560.User Option 7:elink.
:p.:link reftype=hd res=2560.User Option 8:elink.
:p.:link reftype=hd res=2570.Create Desktop Object:elink.
.*.....................................
:h3 res=2510.Print File
:hp2.Print the File:ehp2.
:p.
This is a simple copy file to printer operation that occurs in the background and is not followed
by a form feed. This is good for printing out small snippets of text that may only take a few lines.
For more demanding printing, use :link reftype=hd res=2520.Edit File:elink. which will
(if EPM or other full-featured editors are used) provide formatted output in your choice of fonts.
.*.....................................
:h3 res=2520.Edit File
:hp2.Edit the File:ehp2.
:p.
Plug your favourite editor into the :link reftype=hd res=2630.Editor:elink. setting in
the :hp2.Settings:ehp2. notebook.  The EPM editor, which is available in a 32-bit version now,
is set as the default.  If you do not have EPM (the Enhanced Editor) installed, you're missing out
on a very configurable free editor.
.*.....................................
:h3 res=2528.Search Tool
:hp2.Search for Duplicate Files or Text:ehp2.
:p.
A link is provided for a Search tool to be used which will respond to the pushbutton that depicts
the magnifying glass.  The default is an OS/2 application called :hp2.PMSeek.Exe:ehp2. although
other search
tools can be substituted.  See :link reftype=hd res=3500.PMSeek or User Defined Search Tool:elink..
.br
If a file is selected before calling PMSeek, a search can be made for duplicate files.
Searches can also be made for text in files.
.br
For more information, see the extensive online Help within PMSeek.
.*......................................
:h3 res=2529.Force Zip Viewer
:hp2.Using the Zip Viewer for Files with Extensions other than ZIP:ehp2.
:p.
To force File Freedom to use the Zip Viewer (either built-in or user configured) with a file that
has an extension other than :hp2.zip:ehp2., use this option.  It permits looking inside of self-extracting
:hp2.exe:ehp2. files as well as other Zip compatible files with non-standard file extensions.
.*............................................................
:h3 res=2530.Zip File
:p.
By default, files will be added to the zip file if the file name already exists.  This can be
changed by changing the parameters in the :link reftype=hd res=2640.Archiver:elink. parameters line
in the :hp2.Settings Notebook:ehp2..
:p.
:hp2.Zipping Files with Drag and Drop:ehp2.
:p.
Using Drag and Drop to Zip files is done by selecting the files with the cursor/spacebar/grey+
or with a mouse single click.  Dragging the selected files to the Drive Letter Icon (or to
directories in the Directory Tree
window or to directories and general areas within the Files Window)
is done with the right mouse button held down, and dropping them on the target
is done by releasing the button.  If the mouse is not over one of the selected
files when the drag is started, the single file under the mouse pointer will be dragged instead.
This enables the user to operate on a single file without selecting it.
.br
The Drag and Drop dialogue is presented when the file(s) is dropped.  The option to edit
the destination directory name is presented, as well as the options to Zip, Unzip, Copy or Move
files.
.br
A tree structure is shown which allows the user to choose the directory.
.br
Multiple files can be compressed and added to a zip file at once.  After you have accepted
the Drag Drop selections, you will be prompted for a zip
file name and the compressed zip file will be placed in the Destination directory.
:p.
:hp2.Zipping Files without Drag and Drop:ehp2.
:p.
A destination is chosen for the zip file by moving to the drive
and/or directory desired.  Click on the destination button (or press F7) and the
destination is set.  Then, move to the drive/directory where the file(s)
are stored that must be compressed.
Then, select the file(s).  Pressing :hp2.F2:ehp2. or clicking on the :hp2.Compress Files:ehp2.
button can zip a single file or a group of files.  The
created zip file is deposited in the destination directory.
.br
Multiple files can be compressed and added to a zip file at once.  You will be prompted for a zip
file name and the compressed zip file will be placed in the Destination directory.
:p.
:hp2.Zipping Directory Trees:ehp2.
:p.
Complete directory trees can be zipped by selecting a Directory in the Files Window and pressing
:hp2.F2:ehp2..  Only one directory can be zipped at a time.  If other directories or files are selected,
only the first directory will be chosen and the other files and directories will be ignored.  Again,
you will be prompted for a zip name and the zip file will be placed in the Destination directory.
The tree will be zipped using :hp2.-rS:ehp2. parameters (this archives all files and preserves
pathnames) and the parameters in the Settings Notebook will be ignored.
:p.
:hp2.Zipping Entire Drives:ehp2.
:p.
The entire Source Drive can also be zipped.  To zip the drive, do NOT select any files or sub-directories
and press :hp2.F2:ehp2..  You will prompted for a zip name and then a message box will pop up
and ask you if you want to carry on and zip the complete drive.  If you answer yes, the zip file
containing the contents of the Source Drive will be placed in the Destination directory.
The drive will be zipped using :hp2.-rS:ehp2. parameters (this archives all files and preserves
pathnames) and the parameters in the Settings Notebook will be ignored.
:p.
:hp2.Zip Info:ehp2.
:p.
File compression and archiving are done with Info-Zip's Zip 2.1.  This is a freeware file
compression/decompression set of programs (Zip 2.1 and Unzip 5.2) that produce and read zip files
compatible with the popular zip format. This link requires Version 2.1 or higher.
.br
See the :hp2.Readme:ehp2. file for sources for Info-Zip's latest versions.
.br
The directory holding Zip.Exe must be included in the :hp2.Config.Sys:ehp2. path statement or the
fully qualified path/name (including the drive) must be entered into the :hp2.Program Name:ehp2.
line on the set-up page, or it must be the File Freedom home directory.
.br
Additional parameters can be added in the :link reftype=hd res=2640.Archiver:elink. parameters line
in the :hp2.Settings Notebook:ehp2..
.*.....................................
:h3 res=2540.Unzip File
:hp2.Unzipping Files with Drag and Drop:ehp2.
:p.
Using Drag and Drop to Unzip a file is done by selecting the zip file with the cursor/spacebar/grey+
or with a mouse single click.  Dragging the selected file to the Drive Letter Icon (or to
directories in the Directory Tree
window or to directories and general areas within the Files Window)
is done with the right mouse button held down, and dropping it on the target
is done by releasing the button.  If the mouse is not over the selected
file when the drag is started, the single file under the mouse pointer will be dragged instead.
This enables the user to operate on a single file without selecting it.
.br
The Drag and Drop dialogue is presented when the file is dropped.  The option to edit
the destination directory name is presented, as well as the options to Zip, Unzip, Copy or Move
files.
.br
A tree structure is shown which allows the user to choose the directory.
.br
Once the file is dropped, it will be automatically unzipped to the chosen destination.
:p.
:hp2.UnZipping Files without Drag and Drop:ehp2.
:p.
A destination is chosen for the uncompressed file(s) by moving to the drive
and/or directory desired.  Click on the destination button (or press F7) and the
destination is set.  Then, move to the drive/directory where the file
is stored that must be uncompressed.  Now, select the zip file and
simply press :hp2.F3:ehp2. or click on the :hp2.Uncompress Files:ehp2. button.  The
file will be unzipped to the destination directory.
.br
To Unzip files to a destination directory that is created 'on the fly' and has the same name
as the zip file, see :link reftype=hd res=2545.Unzip to New Dir:elink..
:p.
File de-compression and unarchiving are done with Info-Zip's UnZip 5.2.  This is a freeware file
compression/decompression set of programs (Zip 2.1 and Unzip 5.2) that produce and read zip files
compatible with the popular zip format.  This link requires Version 5.2 or higher.
.br
See the :hp2.Readme:ehp2. file for sources for Info-Zip's latest versions.
.br
The directory holding UnZip.Exe must be included in the :hp2.Config.Sys:ehp2. path statement or
the fully qualified path/name (including the drive) must be entered into the :hp2.Program Name:ehp2.
line on the set-up page, or it must be the File Freedom home directory.
.br
Additional parameters can be added in the :link reftype=hd res=2640.Archiver:elink. parameters line
in the :hp2.Settings Notebook:ehp2..
:p.
.*.....................................
:h3 res=2545.Unzip to New Dir
:hp2.UnZipping Files to a New Directory:ehp2.
:p.
First, select the zip file.
Using this feature is the same as :hp2.Unzip File:ehp2. with an added bonus.  A new directory
with the same name as the zip file is created on-the-fly in the Destination directory and the
files are unzipped into this new directory.  This feature is only available from the :hp2.Options:ehp2.
menu or by pressing :hp2.Shift F3:ehp2..
.br
This feature, combined with the :link reftype=hd res=2570.Create Desktop Object:elink. feature,
make it easy to unzip and evaluate new software.  When evaluation is complete, select the
directory and delete the directory and it's contents with :link reftype=hd res=2130.Delete:elink..
.*.....................................
:h3 res=2550.Test Zip File
:hp2.Testing the Zip File:ehp2.
:p.
Select the file to be tested (for CRC errors) and press :hp2.F4:ehp2..  When the check is complete,
press :hp2.Alt:ehp2., then :hp2.C:ehp2. to close the window.
.br
File de-compression and unarchiving are done with Info-Zip's UnZip 5.2  This is a freeware file
decompression program that reads zip files compatible with the popular
zip format.  This link requires Version 5.2 or higher.
.br
See the :hp2.Readme:ehp2. file for sources for Info-Zip's latest versions.
.br
The directory holding UnZip.Exe must be included in the :hp2.Config.Sys:ehp2. path statement or
the fully qualified path/name (including the drive) must be entered into the :hp2.Program Name:ehp2.
line in the :link reftype=hd res=2640.Archiver:elink. page in the :hp2.Settings Notebook:ehp2.,
or it must be the File Freedom home directory.
The Test Zip File procedure shares this line with the UnZip File procedure.
:p.
The file test examines the CRC value of the files in the selected zip file and displays the results
in a window.  This window is persistent to allow the user to see the results of the test and must
be closed with a double-click on the Title Bar Icon or via the pull down menu.
.*.....................................
:h3 res=2560.User Options
:hp2.User Defined Programs:ehp2.
:p.
A link is provided for eight programs determined by the user, which can be executable programs or
Rexx :hp2.cmd:ehp2. files.  Each User Program will also accept optional command line parameters.
If a file is selected when the User Program is initiated, the command line parameters will be
be passed as a first parameter, and the filename will be passed as a second
parameter.  If a file is not selected the program will still be initiated, but only the optional
parameters will be passed.
.br
If optional parameters are not specified but a file is selected, the filename will become the first
and only parameter passed to the program.
.br
These are entered in the :link reftype=hd res=2650.User:elink. page of the :hp2.Settings Notebook:ehp2..
.*.....................................
:h3 res=2570.Create Desktop Object
:hp2.Creating a Desktop Object the Easy Way:ehp2.
:p.
If you want to create a Desktop Program Object,
just select the program file you want to appear as an object on your Desktop and press
:hp2.Control+F11:ehp2.. This will create a program object on the desktop with a working directory
the same as the program directory.  Some fine tuning may be required in some cases,
but most programs should run as is.
.*..............................................
:h2 res=2800.Help for Settings
:p.:link reftype=hd res=2600.Settings Notebook:elink.
:p.:link reftype=hd res=2700.ToolBar:elink.
.*................................................
:h3 res=2600.Help for the Settings Notebook
:p.
The :hp2.Settings Notebook:ehp2. within File Freedom contains settings for User-Configurable
options.  This is found in the Menu under :hp2.Settings:ehp2. and is different from the settings
notebook for the File Freedom Object found in the Desktop menu for this object.
Once options have been configured, pressing the &odq.Done&cdq. pushbutton below the
Settings Notebook will dismiss the notebook and save any changes made.  It is
the same as double-clicking on the titlebar icon.
.br
For Help on an individual page, choose one of the following:
:p.:link reftype=hd res=2610.Paths:elink.
:p.:link reftype=hd res=2620.Viewers:elink.
:p.:link reftype=hd res=2630.Editor:elink.
:p.:link reftype=hd res=2640.Archiver:elink.
:p.:link reftype=hd res=2650.User:elink.
:p.:link reftype=hd res=2660.Refresh:elink.
:p.:link reftype=hd res=2670.Search:elink.
.*.....................................
:h3 res=2610.Paths
:hp2.Source and Destination Path Settings:ehp2.
:p.
This is where the default paths for the Source and Destination directories can be set.  If these
fields are left blank, File Freedom will start with the directory that the program is found in, as the
Source and Destination directories.
.*.....................................
:h3 res=2620.Viewers
:hp2.File Viewer Settings:ehp2.
:p.
File Freedom provides links for as many file viewers as desired.  Program names, including paths,
may be up to 50 characters long.  If the directories holding these
viewers (including :hp2.cmd:ehp2. files) are located in directories included in the
:hp2.Config.Sys:ehp2. path statement, or they are located in the File Freedom home directory,
paths are not required.
:p.
The default viewers can be edited or deleted except for the viewer associated
with :hp2.<none>:ehp2. which can only be edited.  The use of EPM as a viewer in read-only mode
(browse mode) is designated by entering :hp2.<epm>:ehp2. in the viewer entry field and this is
the default for :hp2.<none>:ehp2.  This prevents accidental editing of the file being viewed.
The viewer for :hp2.<none>:ehp2. is the viewer for all file types (with or without extensions)
that don't have a designated viewer, with the exception of :hp2.exe:ehp2., :hp2.cmd:ehp2. or
:hp2.bat:ehp2. files which will run by default when double-clicked on.
:p.
:hp2.Examples:ehp2.
:p.
To use :hp2.PMView:ehp2. as the viewer instead of :hp2.<epm>:ehp2., simply place the cursor
in the :hp2.Edit Viewer Name:ehp2. entry field and replace :hp2.<epm>:ehp2. with
:hp2.pmview.exe:ehp2..  A path may be included with the viewer name,
eg. :hp2.C&colon.&bsl.graphics&bsl.pmview.exe:ehp2., but the total length of characters used
must not exceed 50.
.br
If the viewer program is already located in a directory that appears in the path statement, or
if it is located in the File Freedom home directory, a path is not required.
.br
To use :hp2.epm:ehp2. in normal editing mode as the viewer, replace :hp2.<epm>:ehp2. with
:hp2.epm.exe:ehp2..
.br
Other default viewers can be edited in the same way.
:p.
File viewers for other file types can also be added.  Click the mouse pointer in the :hp2.Add
extension:ehp2. entry box and type in the file name extension for the file type desired, then press
Enter.  The cursor will move to the :hp2.Edit Viewer Name:ehp2. entry box where the name of
the viewer is then entered.  Be sure to include the program name extension.  The Name and
Path of the Viewer cannot exceed 50 characters.  As a added feature,
the viewer name can be a Rexx :hp2..cmd:ehp2. file.  This enables the use of Rexx batch files.
The file name is passed as a parameter to the Rexx script.
:p.
To delete or edit a viewer, select the viewer by first clicking on the Drop-Down list symbol
under the :hp2.File Extensions:ehp2. heading and then selecting from the list by double-clicking
on the extension. The matching viewer will appear in the :hp2.Edit Viewer Name:ehp2. box. To delete
the pair, press the Delete button.  To change the Viewer, simply edit the viewer name and press
:hp2. Enter:ehp2..
:p.
To restore the default viewers, press the Defaults button.
:p.
:hp2.Note:ehp2.
:p.
To understand the implications of installing your own Zip viewer instead of the built-in viewer,
see :link reftype=hd res=3200.Zip Viewer:elink..
.*.....................................................
:h3 res=2630.Editor
:hp2.Editor Settings:ehp2.
:p.
The name of your favourite PM (or Dos, Windows or non-PM OS/2) editor can be entered here, along
with command-line parameters.
Be sure to include the program name extension.  The directory where the editor program is located
must be the File Freedom home directory, or it must be in the :hp2.Config.Sys:ehp2. path statement
or a fully qualified
:hp2.Drive&colon.&bsl.Path&bsl.Name:ehp2. must be entered as the program name.  The file selected
at the time the editor is invoked will also be handed to the editor as a second parameter.  The
editor can be invoked without selecting a file, however.
.*.....................................
:h3 res=2640.Archiver
:hp2.Archiver Settings:ehp2.
:p.
The Archiver Settings are found on the :hp2.Archiver:ehp2. page of the
:link reftype=hd res=2600.Settings Notebook:elink. which is accessed with :hp2.F12:ehp2.
or found under the menu item :hp2.Settings:ehp2..
.br
The :hp2.Zip.Exe:ehp2. and :hp2.Unzip.Exe:ehp2. program names and parameters are entered here.
Zip.Exe is used by ZIP FILE and Unzip.Exe is used by UNZIP FILE, TEST ZIP FILE and ZIP VIEWER.
If the program names alone are entered, the executables must be in the File Freedom home
directory, or in the path statement as listed
in the :hp2.Config.Sys:ehp2. file or, if the path statement in the Config.Sys file does not contain the
directory where the executables can be located, fully qualified path/names must be entered such as
"H&colon.&bsl.progs&bsl.zip.exe" and "H&colon.&bsl.progs&bsl.unzip.exe".
.br
Info-Zip's :hp2.Zip.Exe 2.1:ehp2. and :hp2.Unzip.Exe 5.2:ehp2. or greater must be used.
:p.
Additional command-line parameters can also be added for Info-Zip's Zip and Unzip
programs.  A common parameter for Zip or Unzip would be :hp2.-j:ehp2. to exclude pathnames, either
on creation (zip.exe) or unzipping (unzip.exe).
.br
The extra parameters added will have no effect on the ZIP VIEWER or on TEST ZIP FILE.
.*.....................................
:h3 res=2650.User
:hp2.User Program Settings:ehp2.
:p.
There are eight pages of User-Defined Program settings.  The small arrows at the bottom of the
page must be used to turn to pages 2 through 8.  Each page contains the settings for one program.
:p.
Enter the program names (including extensions) here as well as (optional) command line parameters
and (optional) a working directory.  You can also give a name to your program which will
be listed in the :hp2.Options:ehp2. menu.  This name can be up to 13 characters long.
.br
The directory where the user programs are located must be in the :hp2.Config.Sys:ehp2.
path statement or a fully qualified :hp2.Drive&colon.&bsl.Path&bsl.Name:ehp2. must be entered as
the program name.
.br
See :link reftype=hd res=3400.Installing User Programs:elink. for more details.
:p.
:hp2.Note:ehp2.
.br
Windows 3.1 programs and PC/DOS programs will be opened as Windowed applications
instead of Full-Screen.
.*..........................................................
:h3 res=2660.Refresh
:hp2.Timed Refresh:ehp2.
:p.
Two separate timers are available to allow automatic refresh of the Directories content and the
Drive Table.  These timers are intended for users on networks who must cope with the
disappearance and reappearance of network drives and files.  Setting the automatic refresh allows
some degree of confidence that the file or drive displayed is still available.
:p.
:hp2.Directories:ehp2.
.br
Check this box to allow a timed refresh of the files and directory tree display.  Time units are
in seconds, with the default set for 30 and a maximum of 600 seconds (ten minutes).
 This information is saved in the File Freedom INI file and initialized at start-up, if set.
.br
If enabled, this feature completely re-reads the contents of the source directory and modifys the
tree display, removing or updateing files and directories that may have been deleted or modified
by others on a network.
.br
If files are marked (selected) for some operation, this :hp2.refresh is temporarily ignored:ehp2. until
the operation has been completed.  This keeps the display coherent until all files are unmarked again.
:p.
:hp2.Drives List:ehp2.
.br
Check this box to allow a timed refresh of the Drives list and the Drive button bar.  Time units are
also in seconds, with a default of 30 and a maximum of 600 seconds (ten minutes).  This
information is also saved in the File Freedom INI file and initialized at start-up, if set.
.br
If enabled, this feature reloads the Drive Map and displays only those drives currently available.
If a network drive has been taken off-line, or a network drive put on-line, the Drive Button Bar
will be changed to reflect the availability of these drives.
.*..........................................................
:h3 res=2670.Search
:hp2.Installing a User-Defined Search Tool:ehp2.
:p.
Although PMSeek is the default search tool, other search tools can be installed instead.  To do this,
edit out :hp2.PMSeek.exe:ehp2. and insert the pathname of the
program you wish to use, for example :hp2.c&colon.&bsl.utilities&bsl.pmgrep.exe:ehp2..  There is
also an area to
enter parameters that may be required for any particular program.  The file name (if a file is
selected when the search is started) will be handed to the program as a parameter also.
.*..........................................................
:h3 res=2700.ToolBar
:hp2.Toolbar Visibility:ehp2.
:p.
If this menu item is checked, it indicates that the ToolBar is visible.  If it is unchecked, the
ToolBar is currently hidden.  To toggle the visible state of the ToolBar, click on this item or
press Control+F12.  See :link reftype=hd res=1300.Tool Bar:elink. for more information.
.*.........................................................
:h2 res=3210.View File
:hp2.Viewing Files in the Zip:ehp2.
:p.
The selection bar may be moved to a file of interest and, by pressing the Enter key or
double-clicking on a file, the file may be viewed with the same viewers that are used elsewhere
in File Freedom.  These viewers are set-up in the :link reftype=hd res=2600.Settings Notebook:elink.
and are tied to the extension of the file being viewed.
.*...............................
:h2 res=3220.Extract File to Destination
:hp2.Extracting Single Files from the Archive:ehp2.
:p.
The selection bar may be moved to a file of interest and the file extracted to the destination
directory (set in File Freedom) by pressing the spacebar.  Using the :hp2.Spacebar:ehp2. alone will
eliminate the path if one was stored for that file within the archive.  To extract a file and
preserve/build the path in the destination directory, see
:link reftype=hd res=3260.Extract Files to Destination with Path:elink.
.*...............................
:h2 res=3260.Extract File to Destination with Path
:hp2.Extracting Single Files from the Archive:ehp2.
:p.
The selection bar may be moved to a file of interest and the file extracted to the destination
directory (set in File Freedom) by pressing the spacebar.  Using the :hp2.Shift + Spacebar:ehp2.
combination will preserve and build the path for the file if one was stored in the archive.  To
extact a file and eliminate the path, see
:link reftype=hd res=3220.Extract File to Destination:elink.
.*...............................
:h2 res=3230.View Zip File Comment
:hp2.Viewing Archive Comments:ehp2.
:p.
There are two kinds of Comments that may be found in a Zip file.
.br
One Comment is attached to the file as a whole and is usually a description of the contents, or
sometimes an advertisement.  This is the Comment that is displayed with this command.  Once
displayed, this comment will disappear with a mouse click anywhere esle on the screen.
.br
The other kind of Comment is attached to individual files within the archive and these are
displayed (if available) at the end of the file description in the main Zip Viewer window.
.*.................................................
:h2 res=3240.Quit
:hp2.Quitting the Zip Viewer:ehp2.
:p.
This command will dismiss the Zip Viewer window and return you to the main File Freedom
window.
.*...............................
:h2 res=3250.Deleting Files from the Archive
:hp2.Deleting Single Files from the Archive:ehp2.
:p.
The selection bar may be moved to a file of interest and the file deleted from the zip
by pressing the :hp2.Del:ehp2. key.
.*................................................
:euserdoc.
