/*
** Module   :PLUGIN.C
** Abstract :Sample external plugin for SafeFire firewall
**
** Copyright (C) Link Guard Solutions
** For conditions of distribution and use, see license in license.txt
**
** Log: Fri  28/11/2003 Created
**
*/
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <process.h>
#include "entries.h"

unsigned long pluginnum = 0;
pDLLlog logging = NULL;

void log(char *fmt, ...)
{
	if (logging)
	{
		char buf[256];
		va_list args;
		va_start (args, fmt);
		vsprintf(buf, fmt, args);
		va_end (args);	
		logging(pluginnum, LOG_INFO, buf);
	}
}

void APIENTRY init(unsigned long pnum, unsigned long *plidx, pDLLlog logfunc)
{
	int pid = getpid();
	pluginnum = pnum;
	logging = logfunc;
	log("init: Pnum = %d, Plidx = %d", pnum, pid);
	if (plidx) *plidx = pid;
}

unsigned long APIENTRY initc(unsigned long plidx)
{
	log("initcomplete: Plidx = %d", plidx);
	return 0;
}

void APIENTRY config(unsigned long plidx, char *var, char *val)
{
	log("config: Plidx = %d var = <%s> val = <%s>", plidx, var, val);
}

unsigned long APIENTRY write(unsigned long plidx, unsigned long source, char *packet, unsigned long psize)
{
	log("write: Plidx = %d Source = %d Psize = %d", plidx, source, psize);
	return PLUGIN_ACTION_CONT;
}

void APIENTRY done(unsigned long plidx)
{
	log("done: Plidx = %d", plidx);
}
