/* crt0 for VAX */
	
/* program stack looks like 
       argc            argument counter (integer)
        argv[0]         program name (pointer)
        argv[1...N]     program args (pointers)
        argv[argc-1]    end of args (integer)
        NULL
        env[0...N]      environment variables (pointers)
        NULL
*/

.text
.align 4

.global __start
__start:
.global _start
_start:
	.word 0x0101

	/* clear the frame pointer */
	movl $0, fp

	movl (sp)+, r4
	movl sp, r3
	/* r4 has argc in it .. add one to get over NULL
	   - move it left shifted 2 into r0 */
	addl3 r4, $1, r0
	ashl $2, r0, r0
	/* add size of args to r3 to get start of environ into r2 */
	addl3 r3, r0, r2

	/* start to load the arguments from the stack */
	/* arguments are on ap stack */
	pushl r2
	pushl r3
	pushl r4

	calls $3, __uClibc_main
	halt
.align 2
